   Declare Function Min(R1 As Single,R2 As Single) As Single
   Declare Function Max(R1 As Single,R2 As Single) As Single
   Declare Function Erf(x As Single) As Single
   Declare Function Erfc(x As Single) As Single
   Declare Function Tanh(x As Single) As Single
   Declare Function Coth(x As Single) As Single
   Declare Function Log10(R As Single) As Single
   Declare Function Bell(xpos As Single, xleft As Single, xright As Single) As Single
   Declare Sub ShellSort1(X() As Single, Isort() As Integer, N As Integer)
   Declare Sub ShellSort3(X() As Single,Y() As Single,Z() As Single,IS() As Integer, N As Integer)  
   Declare Function CC_Count(CIn As String, CDiv As String) As Integer
   Declare Sub CC_Cut(CIn As String,CDiv As String,COut() As String, _
               Byref N as Integer)
   Declare Function ConvTab(Cin As String) As String            
 
   
   Public Function Min(R1 As Single,R2 As Single) As Single
   	Dim Rmin As Single
   	If R1 < R2 Then
   	  Rmin = R1
   	Else
   	  Rmin = R2
   	EndIf
   	Min = Rmin
   End Function

   Public Function Max(R1 As Single,R2 As Single) As Single
   	Dim Rmax As Single
   	If R1 > R2 Then
   	  Rmax = R1
   	Else
   	  Rmax = R2
   	EndIf
   	Max = Rmax
   End Function
   
   Public Function Erf(x As Single) As Single
   /' Sergei Winitzki, 2008: relative accuracy < 1.4E-4 '/
   '  Dim As Single a = 0.147
   '  Const As Single b = 1.27324  ' 4/pi,
   '  Const As Single pi = 3.14159
   '  Dim As Single Result
   '  Result = Sqr(1.E0 - exp(-x^2 * (b + a * x^2) / (1.E0 - a * x^2) ) )
   '  If x < 0 Then Result = - Result
   '  WiErf = Result
     Erf = 1.E0 - Erfc(x)
   End Function

   Public Function Erfc(x As Single) As Single
   /' Complementary error function from numerical recipes '/
     Dim As Double t,z,r
     z = Abs(x)
     t = 1.E0/(1.E0 + 0.5E0 * z)
     r = t*exp(-z*z-1.26551223+t*(1.00002368+t*(0.37409196 _
      +t*(0.09678418+t*(-0.18628806+t*(0.27886807+t*(-1.13520398 _
      +t*(1.48851587+t*(-0.82215223+t*0.17087277)))))))))
     If (x < 0) Then
       Erfc = 2.E0 - r
     Else
       Erfc = r
     Endif
   End Function   
   
   Public Function Tanh(x As Single) As Single
     Dim As Single Result
     If x >= 0 Then
       Result = (1 - exp(-2*x))/(1 + exp(-2*x))
     Else
       Result = (exp(2*x) - 1)/(exp(2*x) + 1)
     EndIf
     Tanh = Result
   End Function

   Public Function Coth(x As Single) As Single
     Dim As Single Result
     If x >= 0 Then
       Result = (1 + exp(-2*x))/(1 - exp(-2*x))
     Else
       Result = (exp(2*x) + 1)/(exp(2*x) - 1)
     EndIf
     Coth = Result
   End Function

   Public Function Log10(R As Single) As Single
     log10 = Log(R) / Log(10)
   End Function
   
   Public Function Bell(xpos As Single, xleft As Single, xright As Single) As Single
   ' Bell-shaped curve, maximum = 1, zero for x < xleft and x > xright
     Dim As Single x,y
     If xpos - xleft > 1.E-3 And xright - xpos > 1.E-3 Then
       x = (xpos - xleft) / (xright - xleft)
       y = (x^2 * (1-x)^2)/0.0625
     Else
       y = 0
     End If    
     Bell = y
   End Function  
  '/ 
 Public Function Pyes(Cin As String,Cdefault As String) As Single
     Dim As String Ctest
     Dim As Integer I,Iout
     Ctest = Cin
     If Cdefault <> "" And Ctest = "" Then
       If Cdefault = "YES" Then Iout = 1
       If Cdefault = "NO" Then Iout = 0
     Else
       If Instr("YES",Ucase(Ctest)) = 1 or Ctest = "1" Then
         Iout = 1
       ElseIf Instr("NO",Ucase(Ctest)) = 1 or Ctest = "0" Then
         Iout = 0
       Else
         Iout = -1
         For I = 1 To 5
           Input "Enter YES or NO: ",Ctest
           If Instr("YES",Ucase(Ctest)) = 1 Then
             Iout = 1
             Exit For
           End If
           If Instr("NO",Ucase(Ctest)) = 1 Then
             Iout = 0
             Exit For
           End If
         Next I 
       End If  
     End If     
     If Iout = -1 Then
       Print "Program is terminated."
       End
     End If
     Pyes = Iout  
   End Function
   
   Public Sub ShellSort1(X() As Single, Isort() As Integer, N As Integer)
     /' Shellsort nach AlgorithmM 201 der CACM '/
     /' gibt in X den umsortierten Vektor zurück '/
     /' Gebrauch: Isort bei Eingabe aufsteigend (1,2,3,4,5 ...,N) '/
     /'           Isort bei Ausgabe umsortiert nach Wert von X '/

        Dim As Integer I,J,K,L,M,IM
        Dim As Single U

        If Ubound(X,1) < N Then Goto LeaveShell

        M = N
   L10: M = M / 2
        If M = 0 Then Goto Leaveshell
        K = N - M
        For J = 1 TO K
          I = J
     L20: IF I < 1 Then Goto L50
          IF X(I+M) >= X(I) Then Goto L50
          U = X(I)
          IM = Isort(I)
          X(I) = X(I+M)
          Isort(I) = Isort(I+M)
          X(I+M) = U
          Isort(I+M) = IM
          I = I - M
          Goto L20
   L50: Next J
        Goto L10
   LeaveShell:
      End Sub

   Public Sub ShellSort3(X() As Single, Y() As Single, Z() As Single, Isort() As Integer, N As Integer)
     /' Shellsort nach AlgorithmM 201 der CACM '/
     /' gibt in X den umsortierten Vektor und '/
     /' in Y und Z je einen weiteren umgeordneten Vektor zurueck '/
     /' Gebrauch: Isort bei Eingabe aufsteigend (1,2,3,4,5 ...) '/
     /'           Isort bei Ausgabe umsortiert nach Wert von X '/

        Dim As Integer I,J,K,L,M,IM
        Dim As Single U,V,W

        If Ubound(X,1) < N Or Ubound(Y,1) < N Or Ubound(Z,1) < N _
          Or Ubound(Isort,1) < N Then Goto LeaveShell

        M = N
   L10: M = M / 2
        If M = 0 Then Goto Leaveshell
        K = N - M
        For J = 1 TO K
          I = J
     L20: IF I < 1 Then Goto L50
          IF X(I+M) >= X(I) Then Goto L50
          U = X(I)
          V = Y(I)
          W = Z(I)
          IM = Isort(I)
          X(I) = X(I+M)
          Y(I) = Y(I+M)
          Z(I) = Z(I+M)
          Isort(I) = Isort(I+M)
          X(I+M) = U
          Y(I+M) = V
          Z(I+M) = W
          Isort(I+M) = IM
          I = I - M
          Goto L20
   L50: Next J
        Goto L10
   LeaveShell:
      End Sub

   Public Function CC_Count(CIn As String, CDiv As String) As Integer
     /' Returns the number of pieces in a string '/
     Dim As Integer I = 0, N
     Dim As String CRest
     CRest = Convtab(Trim(CIn))  ' remove leading and trailing blanks
     N = 0
     If CRest = "" Then
       Return N
     End If
     I = Instr(CRest,CDiv)
     If I = 0 then
        N = 1
        Return N
     Else
        While I > 0
           N = N + 1
           CRest = Mid(CRest,I+Len(CDiv))
           CRest = Trim(CRest)
           I = Instr(CRest,CDiv)
        Wend 
        N = N + 1
        Return N
     End If  
   End Function

   Public Sub CC_Cut(CIn As String, CDiv As String, COut() As String, _
                  ByRef N As Integer) 
     /' Cuts a string into pieces with CDiv as divider '/ 
     /' Special treatment for blank as devider: 
          multiple blanks count as one divider '/              
     Dim As Integer I = 0
     Dim As String CRest
     CRest = Convtab(Trim(CIn))  ' remove leading and trailing blanks
     N = 0
     If CRest = "" Then
       Return
     End If
     I = Instr(CRest,CDiv)
     If I = 0 then
        N = 1
        COut(1) = CIn
        Return
     Else
        While I > 0
           N = N + 1
           If N > Ubound(COut) Then 
             N = N - 1
             Print "<E> Dimension of COut too small in CC_cut(";CIn;")" 
           End if
           COut(N) = Mid(CRest,1,I-1)
           CRest = Mid(CRest,I+Len(CDiv))
           CRest = Trim(CRest)
           I = Instr(CRest,CDiv)
        Wend 
        N = N + 1
        If N > Ubound(COut) Then
           N = N - 1
           Print "<E> Dimension of COut too small in CC_cut(";CIn;")" 
        End if
        COut(N) = CRest
        Return
     End if
   End Sub

   Public Function ConvTab(Cin As String) As String
     Dim As String Cmod
     Cmod = Cin
     Do While Instr(Cmod,Chr(9)) > 0 
       Mid(Cmod,Instr(Cmod,Chr(9))) = " "
     Loop
     Return Cmod
   End Function
