 /' Plot of mass distribution (Plotting.bas) '/

' If I_thread < 2 Then  ' Plotting with multiple GEF jobs does not work (program crashes).
                       ' Therefore, plotting is not allowed for I_thread > 1.
' A condition on B_graphics (that depends on I_thread) is inserted below and 
' in the plotting subroutines in DCLplotting.bas (5.Dec.2018,KHS).
' This makes it possible to calculate chi-square values without uwing graphics.

If I_thread < 2 And B_Print_Chisquare = 0 Then 
  B_graphics = 1
Else
  B_graphics = 0
End If    

' B_graphics = 0     ' Graphics output totally suppressed, but chi-square calculation still performed.                       
           
If B_graphics = 1 Then                       
Scope
   ' set window title
  Dim WinTitle As String
  WinTitle = "GEF "+C_GEF_Version+": Mass yields for Z="+Str(P_Z_CN)+", A="+Str(P_A_CN)
  Select Case Emode
    Case 0
        WinTitle = WinTitle+", E* over Eb = "+Str(P_E_EXC)+" MeV"
    Case 1
        WinTitle = WinTitle+", E* = "+Str(P_E_EXC)+" MeV"
    Case 2
        WinTitle = WinTItle+" (CN), En = "+Str(P_E_EXC)+" MeV"
  End Select

' create a window with given resolution and 32-bit colours
'Screenres 500,350,32
  Screenres 500,350,32
  WindowTitle WinTitle

End Scope

' set foreground and background colours
Color RGB(0,0,0), RGB(255,255,255)
' draw background
Cls

Print " "
Print "    nu-bar = ";Round(Nmean,4) '; "Bf = ";B_F;" EB = ";E_B

Dim As Single Xmin, Xmax, Ymin, Ymax
Xmin = 70
Xmax = 180
Xmin = ((Cint(P_A_CN/2.0))\10) * 10 - 50
Xmax = (((Cint(P_A_CN/2.0))\10) + 1) * 10 + 50
'Print Xmin,Xmax
Dim As Single Xtic, Ytic

If P_ylog = 1 Then
  If Nevtused <0.9E6 Then
    Ymin = -2.3
  Else
    Ymin = -3.3
  End If  
  Ymax = 1.3
Else
  Ymin = 0
  Ymax = 14
End If

' write numbers on axes
If P_Ylog = 1 Then
  If ymin > -2.4 And ymin < -2.2 Then
    Draw String (30,40), "10"
    Draw String (38,118), "1"
    Draw String (22,196), "0.1"
    Draw String (14,274), "0.01"
 '   Draw String (6,352), "0.001"
  End If
  If ymin > -3.4 And ymin < -3.2 Then
    Draw String (30,31), "10"
    Draw String (38,92), "1"
    Draw String (22,149), "0.1"
    Draw String (14,214), "0.01"
    Draw String (6,275), "0.001"
  End If 
Else
  Draw String (38,295), "0"
  Draw String (38,255), "2"
  Draw String (38,215), "4"
  Draw String (38,175), "6"
  Draw String (38,135), "8"
  Draw String (30,95), "10"
  Draw String (30,55), "12"
End If 
Ytic = 308 
For I = 20 To 200 Step 20
  If I > Xmin And I < Xmax Then
    Xtic = 3.92 * (110 / (Xmax - Xmin)) * (I - Xmin + 70) - 236.1
    If I < 100 Then Xtic = Xtic + 5
    Draw String (Xtic,Ytic), Trim(Str(I))
  End If  
Next I  
/'  
Draw String (81,308), "80"
Draw String (156,308), "100"
Draw String (234,308), "120"
Draw String (313,308), "140"
Draw String (391,308), "160"
'/
Draw String (200,330), "Post-neutron mass"


' define a viewport (clipping region)
View (50,20) - (480,300), RGB(255,255,150), RGB(0,0,0)

' define new coordinate system on viewport region
Window (Xmin,Ymin) - (Xmax, Ymax)

' Draw grid
' Draw horizontal grid lines:
If P_ylog = 1 Then
  For Ytic = -5 To 5 Step 1
    Line (Xmin,Ytic) - (Xmax,Ytic)
  Next
Else
  For Ytic = 0 To 20 Step 2
    Line (Xmin,Ytic) - (Xmax,Ytic)
  Next
End If
' Draw vertical grid lines:
For Xtic = Xmin + 10 To Xmax - 10 Step 10
 Line (Xtic,Ymin) - (Xtic,Ymax)
Next

' draw a line with red colour
' Line (90,-2) - (100,0), RGB(255,0,0)


' draw mass distribution
'Logcircle (100,0.1)
Scope
Dim As Single Dplus,Dminus
Dim As Ubyte Bdraw
  For I = 20 To 190
    Bdraw = 0
    If P_Ylog = 1 Then
      If APost(I) > 10^Ymin Then Bdraw = -1
    Else
      If APost(I) > 0 Then Bdraw = -1
    End If  
   	If Bdraw Then
   	  If P_Ylog = 1 Then 
   	    Logcircle (I,APost(I),0.6)
   	  Else
   	    Lincircle (I,APost(I),0.6)
   	  End If  
   	  If d_APost(0,I) > 0 Then
         Dplus = APost(I) + d_APost(0,I)  
         Dminus = APost(I) - d_APost(0,I) 
         If Dminus < 0.1*APost(I) Then Dminus = 0.1 * APost(I)
         If P_Ylog = 1 Then
           Logline3(I,Dplus,I,Dminus)
         Else
           LinLine3(I,Dplus,I,Dminus)
         End If    
      End If      	  
   	End If  
  Next
End Scope

' draw contribution of fission channels
Scope
Dim As Single IFirst
Dim As Ubyte Bdraw
For I = 0 To 6
  IFirst = 0
  For J = 20 To 190
    Bdraw = 0
    If P_Ylog = 1 Then
      If AMPost(I,J) > 10^Ymin Then Bdraw = -1
    Else 
      If AMPOst(I,J) > 0 Then Bdraw = -1
    End If  
    If Bdraw Then
      IFirst = IFirst + 1
      If IFirst = 2 Then
        If P_Ylog = 1 Then
          Logline1(J-1,AMpost(I,J-1),J,AMpost(I,J))
        Else
          Linline1(J-1,AMpost(I,J-1),J,AMpost(I,J))
        End If  
      End If
      If IFirst > 2 Then
        If P_Ylog = 1 Then 
          Logline2(J,AMpost(I,J))
        Else
          Linline2(J,AMpost(I,J))
        End If  
      End If
    Else
      IFirst = 0
    End If
  Next
Next
End Scope
End If  ' If B_graphics

Chilin = 0
Chilog = 0
ChiGEFlin = 0
ChiGEFlog = 0
' Dim As Single Chilin,Chilog,ChiGEFlin,ChiGEFlog
' Spontaneous fission
If EMODE = 1 And P_E_EXC = 0 Then
  If P_A_CN = 252 And P_Z_CN = 98 Then
    Restore CF252S
    Ploteval("CF252S","ENDF B VII")
    Restore CF252S
    Chisqr_Apost("CF252S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 250 And P_Z_CN = 98 Then
    Restore CF250S
    Ploteval("CF250S","ENDF B VII")
    Restore CF250S
    Chisqr_Apost("CF250S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 244 And P_Z_CN = 96 Then
    Restore CM244S
    Ploteval("CM244S","ENDF B VII")
    Restore CM244S
    Chisqr_Apost("CM244S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 246 And P_Z_CN = 96 Then
    Restore CM246S
    Ploteval("CM246S","ENDF B VII")
    Restore CM246S
    Chisqr_Apost("CM246S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 248 And P_Z_CN = 96 Then
    Restore CM248S
    Ploteval("CM248S","ENDF B VII")
    Restore CM248S
    Chisqr_Apost("CM248S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 253 And P_Z_CN = 99 Then
    Restore ES253S
    Ploteval("ES253S","ENDF B VII")
    Restore ES253S
    Chisqr_Apost("ES253S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 254 And P_Z_CN = 100 Then
    Restore FM254S
    Ploteval("FM254S","ENDF B VII")
    Restore FM254S
    Chisqr_Apost("FM254S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If  
  If P_A_CN = 256 And P_Z_CN = 100 Then
    Restore FM256S
    Ploteval("FM256S","ENDF B VII")
    Restore FM256S
    Chisqr_Apost("FM256S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If  
  If P_A_CN = 238 And P_Z_CN = 92 Then
    Restore U238S
    Ploteval("U238S","ENDF B VII")
    Restore U238S
    Chisqr_Apost("U238S",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF B VII")
  End If  
End If

' Thermal-neutron-induced fission
If EMODE = 2 And (P_E_EXC >= 0 And P_E_EXC <= 0.05) Then
  If P_A_CN = 242 And P_Z_CN = 95 Then
    If IENDFall = 0 Then
      Restore AM241T
      Ploteval("AM241T","ENDF B VII")
      Restore AM241T
      Chisqr_Apost("AM241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore AM241TJEFF311
      Ploteval("AM241T","JEFF 3.1.1")
      Restore AM241TJEFF311
      Chisqr_Apost("AM241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore AM241TJEFF33
      Ploteval("AM241T","JEFF 3.3")
      Restore AM241TJEFF33
      Chisqr_Apost("AM241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 243 And P_Z_CN = 95 Then
    If IENDFall = 0 Then
      Restore AM242T
      Ploteval("AM242T","ENDF B VII")
      Restore AM242T
      Chisqr_Apost("AM242T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore AM242MTJEFF311
      Ploteval("AM242mT","JEFF 3.1.1")
      Restore AM242MTJEFF311
      Chisqr_Apost("AM242mT",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
  End If
  If P_A_CN = 244 And P_Z_CN = 95 Then
    If IENDFall = 1 Then
      Restore AM243TJEFF311
      Ploteval("AM243T","JEFF 3.1.1")
      Restore AM243TJEFF311
      Chisqr_Apost("AM243T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore AM243TJEFF33
      Ploteval("AM243T","JEFF 3.3")
      Restore AM243TJEFF33
      Chisqr_Apost("AM243T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If
  If P_A_CN = 250 And P_Z_CN = 98 Then
    If IENDFall = 0 Then
      Restore CF249T
      Ploteval("CF249T","ENDF B VII")
      Restore CF249T
      Chisqr_Apost("CF249T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 3 Then
      Restore CF249TLOHENGRIN
      Ploteval("CF249T","LOHENGRIN")
      Restore CF249TLOHENGRIN
      Chisqr_Apost("CF249T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")    
    End If 
  End If
  If P_A_CN = 252 And P_Z_CN = 98 Then
    If IENDFall = 0 Then
      Restore CF251T
      Ploteval("CF251T","ENDF B VII")
      Restore CF251T
      Chisqr_Apost("CF251T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 3 Then
      Restore CF251TLOHENGRIN
      Ploteval("CF251T","LOHENGRIN")
      Restore CF251TLOHENGRIN
      Chisqr_Apost("CF251T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")
    End If
  End If
  If P_A_CN = 244 And P_Z_CN = 96 Then
    IF IENDFall = 0 Then
      Restore CM243T
      Ploteval("CM243T","ENDF B VII")
      Restore CM243T
      Chisqr_Apost("CM243T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
    If IENDFall = 1 Then
      Restore CM243TJEFF311
      Ploteval("CM243T","JEFF 3.1.1")
      Restore CM243TJEFF311
      Chisqr_Apost("CM243T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore CM243TJEFF33
      Ploteval("CM243T","JEFF 3.3")
      Restore CM243TJEFF33
      Chisqr_Apost("CM243T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 245 And P_Z_CN = 96 Then
    If IENDFall = 1 Then
      Restore CM244TJEFF311
      Ploteval("CM244T","JEFF 3.1.1")
      Restore CM244TJEFF311
      Chisqr_Apost("CM244T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrinTChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore CM244TJEFF33
      Ploteval("CM244T","JEFF 3.3")
      Restore CM244TJEFF33
      Chisqr_Apost("CM244T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrinTChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 246 And P_Z_CN = 96 Then
    If IENDFall = 0 Then
      Restore CM245T
      Ploteval("CM245T","ENDF B VII")
      Restore CM245T
      Chisqr_Apost("CM245T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore CM245TJEFF311
      Ploteval("CM245T","JEFF 3.1.1")
      Restore CM245TJEFF311
      Chisqr_Apost("CM245T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore CM245TJEFF33
      Ploteval("CM245T","JEFF 3.3")
      Restore CM245TJEFF33
      Chisqr_Apost("CM245T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 255 And P_Z_CN = 99 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore ES254T
      Ploteval("ES254T","ENDF B VII")
      Restore ES254T
      Chisqr_Apost("ES254T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 256 And P_Z_CN = 100 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore FM255T
      Ploteval("FM255T","ENDF B VII")
      Restore FM255T
      Chisqr_Apost("FM255T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 238 And P_Z_CN = 93 Then
    IF IENDFall = 0 Then
      Restore NP237T
      Ploteval("NP237T","ENDF B VII")
      Restore NP237T
      Chisqr_Apost("NP237T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore NP237TJEFF311
      Ploteval("NP237T","JEFF 3.1.1")
      Restore NP237TJEFF311
      Chisqr_Apost("NP237T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore NP237TJEFF33
      Ploteval("NP237T","JEFF 3.3")
      Restore NP237TJEFF33
      Chisqr_Apost("NP237T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If  
  If P_A_CN = 239 And P_Z_CN = 93 Then
    IF IENDFall = 1 Then
      Restore NP238TJEFF311
      Ploteval("NP238T","JEFF 3.1.1")
      Restore NP238TJEFF311
      Chisqr_Apost("NP238T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    IF IENDFall = 2 Then
      Restore NP238TJEFF33
      Ploteval("NP238T","JEFF 3.3")
      Restore NP238TJEFF33
      Chisqr_Apost("NP238T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 3 Then   ' LOHENGRIN data
      Restore NP238TLOHENGRIN
      Ploteval("NP238T","LOHENGRIN")
      Restore NP238TLOHENGRIN
      Chisqr_Apost("NP238T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")
    End If
  End If
  If P_A_CN = 239 And P_Z_CN = 94 Then
    If IENDFall = 1 Then
      Restore PU238TJEFF311
      Ploteval("PU238T","JEFF 3.1.1")
      Restore PU238TJEFF311
      Chisqr_Apost("PU238T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore PU238TJEFF33
      Ploteval("PU238T","JEFF 3.3")
      Restore PU238TJEFF33
      Chisqr_Apost("PU238T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If
  If P_A_CN = 240 And P_Z_CN = 94 Then
    IF IENDFall = 0 Then
      Restore PU239T
      Ploteval("PU239T","ENDF B VII")
      Restore PU239T
      Chisqr_Apost("PU239T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
    If IENDFall = 1 Then
      Restore PU239TJEFF311
      Ploteval("PU239T","JEFF 3.1.1")
      Restore PU239TJEFF311
      Chisqr_Apost("PU239T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore PU239TJEFF33
      Ploteval("PU239T","JEFF 3.3")
      Restore PU239TJEFF33
      Chisqr_Apost("PU239T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 3 Then
      Restore PU239TLOHENGRIN
      Ploteval("PU239T","LOHENGRIN")
      Restore PU239TLOHENGRIN
      Chisqr_Apost("PU239T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")
    End If
  End If  
  If P_A_CN = 241 And P_Z_CN = 94 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore PU240T
      Ploteval("PU240T","ENDF B VII")
      Restore PU240T
      Chisqr_Apost("PU240T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If  
  If P_A_CN = 242 And P_Z_CN = 94 Then
    IF IENDFall = 0 Then
      Restore PU241T
      Ploteval("PU241T","ENDF B VII")
      Restore PU241T
      Chisqr_Apost("PU241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore PU241TJEFF311
      Ploteval("PU241T","JEFF 3.1.1")
      Restore PU241TJEFF311
      Chisqr_Apost("PU241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore PU241TJEFF33
      Ploteval("PU241T","JEFF 3.3")
      Restore PU241TJEFF33
      Chisqr_Apost("PU241T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If  
  If P_A_CN = 243 And P_Z_CN = 94 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore PU242T
      Ploteval("PU242T","ENDF B VII")
      Restore PU242T
      Chisqr_Apost("PU242T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If  
  If P_A_CN = 228 And P_Z_CN = 90 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore TH227T
      Ploteval("TH227T","ENDF B VII")
      Restore TH227T
      Chisqr_Apost("TH227T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If  
  If P_A_CN = 230 And P_Z_CN = 90 Then
    IF IENDFall = 0 Then
      Restore TH229T
      Ploteval("TH229T","ENDF B VII")
      Restore TH229T
      Chisqr_Apost("TH229T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 3 Then
      Restore TH229TLOHENGRIN
      Ploteval("TH229T","LOHENGRIN")
      Restore TH229TLOHENGRIN
      Chisqr_Apost("TH229T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")
    End If  
  End If  
  If P_A_CN = 233 And P_Z_CN = 92 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore U232T
      Ploteval("U232T","ENDF B VII")
      Restore U232T
      Chisqr_Apost("U232T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If  
  If P_A_CN = 234 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U233T
      Ploteval("U233T","ENDF B VII")
      Restore U233T
      Chisqr_Apost("U233T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 2 Then
      Restore U233TJEFF33
      Ploteval("U233T","JEFF 3.3")
      Restore U233TJEFF33
      Chisqr_Apost("U233T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 1 Then
      Restore U233TJEFF311
      Ploteval("U233T","JEFF 3.1.1")
      Restore U233TJEFF311
      Chisqr_Apost("U233T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 3 Then
      Restore U233TLOHENGRIN
      Ploteval("U233T","LOHENGRIN")
      Restore U233TLOHENGRIN
      Chisqr_Apost("U233T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")
    End If
  End If  
  If P_A_CN = 236 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U235T
      Ploteval("U235T","ENDF B VII")
      Restore U235T
      Chisqr_Apost("U235T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
    If IENDFall = 1 Then
      Restore U235TJEFF311
      Ploteval("U235T","JEFF 3.1.1")
      Restore U235TJEFF311
      Chisqr_Apost("U235T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF") 
    End If
    If IENDFall = 2 Then  
      Restore U235TJEFF33
      Ploteval("U235T","JEFF 3.3")
      Restore U235TJEFF33
      Chisqr_Apost("U235T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")  
    End If  
    If IENDFall = 3 Then
      Restore U235TLOHENGRIN
      Ploteval("U235T","LOHENGRIN")
      Restore U235TLOHENGRIN
      Chisqr_Apost("U235T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"LOHENGRIN")  
    End If
  End If
  If P_A_CN = 237 And P_Z_CN = 92 Then
    If (B_Print_Chisquare = 1  And IENDFall = 2) Or B_Print_Chisquare = 0 Then
      Restore U236TJEFF33
      Ploteval("U236T","JEFF 3.3")
      Restore U236TJEFF33
      Chisqr_Apost("U236T",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")  
    End If  
  End If
End If

' Fast-neutron-induced fission
If (EMODE = 2 And (P_E_Exc >= 0.4 And P_E_Exc <= 2) ) Or _
   ( EMODE Mod 10 = 3 And Instr(C_Espectrum,"F") > 0 ) Then  ' Distribution of E*
  If P_A_CN = 242 And P_Z_CN = 95 Then
    If IENDFall = 0 Then
      Restore AM241F
      Ploteval("AM241F","ENDF B VII")
      Restore AM241F
      Chisqr_Apost("AM241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore AM241FJEFF311
      Ploteval("AM241F","JEFF 3.1.1")
      Restore AM241FJEFF311
      Chisqr_Apost("AM241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore AM241FJEFF33
      Ploteval("AM241F","JEFF 3.3")
      Restore AM241FJEFF33
      Chisqr_Apost("AM241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If
  If P_A_CN = 243 And P_Z_CN = 95 Then
    If (B_Print_Chisquare = 1  And IENDFall = 1) Or B_Print_Chisquare = 0 Then
      Restore AM242MFJEFF311
      Ploteval("AM243F","JEFF 3.1.1")
      Restore AM243FJEFF33
      Chisqr_Apost("AM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 244 And P_Z_CN = 95 Then
    If IENDFall = 0 Then
      Restore AM243F
      Ploteval("AM243F","ENDF B VII")
      Restore AM243F
      Chisqr_Apost("AM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore AM243FJEFF311
      Ploteval("AM243F","JEFF 3.1.1")
      Restore AM243FJEFF311
      Chisqr_Apost("AM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore AM243FJEFF33
      Ploteval("AM243F","JEFF 3.3")
      Restore AM243FJEFF33
      Chisqr_Apost("AM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 243 And P_Z_CN = 96 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore CM242F
      Ploteval("CM242F","ENDF B VII")
      Restore CM242F
      Chisqr_Apost("CM242F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 244 And P_Z_CN = 96 Then
    IF IENDFall = 0 Then
      Restore CM243F
      Ploteval("CM243F","ENDF B VII")
      Restore CM243F
      Chisqr_Apost("CM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore CM243FJEFF311
      Ploteval("CM243F","JEFF 3.1.1")
      Restore CM243FJEFF311
      Chisqr_Apost("CM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore CM243FJEFF33
      Ploteval("CM243F","JEFF 3.3")
      Restore CM243FJEFF33
      Chisqr_Apost("CM243F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If
  If P_A_CN = 245 And P_Z_CN = 96 Then
    If IENDFall = 0 Then
      Restore CM244F
      Ploteval("CM244F","ENDF B VII")
      Restore CM244F
      Chisqr_Apost("CM244F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore CM244FJEFF311
      Ploteval("CM244F","JEFF 3.1.1")
      Restore CM244FJEFF311
      Chisqr_Apost("CM244F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore CM244FJEFF33
      Ploteval("CM244F","JEFF 3.3")
      Restore CM244FJEFF33
      Chisqr_Apost("CM244F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 246 And P_Z_CN = 96 Then
    If IENDFall = 1 Then
      Restore CM245FJEFF311
      Ploteval("CM245F","JEFF 3.1.1")
      Restore CM245FJEFF311
      Chisqr_Apost("CM245F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore CM245FJEFF33
      Ploteval("CM245F","JEFF 3.3")
      Restore CM245FJEFF33
      Chisqr_Apost("CM245F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If
  If P_A_CN = 247 And P_Z_CN = 96 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore CM246F
      Ploteval("CM246F","ENDF B VII")
      Restore CM246F
      Chisqr_Apost("CM246F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
  End If
  If P_A_CN = 249 And P_Z_CN = 96 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore CM248F
      Ploteval("CM248F","ENDF B VI")
      Restore CM248F
      Chisqr_Apost("CM248F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If  
  If P_A_CN = 238 And P_Z_CN = 93 Then
    If IENDFall = 0 Then
      Restore NP237F
      Ploteval("NP237F","ENDF B VII")
      Restore NP237F
      Chisqr_Apost("NP237F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore NP237FJEFF311
      Ploteval("NP237F","JEFF 3.1.1")
      Restore NP237FJEFF311
      Chisqr_Apost("NP237F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore NP237FJEFF33
      Ploteval("NP237F","JEFF 3.3")
      Restore NP237FJEFF33
      Chisqr_Apost("NP237F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 239 And P_Z_CN = 93 Then
    If IENDFall = 0 Then
      Restore NP238F
      Ploteval("NP238F","ENDF B VII")
      Restore NP238F
      Chisqr_Apost("NP238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore NP238FJEFF311
      Ploteval("NP238F","JEFF 3.1,1")
      Restore NP238FJEFF311
      Chisqr_Apost("NP238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore NP238FJEFF33
      Ploteval("NP238F","JEFF 3.3")
      Restore NP238FJEFF33
      Chisqr_Apost("NP238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If  
  If P_A_CN = 232 And P_Z_CN = 91 Then
    Restore PA231F
    Ploteval("PA231F","ENDF B VII")
    Restore PA231F
    Chisqr_Apost("PA231F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
    PrintChisqr(Chilin,"ENDF")
  End If
  If P_A_CN = 239 And P_Z_CN = 94 Then
    If IENDFall = 0 Then
      Restore PU238F
      Ploteval("PU238F","ENDF B VII")
      Restore PU238F
      Chisqr_Apost("PU238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore PU238FJEFF311
      Ploteval("PU238F","JEFF 3.1.1")
      Restore PU238FJEFF311
      Chisqr_Apost("PU238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore PU238FJEFF33
      Ploteval("PU238F","JEFF 3.3")
      Restore PU238FJEFF33
      Chisqr_Apost("PU238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 240 And P_Z_CN = 94 Then
    IF IENDFall = 0 Then
      Restore PU239F
      Ploteval("PU239F","ENDF B VII")
      Restore PU239F
      Chisqr_Apost("PU239F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore PU239FJEFF311
      Ploteval("PU239F","JEFF 3.1.1")
      Restore PU239FJEFF311
      Chisqr_Apost("PU239F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore PU239FJEFF33
      Ploteval("PU239F","JEFF 3.3")
      Restore PU239FJEFF33
      Chisqr_Apost("PU239F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If       
  If P_A_CN = 241 And P_Z_CN = 94 Then
    If IENDFall = 0 Then
      Restore PU240F
      Ploteval("PU240F","ENDF B VII")
      Restore PU240F
      Chisqr_Apost("PU240F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore PU240FJEFF311
      Ploteval("PU240F","JEFF 3.1.1")
      Restore PU240FJEFF311
      Chisqr_Apost("PU240F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore PU240FJEFF33
      Ploteval("PU240F","JEFF 3.3")
      Restore PU240FJEFF33
      Chisqr_Apost("PU240F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If        
  If P_A_CN = 242 And P_Z_CN = 94 Then
    IF IENDFall = 0 Then
      Restore PU241F
      Ploteval("PU241F","ENDF B VII")
      Restore PU241F
      Chisqr_Apost("PU241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore PU241FJEFF311
      Ploteval("PU241F","JEFF 3.1.1")
      Restore PU241FJEFF311
      Chisqr_Apost("PU241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If 
    If IENDFall = 2 Then
      Restore PU241FJEFF33
      Ploteval("PU241F","JEFF 3.3")
      Restore PU241FJEFF33
      Chisqr_Apost("PU241F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If 
  End If        
  If P_A_CN = 243 And P_Z_CN = 94 Then
    If IENDFall = 0 Then
      Restore PU242F
      Ploteval("PU242F","ENDF B VII")
      Restore PU242F
      Chisqr_Apost("PU242F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 2 Then
      Restore PU242FJEFF33
      Ploteval("PU242F","JEFF 3.3")
      Restore PU242FJEFF33
      Chisqr_Apost("PU242F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If    
  If P_A_CN = 233 And P_Z_CN = 90 Then
    If IENDFall = 0 Then
      Restore TH232F
      Ploteval("TH232F","ENDF B VII")
      Restore TH232F
      Chisqr_Apost("TH232F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore TH232FJEFF311
      Ploteval("TH232F","JEFF 3.1.1")
      Restore TH232FJEFF311
      Chisqr_Apost("TH232F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore TH232FJEFF33
      Ploteval("TH232F","JEFF 3.3")
      Restore TH232FJEFF33
      Chisqr_Apost("TH232F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If      
  If P_A_CN = 234 And P_Z_CN = 92 Then
    IF IENDFall = 0 Then
      Restore U233F
      Ploteval("U233F","ENDF B VII")
      Restore U233F
      Chisqr_Apost("U233F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U233FJEFF311
      Ploteval("U233F","JEFF 3.1.1")
      Restore U233FJEFF311
      Chisqr_Apost("U233F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore U233FJEFF33
      Ploteval("U233F","JEFF 3.3")
      Restore U233FJEFF33
      Chisqr_Apost("U233F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If        
  If P_A_CN = 235 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U234F
      Ploteval("U234F","ENDF B VII")
      Restore U234F
      Chisqr_Apost("U234F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U234FJEFF311
      Ploteval("U234F","JEFF 3.1.1")
      Restore U234FJEFF311
      Chisqr_Apost("U234F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore U234FJEFF33
      Ploteval("U234F","JEFF 3.3")
      Restore U234FJEFF33
      Chisqr_Apost("U234F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If        
  If P_A_CN = 236 And P_Z_CN = 92 Then
    IF IENDFall = 0 Then
      Restore U235F
      Ploteval("U235F","ENDF B VII")
      Restore U235F
      Chisqr_Apost("U235F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U235FJEFF311
      Ploteval("U235F","JEFF 3.1.1")
      Restore U235FJEFF311
      Chisqr_Apost("U235F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore U235FJEFF33
      Ploteval("U235F","JEFF 3.3")
      Restore U235FJEFF33
      Chisqr_Apost("U235F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If       
  If P_A_CN = 237 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U236F
      Ploteval("U236F","ENDF B VII")
      Restore U236F
      Chisqr_Apost("U236F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U236FJEFF311
      Ploteval("U236F","JEFF 3.1.1")
      Restore U236FJEFF311
      Chisqr_Apost("U236F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore U236FJEFF33
      Ploteval("U236F","JEFF 3.3")
      Restore U236FJEFF33
      Chisqr_Apost("U236F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
  End If      
  If P_A_CN = 238 And P_Z_CN = 92 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore U237F
      Ploteval("U237F","ENDF B VII")
      Restore U237F
      Chisqr_Apost("U237F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If     
  If P_A_CN = 239 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U238F
      Ploteval("U238F","ENDF B VII")
      Restore U238F
      Chisqr_Apost("U238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If  
    If IENDFall = 1 Then
      Restore U238FJEFF311
      Ploteval("U238F","JEFF 3.1.1")
      Restore U238FJEFF311
      Chisqr_Apost("U238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If  
    If IENDFall = 2 Then
      Restore U238FJEFF33
      Ploteval("U238F","JEFF 3.3")
      Restore U238FJEFF33
      Chisqr_Apost("U238F",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If      
End If

' HE (14 MeV) -neutron-induced fission
If EMODE = 2 And (P_E_EXC >= 13.5 And P_E_Exc <= 14.5) Then
  If P_A_CN = 233 And P_Z_CN = 90 Then
    If IENDFall = 0 Then
      Restore TH232HE
      Ploteval("TH232HE","ENDF B VII")
      Restore TH232HE
      Chisqr_Apost("TH232HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore TH232HJEFF311
      Ploteval("TH232HE","JEFF 3.1.1")
      Restore TH232HJEFF311
      Chisqr_Apost("TH232HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore TH232HJEFF33
      Ploteval("TH232HE","JEFF 3.3")
      Restore TH232HJEFF33
      Chisqr_Apost("TH232HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 234 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U233HE
      Ploteval("U233HE","ENDF B VII")
      Restore U233HE
      Chisqr_Apost("U233HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U233HJEFF311
      Ploteval("U233HE","JEFF 3.1.1")
      Restore U233HJEFF311
      Chisqr_Apost("U233HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore U233HJEFF33
      Ploteval("U233HE","JEFF 3.3")
      Restore U233HJEFF33
      Chisqr_Apost("U233HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 235 And P_Z_CN = 92 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore U234HE
      Ploteval("U234He","ENDF B VII")
      Restore U234HE
      Chisqr_Apost("U234HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 236 And P_Z_CN = 92 Then
    If IENDFall = 0 Then
      Restore U235HE
      Ploteval("U235HE","ENDF B VII")
      Restore U235HE
      Chisqr_Apost("U235HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 1 Then
      Restore U235HJEFF311
      Ploteval("U235HE","JEFF 3.1.1")
      Restore U235HJEFF311
      Chisqr_Apost("U235HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 2 Then
      Restore U235HJEFF33
      Ploteval("U235HE","JEFF 3.3")
      Restore U235HJEFF33
      Chisqr_Apost("U235HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If 
  If P_A_CN = 237 And P_Z_CN = 92 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore U236HE
      Ploteval("U236HE","ENDF B VII")
      Restore U236HE
      Chisqr_Apost("U236HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 239 And P_Z_CN = 92 Then
    IF IENDFall = 0 Then
      Restore U238HE
      Ploteval("U238HE","ENDF B VII")
      Restore U238HE
      Chisqr_Apost("U238HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
    If IENDFall = 2 Then
      Restore U238HJEFF33
      Ploteval("U238HE","JEFF 3.3")
      Restore U238HJEFF33
      Chisqr_Apost("U238HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
    If IENDFall = 1 Then
      Restore U238HJEFF311
      Ploteval("U238HE","JEFF 3.1.1")
      Restore U238HJEFF311
      Chisqr_Apost("U238HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"JEFF")
    End If
  End If
  If P_A_CN = 238 And P_Z_CN = 93 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore NP237HE
      Ploteval("NP237HE","ENDF B VII")
      Restore NP237HE
      Chisqr_Apost("NP237HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 240 And P_Z_CN = 94 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore PU239HE
      Ploteval("PU239HE","ENDF B VII")
      Restore PU239HE
      Chisqr_Apost("PU239HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 241 And P_Z_CN = 94 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore PU240HE
      Ploteval("PU240HE","ENDF B VII")
      Restore PU240HE
      Chisqr_Apost("PU240HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 243 And P_Z_CN = 94 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore PU242HE
      Ploteval("PU242HE","ENDF B VII")
      Restore PU242HE
      Chisqr_Apost("PU242HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
  If P_A_CN = 242 And P_Z_CN = 95 Then
    If (B_Print_Chisquare = 1  And IENDFall = 0) Or B_Print_Chisquare = 0 Then
      Restore AM241HE
      Ploteval("AM241HE","ENDF B VII")
      Restore AM241HE
      Chisqr_Apost("AM241HE",Chilin,Chilog,ChiGEFlin,ChiGEFlog)
      PrintChisqr(Chilin,"ENDF")
    End If
  End If
End If

If B_graphics = 1 Then
  Locate 45
End If

'End If 'If I_thread < 2

If Chisqr_present < Chisqr_min And Chisqr_present > 0 Then
  Chisqr_min = Chisqr_present
 ' Print "New best fit found, Chi-sqr = ";Chisqr_min
  Fitfile = Freefile
'  Open "tmp\"+Cfileout+".fit" For Append As #Fitfile 
  Open "tmp\"+Csystem+".fit" For Append As #Fitfile 
  Print #Fitfile, "**********************************************"
  Print #Fitfile, " New best fit found on ";
  Print #Fitfile, Format( Rdatetime, "dd.mm.yyyy, hh:mm:ss");"."  
  Print #Fitfile, " Chi-square = ",Chisqr_present
  Print #Fitfile, " "
  Print #Fitfile, " New optimum parameter values:"
  Print #fitfile, "P_DZ_Mean_S1 = ", P_DZ_Mean_S1
  Print #fitfile, "P_DZ_Mean_S2 = ", P_DZ_Mean_S2
  Print #fitfile, "P_DZ_Mean_S3 = ", P_DZ_Mean_S3
  Print #fitfile, "P_DZ_Mean_S4 = ", P_DZ_Mean_S4
  Print #fitfile, "P_Z_Curv_S1 = ", P_Z_Curv_S1
  Print #fitfile, "P_Z_Curv_S2 = ", P_Z_Curv_S2
  Print #fitfile, "S2leftmod = ", S2leftmod
  Print #fitfile, "P_A_Width_S2 = ", P_A_Width_S2
  Print #fitfile, "P_Z_Curv_S3 = ", P_Z_Curv_S3
  Print #fitfile, "P_Z_Curv_S4 = ", P_Z_Curv_S4
  Print #fitfile, "Delta_S0 = ", Delta_S0
  Print #fitfile, "P_Shell_S1 = ", P_Shell_S1
  Print #fitfile, "P_Shell_S2 = ", P_Shell_S2
  Print #fitfile, "P_Shell_S3 = ", P_Shell_S3
  Print #fitfile, "P_Shell_S4 = ", P_Shell_S4
  Print #fitfile, "T_low_S1 = ", T_low_S1
  Print #fitfile, "T_low_S2 = ", T_low_S2
  Print #fitfile, "T_low_S3 = ", T_low_S3
  Print #fitfile, "T_low_S4 = ", T_low_S4
  Print #fitfile, "T_low_SL = ", T_low_SL
  Print #fitfile, "P_att_pol = ", P_att_pol
  Print #fitfile, "P_att_rel = ", P_att_rel
  Print #fitfile, "HOMPOL = ", HOMPOL
  Print #fitfile, "POLARadd =  ", POLARadd
  Print #fitfile, "Jscaling = ", Jscaling
 ' Print #Fitfile, " Set new parameter values as starting values"
 ' Print #Fitfile, " "
  Close #Fitfile
End If

