#define B_plotting

Dim Shared As Integer B_graphics   ' Determines, whether graphics is performed in Plotting.bas

Dim Shared As Single Chilin,Chilog,ChiGEFlin,ChiGEFlog


Dim Shared As Integer IENDFall = 2  ' Data from JEFF 3.3. are taken, when available.
   ' IENDFall = 0: Data from ENDF are taken for comparison, when available.
   ' IENDFall = 1: Data from JEFF 3.1.1 are taken, when available.
   ' IENDFall = 3: LOHENGRIN data are taken, when available.

Dim Shared As Integer P_Ylog = 1

Dim Shared As Single Yield_threshold = 0.01   ' Default: 0.01 (KHS, 5. Dec. 2018)

Dim Shared As Single Chisqr_present
Dim Shared As Single Chisqr_min = 5    
'Dim Shared As Single Chisqr_min = 1.E10     ' The value is only set here when starting GEF.
                                            ' This way, the minimum is memembered over
                                            ' several calculations.
Dim As Integer Fitfile

Declare Sub Logcircle(X As Single, Y As Single, R As Single)
Declare Sub Lincircle(X As Single, Y As Single, R As Single)
Declare Sub Logline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Linline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Logline2(X As Single, Y As Single)
Declare Sub Linline2(X As Single, Y As Single)
Declare Sub Logline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Linline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Logcross(X As Single, Y As Single, DY As Single)
Declare Sub Lincross(X As Single, Y As Single, DY As Single)
Declare Sub Ploteval(CCN As String, Csource As String)

Declare Sub Chisqr_Apost(CCN As String, Byref Chilin As Single, Byref Chilog As Single, _
            Byref ChiGEFlin As Single, Byref ChiGEFlog As Single)
Declare Sub PrintChisqr(Chi As Single, Csource As String)

Sub PrintChisqr(Chi As Single,Csource As String)
  Dim As Integer Xpos = ((Cint(P_A_CN/2.0))\10) * 10 - 50  ' Identical to Xmin in Plotting.bas
  If B_graphics = 1 Then 
    If P_Ylog = 1 Then
      Draw String (Xpos,1.12), "Chi-sqr="+Str(Round(Chi,2))
      Draw String (Xpos,0.96), "(GEF-"+Csource+"," 
      Draw String (Xpos,0.82), " Yields>0.01%)"
    Else
      Draw String (Xpos,13.4), "Chi-sqr="+Str(Round(Chi,2))
      Draw String (Xpos,12.9), "(GEF-"+Csource+"," 
      Draw String (Xpos,12.4), " Yields>0.01%)"
    End If 
  End If   
End Sub

Sub Chisqr_Apost(CCN As String, Byref Chilin As Single, Byref Chilog As Single, _
                 Byref ChiGEFlin As Single, Byref ChiGEFlog As Single)
    Dim As Integer Afirst, Alast, I, N
    Dim As Single Diff,Logdiff 
    Read Afirst
    Read Alast
    Redim As Single VYA(Afirst to Alast)
    Redim As Single VDYA(Afirst to Alast)
    For I = Afirst to Alast
       Read VYA(I)
    Next
    For I = Afirst to Alast
       Read VDYA(I)
    Next    
    
    Chilin = 0
    Chilog = 0
    N = 0
    For I = Afirst to Alast
   '   If I <> 129 And I <> 81 Then 
   '   If I <> 129 Then 
      If Apost(I) > Yield_threshold And VYA(I) > Yield_threshold Then
        Diff = (VYA(I) - Apost(I)) / VDYA(I)
' If Diff^2 > 10 Then Print I,Diff^2        
        Chilin = Chilin + Diff^2
        Logdiff = 0.5 * Log(VYA(I)/Apost(I)) / Log( (VYA(I) + VDYA(I)) / (VYA(I) - VDYA(I)) )
        Chilog = Chilog + Logdiff^2
        N = N + 1
      End If
    Next I
    Chilin = Chilin / N
    Chilog = Chilog / N
    Chisqr_present = Chilin

    ChiGEFlin = 0
    ChiGEFlog = 0
    N = 0
    If B_Error_On = 1 Then  ' Only when errors from GEF are available
      For I = Afirst to Alast
        If Apost(I) > Yield_threshold And VYA(I) > Yield_threshold Then
          Diff = (VYA(I) - Apost(I)) / d_Apost(0,I)
'        If Diff^2 > 10 Then Print I,Diff^2        
          ChiGEFlin = ChiGEFlin + Diff^2
          Logdiff = 0.5 * Log(VYA(I)/Apost(I)) / Log( (VYA(I) + d_Apost(0,I)) / (VYA(I) - d_Apost(0,I)) )
          ChiGEFlog = ChiGEFlog + Logdiff^2
 ' Print "d-GEF", I, diff^2        
          N = N + 1
     '   End If
        End If
      Next I
      ChiGEFlin = ChiGEFlin / N
      ChiGEFlog = ChiGEFlog / N
    End If
End Sub

Sub Ploteval(CCN As String,Csource As String)
  Dim As Integer Xpos = P_A_CN / 2 - 10
  If B_graphics = 1 Then 
    Dim As Integer Afirst, Alast,I
    If P_Ylog = 1 Then
      Draw String (Xpos,1.2), "black: "+Csource+" for "+CCN
    Else
      Draw String (Xpos,13.5), "black: "+Csource+" for "+CCN  
    End If  
    Read Afirst
    Read Alast
    Redim As Single VYA(Afirst to Alast)
    Redim As Single VDYA(Afirst to Alast)
    For I = Afirst to Alast
       Read VYA(I)
    Next
    For I = Afirst to Alast
       Read VDYA(I)
    Next
    For I = Afirst to Alast
      If P_ylog = 1 Then
        Logcross(I,VYA(I),VDYA(I))
      Else
        Lincross(I,VYA(I),VDYA(I))
      End If  
    Next I
  End If 
End Sub



Sub Logcircle(X As Single, Y As Single, R As Single)
   Dim As Single U,V
   U = X
   V = Log10(Y)
   Circle (U,V),R,RGB(255,0,0),,,,F
End Sub

Sub Lincircle(X As Single, Y As Single, R As Single)
    Circle (X,Y),R,RGB(255,0,0),,,,F
End Sub

Sub Logline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,V1,U2,V2
  U1 = X1
  V1 = log10(Y1)
  U2 = X2
  V2 = log10(Y2)
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(0,200,0)
End Sub

Sub Linline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,U2,V1,V2
  U1 = X1
  V1 = Y1
  U2 = X2
  V2 = Y2
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(0,200,0)
End Sub

Sub Logline2(X As Single, Y As Single)
  Dim As Single U,V
  U = X
  V = log10(Y)
  Line - (U,V), RGB(0,200,0)
End Sub

Sub Linline2(X As Single, Y As Single)
  Dim As Single U
  U = X
  Line - (U,Y), RGB(0,200,0)
End Sub

Sub Logline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,V1,U2,V2
  U1 = X1
  V1 = log10(Y1)
  U2 = X2
  V2 = log10(Y2)
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(255,0,0)
End Sub

Sub Linline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,V1,U2,V2
  U1 = X1
  V1 = Y1
  U2 = X2
  V2 = Y2
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(255,0,0)
End Sub

Public Sub Logcross(X As Single, Y As Single, DY As Single)
  Dim As Single U,V,V1,V2
  U = X
  V = Log10(Y)
  V1 = Log10(Y-DY)
  V2 = Log10(Y+DY)
  Line (U-0.2,V) - (U+0.2,V)
  Line (U,V1) - (U,V2)
  Line (U-0.2,V1) - (U+0.2,V1)
  Line (U-0.2,V2) - (U+0.2,V2)
End Sub

Public Sub Lincross(X As Single, Y As Single, DY As Single)
  Dim As Single U,V,V1,V2
  U = X
  V = Y
  V1 = Y-DY
  V2 = Y+DY
  Line (U-0.2,V) - (U+0.2,V)
  Line (U,V1) - (U,V2)
  Line (U-0.2,V1) - (U+0.2,V1)
  Line (U-0.2,V2) - (U+0.2,V2)
End Sub



' Mass Yields from ENDF-B-VII
AM241F:
Data 66,172, _
 9.336039E-07,1.869247E-06,5.717186E-06,9.346409E-06,2.077514E-05,3.320435E-05, _
1.350146E-04,3.488251E-04,6.852833E-04,0.00134924,0.00364434,0.00872924, _
0.01847976,0.03438661,0.06155361,0.09556881,0.1576288,0.2360813,0.3395863, _
0.5240064,0.6388462,0.8364165,1.266185,1.370898,1.732568,2.128378,2.926356, _
2.779929,3.730787,3.759122,4.742401,4.636908,5.431832,5.412632,5.911688, _
6.104204,6.063275,6.451236,6.017781,5.342086,4.813984,5.1259,4.116734,2.334843, _
2.055456,1.001644,0.7435825,0.2855293,0.1349561,0.1596012,0.1026962,0.09242541, _
0.09242743,0.08729128,0.08729199,0.09361152,0.09916416,0.1144131,0.1255245, _
0.1931942,0.2616076,0.3805572,0.6136156,1.017952,1.867249,4.16841,4.321882, _
5.817628,7.824069,6.50579,7.684681,5.924618,6.673476,6.762042,4.94121,4.718943, _
5.444504,3.891847,3.415312,3.449104,2.917494,2.149325,1.902163,1.570895, _
1.239355,0.9463601,0.8113003,0.6292022,0.4265999,0.3984769,0.262465,0.1456183, _
0.09673206,0.07937501,0.06302162,0.03766816,0.00874109,0.00257132,0.00104072, _
6.173987E-04,2.389473E-04,1.039807E-04,4.157443E-05,1.456574E-05,8.332911E-06, _
4.88461E-06,1.976138E-06, _
 4.026554E-07,7.837776E-07,2.444077E-06,3.975529E-06,7.705555E-06,1.419372E-05, _
5.674955E-05,1.491548E-04,2.824285E-04,5.659563E-04,0.00157483,0.00358291, _
0.00783037,0.0112973,0.02582594,0.0409325,0.05269349,0.09023897,0.1410213, _
0.1834563,0.2128865,0.1911313,0.5357544,0.5922109,0.68152,0.5666519,0.7070948, _
0.8011603,0.9838099,0.7962934,0.850647,1.287584,1.306226,1.237282,1.100263, _
1.37919,1.749941,1.378233,1.34841,1.138452,1.064422,1.147427,0.8695047, _
0.7428108,0.5096846,0.5018353,0.1539204,0.1485328,0.06263833,0.07261511, _
0.04378865,0.03421244,0.03031843,0.0320472,0.03611499,0.03056443,0.02821423, _
0.04247777,0.05426928,0.07588992,0.07145083,0.1628615,0.2210994,0.3999394, _
0.4566998,0.8754598,0.9213845,1.130089,1.033091,0.7845588,1.349736,1.249289, _
1.33504,1.458944,1.146806,0.9996518,1.234266,0.8489662,0.7333804,0.9003844, _
0.7707478,0.5783421,0.458117,0.5442587,0.5362517,0.3977004,0.3444617,0.2695432, _
0.1502058,0.1722583,0.1106105,0.06218928,0.04150917,0.03332577,0.02690021, _
0.01590674,0.00370248,0.00110767,4.363834E-04,2.64959E-04,1.016273E-04, _
4.386126E-05,1.798127E-05,6.121005E-06,2.776838E-06,2.096369E-06,8.293607E-07

AM241HE:
Data 66,172, _
  3.39000E-0004, 7.26000E-0004, 1.16200E-0003, 1.93700E-0003, 3.20000E-0003, _ 
  4.84200E-0003, 8.71600E-0003, 1.35590E-0002, 2.13080E-0002, 2.71180E-0002, _ 
  3.89400E-0002, 5.86630E-0002, 7.74820E-0002, 1.06546E-0001, 1.81000E-0001, _ 
  2.49329E-0001, 3.54041E-0001, 4.64420E-0001, 5.93532E-0001, 7.82329E-0001, _ 
  9.48662E-0001, 1.07670E+0000, 1.21449E+0000, 1.53791E+0000, 1.74114E+0000, _ 
  2.04490E+0000, 2.21702E+0000, 2.42434E+0000, 2.59816E+0000, 3.12482E+0000, _ 
  3.28433E+0000, 3.54513E+0000, 3.93954E+0000, 4.33690E+0000, 4.56686E+0000, _ 
  4.78342E+0000, 4.89180E+0000, 5.04052E+0000, 4.72749E+0000, 4.72953E+0000, _ 
  4.12356E+0000, 3.78403E+0000, 3.51397E+0000, 3.22237E+0000, 2.87692E+0000, _
  2.33210E+0000, 2.42316E+0000, 2.46782E+0000, 1.83811E+0000, 1.72021E+0000, _
  1.54481E+0000, 1.49605E+0000, 1.44702E+0000, 1.44702E+0000, 1.54044E+0000, _
  1.60125E+0000, 1.78852E+0000, 1.90529E+0000, 2.29601E+0000, 2.35216E+0000, _
  3.57801E+0000, 2.32121E+0000, 2.90870E+0000, 3.60408E+0000, 4.59521E+0000, _
  4.47230E+0000, 3.77210E+0000, 4.63100E+0000, 5.28121E+0000, 4.74197E+0000, _ 
  6.21689E+0000, 4.39037E+0000, 4.40492E+0000, 4.07992E+0000, 3.53239E+0000, _ 
  3.24333E+0000, 3.03853E+0000, 2.70422E+0000, 2.52534E+0000, 2.24986E+0000, _ 
  2.02690E+0000, 1.81579E+0000, 1.59082E+0000, 1.30587E+0000, 1.23572E+0000, _ 
  8.97233E-0001, 8.15177E-0001, 6.71613E-0001, 5.30077E-0001, 3.41757E-0001, _ 
  2.73777E-0001, 1.79285E-0001, 1.53996E-0001, 1.33100E-0001, 8.76450E-0002, _ 
  6.07270E-0002, 3.46470E-0002, 2.44620E-0002, 1.74500E-0002, 1.01900E-0002, _ 
  7.13300E-0003, 4.07600E-0003, 2.95600E-0003, 1.93600E-0003, 1.16500E-0003, _ 
  7.74000E-0004, 5.10000E-0004, _ 
 1.367931E-04,2.902673E-04,4.637516E-04,7.791813E-04,0.00118964,0.00193593, _
0.0034884,0.00542559,0.00828353,0.0108181,0.01565451,0.02322333,0.03092193, _
0.03363232,0.07207751,0.09987929,0.1128966,0.1752763,0.2121712,0.2735721, _
0.2992334,0.4283388,0.3950501,0.6246671,0.6698937,0.5399732,0.460044,0.6501846, _
0.6178886,0.6462281,0.8439357,0.8455552,0.9082037,0.915682,0.8027656,1.102409, _
1.24296,1.091734,0.9720274,0.9774228,1.077915,0.7858192,0.7192262,0.950732, _
0.652755,0.6536131,0.6369607,0.5833497,0.7354698,0.6850888,0.6139688,0.5660389, _
0.4642394,0.5127708,0.5764297,0.5405207,0.5269148,0.6700888,0.646605,0.5263084, _
0.7137626,0.4922392,0.6140994,0.8748254,0.9861162,0.8749473,0.7467356,1.124663, _
0.9335964,0.742335,1.3699,0.945604,0.7389416,1.067634,0.6611069,0.8869032, _
0.715032,0.5585732,0.6601674,0.6855149,0.4785568,0.7282296,0.5241969,0.5262061, _
0.4930146,0.3616838,0.2894775,0.2693262,0.1689043,0.1364163,0.07174943, _
0.07126597,0.0617465,0.05366272,0.0359719,0.02446535,0.01284735,0.00978626, _
0.00703554,0.00395455,0.00284549,0.00163869,0.00118002,7.807368E-04, _
3.856696E-04,3.104618E-04,2.05354E-04

AM241T:
Data 66,172, _
 1.360243E-07,2.520755E-07,5.801802E-07,1.261308E-06,4.54781E-06,6.782167E-06, _
9.932398E-06,3.974789E-05,8.934005E-05,2.482862E-04,5.174494E-04,0.00338238, _
0.00714449,0.01193096,0.02179647,0.04372296,0.06408221,0.17715,0.2658498, _
0.3295127,0.4299125,0.6876811,0.7589043,0.9970028,1.387261,1.851301,1.993558, _
2.638958,3.239136,3.991452,4.263665,5.268149,5.855564,6.645345,6.257203, _
5.998321,6.177491,6.229339,6.211661,6.651797,5.95904,5.270939,4.254325,2.494516, _
1.492982,0.9511381,0.5598577,0.1965796,0.14892,0.0511249,0.03979603,0.03188552, _
0.03602295,0.0278567,0.02586836,0.02617948,0.02935217,0.03979312,0.0503765, _
0.08163791,0.1699472,0.5857888,0.9288238,1.362747,2.234195,3.563391,4.775146, _
5.507373,7.233009,7.01174,7.782257,6.523061,6.961637,6.686576,5.937371,4.792054, _
4.714255,3.675428,3.489514,3.315627,2.645705,2.032388,1.828546,1.433124, _
1.148842,0.8394767,0.7225793,0.6023885,0.3770252,0.3077208,0.1911428,0.1642623, _
0.08587178,0.07300621,0.03459359,0.02210235,0.01047251,0.00282762,3.245606E-04, _
1.002326E-04,6.807017E-05,3.035591E-05,1.361656E-05,5.865321E-06,1.677646E-06, _
3.248216E-07,1.04708E-07, _
 5.912357E-08,1.061646E-07,2.484924E-07,5.420406E-07,1.688847E-06,2.921878E-06, _
4.208766E-06,1.696103E-05,3.75818E-05,1.043965E-04,2.238899E-04,0.00140961, _
0.00302238,0.00392374,0.0092015,0.01870903,0.0212798,0.06795313,0.1100175, _
0.1124919,0.1463234,0.2986943,0.3190001,0.327418,0.5647534,0.530812,0.4801231, _
0.5579203,0.8437994,0.7808102,0.8912998,1.552047,1.129068,1.437594,1.188065, _
1.349577,1.791537,1.333856,1.395227,1.419566,1.324475,1.176007,0.9025983, _
0.7951544,0.5667819,0.4646328,0.1177441,0.107129,0.07541166,0.0235273, _
0.01676862,0.0131028,0.01210074,0.01097318,0.01057668,0.00832434,0.00873459, _
0.01394693,0.01971325,0.02939182,0.06241987,0.24578,0.3455482,0.4308642, _
0.6979994,0.8543103,0.7625615,1.144336,1.344189,0.9151649,1.34816,1.428563, _
1.630331,1.227168,1.384165,0.9303932,1.028612,0.8854303,0.6438032,0.8731866, _
0.8999116,0.5939815,0.4437322,0.5245489,0.4960675,0.3601105,0.3044537,0.2617221, _
0.1443421,0.1317379,0.08205546,0.06921222,0.03734234,0.03086416,0.01485244, _
0.0095112,0.00441249,0.00122998,1.370168E-04,4.288129E-05,2.935774E-05, _
1.277633E-05,5.909459E-06,2.496065E-06,5.739475E-07,1.410452E-07,4.406768E-08

AM242T:
Data 66,172, _
 9.569102E-06,1.91832E-05,2.872112E-05,5.736977E-05,9.570941E-05,1.915485E-04, _
4.789683E-04,9.56764E-04,0.0017227,0.00287005,0.00574698,0.00969464,0.01912862, _
0.029328,0.047729,0.06706911,0.1154512,0.2477873,0.3683912,0.4719844,0.5575843, _
0.6570295,0.9033691,1.207024,1.407738,1.753361,2.085452,2.51721,2.772146, _
3.311836,3.630187,4.283653,4.581688,5.37737,5.484429,5.870559,6.65306,7.072553, _
6.936657,6.968434,6.165398,5.38135,4.10886,3.748904,2.425026,1.534716,0.6429886, _
0.251871,0.105254,0.0737428,0.03877904,0.02935305,0.02714522,0.02326777, _
0.02326784,0.01952945,0.03285103,0.04377076,0.0547866,0.1036566,0.1690289, _
0.2667477,0.413414,1.471808,2.005085,3.483857,4.813762,5.981537,6.990434, _
6.657536,6.371241,6.267843,6.007761,5.792052,5.411484,5.245252,4.478864, _
4.643647,4.429078,3.355493,2.880448,2.466796,2.132502,1.720507,1.602408, _
1.218077,1.023991,0.8290941,0.5471941,0.3611097,0.3275484,0.1550524,0.08754189, _
0.05471331,0.03832984,0.02015066,0.01313227,0.00656571,0.00218842,0.00106687, _
5.473353E-04,2.190844E-04,1.094165E-04,8.746442E-05,4.385761E-05,2.188478E-05, _
1.094234E-05, _
 4.138129E-06,8.122294E-06,1.214541E-05,2.476898E-05,3.661989E-05,8.192041E-05, _
2.046738E-04,4.024543E-04,7.325307E-04,0.0012102,0.00244615,0.0041152, _
0.00802055,0.00966721,0.02029442,0.02829945,0.03788783,0.09672474,0.1121742, _
0.1580687,0.1927068,0.2844603,0.3799355,0.3270029,0.2810855,0.6624303,0.5206482, _
0.5396091,0.7506798,0.9091696,0.7379231,1.404609,0.813694,1.183089,1.317769, _
1.247776,1.958295,1.508022,1.667082,1.538323,1.318241,1.27035,0.8693802, _
1.216913,0.5893232,0.4530107,0.1794218,0.1362447,0.05214076,0.03335473, _
0.01642142,0.01165484,0.00902316,0.00920485,0.00930241,0.0061867,0.01012133, _
0.01554596,0.02070053,0.03605596,0.06032139,0.111004,0.1513699,0.5801585, _
0.4973591,0.6580591,0.9054977,1.07447,1.370137,0.9694761,1.129816,1.334429, _
1.346851,0.8850885,1.036626,1.142517,0.9525918,1.207513,0.9453836,0.9209052, _
0.9606428,0.7568182,0.5225229,0.7231929,0.687293,0.520479,0.4300764,0.3587147, _
0.2063763,0.1546025,0.1403561,0.06514281,0.03786263,0.02311251,0.01628293, _
0.00869351,0.00550268,0.00282532,9.331697E-04,4.489346E-04,2.366187E-04, _
9.229536E-05,4.665843E-05,3.76321E-05,1.580712E-05,9.444964E-06,4.64756E-06

AM243F:
Data 66,172, _
 4.994798E-07,8.980136E-07,2.195758E-06,4.988585E-06,1.596369E-05,2.497895E-05, _
4.986638E-05,1.198703E-04,2.793001E-04,6.991128E-04,0.00129896,0.00289639, _
0.0049835,0.0189369,0.03869149,0.06502194,0.1003342,0.1695981,0.2240353, _
0.3869358,0.4888933,0.6582032,0.8561518,1.133709,1.401968,1.75348,2.09025, _
2.507704,3.202585,3.756762,4.462137,4.681954,5.058695,5.425409,5.450852, _
5.924725,5.994454,5.90462,5.972828,5.883152,5.627293,5.245328,4.93496,3.777303, _
2.818814,1.747796,0.9288284,0.4214111,0.2196077,0.10199,0.09982221,0.0999111, _
0.09487946,0.08988563,0.08489266,0.0848425,0.09472895,0.09967197,0.1196798, _
0.129834,0.2308296,0.349317,0.5679274,0.9473178,1.737105,3.194985,4.72238, _
5.619345,6.218049,6.779684,7.265587,7.29714,6.637085,5.97495,5.483855,4.953151, _
5.234495,5.210595,4.155845,3.418163,2.895627,2.336131,1.865061,1.556962, _
1.233111,0.9667911,0.7973523,0.5880487,0.4188332,0.308975,0.2192721,0.1495037, _
0.09568205,0.05780713,0.03497162,0.01993307,0.00847979,0.0032421,0.00139501, _
5.979501E-04,2.991276E-04,9.964292E-05,5.574359E-05,2.389803E-05,1.296659E-05, _
3.486302E-06,1.793856E-06, _
 2.098453E-07,3.738008E-07,9.058904E-07,2.101369E-06,6.151343E-06,1.038354E-05, _
2.089499E-05,4.940057E-05,1.157318E-04,2.905333E-04,5.381755E-04,0.00120546, _
0.00205576,0.00621669,0.0161902,0.02678508,0.03246688,0.06719609,0.08546603, _
0.1257134,0.1726773,0.2771583,0.3542311,0.4722137,0.5693444,0.7240856,0.5446538, _
0.5243893,0.8592495,0.811558,0.903455,1.402761,0.903335,1.185985,1.300356, _
1.245512,1.704159,1.246361,1.428322,1.313977,1.177824,1.196005,1.050812, _
1.041521,0.6720318,0.7213257,0.3562901,0.2243475,0.1047688,0.04597764, _
0.04749425,0.04142374,0.03542007,0.03723427,0.02968399,0.02689441,0.03184305, _
0.0358233,0.04398761,0.04430649,0.07960399,0.1464155,0.2182293,0.3828497, _
0.5106712,0.7402899,0.8326489,1.116471,1.186498,1.442333,1.279802,1.548162, _
1.481176,1.250415,1.231581,1.065092,1.112792,1.190156,0.8696042,0.8984315, _
0.7861137,0.6556057,0.4452415,0.6418847,0.5190196,0.3998842,0.3294546,0.2463597, _
0.1474365,0.129987,0.09096218,0.0620015,0.0402588,0.0238347,0.01463872, _
0.00833031,0.00349104,0.00136463,5.778638E-04,2.479229E-04,1.257698E-04, _
4.106055E-05,2.337371E-05,9.971873E-06,4.473783E-06,1.467681E-06,7.419537E-07

CF249T:
Data 66,172, _
 3.003711E-07,5.006862E-07,3.001629E-06,5.705404E-06,3.061365E-05,5.356459E-05, _
1.091285E-04,2.139405E-04,5.331218E-04,9.556817E-04,0.00191282,0.00461926, _
0.00816801,0.01844498,0.03022183,0.04804157,0.07574046,0.1298104,0.1837724, _
0.2562576,0.329949,0.4171037,0.5212514,0.4613465,0.5922664,0.8292551,0.8858405, _
1.064568,1.208309,1.507812,1.682469,2.088115,2.305209,2.811734,3.238175, _
3.685313,4.21311,4.926131,5.082934,5.44169,5.618004,5.697193,5.723218,5.576734, _
5.416336,5.499272,4.924504,4.164576,3.623452,2.985791,2.199522,1.830526, _
1.021181,0.6093925,0.385231,0.2063622,0.1802393,0.1681902,0.1374027,0.20708, _
0.4459797,0.5888668,0.7834367,1.629839,1.973786,3.167518,4.158757,5.248341, _
5.386357,5.42013,5.585406,5.764215,5.400658,6.118531,5.322448,5.431498,4.386586, _
4.707764,4.316968,3.538978,3.350847,2.855884,2.254474,2.054087,1.754701, _
1.604402,1.255628,1.21002,0.8926584,0.6159741,0.6767283,0.4212156,0.3809579, _
0.3640027,0.2329119,0.1930784,0.1106548,0.06684857,0.04346443,0.02802512, _
0.0166884,0.00739125,0.004182,0.00168689,8.625747E-04,4.807653E-04,3.628193E-04, _
 1.256456E-07,2.010193E-07,1.17644E-06,2.313277E-06,1.028346E-05,2.006631E-05, _
4.649075E-05,8.581698E-05,1.916307E-04,3.897506E-04,7.494459E-04,0.00172038, _
0.00353846,0.00622684,0.01181042,0.01939708,0.02748741,0.04590305,0.07486394, _
0.0931105,0.1038169,0.1689338,0.2139677,0.05657693,0.2618589,0.2947531, _
0.2689668,0.2413461,0.1335184,0.6068602,0.5040016,0.5390328,0.5346191,0.7278829, _
0.7649684,0.8087729,1.123401,1.014,0.8834642,1.114234,0.8204774,1.610814, _
0.7601222,1.580012,1.223582,1.478487,0.8299668,0.8475805,0.8956689,0.7076311, _
0.7391495,0.6008421,0.324735,0.2564378,0.133942,0.06371876,0.06658583, _
0.05899325,0.04828017,0.0646299,0.1320803,0.1845054,0.2328036,0.2698674, _
0.4471242,0.292944,0.9559557,0.8723215,0.570244,0.5356607,1.200148,0.923519, _
0.5633889,0.4434766,0.9047555,1.114284,0.4931272,0.9764078,0.6956371,0.9407566, _
0.6944659,0.7526776,0.5330865,0.5681198,0.6801263,0.564366,0.5342041,0.4843033, _
0.267748,0.2531948,0.2730379,0.1694036,0.1625698,0.146873,0.08961044,0.07814758, _
0.04659131,0.02683364,0.01775803,0.01141397,0.00646946,0.00296314,0.00180738, _
6.756124E-04,2.978387E-04,1.978422E-04,1.438293E-04

CF250S:
Data 66,172, _
 0.00196615,0.00245632,0.00294824,0.00373506,0.00491775,0.00589556,0.00786074, _
0.0098761,0.01277393,0.01670449,0.01971823,0.02554881,0.03242241,0.04224609, _
0.05007086,0.06884274,0.08966316,0.09651542,0.152685,0.2302323,0.2819488, _
0.2827927,0.3402722,0.4822281,0.5222281,0.567634,0.7662197,0.9293291,1.155429, _
1.488561,1.535321,1.584069,2.467251,3.293937,3.571799,4.009032,4.95656,5.303432, _
6.46393,6.603721,6.8265,7.270499,6.938935,6.330976,5.951902,4.931723,4.095244, _
3.510694,2.46961,2.04965,1.191454,0.4938775,0.196536,0.11792,0.05896202, _
0.02703685,0.01965422,0.01867195,0.01879598,0.02128694,0.04394548,0.1131014, _
0.2149163,0.3967714,0.8801178,1.704766,2.459653,3.903873,4.152461,4.643878, _
4.844939,5.548065,5.772315,6.202791,5.248627,5.849675,6.531487,5.573484, _
4.743872,4.949665,4.449477,3.814537,3.458615,3.258961,2.367303,2.071819, _
1.574102,1.215125,0.8366962,0.6839758,0.508096,0.4103847,0.3419904,0.2540469, _
0.215611,0.1661092,0.1270232,0.107482,0.07817739,0.06296358,0.05080833, _
0.04006073,0.03224379,0.02442742,0.02053994,0.01563433,0.01270283, _
 8.218645E-04,0.00102585,0.00127546,0.00159975,0.00178932,0.00242906,0.00326353, _
0.00427147,0.00532016,0.0069388,0.00826116,0.01019124,0.01384412,0.01394843, _
0.02095474,0.02861803,0.02984319,0.03629924,0.06466914,0.078968,0.09396257, _
0.118175,0.1420874,0.2099369,0.2148844,0.2027034,0.3338879,0.3863832,0.501913, _
0.6401013,0.6021128,0.5118428,0.6382179,0.8737267,0.8588406,0.8496737,1.472587, _
1.118043,1.561835,1.431517,1.476582,1.582917,1.486177,1.978335,1.021164, _
1.203859,0.7465827,0.8999149,0.7206341,0.6781093,0.3912045,0.1590939,0.09842748, _
0.0460711,0.0323702,0.01014733,0.00920844,0.00654556,0.00854689,0.00828794, _
0.02362636,0.04813457,0.08184222,0.1557944,0.2655152,0.3994171,0.5538676, _
0.9128084,0.9326591,0.5948446,0.8542868,1.201,1.377656,1.011636,1.183393, _
1.262478,1.405177,1.32498,1.010857,1.082472,1.262888,0.8136957,0.851807, _
0.6916294,0.6304237,0.5101469,0.6752505,0.5232625,0.2920727,0.2866995,0.2109972, _
0.1770635,0.1484522,0.1057025,0.09029258,0.06900376,0.05399079,0.04697686, _
0.03274814,0.02617034,0.02117092,0.01686413,0.01411502,0.01035311,0.00690276, _
0.00654072,0.00530054

CF251T:
Data 66,172, _
 9.36462E-05,1.402798E-04,1.870748E-04,2.805956E-04,3.743884E-04,4.670657E-04, _
6.546534E-04,9.54031E-04,0.00121544,0.00177752,0.0023419,0.00334023,0.0046756, _
0.00580125,0.00838442,0.0112484,0.01556399,0.0219316,0.02478673,0.04647774, _
0.05482078,0.07295516,0.09952007,0.1456241,0.3052025,0.5225232,0.576362, _
0.6766315,0.7665803,0.9832444,1.439073,1.654316,2.178323,3.312057,3.392419, _
3.871336,4.258333,4.355141,4.538045,4.859633,4.938149,5.226309,5.322145, _
5.223392,5.231263,5.01925,5.335353,4.457916,4.51012,4.56034,3.628636,2.903504, _
1.908816,1.24073,0.7635244,0.4973397,0.2806291,0.1964442,0.1874684,0.3810635, _
0.5065498,0.6090494,0.7092431,0.929301,1.217092,1.841922,3.218643,3.909097, _
4.821788,4.444305,5.438124,5.858964,5.817217,5.711905,4.515359,4.922872, _
5.444064,5.090281,5.052107,4.964054,4.243541,3.5144,3.342784,3.023977,2.425657, _
2.019556,1.520583,1.216441,0.9123958,0.713521,0.5665537,0.4077218,0.3057907, _
0.2038623,0.1529471,0.10193,0.08154389,0.06115697,0.04077223,0.03041057, _
0.02038476,0.01528941,0.01019362,0.00815484,0.0061168,0.00407702,0.00305756, _
 3.959567E-05,5.861065E-05,7.763712E-05,1.188713E-04,1.430645E-04,1.953824E-04, _
2.755154E-04,3.949648E-04,5.068757E-04,7.412573E-04,9.761658E-04,0.00139577, _
0.0019359,0.00190653,0.00352571,0.00465695,0.00504822,0.0086922,0.00955941, _
0.01510853,0.01992946,0.03076244,0.04175678,0.06044665,0.1272539,0.2164346, _
0.2426885,0.2845116,0.3181229,0.4162741,0.5751468,0.5444789,0.7183512,0.6988866, _
0.820514,0.8124442,1.267121,0.930619,1.09405,1.107152,1.036326,1.182757, _
1.140797,1.432118,1.218382,1.048395,1.221359,0.9509181,0.9724358,1.090061, _
0.9505748,0.9181741,0.6580197,0.4553134,0.2876903,0.1905978,0.1402162, _
0.08869949,0.07295021,0.09924924,0.2432098,0.2481093,0.2741814,0.3796765, _
0.3613583,0.4326335,0.7772729,0.7771003,1.108218,0.8154654,1.008865,1.243586, _
1.23712,1.257253,0.8059392,1.281538,1.147922,1.120755,1.105457,1.052192, _
1.376538,0.7382318,0.8686931,0.8441914,0.7264267,0.5261574,0.6297199,0.511578, _
0.3655268,0.2956596,0.2400338,0.1696048,0.127846,0.08614065,0.06328953, _
0.04307435,0.03410484,0.02542822,0.01727443,0.0126011,0.00857303,0.00642927, _
0.00422548,0.00345576,0.00229262,0.00171225,0.00128734

CF252S:
Data 66,172, _
 5.262687E-08,1.441292E-07,3.841434E-07,9.897542E-07,2.390601E-06,6.024517E-06, _
1.407967E-05,3.215305E-05,7.06125E-05,1.517718E-04,3.16804E-04,6.251268E-04, _
0.00205871,0.0034301,0.00471483,0.00834997,0.01526263,0.04128581,0.05236121, _
0.121811,0.1217306,0.2075462,0.3057492,0.3593313,0.5428675,0.5994906,0.6773663, _
0.8814922,1.110424,1.249544,1.603506,1.673742,2.274331,2.651276,3.454928, _
3.933855,4.037408,5.44624,5.634628,6.230864,6.315719,6.618042,6.107254,5.93681, _
5.908461,5.187494,4.135383,4.782717,3.328342,2.897137,2.127236,1.500616, _
0.9938431,0.3841373,0.2389561,0.1175209,0.08845277,0.04088571,0.02543123, _
0.01768514,0.02769515,0.1056024,0.1933433,0.5888286,0.8471598,1.599793,2.152569, _
3.149263,3.8761,4.196888,4.078383,5.094625,5.580282,5.884069,5.962063,5.969938, _
6.016572,6.249428,5.896524,5.068393,4.437222,4.280533,3.943121,2.721639, _
2.445108,1.948856,1.721655,1.292896,1.067242,0.7928709,0.6766843,0.5378041, _
0.4696063,0.3402292,0.2857973,0.1936918,0.1195685,0.07583834,0.04720734, _
0.0286444,0.01839537,0.00956695,0.00525068,0.00166788,0.0013978,7.085066E-04, _
3.458179E-04, _
 2.15982E-08,5.932498E-08,1.573339E-07,4.17262E-07,9.999403E-07,2.481559E-06, _
5.786052E-06,1.318011E-05,2.9407E-05,6.519347E-05,1.315835E-04,2.553682E-04, _
8.451924E-04,0.00118452,0.0020244,0.00349711,0.00510116,0.01650477,0.0191778, _
0.03974627,0.04733116,0.08504505,0.1251927,0.1477539,0.2305159,0.2494548, _
0.2734893,0.3649364,0.3839409,0.4056953,0.6556036,0.5611195,0.7325136,0.5539885, _
0.864943,0.8477387,1.035948,1.119886,1.18608,1.12812,1.343438,1.441797, _
0.7548285,1.500069,1.799041,1.076651,0.8236179,0.8519913,0.8988629,0.7100517, _
0.7550102,0.5056659,0.3293556,0.1478005,0.1061291,0.04591818,0.05344425, _
0.02160715,0.00853127,0.00489548,0.01188073,0.048261,0.07951291,0.2278827, _
0.2652918,0.349046,0.6639906,0.6381173,0.5876034,0.7330344,1.01045,0.7047647, _
0.3957649,0.3938511,0.4258256,0.4126396,0.8070248,1.16565,0.9023937,1.06613, _
1.137919,0.7845723,1.013428,0.6540556,0.7338439,0.7949703,0.695415,0.419918, _
0.3695605,0.3279001,0.1263049,0.1827682,0.1882695,0.1412858,0.1173102, _
0.07948983,0.04948366,0.03256958,0.01975145,0.01170228,0.00755573,0.00394044, _
0.00224714,7.044487E-04,4.781264E-04,2.913884E-04,1.418602E-04

CM242F:
Data 66,172, _
 9.976785E-07,2.990249E-06,3.993976E-06,5.984426E-06,1.501563E-05,2.59693E-05, _
6.383787E-05,1.996604E-04,3.991659E-04,8.978749E-04,0.00136348,0.00494226, _
0.01297685,0.02794921,0.04744336,0.08590198,0.1248077,0.1912241,0.2841046, _
0.4149972,0.5570809,0.7859119,0.9601199,1.227028,1.523775,1.887657,2.262657, _
2.647071,3.374505,4.019274,4.633781,4.845148,5.199471,5.433949,5.649985, _
5.953333,5.973204,5.943358,5.942727,5.787839,5.484037,5.134258,4.484844, _
3.406236,2.41305,1.427739,0.7388291,0.3514138,0.1795966,0.1105759,0.09977631, _
0.0998414,0.08985805,0.08985883,0.0848646,0.08283816,0.0926731,0.107202, _
0.118396,0.1559322,0.2688783,0.3731925,0.603923,1.011745,1.906739,3.45551, _
4.887071,5.647213,6.295203,6.764649,8.25744,7.020999,6.446314,5.777529,5.370582, _
4.76878,5.380749,4.967348,3.949403,3.297652,2.79402,2.180083,1.806818,1.492698, _
1.241072,0.9329176,0.7503847,0.5457596,0.407958,0.2923717,0.2046594,0.136443, _
0.08873541,0.05360235,0.03420081,0.01851784,0.00736577,0.00245528,0.00107906, _
5.259595E-04,2.141189E-04,7.796709E-05,2.43582E-05,1.462314E-05,1.009712E-05, _
4.47603E-06,2.725445E-06, _
 4.069072E-07,1.234751E-06,1.656368E-06,2.453151E-06,5.305697E-06,1.03305E-05, _
2.623826E-05,8.392584E-05,1.515674E-04,3.673248E-04,5.580778E-04,0.00190733, _
0.00548965,0.00927604,0.01934402,0.03502535,0.04385849,0.07050649,0.1121642, _
0.1540443,0.1785129,0.3213205,0.4060527,0.5061637,0.5573533,0.5135162,0.6792933, _
0.6450474,0.7081501,0.8826301,1.064439,1.165755,1.219978,1.110113,1.010597, _
1.29387,1.446391,1.249651,1.241093,1.241458,1.21154,1.071038,1.120364,1.000826, _
0.7260956,0.5478602,0.359726,0.1903259,0.09802064,0.05455703,0.04326124, _
0.03787153,0.02869823,0.03037807,0.03218221,0.02821941,0.03198396,0.03949802, _
0.0575758,0.06545653,0.07444137,0.1550515,0.2043367,0.3889953,0.601824, _
0.6816163,1.118859,1.335635,1.023489,1.367782,1.707039,1.500709,1.138256, _
1.285687,1.121763,1.090085,1.146031,1.062856,0.8664066,0.6914752,0.6832818, _
0.6660717,0.5859602,0.6127434,0.5147139,0.3917744,0.2606362,0.2250927,0.1350577, _
0.1205075,0.08677261,0.05604771,0.0362517,0.02206579,0.01406003,0.00777894, _
0.00282928,0.00100626,4.418601E-04,2.035772E-04,8.95525E-05,3.239117E-05, _
9.931316E-06,6.043637E-06,3.49926E-06,1.864854E-06,1.147319E-06

CM243F:
Data 66,172, _
 9.499473E-06,1.799584E-05,3.401086E-05,6.695705E-05,1.402385E-04,2.702961E-04, _
5.293222E-04,9.995074E-04,0.00200108,0.0037006,0.00664751,0.01199918,0.01999606, _
0.03399188,0.05497964,0.0870486,0.1332332,0.1999193,0.2918162,0.4287122, _
0.5738249,0.7744225,0.9990895,1.311856,1.612713,1.901591,2.293191,2.584506, _
3.028352,3.23451,3.622925,4.001118,4.392987,4.909813,5.505295,6.100083,6.599955, _
6.900142,6.89748,6.603884,6.000316,5.20007,4.199964,3.200083,2.203655,1.50003, _
0.9600189,0.5900159,0.3500095,0.2100046,0.1300029,0.0880006,0.06800091, _
0.06000088,0.05700165,0.05900154,0.06543863,0.079378,0.1100144,0.211209, _
0.2976177,0.4972962,0.8249171,1.29333,2.000726,2.888751,3.884841,4.880883, _
5.793487,6.474696,7.394814,6.873122,6.694537,6.18133,5.677792,4.850427,4.580219, _
4.086427,3.699814,3.38741,3.087998,2.689503,2.390509,1.989179,1.729213,1.3923, _
1.093946,0.8433895,0.6379405,0.4564211,0.3274328,0.2282115,0.1488508,0.09922135, _
0.06387931,0.03869633,0.02381367,0.01389161,0.00784854,0.00436634,0.00238184, _
0.00129081,6.451195E-04,3.270725E-04,1.704292E-04,8.237514E-05,4.167035E-05, _
 3.896207E-06,7.485362E-06,1.452902E-05,2.794059E-05,5.030512E-05,1.09183E-04, _
2.187452E-04,4.276961E-04,8.002545E-04,0.00151942,0.00273295,0.0046963, _
0.00856345,0.01119189,0.02259771,0.03577435,0.0455362,0.07485174,0.120708, _
0.1521289,0.184477,0.3186954,0.4232143,0.5595322,0.6166559,0.4995537,0.7075002, _
0.6943169,0.8105839,0.6783278,0.9204863,1.038589,1.03329,1.069837,0.9896082, _
1.265005,1.705316,1.5267,1.494884,1.389697,1.23337,1.090758,1.04027,0.9439019, _
0.6593037,0.5789269,0.4042148,0.3151637,0.1942739,0.1092176,0.05997321, _
0.03491532,0.02497978,0.02281282,0.02358947,0.01911562,0.01946945,0.02911592, _
0.05141059,0.08679413,0.1645317,0.2115359,0.2865672,0.4859711,0.6182848, _
0.774289,0.90227,1.12037,0.9359331,1.368208,1.457673,1.472272,1.220364,1.381067, _
1.210035,1.036505,1.187628,0.8589204,0.8176643,0.7243402,0.7434421,0.7026959, _
0.5975579,0.527499,0.7085611,0.5869465,0.4502227,0.3473783,0.2044611,0.1877112, _
0.1394358,0.09736696,0.06132897,0.04110547,0.02617372,0.01624248,0.01004502, _
0.00575537,0.00322029,0.00175509,9.926163E-04,5.537996E-04,2.707332E-04, _
1.34735E-04,5.509863E-05,3.401729E-05,1.797791E-05

CM243T:
Data 66,172, _
 3.4107E-06,8.556084E-06,2.118829E-05,4.703536E-05,8.556856E-05,1.69504E-04, _
3.758676E-04,6.700067E-04,0.00171202,0.00423775,0.00858187,0.01778586, _
0.02990281,0.05124086,0.08537949,0.1588698,0.2463172,0.3554962,0.4047591, _
0.423304,0.5364745,0.7086337,0.7600724,1.070649,1.158954,1.158475,1.365409, _
1.751343,2.241419,2.907118,3.352087,3.962876,4.721086,5.040157,5.432485, _
5.946536,8.701928,6.421615,6.710047,6.388371,5.911021,5.66691,4.305952,4.105299, _
2.626387,1.849245,2.355465,0.4669841,0.177819,0.1627402,0.06946664,0.04578302, _
0.03231229,0.02729427,0.03521711,0.03739199,0.0541217,0.06113092,0.072503, _
0.102305,0.1660984,0.6554623,0.7448469,1.207569,2.133637,3.193551,4.773698, _
5.742235,7.524263,5.910232,4.76136,6.402132,5.827525,6.809613,5.540015,5.150066, _
3.768088,4.289833,3.721924,3.275231,2.457521,2.092215,2.352539,1.985309, _
1.852624,1.244853,1.237907,1.309523,0.9041409,0.708375,0.4450572,0.4553847, _
0.3449039,0.2333723,0.1842983,0.1218485,0.08106178,0.0557607,0.02541389, _
0.0110495,0.0045442,0.00227209,0.00134335,6.094763E-04,3.007298E-04, _
1.754952E-04,9.572338E-05, _
 1.39508E-06,3.523264E-06,9.083222E-06,2.006069E-05,3.174385E-05,6.93781E-05, _
1.538173E-04,2.83162E-04,7.250035E-04,0.00175313,0.00350928,0.00709957, _
0.01259148,0.01672987,0.03584773,0.06528181,0.08008233,0.1334863,0.1692728, _
0.142224,0.1821714,0.2936056,0.3132427,0.4562949,0.4836849,0.4590731,0.5596583, _
0.6310433,0.5125492,0.6987984,0.6751126,1.194396,1.164416,1.29145,1.320805, _
1.306695,2.301377,1.39454,1.484404,1.163735,0.7789689,1.189935,0.9420994, _
1.248614,0.6226829,0.4482308,0.5326728,0.2333051,0.09822395,0.08942685, _
0.0342312,0.01915557,0.01034814,0.00945393,0.01438691,0.0123373,0.01718166, _
0.02255154,0.03045042,0.03810366,0.08821416,0.2782041,0.2629971,0.4319976, _
0.2529518,0.4155336,0.2997982,1.17451,1.199558,1.062878,1.23227,1.462414, _
1.104317,1.129039,0.8013579,1.077846,0.8824958,0.9360979,0.6731898,0.8620841, _
0.6211604,0.556278,0.5631385,0.8168898,0.4889762,0.4506628,0.5297757,0.5563076, _
0.3117793,0.2934369,0.183907,0.1954907,0.1467028,0.0960579,0.07539773, _
0.05030313,0.03486856,0.02363677,0.01041149,0.00452188,0.00186472,9.662043E-04, _
5.807855E-04,2.512124E-04,9.64583E-05,7.222546E-05,4.0711E-05

CM244F:
Data 66,172, _
 7.305735E-06,1.30135E-05,2.501219E-05,4.802156E-05,9.610377E-05,1.902248E-04, _
3.804422E-04,7.304546E-04,0.00140064,0.0026013,0.00481756,0.00850332,0.01500309, _
0.0249989,0.04095045,0.06609359,0.1013413,0.1599527,0.2187592,0.3420767, _
0.4527092,0.6224099,0.8338863,1.113123,1.420531,1.703514,1.993579,2.377807, _
2.843222,3.026353,3.612588,4.103275,4.589443,5.11767,5.704846,6.201488,6.501383, _
6.701623,6.695316,6.409222,5.902079,5.201254,4.300753,3.401158,2.603033, _
1.900458,1.300442,0.8502893,0.5402598,0.3401149,0.2100704,0.1400465,0.09503312, _
0.07402703,0.06502168,0.06403014,0.07033843,0.086214,0.119452,0.1794251, _
0.2872963,0.4670783,0.7443369,1.093749,1.692853,2.389211,3.185569,3.981736, _
4.87677,5.675124,6.480082,6.777723,6.790207,6.583404,6.272279,5.926188,5.271783, _
4.783497,4.02495,3.784805,3.285285,2.881483,2.483615,2.090977,1.803654,1.490419, _
1.192333,0.9041871,0.6864256,0.5268418,0.3666571,0.257652,0.1783775,0.1189149, _
0.07486915,0.04657522,0.02873822,0.01684629,0.00991315,0.00566415,0.00307168, _
0.00168462,8.81837E-04,4.565312E-04,2.285545E-04,1.190125E-04,5.843858E-05, _
 3.009016E-06,5.376694E-06,1.071513E-05,2.039015E-05,3.510433E-05,7.799475E-05, _
1.563808E-04,3.09781E-04,5.856359E-04,0.0010741,0.00198511,0.00338806, _
0.00633134,0.00816574,0.01708697,0.02725244,0.03316402,0.05996925,0.0910437, _
0.1159209,0.1512896,0.2583847,0.3461024,0.4779429,0.5706638,0.7043332,0.5471041, _
0.7194135,0.7359489,0.6417867,0.7460577,1.148051,1.10943,1.304572,1.09901, _
1.35746,1.808879,1.419413,1.505261,1.357412,1.291275,1.116642,0.9207706, _
1.046492,0.6754112,0.4648664,0.5366655,0.4357664,0.2994718,0.180924,0.09798518, _
0.05475815,0.03176285,0.02676708,0.02689575,0.02084442,0.02092463,0.03119757, _
0.05207741,0.0683528,0.1544319,0.1981578,0.2763596,0.3902457,0.5142122, _
0.5811021,0.7627405,0.9026905,0.9249942,1.264644,1.51051,1.534323,1.384264, _
1.392227,1.293515,1.242509,1.191779,1.047608,0.8470802,0.995541,0.8323269, _
0.7593781,0.5957599,0.6174218,0.4804678,0.6167532,0.5086758,0.380407,0.2308673, _
0.218795,0.1520395,0.1107007,0.07557186,0.04904741,0.03086899,0.01921976, _
0.0122745,0.0071722,0.00407985,0.00233263,0.00126197,7.128723E-04,3.812732E-04, _
1.889272E-04,7.396256E-05,4.916104E-05,2.455808E-05

CM244S:
Data 66,172, _
 3.986089E-05,6.57787E-05,9.961211E-05,1.493708E-04,2.490594E-04,3.984243E-04, _
6.564175E-04,9.970907E-04,0.00149332,0.00256892,0.00398854,0.00474966, _
0.00995567,0.01692507,0.02687448,0.04482616,0.07074329,0.1157891,0.1126782, _
0.2235962,0.1971384,0.3673923,0.4445721,0.72181,0.8116257,0.8254665,1.090339, _
1.287221,1.508826,1.630835,2.49629,3.065035,3.484617,3.90745,4.991358,5.787746, _
6.885237,6.929599,7.677633,9.300889,7.398161,6.985209,5.986909,5.01237,3.992637, _
2.876296,2.045346,0.881394,0.3983092,0.2577765,0.0697045,0.02990973,0.00996932, _
0.00498634,0.00199188,0.00131806,0.00244002,0.00486703,0.00877686,0.0154993, _
0.06808069,0.1987087,0.4860467,0.6608591,1.991528,3.004091,4.194263,5.660553, _
6.803529,7.481576,7.440197,8.073092,7.688324,7.02018,6.102636,5.620769,4.869087, _
4.00115,3.677363,3.088287,2.58792,1.981329,1.691584,1.452263,0.9974239, _
0.6967001,0.5971672,0.500562,0.3893709,0.2919847,0.2039501,0.1557253,0.09732869, _
0.06813081,0.04384693,0.02919766,0.01946501,0.01167941,0.00778638,0.00490482, _
0.00340597,0.00243331,0.00146012,9.739484E-04,5.837396E-04,3.893523E-04, _
2.921523E-04, _
 1.587385E-05,2.785564E-05,4.751425E-05,6.758949E-05,9.615379E-05,1.622272E-04, _
2.740541E-04,4.504485E-04,7.046053E-04,0.00108713,0.00158858,0.00188555, _
0.00460184,0.00578281,0.01156768,0.01838814,0.02581965,0.04487064,0.05293613, _
0.07966951,0.06297169,0.1526722,0.205716,0.3327427,0.3377715,0.3414494, _
0.4437263,0.5670781,0.3963165,0.703273,0.7052018,0.8448718,0.8550432,1.005782, _
1.227268,1.248861,1.842952,1.520867,1.882581,2.021946,1.478628,1.489778, _
1.380451,1.66398,0.9333833,0.7739372,0.7407943,0.3232419,0.2144168,0.1020641, _
0.03975915,0.01540104,0.00462734,0.00200234,9.006326E-04,4.265195E-04, _
7.024212E-04,0.00177169,0.00383986,0.00577821,0.03732598,0.08580729,0.1956014, _
0.2394508,0.5929105,0.7069757,0.8809378,1.186215,1.487932,1.105443,1.356854, _
1.788533,1.501951,1.526482,1.317366,1.213335,1.105543,1.040136,0.8303131, _
0.8656787,0.6725134,0.6839749,0.4255986,0.6130072,0.3964688,0.2904889,0.2063048, _
0.2290957,0.1515445,0.120816,0.08400092,0.06941447,0.0469589,0.02925285, _
0.0175409,0.0120835,0.00874354,0.00541712,0.00351107,0.00202459,0.00136136, _
0.00104052,7.039393E-04,4.34991E-04,2.104001E-04,1.611539E-04,1.241387E-04

CM245T:
Data 66,172, _
 1.044244E-06,2.08846E-06,4.175883E-06,1.045035E-05,2.611042E-05,5.747035E-05, _
1.044854E-04,2.089638E-04,4.599781E-04,7.733933E-04,0.00209087,0.0051583, _
0.01044162,0.02042451,0.03639531,0.06279352,0.1048859,0.1907532,0.2478064, _
0.314806,0.4630001,0.4961371,0.5909294,0.8609163,1.115876,0.8837012,1.275032, _
1.769137,1.672097,2.367941,2.835007,2.901754,3.653054,4.194667,4.943582, _
5.761652,5.956336,6.327807,6.739069,6.41771,5.744369,5.57935,5.742624,4.656776, _
4.726575,4.010345,3.0063,2.039337,1.093788,0.5595422,0.2166456,0.1431331, _
0.0845941,0.05261291,0.03713997,0.031131,0.05331389,0.06330457,0.0710137, _
0.0935051,0.1618115,0.4865031,0.6513394,1.270379,1.850609,2.91578,4.184739, _
5.466723,7.082899,6.80868,4.9584,6.253076,6.19061,5.879134,5.51993,5.161513, _
4.716754,4.424053,4.301075,3.043344,2.755507,2.438097,2.313969,1.952232, _
1.818359,1.142818,1.22276,1.295212,0.8925162,0.6963168,0.4328855,0.4479941, _
0.3283937,0.2290635,0.1795288,0.1196001,0.07966403,0.05473256,0.02493381, _
0.01090396,0.00445934,0.00223009,0.00131749,5.979109E-04,2.938567E-04, _
1.722348E-04,8.004364E-05, _
 4.303884E-07,8.68639E-07,1.787161E-06,4.579433E-06,1.041673E-05,2.386533E-05, _
4.303209E-05,8.758869E-05,2.027443E-04,3.304322E-04,8.620785E-04,0.00213284, _
0.00433875,0.00679247,0.01599803,0.02608041,0.03371535,0.07475018,0.102046, _
0.104059,0.1747395,0.2043549,0.2443752,0.29469,0.2797361,0.3782617,0.4188212, _
0.4226342,0.4932305,0.6062281,0.7988893,0.9514616,0.9939445,0.9074624,1.200704, _
1.215512,1.638837,1.343131,1.624434,1.450312,1.055836,1.170318,1.208625, _
1.281135,1.140434,0.8397085,1.174193,0.6552633,0.5669175,0.2174056,0.1169111, _
0.06694371,0.03450643,0.02177307,0.01344822,0.01003863,0.01739831,0.02167881, _
0.0269071,0.03199526,0.05686688,0.0993013,0.252738,0.5163249,0.4298504, _
0.4443882,0.7803065,0.7268333,0.4792504,0.917483,0.7629141,0.9109256,0.6369728, _
0.859655,1.171096,1.160526,0.8390887,1.159104,0.9524791,0.6463228,0.8869281, _
0.5138496,0.6045003,0.5311408,0.7521198,0.3681904,0.5072842,0.5624261,0.3709677, _
0.2893144,0.1774943,0.1869636,0.1458752,0.09800065,0.07402807,0.05014717, _
0.03308642,0.02372757,0.01097511,0.00452885,0.00183901,9.263848E-04, _
5.704806E-04,2.61322E-04,1.114564E-04,7.20122E-05,3.295933E-05

CM246F:
Data 66,172, _
 4.117991E-06,7.524064E-06,1.403996E-05,2.908037E-05,5.729407E-05,1.103263E-04, _
2.304069E-04,4.506863E-04,8.63257E-04,0.00160604,0.0030117,0.00531291, _
0.00942399,0.01603451,0.02691972,0.04323711,0.0684754,0.1000823,0.1398957, _
0.2527857,0.3129788,0.4422035,0.5954564,0.8077382,1.042238,1.310024,1.597061, _
1.869673,2.274967,2.341773,2.92091,3.316418,3.787498,4.337256,4.91587,5.409127, _
6.009917,6.410556,6.694748,6.83533,6.615036,6.210483,5.508387,4.70519,3.810097, _
2.904904,2.10502,1.503586,1.002389,0.6510984,0.400955,0.250423,0.150359, _
0.0982331,0.07016838,0.05718711,0.05620084,0.06422839,0.08600201,0.117373, _
0.207298,0.347236,0.5530533,0.8722672,1.289721,1.888904,2.67741,3.477747, _
4.355829,5.280237,5.986353,6.664638,6.813975,6.811005,6.568841,5.932851, _
5.558323,4.98283,4.674943,3.988609,3.481061,3.081538,2.67551,2.282687,1.990103, _
1.685683,1.388206,1.090734,0.8498113,0.6931823,0.4841635,0.3557105,0.2470222, _
0.1778548,0.1186418,0.0760825,0.04841604,0.03063094,0.0187735,0.01090673, _
0.00622598,0.00355702,0.00187708,9.873684E-04,5.440209E-04,2.76826E-04, _
1.383153E-04, _
 1.727494E-06,3.148928E-06,5.843067E-06,1.247631E-05,2.307182E-05,4.59066E-05, _
9.693602E-05,1.868764E-04,3.647961E-04,6.805892E-04,0.00124959,0.00222922, _
0.00391373,0.00535565,0.01151008,0.01793622,0.02233009,0.04075769,0.05332753, _
0.08244909,0.118369,0.1850083,0.2500341,0.3357614,0.4437093,0.5470994,0.6685372, _
0.5101958,0.6919576,0.608523,0.607423,1.09326,0.6695557,0.9181741,1.20065, _
1.143345,1.728616,1.401282,1.649902,1.467223,1.403445,1.358528,1.203611, _
1.277062,0.9180144,0.6082724,0.5493033,0.6234013,0.5002123,0.2517536,0.214228, _
0.1184187,0.06104916,0.0455011,0.02270614,0.01935931,0.0212588,0.02452247, _
0.03150407,0.04105252,0.09283748,0.1502935,0.2148092,0.3876318,0.3813652, _
0.442856,0.9129287,0.6868469,0.9671343,1.109998,0.9703135,1.400978,1.4849, _
1.482385,1.393784,1.251424,1.169796,1.109686,1.02847,0.8440431,1.127328, _
0.6478443,0.6922542,0.6419159,0.584677,0.4436977,0.5751053,0.4664316,0.3366039, _
0.2880672,0.2040976,0.1474949,0.1053408,0.07543808,0.04922694,0.03209638, _
0.02009826,0.01294544,0.00802702,0.00452477,0.00261927,0.00148546,7.850505E-04, _
4.238988E-04,2.057787E-04,1.157089E-04,5.811635E-05

CM246S:
Data 66,172, _
 2.153902E-05,4.412082E-04,4.214345E-04,8.158097E-04,8.009757E-04,0.00110722, _
0.00149965,0.00209599,0.00287042,0.00415458,0.00570626,0.007492,0.01185191, _
0.01713953,0.02552383,0.0392529,0.0571528,0.08304682,0.09132172,0.1679616, _
0.1777313,0.2866277,0.3519396,0.5772312,0.6488433,0.702834,0.959595,1.210963, _
1.487398,1.987705,2.283639,2.364987,3.309904,4.248372,4.720648,5.470753, _
6.138634,6.835194,6.937564,6.811804,6.733375,6.606563,6.005955,5.511356, _
4.848207,4.309434,4.029616,1.752168,1.242049,0.8137178,0.07097495,0.02534316, _
0.00860581,0.00402169,0.00203056,0.00154782,0.00195076,0.00291879,0.00436632, _
0.01016421,0.03460115,0.1053796,0.2507184,0.5660281,1.793253,3.32596,4.655059, _
5.704026,5.814184,6.62958,6.791939,6.914161,6.684257,6.326641,6.371862,5.324576, _
5.514224,5.323882,5.055202,3.518029,2.905872,2.570287,1.977142,1.544039, _
1.119196,0.8575588,0.5712954,0.5895733,0.3356501,0.2285172,0.181209,0.1205082, _
0.08301706,0.05802285,0.03928768,0.02677933,0.02053084,0.01428159,0.01071221, _
0.00739254,0.00535563,0.00446326,0.00267822,0.00178643,0.00169566,0.00116106, _
9.820067E-04, _
 8.794834E-06,1.839678E-04,1.885134E-04,3.683706E-04,3.218832E-04,4.596189E-04, _
6.14572E-04,9.010051E-04,0.00132333,0.00179775,0.0023437,0.00307141,0.00504779, _
0.00577854,0.01151042,0.01636304,0.01832591,0.03216505,0.04019532,0.05672672, _
0.06671572,0.1200072,0.1454998,0.2538421,0.296143,0.2962121,0.3919887,0.5048575, _
0.6676574,0.5224357,0.6628188,0.7679072,0.8702065,0.9447198,1.166351,1.163891, _
1.660841,1.455365,1.69366,1.590622,1.435586,1.383273,1.268921,1.657306,1.167321, _
0.9086794,1.073119,0.7324954,0.6421168,0.3194236,0.03948352,0.01233837, _
0.00362138,0.00166403,7.762965E-04,5.107274E-04,6.546073E-04,0.00100178, _
0.00177478,0.00363779,0.01784455,0.0443137,0.100356,0.2317079,0.5518403, _
0.7752943,0.9972056,1.037226,1.409964,1.180119,1.097126,1.476271,1.569241, _
1.405712,1.349341,1.213554,1.178113,1.244348,1.150403,0.7503286,0.9423227, _
0.5514771,0.5003843,0.6656896,0.4586356,0.3580843,0.2465171,0.2669025,0.1422762, _
0.09523536,0.07402433,0.0506967,0.03817318,0.0257767,0.01639612,0.0112176, _
0.00852038,0.00630479,0.00494987,0.00312279,0.00218859,0.00186021,0.0011804, _
8.097341E-04,6.950113E-04,4.840876E-04,4.014275E-04

CM248F:
Data 66,172, _
 2.074868E-06,3.65945E-06,6.832928E-06,1.286209E-05,2.585224E-05,5.246901E-05, _
1.089105E-04,2.087394E-04,3.958375E-04,7.629479E-04,0.00138531,0.00258164, _
0.00464488,0.00799694,0.0136314,0.02284502,0.03669456,0.0574938,0.06619884, _
0.153677,0.1801401,0.2729417,0.3552438,0.5030575,0.7229612,0.8801838,1.094302, _
1.338352,1.773972,2.073279,2.313635,2.717687,3.053597,3.630062,4.098457, _
4.675797,5.37196,5.968262,6.43868,6.931716,6.975887,6.764973,6.365033,5.777879, _
4.987739,4.078888,3.183514,2.387637,1.687618,1.094335,0.7346108,0.4576303, _
0.27796,0.168762,0.1091983,0.07243413,0.05741864,0.05544618,0.06633323, _
0.08734111,0.1478614,0.238149,0.3943334,0.6349502,0.9904072,1.487342,2.082296, _
2.875073,3.727428,4.721084,5.435168,6.534645,6.769624,7.094317,6.886296, _
6.642542,6.048513,5.599377,5.043958,4.319954,3.787965,3.279522,2.778781, _
2.384795,2.082639,1.685082,1.387714,1.18947,0.9416658,0.7378961,0.5629259, _
0.4147877,0.306152,0.2172697,0.1481426,0.09875821,0.0651797,0.04147917, _
0.02567679,0.01585971,0.00948062,0.00543253,0.00306229,0.00167904,9.178955E-04, _
4.832551E-04,2.472875E-04, _
 8.659467E-07,1.557284E-06,2.85536E-06,5.471831E-06,1.092515E-05,2.190443E-05, _
4.613692E-05,8.79845E-05,1.658433E-04,3.30426E-04,5.841683E-04,0.00108246, _
0.00197239,0.00289513,0.00586744,0.00976548,0.01284701,0.02419575,0.0227926, _
0.05176707,0.07526726,0.114052,0.1504768,0.2120599,0.303124,0.3803172,0.458566, _
0.5656409,0.4941637,0.6168114,0.588605,0.6830287,1.002926,0.7879393,0.8703409, _
1.217952,1.345695,1.331504,1.824393,1.482034,1.511147,1.440805,1.394156, _
1.383679,1.052164,1.059685,0.6732658,0.6290936,0.704985,0.4031717,0.2846458, _
0.2398442,0.1253892,0.0760731,0.03997827,0.02998547,0.02243464,0.02253229, _
0.02168275,0.03069806,0.05529964,0.08192199,0.1425018,0.2676241,0.367586, _
0.5299361,0.6849731,0.7393864,0.8747908,1.034251,0.9576188,1.390034,1.423805, _
1.61331,1.509177,1.411488,1.287441,1.175774,1.131977,0.9493812,1.02354, _
0.8581635,0.5849239,0.6332548,0.5865266,0.7054266,0.5900208,0.4961887,0.4019877, _
0.3144546,0.2352837,0.1765525,0.1277679,0.09291054,0.06369659,0.04119555, _
0.02769653,0.01741397,0.01084068,0.00686836,0.00397937,0.00229071,0.00129708, _
7.01703E-04,3.920774E-04,2.052482E-04,1.034438E-04

CM248S:
Data 66, 172, _
 4.397148E-04,5.487097E-04,7.686162E-04,9.877197E-04,0.0013902,0.00186694, _
0.00241557,0.0032084,0.00439292,0.00593065,0.00769033,0.01069349,0.01426564, _
0.01865148,0.02514262,0.03523387,0.04632771,0.04558003,0.06928283,0.1074655, _
0.1608088,0.2093474,0.2650146,0.4382651,0.496586,0.597923,0.8495646,1.138114, _
1.543216,1.636987,2.110027,2.626063,3.183774,4.153313,4.520552,5.245277, _
5.454882,5.512637,6.273931,6.433392,6.175519,6.29433,6.083044,6.051877,5.777919, _
5.417086,4.683302,2.662814,2.098106,1.38775,0.07686738,0.02138608,0.00748571, _
0.00320821,0.00213848,0.00181768,0.00164595,0.00186681,0.00205997,0.00650519, _
0.0132242,0.0311733,0.1016419,0.3221179,2.026417,2.620905,4.33663,5.255962, _
4.908693,5.790323,4.543206,6.238781,6.574431,6.328858,5.838215,5.621989, _
6.264241,5.489667,5.828458,4.480808,3.742869,3.130743,2.622848,2.030586, _
1.521403,1.184068,0.9685025,0.7927192,0.4077955,0.2548701,0.2038946,0.1325318, _
0.1019471,0.07136314,0.05097963,0.03568107,0.03058294,0.02344703,0.01835088, _
0.01318022,0.01019484,0.00815613,0.00611675,0.00458835,0.00356931,0.00254841, _
0.0020395, _
 1.847447E-04,2.342723E-04,3.200197E-04,4.193441E-04,5.679555E-04,7.774314E-04, _
0.00103256,0.00134357,0.00184215,0.00252447,0.00320197,0.00453782,0.00598237, _
0.0062643,0.01070284,0.0146617,0.01511311,0.01815542,0.02722099,0.03522218, _
0.05768769,0.08927456,0.1114647,0.1829665,0.2084839,0.2490671,0.3606154, _
0.4823388,0.6432634,0.4265976,0.5891318,0.8799803,1.042492,0.8741915,0.9852992, _
1.137843,1.49166,1.286318,1.651757,1.432055,1.353509,1.33791,1.299726,1.541118, _
1.269999,1.149335,1.033003,0.7203555,0.6473614,0.3030784,0.04193502,0.0108996, _
0.00326675,0.00145646,7.167077E-04,6.914302E-04,6.706971E-04,7.048661E-04, _
6.783116E-04,0.00220626,0.0051853,0.01124347,0.03776176,0.1353513,0.7344024, _
0.6608159,0.9625158,1.076419,1.141799,1.252636,0.7971355,1.41937,1.378523, _
1.453828,1.252601,1.212005,1.428066,1.152738,1.344125,0.9562351,1.073682, _
0.8657751,0.7672319,0.534482,0.633299,0.3851903,0.4066464,0.3330027,0.1691039, _
0.1061175,0.08669619,0.05603727,0.04253772,0.03051293,0.0213312,0.01502599, _
0.01304127,0.00976082,0.00780816,0.00556759,0.00425612,0.00348767,0.00255935, _
0.00193381,0.00146844,0.00106079,8.682645E-04

ES253S:
Data 66,172, _
 2.671919E-04,3.599388E-04,5.133974E-04,6.775875E-04,9.451056E-04,0.00133302, _
0.00184687,0.00234137,0.00338541,0.00461595,0.00619955,0.00814653,0.01128294, _
0.01538324,0.0225464,0.03081048,0.04197189,0.06161094,0.07802432,0.1163609, _
0.1516477,0.1999544,0.2843312,0.3716436,0.4667499,0.5338181,0.6124138,0.6600046, _
0.9848831,1.149258,1.53424,1.875936,2.218504,3.116789,3.447869,3.849507, _
4.558483,5.856871,6.275385,6.248576,6.532347,6.280789,5.875143,5.520592, _
5.275653,4.728837,3.977547,3.646909,3.24217,2.828172,2.57118,2.228665,1.222083, _
0.6619633,0.3157057,0.1524624,0.06566466,0.03180525,0.02002489,0.01898346, _
0.02993251,0.06338045,0.1545348,0.3103416,0.5807769,1.136353,2.528619,2.669498, _
2.943386,4.707016,4.272602,4.598938,4.833023,5.884627,5.661408,5.741125, _
5.794275,6.448845,5.108228,5.804204,5.407469,4.817023,3.833056,3.133095,2.46532, _
1.907915,1.561618,1.482296,1.075298,0.9272155,0.772854,0.7442863,0.5796614, _
0.5641536,0.4398304,0.2898212,0.2125343,0.144913,0.1063953,0.07728654, _
0.05796444,0.04057504,0.0289817,0.02221898,0.01658601,0.01062611,0.00772883, _
 1.097346E-04,1.460331E-04,2.080754E-04,2.76253E-04,3.339609E-04,5.379465E-04, _
7.484242E-04,9.600391E-04,0.00131129,0.00187103,0.00255231,0.00318978, _
0.00460374,0.00493005,0.00914367,0.01257618,0.01371696,0.02257612,0.03053968, _
0.03947423,0.04954437,0.08206036,0.1152328,0.1523384,0.1803097,0.2177999, _
0.2517108,0.266635,0.4047999,0.4682482,0.5860289,0.6022965,0.5486482,0.8023447, _
0.8345453,0.8326406,1.267764,1.225799,1.339836,1.294842,1.344715,1.315791, _
1.225395,1.634325,0.9310523,1.156052,0.8265995,0.7839357,0.6966572,0.7408915, _
0.8211561,0.6820539,0.4710205,0.2032328,0.09980115,0.06517395,0.02104377, _
0.01403606,0.00661269,0.00759185,0.01604579,0.02663321,0.05814249,0.12059, _
0.1726062,0.4448154,0.6291644,0.6216141,0.7309933,0.689809,0.7498058,1.010269, _
1.090805,1.244641,1.269945,1.189862,1.311983,1.362934,1.078289,1.194868,1.37467, _
1.069831,0.9113454,0.6577681,0.6447615,0.7740012,0.6307583,0.6058774,0.3615531, _
0.3817265,0.3134838,0.3056269,0.2368169,0.229662,0.1809757,0.1175261,0.08597952, _
0.05906259,0.04339068,0.03121755,0.02346873,0.0166788,0.01182892,0.00904159, _
0.00529751,0.00431359,0.00316559

ES254T:
Data 66,172, _
 9.3824E-09,1.874464E-08,3.75627E-08,7.514279E-08,1.409305E-07,2.345356E-07, _
1.454309E-07,9.686134E-07,1.880799E-06,3.282271E-06,6.577616E-06,1.357003E-05, _
2.422607E-05,4.838431E-05,9.31516E-05,2.353471E-04,4.251063E-04,8.711522E-04, _
0.00142971,0.00362021,0.00678289,0.01341464,0.0266412,0.0488806,0.115311, _
0.2765512,0.3543628,0.4455482,0.5793652,0.7155356,0.7550815,0.9809126,1.321125, _
2.317402,2.428525,2.487147,2.713937,3.127816,3.38223,4.26393,4.025843,3.877228, _
3.682632,3.718746,3.881562,4.192536,4.342347,3.890815,4.94348,5.572667,5.480339, _
5.087158,4.458822,3.913194,3.392581,2.695797,2.295831,1.938617,1.339261, _
0.9033266,0.8446203,0.9452509,1.284918,1.961228,2.460507,3.79487,4.799688, _
5.053106,5.304444,5.502077,4.935948,4.832289,4.506392,4.2057,4.001887,4.588583, _
4.570943,4.839259,3.889947,3.572703,3.266098,2.967359,2.656576,2.266836, _
1.980224,1.700241,1.624616,1.591975,1.280085,0.9846156,0.7962622,0.7543094, _
0.6847703,0.4891217,0.3915011,0.2934731,0.1956475,0.09782308,0.0479333,0.019691, _
0.008803,0.00391289,0.00195689,9.778123E-04,4.892714E-04,1.961339E-04, _
9.79039E-05, _
 3.970144E-09,7.826159E-09,1.559114E-08,3.181734E-08,5.381961E-08,9.807749E-08, _
6.12135E-08,4.011024E-07,7.850233E-07,1.368467E-06,2.741524E-06,5.675748E-06, _
1.003472E-05,1.590017E-05,3.91598E-05,9.74188E-05,1.379823E-04,3.452184E-04, _
5.514858E-04,0.00117605,0.00247506,0.005653,0.0111942,0.02026212,0.04830978, _
0.1149693,0.1480227,0.1883653,0.2397173,0.3011292,0.309282,0.3360051,0.4285783, _
0.4862539,0.6219038,0.7227765,0.9015469,0.8523013,0.8295813,1.112913,0.8456635, _
1.031516,0.7968566,1.002007,0.9407564,0.880213,0.9626074,0.8467852,1.049429, _
1.342673,1.003385,0.8878286,0.7811832,0.6749765,0.7514719,0.6738521,0.7242031, _
0.4880006,0.5192525,0.3366572,0.2989919,0.2911478,0.4936003,0.5047942,0.8520904, _
0.9059283,0.8782579,1.00767,1.217543,1.154253,0.8909661,1.039329,0.9487965, _
0.9543035,0.7291806,1.063394,0.9672201,1.062403,0.8511541,0.7562355,1.059124, _
0.6239742,0.6938362,0.6362843,0.5853689,0.4443375,0.6717923,0.6712856,0.5039096, _
0.4091493,0.3374053,0.3126478,0.2879885,0.2058099,0.1621723,0.1242935, _
0.08146506,0.04083873,0.02028064,0.00814706,0.00371216,0.00164301,8.11329E-04, _
4.144928E-04,1.854805E-04,8.206328E-05,4.137477E-05

FM254S:
Data 66,172, _
 2.824101E-05,3.841463E-05,5.261704E-05,7.471279E-05,1.016376E-04,1.516492E-04, _
2.025359E-04,2.822571E-04,3.840941E-04,5.051044E-04,7.219987E-04,0.00101048, _
0.00151632,0.00232367,0.00354557,0.00505462,0.0085668,0.01208757,0.016832, _
0.02665655,0.04026434,0.05556962,0.09519973,0.1319767,0.2027751,0.3952556, _
0.4430089,0.4785986,0.5001159,0.5225063,1.015821,1.26156,1.5079,1.758764, _
2.219737,2.7145,3.01603,3.168802,4.019588,4.934113,5.565042,5.429001,5.629903, _
5.701335,6.457108,5.529492,6.229129,5.730622,5.032598,5.078135,4.244426, _
3.518799,2.619719,1.813658,1.111863,0.7967667,0.4092798,0.2526796,0.1602105, _
0.1267905,0.1638165,0.2389151,0.4545795,0.8718573,1.507643,2.440137,3.520972, _
4.341242,5.187315,4.478276,5.742619,5.592595,5.744035,4.991275,5.543559, _
5.478932,5.029107,5.457284,4.84689,4.108037,3.725071,3.447174,2.864973,2.857482, _
2.201214,1.685728,1.498415,1.385211,1.034269,0.8009848,0.664453,0.6189294, _
0.4734149,0.4332689,0.2180832,0.1183269,0.07281896,0.05461893,0.03839596, _
0.02457467,0.01820381,0.01183296,0.00546217,0.003641,0.00280822,0.00182165, _
9.099694E-04, _
 1.15195E-05,1.580772E-05,2.083909E-05,3.039607E-05,3.520809E-05,5.917511E-05, _
8.254476E-05,1.168458E-04,1.377582E-04,2.072701E-04,2.968882E-04,3.832819E-04, _
6.27966E-04,7.889873E-04,0.00145707,0.00204785,0.00304034,0.004348,0.00639181, _
0.00994678,0.01291031,0.02264461,0.03928275,0.0542568,0.07449827,0.1637195, _
0.1806438,0.1947306,0.2058641,0.2122757,0.3891878,0.3729159,0.5820668,0.7132657, _
0.7600446,0.7079284,0.7877253,0.8579321,0.8394346,1.042254,1.250683,1.128755, _
1.190579,1.3987,1.154621,1.168699,0.8713938,1.241805,1.053229,1.013898,1.065462, _
0.7642233,0.6533339,0.5971549,0.3184074,0.2610332,0.1928786,0.1022679, _
0.08658685,0.05327981,0.08786444,0.09723355,0.1564685,0.260148,0.4695503, _
0.616562,0.5969994,1.000236,0.9548974,0.8950839,1.440118,1.261785,0.9993985, _
1.059106,1.176518,1.166863,1.196641,1.1338,1.0871,0.8761038,0.8973166,0.9022673, _
0.7103944,0.7652047,0.6131392,0.6889639,0.5971805,0.4980437,0.3340976,0.3287618, _
0.2720717,0.2558696,0.1929349,0.1795005,0.08892871,0.04880313,0.02815942, _
0.0223046,0.0159068,0.00957818,0.00743646,0.00488153,0.00222585,0.00150739, _
9.380479E-04,7.461981E-04,3.767475E-04

FM255T:
Data 66, 172, _
 1.585978E-04,2.0525E-04,2.518404E-04,3.267539E-04,4.382183E-04,5.775442E-04, _
7.456841E-04,9.518139E-04,0.00130549,0.00158452,0.00214946,0.00279652, _
0.00372794,0.00465933,0.00633648,0.00802127,0.01036459,0.0133244,0.01625947, _
0.02435475,0.02932981,0.03939403,0.05110266,0.06591938,0.08666478,0.111978, _
0.1387925,0.186959,0.2363993,0.3086306,0.4106219,0.687297,0.696076,0.8601909, _
0.9525971,1.142434,1.237566,1.332801,1.519811,2.392556,2.415537,2.608418, _
2.704612,2.897614,3.286434,3.188062,3.625351,4.253723,4.830398,5.591329,5.66202, _
5.856079,5.893073,5.953695,5.796475,5.699842,5.329954,4.927008,3.879268, _
3.016303,2.40434,2.322269,2.168519,2.263562,2.483183,3.215207,4.809127,5.420526, _
5.817971,6.177968,6.098579,6.465608,6.107572,5.714777,4.834266,4.623211,4.3335, _
3.144065,3.209111,2.833512,2.482835,2.022641,1.745965,1.469318,1.28779,1.285995, _
1.103258,0.9980806,0.7088053,0.5315931,0.4429942,0.364707,0.2657962,0.1949182, _
0.150645,0.1151777,0.08859837,0.07087819,0.05316001,0.04596977,0.03544001, _
0.02657961,0.01771933,0.0150623,0.01240511,0.00886016,0.00708757, _
 6.926284E-05,8.71162E-05,1.099047E-04,1.403495E-04,1.608532E-04,2.506317E-04, _
3.163621E-04,4.157818E-04,5.41645E-04,6.735377E-04,9.477349E-04,0.00115244, _
0.00160879,0.00155096,0.00268634,0.0035022,0.00351332,0.00507935,0.00694483, _
0.00863181,0.00985997,0.0171696,0.0217206,0.02907755,0.03502183,0.04856489, _
0.06068954,0.07929977,0.1041279,0.1320894,0.1647903,0.229122,0.2576827, _
0.3773954,0.3805491,0.4911978,0.4116512,0.5650857,0.6481252,0.6837621,0.7092384, _
0.6824988,0.5770901,0.9546226,0.7627964,0.6843899,0.9437564,0.9120128,1.086695, _
1.351843,1.020112,1.043486,1.04236,1.032209,1.31563,1.403596,1.524193,0.9546678, _
1.021315,0.6798978,0.6606404,0.5970943,0.8083073,0.6064172,0.7562855,0.7633366, _
0.8517304,1.099944,1.348838,1.159749,1.109243,1.407926,1.326196,1.302329, _
1.036218,1.202313,0.9267516,0.8329552,0.7014624,0.8155379,0.8264489,0.8577436, _
0.4441437,0.6310808,0.5536931,0.5652984,0.4674177,0.4380178,0.2877574,0.2272781, _
0.1953246,0.1549328,0.1158291,0.08495341,0.06399186,0.05076527,0.03791905, _
0.03051182,0.02338398,0.01949282,0.01551031,0.01152953,0.00754765,0.00664484, _
0.00482906,0.00383308,0.00310826

FM256S:
Data 66, 172, _
 1.010745E-04,1.615773E-04,2.21779E-04,3.030103E-04,4.043488E-04,5.255021E-04, _
7.068219E-04,0.00100722,0.0013137,0.00181696,0.00254011,0.00342416,0.00464441, _
0.0070665,0.00907917,0.01213077,0.01654598,0.02214293,0.02918253,0.04147848, _
0.05386862,0.07328021,0.1102465,0.1526235,0.2038373,0.2424369,0.301129, _
0.3955863,0.5321778,0.6689646,0.7484407,0.7681777,1.005212,1.213263,1.511981, _
1.812561,2.009815,2.210792,2.714007,3.114184,3.618669,4.522294,5.225097, _
5.418058,5.624226,5.433909,5.627754,6.029729,6.029969,6.131702,5.657343, _
4.716551,4.019818,3.222344,2.61816,2.720061,1.569283,0.9088657,0.4676412, _
0.4430701,0.4185954,0.4294329,0.5707647,0.8583694,1.546931,2.537372,4.024408, _
3.827047,4.086682,6.220217,4.7795,5.183128,5.293835,6.122885,5.963209,5.759212, _
5.26334,4.88593,4.490768,3.908338,3.416088,3.122585,2.703111,2.655003,2.239134, _
2.050125,1.64177,1.35234,1.064814,0.8373626,0.7219397,0.5203366,0.3996733, _
0.3044948,0.2310795,0.1617626,0.1141851,0.07993124,0.05713371,0.04345804, _
0.03330409,0.02474046,0.0190319,0.01332092,0.00956242,0.007042,0.0047578, _
 4.16714E-05,6.574246E-05,9.02732E-05,1.239728E-04,1.436166E-04,2.134167E-04, _
2.875381E-04,4.141875E-04,5.130098E-04,7.389729E-04,0.00105036,0.00134859, _
0.00190161,0.00226933,0.00369413,0.00497413,0.00544988,0.00808949,0.01147123, _
0.01445,0.01737487,0.03004498,0.04505679,0.06309708,0.07692546,0.09995002, _
0.1236454,0.1605811,0.2199936,0.2726182,0.2864496,0.248919,0.3618243,0.4987855, _
0.565353,0.7426175,0.6471487,0.7083491,0.6494353,0.6573817,0.771229,1.006141, _
1.076311,1.538597,1.071486,1.139749,1.230843,1.25286,1.247283,1.104146, _
0.9060992,0.7880294,0.9272401,0.9922419,0.8153412,0.5830501,0.4972364,0.3420495, _
0.242565,0.1840421,0.2276478,0.180238,0.2150496,0.3391697,0.4551696,0.582512, _
0.8407375,0.9138662,0.9929377,1.068643,0.8364449,1.097151,1.262062,1.271605, _
1.232992,1.213552,1.124303,1.086941,0.932637,1.026212,0.9180338,0.6671737, _
0.6425815,0.5524164,0.5839181,0.8345506,0.6652944,0.5530577,0.3503992,0.3451855, _
0.2938622,0.2151392,0.1632966,0.1246886,0.09546307,0.06581713,0.04647418, _
0.03280604,0.02330074,0.0177747,0.01357069,0.01015744,0.00784877,0.00542036, _
0.00307206,0.00288413,0.00194362

NP237F:
Data 66, 172, _
 1.870675E-07,3.732831E-07,1.878534E-06,6.88089E-08,2.439464E-05,6.188707E-05, _
1.504998E-04,3.684686E-04,6.627251E-04,0.00131849,0.00601294,0.01044062, _
0.02434307,0.05633868,0.1104736,0.2363335,0.3577776,0.4821873,0.7067264, _
0.9985518,1.27353,1.710462,2.135516,2.544159,3.420172,3.938418,4.347595, _
5.000727,5.245265,5.702981,5.49946,6.142352,6.072685,6.150194,6.442837,6.124364, _
5.768816,5.558099,4.123412,3.111566,2.334839,1.712623,1.29639,0.6371514, _
0.301735,0.09527849,0.07346124,0.0515581,0.05283343,0.04894715,0.04778631, _
0.04302248,0.05294127,0.0532655,0.05302229,0.05260609,0.06072722,0.07569814, _
0.07274681,0.131045,0.1649559,0.3560004,1.499034,1.758945,2.727417,3.600316, _
4.853945,6.467511,7.048923,7.269404,6.551699,6.349054,6.17394,5.668061,5.496813, _
5.34293,4.780852,4.658407,4.142292,3.456164,2.800172,2.22783,1.718609,1.303397, _
0.9940159,0.7272126,0.4599397,0.3651559,0.187241,0.1419319,0.1004968,0.03221492, _
0.01277158,0.00649181,0.0025085,7.795688E-04,3.025463E-04,1.295944E-04, _
5.622702E-05,1.923989E-05,1.124646E-05,1.553627E-06,3.987289E-07,1.295573E-07, _
4.075798E-07,1.210042E-07,4.672801E-07, _
 7.982672E-08,1.600455E-07,7.860854E-07,2.966662E-08,9.824337E-06,2.610118E-05, _
6.488319E-05,1.543636E-04,2.81653E-04,5.629144E-04,0.00252209,0.00447442, _
0.010263,0.01902241,0.04754018,0.09889464,0.1173987,0.1938947,0.2094664, _
0.3309849,0.4485351,0.370553,0.8109568,0.6863497,0.8669541,0.7108815,1.132242, _
1.06798,1.16004,1.264613,1.120308,1.802488,0.9325845,1.348477,1.546736,1.298343, _
1.769942,1.194365,0.9960545,0.7454689,0.4934295,0.4833059,0.3626264,0.3305806, _
0.1374243,0.04063506,0.03092277,0.02216676,0.02231257,0.02065763,0.01979678, _
0.01528641,0.01733484,0.02002962,0.02160771,0.01673976,0.01858957,0.02756047, _
0.02665685,0.0440241,0.05462082,0.1443875,0.5793831,0.7048376,0.7671804, _
0.7923254,0.7573077,0.8819409,0.6407088,1.087475,1.191678,0.8079731,0.7322096, _
1.21818,0.9730046,1.214441,0.8627712,1.080551,0.8892856,0.7566066,0.8613978, _
0.7048253,0.4241078,0.5514475,0.3291911,0.3152005,0.1925952,0.1531853, _
0.07158935,0.06041628,0.04313437,0.01348846,0.00549727,0.00275123,0.00105812, _
3.361137E-04,1.268175E-04,5.538142E-05,2.405948E-05,8.059012E-06,4.848745E-06, _
6.55996E-07,1.687743E-07,5.58231E-08,1.501353E-07,5.187682E-08,1.992424E-07

NP237HE:
Data 66, 172, _
 0.00500078,0.00700121,0.00900122,0.01200152,0.01500499,0.02000283,0.02500395, _
0.03300516,0.04300803,0.05301105,0.07007196,0.09501936,0.119954,0.1599095, _
0.1992263,0.2606777,0.3522658,0.4497222,0.5372703,0.7764863,0.8934161,1.182932, _
1.487258,2.032246,2.571905,2.675688,3.992715,4.792158,5.151352,5.58041,5.523332, _
5.3876,5.287126,4.887401,5.206399,5.001207,4.600973,4.331047,3.996505,3.451083, _
3.001445,2.500566,1.900021,1.456032,1.302153,1.214339,1.212032,1.230256, _
1.230238,1.229594,1.230313,1.230297,1.229669,1.229704,1.229634,1.259456, _
1.299848,1.349865,1.408776,1.499603,1.898768,2.503111,2.89831,3.30121,3.616927, _
4.091825,4.39876,4.499304,5.441403,5.001944,4.881315,5.204677,5.026281,4.784565, _
4.829754,4.801114,4.494755,3.549047,3.001683,2.503559,2.000053,1.702403, _
1.199206,0.900031,0.7022309,0.5297467,0.3998053,0.3149134,0.2499969,0.1799145, _
0.1399302,0.09259658,0.07996043,0.06790283,0.05015784,0.03498312,0.02698511, _
0.01999046,0.01599556,0.01199538,0.0094952,0.00699604,0.00549611,0.00419738, _
0.00320222,0.00238839,0.00189859, _
 0.00209396,0.00292727,0.00371072,0.00505613,0.00595931,0.00830293,0.01051666, _
0.01360779,0.01785084,0.02211705,0.02898438,0.03980704,0.04956283,0.05266112, _
0.08341049,0.1075296,0.1138472,0.1789914,0.2095387,0.2545242,0.3098672, _
0.4991243,0.6156122,0.5672346,0.66106,0.5610678,1.042096,1.011363,1.121634, _
1.22474,1.128034,1.533343,0.9414267,1.070055,1.244198,1.05907,1.369243, _
0.9065803,0.9606797,0.7327442,0.637702,0.6631956,0.5153911,0.5070711,0.5392649, _
0.5041538,0.5021578,0.5184436,0.5087792,0.5095608,0.4998867,0.4467969,0.4035677, _
0.4920555,0.4429184,0.4051113,0.4928279,0.5210946,0.4552375,0.474387,0.4414889, _
0.5879306,0.8562832,0.6597582,0.8934488,0.823028,1.049794,1.006667,0.9789196, _
1.111211,0.8545313,1.114072,1.176941,1.001769,1.082799,1.036706,0.9503173, _
0.9250123,0.6306326,0.6781823,0.6591119,0.7043048,0.4905733,0.3710721,0.295291, _
0.2199783,0.1651365,0.1323453,0.08885875,0.07571294,0.05806849,0.03851231, _
0.03361905,0.02799275,0.02109212,0.01455601,0.01114435,0.00842036,0.00660163, _
0.00500875,0.00397469,0.00288713,0.00231502,0.00174089,0.0010728,0.00100512, _
7.828604E-04

NP237T:
Data  66, 172, _
 4.88015E-08,8.7917E-08,4.87436E-07,1.94954E-06,5.856687E-06,1.463877E-05, _
2.931632E-05,8.839597E-05,2.633843E-04,4.397225E-04,0.00185441,0.00432474, _
0.01267357,0.02632537,0.03464454,0.1174701,0.1759685,0.3414395,0.4385167, _
1.068729,1.098717,1.811305,2.186141,2.863659,3.532445,3.676803,4.135007, _
4.692737,5.125458,5.731821,5.68972,5.859629,5.860496,6.660647,5.351025,6.640117, _
5.087504,5.778161,3.871065,2.657717,3.301011,2.410496,1.77774,1.099969, _
0.5390783,0.136614,0.05854912,0.03903301,0.03415364,0.01625724,0.019658, _
0.01778255,0.01670859,0.01619936,0.0142949,0.01586618,0.01773686,0.01960208, _
0.02614262,0.0295414,0.07080501,0.183504,0.5221743,0.9710044,1.839655,3.157179, _
4.567892,6.474188,7.311868,7.691932,6.914595,6.360175,6.255343,6.193016, _
6.021587,6.021975,4.947321,5.04912,4.848925,3.618247,2.811174,2.500003,1.656529, _
1.549034,0.7375935,0.7418379,0.3640288,0.1960164,0.1048227,0.07861539, _
0.06145641,0.02429906,0.01286392,0.00102558,3.735266E-04,2.329763E-04, _
1.400094E-04,5.5963E-05,2.333169E-05,1.04789E-05,2.523714E-06,9.339129E-07, _
1.867115E-07,6.99319E-08,9.32884E-09,4.67309E-09,9.3298E-10, _
 2.073298E-08,3.963304E-08,2.071478E-07,8.359715E-07,2.504788E-06,6.331963E-06, _
1.262213E-05,3.813062E-05,1.165037E-04,1.881726E-04,7.864005E-04,0.00194847, _
0.00537033,0.00912557,0.01568717,0.04977857,0.05813381,0.1455097,0.1786386, _
0.3591832,0.4125206,0.4763534,0.5304852,0.6165894,0.889601,0.7859307,0.938554, _
1.049675,1.132536,1.321115,1.182191,1.848757,1.034382,1.426025,1.320735, _
1.417212,1.48486,1.316964,0.9628245,0.6941522,0.7166371,0.7053646,0.4928105, _
0.4270431,0.2603896,0.06176491,0.0265669,0.01667051,0.01469777,0.00693927, _
0.00880984,0.00687729,0.00564587,0.00696754,0.0057465,0.00504698,0.00629387, _
0.00748691,0.00955276,0.00982359,0.03103581,0.06957265,0.2040018,0.3957478, _
0.5667672,0.7584867,0.8124241,1.306053,0.9208207,1.305664,1.185002,1.396055, _
1.088992,1.390003,1.285495,1.439163,1.06195,1.098545,1.128573,0.7790791, _
0.9212052,0.7358063,0.4494408,0.6660087,0.3121281,0.3364639,0.1539117, _
0.08331702,0.04588791,0.03349368,0.02640954,0.01069007,0.00559882,4.413654E-04, _
1.604393E-04,1.038745E-04,5.982041E-05,2.369374E-05,1.057227E-05,4.435858E-06, _
1.069804E-06,4.224827E-07,7.913221E-08,2.99139E-08,3.98532E-09,2.013234E-09, _
4.016746E-10

NP238F:
Data 66, 172, _
 1.294034E-07,5.470966E-07,2.288708E-06,6.961822E-06,1.592556E-05,4.382611E-05, _
1.591693E-04,2.992732E-04,6.47095E-04,0.00289042,0.00523172,0.01445154, _
0.03036929,0.0577145,0.09803019,0.1699255,0.2395369,0.3880968,0.6266895, _
0.7615635,1.119407,1.39899,1.750036,2.327389,2.747729,3.235638,3.639422, _
4.216536,4.980963,5.086402,5.441891,5.659004,5.643804,6.213391,6.106448, _
6.055525,6.145103,5.815892,5.684963,4.26172,3.843513,2.444156,1.655633, _
0.8960831,0.4799167,0.229224,0.12938,0.06990561,0.07364716,0.07117409, _
0.06079326,0.06085396,0.05979809,0.05834208,0.05931543,0.06149522,0.06438803, _
0.07207333,0.08323155,0.126409,0.184557,0.2724071,0.5857215,1.011625,2.090145, _
3.476654,5.148221,5.765419,7.994832,6.446291,6.959301,6.763392,6.248219, _
5.801846,5.799464,4.9363,5.747904,4.389727,4.14492,3.279148,2.855114,2.392059, _
1.767293,1.753111,0.9034751,0.8945931,0.6438333,0.4324232,0.2882826,0.2017969, _
0.1249214,0.0778366,0.04324292,0.02594499,0.01345375,0.00700225,0.00291626, _
9.416956E-04,2.789446E-04,8.174784E-05,2.691362E-05,1.153104E-05,4.134798E-06, _
1.24946E-06,3.07588E-07,6.728252E-08,5.76797E-09, _
 5.669983E-08,2.440785E-07,9.789179E-07,3.104057E-06,6.727808E-06,1.889523E-05, _
7.143652E-05,1.286977E-04,2.834994E-04,0.001286,0.00223911,0.00644037,0.013248, _
0.02017448,0.04399094,0.07289494,0.08097453,0.1664002,0.2458962,0.2552743, _
0.4256033,0.6204495,0.4894684,0.6988835,0.6944607,0.6971738,0.9801685,0.9488883, _
1.080001,1.323531,1.151794,1.686388,1.006957,1.336414,1.390289,1.333704, _
1.765443,1.372977,1.518253,0.9821594,0.8570787,0.7361589,0.4620662,0.3435633, _
0.2370395,0.10335,0.05757353,0.02999264,0.03300524,0.03061143,0.02684236, _
0.02504132,0.02062804,0.02528215,0.02242885,0.02037136,0.02426321,0.02778756, _
0.02827915,0.04241236,0.08139461,0.109351,0.225969,0.4261431,0.7097121, _
0.8534111,0.9347087,1.176629,1.895891,1.399892,1.227848,1.534948,1.347264, _
1.401069,1.25313,1.123279,1.292541,0.9547307,1.080224,0.7065989,0.9632148, _
0.6706328,0.7615467,0.4565301,0.3879067,0.3955278,0.2850311,0.1853992,0.1278816, _
0.08740396,0.05449748,0.03480887,0.01850727,0.01154533,0.00592232,0.00301155, _
0.00130938,4.063201E-04,1.222924E-04,3.648409E-05,1.151539E-05,5.144163E-06, _
1.811285E-06,5.391461E-07,1.36026E-07,2.896597E-08,2.536182E-09

PA231F:
Data 66, 172, _
 9.859495E-05,1.771181E-04,3.448204E-04,6.895311E-04,0.00128046,0.00246211, _
0.00443255,0.00890268,0.01674222,0.03151514,0.05912383,0.0989258,0.1968682, _
0.3966535,0.6881593,0.9903762,1.691732,2.299778,4.09495,4.617091,5.043211, _
5.891594,6.628855,7.078433,6.93192,6.456943,6.732646,6.621672,6.461996,6.38346, _
4.972485,4.355209,3.168896,2.544867,1.979816,1.38497,0.6429865,0.3706733, _
0.1956621,0.14764,0.1037071,0.09552687,0.07874161,0.07957546,0.0690636, _
0.09528118,0.05851088,0.08096395,0.06105772,0.0833059,0.06466703,0.06569061, _
0.06671859,0.06877308,0.07287858,0.07902725,0.08721146,0.09855357,0.116361, _
0.1457553,0.1931844,0.2915846,0.5289598,1.034249,2.085015,2.667323,3.584338, _
5.092382,6.364538,6.674606,7.285893,7.156854,7.488075,7.368133,6.716192, _
6.839452,6.198158,5.332872,4.697146,3.211158,2.607386,2.027285,1.559834, _
0.922141,0.5506546,0.3164078,0.1794691,0.07696655,0.04150145,0.02074801, _
0.01037308,0.00518722,0.00321523,0.00155554,7.363505E-04,3.736448E-04, _
1.970304E-04,1.037257E-04,4.148691E-05,2.055244E-05,9.325365E-06,3.627089E-06, _
1.556768E-06,6.220173E-07,3.114617E-07,1.55625E-07,1.036842E-07, _
 4.289763E-05,7.61191E-05,1.462202E-04,3.018071E-04,5.0626E-04,0.0010591, _
0.00192366,0.00375978,0.00722843,0.01345662,0.02530593,0.04262975,0.08309545, _
0.1312545,0.2941233,0.4229069,0.560238,0.6857005,0.7682554,0.8176288,0.8882493, _
1.320731,1.416309,1.547367,1.436495,1.430473,1.522601,1.404853,1.514607, _
1.381022,1.032266,1.327993,0.8216768,0.6646891,0.4829512,0.6581925,0.2461947, _
0.2000898,0.07183298,0.06659862,0.04517319,0.04053024,0.03424285,0.03129211, _
0.02969074,0.04095858,0.02496246,0.0353126,0.02577201,0.03596943,0.02584704, _
0.02249543,0.0220668,0.02535539,0.0304413,0.0254128,0.02612227,0.03579735, _
0.04422279,0.05226694,0.07014435,0.1249443,0.1977569,0.4074911,0.6388212, _
0.6375552,0.8539048,1.050706,1.216691,1.463878,1.282612,1.275935,1.674502, _
1.567959,1.550936,1.488782,1.349439,1.235252,0.9995986,0.8502364,0.8865969, _
0.5979888,0.664607,0.3894368,0.239469,0.1358673,0.0761774,0.03362653,0.01543839, _
0.00902294,0.00445942,0.00220437,0.0014069,6.584414E-04,3.180262E-04, _
1.620655E-04,8.314618E-05,4.532771E-05,1.772178E-05,8.769125E-06,4.075862E-06, _
1.531523E-06,6.757327E-07,2.683221E-07,1.096205E-07,6.810127E-08,4.405259E-08

PU238F:
Data 66, 172, _
 1.224462E-06,2.035375E-06,6.117401E-06,2.039301E-05,7.131648E-05,1.834099E-04, _
4.281173E-04,4.609456E-04,0.00126734,0.0024327,0.00786289,0.02128769,0.03647488, _
0.06736991,0.1111937,0.1827259,0.2751976,0.3783337,0.5897804,0.7325104,1.02211, _
1.168523,1.582721,2.097805,2.46175,2.953232,3.453248,4.052854,4.802197,4.439692, _
5.341872,5.658639,5.598281,6.135979,6.112407,6.048102,6.138802,5.89666,5.69863, _
4.770565,4.241429,3.010745,2.140371,1.216494,0.6084834,0.3058194,0.1631041, _
0.08240476,0.0815516,0.08343393,0.0750519,0.07501546,0.07441731,0.0728878, _
0.07488359,0.07782998,0.08244926,0.09279641,0.1098946,0.149767,0.2302302, _
0.3695402,0.6578375,1.119185,2.22784,3.915864,5.304242,5.872996,6.596228, _
6.745116,7.320863,6.586524,6.314111,5.73702,5.614694,4.785239,5.869922,4.540011, _
3.926993,3.237748,2.767061,2.236533,1.757,1.597834,0.9824042,0.908011,0.6785139, _
0.4689712,0.3193968,0.2394752,0.159649,0.09978167,0.07972195,0.03592268, _
0.01999391,0.01023525,0.00374409,0.00179566,6.978841E-04,2.993539E-04, _
1.297398E-04,4.499233E-05,6.984564E-06,3.997885E-06,1.697823E-06,6.987111E-07, _
3.79663E-07, _
 4.850942E-07,8.352399E-07,2.750537E-06,9.303265E-06,2.980902E-05,7.443241E-05, _
1.713194E-04,1.979626E-04,5.947205E-04,0.00106085,0.00317451,0.00850473, _
0.01557027,0.02278096,0.05084305,0.07513943,0.08813114,0.1449224,0.2714199, _
0.2494119,0.3532026,0.3160536,0.6826661,0.5458174,0.6344658,0.6270323,0.7594346, _
0.8633175,1.254619,0.9912015,1.086473,1.617039,1.107236,1.433497,1.497577, _
1.275579,1.581805,1.247971,1.409132,1.083743,0.8932071,0.8077865,0.6899779, _
0.4552339,0.2459272,0.1637248,0.07005347,0.03363346,0.03691045,0.0362456, _
0.02698148,0.02301789,0.0295999,0.02443437,0.03155576,0.02558007,0.02485717, _
0.03549737,0.04508251,0.05466716,0.08636858,0.1606835,0.2666332,0.4078935, _
0.6555058,0.9152209,1.169719,1.1124,1.418115,1.429381,1.345131,1.52112,1.536887, _
1.213064,1.110055,1.008781,1.377009,1.04651,0.8297697,0.8616945,0.6843607, _
0.5886428,0.4304725,0.6588028,0.3886005,0.3793693,0.3145004,0.2103298,0.1197643, _
0.09768484,0.06563038,0.04425594,0.03745532,0.01514313,0.00793206,0.00419329, _
0.00166911,8.196763E-04,3.061391E-04,1.218529E-04,5.173331E-05,1.923567E-05, _
3.297729E-06,1.751211E-06,5.931924E-07,2.848712E-07,1.611371E-07

PU239F:
Data 66, 172, _
 8.680869E-07,2.862627E-06,8.423419E-06,3.124203E-05,8.681548E-05,2.024115E-04, _
5.196785E-04,7.066586E-04,0.00173666,0.00254663,0.00581028,0.01269305, _
0.02291215,0.06073928,0.09228528,0.1420408,0.2189055,0.3153309,0.4777756, _
0.6245013,0.7685531,1.030506,1.31706,1.743756,2.071348,2.520027,3.015737, _
3.781406,4.276312,4.688247,4.859753,5.299067,5.609514,6.005319,6.547979, _
6.669768,6.73131,6.828742,6.576367,5.369249,4.366061,3.221035,2.002562,1.036177, _
0.6475781,0.3570115,0.1889251,0.1276598,0.09426344,0.08140602,0.06035537, _
0.06987054,0.05986282,0.05501733,0.05568852,0.06308457,0.06990402,0.07680782, _
0.120773,0.1778428,0.2666447,0.5009764,0.8788109,1.450814,2.454295,3.878483, _
5.329477,6.970454,7.373923,7.554983,6.929867,6.674805,6.16537,5.627697,5.333657, _
5.147736,4.746747,4.347591,3.674127,3.006336,2.460187,1.990602,1.661006, _
1.241493,0.9968772,0.7849252,0.6266911,0.4258395,0.267246,0.2088174,0.1547517, _
0.1061351,0.06565636,0.03854638,0.01605129,0.00864894,0.00613974,0.00314657, _
0.00179267,8.968647E-04,6.347059E-04,2.668618E-04,7.658663E-05,2.582422E-05, _
7.658345E-06,2.578538E-06,7.663477E-07, _
 3.458204E-07,1.182436E-06,3.814229E-06,1.42055E-05,3.570537E-05,8.25673E-05, _
2.093865E-04,3.046633E-04,8.136244E-04,0.00110281,0.00234772,0.00509559, _
0.00986885,0.02052906,0.04183653,0.05851818,0.07030586,0.1211096,0.1567054, _
0.2126355,0.26833,0.1968474,0.3919345,0.2879908,0.5349211,0.7476287,0.7267264, _
0.6699995,0.6604758,1.049312,0.988911,1.519327,0.7095124,1.40188,1.604566, _
1.409894,1.751976,1.234442,1.271617,1.209076,0.9197497,0.8619414,0.6000009, _
0.3950808,0.1870461,0.1932718,0.09422421,0.05748588,0.03750587,0.03464573, _
0.02816713,0.02604443,0.01906454,0.01955032,0.02561911,0.0204249,0.02149812, _
0.02633876,0.04935167,0.06614785,0.04005666,0.2204903,0.3497962,0.5879004, _
0.62163,0.6741741,0.8368073,0.8772553,0.7472553,0.9678736,1.564204,0.4564373, _
0.4885807,1.201378,1.17938,1.002333,0.6680684,1.133515,0.7943597,0.8088215, _
0.5834385,0.4747615,0.413033,0.4705399,0.3971359,0.3242415,0.168351,0.1908797, _
0.1042461,0.08578604,0.06291512,0.04636193,0.03098983,0.01651703,0.00644659, _
0.00355379,0.00267391,0.00143429,8.040856E-04,3.687291E-04,2.530656E-04, _
1.121814E-04,3.580815E-05,1.150881E-05,2.813283E-06,1.058765E-06,3.171191E-07

PU239HE:
Data 66, 172, _
 6.225972E-05,9.831454E-05,2.176064E-04,3.707943E-04,6.704286E-04,0.00119604, _
0.00218454,0.00375947,0.0058806,0.01022988,0.01641844,0.02370264,0.04146976, _
0.08615795,0.1561051,0.2726443,0.3501312,0.4730066,0.730958,1.029856,1.111199, _
1.285044,1.893307,2.093148,2.136099,2.240457,2.899892,3.182194,3.532176, _
3.940775,4.37921,4.5673,4.849157,4.7645,5.124148,4.997589,5.476413,5.207741, _
5.438741,4.27958,3.577797,2.862293,2.39758,2.475843,1.745581,1.547298,1.392304, _
1.295265,1.256601,1.271724,1.157195,1.151457,1.265308,1.25186,1.248023,1.444536, _
1.460721,1.729728,1.882186,1.954903,2.546901,2.205153,2.718458,3.388101,4.47234, _
4.365778,5.231208,4.865559,6.005656,6.377105,6.197665,4.589047,4.13096,4.133972, _
3.843757,3.560563,3.106279,2.80939,2.70498,2.158801,1.744048,1.709635,1.295557, _
1.055323,0.9937657,0.7376105,0.5399975,0.4577183,0.3269021,0.2331494,0.2139721, _
0.1132989,0.07308692,0.05251003,0.03538582,0.01850494,0.00904885,0.00319492, _
0.00184092,7.370659E-04,5.048872E-04,2.740563E-04,1.376209E-04,6.420609E-05, _
4.804772E-05,3.670801E-05,1.841619E-05, _
 2.494637E-05,3.91926E-05,8.631217E-05,1.486885E-04,2.515695E-04,4.758009E-04, _
8.728283E-04,0.00149398,0.0022982,0.00407081,0.00654688,0.00939287,0.01647092, _
0.02735507,0.06231922,0.1082575,0.1102698,0.1803099,0.2701659,0.3303272, _
0.3627849,0.5170844,0.5686475,0.4842945,0.8114336,0.5956658,0.816141,0.6467261, _
0.9335233,0.8074903,0.8041893,1.205946,1.1353,1.051759,0.9213544,1.114555, _
1.444287,1.095793,1.123902,0.8796615,0.9354994,0.5897084,0.6696419,0.7547658, _
0.6410382,0.6132658,0.5584252,0.5154334,0.5005119,0.4940274,0.4153474,0.3719384, _
0.399611,0.4367349,0.4620193,0.4456702,0.4680686,0.6292778,0.6155633,0.6275371, _
0.4642719,0.7699458,0.7715936,0.8189418,0.9310408,0.8484098,1.007721,1.128263, _
0.9636547,1.343862,1.163839,0.6161253,0.5898976,0.9337742,0.8018152,0.7490985, _
0.7345743,0.5756883,0.7107306,0.6236212,0.6495251,0.6836271,0.4340951,0.4232222, _
0.3948198,0.2953343,0.1937483,0.1816509,0.1032975,0.09260269,0.08564661, _
0.04519067,0.02913633,0.02105113,0.01405461,0.00741182,0.00335813,0.00127094, _
7.382861E-04,2.854978E-04,2.003323E-04,1.096288E-04,5.4665E-05,2.574255E-05, _
1.566118E-05,1.461865E-05,7.391293E-06

PU239T:
Data 66, 172, _
 2.208503E-07,4.489698E-07,1.620852E-06,5.888474E-06,1.991037E-05,3.665489E-05, _
1.214428E-04,2.619899E-04,6.3595E-04,0.0013723,0.00293614,0.00723454,0.0187695, _
0.04362649,0.0937373,0.1837777,0.2297108,0.2966512,0.4732846,0.5807691, _
0.7483376,0.9900881,1.312794,1.719099,2.153562,2.48871,2.988235,3.745615, _
4.358535,4.849266,4.896388,5.41442,5.804398,6.238735,6.777501,6.019096,6.12585, _
6.994607,6.08412,5.654659,4.350492,3.330019,2.163559,1.478,0.6453729,0.2959899, _
0.1285072,0.08166269,0.06025306,0.0425993,0.05067778,0.04445965,0.03248685, _
0.03224954,0.03058468,0.03780659,0.04469353,0.04411842,0.0787171,0.1116571, _
0.2021637,0.5064075,0.7340041,1.37124,2.361852,3.856462,5.406877,7.015683, _
7.665568,7.626193,6.977841,6.716598,6.162849,5.663007,5.366999,5.247752, _
4.919877,4.419634,3.740922,2.989794,2.458402,2.002953,1.641711,1.216911, _
0.9674715,0.7384156,0.5763097,0.3612539,0.2597833,0.1657226,0.1240166, _
0.07415033,0.04143775,0.02065298,0.00968167,0.00484091,0.00223123,9.166919E-04, _
3.295999E-04,1.3432E-04,6.662734E-05,1.521096E-05,4.2853E-06,1.473389E-06, _
3.175225E-07,1.570915E-07,4.940206E-08, _
 8.854489E-08,1.894331E-07,7.539655E-07,2.595472E-06,7.474656E-06,1.496326E-05, _
5.038341E-05,1.158739E-04,2.912174E-04,5.768947E-04,0.00117611,0.00288388, _
0.00837372,0.01483524,0.04076329,0.07577856,0.07799824,0.08720565,0.1544385, _
0.1847408,0.2546199,0.09566308,0.05127024,0.1655047,0.4010099,0.4473761, _
0.1182803,0.1715038,0.236057,1.402812,1.314301,1.435129,1.102259,1.339724, _
0.7749092,0.8015198,1.552163,1.511095,0.8685256,0.8737043,0.9863276,0.7074199, _
0.3303441,0.5202847,0.1352954,0.1593627,0.06322441,0.03684733,0.02409699, _
0.01793614,0.0236012,0.01661196,0.01054606,0.01157451,0.01397192,0.01216359, _
0.01395863,0.01500233,0.03204317,0.040737,0.0301714,0.1297959,0.2520239, _
0.5375128,0.4501397,0.3226009,0.300649,0.5733863,0.5172224,0.7445731,1.234372, _
0.2382042,0.412366,0.5697137,0.5019239,0.624254,0.6183698,0.8588387,0.8122986, _
0.6681643,0.6401421,0.4892944,0.4943874,0.4430864,0.3876983,0.3054338,0.1574376, _
0.1630669,0.1050401,0.06866241,0.05000158,0.03170632,0.01949931,0.00894846, _
0.00394285,0.00200764,9.459495E-04,4.107516E-04,1.513759E-04,5.587345E-05, _
2.66361E-05,6.318093E-06,1.950307E-06,6.624134E-07,1.254374E-07,6.509951E-08, _
2.000929E-08

PU240F:
Data 66, 172, _
 8.870859E-07,1.332534E-06,3.113038E-06,4.889081E-06,1.193644E-05,3.400735E-05, _
1.087675E-04,3.086637E-04,7.83767E-04,0.00170435,0.004092,0.01078649,0.02219437, _
0.04165462,0.07076576,0.1179898,0.1732201,0.2254427,0.3609105,0.4588282, _
0.6077096,0.8421464,0.947188,1.427432,1.831604,2.196237,2.653793,3.443548, _
3.993021,4.460794,4.739962,5.169101,5.470549,5.959893,6.81725,6.479862,6.666604, _
6.612749,6.823414,5.600085,5.095044,3.927546,2.794729,1.746015,0.9416327, _
0.4872109,0.2279719,0.14958,0.09112041,0.06124971,0.06482513,0.0637521, _
0.05899468,0.05855488,0.06707098,0.06803153,0.07599847,0.08694175,0.1098788, _
0.089288,0.2715031,0.4176429,0.6931763,1.149031,2.03139,3.520317,5.042097, _
6.918223,7.465742,7.448484,6.501619,6.693836,6.474196,6.012129,5.507714, _
5.016522,4.877429,4.444355,3.963439,3.080765,2.553768,2.202896,1.772976, _
1.336187,1.085456,0.8504798,0.6511018,0.5145973,0.3095765,0.2355131,0.1739397, _
0.1302769,0.07778389,0.03590435,0.0194006,0.01186752,0.00686406,0.00216679, _
0.00116337,5.701024E-04,3.033264E-04,1.818788E-04,9.094201E-05,9.262151E-05, _
2.01969E-05,1.111758E-05,6.059988E-06, _
 3.567165E-07,5.505192E-07,1.377482E-06,2.244548E-06,5.161971E-06,1.400686E-05, _
4.362184E-05,1.306443E-04,3.677245E-04,7.609533E-04,0.00169617,0.0044034, _
0.00925713,0.0141705,0.03322261,0.04969093,0.05572603,0.08828591,0.1142634, _
0.1556798,0.2384559,0.2251273,0.389144,0.4841171,0.4674676,0.5549454,0.716727, _
0.7285428,0.8772686,1.030877,0.9804219,1.534474,0.8448591,1.348481,1.698975, _
1.382761,1.744268,1.408753,1.359342,1.45679,1.123864,0.8578038,0.5968645, _
0.6436353,0.3741185,0.2713026,0.1181599,0.06800985,0.03702541,0.02530981, _
0.02954128,0.02799708,0.02123002,0.02300756,0.02805061,0.02266667,0.02794651, _
0.03078065,0.04224299,0.03138235,0.07283071,0.17868,0.2806703,0.4821188, _
0.6275632,0.765632,0.9226561,1.28642,1.379887,1.33561,1.208533,0.7487128, _
1.164646,1.338667,1.164059,1.124403,0.8662626,1.15984,1.085509,0.6537195, _
0.7546741,0.6963804,0.3657337,0.5967543,0.4470756,0.3516117,0.2273193,0.2325018, _
0.1397948,0.09848367,0.06956057,0.05434964,0.03609979,0.01625493,0.0081791, _
0.00490339,0.00281992,9.606936E-04,5.508107E-04,2.432483E-04,1.219756E-04, _
7.51308E-05,4.023982E-05,4.253401E-05,8.602778E-06,4.593921E-06,2.431874E-06

PU240HE:
Data 66, 172, _
 6.18112E-05,1.325238E-04,2.453557E-04,5.007295E-04,0.00100157,0.00214526, _
0.00457476,0.00840323,0.01634385,0.03268779,0.05219585,0.07613587,0.1102428, _
0.1592043,0.2204589,0.3001134,0.4027767,0.5072517,0.6064464,0.8839592,1.02171, _
1.225622,1.469872,1.763998,1.991064,2.45524,2.856946,2.831017,3.550421,3.7119, _
4.141405,4.280293,4.736724,4.88851,5.211073,5.396852,5.437108,5.289664,5.207905, _
4.762669,4.021794,3.146933,2.637318,2.295104,1.952286,1.671297,1.568383, _
1.717413,1.248626,1.19282,1.066062,0.8615466,0.9846866,1.004041,1.064989, _
1.166135,1.247784,1.369452,1.536282,1.613512,2.064748,2.002732,2.917076, _
2.860409,4.30879,4.459473,4.58974,5.552468,5.467067,5.340811,5.697428,4.596389, _
5.457705,4.593761,3.852975,3.587233,3.894281,3.10509,2.671574,2.688496,2.129996, _
1.785567,1.510875,1.367679,1.069144,0.8113719,0.6529083,0.5802942,0.4004067, _
0.279434,0.2260454,0.1603263,0.1101984,0.07028597,0.05218976,0.03477363, _
0.02346554,0.01632484,0.01021814,0.00693786,0.00448884,0.00285724,0.00183627, _
0.00115414,7.414392E-04,5.302402E-04,3.672784E-04, _
 2.507928E-05,5.363621E-05,9.855056E-05,2.037755E-04,3.842578E-04,8.648028E-04, _
0.00185827,0.00337691,0.00653008,0.01321526,0.02102503,0.03075423,0.04436146, _
0.05148662,0.08932035,0.1205928,0.1277982,0.1956083,0.2295129,0.2878177, _
0.3391341,0.4998335,0.515372,0.4663405,0.5351402,0.6893776,0.6756659,0.5778307, _
0.92916,0.7734709,0.8566239,1.206018,0.8598081,1.086736,1.244086,1.138755, _
1.552405,1.091177,1.248384,0.9903472,0.859076,0.841507,0.5385993,0.7317971, _
0.4769447,0.6726511,0.5117825,0.6986608,0.5018755,0.4788246,0.4093403,0.2994269, _
0.3155356,0.3845867,0.3746496,0.3674794,0.4556812,0.5158375,0.4874239,0.4954346, _
0.4779025,0.3311376,0.592602,0.7390354,0.8650575,0.7520263,0.7795846,1.25407, _
0.8571225,0.8357825,1.276871,1.040819,1.213539,0.9715437,0.9141026,0.7396647, _
1.026729,0.6527915,0.7507765,0.7181218,0.7602643,0.4663645,0.5432665,0.4355244, _
0.4322897,0.3273138,0.2517708,0.2331724,0.1276131,0.112806,0.09116647, _
0.06524833,0.04431647,0.02848753,0.02153001,0.01398315,0.00933746,0.00658299, _
0.00412625,0.00279338,0.00180234,0.00115992,7.435014E-04,4.64401E-04, _
2.353568E-04,2.135609E-04,1.483842E-04

PU240T:
Data 66, 172, _
 1.597265E-07,3.097852E-07,9.387989E-07,2.974387E-06,9.995162E-06,1.797067E-05, _
5.989953E-05,1.497765E-04,2.994904E-04,8.983754E-04,0.00179788,0.00589355, _
0.01697,0.01595628,0.03863456,0.1100973,0.120093,0.2493714,0.3936183,0.49678, _
0.6664724,0.8154327,1.186349,1.336846,1.873424,2.214412,2.658463,3.391805, _
3.955096,4.71439,4.737209,5.172245,5.916987,5.998755,6.700979,5.925857,6.155492, _
5.965729,6.093924,5.672867,5.268205,4.197064,3.267404,2.148332,1.459942, _
0.3994415,0.1997217,0.109891,0.09986059,0.06993061,0.04993081,0.04297018, _
0.04195859,0.04195937,0.03086458,0.03080889,0.03379636,0.04174232,0.060663, _
0.0607347,0.1390045,0.3585563,0.6966661,1.353808,2.161168,3.339956,4.815279, _
6.71366,7.610041,7.238787,6.829706,6.708979,6.435058,5.992557,5.705688,5.495297, _
4.777723,4.496249,3.930003,3.076677,2.569488,2.123453,1.771369,1.394958, _
1.063843,0.8547112,0.6559417,0.4571708,0.3279743,0.2584008,0.1391382,0.09938595, _
0.0725513,0.04472436,0.02186772,0.00894498,0.00119214,9.1449E-04,3.181589E-04, _
1.095135E-04,6.459225E-05,2.387779E-05,9.244609E-06,3.675022E-06,9.941708E-07, _
2.386007E-07,7.6498E-08, _
 6.416582E-08,1.278074E-07,4.166398E-07,1.374225E-06,4.345173E-06,7.397553E-06, _
2.397725E-05,6.353168E-05,1.414169E-04,4.037927E-04,7.470758E-04,0.00239994, _
0.00708514,0.00544622,0.01826735,0.04650117,0.03867647,0.09691121,0.1726555, _
0.16928,0.2631885,0.3364066,0.4873043,0.5967915,0.4779687,0.7040448,0.7217042, _
0.7176698,1.060181,1.102882,0.9840322,1.524878,1.101399,1.358898,1.676911, _
1.270154,1.603774,1.272742,1.495277,1.47485,1.171444,0.9147113,0.6950452, _
0.7920725,0.4189066,0.2241048,0.105065,0.05026687,0.04080183,0.02887014, _
0.02280791,0.01909189,0.01528666,0.01649673,0.01290505,0.01032454,0.01273853, _
0.01457433,0.0233311,0.02100534,0.07107244,0.1512046,0.282777,0.5619738, _
0.6726923,0.7760014,1.026838,1.228717,1.846925,1.518884,1.254816,1.43759, _
1.547965,1.345446,1.204746,1.240797,1.032191,1.182607,1.064095,0.6518114, _
0.823029,0.6749626,0.4623762,0.6268216,0.440951,0.3525623,0.2766702,0.2081119, _
0.1503475,0.1081585,0.05555392,0.041394,0.03370379,0.02045105,0.00930525, _
0.00368896,4.887786E-04,4.056122E-04,1.51861E-04,4.701487E-05,2.599307E-05, _
9.85446E-06,4.08164E-06,1.697091E-06,4.310045E-07,9.865739E-08,3.061752E-08

PU241F:
Data 66, 172, _
 1.876056E-07,1.314032E-06,2.816988E-06,1.031923E-05,3.285957E-05,8.446396E-05, _
1.501241E-04,4.777285E-04,0.00112659,0.00281548,0.00563157,0.00969329, _
0.01839616,0.03581313,0.06452428,0.09259929,0.1429735,0.2029575,0.3129497, _
0.4887637,0.5801659,0.7815604,0.9564395,1.298776,1.591914,1.936708,2.369013, _
2.887638,3.376962,3.82071,4.306215,4.468308,4.753847,5.570532,5.969599,6.490914, _
6.864937,6.506914,7.27901,6.60963,6.247308,4.906668,3.54115,2.352853,1.400499, _
0.6445846,0.3177857,0.21324,0.1173923,0.1090194,0.09692666,0.0880455,0.0833592, _
0.08238874,0.08650462,0.09158464,0.09465463,0.1017744,0.1131018,0.151115, _
0.223768,0.3322852,0.6583809,1.167463,1.862436,3.362871,4.710133,6.455916, _
7.506952,7.080053,6.431367,6.568322,6.169255,6.373962,5.312863,5.080355, _
4.610234,4.684844,4.171229,3.340222,2.807811,2.224198,1.954226,1.460339,1.23056, _
0.911266,0.7319071,0.5505978,0.3813318,0.3358458,0.2442518,0.1628341,0.1119487, _
0.06513233,0.03969168,0.02340775,0.01178781,0.00522747,0.00331303,0.00153717, _
6.213945E-04,3.106441E-04,1.24275E-04,5.905952E-05,1.65426E-05,5.790651E-06, _
1.656129E-06, _
 7.658071E-08,5.455765E-07,1.210136E-06,4.727268E-06,1.49192E-05,3.526465E-05, _
6.035612E-05,1.997389E-04,5.205976E-04,0.00128967,0.00241798,0.00400168, _
0.00750987,0.0123493,0.03084016,0.04019468,0.04839284,0.08171427,0.09454601, _
0.1664681,0.2486297,0.2618091,0.3890755,0.5598571,0.4104029,0.4747235,0.7031425, _
0.8059016,0.5974137,0.9939655,0.7470695,1.229466,0.8832026,1.193393,1.430959, _
1.468435,1.77106,1.469363,1.408466,1.582315,1.428173,1.053711,0.7640311, _
0.8106518,0.2962604,0.2548844,0.1655927,0.09735768,0.04845992,0.04526793, _
0.04350962,0.03970637,0.03222248,0.03340206,0.03304397,0.03101085,0.04006454, _
0.03737314,0.0388785,0.05102137,0.05855951,0.1383024,0.2664398,0.4987854, _
0.6656869,0.8140703,0.7878706,1.311401,1.407772,1.518638,1.040646,1.044952, _
1.405771,1.53859,1.172744,1.114379,0.9827819,0.8273309,1.092481,0.7198666, _
0.9143011,0.6671507,0.4557818,0.4953158,0.5345644,0.3783589,0.2987568,0.24241, _
0.09625363,0.1445307,0.09876132,0.06757034,0.04940134,0.03005694,0.01793342, _
0.00972386,0.00474632,0.00221193,0.00156541,6.926491E-04,2.604218E-04, _
1.29142E-04,5.162842E-05,2.646373E-05,7.741899E-06,2.466969E-06,6.680306E-07

PU241T:
Data 66, 172, _
 1.671409E-07,5.04729E-07,1.410445E-06,3.641847E-06,1.397829E-05,5.235576E-05, _
2.431344E-05,5.784134E-05,9.468834E-05,2.844872E-04,9.487893E-04,0.00189471, _
0.01151735,0.01494321,0.02910687,0.06218109,0.1367985,0.2012836,0.3295315, _
0.4273018,0.5783352,0.7346503,0.9661501,1.228448,1.590033,1.868657,2.285764, _
2.884391,3.4652,3.949291,4.414053,4.808243,4.991881,6.001462,6.263775,6.231934, _
6.654564,6.775715,7.151231,6.100328,6.108146,4.886318,3.768285,2.587273, _
1.326748,0.5855118,0.2184863,0.1519239,0.07108641,0.03808764,0.02778751, _
0.02362515,0.02315743,0.02315682,0.02562355,0.02587905,0.02588388,0.02670523, _
0.03235074,0.0469015,0.0820796,0.2325286,0.378922,0.8201703,1.81839,3.10116, _
4.564552,6.725917,7.88164,7.181904,6.838293,6.818564,6.64179,6.288313,5.776362, _
4.909019,4.722926,4.587073,4.229491,3.279229,2.769508,2.28495,1.929421,1.476484, _
1.209708,0.9130222,0.7176315,0.5405836,0.3791148,0.2414145,0.1721244,0.1353686, _
0.09224503,0.04802976,0.02049884,0.00846899,1.273367E-05,5.906626E-06, _
1.966927E-06,6.157383E-07,4.145778E-07,1.035821E-07,9.50666E-06,4.024463E-06, _
1.642353E-06,2.192652E-07,7.312835E-08, _
 7.046253E-08,2.12949E-07,6.342884E-07,1.65783E-06,5.428828E-06,2.186537E-05, _
1.019048E-05,2.52817E-05,4.311901E-05,1.240135E-04,3.977605E-04,7.827027E-04, _
0.0048941,0.00508924,0.01309615,0.02615817,0.04439878,0.07893088,0.1025535, _
0.1454952,0.2164755,0.1385368,0.08253044,0.09138194,0.1840172,0.5292929, _
0.476943,0.5492688,0.6135678,1.028368,0.7587938,1.371019,0.8877598,1.30371, _
1.467287,1.384509,1.815755,1.426704,1.631996,1.442711,1.388152,1.041534, _
0.9918757,0.6775531,0.3743199,0.3288596,0.08298954,0.07070176,0.0327067, _
0.01608683,0.01180475,0.01074517,0.00879228,0.00957618,0.00938693,0.00875843, _
0.01070842,0.00992808,0.01081412,0.01556089,0.03473344,0.09157219,0.1498652, _
0.3455395,0.622386,0.7543042,0.7515159,1.277053,0.9483648,1.115277,1.114242, _
0.4863442,0.3384239,0.483924,0.7636299,0.9775592,0.9784357,0.8130687,1.099424, _
0.7146219,0.9276825,0.5480863,0.528002,0.384538,0.5273794,0.3068015,0.3017641, _
0.2311893,0.126817,0.1075394,0.07224085,0.05708849,0.03881399,0.02158204, _
0.00935782,0.00360276,5.358399E-06,2.477056E-06,8.543903E-07,2.83481E-07, _
1.819291E-07,4.341582E-08,4.004561E-06,1.703636E-06,7.429292E-07,9.919094E-08, _
3.087448E-08

PU242F:
Data 66, 172, _
 2.889856E-06,5.791355E-06,8.693542E-06,1.158401E-05,2.891611E-05,5.793362E-05, _
1.25433E-04,2.415287E-04,7.725079E-04,0.00115831,0.00241313,0.006829,0.01348791, _
0.03372851,0.05432862,0.09209882,0.1257247,0.1778687,0.2922093,0.3719808, _
0.5230251,0.6155801,0.7890354,1.101475,1.414309,1.813205,2.128047,2.676351, _
3.217655,3.654649,4.303299,4.475908,4.783007,5.483025,6.096469,5.990137, _
6.419559,6.542945,6.438879,7.008796,5.76495,5.02725,4.395261,3.192894,2.080813, _
1.222247,0.6535766,0.318057,0.13305,0.1091528,0.09754846,0.09826714,0.08779444, _
0.08779282,0.08291627,0.08202187,0.08387063,0.08844041,0.1005201,0.1288967, _
0.1680766,0.277498,0.516961,1.230873,2.0047,3.107153,4.484683,6.639594,7.362753, _
7.028082,6.649417,6.455123,6.228567,6.091946,5.460069,5.025118,4.572553, _
4.555168,4.258991,3.393569,2.912566,2.370548,1.998196,1.576114,1.320261, _
0.9879605,0.7903996,0.6233218,0.4356885,0.3281637,0.2370087,0.164082,0.1093884, _
0.06563193,0.04102097,0.02370128,0.01276153,0.00546891,0.00136678,9.374737E-04, _
4.558732E-04,1.820761E-04,7.294433E-05,4.377063E-05,2.093565E-05,1.184966E-05, _
6.384152E-06, _
 1.201431E-06,2.425976E-06,3.60025E-06,5.076488E-06,1.306595E-05,2.442814E-05, _
5.127339E-05,1.006748E-04,3.362431E-04,5.204661E-04,0.00105426,0.0028382, _
0.00551189,0.01199162,0.0248703,0.04042236,0.04498686,0.07345621,0.1026524, _
0.125405,0.2292711,0.2580669,0.3189633,0.4601469,0.4763968,0.4965347,0.7505822, _
0.7037907,0.5884319,0.9623714,0.9357478,1.171549,0.9343839,1.160093,1.397889, _
1.362632,1.631264,1.370416,1.645367,1.566514,1.367953,1.068309,0.989629, _
0.7847964,0.5953156,0.3454621,0.256914,0.1547353,0.05993726,0.04582457, _
0.04003325,0.0428482,0.03874607,0.03645785,0.02690889,0.02851479,0.03764307, _
0.03519097,0.03231283,0.04418323,0.06730811,0.1036434,0.1986444,0.407087, _
0.7516432,0.7864347,0.7720966,1.340674,1.379326,1.537067,1.191243,1.225886, _
0.9115322,1.579499,1.205548,1.08529,1.004313,0.9604422,1.10699,0.7429699, _
0.7841032,0.6451436,0.5368817,0.5256861,0.5781055,0.3305049,0.3231108,0.263978, _
0.1453819,0.1420343,0.09748066,0.06866709,0.04610299,0.02922671,0.01851924, _
0.00989589,0.00521274,0.00227866,6.108067E-04,4.194852E-04,1.941871E-04, _
7.602778E-05,2.988467E-05,1.870489E-05,9.559196E-06,5.100912E-06,2.62233E-06

PU242HE:
Data 66, 172, _
 2.078047E-07,4.176738E-07,7.329608E-07,1.55879E-06,3.119995E-06,5.221397E-06, _
1.138691E-05,1.861135E-05,5.226319E-05,5.218268E-05,2.096057E-04,0.00518265, _
0.01453494,0.029151,0.05419683,0.09225433,0.1346615,0.2190052,0.2225359, _
0.7975692,0.7993203,0.9818854,1.129261,1.342445,1.605345,2.139168,2.388227, _
2.53736,2.901626,3.418199,3.875924,4.271199,4.519655,5.168239,5.075411,5.08594, _
5.368128,5.675316,5.475249,5.581331,5.069857,3.83465,3.037836,2.543533,2.33435, _
2.234185,1.932371,1.780167,1.425522,1.237393,0.9164058,0.8103119,0.7127608, _
0.6109374,0.6109397,0.6474499,0.7758396,0.8807051,1.076352,1.329445,1.564449, _
1.987632,2.461395,2.658609,2.938601,3.781458,5.269388,5.556796,5.898229, _
6.192919,5.371401,5.282886,5.25585,4.936516,4.886029,4.828543,4.295112,3.639548, _
3.167291,2.569991,2.158325,1.956934,1.759793,1.594553,1.274397,0.9051966, _
0.8725941,0.6592931,0.455775,0.3684291,0.2714731,0.1783957,0.1192556,0.073589, _
0.04581278,0.02685651,0.01396056,0.00611747,0.00305441,0.00203448,0.00102716, _
3.975716E-04,1.724583E-04,9.670737E-05,4.584731E-05,1.970825E-05,1.531853E-05, _
 8.465135E-08,1.729085E-07,2.996019E-07,6.38726E-07,1.257975E-06,2.124234E-06, _
4.695466E-06,7.652593E-06,2.123794E-05,2.158923E-05,8.569824E-05,0.00211758, _
0.00600988,0.01041079,0.02235007,0.03793282,0.04605676,0.08935639,0.07533582, _
0.2605811,0.3113015,0.3977789,0.4683628,0.5465954,0.6559602,0.5093921,0.6798666, _
0.6712206,0.6031318,0.8943616,0.7945521,1.175386,0.8210819,1.071823,1.083507, _
1.081344,1.450048,1.289789,1.395854,1.238255,1.088234,0.8037307,0.7920746, _
0.6147116,0.6949754,0.6233474,0.4032905,0.5153239,0.6425152,0.6128507,0.379347, _
0.3293703,0.2831123,0.2485439,0.1991536,0.2118811,0.2870815,0.314392,0.4140742, _
0.4585042,0.6249226,0.4055461,0.9501359,0.6969593,0.8641375,0.7312637,0.8133894, _
1.098781,1.183634,1.089822,1.016689,1.098709,1.043287,1.065132,1.022832, _
1.126648,0.8952647,0.7989092,0.6815414,0.7575712,0.6919027,0.797277,0.4524531, _
0.6536412,0.5215589,0.3741658,0.3543572,0.2725841,0.1724039,0.1507833,0.1122755, _
0.07264199,0.04917868,0.03026071,0.01867915,0.01111653,0.00569994,0.00250769, _
0.00126254,8.279724E-04,4.237608E-04,1.633278E-04,7.03215E-05,4.004067E-05, _
1.705721E-05,8.085086E-06,6.333014E-06

PU242T:
Data 66, 172, _
 4.971499E-08,9.9395E-08,2.282874E-07,4.976315E-07,1.789031E-06,2.685271E-06, _
9.950019E-06,2.987626E-05,7.956223E-05,1.992847E-04,4.171507E-04,0.00268942, _
0.00646157,0.00743709,0.01957375,0.04094576,0.06070523,0.1389209,0.2349071, _
0.3778232,0.4820568,0.6646816,0.8396089,0.920763,1.286674,1.696459,2.02465, _
2.550987,3.241914,3.81955,4.276957,4.531751,5.563276,6.04909,6.16162,6.094092, _
6.13377,6.233124,6.212528,6.044531,5.940906,5.485682,4.447323,3.503704,2.607383, _
1.105912,0.3979169,0.2590416,0.149219,0.119559,0.07970504,0.04987071,0.04981701, _
0.04981558,0.03586747,0.02473799,0.02474312,0.03167963,0.04063903,0.05559311, _
0.1185863,0.208643,0.4150355,0.8443568,1.630638,2.617253,3.970382,5.848285, _
7.385812,7.531796,7.074927,6.9382,6.651304,6.444174,6.036258,5.305358,4.644698, _
4.559638,4.18922,3.464757,2.810811,2.387707,1.986967,1.601747,1.261253,1.022541, _
0.8017054,0.6235491,0.4354946,0.3167224,0.237542,0.1682581,0.118772,0.07917951, _
0.05146779,0.02474397,0.00890723,0.00395928,0.00148546,2.976695E-04,1.38527E-04, _
3.96352E-05,1.286965E-05,3.46899E-06,1.979013E-06,9.893542E-07,4.944756E-07, _
 2.080439E-08,4.157852E-08,9.474828E-08,2.21502E-07,8.318688E-07,1.143152E-06, _
4.048249E-06,1.246243E-05,3.515623E-05,9.144685E-05,1.857035E-04,0.00111812, _
0.00262765,0.0026464,0.0091681,0.01830389,0.02224458,0.05727012,0.08590576, _
0.1285965,0.2193461,0.2791193,0.3411281,0.3859689,0.5943229,0.4559967,0.8473306, _
0.6711061,0.6883991,1.024528,1.111724,1.180884,0.8906966,1.283454,1.427818, _
1.420666,1.537525,1.302955,1.622158,1.351146,1.448026,1.1791,0.9782066, _
0.8571371,0.749533,0.6076112,0.2250132,0.1308064,0.06844458,0.05561797, _
0.03246866,0.02178692,0.02297903,0.0208854,0.01150571,0.00877454,0.01144855, _
0.01297598,0.01319705,0.01882704,0.04787643,0.07672767,0.1611293,0.3641367, _
0.623251,0.6994708,0.9196327,1.195683,1.803294,1.698937,1.280152,1.546804, _
1.448128,1.546231,1.37584,1.133097,1.047492,0.9685628,1.104393,0.952886, _
0.7304237,0.6341277,0.6116891,0.4215744,0.5750533,0.4267373,0.3257253,0.262966, _
0.2028362,0.1418565,0.09903727,0.07038763,0.04957979,0.03537323,0.02411754, _
0.01050101,0.00362283,0.00165016,6.607044E-04,1.365217E-04,6.133654E-05, _
1.651866E-05,5.236419E-06,1.476292E-06,9.251471E-07,4.405036E-07,2.054155E-07

TH227T:
Data 66, 172, _
 8.52473E-08,2.157486E-07,8.235662E-07,2.348944E-06,5.197259E-06,1.273913E-05, _
5.691525E-05,9.361161E-05,2.648542E-04,7.847611E-04,0.00225602,0.01089143, _
0.03720397,0.6434287,1.882635,3.485717,4.883939,5.652719,6.089515,6.781999, _
6.986066,7.061135,7.064992,7.65627,7.706656,6.170123,4.723169,4.368998,3.679965, _
3.388658,2.613838,2.38309,1.363788,1.435981,0.9368855,0.749314,0.5816461, _
0.56993,0.3115199,0.2796191,0.173294,0.0940906,0.05388883,0.03374447,0.03531358, _
0.04098927,0.02871351,0.03669637,0.03030321,0.03021461,0.03232394,0.03827207, _
0.04747581,0.06345081,0.08383914,0.1135956,0.1091422,0.2212154,0.31372,0.500067, _
0.5690891,0.6731641,0.9262833,1.428623,1.864073,2.626347,3.388653,4.839018, _
5.726812,6.770896,7.565365,7.058391,7.254691,7.558729,7.748536,7.641498, _
7.442986,6.994688,5.967237,3.106312,1.037378,0.1833941,0.03131262,0.01010278, _
0.00202082,5.046262E-04,2.018037E-04,1.010362E-04,4.03827E-05,1.009376E-05, _
5.048839E-06,1.519412E-06,5.757E-07,2.017371E-07,1.009449E-08,6.057821E-09, _
3.030101E-09,1.010881E-09,6.056001E-10,3.0251E-10,1.008E-10,5.979E-11,3.009E-11, _
9.54001E-12,4.03E-12,1.55E-12,0, _
 3.160201E-08,9.355202E-08,4.53105E-07,1.198836E-06,2.384296E-06,4.928726E-06, _
2.592571E-05,4.727435E-05,1.465114E-04,3.450628E-04,8.394084E-04,0.00429683, _
0.02027676,0.2389224,0.51541,0.7087514,1.504425,1.270151,1.246322,1.201847, _
1.214673,1.49977,1.865656,1.566007,1.9616,1.321032,1.028115,1.042543,1.050222, _
0.9456066,0.7141485,0.8111259,0.3599291,0.3072631,0.4006892,0.3054477,0.234155, _
0.2724319,0.1067268,0.1196312,0.09609705,0.04618447,0.02176372,0.01205833, _
0.01913696,0.02092436,0.01274194,0.01459509,0.01537932,0.01571634,0.01637774, _
0.01265551,0.01821914,0.02279439,0.04697246,0.0381253,0.03536021,0.07458138, _
0.1691023,0.1291738,0.1726008,0.3020222,0.3822109,0.5305858,0.5399001,0.7183899, _
0.3788667,1.011345,1.468369,1.415786,1.594672,1.754794,2.046288,1.716305, _
1.462612,1.63451,2.086975,1.900936,1.435687,0.8582152,0.4473168,0.0923572, _
0.0173838,0.00450614,7.575799E-04,2.116859E-04,1.083554E-04,5.247907E-05, _
1.988065E-05,4.041168E-06,2.077479E-06,7.279908E-07,3.240871E-07,9.624418E-08, _
4.134612E-09,2.428438E-09,1.522357E-09,5.253205E-10,3.2466E-10,1.264138E-10, _
3.782351E-11,2.698579E-11,1.682039E-11,5.105018E-12,2.5792E-12,9.92001E-13,0

TH229T:
Data 66, 172, _
 3.021744E-08,7.18874E-08,2.703013E-07,1.145194E-06,3.645054E-06,1.560674E-05, _
7.187618E-05,2.600093E-04,0.0010411,0.00338304,0.01197313,0.04205552,0.2557194, _
0.422642,1.633482,2.300182,3.457586,5.194316,9.213787,9.34447,8.187587,7.19124, _
8.173024,9.198595,8.393294,6.615963,5.942635,4.830236,4.144693,2.679188, _
1.381865,0.7314557,0.2711253,0.1523838,0.03603429,0.01308176,0.00655119, _
0.00598422,0.01003016,0.00817424,0.01201761,0.0108121,0.01173153,0.01289036, _
0.01691478,0.02164984,0.02083577,0.01700316,0.02148558,0.01983129,0.01961891, _
0.02274667,0.01693086,0.01571257,0.01467822,0.01331039,0.01367158,0.01289344, _
0.01110501,0.00564322,0.01904016,0.03891911,0.0519346,0.1188127,0.4172659, _
0.6043554,1.20402,2.965704,5.960552,5.797479,5.83996,7.289948,7.893322,8.512355, _
7.939632,7.462582,7.285674,8.317463,9.760325,5.022272,3.379773,2.11435,1.021262, _
0.5884569,0.178462,0.03799855,0.00975603,0.00205822,4.832186E-04,9.847096E-05, _
2.598127E-05,7.156616E-06,1.792886E-06,5.277774E-07,1.342427E-07,3.573675E-08, _
8.863346E-09,2.689573E-09,8.946646E-10,2.683014E-10,7.13004E-11,1.780009E-11, _
5.16003E-12,1.50001E-12,1.33001E-12,0,0, _
 1.276929E-08,2.747918E-08,1.380888E-07,6.165263E-07,2.00701E-06,6.622505E-06, _
2.696993E-05,1.206709E-04,5.910043E-04,0.00176467,0.00547938,0.01502725, _
0.08813035,0.1559103,0.4906292,0.6409112,0.7509549,0.4709608,0.467,1.314035, _
1.689201,0.914705,0.4628946,0.5050144,0.5235888,0.9742175,0.8059707,0.47232, _
0.8627397,0.3864391,0.5089365,0.1746442,0.09506948,0.08739492,0.02216217, _
0.00780533,0.00383654,0.00299127,0.00397318,0.00333143,0.00665276,0.00575636, _
0.00540981,0.00429637,0.00885664,0.01172034,0.01069851,0.00636728,0.01013533, _
0.01056076,0.01084928,0.00875496,0.00624681,0.00567916,0.00838316,0.00465296, _
0.00495082,0.00424456,0.00579625,0.00236217,0.0114972,0.01798618,0.02250572, _
0.05191078,0.1402678,0.1627237,0.2236507,0.3287834,0.3131618,1.241212,1.063538, _
0.8208159,0.6394867,0.6388672,1.509344,1.254605,0.6657038,1.284661,2.036542, _
1.113311,0.7010218,0.4748755,0.2123549,0.2179306,0.0804207,0.01423351, _
0.00487716,0.00110411,2.678666E-04,4.273349E-05,9.66774E-06,3.24493E-06, _
1.00996E-06,2.806752E-07,6.547866E-08,1.329963E-08,4.027207E-09,1.39151E-09, _
5.100343E-10,1.285917E-10,2.798573E-11,7.209693E-12,3.30242E-12,9.60005E-13, _
8.51204E-13,0,0

TH232F:
Data 66, 172, _
 1.133007E-06,3.901269E-06,1.428673E-05,3.30318E-05,6.538691E-05,1.660977E-04, _
4.141246E-04,6.204804E-04,0.00115374,0.00283551,0.00673924,0.01176571, _
0.03515567,0.07648633,0.1867836,0.4709285,1.076082,2.15668,3.168877,4.97689, _
6.373123,6.951019,6.912892,7.526154,8.43059,7.462611,6.884263,6.415471,5.778937, _
5.752594,4.815221,4.466406,3.644961,2.983161,1.374787,0.713527,0.3677751, _
0.1553261,0.08904449,0.0525419,0.04891834,0.05107361,0.06123567,0.06595311, _
0.071366,0.0716184,0.07826046,0.07806502,0.073421,0.07700252,0.07379941, _
0.07381944,0.06327894,0.0572095,0.05432512,0.04880609,0.03652791,0.02936546, _
0.02647524,0.03295339,0.04797856,0.1014778,0.1822266,0.2521417,0.9440851, _
1.620837,2.970646,4.020586,5.204022,5.604632,5.544904,5.729562,6.47384,7.257795, _
7.908733,7.509957,6.463204,6.634217,7.889151,5.448672,4.581377,2.97859,1.999624, _
1.088533,0.5626237,0.3636493,0.07554483,0.0310079,0.00687556,0.00361702, _
0.00269088,9.322601E-04,4.641866E-04,9.771481E-05,6.91972E-05,1.448792E-05, _
7.976879E-06,4.651239E-06,2.031633E-06,3.536647E-07,1.386452E-07,9.765603E-08, _
5.301497E-08,2.689126E-08,1.068076E-08,4.640439E-09,2.389952E-09, _
 5.193934E-07,1.655818E-06,5.921557E-06,1.411545E-05,3.112462E-05,7.6159E-05, _
1.765915E-04,2.663262E-04,4.836056E-04,0.00127554,0.00325522,0.00508842, _
0.01458016,0.03035639,0.08429156,0.2189349,0.4451476,0.584229,0.8824022, _
0.8775352,1.626516,1.403283,1.51267,1.651877,1.042628,0.7617027,0.6826069, _
1.314983,1.248185,1.026032,1.255753,1.109064,0.9997987,0.8147248,0.6430492, _
0.3706189,0.209355,0.06008923,0.0421534,0.02376068,0.0202993,0.02249879, _
0.02970093,0.02863335,0.02958734,0.03040952,0.03737519,0.03527465,0.03063658, _
0.03296429,0.03212612,0.03416676,0.02862408,0.02422637,0.01753987,0.01801665, _
0.01701917,0.01316697,0.0096728,0.01041067,0.01767,0.03476036,0.06554161, _
0.08247717,0.3829779,0.5377102,0.5432513,0.9996557,1.295882,0.7449292,1.266844, _
0.8815026,1.414951,0.8689637,0.5369562,1.057105,1.2148,1.462836,1.415527, _
1.428399,1.139786,0.6472784,0.4813013,0.4667608,0.2712137,0.1637973,0.03162161, _
0.01329291,0.00296872,0.00168003,0.0012584,3.956016E-04,1.924281E-04, _
4.150665E-05,3.254337E-05,6.715208E-06,3.452687E-06,1.99197E-06,8.460199E-07, _
1.567761E-07,6.728524E-08,4.287126E-08,2.204231E-08,1.149291E-08,4.663866E-09, _
2.162884E-09,1.114856E-09

TH232HE:
Data 66, 172, _
 1.286217E-04,2.240238E-04,7.598372E-04,0.00151501,0.00278268,0.00530429, _
0.00787331,0.01626199,0.03021294,0.05304221,0.09064306,0.1309696,0.2486686, _
0.4120986,0.6739323,1.060875,1.375823,1.734673,1.176508,5.660922,5.249033, _
4.957835,5.064425,5.817682,6.533974,6.064689,5.433561,5.394196,5.546947, _
5.016028,3.817282,3.416977,2.688992,2.072184,1.645356,1.357788,1.02374, _
0.8859082,0.9451335,1.094613,1.199567,1.177843,1.27801,1.408837,1.38878, _
1.303289,1.471981,1.418936,1.331016,1.312196,1.27237,1.429681,1.113324,1.060307, _
0.9754855,0.9480711,0.847409,0.8076228,0.7966103,0.7209816,0.8751265,1.080389, _
1.160634,1.254578,2.44766,2.816572,3.429878,4.651662,6.582761,5.258525,6.395394, _
5.677941,5.781333,5.89215,6.010815,6.132499,5.368108,5.132715,4.218753,2.660497, _
2.461104,1.864806,1.066835,0.8148642,0.4106772,0.2325206,0.1293815,0.08958393, _
0.05517197,0.03165603,0.01831283,0.01061205,0.00624876,0.00455038,0.00172454, _
0.00105786,5.100076E-04,2.556052E-04,1.318793E-04,7.263546E-05,2.970711E-05, _
1.595798E-05,8.013707E-06,3.877542E-06,1.740338E-06,8.18438E-07,3.819301E-07, _
 5.375992E-05,9.226186E-05,3.191074E-04,6.278526E-04,0.00115014,0.00222823, _
0.00324255,0.006801,0.0125822,0.02191937,0.03807953,0.05389027,0.1043222, _
0.1575577,0.2786013,0.4472736,0.4923445,0.4536459,0.3915805,1.41942,1.263695, _
0.8538878,0.8814065,1.010506,1.38189,0.7210722,0.9220845,1.243032,1.207342, _
1.022285,0.9820173,0.8353009,0.8906862,0.551074,0.6765383,0.5631577,0.4179616, _
0.3651132,0.3096015,0.4558899,0.4946341,0.4929222,0.5289066,0.5816849,0.5830148, _
0.5368637,0.4759863,0.5930729,0.5484096,0.5545617,0.5273577,0.5868207,0.4563886, _
0.437607,0.3267779,0.3874412,0.2861675,0.3332959,0.298352,0.2794218,0.3027228, _
0.3422695,0.3420725,0.3371445,0.7109636,0.7165456,0.864158,0.9278039,1.359136, _
0.901371,1.121893,0.6335868,0.9405698,0.8452796,0.6958012,1.257963,1.133841, _
1.066997,0.9425659,0.7398184,0.8287126,0.4927653,0.4384218,0.3396279,0.1695839, _
0.0966533,0.05414933,0.0368843,0.02280551,0.0131245,0.00758505,0.00445901, _
0.00257434,0.00190083,7.205205E-04,4.357401E-04,2.141604E-04,1.059623E-04, _
5.463215E-05,3.052615E-05,1.223531E-05,6.66493E-06,3.345639E-06,1.597026E-06, _
7.174596E-07,3.39121E-07,1.583046E-07

U232T:
Data 66, 172, _
 0.00699599,0.00899462,0.01299275,0.01798943,0.02500403,0.03498069,0.04697309, _
0.06797189,0.0899522,0.129929,0.1709869,0.2499102,0.3497758,0.4797845,0.6401711, _
0.7997437,1.14422,1.499328,1.783741,2.691712,3.309161,4.362436,6.203865,6.96727, _
6.621186,7.161239,6.828914,7.27725,6.257245,6.208402,5.835437,5.433277,4.694567, _
4.214785,3.001459,1.999355,1.499457,1.061154,0.3497061,0.2434205,0.09994796, _
0.02598541,0.00819299,0.0089967,0.00829874,0.00914165,0.01099453,0.01399274, _
0.01599017,0.01878236,0.01547944,0.0144998,0.01143336,0.00870024,0.00811989, _
0.00863698,0.0144379,0.01905816,0.03156144,0.1583156,0.2286409,0.382981, _
1.062887,1.765775,3.01339,3.748975,5.17128,5.804564,5.234876,5.318989,7.125771, _
7.869682,5.646495,7.126929,7.304661,6.914626,6.350093,5.088131,4.330334, _
3.116057,2.505122,1.205581,0.952775,0.6670303,0.5112295,0.343031,0.2668023, _
0.1905701,0.134038,0.1048135,0.07622808,0.05240694,0.03335237,0.02096252, _
0.01454845,0.00857594,0.00571589,0.00352565,0.00238371,0.00171536,0.0011434, _
7.626057E-04,4.760448E-04,3.044366E-04,2.115891E-04,1.429331E-04,9.529766E-05, _
 0.00272239,0.00376563,0.00608709,0.00790514,0.00921698,0.01368251,0.01992844, _
0.0306275,0.03981127,0.05282808,0.06648523,0.09703864,0.1650393,0.1625985, _
0.2552475,0.3134701,0.4674033,0.5776697,0.4359609,0.6461703,0.8846208,0.7705545, _
0.6443098,0.755783,1.329584,1.440872,1.022644,0.8082206,0.7949488,1.305458, _
0.9159689,1.104127,1.151371,0.9369702,0.7491584,0.5391697,0.5814707,0.2336155, _
0.2013356,0.1321755,0.04819944,0.01049111,0.00343229,0.00296758,0.00348125, _
0.00369279,0.00426912,0.00579191,0.00746915,0.00798391,0.00547613,0.00439042, _
0.00477088,0.00287979,0.00328276,0.00277633,0.00449052,0.00686126,0.01501417, _
0.06415561,0.1313875,0.1639675,0.3925741,0.4537759,0.9313079,0.7516722,0.615732, _
1.098876,0.5576672,0.7012957,1.724299,1.779985,0.5311911,0.5418366,1.319966, _
1.54207,1.532696,1.069967,0.5930902,0.5657784,0.3816311,0.5387525,0.3370778, _
0.2683394,0.2170037,0.1544047,0.1178047,0.07804435,0.04260182,0.04324964, _
0.03534988,0.0234365,0.01397065,0.00842865,0.0059025,0.00376253,0.0026575, _
0.00148444,9.313944E-04,6.6712E-04,5.086235E-04,3.456067E-04,2.100035E-04, _
1.230362E-04,6.970409E-05,6.05875E-05,4.504663E-05

U233F:
Data 66, 172, _
 3.990206E-07,1.595608E-06,4.876099E-06,1.33007E-05,5.311572E-05,2.306885E-04, _
6.825146E-04,0.00156421,0.00372521,0.01108587,0.01970295,0.03725962,0.06206219, _
0.09750607,0.2115055,0.3702676,0.5922709,0.9923115,1.607457,2.159054,2.732672, _
3.809744,5.059229,5.809892,6.427629,6.454555,6.511715,6.903808,6.804344, _
6.295399,5.726004,5.429347,5.128244,4.708515,4.35867,3.893539,2.935405,1.664362, _
1.278235,0.8564113,0.3252559,0.145756,0.09749974,0.08524445,0.07992221, _
0.07368706,0.06485697,0.06263088,0.05586994,0.05477973,0.06548506,0.06572292, _
0.07068113,0.074922,0.07091754,0.08033518,0.07264647,0.07580675,0.1033842, _
0.14614,0.2844718,0.7396435,1.182897,1.738086,2.793121,3.742407,5.037387, _
6.037808,6.309772,6.420922,6.942595,6.828384,6.58843,5.898303,6.005381,6.248189, _
6.116155,5.52932,4.380434,3.201052,2.38166,1.685956,1.197376,0.7107698, _
0.4698641,0.3082855,0.1921871,0.1034521,0.04362486,0.02274118,0.01756587, _
0.01012125,0.00331722,0.00173391,4.187558E-04,9.47911E-05,2.271804E-05, _
1.042256E-05,3.501234E-06,1.156219E-06,6.721352E-07,9.381635E-08,2.46295E-08, _
8.24388E-09,2.46255E-09,7.5803E-10,2.8447E-10, _
 1.538013E-07,6.62439E-07,2.347962E-06,6.27143E-06,2.255496E-05,9.221398E-05, _
2.756537E-04,7.018276E-04,0.00184909,0.00486832,0.00779141,0.01462617, _
0.02833217,0.03387581,0.09825916,0.1499941,0.2013492,0.2540734,0.307221, _
0.7475842,0.7140064,0.4656757,0.7047985,1.519135,1.438826,1.408811,1.195785, _
0.9709059,1.392607,1.370816,1.066888,1.341782,0.8068678,1.217615,1.071756, _
0.8473003,0.6924706,0.4704691,0.1389498,0.4899321,0.09329432,0.06964612, _
0.04002266,0.03153998,0.0385619,0.03399609,0.02643412,0.02532612,0.02530511, _
0.0258048,0.028495,0.02104291,0.02565192,0.02581293,0.03437277,0.02595372, _
0.02135509,0.02576227,0.04754187,0.05848376,0.03017967,0.3321453,0.4723935, _
0.6423847,0.8076133,0.9250011,0.8021538,1.248829,0.8110638,1.372073,1.342915, _
1.243933,1.247658,1.259664,1.157705,1.323405,0.8455265,1.313096,0.9501443, _
0.8591336,0.5110483,0.4509994,0.4140924,0.2991765,0.1811348,0.127874,0.05099411, _
0.04823807,0.01721294,0.00916608,0.0073582,0.0046627,0.00163939,7.401162E-04, _
1.619784E-04,3.888274E-05,1.070448E-05,4.943691E-06,1.584508E-06,4.662498E-07, _
2.659748E-07,4.136953E-08,1.230054E-08,3.695357E-09,8.728897E-10,3.061565E-10, _
1.252996E-10

U233HE:
Data 66, 172, _
 6.694245E-04,0.00151467,0.00180277,0.00289945,0.00470379,0.00744545,0.01303136, _
0.01874737,0.0280824,0.04349855,0.06696913,0.1019584,0.1548128,0.2306241, _
0.335923,0.5424325,0.8383964,1.304888,1.984658,2.197735,2.637624,3.342733, _
3.961968,4.664592,4.807177,5.18482,5.455565,5.318841,5.08872,5.068744,4.819321, _
4.836758,3.935919,3.794008,3.088392,2.743745,2.507092,2.531972,1.971554, _
1.811293,1.387908,1.422649,1.431278,1.502362,1.322948,1.412377,1.690539, _
1.702444,1.228654,1.447279,1.381761,1.320992,1.285069,1.220152,1.159647, _
1.709819,1.235142,1.35142,1.514458,1.516258,2.310707,2.228019,2.541648,2.834433, _
3.200194,4.066984,3.983501,4.560313,4.983166,5.133527,5.653897,5.112441, _
6.409112,5.872849,5.029917,4.464476,4.395474,3.219949,2.47872,2.025789,1.629165, _
1.241184,0.8841757,0.6169577,0.4460758,0.3420161,0.2168181,0.1428683,0.09765298, _
0.06537434,0.04362319,0.02775977,0.01708082,0.01064964,0.00716245,0.00467251, _
0.00274854,0.00170597,0.0010471,6.258979E-04,2.635901E-04,2.178503E-04, _
1.327075E-04,8.281634E-05,4.360791E-05,2.367448E-05,2.272324E-05, _
 2.717469E-04,6.138603E-04,7.240465E-04,0.00118102,0.00180729,0.00300254, _
0.0052977,0.00753879,0.01122714,0.01758717,0.02700305,0.04117838,0.06228963, _
0.07399389,0.1358349,0.2186204,0.2681003,0.4954116,0.3854659,0.5545288, _
0.8406943,0.560778,0.6075649,1.040942,0.9542544,1.187744,1.140164,1.10976, _
1.1259,1.046308,0.8920636,1.293728,0.929476,0.9718774,0.7625535,0.735927, _
0.8122036,0.5229231,0.4669354,0.7326129,0.4864172,0.5778785,0.579748,0.5071911, _
0.5252791,0.5689149,0.551748,0.6725137,0.4940676,0.5830668,0.5254472,0.4485957, _
0.4085048,0.4537398,0.422856,0.5522321,0.429191,0.5041983,0.4853059,0.4785194, _
0.5174385,0.4689645,0.7280339,0.7044284,1.016016,0.7922196,0.6355253,1.083851, _
0.7370925,1.045277,1.285444,1.141082,1.115201,1.390593,0.9609333,0.9532461, _
0.9726492,0.6649344,0.6514422,0.4825387,0.6084086,0.5055466,0.3106531,0.2508628, _
0.1804545,0.1350367,0.08449886,0.05748339,0.03142098,0.02648903,0.01757326, _
0.01130453,0.00687358,0.00432201,0.00295989,0.00188582,0.00107092,6.861753E-04, _
4.263025E-04,2.475881E-04,1.059992E-04,8.86353E-05,5.337426E-05,3.364856E-05, _
1.413308E-05,9.534359E-06,9.249835E-06

U233T:
Data 66, 172, _
 2.502551E-07,1.119579E-06,3.423429E-06,9.405139E-06,3.667369E-05,1.618443E-04, _
4.16721E-04,0.0011557,0.00270854,0.00798039,0.01384595,0.02595825,0.05381089, _
0.1434735,0.2336686,0.3679972,0.586514,1.013669,1.637075,2.286758,2.793725, _
3.991101,5.458866,6.371397,6.836402,6.491316,6.523192,6.947972,6.875684,6.36354, _
5.679286,5.514951,5.178917,4.924585,4.460056,3.171171,2.402636,1.573172, _
0.9787734,0.4972616,0.2462747,0.1145293,0.07573259,0.03937386,0.03872445, _
0.02159965,0.01330408,0.01356184,0.01285886,0.0149809,0.0132005,0.01412358, _
0.01541667,0.01855763,0.02182876,0.02308055,0.04096749,0.06041372,0.07462078, _
0.1169592,0.225923,0.5556166,0.8356572,1.592379,2.091663,3.604288,4.953441, _
5.949944,6.300451,6.262645,6.797548,6.839653,5.920187,6.324751,6.424557, _
6.480861,6.665506,5.969125,4.725947,3.447068,2.586059,1.738358,1.301229, _
0.7784272,0.5057133,0.3157159,0.213634,0.1036818,0.04668831,0.02142904, _
0.01279465,0.00630303,0.0020549,8.8602E-04,3.165138E-04,1.215751E-04, _
1.271548E-05,5.927062E-06,1.951632E-06,6.321492E-07,3.674433E-07,5.083982E-08, _
1.289968E-08,4.404528E-09,1.618755E-09,4.460591E-10,1.507662E-10, _
 9.599022E-08,4.585687E-07,1.633633E-06,4.472201E-06,1.638543E-05,6.501286E-05, _
1.633835E-04,5.062972E-04,0.00136162,0.003607,0.00565416,0.01019166,0.02371228, _
0.05335404,0.1189083,0.1569054,0.1533502,0.2947621,0.57147,0.7812694,0.8085877, _
0.2196202,0.2438382,0.3357103,0.6721363,1.095366,0.9382318,1.662547,1.6487, _
1.331216,1.000072,1.161448,1.664425,1.058536,0.4323908,0.4637934,0.7802989, _
0.6376551,0.4838318,0.2369987,0.1329798,0.05760746,0.0347238,0.01490695, _
0.01835641,0.01013006,0.00552411,0.00545648,0.00576815,0.00669357,0.00609544, _
0.00474293,0.0052316,0.00640261,0.0109019,0.00747264,0.0126387,0.02379161, _
0.02927508,0.04081165,0.04609673,0.2370242,0.3091907,0.5816393,0.6180706, _
0.4099542,0.5336873,0.5399274,0.6301032,0.6996506,1.414497,0.266021,0.5194787, _
0.8597596,0.9768713,0.8944862,0.8774147,1.065089,0.2667048,0.7453937,0.6008084, _
0.4266303,0.2559165,0.3430985,0.198057,0.1280152,0.05850253,0.04933698, _
0.02113008,0.00868319,0.0050017,0.0027528,0.0010368,4.005344E-04,1.287283E-04, _
4.885375E-05,5.576525E-06,2.787017E-06,9.590309E-07,2.643544E-07,1.401449E-07, _
2.105956E-08,6.277389E-09,2.081085E-09,6.86134E-10,1.798773E-10,6.028194E-11

U234F:
Data 66, 172, _
 3.920485E-06,9.288475E-06,2.680505E-05,6.194913E-05,2.062796E-04,5.158895E-04, _
6.344081E-04,0.00107465,0.00414272,0.0117649,0.02609599,0.05677454,0.08876111, _
0.1444975,0.216423,0.3617076,0.6538793,1.206397,1.905204,2.22949,3.441612, _
2.956966,3.91744,5.45725,6.095132,6.434357,6.075294,6.094696,6.487726,6.356677, _
6.2288,6.040828,5.749469,5.09399,4.138037,3.394214,2.669827,2.417184,1.319326, _
1.239631,0.4291662,0.268439,0.1857241,0.1226682,0.1035256,0.05819447,0.07227239, _
0.0597416,0.05884942,0.06851701,0.05678621,0.05478764,0.05478659,0.05976792, _
0.06464456,0.06961518,0.08158562,0.0994532,0.1194408,0.1565011,0.2591549, _
0.3888607,0.6473057,1.616283,2.541028,3.736007,4.364336,6.463571,5.740695, _
5.578926,6.347684,5.974308,6.607046,6.025774,5.787398,6.50678,5.979162,6.150958, _
5.445931,3.992219,3.071782,2.017738,1.434132,1.036147,0.6373448,0.3181106, _
0.2486321,0.1487608,0.08056227,0.05072156,0.02088574,0.01093924,0.00636393, _
0.0020889,0.00109551,4.38086E-04,1.590877E-04,4.976593E-05,2.888591E-05, _
9.457287E-06,2.490052E-06,5.968053E-07,2.681295E-07,9.449201E-08,2.48373E-08, _
7.9609E-09,1.1923E-09, _
 1.533082E-06,3.805551E-06,1.238678E-05,2.915451E-05,9.164148E-05,2.097473E-04, _
2.496126E-04,4.642049E-04,0.00203804,0.00529597,0.01061041,0.02257599, _
0.03924876,0.04983786,0.1015554,0.1482143,0.2136898,0.4666048,0.4824258, _
0.7675483,0.8748702,0.7095152,0.8766831,1.425945,1.419817,1.365905,1.189363, _
1.082431,1.717583,1.442191,1.275902,1.70601,1.409082,1.330452,1.034423,0.717636, _
0.8532475,0.5152407,0.3635107,0.3563311,0.2462531,0.1353333,0.08544075, _
0.0489781,0.04400334,0.02730021,0.03299806,0.02430567,0.02397526,0.03113039, _
0.02731467,0.02040227,0.01744302,0.02129717,0.03103743,0.02312606,0.02799465, _
0.03416335,0.04899088,0.05807018,0.1001506,0.1729285,0.2639422,0.666375, _
0.7614155,0.8678845,1.071099,1.236929,1.420536,0.8659708,1.408136,1.31768, _
1.711007,1.334688,1.233378,1.405704,1.371538,1.602977,1.232794,0.8764481, _
0.7749004,0.5578567,0.3676361,0.4456423,0.2492866,0.1305998,0.116404,0.06990521, _
0.03434933,0.02065998,0.00830051,0.00478989,0.0031505,9.306122E-04,4.427251E-04, _
1.781376E-04,6.949399E-05,2.322396E-05,1.380733E-05,3.929011E-06,9.664285E-07, _
2.494675E-07,1.292437E-07,4.393263E-08,9.998119E-09,3.234035E-09,4.859442E-10

U234HE:
Data 66, 172, _
 4.461846E-04,0.00105283,0.0014714,0.00206031,0.00343508,0.00529806,0.01042513, _
0.01479942,0.02256795,0.03434297,0.05505985,0.08386921,0.1353236,0.2060893, _
0.2588344,0.4737055,0.8288235,1.173652,1.414255,2.395549,2.218323,3.152026, _
3.756223,4.342058,4.754412,5.008486,5.162002,4.985277,5.22604,5.046055,5.29685, _
5.04473,4.844559,4.268338,3.510777,3.167301,2.969872,2.298058,2.074154,2.141864, _
1.530669,1.233372,1.420293,1.256797,1.423571,1.318349,1.471315,1.304213, _
1.324604,1.328336,1.180296,1.193029,1.190144,1.170307,1.150472,1.33872,1.220241, _
1.299459,1.43021,1.610591,2.134946,2.198155,2.509244,3.19236,3.478321,3.708356, _
5.261597,5.010633,5.540261,5.459409,6.441389,5.077069,5.270981,5.285622, _
3.930893,3.68089,4.323082,3.287822,2.695677,2.341458,1.914242,1.282374,1.047559, _
0.6228092,0.4832662,0.3360505,0.2372111,0.1819419,0.08919317,0.06424594, _
0.0471188,0.03261674,0.01976898,0.01163766,0.0070201,0.00455113,0.00276813, _
0.00168043,9.897712E-04,5.831727E-04,2.577246E-04,2.073286E-04,1.186405E-04, _
7.907804E-05,3.897259E-05,2.075234E-05,1.680353E-05, _
 1.826637E-04,4.287416E-04,5.951705E-04,8.454691E-04,0.00132002,0.00215315, _
0.00426267,0.00598597,0.00908154,0.01395031,0.02236758,0.03406549,0.05472898, _
0.06614712,0.1052416,0.1922431,0.2662553,0.4477327,0.5511744,0.6103157, _
0.7119759,0.6680042,0.7962442,0.9639719,0.9435129,1.153529,1.079376,1.034456, _
1.156317,1.044448,0.9780777,1.353336,1.148322,1.093129,0.8694279,0.8533852, _
0.9620498,0.7124259,0.4913104,0.5589668,0.620869,0.5018139,0.5821955,0.4480889, _
0.5749608,0.5384163,0.5040655,0.5348363,0.5379236,0.5364102,0.4672765,0.4271842, _
0.3845517,0.4522136,0.4113019,0.4216861,0.4424058,0.490641,0.4565422,0.5047901, _
0.4823328,0.5384859,0.7229917,0.803722,0.9142414,0.7235827,0.9855277,1.180172, _
0.970825,1.127107,1.647152,1.140539,0.9179096,1.18212,0.8344804,0.7745931, _
0.9834495,0.6808311,0.7213313,0.6489183,0.7016873,0.5261537,0.3791859,0.2541497, _
0.1974755,0.1359586,0.09456557,0.07379931,0.02924983,0.02629225,0.01905585, _
0.01337334,0.00802839,0.00473393,0.00287472,0.00184063,0.00111228,6.814246E-04, _
4.033986E-04,2.354566E-04,1.041368E-04,8.499022E-05,4.814063E-05,3.216777E-05, _
1.246554E-05,8.39104E-06,6.876792E-06

U235F:
Data 66, 172, _
 7.230878E-07,2.327381E-06,4.036646E-06,8.708474E-06,1.889313E-05,4.641957E-05, _
1.658637E-04,5.234769E-04,0.00119063,0.00353079,0.01757676,0.03180818, _
0.05705767,0.0907376,0.1749391,0.2286915,0.3404135,0.5752432,0.9262118,1.465087, _
1.88956,2.468987,3.420131,4.399066,5.626073,5.748593,5.781825,6.129097,6.418098, _
6.480661,6.217292,6.013967,5.879849,5.985618,6.305944,5.124243,4.3587,3.243693, _
2.066711,1.20211,0.5328048,0.3023271,0.1306879,0.08141375,0.06517335,0.04257535, _
0.03771098,0.03261428,0.03229373,0.03387675,0.03400434,0.03681958,0.03363263, _
0.0350194,0.03529166,0.0368082,0.04040895,0.04406312,0.06333286,0.06802933, _
0.0973244,0.3064709,0.5040355,0.834744,1.79483,3.220123,4.671125,6.720931, _
7.625521,6.629701,6.059541,6.324691,6.713793,6.379676,5.982377,5.949734, _
5.525296,5.741403,5.261775,3.792449,2.923376,2.138872,1.682051,1.038252, _
0.6859217,0.4119866,0.2708549,0.1670553,0.07231851,0.03947148,0.02025852, _
0.01058248,0.00649522,0.00300716,0.00113201,3.332174E-04,5.782578E-05, _
9.621072E-06,5.772787E-06,2.306685E-06,9.623704E-07,3.84301E-07,9.613305E-08, _
5.769031E-08,1.922656E-08,6.727176E-09,1.923613E-09, _
 3.075478E-07,9.5083E-07,1.710786E-06,4.062165E-06,9.49472E-06,2.004404E-05, _
6.473509E-05,2.159527E-04,5.662334E-04,0.00170021,0.00819354,0.01301852, _
0.02255112,0.03169246,0.08906107,0.1033718,0.1197587,0.2266773,0.2285108, _
0.5136635,0.4464043,0.3258836,0.3139971,0.5394711,0.4807987,0.7919288,1.054056, _
0.2920174,0.3005614,0.7967634,0.8439644,1.606787,0.8510426,1.305635,1.677079, _
1.189642,1.081949,0.7893324,0.4325773,0.3429115,0.05994941,0.1714423,0.07024398, _
0.03457319,0.02553582,0.01943523,0.01893185,0.0136831,0.01251674,0.01452185, _
0.01717454,0.01620262,0.01191663,0.01333825,0.01589985,0.01281149,0.0179682, _
0.01612633,0.0215898,0.02268319,0.04538915,0.1231391,0.2064235,0.2790264, _
0.6220205,0.7315779,0.7599743,0.8976539,0.4589429,0.6681262,0.7070032,0.2380492, _
0.2220749,0.9564129,0.2682055,1.322317,0.4193934,0.3107469,0.6204321,0.84872, _
0.7561827,0.4594964,0.3821703,0.2726452,0.3171296,0.1687965,0.1082007, _
0.05788952,0.03673631,0.01779229,0.00818983,0.00432706,0.00291586,0.00143786, _
5.54512E-04,1.392622E-04,2.236937E-05,4.055436E-06,2.860445E-06,1.096062E-06, _
4.240306E-07,1.569895E-07,3.944504E-08,2.633E-08,9.723312E-09,2.967471E-09, _
7.638503E-10

U235HE:
Data 66, 172, _
 2.877192E-04,6.031931E-04,8.865694E-04,0.00132007,0.00236142,0.00394577, _
0.00601191,0.01134462,0.01700827,0.02698408,0.04001566,0.06658626,0.0996256, _
0.167681,0.2516182,0.3419706,0.5935373,1.099786,1.37678,1.793623,1.783813, _
2.380614,3.366988,4.162302,4.710167,4.836435,5.079415,5.085839,5.194139, _
5.200788,5.217666,5.525681,5.41118,5.160653,3.953702,3.452316,3.253406,3.204485, _
2.469104,1.880557,1.611393,1.285338,1.177188,1.171204,1.086158,1.079264, _
1.075815,1.091283,1.057012,1.091541,1.056207,1.06521,1.081827,1.084015,1.090325, _
1.053678,1.145964,1.192963,1.290026,1.460331,1.862136,2.180774,2.453603,3.37665, _
3.599647,4.102715,4.885822,5.528661,5.707504,5.73079,5.210431,5.016343,4.603212, _
4.827147,4.528828,4.485527,4.196489,3.820217,3.172958,2.712441,2.199175, _
1.623174,1.197542,0.8134843,0.5118293,0.3577337,0.2576451,0.2035873,0.1269613, _
0.07871858,0.05789097,0.03770252,0.0234678,0.01212324,0.00720748,0.00526052, _
0.00278191,0.00158397,9.759085E-04,5.375564E-04,2.796625E-04,1.852784E-04, _
1.064794E-04,7.801956E-05,3.252658E-05,1.7628E-05,1.655315E-05, _
 1.167468E-04,2.469572E-04,3.579196E-04,5.389886E-04,9.34199E-04,0.00159328, _
0.00246275,0.00459605,0.00686165,0.01103702,0.01616342,0.02712209,0.04045785, _
0.05557492,0.1028672,0.1399328,0.1892733,0.431518,0.5121922,0.5772272,0.6101484, _
0.5014319,0.4706581,0.5964516,0.986494,0.8848933,1.024809,1.045812,1.161016, _
1.098258,1.068157,1.518205,0.9709383,1.131917,0.9398205,0.7224261,1.036106, _
0.6661029,0.5909787,0.7502851,0.6561262,0.5201248,0.4821784,0.4340643,0.438055, _
0.4419659,0.4365877,0.4450127,0.4313075,0.3072215,0.4245608,0.4021473,0.3633316, _
0.4319398,0.366661,0.3434434,0.4360265,0.457457,0.4132418,0.3716091,0.4428216, _
0.4996574,0.7157078,0.5610899,0.8815577,0.8250141,0.8610294,1.225086,0.9183498, _
0.6866025,0.9230817,0.5929413,0.7472132,0.8308095,0.9395446,0.9246018,0.9012823, _
0.8415596,0.6572646,0.7091815,0.7429027,0.5240122,0.4585034,0.329792,0.2117366, _
0.1445051,0.1030939,0.0826421,0.04187519,0.03220816,0.02338463,0.01542218, _
0.00953878,0.0049138,0.00297498,0.0021268,0.00112238,6.467075E-04,3.943043E-04, _
2.190348E-04,1.135951E-04,7.515957E-05,4.360221E-05,3.152477E-05,1.048448E-05, _
7.187438E-06,6.734638E-06

U235T:
Data 66, 172, _
 7.221155E-08,3.605806E-07,7.157735E-07,1.572404E-06,3.617294E-06,8.384933E-06, _
2.649483E-05,1.017579E-04,3.385258E-04,0.0010677,0.00309725,0.00795941, _
0.0209287,0.04466554,0.1279504,0.2033144,0.3257495,0.534757,0.8940306,1.285686, _
2.031158,2.521424,3.534232,4.748485,5.88117,5.856083,5.975204,6.234634,6.575449, _
6.540931,6.355827,6.004722,5.752562,6.145833,6.297475,5.172552,4.298203, _
3.030785,1.874197,0.9709237,0.4016966,0.1461922,0.05407689,0.03117186, _
0.02553974,0.01743106,0.01304156,0.01420416,0.01183225,0.01258354,0.01324768, _
0.01276207,0.01134433,0.012874,0.0126085,0.01304529,0.01548211,0.01565748, _
0.02678666,0.03401805,0.05821392,0.1572559,0.3480327,0.5431402,1.811058, _ 
_'0.02678666,0.03401805,0.05821392,0.1572559,0.3480327,0.8100000,1.811058, _ 'value for A=129 changed in this line (from Mills thesis)
2.890825,4.31344,6.696198,7.84928,6.54644,6.097407,6.343482,6.775188,6.476025, _
6.222877,5.852969,5.829085,5.967125,5.502811,3.942641,2.997919,2.246727, _
1.672677,1.082445,0.6533272,0.4187668,0.2669133,0.1582784,0.07443416,0.03213494, _
0.01485293,0.00615086,0.00328518,0.00100941,3.190062E-04,8.52942E-05, _
1.590629E-05,6.101987E-06,1.881684E-06,9.514985E-07,3.624149E-07,2.471381E-07, _
5.704561E-08,2.385004E-08,5.006529E-09,2.347027E-09,7.686748E-10, _
 3.026989E-08,1.4718E-07,3.123155E-07,7.499138E-07,1.809397E-06,3.572812E-06, _
1.024456E-05,4.251923E-05,1.666097E-04,5.102658E-04,0.00135697,0.00331992, _
0.00826068,0.01078034,0.00985084,0.00766086,0.08450522,0.03408511,0.09063299, _
0.411958,0.1803774,0.06282173,0.1102757,0.06531929,0.4577789,0.05289498, _
0.1078261,0.0853548,0.08446699,0.3670528,0.6674448,1.423558,1.265029,0.8333609, _
1.658957,0.141908,0.7401456,0.4623724,0.2676036,0.08541009,0.02452209,0.0790517, _
0.02459732,0.01317107,0.01008488,0.00811633,0.00653271,0.0058953,0.00435748, _
0.00519794,0.00536591,0.00564873,0.00310278,0.00316413,0.00566042,0.00376496, _
0.00770107,0.00694663,0.00889678,0.0045201,0.02897836,0.01625092,0.1369769, _
0.04503055,0.561335,0.4048246,0.1336618,0.2617706,0.4718021,0.2103039,1.000651, _
0.149312,0.1512627,0.1224305,0.1634888,0.1948924,0.1960194,0.2993665,0.1328077, _
0.1975699,0.6782757,0.2674503,0.3584795,0.1553164,0.2878789,0.1729659, _
0.09223162,0.05548479,0.03759471,0.01385616,0.00576662,0.00255666,0.00160218, _
4.899529E-04,1.470975E-04,3.496666E-05,6.370334E-06,2.740941E-06,9.690534E-07, _
4.329489E-07,1.471368E-07,1.010872E-07,2.583985E-08,1.152474E-08,2.432947E-09, _
9.828711E-10,2.973508E-10

U236F:
Data 66, 172, _
 8.297559E-07,2.073867E-06,4.158442E-06,9.334155E-06,2.073617E-05,5.1882E-05, _
1.868039E-04,7.188419E-04,0.00311351,0.00830304,0.02283304,0.04517709, _
0.05806179,0.1140577,0.1858398,0.2705717,0.3845709,0.5635422,0.9395179,1.502421, _
1.715,2.244121,2.802164,3.91923,4.843043,5.527523,5.56411,5.397912,5.122932, _
6.415905,6.070514,5.464421,5.9861,5.862486,5.785608,5.229299,5.196377,4.155797, _
3.529251,2.477181,1.013039,0.6160435,0.383791,0.1538313,0.1146616,0.06730792, _
0.05292776,0.04106948,0.03632284,0.03844751,0.0373611,0.03770193,0.0362972, _
0.03534327,0.03820693,0.03745882,0.0505776,0.07118662,0.09401948,0.1642947, _
0.243183,0.3536345,0.5441403,0.9311857,1.742158,2.950469,4.377124,6.88514, _
7.69335,6.091369,6.328255,6.18513,6.677754,6.134056,5.642909,5.385015,5.393676, _
5.780176,5.110675,4.171041,3.46541,2.295286,1.727505,1.340007,0.7400543, _
0.4148881,0.3152069,0.2528786,0.1311239,0.09365924,0.03372977,0.02341401, _
0.01123922,0.00440248,0.00196627,4.926855E-04,2.062753E-04,1.124003E-04, _
4.497237E-05,1.719795E-05,1.029501E-05,4.87443E-06,1.218009E-06,2.992489E-07, _
9.077549E-08,2.993879E-08,8.049301E-09, _
 3.508331E-07,8.477627E-07,1.735014E-06,4.280839E-06,1.007665E-05,2.22193E-05, _
7.373302E-05,2.973948E-04,0.00146125,0.00392515,0.01013061,0.01839828, _
0.02348468,0.03947587,0.09185277,0.1187383,0.1284067,0.2210661,0.4107887, _
0.5241294,0.4230761,0.6507705,0.6026344,0.8613111,1.268743,1.246648,1.176943, _
1.197615,0.9078925,1.563677,1.082099,1.424997,0.9589244,1.253223,1.41517, _
1.231662,1.291361,1.106923,0.8813198,0.561012,0.4128846,0.2424032,0.1918583, _
0.06931646,0.04516196,0.02947335,0.02616294,0.01759999,0.01428493,0.01614763, _
0.01807709,0.01697265,0.01364198,0.01393174,0.01517854,0.01291886,0.02325697, _
0.02703485,0.03032975,0.054774,0.1094349,0.1414098,0.2203168,0.3411378, _
0.6672869,0.7822106,0.6986337,1.391609,0.8284689,1.38477,1.166831,1.344483, _
1.182282,1.602158,1.292384,1.162037,1.149629,1.022104,1.350677,0.9190508, _
0.9234374,0.489419,0.4729276,0.6344385,0.3308437,0.1700493,0.1263994,0.1113491, _
0.06451356,0.04193323,0.01370658,0.00958122,0.00489411,0.00206691,9.421733E-04, _
2.065271E-04,8.110633E-05,4.695671E-05,2.144202E-05,8.092702E-06,4.515735E-06, _
1.994854E-06,4.926098E-07,1.33214E-07,4.464081E-08,1.325261E-08,3.247721E-09

U236HE:
Data 66, 172, _
 1.848187E-04,4.057831E-04,7.865134E-04,0.00109601,0.00199425,0.00308836, _
0.00468542,0.0081779,0.01394408,0.01991955,0.02889595,0.05982999,0.1094242, _
0.1690753,0.2365136,0.3498907,0.5412369,0.6372704,0.9352679,1.477472,1.683799, _
2.544925,2.56054,3.702806,3.936794,4.269622,4.789793,4.925111,5.488012,5.295279, _
5.323805,5.458889,5.191193,5.158493,4.797803,4.201574,3.552764,3.213456, _
2.804425,2.518284,1.817545,1.585503,1.375411,1.195122,1.299876,1.10607,1.160652, _
1.085208,1.047029,1.044624,1.266416,1.143987,1.101795,1.022386,1.052163, _
1.160982,1.101811,1.171801,1.293257,1.469058,1.594674,1.957007,2.230966,2.8124, _
3.35117,3.810133,4.873324,5.389033,5.830106,5.576875,5.965308,5.240859,5.092854, _
5.231889,4.120324,4.056171,4.251554,3.944685,3.488317,2.556472,1.995943, _
1.732623,1.269879,0.8813632,0.6847957,0.4848763,0.3562355,0.2796715,0.1415438, _
0.09202731,0.07047991,0.04947677,0.02770764,0.01630265,0.00992087,0.0064684, _
0.00385813,0.00227604,0.00138521,7.536374E-04,4.198876E-04,2.569427E-04, _
1.485667E-04,1.191547E-04,4.459137E-05,2.474547E-05,1.381808E-05, _
 7.544381E-05,1.678333E-04,3.204035E-04,4.501488E-04,8.040102E-04,0.00125548, _
0.00193523,0.00335091,0.00566872,0.00823874,0.01177057,0.02454194,0.04504595, _
0.0582714,0.09771091,0.1425745,0.1760442,0.2561134,0.3407019,0.4731188, _
0.5995868,0.6727,0.7313483,0.7863289,1.004316,0.8869627,1.093865,1.034384, _
1.177729,1.1694,1.077525,1.598048,0.9085398,1.085862,1.150785,0.8729748, _
1.148748,0.6924271,0.6833816,0.673026,0.4823221,0.6453325,0.5671277,0.4618083, _
0.5279574,0.4574676,0.4742101,0.4444818,0.4326587,0.4249371,0.5158352,0.4477503, _
0.3847383,0.4156943,0.3457578,0.3931794,0.4300169,0.4610789,0.4264725,0.4544939, _
0.5618066,0.6685954,0.651758,0.5433952,0.8098763,0.9248036,0.8518674,1.081384, _
1.193328,1.196763,1.05124,1.098206,1.23211,1.0888,0.9060538,0.876438,0.889838, _
1.029294,0.7271236,0.6958588,0.6500167,0.5922096,0.5126159,0.3593636,0.2814454, _
0.1997015,0.1445297,0.1156536,0.05257119,0.03774414,0.02906591,0.02013943, _
0.01145799,0.00665228,0.0040734,0.00266515,0.00156686,9.410161E-04,5.666274E-04, _
3.078687E-04,1.73572E-04,1.045738E-04,6.116738E-05,4.898966E-05,1.536233E-05, _
1.023124E-05,5.644976E-06

U237F:
Data 66, 172, _
 4.45929E-07,1.386684E-06,1.981356E-06,5.939842E-06,1.189056E-05,2.774843E-05, _
4.957023E-05,2.984095E-04,9.910013E-04,0.00317073,0.00733468,0.01788672, _
0.0465152,0.07521298,0.1273382,0.2090804,0.3076851,0.4749191,0.8046601,1.081308, _
1.506306,1.715018,2.618017,3.441176,4.06078,4.414467,4.762786,5.085342,5.628909, _
5.674896,5.828772,5.910765,5.872965,6.259937,5.955295,5.804114,5.684472, _
4.947286,4.61886,2.709162,2.062948,1.122898,0.4953041,0.178569,0.1295396, _
0.06937654,0.05946646,0.04371289,0.03667079,0.04158078,0.03468726,0.03478046, _
0.03577499,0.0347432,0.03474522,0.03660828,0.04453462,0.05642078,0.07131322, _
0.1191227,0.1776413,0.2483623,0.573181,1.013182,2.02811,3.214311,4.756469, _
5.454151,6.722189,6.662914,6.371755,6.697618,6.328166,6.179007,6.658218, _
5.589428,5.422164,4.831087,4.846426,3.663104,3.130164,2.616421,1.853411,1.44577, _
1.042699,0.7719367,0.5245213,0.3463815,0.1880356,0.1187597,0.05740084, _
0.04255516,0.01484489,0.00682801,0.0027304,0.00104244,2.961411E-04,5.15275E-05, _
2.768054E-05,9.923674E-06,5.935508E-06,2.371396E-06,1.089447E-06,4.156042E-07, _
8.414447E-08,2.281187E-08,6.926085E-09, _
 1.96048E-07,5.716473E-07,8.063137E-07,2.656313E-06,5.902667E-06,1.239677E-05, _
2.011838E-05,1.2306E-04,4.375654E-04,0.00150524,0.00352228,0.00749157, _
0.01840498,0.02696536,0.06222738,0.09744404,0.11714,0.1922524,0.3087816, _
0.3756612,0.3818114,0.7225704,0.7135319,0.7332854,1.08557,1.046929,1.025516, _
1.048033,1.200949,1.329824,1.187615,1.484329,0.9523625,1.334378,1.394311, _
1.52152,1.407227,1.071628,1.224454,0.7892887,0.5945659,0.4502576,0.2629477, _
0.08095682,0.05215987,0.02886605,0.02886527,0.02025022,0.01506642,0.01715536, _
0.01578885,0.01649844,0.01582188,0.01426343,0.01159564,0.01276215,0.0219049, _
0.0239394,0.02356475,0.04051259,0.07343234,0.09337195,0.2254324,0.4529687, _
0.8038995,0.930335,0.8845055,1.124702,1.676948,1.617125,1.289319,1.380033, _
1.349621,1.457306,1.645479,1.194491,1.072493,1.026296,1.297067,0.9827684, _
0.780527,0.6940993,0.7883796,0.3868187,0.5071415,0.3253118,0.2075016,0.1452539, _
0.0899683,0.05635598,0.02543324,0.01754428,0.00602707,0.00304383,0.00136075, _
4.67312E-04,1.204238E-04,2.124066E-05,1.217313E-05,4.697967E-06,2.857621E-06, _
9.957014E-07,4.308722E-07,1.745828E-07,4.037037E-08,1.081375E-08,3.056381E-09

U238F:
Data 66, 172, _
 3.704627E-06,2.143364E-05,2.80312E-05,3.591197E-05,4.419508E-05,4.948809E-05, _
6.05442E-05,2.060041E-04,2.771876E-04,4.622193E-04,8.007113E-04,0.00330193, _
0.01116444,0.03260076,0.04107114,0.08560147,0.2139458,0.3936458,0.6248965, _
0.9281149,1.2542,1.590461,1.827912,2.694771,3.466771,4.081954,4.317273,4.640787, _
4.822732,5.12921,6.158909,5.569324,5.868143,6.237962,6.72458,6.209044,6.446565, _
6.272674,4.992314,4.092845,2.495331,1.445876,0.6009729,0.2517195,0.1416359, _
0.0712156,0.05590134,0.04611245,0.03925743,0.03754765,0.0393137,0.03773198, _
0.04317657,0.0397207,0.03871442,0.03690728,0.04106724,0.04455766,0.04646096, _
0.04852479,0.05386155,0.1364748,0.2841646,1.012532,1.913953,3.28784,5.150981, _
6.729358,7.457114,7.041598,6.684493,6.225989,5.773952,5.810166,5.839304, _
5.379018,4.54303,4.616786,4.534554,3.870584,3.461346,2.592735,2.10468,1.631635, _
1.274931,0.7994029,0.5302316,0.4147904,0.2162819,0.1415151,0.07603332, _
0.04137502,0.01848751,0.00861914,0.00354503,0.00121536,3.405963E-04, _
2.042005E-04,1.247615E-04,7.667431E-05,5.666655E-05,4.351727E-05,2.837824E-05, _
1.701294E-05,1.021359E-05,5.714844E-06,1.06605E-05, _
 1.608783E-06,9.002792E-06,1.167505E-05,1.513163E-05,1.986971E-05,2.172414E-05, _
2.529584E-05,8.736879E-05,1.154828E-04,2.013779E-04,3.630345E-04,0.00139525, _
0.00464732,0.01286696,0.01771375,0.03829782,0.08647414,0.1716955,0.2048813, _
0.3271087,0.315072,0.3455712,0.5828144,0.6335822,0.6149194,0.6047935,0.4265319, _
0.9207512,1.055323,0.9074407,1.125799,1.464182,1.046578,1.43054,1.427341, _
1.433062,1.56609,1.333102,1.529736,0.750842,0.4847029,0.4079754,0.2337109, _
0.1197174,0.06414539,0.0302673,0.02364668,0.02068342,0.0166695,0.01594794, _
0.01634549,0.01639087,0.01914362,0.0166713,0.01250018,0.01365881,0.01770846, _
0.01922993,0.01673816,0.01534853,0.01963424,0.04585306,0.09871859,0.3211372, _
0.7508818,1.11785,0.9132344,1.046333,1.341933,1.575154,1.298667,0.8309212, _
1.243856,0.8741028,0.7408693,0.6917338,0.9828866,0.8858407,0.8055174,1.007075, _
0.8620374,0.7320113,0.7903331,0.5725333,0.4284943,0.3440276,0.2204215,0.175421, _
0.0916983,0.06309691,0.03349552,0.01734722,0.00770942,0.00361745,0.00158584, _
5.378227E-04,1.431767E-04,8.65332E-05,5.187057E-05,3.308465E-05,2.578626E-05, _
1.853393E-05,1.180598E-05,7.186678E-06,4.344562E-06,2.547127E-06,4.704376E-06

U238HE:
Data 66, 172, _
 7.821796E-05,1.386739E-04,2.983565E-04,5.010404E-04,9.012745E-04,0.00159162, _
0.00270596,0.00523004,0.00800628,0.01386986,0.02199003,0.03129333,0.05699387, _
0.1329564,0.2092518,0.334513,0.4537678,0.6663946,0.9607861,1.158072,1.523847, _
1.651169,2.048304,2.884037,3.367145,3.893229,3.873924,4.296611,4.855656, _
4.926308,5.622543,5.322355,5.406467,5.760124,5.013084,5.697824,4.621129, _
4.614399,3.995831,3.241973,2.460785,1.694375,1.221307,1.120021,1.03141, _
0.9922501,1.032698,0.914341,0.718888,0.8570475,0.6756378,0.6047033,0.8310164, _
0.725952,0.7774184,0.8328025,0.8498614,0.9228812,1.034999,1.196329,1.322679, _
1.495971,1.94295,2.079847,3.150233,3.993001,4.838687,6.012312,6.405131,5.860982, _
5.446806,5.197778,4.97367,5.10901,4.624636,4.394473,4.030463,3.915194,3.716103, _
3.033705,2.44469,2.091154,1.726726,1.461404,1.081455,0.8014741,0.5787942, _
0.3919224,0.2521235,0.1552578,0.114369,0.0803493,0.04259307,0.02601792, _
0.01566457,0.00846904,0.00593662,0.00339334,0.00199194,0.00109749,6.297313E-04, _
3.694677E-04,2.004735E-04,1.292682E-04,5.948958E-05,3.302417E-05,2.126358E-05, _
 3.231108E-05,5.80561E-05,1.225259E-04,2.081909E-04,3.678567E-04,6.528907E-04, _
0.00113041,0.00216905,0.00328475,0.00580787,0.00906587,0.01293654,0.02381782, _
0.04758659,0.08719488,0.1384676,0.1532079,0.2740025,0.3268696,0.3766271, _
0.5930712,0.4873587,0.3604941,0.3617073,0.4326308,0.5274587,0.6420903,1.024569, _
1.019802,1.079263,1.223149,1.393463,1.029512,1.214347,1.051429,1.287475, _
1.162494,1.024287,1.131803,0.6809602,0.652953,0.70492,0.5020154,0.4602373, _
0.4257639,0.408696,0.432892,0.3760858,0.2985704,0.3580613,0.2769639,0.2503369, _
0.3277943,0.2975125,0.2514892,0.3202441,0.3140382,0.3832115,0.3882574,0.3944708, _
0.4291773,0.4780431,0.5779856,0.7500455,0.9191356,0.6688598,0.7832638,1.168825, _
0.8751185,1.060138,0.9892447,0.5773638,0.6337098,0.7538033,0.6205395,0.8691308, _
0.8416016,0.8128261,0.978815,0.6459522,0.818975,0.5518317,0.7076018,0.46965, _
0.4466455,0.3317125,0.2417588,0.1606066,0.1039069,0.06435104,0.04711728, _
0.03364893,0.01752601,0.01079246,0.00652949,0.00347627,0.00247902,0.00140743, _
8.194378E-04,4.596103E-04,2.595913E-04,1.527791E-04,8.391785E-05,5.309094E-05, _
2.453287E-05,1.375753E-05,8.729518E-06

U238S:
Data 66, 172, _
 8.133126E-11,2.446135E-10,8.125523E-10,2.457442E-09,8.135643E-09,2.446352E-08, _
8.124411E-08,2.555344E-07,8.137679E-07,2.449174E-06,8.12664E-06,2.55601E-05, _
8.102346E-05,3.35474E-04,7.64068E-04,0.00401743,0.01225796,0.02879181, _
0.09186661,0.08626615,0.9358717,1.542977,2.428585,3.59653,5.847204,5.886475, _
5.837173,5.776653,6.791975,6.690174,6.764961,6.623606,6.415067,6.145249, _
6.157159,6.537965,6.160252,4.555743,3.738511,0.7942804,0.2704863,0.1390346, _
0.08130173,0.01181817,0.00985187,0.00856495,0.00585782,0.00510342,0.00410945, _
0.00382648,0.00355311,0.00328057,0.00319045,0.00379333,0.00379354,0.00388905, _
0.00419062,0.00449006,0.00498816,0.00599022,0.0069638,0.01399333,0.01990331, _
0.02656784,0.1396113,0.4475269,3.327778,5.584719,4.703992,5.256915,5.358765, _
6.089978,6.327491,7.004104,6.840519,6.955839,6.200617,7.178237,6.132599, _
6.139369,5.288952,4.399125,3.030649,2.212395,0.9995816,0.1995014,0.04987444, _
0.01994942,0.00798044,0.00299281,9.976223E-04,3.99589E-04,9.972932E-05, _
1.99635E-05,4.987029E-06,1.499996E-06,5.98249E-07,9.968802E-08,2.997247E-08, _
9.981157E-09,3.987029E-09,9.97646E-10,3.984364E-10,1.993031E-10,9.862157E-11, _
2.973046E-11,9.01014E-12, _
 3.595739E-11,1.070204E-10,3.584135E-10,1.073829E-09,3.84379E-09,1.114716E-08, _
3.5092E-08,1.136932E-07,3.510935E-07,1.136883E-06,3.811997E-06,1.105671E-05, _
3.592896E-05,1.34357E-04,3.438997E-04,0.00191289,0.00485639,0.01264471, _
0.03161006,0.03044782,0.3163574,0.6805393,0.5530074,0.800447,1.291941,1.464814, _
1.31251,1.274942,1.569574,1.453149,1.629523,1.64299,1.155801,1.457046,1.334667, _
1.561901,1.528925,0.9884334,1.247752,0.344558,0.1324471,0.07570595,0.04489711, _
0.00587122,0.00424926,0.00374235,0.0027436,0.00227781,0.00180921,0.00166412, _
0.00159814,0.00154009,0.00126392,0.00166124,0.00129519,0.00138646,0.00195567, _
0.00195899,0.00174828,0.00192634,0.00257205,0.00472677,0.00696149,0.01103655, _
0.05490501,0.1685469,0.7364013,1.383118,0.9766046,1.09547,1.334677,1.338618, _
1.382981,1.554515,1.648248,1.612983,1.348474,1.63065,1.329547,1.465998,1.312669, _
0.8671822,0.7912629,0.4795411,0.468121,0.09256992,0.02151327,0.00887649, _
0.00344342,0.00137592,4.719319E-04,1.736644E-04,4.40629E-05,8.700647E-06, _
2.21699E-06,7.163952E-07,2.670621E-07,4.340878E-08,1.326678E-08,4.334294E-09, _
1.883449E-09,4.595204E-10,1.718951E-10,8.891646E-11,4.301735E-11,1.375863E-11, _
4.669902E-12

' Data from evaluation JEFF 3.1.1

AM241FJEFF311:
Data 56, 183, _
 1.7913E-10,8.4851E-10,2.63158E-09,7.61752E-09,2.14626E-08,5.847064E-08, _
1.551441E-07,4.014296E-07,1.011908E-06,2.485685E-06,5.950347E-06,1.388107E-05, _
3.155662E-05,6.990928E-05,1.509175E-04,3.174774E-04,6.507356E-04,0.00129976, _
0.00252892,0.00479389,0.00885224,0.01592026,0.0278789,0.04752814,0.07884598, _
0.1272165,0.1995309,0.3040487,0.4497311,0.6453869,0.8982465,1.210822,1.298903, _
1.866124,2.15262,2.432566,2.841946,3.00234,3.356047,3.770165,4.172266,4.75462, _
4.847262,5.345383,5.680134,6.253288,6.785494,6.502378,6.022854,5.379838, _
4.842157,4.545148,3.332124,2.306803,1.561755,0.9882258,0.7452566,0.4349564, _
0.2579496,0.1597869,0.1141908,0.08714068,0.07194009,0.06475369,0.06347102, _
0.06845831,0.08032414,0.1017714,0.1380813,0.1985684,0.2839849,0.4153303, _
0.6051204,1.354197,2.433574,4.157804,4.884416,5.801631,6.253729,6.897421, _
6.659718,6.456457,6.898142,6.809724,4.95624,4.721289,4.119605,3.881892,3.424475, _
3.688397,3.164909,2.156005,2.085932,1.565536,1.392838,0.9498466,0.9590181, _
0.6298394,0.5422998,0.4112317,0.2627575,0.1844575,0.1232134,0.07947708, _
0.05606811,0.03741831,0.02116792,0.01162086,0.00621369,0.00323597,0.00164117, _
8.105899E-04,3.898937E-04,1.826448E-04,8.333128E-05,3.703386E-05,1.603073E-05,_
6.760134E-06,2.777026E-06,1.111488E-06,4.333745E-07,1.647048E-07,6.088621E-08,_
2.1997E-08,7.6963E-09,2.60572E-09,8.1432E-10,1.8163E-10,_
 3.7793E-11,1.553822E-10,4.208973E-10,1.232241E-09,3.560235E-09,9.060734E-09,_
2.472893E-08,6.69226E-08,1.545739E-07,4.305248E-07,9.609029E-07,2.266859E-06,_
4.757457E-06,8.805534E-06,2.412139E-05,5.135923E-05,1.054165E-04,2.03896E-04,_
3.772303E-04,8.02401E-04,0.00150531,0.00239233,0.00483201,0.00704773,0.01284179,_
0.02032831,0.02871891,0.05019394,0.06601009,0.1146562,0.1606247,0.2091788,_
0.3462635,0.3202447,0.3746286,0.4100432,0.37951,0.5277208,0.5368535,0.6676474,_
0.5962922,0.5438759,0.7477913,0.6068268,0.8174289,0.8985049,0.7933358,0.8615123,_
0.7303838,0.6985757,0.6257197,0.6097652,0.4865652,0.282986,0.2611922,0.08580355,_
0.05719321,0.06002529,0.03783136,0.0167069,0.01743705,0.01206264,0.0102889,_
0.00939494,0.00941537,0.00878705,0.01001577,0.01341215,0.02095559,0.02881006,_
0.03942521,0.04873081,0.06982765,0.1824907,0.3162883,0.4758962,0.8315241,_
0.5655221,0.9970655,1.13972,1.089078,1.042809,0.9797538,0.8711265,0.6426286,_
0.6058418,0.4530956,0.5166848,0.4218183,0.5255898,0.4200797,0.2606602,0.3058266,_
0.1835014,0.2266167,0.1230219,0.1418116,0.08975753,0.0675559,0.05858424,_
0.03238805,0.02889733,0.02101867,0.00956124,0.00946418,0.00515592,0.00321749,_
0.00200843,0.00100604,5.07468E-04,2.762004E-04,1.256357E-04,5.922115E-05,_
2.983964E-05,1.174006E-05,6.414455E-06,2.44947E-06,1.12649E-06,4.732143E-07,_
1.686709E-07,6.610913E-08,2.359094E-08,8.943768E-09,3.553949E-09,8.901946E-10,_
4.484592E-10,1.188195E-10,3.6884E-11

AM241TJEFF311:
Data 58,181, _
 2.0913E-10,8.6911E-10,2.86877E-09,8.6275E-09,2.516375E-08,7.08914E-08, _
1.944542E-07,5.178757E-07,1.3407E-06,3.373309E-06,8.249135E-06,1.960647E-05, _
4.52915E-05,1.0169E-04,2.218908E-04,4.706001E-04,9.699784E-04,0.00194324, _
0.00378356,0.00716054,0.01317378,0.02356514,0.04099793,0.06937525,0.1142364, _
0.1799274,0.2769001,0.3632704,0.4241804,0.5874131,0.7262575,1.050913,1.378777, _
1.774782,2.134222,2.721579,3.999419,3.991089,4.913394,5.007142,4.894785, _
6.583508,5.916331,6.683388,6.688158,7.21833,6.324562,6.56672,6.076878,4.794034, _
3.202362,1.96682,1.369713,0.8820422,0.5475093,0.2510638,0.1112802,0.04487251, _
0.02966082,0.01929235,0.01286743,0.01006893,0.01122337,0.01752866,0.03149474, _
0.05793082,0.1058828,0.1927771,0.3550134,0.6503073,0.9970151,1.322908,2.384684, _
3.406095,4.352102,5.780156,6.188645,7.734036,7.301706,7.293451,7.05285,7.296809, _
5.851617,4.805791,4.880079,3.808315,3.371077,3.2007,2.353056,2.016832,1.524689, _
1.271836,0.9738666,0.80247,0.6696814,0.5714738,0.4090553,0.2973551,0.2379932, _
0.1593521,0.1073146,0.07058927,0.039508,0.02159885,0.01151488,0.00597107, _
0.003007,0.00147091,6.989542E-04,3.226721E-04,1.447373E-04,6.307966E-05, _
2.671514E-05,1.099598E-05,4.398204E-06,1.70996E-06,6.4606E-07,2.373811E-07, _
8.472263E-08,2.940758E-08,9.8746E-09,3.19289E-09,1.03118E-09,1.9915E-10, _
 6.691E-11,2.27147E-10,6.627432E-10,2.05243E-09,5.759474E-09,1.70007E-08,_
4.738592E-08,1.262035E-07,3.112896E-07,8.187367E-07,1.896638E-06,3.655406E-06,_
1.044139E-05,2.391003E-05,5.292541E-05,9.936798E-05,2.303286E-04,4.73927E-04,_
8.931365E-04,0.00165284,0.00322173,0.00504705,0.00998997,0.01574636,0.02319774,_
0.02426432,0.03187464,0.08526742,0.06906878,0.1330509,0.1095438,0.1283792,_
0.1916017,0.2170478,0.2988504,0.3614252,0.7015886,0.5342881,0.7583905,0.5423577,_
1.136878,0.7050386,1.321682,1.430918,1.242893,0.9368604,1.348285,0.8419632,_
1.108383,0.9169303,0.6528643,0.2732286,0.3149309,0.2162881,0.04448004,_
0.04367213,0.02209028,0.00560823,0.00667601,0.00388286,0.00265798,0.00204785,_
0.00247314,0.00332124,0.00562725,0.01128687,0.02280634,0.03660593,0.08844738,_
0.04709452,0.1661355,0.1438856,0.3489135,0.389962,0.4733159,0.5332585,0.7132201,_
0.9392223,0.8485652,0.8455202,0.7773513,0.9061491,0.7180188,0.6396281,0.5851427,_
0.5155284,0.4504422,0.4036562,0.5156855,0.2372369,0.3602393,0.1706661,0.236807,_
0.1145329,0.1626198,0.08190939,0.08134143,0.04246246,0.03301494,0.0188875,_
0.02646334,0.00954275,0.00926308,0.00314507,0.00280075,0.00144284,7.256127E-04,_
3.425466E-04,1.699209E-04,7.745531E-05,3.383268E-05,1.539013E-05,5.205078E-06,_
2.663219E-06,1.074828E-06,4.075479E-07,1.581475E-07,5.609082E-08,1.845213E-08,_
6.439723E-09,2.36479E-09,7.57722E-10,1.864519E-10,6.6213E-11

AM242MFJEFF311:
Data 57, 182, _
 1.0715E-10,5.3633E-10,1.72198E-09,5.02843E-09,1.41112E-08,3.908112E-08,_
1.047094E-07,2.731206E-07,6.933063E-07,1.713491E-06,4.122905E-06,9.657425E-06,_
2.202394E-05,4.889493E-05,1.056911E-04,2.224094E-04,4.557061E-04,9.091248E-04,_
0.00176628,0.00334232,0.00616192,0.01107166,0.01940162,0.03317575,0.05537735,_
0.09033821,0.1440296,0.2241191,0.3401776,0.5014105,0.7042051,0.9299286,1.195812,_
1.501556,1.942108,2.408505,2.846808,3.114181,3.536016,4.026371,4.46222,4.537028,_
4.7616,5.01858,5.517652,6.027397,6.437991,6.350584,6.672784,6.654808,5.984565,_
4.610267,3.473851,2.347721,1.356736,0.8894496,0.540497,0.3031752,0.1726719,_
0.1048268,0.0655392,0.04230041,0.03022726,0.02887876,0.03534815,0.05304918,_
0.08652618,0.1429397,0.2310849,0.3678702,0.623546,1.065133,1.683243,2.457272,_
3.577236,4.642289,5.786395,6.831127,7.417291,6.923333,6.508423,6.0609,5.753473,_
5.331017,4.946314,4.425475,4.236632,3.975003,3.522399,2.846228,2.401252,_
2.023374,1.681609,1.256465,0.9157494,0.6508135,0.4727934,0.3423782,0.2415724,_
0.1660288,0.1108157,0.07148959,0.04462238,0.02701537,0.01587357,0.00905922,_
0.00502588,0.00271183,0.00142348,7.271619E-04,3.615569E-04,1.749908E-04,_
8.244511E-05,3.781531E-05,1.688471E-05,7.339806E-06,3.106325E-06,1.279423E-06,_
5.133306E-07,2.002493E-07,7.614593E-08,2.80195E-08,1.010318E-08,3.51564E-09,_
1.21029E-09,3.77176E-10,_
 3.6962E-11,1.40571E-10,4.111125E-10,1.189451E-09,3.392686E-09,8.58217E-09,_
2.548436E-08,6.594041E-08,1.68674E-07,4.079101E-07,9.840271E-07,2.114492E-06,_
4.095089E-06,1.150962E-05,2.559976E-05,5.187132E-05,1.02516E-04,2.189384E-04,_
4.21585E-04,8.11507E-04,0.00142564,0.00265242,0.00427365,0.0078735,0.01227229,_
0.01734107,0.03077535,0.04600365,0.07047335,0.1033166,0.1414164,0.1997545,_
0.2590448,0.3286436,0.431824,0.509228,0.6359842,0.7241322,0.826405,0.7944344,_
0.7407345,1.00465,1.099858,1.133366,1.281112,1.055154,1.455419,1.401538,_
1.467061,1.405147,1.18232,0.974765,0.7152209,0.5129073,0.3165388,0.1589099,_
0.1308848,0.05892395,0.0383389,0.02539081,0.01391716,0.00922822,0.00646292,_
0.00612566,0.00668772,0.01008471,0.01604869,0.02629321,0.04294247,0.09294404,_
0.1244504,0.1945909,0.2900835,0.4215663,0.7491105,0.9861321,0.9866039,1.255726,_
1.417726,1.345436,1.388703,1.247247,1.238583,1.127858,1.11708,1.018681,0.967019,_
0.8861921,0.7747514,0.6194654,0.5715506,0.4738761,0.3862044,0.2999068,0.236482,_
0.16857,0.1287507,0.07498492,0.06157479,0.04321104,0.02754665,0.01804187,_
0.01108707,0.00640676,0.00391493,0.00221061,0.00120674,6.612166E-04,3.35501E-04,_
1.756076E-04,8.720163E-05,4.105098E-05,2.014822E-05,7.564461E-06,4.06602E-06,_
1.794829E-06,7.350699E-07,3.130599E-07,1.230832E-07,4.450987E-08,1.719571E-08,_
6.733356E-09,2.37091E-09,6.793188E-10,2.892099E-10,8.627964E-11

AM242MTJEFF311:
Data 57, 182,_
 0,5.6508E-10,1.87631E-09,5.57201E-09,1.58858E-08,4.458414E-08,1.212391E-07,_
3.214569E-07,8.29649E-07,2.086771E-06,5.111674E-06,1.219684E-05,2.834564E-05,_
6.416124E-05,1.414294E-04,3.036088E-04,6.345907E-04,0.00129131,0.00255783,_
0.00492959,0.00923933,0.01682488,0.0297348,0.05089125,0.08401485,0.1332107,_
0.2266098,0.2726678,0.3799535,0.5475392,0.8050446,1.049069,1.318672,1.62547,_
2.141277,2.587576,2.964134,3.142876,3.628255,4.192556,4.599638,4.400424,_
4.649455,5.037858,5.541056,5.802987,6.053668,5.865038,6.492464,6.665605,_
5.912967,4.392795,3.430162,2.338791,1.335072,0.9419495,0.5727293,0.3235833,_
0.1827021,0.1088847,0.06642643,0.0415195,0.02856751,0.02604007,0.03197841,_
0.04877027,0.08046533,0.1337515,0.2171107,0.346271,0.5831748,0.9921722,1.64867,_
2.361128,3.482986,4.292428,5.300881,6.243683,6.963171,6.570154,6.266362,_
5.842102,5.799309,5.629086,5.187688,4.440185,4.341116,4.224647,3.860125,_
3.117785,2.620293,2.214078,1.917324,1.462007,1.06856,0.7629257,0.6045977,_
0.4527505,0.3225193,0.2109216,0.1332926,0.08226235,0.04975737,0.02947268,_
0.01706202,0.00964173,0.00531446,0.00285477,0.00149403,7.615782E-04,_
3.780749E-04,1.827708E-04,8.603127E-05,3.943018E-05,1.759685E-05,7.645502E-06,_
3.234983E-06,1.331633E-06,5.344477E-07,2.081885E-07,7.931486E-08,2.903521E-08,_
1.05109E-08,3.61991E-09,1.26128E-09,3.81532E-10,_
 0,1.504036E-10,4.554493E-10,1.291253E-09,3.77439E-09,1.002229E-08,2.926749E-08,_
7.813563E-08,2.028001E-07,4.873856E-07,1.230151E-06,2.762434E-06,5.219772E-06,_
1.498516E-05,3.367203E-05,7.140161E-05,1.375105E-04,3.09711E-04,6.208399E-04,_
0.0011854,0.00213961,0.00414368,0.00654624,0.01276386,0.02005148,0.02862571,_
0.03502673,0.07018186,0.09903163,0.1061796,0.1762551,0.2499524,0.3163716,_
0.3976338,0.5149707,0.6177049,0.7561331,0.8486543,0.9774988,0.8835471,0.8915532,_
1.157119,1.228342,1.271699,1.404263,1.186254,1.59958,1.549197,1.608346,1.487997,_
1.274225,1.013535,0.7572777,0.539976,0.327778,0.1682904,0.1370117,0.06090883,_
0.03981975,0.02584492,0.01358935,0.00886619,0.00595293,0.0055381,0.006062,_
0.00951796,0.01498116,0.02516085,0.0406295,0.08971609,0.1179616,0.186318,_
0.2753391,0.404797,0.388041,0.948736,1.012444,1.330616,1.514535,1.365344,_
1.529508,1.389565,1.397195,1.27575,1.244747,1.160092,1.06665,1.004648,0.8574523,_
0.6607159,0.6421783,0.5240352,0.4345949,0.3259214,0.2589683,0.1859367,0.137975,_
0.08710708,0.06553068,0.04567088,0.02979167,0.01909349,0.01183185,0.00676352,_
0.00407631,0.00234782,0.00126069,6.983101E-04,3.550781E-04,1.7943E-04,_
9.228857E-05,4.375488E-05,2.088317E-05,8.203161E-06,4.169211E-06,1.867221E-06,_
7.732893E-07,3.250719E-07,1.298705E-07,4.684068E-08,1.807396E-08,7.132623E-09,_
2.475887E-09,7.690172E-10,3.007639E-10,8.980073E-11

AM243FJEFF311:
Data 57, 184,_
 3.1967E-10,9.5602E-10,2.89501E-09,8.05972E-09,2.175986E-08,5.729163E-08,_
1.472774E-07,3.689728E-07,9.012717E-07,2.146816E-06,4.987043E-06,1.129714E-05,_
2.495749E-05,5.376599E-05,1.129601E-04,2.314414E-04,4.624758E-04,9.012737E-04,_
0.00171333,0.00317734,0.00574998,0.01015723,0.01752416,0.02954309,0.04870719,_
0.07863235,0.1243064,0.1923876,0.2912781,0.4294291,0.6040294,0.806109,1.039545,_
1.293464,1.659067,2.085294,2.512094,2.76277,3.135013,3.589948,4.043862,4.230767,_
4.488581,4.645299,5.087889,5.685232,6.168565,6.16171,6.614199,6.834406,6.56322,_
5.455363,4.381001,3.142539,2.092461,1.388314,0.9118972,0.5677651,0.3280069,_
0.1968979,0.1212105,0.07657672,0.05155285,0.04105659,0.04446798,0.06058582,_
0.09371042,0.1513899,0.2445959,0.3889933,0.6289211,1.048894,1.733024,2.531131,_
3.518342,4.476033,5.513637,6.397027,7.037876,6.913163,6.591179,5.981891,_
5.694703,5.430344,5.042457,4.403875,4.160975,3.934875,3.586622,2.996907,_
2.503419,2.067384,1.771277,1.407235,1.056467,0.7457122,0.5466842,0.4019371,_
0.2899364,0.2066144,0.1433045,0.09611345,0.06241248,0.03931655,0.02404708,_
0.01430283,0.00828115,0.00466924,0.00256507,0.00137352,7.169677E-04,3.64903E-04,_
1.810842E-04,8.762917E-05,4.135403E-05,1.90255E-05,8.540237E-06,3.731691E-06,_
1.594916E-06,6.60377E-07,2.692105E-07,1.044538E-07,4.099885E-08,1.479827E-08,_
5.62713E-09,1.75467E-09,6.6464E-10,1.1214E-10,_
 8.377474E-11,2.494163E-10,6.888087E-10,1.918539E-09,5.236318E-09,1.234686E-08,_
3.59903E-08,8.919829E-08,2.174902E-07,5.177807E-07,1.184464E-06,2.396988E-06,_
4.763189E-06,1.266754E-05,2.755517E-05,5.401205E-05,1.053382E-04,2.189428E-04,_
4.057279E-04,7.751015E-04,0.00133436,0.0023984,0.00395038,0.00701124,0.01065407,_
0.01545251,0.02690015,0.03924231,0.05999238,0.08878044,0.1218724,0.1680327,_
0.2251583,0.2840961,0.3749966,0.444142,0.5530378,0.6530783,0.729924,0.7507491,_
0.6846144,0.9047253,1.056649,1.062303,1.208855,1.018015,1.350059,1.326954,_
1.437619,1.465573,1.296818,1.150096,0.915627,0.6984446,0.4825722,0.2466007,_
0.2163829,0.1005282,0.07239845,0.04463971,0.02360833,0.01717902,0.01097004,_
0.00871909,0.00895415,0.01312776,0.01821205,0.02677991,0.04717356,0.08804069,_
0.1287851,0.199098,0.2841763,0.4153726,0.7274415,0.8900419,1.002788,1.259437,_
1.438184,1.252512,1.427269,1.272987,1.260127,1.136078,1.087128,1.031117,_
0.9359471,0.8993979,0.7794216,0.5958462,0.6070652,0.4958162,0.4238311,0.326032,_
0.2637086,0.1952327,0.1465392,0.09925892,0.0749446,0.05328064,0.03683782,_
0.02420341,0.01569702,0.00950301,0.00583268,0.00353001,0.00197185,0.00114282,_
6.209234E-04,3.212017E-04,1.752219E-04,8.78125E-05,4.338886E-05,1.90819E-05,_
9.81919E-06,4.598847E-06,2.057613E-06,9.039261E-07,3.89673E-07,1.535917E-07,_
6.239152E-08,2.60009E-08,9.626944E-09,3.352103E-09,1.367374E-09,4.336823E-10,_
1.728713E-10,3.6077E-11

AM243TJEFF311:
Data 57,184, _
 3.1416E-10,9.0605E-10,2.78507E-09,7.7736E-09,2.098883E-08,5.538375E-08, _
1.424009E-07,3.571297E-07,8.730543E-07,2.081572E-06,4.839888E-06,1.09741E-05, _
2.426344E-05,5.231933E-05,1.10018E-04,2.25602E-04,4.511905E-04,8.800374E-04, _
0.0016743,0.00310729,0.00562656,0.00994307,0.01715998,0.0289344,0.04768769, _
0.07691351,0.1214864,0.18797,0.2856897,0.4242263,0.6020612,0.7867415,1.000294, _
1.240651,1.633348,2.054136,2.444081,2.618988,3.027266,3.568976,4.051524, _
4.043513,4.300292,4.567661,5.133952,5.708218,6.127582,5.931611,6.663826, _
7.209668,6.923815,5.433521,4.397768,3.190297,2.167553,1.501081,0.9811819, _
0.6056821,0.3529326,0.2107943,0.1289607,0.08127866,0.05481488,0.0435908, _
0.04557241,0.06077218,0.09201653,0.1460285,0.2329869,0.3679052,0.5909365, _
0.9786997,1.679958,2.52613,3.567816,4.498791,5.458349,6.178648,7.047906, _
7.109974,6.698343,5.790257,5.668323,5.586043,5.189526,4.356524,4.086526, _
3.878146,3.653729,3.081844,2.513674,1.996946,1.772714,1.453773,1.094847, _
0.7397626,0.5423213,0.4014759,0.2950695,0.2113537,0.1465654,0.0981665, _
0.06371772,0.04012104,0.02453065,0.01459122,0.008452,0.00476839,0.00262138, _
0.00140474,7.338485E-04,3.737944E-04,1.85668E-04,8.991449E-05,4.247618E-05, _
1.955014E-05,8.787229E-06,3.834585E-06,1.643601E-06,6.775143E-07,2.77774E-07, _
1.057562E-07,4.226292E-08,1.486299E-08,5.77731E-09,1.65636E-09,6.8417E-10, _
1.062E-10, _
 8.182585E-11,2.386037E-10,6.69895E-10,1.826667E-09,4.984329E-09,1.216883E-08, _
3.462429E-08,8.667335E-08,2.12989E-07,4.922501E-07,1.15336E-06,2.429642E-06, _
4.486601E-06,1.232185E-05,2.653698E-05,5.246479E-05,9.986732E-05,2.126653E-04, _
4.016449E-04,7.539414E-04,0.001292,0.00238724,0.00375439,0.00693355,0.01053668, _
0.01471533,0.0260166,0.03932259,0.05967327,0.08705045,0.1190934,0.1689017, _
0.2207576,0.2800193,0.3698872,0.4389932,0.5552592,0.6427445,0.7355031,0.7217407, _
0.688285,0.9213982,1.036677,1.064356,1.201622,0.9947726,1.363538,1.348892, _
1.449088,1.461156,1.294685,1.15545,0.9153708,0.7129025,0.4825456,0.2534304, _
0.2206468,0.1026317,0.07439269,0.0458873,0.02388572,0.01781409,0.01137926, _
0.00903527,0.00922355,0.01339898,0.0179629,0.02675522,0.04604361,0.08712894, _
0.12464,0.1935878,0.2748054,0.4052074,0.7181979,0.8457822,1.030188,1.277707, _
1.464216,1.20155,1.433064,1.297025,1.248533,1.161394,1.06765,1.038263,0.9406204, _
0.8920527,0.7960441,0.5709779,0.6176438,0.4991834,0.4268714,0.3354701,0.2609624, _
0.1989188,0.1468576,0.1043906,0.07674449,0.0523506,0.03748618,0.02464632, _
0.01577224,0.00985014,0.0058615,0.00356897,0.00203994,0.00116313,6.405953E-04, _
3.272276E-04,1.773301E-04,9.122158E-05,4.4192E-05,2.032797E-05,1.013317E-05, _
4.618995E-06,2.144806E-06,9.342237E-07,3.992771E-07,1.627495E-07,6.422128E-08, _
2.680795E-08,1.012375E-08,3.607133E-09,1.432554E-09,4.275887E-10,1.78033E-10, _
3.4759E-11

CM243FJEFF311:
Data 57, 184,_
 3.5707E-10,1.09048E-09,3.10975E-09,8.68415E-09,2.32827E-08,6.15153E-08,_
1.576974E-07,3.94141E-07,9.605089E-07,2.283036E-06,5.29087E-06,1.195814E-05,_
2.635402E-05,5.663816E-05,1.187052E-04,2.426012E-04,4.836182E-04,9.401672E-04,_
0.00178292,0.00329916,0.00595755,0.01050226,0.01809127,0.03046306,0.05014056,_
0.08076614,0.1274477,0.1967576,0.2967078,0.4352299,0.6130649,0.8139563,1.06078,_
1.356769,1.689656,2.047487,2.447767,2.85806,3.220004,3.587351,3.935729,4.208814,_
4.575719,4.995886,5.268881,5.620894,6.216269,6.71567,6.949652,6.835473,6.27857,_
5.301494,4.25891,3.037377,1.925892,1.108307,0.6738582,0.4479363,0.2835598,_
0.166393,0.09968191,0.0629629,0.04303427,0.03498381,0.0413719,0.05745379,_
0.08809315,0.1390917,0.2150074,0.3799581,0.6989575,1.099335,1.647316,2.382729,_
3.35971,4.575527,5.796323,6.70248,7.144001,7.120533,6.760291,6.50777,5.797355,_
5.200681,4.840108,4.628644,4.155778,3.700027,3.313405,2.884236,2.437203,_
2.030752,1.635475,1.273904,0.9582582,0.7093927,0.5067204,0.3720519,0.272456,_
0.1943528,0.1344298,0.09017081,0.05856518,0.03690464,0.02260409,0.01345555,_
0.00779131,0.00439307,0.00241293,0.00129142,6.736887E-04,3.426261E-04,_
1.698834E-04,8.213059E-05,3.871702E-05,1.779745E-05,7.97729E-06,3.486796E-06,_
1.486053E-06,6.176339E-07,2.503215E-07,9.890869E-08,3.807999E-08,1.4187E-08,_
5.15498E-09,1.86549E-09,6.0869E-10,1.2357E-10,_
 9.290061E-11,2.676092E-10,7.551956E-10,2.010427E-09,5.557522E-09,1.400753E-08,_
3.781081E-08,9.550597E-08,2.346443E-07,5.332643E-07,1.281676E-06,2.716881E-06,_
4.886038E-06,1.31678E-05,2.818076E-05,5.765901E-05,1.047827E-04,2.223651E-04,_
4.329355E-04,7.826203E-04,0.0013798,0.00254792,0.00386873,0.0072829,0.01121076,_
0.01595173,0.02653012,0.04137915,0.06378511,0.08722696,0.1239848,0.1723487,_
0.2201172,0.2809739,0.3589218,0.4520538,0.5382414,0.6224915,0.4307725,0.6434369,_
0.7245969,0.9196222,0.9665666,1.018066,1.120072,1.033136,1.312534,1.332885,_
1.421466,1.316038,1.260436,1.041605,0.85443,0.6139724,0.4128394,0.2540503,_
0.1489646,0.1183721,0.05672443,0.03996313,0.02176043,0.01416917,0.00913551,_
0.00815311,0.00753987,0.01077861,0.01633096,0.02936193,0.0149525,0.0887796,_
0.1108408,0.1724624,0.2662973,0.4182509,0.6778733,0.9428968,0.9337494,1.052872,_
1.364697,1.394053,0.8352183,1.163253,1.215672,1.165047,0.556704,0.9957552,_
0.89064,0.4551402,0.7497424,0.6280527,0.5753477,0.4260654,0.3916407,0.3137204,_
0.2424551,0.1713815,0.1371668,0.08452096,0.07487538,0.05172782,0.03539582,_
0.02251965,0.01458855,0.00927337,0.00544297,0.00332254,0.00189296,0.00103346,_
5.604827E-04,3.103442E-04,1.622891E-04,7.14357E-05,4.034233E-05,1.790997E-05,_
9.267802E-06,4.315856E-06,1.947692E-06,8.136515E-07,3.47605E-07,1.233189E-07,_
5.005453E-08,2.163466E-08,8.203027E-09,2.287688E-09,1.275763E-09,3.437142E-10,_
1.584811E-10,4.2561E-11

CM243TJEFF311:
Data 57,184, _
 3.3692E-10,1.02928E-09,2.92557E-09,8.12636E-09,2.206852E-08,5.795273E-08, _
1.482293E-07,3.695074E-07,8.97935E-07,2.127342E-06,4.912465E-06,1.105823E-05, _
2.426566E-05,5.190477E-05,1.082273E-04,2.199941E-04,4.359887E-04,8.425553E-04, _
0.00158836,0.00292227,0.00525123,0.00922487,0.01586886,0.02677513,0.0443627, _
0.07230563,0.1157217,0.1799144,0.2633765,0.3736784,0.5104371,0.6909474, _
0.9147265,1.180971,1.445535,1.539839,1.796942,2.430772,2.827222,3.401334, _
3.737127,4.350243,5.263352,6.078851,6.627788,7.380724,6.246841,7.314083, _
6.260619,6.097862,6.192769,3.48505,4.482503,3.168246,1.634121,1.769456, _
0.5570503,0.5386864,0.390361,0.2365769,0.1392808,0.08796778,0.06030961, _
0.0482657,0.0603935,0.08077546,0.1198833,0.1841003,0.2852436,0.4847092, _
0.6609175,0.8026348,1.223636,1.877412,3.215661,4.455956,5.219294,6.235472, _
6.075791,7.081818,7.879683,8.601851,6.607531,5.042464,5.212669,6.21259,4.060112, _
3.240824,3.336713,2.392974,1.932913,1.643754,1.344267,1.056849,1.182694, _
0.6502976,0.4758459,0.3260272,0.2277151,0.1577967,0.1168001,0.0838116, _
0.05722291,0.0372599,0.02329234,0.01403079,0.00817895,0.00462729,0.00254467, _
0.00136201,7.100854E-04,3.607683E-04,1.786835E-04,8.628943E-05,4.063411E-05, _
1.866071E-05,8.35714E-06,3.65007E-06,1.554684E-06,6.4568E-07,2.616216E-07, _
1.032452E-07,3.981191E-08,1.48849E-08,5.48324E-09,1.94371E-09,6.0939E-10, _
1.1368E-10, _
 8.769777E-11,2.502098E-10,7.21323E-10,1.845492E-09,5.29923E-09,1.33306E-08, _
3.499676E-08,8.969309E-08,2.185008E-07,4.990832E-07,1.200166E-06,2.51847E-06, _
4.650252E-06,1.171787E-05,2.556067E-05,5.318119E-05,9.047761E-05,1.9461E-04, _
3.864095E-04,6.837407E-04,0.00121371,0.0022008,0.00327698,0.0061966,0.00948011, _
0.0134618,0.02093768,0.03248853,0.05108665,0.06934143,0.0984519,0.1320834, _
0.1698527,0.2096913,0.2665534,0.2583611,0.2463877,0.3745955,0.3888897,0.5448584, _
0.4374325,0.9065039,0.6966728,1.092186,0.8449281,0.9915663,0.8139669,0.8563747, _
0.8113754,0.7897748,0.8230439,0.4602338,0.6782899,0.7067581,0.562431,0.2892302, _
0.2259714,0.1870395,0.0876273,0.06211486,0.03257191,0.0208259,0.01346823, _
0.01178699,0.01040954,0.01394932,0.02053737,0.0361669,0.05059988,0.1000775, _
0.05727238,0.08117493,0.1424851,0.1811626,0.3846362,0.4621906,0.53258,0.9081246, _
0.7458534,1.258304,1.345807,1.200844,0.7961674,0.674607,0.7085633,0.889041, _
0.5694206,0.4442411,0.4849774,0.3063917,0.2735358,0.3616275,0.3453197,0.3100797, _
0.1575261,0.1847532,0.1465318,0.08449297,0.07882435,0.05230059,0.03618012, _
0.0244699,0.01548066,0.0098326,0.00586159,0.00349011,0.00203838,0.0010995, _
6.002748E-04,3.314799E-04,1.676465E-04,7.895365E-05,4.294815E-05,1.744073E-05, _
9.881004E-06,4.474793E-06,2.029444E-06,8.720729E-07,3.65691E-07,1.356845E-07, _
5.309703E-08,2.334E-08,8.858858E-09,2.320806E-09,1.340394E-09,3.716082E-10, _
1.600418E-10,4.117E-11

CM244FJEFF311:
Data 56, 185,_
 1.5338E-10,6.8019E-10,1.98786E-09,5.43308E-09,1.446392E-08,3.727335E-08,_
9.40875E-08,2.316455E-07,5.572611E-07,1.308706E-06,3.002073E-06,6.725893E-06,_
1.471804E-05,3.145581E-05,6.566776E-05,1.339176E-04,2.667933E-04,5.194254E-04,_
9.885014E-04,0.00184027,0.00335444,0.00599505,0.01052583,0.01821226,0.03112898,_
0.05253203,0.08631815,0.1368071,0.202262,0.2940714,0.4183066,0.5760297,_
0.7688628,1.011611,1.302442,1.622869,1.974566,2.358958,2.746812,3.000223,_
3.521645,3.859759,4.16526,4.582527,5.004052,5.245059,5.553275,5.986393,6.289012,_
6.594522,6.62906,6.174937,5.336082,4.530837,3.461244,2.365202,1.502181,_
0.9322224,0.6248605,0.4072534,0.2553878,0.1521435,0.09404367,0.06163172,_
0.04578897,0.04714575,0.05677624,0.07963371,0.1202665,0.1800109,0.3102292,_
0.5387806,0.9362004,1.450988,2.141768,2.989924,3.972581,5.067441,5.981402,_
6.39855,6.423841,6.679754,6.417787,5.843413,5.464727,5.959033,4.925032,4.361458,_
4.019692,3.522438,3.121969,2.734906,2.346938,1.90471,1.510854,1.19693,0.9192312,_
0.6604198,0.4764585,0.5325211,0.2311733,0.1506837,0.1053734,0.07298968,_
0.05258424,0.03604627,0.02334054,0.01438772,0.00852435,0.00488213,0.00271414,_
0.00146857,7.744603E-04,3.984334E-04,2.00127E-04,9.816754E-05,4.703578E-05,_
2.201641E-05,1.00681E-05,4.49881E-06,1.963762E-06,8.377747E-07,3.4883E-07,_
1.421554E-07,5.634168E-08,2.198503E-08,8.24129E-09,3.08061E-09,1.0525E-09,_
1.584E-10,_
 5.1306E-11,1.771187E-10,4.905726E-10,1.304916E-09,3.395182E-09,8.878058E-09,_
2.099662E-08,5.606743E-08,1.346367E-07,3.19581E-07,7.077913E-07,1.614875E-06,_
3.28192E-06,5.798275E-06,1.540423E-05,3.216246E-05,6.251001E-05,1.150869E-04,_
2.354764E-04,4.397718E-04,7.988108E-04,0.0013594,0.00245989,0.00374261,_
0.00679765,0.01029322,0.01407911,0.02413883,0.03689931,0.05618919,0.07950963,_
0.1101629,0.1558954,0.2000378,0.2586054,0.3335372,0.4065464,0.5049869,0.5808375,_
0.4054607,0.6258271,0.6432846,0.8717933,0.9292376,0.9789972,1.076686,0.9130374,_
1.237211,1.221216,1.330417,1.299922,1.235059,1.107621,0.9236435,0.7336019,_
0.5097703,0.3162928,0.2003291,0.1637532,0.08089955,0.06439774,0.03090786,_
0.02039523,0.01301504,0.00976579,0.00770388,0.01024953,0.0148137,0.02387501,_
0.01759994,0.07512601,0.09990551,0.1448431,0.2318734,0.3381103,0.6004643,_
0.8334098,0.8363504,1.053653,1.293272,1.347127,0.7523779,1.292046,1.336836,_
1.325132,0.757306,1.123952,1.029721,0.4888619,0.8303372,0.7055038,0.6712547,_
0.5650513,0.4898499,0.4236035,0.3384145,0.2588041,0.2078781,0.1223048,_
0.06813926,0.07954767,0.05617833,0.03842041,0.02417188,0.01615345,0.01020761,_
0.00622602,0.00373517,0.00207985,0.00116659,6.709978E-04,3.498067E-04,_
1.753915E-04,9.609895E-05,4.010774E-05,2.399867E-05,1.13743E-05,5.312356E-06,_
2.428216E-06,1.054498E-06,4.218979E-07,1.767737E-07,8.08986E-08,3.252343E-08,_
9.215613E-09,5.338895E-09,1.659089E-09,7.358867E-10,2.361501E-10,5.2156E-11

CM244TJEFF311:
Data 56, 185,_
 1.4794E-10,6.5686E-10,1.91037E-09,5.20853E-09,1.394096E-08,3.594741E-08,_
9.087126E-08,2.239793E-07,5.390741E-07,1.267029E-06,2.90921E-06,6.523239E-06,_
1.428606E-05,3.055756E-05,6.383974E-05,1.302612E-04,2.596005E-04,5.053505E-04,_
9.609248E-04,0.00178492,0.00323944,0.00574519,0.00995969,0.01688577,0.028014,_
0.04549259,0.07240555,0.1130841,0.1732781,0.2604617,0.3824766,0.5425333,_
0.7237066,0.9432177,1.204841,1.50776,1.845089,2.219172,2.593076,2.925387,_
3.302745,3.656858,3.915112,4.242376,4.609252,4.852977,5.195427,5.730961,_
6.156638,6.508274,6.716974,6.537399,5.799679,5.023573,3.952043,2.816395,_
1.884106,1.239403,0.8376049,0.5430527,0.3434473,0.2138509,0.1370105,0.09310938,_
0.07152327,0.06865635,0.08218077,0.1149235,0.173632,0.268204,0.4270169,_
0.6937134,1.149075,1.741345,2.518664,3.422181,4.406437,5.458829,6.28513,_
6.619962,6.626824,6.567548,6.234084,5.620764,5.213687,4.939784,4.561222,_
4.206711,3.892003,3.483784,3.026665,2.610329,2.204345,1.795022,1.443371,_
1.131254,0.8515016,0.6111687,0.4530462,0.3345318,0.2458475,0.1760992,0.1220429,_
0.08185368,0.05332974,0.03378642,0.02083063,0.01251665,0.00733436,0.00419277,_
0.00233939,0.00127443,6.778521E-04,3.520958E-04,1.785976E-04,8.848157E-05,_
4.281118E-05,2.023086E-05,9.336285E-06,4.208982E-06,1.852185E-06,7.967886E-07,_
3.338109E-07,1.372269E-07,5.45365E-08,2.149415E-08,8.010592E-09,3.052E-09,_
1.03681E-09,2.8751E-10,_
 4.9608E-11,1.70899E-10,4.653712E-10,1.268005E-09,3.183325E-09,8.612618E-09,_
2.062771E-08,5.329156E-08,1.301349E-07,3.095434E-07,6.824886E-07,1.587244E-06,_
3.220664E-06,5.706716E-06,1.46463E-05,3.103372E-05,6.206697E-05,1.081776E-04,_
2.249177E-04,4.335198E-04,7.70869E-04,0.00134024,0.00242185,0.00357747,_
0.00673181,0.01031275,0.01427398,0.02377995,0.03662988,0.05679513,0.07792263,_
0.1100839,0.1525632,0.1946161,0.2494591,0.3248332,0.4075008,0.4914602,0.5743995,_
0.6876515,0.6060795,0.6858177,0.8815576,0.9357074,0.9916917,1.10748,0.9914528,_
1.301544,1.317388,1.454336,1.406977,1.393294,1.225813,1.063591,0.8373255,_
0.6049002,0.3935356,0.2374584,0.2057975,0.1013267,0.08379802,0.0407576,_
0.02829883,0.0189485,0.01576933,0.01280542,0.0172822,0.02190371,0.0356992,_
0.05102685,0.1070276,0.133128,0.1823244,0.2875422,0.4017501,0.6996564,0.9088019,_
0.8967167,1.160261,1.347292,1.314041,1.370304,1.232144,1.231536,1.132484,_
1.100809,0.992679,0.9550873,0.866236,0.7873654,0.6414064,0.6002821,0.5050672,_
0.4278017,0.3535083,0.2841874,0.2091852,0.1706935,0.09918191,0.09146189,_
0.06652979,0.04472312,0.03152632,0.02052468,0.01296659,0.0083878,0.00505438,_
0.00304122,0.00177356,9.903648E-04,5.715138E-04,3.025529E-04,1.550862E-04,_
8.594874E-05,3.462698E-05,2.156634E-05,1.037395E-05,4.786161E-06,2.281502E-06,_
1.002156E-06,4.084811E-07,1.737675E-07,7.812662E-08,3.161211E-08,9.50683E-09,_
5.177934E-09,1.702763E-09,7.223011E-10,2.236239E-10,7.473158E-11

CM245FJEFF311:
Data 56,187, _
 4.524E-10,1.35997E-09,3.82518E-09,1.00375E-08,2.553157E-08,6.310542E-08, _
1.52829E-07,3.615319E-07,8.369171E-07,1.894306E-06,4.193684E-06,9.080388E-06, _
1.922916E-05,3.9828E-05,8.068168E-05,1.598633E-04,3.097893E-04,5.872135E-04, _
0.00108863,0.00197444,0.00350341,0.00608161,0.0103316,0.01718326,0.02798409, _
0.0446436,0.0698161,0.1070673,0.1610344,0.2379433,0.3447539,0.4854901,0.6546551, _
0.8597984,1.096045,1.372719,1.685845,2.02197,2.356573,2.707614,3.081677, _
3.384701,3.655252,4.009536,4.352247,4.623372,4.999733,5.422096,5.798449, _
6.322901,6.656915,6.509066,5.943144,5.405818,4.515687,3.474073,2.530931, _
1.742289,1.162537,0.7811698,0.5054791,0.3198791,0.2033163,0.1357814,0.1001683, _
0.08822716,0.1007138,0.1353012,0.1986301,0.3018879,0.4602425,0.7266697,1.156511, _
1.741385,2.477039,3.353635,4.284553,5.27287,6.040033,6.321909,6.376714,6.402864, _
6.172091,5.65828,5.244024,4.91378,4.546403,4.241833,3.935434,3.526351,3.100507, _
2.713913,2.316669,1.904867,1.551324,1.24155,0.9643524,0.7213874,0.5415037, _
0.4010721,0.2964663,0.2150446,0.1516647,0.1039459,0.06942473,0.04520259, _
0.028709,0.01780312,0.01078388,0.00638188,0.00369185,0.00208807,0.00115473, _
6.244752E-04,3.302613E-04,1.708116E-04,8.64082E-05,4.275175E-05,2.068123E-05, _
9.790115E-06,4.526685E-06,2.051342E-06,9.038918E-07,3.931576E-07,1.64246E-07, _
6.88694E-08,2.663182E-08,1.09861E-08,4.25473E-09,1.52014E-09,5.70002E-10, _
1.3284E-10, _
 1.212651E-10,3.55018E-10,9.51052E-10,2.393416E-09,6.050199E-09,1.510267E-08, _
3.337728E-08,8.811123E-08,2.020805E-07,4.600786E-07,1.001698E-06,2.163665E-06, _
4.179698E-06,7.445095E-06,1.900335E-05,3.881425E-05,7.219506E-05,1.326385E-04, _
2.628968E-04,4.702522E-04,8.531349E-04,0.00141034,0.00247321,0.00382823, _
0.00669731,0.01001086,0.01374683,0.02376789,0.03489708,0.05250316,0.07513605, _
0.1001167,0.1405376,0.1817396,0.2304001,0.3031175,0.3594923,0.4563029,0.5340899, _
0.62217,0.6130026,0.5850894,0.8185105,0.9179467,0.9576496,1.083772,0.88936, _
1.238164,1.240262,1.368088,1.433311,1.353149,1.326541,1.141336,0.989557, _
0.735857,0.4649492,0.3520917,0.2804784,0.1471289,0.1228272,0.05921574,0.0448458, _
0.02831837,0.02103221,0.01734264,0.02135143,0.02575277,0.0358218,0.05823127, _
0.1168471,0.1453407,0.2117749,0.2950664,0.4074375,0.6910899,0.8855488,0.8991193, _
1.158467,1.320164,1.28865,1.373242,1.248756,1.238556,1.114111,1.092672, _
0.9929281,0.9388437,0.8685009,0.7719167,0.6423296,0.6121296,0.5254186,0.4462875, _
0.3653281,0.3057932,0.2305242,0.1882491,0.1166957,0.1030995,0.07790855, _
0.05388393,0.03860829,0.02600975,0.01658165,0.01121148,0.0070327,0.00428983, _
0.00263375,0.00150583,8.927684E-04,5.037402E-04,2.709152E-04,1.526495E-04, _
6.606172E-05,4.113745E-05,2.113124E-05,1.011688E-05,5.060248E-06,2.348072E-06, _
1.006506E-06,4.632491E-07,2.169525E-07,9.177599E-08,3.18629E-08,1.639278E-08, _
5.969398E-09,2.648265E-09,8.413054E-10,3.38833E-10,1.371017E-10,4.4328E-11

CM245TJEFF311:
Data 55, 187, _
 1.1313E-10,4.4084E-10,1.32545E-09,3.67931E-09,9.60699E-09,2.453541E-08, _
6.074672E-08,1.470145E-07,3.482019E-07,8.06396E-07,1.82652E-06,4.046109E-06, _
8.766311E-06,1.857587E-05,3.850064E-05,8.289974E-05,6.84995E-05,9.909902E-05, _
3.28995E-04,0.00107,0.00195001,0.00430994,0.00671984,0.01199347,0.02088593, _
0.03537052,0.05810098,0.0923507,0.1439556,0.2183246,0.4112244,0.7632759, _
0.7139973,0.9380698,1.134037,1.264888,1.461847,1.573467,2.185065,2.453882, _
2.86229,3.00473,3.298919,3.870572,4.093795,4.689521,5.00826,5.455843,5.887335, _
5.823497,6.294816,6.162008,5.703785,4.943045,5.143551,4.133343,3.403205, _
2.376571,1.932527,1.198087,0.6275846,0.1605712,0.1496798,0.1080645,0.07500516, _
0.05407704,0.04406148,0.04876708,0.05565857,0.06893422,0.08388618,0.2347402, _
0.4424227,0.6739447,1.150286,1.815135,2.972489,4.348925,5.464472,5.807351, _
6.154596,4.301072,7.049584,5.694214,7.062569,6.919224,5.348296,4.907304,4.47149, _
4.157902,3.08629,2.579478,2.543568,2.736636,2.283737,1.666882,1.122311,1.124897, _
1.053631,0.766686,0.5574474,0.4001137,0.284014,0.196641,0.1327509,0.08767285, _
0.05649118,0.03551104,0.02181131,0.01308856,0.0076738,0.00439889,0.00246578, _
0.00135177,7.248806E-04,3.802642E-04,1.951619E-04,9.79927E-05,4.814564E-05, _
2.313334E-05,1.088373E-05,5.000382E-06,2.254798E-06,9.865461E-07,4.279148E-07, _
1.770155E-07,7.427977E-08,2.827411E-08,1.175163E-08,4.55954E-09,1.62464E-09, _
5.5114E-10,1.4372E-10, _
 3.8262E-11,1.179462E-10,3.449181E-10,8.996371E-10,2.315135E-09,5.668025E-09, _
1.451651E-08,3.290532E-08,8.351716E-08,1.939172E-07,4.46428E-07,9.535619E-07, _
2.121671E-06,4.135652E-06,5.633983E-06,1.219685E-05,1.099798E-05,1.464191E-05, _
4.39027E-05,1.195385E-04,2.710244E-04,5.992271E-04,7.217478E-04,0.00293873, _
0.00454925,0.00870441,0.013788,0.01938472,0.03208579,0.05778081,0.05743335, _
0.1017387,0.08616775,0.1302776,0.1365675,0.1695086,0.1772664,0.2060746, _
0.2866513,0.2663541,0.3775555,0.3188255,0.3574327,0.4480533,0.5053887,0.5554878, _
0.5896556,0.580874,0.7852049,0.6118287,0.8151127,0.7835923,0.6777415,0.59637, _
0.5977952,0.5304835,0.3451165,0.2911324,0.2095944,0.0927589,0.04464934, _
0.09162044,0.04257705,0.03012704,0.0180732,0.01280207,0.00918179,0.01012227, _
0.01033135,0.01237272,0.01161045,0.05043281,0.03492266,0.04508309,0.1119579, _
0.1781905,0.2908638,0.4814035,0.5260123,0.6295668,0.9131989,1.143188,1.168161, _
0.8921841,0.9456113,0.856688,0.6990268,0.6662712,0.5659055,0.6045271,0.3729218, _
0.3151633,0.3134907,0.4441299,0.4076622,0.3431574,0.1615358,0.2588657,0.2342418, _
0.1630734,0.1420756,0.1046892,0.07126959,0.04984157,0.03360704,0.02111094, _
0.01403524,0.00871668,0.00520727,0.00321577,0.00183361,0.00105774,5.978168E-04, _
3.162142E-04,1.766399E-04,7.633965E-05,4.694724E-05,2.396292E-05,1.133843E-05, _
5.6315E-06,2.637427E-06,1.128907E-06,5.138126E-07,2.372343E-07,9.890871E-08, _
3.523981E-08,1.780747E-08,6.49338E-09,2.84981E-09,8.764139E-10,3.69696E-10, _
1.463655E-10,4.7157E-11

NP237FJEFF311:
Data 59, 176,_
 1.1667E-10,6.51659E-10,2.53525E-09,8.97461E-09,3.080329E-08,1.010592E-07,_
3.192157E-07,9.709441E-07,2.843883E-06,8.020927E-06,2.178432E-05,5.697038E-05,_
1.434779E-04,3.479383E-04,8.126938E-04,0.00182833,0.00396356,0.00828595,_
0.01671897,0.03261835,0.06160321,0.112459,0.1955496,0.324246,0.4863071,0.769125,_
0.9505458,1.310098,1.770178,2.201673,2.277931,3.336484,3.856861,4.440887,_
5.129881,5.122239,5.66324,5.532341,6.233792,6.122685,7.669163,6.565655,6.194275,_
5.90262,5.429869,4.210467,2.979394,2.282231,1.28809,0.6551766,0.3189307,_
0.1594498,0.09158097,0.06273945,0.04459356,0.04289824,0.04304602,0.04687415,_
0.04993814,0.05331422,0.05330271,0.05180392,0.0498351,0.04603448,0.04709373,_
0.0587087,0.09173127,0.1485118,0.4307813,0.769569,1.695875,2.135862,3.73521,_
4.689332,6.691145,7.346054,7.622943,6.934613,6.401056,6.299452,5.738315,_
5.746314,5.198895,4.92518,4.721971,4.124015,3.217588,2.811502,2.219253,1.74067,_
1.275849,0.9867069,0.7110801,0.4570954,0.2825783,0.1852062,0.1253031,0.08526534,_
0.04693528,0.02467529,0.01240903,0.00598398,0.0027719,0.0012347,5.292237E-04,_
2.183248E-04,8.670916E-05,3.315735E-05,1.220896E-05,4.329069E-06,1.47818E-06,_
4.859832E-07,1.5395E-07,4.69442E-08,1.378852E-08,3.87617E-09,9.957301E-10,_
1.6278E-10,_
 2.3326E-11,1.138439E-10,4.102334E-10,1.375098E-09,5.315016E-09,1.532811E-08,_
5.39265E-08,1.637418E-07,4.436991E-07,1.216033E-06,2.837884E-06,8.686679E-06,_
2.445801E-05,5.496439E-05,1.276743E-04,2.89936E-04,6.261961E-04,0.00142082,_
0.002491,0.005379,0.00932714,0.01585955,0.0280788,0.04039541,0.05749447,_
0.0757013,0.1100279,0.165129,0.2005249,0.2811525,0.3133406,0.3473034,0.4875978,_
0.5253897,0.6283123,0.5779808,0.6574076,0.6273386,0.5824518,0.7217464,0.913708,_
0.6257759,0.7938495,0.6204437,0.6498038,0.455036,0.3422908,0.3093128,0.1827693,_
0.09070461,0.04156142,0.02682353,0.01270057,0.01006947,0.00647681,0.00620271,_
0.00582553,0.00701642,0.00724359,0.00762416,0.00721416,0.00760488,0.00626017,_
0.00646028,0.00609639,0.00803768,0.01091222,0.02615382,0.06439326,0.1074903,_
0.2692228,0.2982743,0.3747199,0.5250437,0.6204264,0.7582949,0.8459914,0.762329,_
0.800808,0.6102082,0.7327272,0.6905808,0.6417815,0.5879381,0.5227097,0.5122217,_
0.3691276,0.2962395,0.2771598,0.172368,0.1625859,0.1198094,0.08474056,_
0.05580193,0.04407259,0.02133544,0.02042212,0.01488495,0.00822029,0.00379387,_
0.0021503,9.921923E-04,4.418635E-04,2.117114E-04,8.260025E-05,3.583323E-05,_
1.448544E-05,5.268389E-06,2.109072E-06,6.674125E-07,2.397509E-07,7.523165E-08,_
2.379079E-08,8.041528E-09,2.281324E-09,5.992432E-10,1.834237E-10,3.5113E-11

NP237TJEFF311:
Data 61,174, _
 2.0223E-10,1.386771E-09,5.29601E-09,1.96491E-08,6.98207E-08,2.365058E-07, _
7.68447E-07,2.395605E-06,7.165328E-06,2.056279E-05,5.661464E-05,1.495531E-04, _
3.790198E-04,9.215436E-04,0.0021499,0.00481249,0.01033867,0.02132542,0.04229305, _
0.08090887,0.1507028,0.2693002,0.4562796,0.7023063,1.047019,1.47791,1.932216, _
2.276246,2.891834,3.38007,3.747773,4.249143,5.003494,5.158644,5.818604,6.227528, _
5.935063,6.282157,6.645452,6.863874,6.896276,7.270234,5.962242,3.934079, _
2.683428,1.374935,0.6114609,0.2667913,0.1246672,0.0644724,0.0371545,0.02409013, _
0.01775225,0.01467195,0.01310853,0.01280158,0.01273577,0.01273271,0.01285747, _
0.01317759,0.01398883,0.01590128,0.020099,0.02884872,0.04673564,0.08422739, _
0.1625658,0.393953,0.9318801,1.811905,3.45082,4.314743,6.559187,6.664904, _
7.831023,7.718759,6.716188,6.178952,5.92104,6.087778,6.081635,4.870094,4.941998, _
3.946914,3.488978,2.746382,2.496192,1.892456,1.593374,1.124242,0.7384127, _
0.44041,0.2771,0.167928,0.09707244,0.05263286,0.02710758,0.01333908,0.0062887, _
0.00284281,0.00123259,5.126153E-04,2.04527E-04,7.828815E-05,2.874955E-05, _
1.012998E-05,3.424436E-06,1.110773E-06,3.456786E-07,1.03195E-07,2.954807E-08, _
8.0712E-09,2.00814E-09,4.071E-10, _
 4.3745E-11,2.235824E-10,8.743473E-10,2.923048E-09,1.191481E-08,3.910634E-08, _
1.275503E-07,3.569465E-07,8.510449E-07,3.169482E-06,9.439494E-06,2.453059E-05, _
5.777072E-05,1.352844E-04,3.445047E-04,8.209078E-04,0.00156713,0.00362361, _
0.00596525,0.01184365,0.02179001,0.03494205,0.06397814,0.0926041,0.1299776, _
0.2245215,0.2492195,0.3092414,0.3977178,0.454898,0.5023265,0.5533676,0.6817185, _
0.6071491,0.7108451,0.7875559,0.627899,0.8898847,0.7471591,0.9068759,0.9507223, _
0.8577195,0.7704002,0.4146955,0.3265904,0.215617,0.0879139,0.03800179, _
0.01794355,0.01068559,0.00581054,0.00362956,0.00255729,0.00207252,0.00161222, _
0.00186981,0.00178212,0.00185266,0.00174403,0.00196411,0.0017718,0.00226884, _
0.00258484,0.00397952,0.00633445,0.01178509,0.02723429,0.04408595,0.1047026, _
0.2290523,0.4827195,0.53009,0.6291845,0.6936164,0.9732038,0.9541358,1.020227, _
0.6104692,0.907823,0.8158909,0.7873359,0.6678472,0.5707551,0.6277032,0.5642031, _
0.3661327,0.3513362,0.2879053,0.2564526,0.1914404,0.1214962,0.07881216, _
0.04497257,0.02561049,0.01633303,0.00864058,0.00467172,0.00199061,0.00100509, _
4.857653E-04,1.960487E-04,8.755835E-05,3.2241E-05,1.177569E-05,4.951845E-06, _
1.649031E-06,5.811547E-07,1.760276E-07,5.21637E-08,1.578224E-08,4.845287E-09, _
1.357432E-09,3.600035E-10,7.1452E-11

NP238FJEFF311:
Data 60, 177,_
 4.67286E-10,1.75658E-09,6.04287E-09,2.003572E-08,6.368177E-08,1.957776E-07,_
5.800994E-07,1.658928E-06,4.577643E-06,1.219004E-05,3.13266E-05,7.76872E-05,_
1.859159E-04,4.294004E-04,9.570391E-04,0.00205867,0.00427454,0.00856794,_
0.01658283,0.03099865,0.05598662,0.0977323,0.1649604,0.2690766,0.4240875,_
0.6487523,0.963163,1.388316,1.883025,2.423518,2.945649,3.693457,4.50095,_
5.260539,5.505934,5.745644,5.955714,6.374421,6.499872,6.689664,6.774806,_
7.209414,7.150096,6.274625,4.311986,2.72208,1.592188,0.9557525,0.5916723,_
0.3453517,0.1906778,0.1072186,0.06474763,0.04249088,0.03057403,0.02416192,_
0.02072334,0.0188738,0.01790925,0.01786631,0.01818217,0.01956274,0.0227542,_
0.02907851,0.04094643,0.06325131,0.10645,0.1928438,0.3641932,0.6768602,1.14852,_
1.344029,2.883214,7.51704,7.785303,7.731244,7.850492,7.423542,6.509592,6.290278,_
6.226939,6.13429,5.515867,4.914151,4.305883,3.820325,3.076685,2.346126,1.700541,_
1.25762,0.909785,0.6372799,0.4280099,0.2778837,0.1741496,0.1053051,0.06145253,_
0.03458261,0.01876642,0.00982132,0.00495753,0.00241389,0.00113392,5.139337E-04,_
2.247401E-04,9.48276E-05,3.860669E-05,1.516691E-05,5.749346E-06,2.103175E-06,_
7.42026E-07,2.52844E-07,8.296332E-08,2.634984E-08,7.99759E-09,2.36022E-09,_
6.3079E-10,1.2114E-10,_
 1.191221E-10,4.295877E-10,1.298189E-09,4.897202E-09,1.543844E-08,4.700951E-08,_
1.407092E-07,3.937915E-07,9.534066E-07,2.367179E-06,7.37549E-06,1.897531E-05,_
4.355726E-05,9.822771E-05,2.332835E-04,4.870086E-04,0.00104326,0.00199438,_
0.0038981,0.00708148,0.01338102,0.02132107,0.03360709,0.05981058,0.08816055,_
0.1387327,0.2055777,0.2850662,0.3767767,0.5034936,0.6106534,0.7605749,0.8668456,_
0.9785962,1.097269,1.115731,1.095688,0.9458346,1.103004,1.33573,1.324674,_
1.476726,1.237487,1.302927,0.9447931,0.7975709,0.540252,0.3071839,0.1805989,_
0.09746844,0.04784438,0.02695873,0.01494294,0.00948593,0.00577453,0.00523456,_
0.00474849,0.00372472,0.00398308,0.00375853,0.00383535,0.00381857,0.00485705,_
0.00575347,0.00742057,0.01235615,0.02299412,0.03643723,0.06360815,0.1024947,_
0.1613527,0.1553801,0.3382736,0.9547333,0.7683674,1.266735,1.036139,1.286454,_
1.178921,1.157618,1.144227,1.073592,1.058496,0.9539835,0.8645026,0.751903,_
0.5026327,0.509764,0.3813959,0.2942233,0.2144891,0.146164,0.1032481,0.0663618,_
0.04038699,0.02582911,0.0143996,0.00845322,0.0045738,0.00234163,0.00121184,_
5.748128E-04,2.715877E-04,1.24657E-04,5.427507E-05,2.31193E-05,9.144494E-06,_
3.629614E-06,1.405682E-06,4.98349E-07,1.713615E-07,6.122209E-08,1.941163E-08,_
6.43761E-09,1.954819E-09,5.703675E-10,1.641571E-10,3.9534E-11

NP238TJEFF311:
Data 60, 177,_
 4.92543E-10,1.86322E-09,6.42002E-09,2.154594E-08,6.931043E-08,2.151496E-07,_
6.452741E-07,1.867946E-06,5.220967E-06,1.408901E-05,3.670519E-05,9.231942E-05,_
2.241615E-04,5.254349E-04,0.00118888,0.0025964,0.00547266,0.01113124,0.02184515,_
0.04135028,0.07547134,0.1327462,0.224867,0.3665554,0.5745279,0.9087419,1.117886,_
1.375378,1.874445,2.241627,2.975161,3.407619,4.033092,4.573747,4.980233,_
5.180496,5.333941,5.700343,5.64977,6.199683,6.341628,6.377055,6.405128,6.281234,_
5.544231,4.379976,3.230384,1.975485,1.158984,0.6199951,0.3099736,0.1612749,_
0.08647928,0.04782775,0.02726857,0.01631562,0.01064672,0.00793447,0.00698634,_
0.00734878,0.00919782,0.01330433,0.02126916,0.03599538,0.0628731,0.1127945,_
0.2088642,0.3941395,0.7301739,1.261648,2.148934,3.83937,5.649951,6.471664,_
5.972138,7.468482,7.758842,7.043557,5.210388,5.129881,5.477938,6.227497,_
5.082359,4.143534,3.489945,3.839047,3.456833,2.74986,1.854636,1.325688,0.947997,_
0.6673654,0.4527487,0.2952927,0.1852349,0.1118699,0.06510479,0.03653171,_
0.01977188,0.01032471,0.00520203,0.00252929,0.00118677,5.374097E-04,_
2.348468E-04,9.904046E-05,4.030741E-05,1.583207E-05,6.000148E-06,2.195178E-06,_
7.739851E-07,2.639285E-07,8.649705E-08,2.752512E-08,8.28213E-09,2.47536E-09,_
6.671E-10,1.0795E-10,_
 1.249528E-10,4.398443E-10,1.407957E-09,5.280929E-09,1.720595E-08,5.271969E-08,_
1.524892E-07,4.362181E-07,1.169773E-06,2.612379E-06,8.872071E-06,2.226557E-05,_
5.121769E-05,1.146161E-04,2.936243E-04,6.322494E-04,0.00133651,0.00250143,_
0.00520787,0.00924151,0.01881641,0.0295699,0.04589362,0.08323158,0.136156,_
0.1017523,0.1554856,0.1807676,0.2629488,0.2756902,0.2944904,0.4662355,0.5357484,_
0.6292971,0.5674536,0.5784611,0.6290403,0.6289354,0.7217045,0.7886466,0.5805812,_
0.8536448,0.7615156,0.8237297,0.6158523,0.4809029,0.4281372,0.2576481,0.1363119,_
0.07198042,0.04292385,0.0388661,0.01949536,0.01043411,0.00505543,0.00349281,_
0.00240792,0.00151746,0.00153169,0.00154682,0.0019402,0.00259379,0.00461759,_
0.00710911,0.01169978,0.02254593,0.04846211,0.08166406,0.1527629,0.2741426,_
0.4096272,0.7904403,0.9868588,1.269834,1.550467,1.658013,1.313841,1.438171,_
1.362565,1.292784,1.27778,1.153427,1.123296,1.047709,0.9227162,0.8119951,_
0.5503689,0.5315585,0.4164779,0.3140823,0.2356128,0.1582143,0.1091189,_
0.07297546,0.04542365,0.02750415,0.01510866,0.00867651,0.00488245,0.00250872,_
0.00128451,6.011932E-04,2.740558E-04,1.314814E-04,5.827768E-05,2.420096E-05,_
9.687471E-06,3.673204E-06,1.454352E-06,5.354449E-07,1.877728E-07,6.43851E-08,_
1.990112E-08,6.600619E-09,2.083999E-09,6.053033E-10,1.741439E-10,3.7164E-11

PU238FJEFF311:
Data 60, 177,_
 5.26271E-10,1.98632E-09,6.724988E-09,2.234158E-08,7.089114E-08,2.16919E-07,_
6.407757E-07,1.826262E-06,5.023286E-06,1.333338E-05,3.415441E-05,8.443685E-05,_
2.014649E-04,4.640115E-04,0.00103177,0.00221598,0.0046003,0.00923817,0.01796929,_
0.03393077,0.06226324,0.1107337,0.1891006,0.3076811,0.4651563,0.6847156,_
0.9782754,1.355497,1.808811,2.345872,2.945562,3.537494,4.098288,4.615382,_
5.01795,5.264934,5.451239,5.543003,5.646955,6.021214,6.525054,6.799795,6.904837,_
6.592404,5.675134,4.402695,2.98624,1.743384,0.8326694,0.4213518,0.2265387,_
0.119985,0.06812576,0.04555167,0.03450902,0.02864265,0.02559606,0.02415146,_
0.02369093,0.02875427,0.03046158,0.03438172,0.04214288,0.05648167,0.08167329,_
0.1247994,0.2214689,0.4206388,0.8115969,1.269201,2.061407,3.455889,5.293236,_
6.937889,7.853494,7.791366,7.125328,6.533743,6.095528,5.71406,5.464271,5.294108,_
4.984715,4.519237,3.987358,3.394181,2.781663,2.205076,1.689491,1.239182,_
0.8752078,0.5895295,0.3835427,0.238713,0.1515983,0.09419344,0.05643158,_
0.03235099,0.01773329,0.00931633,0.00470373,0.00228596,0.00107027,4.831559E-04,_
2.103759E-04,8.83713E-05,3.582082E-05,1.401044E-05,5.288375E-06,1.926274E-06,_
6.770832E-07,2.296344E-07,7.518554E-08,2.374129E-08,7.14326E-09,2.117741E-09,_
5.64134E-10,8.5188E-11,_
 1.312586E-10,4.742853E-10,1.533305E-09,5.383559E-09,1.714976E-08,5.302382E-08,_
1.502121E-07,4.406321E-07,1.132583E-06,2.459744E-06,7.979004E-06,2.015014E-05,_
4.757854E-05,1.016171E-04,2.449343E-04,5.351315E-04,0.00109395,0.00212057,_
0.00429115,0.00709643,0.01417701,0.02295209,0.0333918,0.05876876,0.09433565,_
0.147453,0.2093456,0.2900831,0.4067719,0.5075583,0.6306057,0.7757605,0.8990642,_
1.038832,1.107135,1.207747,1.018519,0.9856523,1.269018,1.348218,1.438317,_
1.566751,1.265872,1.475092,1.158719,0.8985647,0.5833369,0.3469884,0.1870326,_
0.1054452,0.05755663,0.03036289,0.01530199,0.01169552,0.00847864,0.00596465,_
0.00612307,0.00541821,0.00555742,0.00535681,0.00614463,0.00626594,0.00632259,_
0.01023542,0.01687844,0.02512713,0.05473856,0.08118149,0.1360173,0.2469179,_
0.4201407,0.7709514,1.123811,1.097935,1.263678,1.471983,1.411885,1.375417,_
1.202222,1.232853,1.233434,1.192548,1.114512,1.043382,0.8846001,0.7911149,_
0.6053576,0.5134541,0.3780906,0.2888913,0.2116982,0.1458161,0.09489267,_
0.06378779,0.03099477,0.02485946,0.01453442,0.00801134,0.00442605,0.00224411,_
0.00113965,5.546665E-04,2.591323E-04,1.181243E-04,4.953479E-05,2.068237E-05,_
8.75051E-06,3.315445E-06,1.192112E-06,4.634449E-07,1.358354E-07,5.611195E-08,_
1.817263E-08,5.737517E-09,1.742514E-09,4.990183E-10,1.288247E-10,2.8332E-11

PU238TJEFF311:
Data 60, 177,_
 4.58641E-10,1.76928E-09,5.910536E-09,1.953441E-08,6.133749E-08,1.856884E-07,_
5.418242E-07,1.523524E-06,4.12962E-06,1.078898E-05,2.716984E-05,6.593664E-05,_
1.542122E-04,3.476049E-04,7.550419E-04,0.00158056,0.003189,0.00620195,_
0.01163082,0.02104093,0.03674504,0.06195907,0.1009421,0.1590185,0.242251,_
0.3565504,0.5063006,0.6282696,1.186503,1.500968,2.536237,2.563922,3.23186,_
3.622749,4.758658,5.536364,5.488785,5.718283,5.284704,6.08963,5.568053,6.808973,_
6.379086,7.872935,6.844737,5.782063,4.135548,2.647399,1.570313,1.376138,_
0.6081052,0.3316742,0.179434,0.09921513,0.05611876,0.03322109,0.02145478,_
0.01583861,0.01380992,0.01450926,0.01790447,0.02542512,0.03971849,0.0654933,_
0.1114575,0.1954878,0.3584672,0.6398614,1.331131,2.096236,3.684278,5.196496,_
7.850209,7.775482,7.753753,7.539053,6.226352,6.188953,6.041842,5.845547,_
4.653652,5.514535,5.230135,3.9135,2.406823,2.704457,1.277151,1.552063,0.8627616,_
0.9596901,0.5905974,0.4484166,0.322346,0.2198132,0.1426508,0.08837216,_
0.05242484,0.02984616,0.01632898,0.00859693,0.00436006,0.0021312,0.00100455,_
4.566296E-04,2.002149E-04,8.468582E-05,3.455584E-05,1.360284E-05,5.165641E-06,_
1.892492E-06,6.689183E-07,2.280274E-07,7.498827E-08,2.378283E-08,7.29121E-09,_
2.141466E-09,5.50318E-10,8.1407E-11,_
 1.135645E-10,4.175819E-10,1.390265E-09,4.717997E-09,1.50915E-08,4.506535E-08,_
1.246829E-07,3.699119E-07,9.692837E-07,2.01765E-06,6.264826E-06,1.526734E-05,_
3.685015E-05,7.223595E-05,1.813519E-04,3.861485E-04,7.430323E-04,0.00141443,_
0.00284432,0.0045076,0.00889513,0.01367267,0.02039488,0.03285882,0.05355524,_
0.07906537,0.1035817,0.104671,0.2311295,0.1778829,0.4293715,0.3151484,0.437174,_
0.4677589,0.4997675,0.7170975,0.9090459,0.6506073,1.173125,0.6559101,1.291371,_
0.8447368,1.215935,0.982136,0.6640689,0.7610227,0.9783206,0.7680131,0.4878848,_
0.1421429,0.1748938,0.08425492,0.03809862,0.0229681,0.01238886,0.0062281,_
0.00474175,0.00322304,0.00291446,0.00290711,0.00394422,0.00494278,0.00661152,_
0.01267351,0.02417765,0.03765423,0.08560042,0.06483161,0.2014567,0.2233281,_
0.5361674,0.5993495,0.7497223,0.6619715,0.8743011,0.8531018,1.140973,0.6789255,_
0.6628388,0.7598354,1.072528,0.7213074,0.5306029,0.4987382,0.6595922,0.3436423,_
0.437762,0.202439,0.297624,0.1912736,0.1810363,0.1328254,0.08860953,0.0589239,_
0.02964055,0.02182827,0.01319339,0.00727369,0.0040462,0.00206075,0.00101646,_
5.218028E-04,2.468166E-04,1.110906E-04,4.802895E-05,1.946073E-05,8.412052E-06,_
3.286368E-06,1.222367E-06,4.603589E-07,1.305276E-07,5.521934E-08,1.845136E-08,_
5.739402E-09,1.783664E-09,5.023228E-10,1.286195E-10,2.764E-11

PU239FJEFF311:
Data 58, 179,_
 1.4051E-10,6.4855E-10,2.311801E-09,7.83395E-09,2.439208E-08,7.31415E-08,_
2.125106E-07,5.979609E-07,1.630292E-06,4.305933E-06,1.101812E-05,2.731393E-05,_
6.55956E-05,1.526166E-04,3.439984E-04,7.512672E-04,0.00158968,0.00326102,_
0.00648772,0.01252802,0.02350898,0.04295497,0.07656527,0.1332527,0.2257088,_
0.3271475,0.5120786,0.6319832,0.8085424,1.019081,1.428074,1.74752,2.059168,_
2.585857,3.055362,3.848504,4.322122,4.706798,4.892562,4.94197,5.661466,5.850431,_
6.614173,6.63165,6.758747,6.586643,6.679734,5.288065,4.129489,3.141504,2.060112,_
1.43054,0.7331464,0.4089463,0.1428595,0.1285589,0.09569,0.07667251,0.06214241,_
0.05453379,0.05111664,0.05386768,0.0529884,0.05396182,0.05839192,0.06913435,_
0.09204783,0.1376898,0.2085015,0.5273316,1.004255,1.311953,2.87469,4.086217,_
5.177355,7.025831,7.519736,7.539901,7.191817,6.453832,5.837061,5.536354,_
5.324984,5.008326,4.984378,4.300933,3.505552,3.037302,2.526841,1.92901,1.696362,_
1.275374,1.010646,0.7965853,0.6147854,0.3958351,0.2670744,0.1705332,0.127002,_
0.1048175,0.05411579,0.02863804,0.01442773,0.00696419,0.00351963,0.00172724,_
8.201184E-04,3.769402E-04,1.677474E-04,7.229089E-05,3.017078E-05,1.219586E-05,_
4.774385E-06,1.810522E-06,6.649891E-07,2.366085E-07,8.15207E-08,2.72037E-08,_
8.74304E-09,2.648787E-09,7.7356E-10,1.4018E-10,_
 2.8745E-11,1.126517E-10,4.07383E-10,1.238926E-09,3.80446E-09,1.244945E-08,_
3.216413E-08,1.027541E-07,2.690118E-07,6.855724E-07,1.673445E-06,3.468545E-06,_
1.026285E-05,2.541353E-05,5.469887E-05,1.185485E-04,2.435817E-04,5.290214E-04,_
0.00111076,0.00185018,0.0039595,0.0063286,0.01130002,0.01954193,0.02750487,_
0.04100343,0.05003602,0.078695,0.1048493,0.114443,0.1843532,0.1985188,0.2315632,_
0.3153286,0.3712198,0.4889012,0.4626992,0.5773883,0.5523859,0.4659716,0.6756623,_
0.6654214,0.7102311,0.9316387,0.76831,0.8282929,0.7605718,0.6077693,0.5576413,_
0.4594609,0.3621801,0.1940218,0.1149165,0.03632224,0.01959621,0.01619479,_
0.01321378,0.00852708,0.00848994,0.00808157,0.0074472,0.00734961,0.00772288,_
0.006983,0.00754818,0.00852272,0.01308316,0.01705,0.03481269,0.06780685,_
0.1068134,0.1392895,0.3037814,0.4397199,0.556731,0.6359859,0.7977557,0.7852305,_
0.8252025,0.7414878,0.6099517,0.690792,0.6286659,0.6342111,0.5285246,0.5035875,_
0.4436852,0.3342743,0.2786894,0.2209193,0.1808727,0.15922,0.1195668,0.1046258,_
0.06534404,0.07607992,0.03623224,0.0301913,0.01862363,0.0128417,0.00922916,_
0.00494678,0.00231733,0.00107217,5.540088E-04,2.791669E-04,1.417554E-04,_
5.756608E-05,2.865668E-05,1.200244E-05,4.393982E-06,2.113063E-06,6.706741E-07,_
2.966031E-07,1.114876E-07,3.668226E-08,1.377252E-08,4.401264E-09,1.323864E-09,_
4.401216E-10,1.228978E-10,3.1501E-11

PU239TJEFF311:
Data 59,178, _
 1.0897E-10,5.65319E-10,2.09736E-09,6.763485E-09,2.087094E-08,6.235862E-08, _
1.800097E-07,5.018889E-07,1.351206E-06,3.514441E-06,8.83152E-06,2.144166E-05, _
5.029579E-05,1.139978E-04,2.893904E-04,7.009812E-04,0.00162406,0.00360524, _
0.00768489,0.02912328,0.05503818,0.1004153,0.1772274,0.232467,0.2816298, _
0.4713059,0.5926243,0.7691625,0.9562517,1.295852,1.709381,2.031805,2.446863, _
3.003193,3.866441,4.368547,4.966656,4.937536,5.231813,5.904862,6.205152, _
6.840144,6.176208,6.080756,6.94751,6.074127,5.764688,4.192826,3.176932,2.055912, _
1.673453,0.6247631,0.307829,0.1282282,0.08104811,0.05392566,0.03643073, _
0.04574685,0.04574626,0.04569422,0.04871639,0.04326416,0.05508492,0.06971858, _
0.08900807,0.1283146,0.1171306,0.3136099,0.4615657,0.8325348,1.406729,2.793839, _
3.724191,5.274308,6.994277,6.865147,7.392187,6.83918,6.709626,6.122463,5.984972, _
5.334993,5.205584,4.965839,4.482863,3.755741,3.038094,2.496512,2.043637, _
1.657762,1.263032,0.9770342,0.775712,0.6080474,0.380336,0.2808341,0.1740334, _
0.109747,0.07666244,0.04150638,0.02144355,0.0104772,0.0049005,0.00240481, _
0.00114045,5.22997E-04,2.319256E-04,9.94475E-05,4.123243E-05,1.653127E-05, _
6.40881E-06,2.402216E-06,8.709326E-07,3.051622E-07,1.034973E-07,3.384745E-08, _
1.075267E-08,3.27106E-09,8.66698E-10,1.7293E-10, _
 2.3943E-11,9.958917E-11,3.380468E-10,1.08041E-09,3.262765E-09,9.786251E-09, _
3.069482E-08,8.079902E-08,2.298474E-07,5.095314E-07,1.112492E-06,3.410303E-06, _
7.92379E-06,1.91169E-05,4.226448E-05,1.014247E-04,2.735666E-04,5.991025E-04, _
0.0010843,0.00429801,0.00782629,0.01660907,0.02723524,0.03369138,0.03367319, _
0.04255149,0.07540601,0.09634265,0.1205356,0.1537851,0.1816739,0.2335392, _
0.2959343,0.3843133,0.463121,0.4357675,0.6060408,0.5520173,0.5518149,0.7165741, _
0.6479974,0.8063838,0.7948882,0.700157,0.8485106,0.5913391,0.6549901,0.5440679, _
0.3776205,0.2657738,0.2044965,0.07281673,0.03569585,0.0160795,0.00903392, _
0.00653125,0.00413331,0.00535885,0.00530068,0.00534294,0.00563516,0.00627691, _
0.00708961,0.00806115,0.01103046,0.01572293,0.01384545,0.04215714,0.045793, _
0.06977163,0.1356672,0.2521319,0.3983091,0.5481151,0.5999695,0.7062606, _
0.8453152,0.7596519,0.7847755,0.5715434,0.7372179,0.6676667,0.639071,0.5567422, _
0.4770662,0.4514509,0.3657483,0.2705267,0.2440306,0.1578815,0.158404,0.1225898, _
0.09620278,0.06868704,0.04581421,0.03205089,0.02658292,0.0157207,0.01114903, _
0.00615277,0.00319725,0.00172485,7.065606E-04,4.00734E-04,1.748606E-04, _
8.452799E-05,3.871852E-05,1.610213E-05,7.056657E-06,2.498735E-06,1.022655E-06, _
3.669889E-07,1.380574E-07,5.184556E-08,1.673362E-08,5.147859E-09,1.835915E-09, _
5.222348E-10,1.480513E-10,3.644E-11

PU240FJEFF311:
Data 59, 180,_
 1.1433E-10,5.69092E-10,1.98857E-09,6.36179E-09,1.97905E-08,5.91768E-08,_
1.711267E-07,4.792907E-07,1.298606E-06,3.404873E-06,8.639823E-06,2.121843E-05,_
5.043566E-05,1.160075E-04,2.751109E-04,6.298608E-04,0.00139358,0.00298285,_
0.006187,0.01246886,0.02451351,0.04724917,0.08974431,0.1676309,0.2298961,_
0.3967135,0.4487862,0.6396699,0.8883919,1.004302,1.781749,1.841228,2.261477,_
2.729629,3.696743,3.994789,4.512196,4.791316,5.231059,5.540571,6.093576,_
6.829894,6.450223,6.601505,6.702221,6.752525,5.455358,5.105473,3.424918,_
2.483893,1.715012,0.8829104,0.4957918,0.2317315,0.1511351,0.09199597,0.06454151,_
0.0484576,0.04066917,0.03629292,0.03611986,0.03521487,0.03602476,0.03934627,_
0.04664674,0.06085696,0.08694138,0.221259,0.4462352,0.8766143,1.643736,2.642766,_
3.571691,4.652135,6.982941,7.179391,7.570003,6.597792,6.650034,6.395078,5.83112,_
5.499525,4.717813,4.780601,4.532631,3.980439,3.140093,2.577058,2.146455,_
1.797326,1.328578,1.066888,0.8305084,0.6133732,0.4637183,0.287613,0.2209809,_
0.1599633,0.1103117,0.05788643,0.03190361,0.019479,0.01212485,0.00918302,_
0.00609065,0.00365102,0.00202714,0.00105678,5.215339E-04,2.450025E-04,_
1.099657E-04,4.120544E-05,1.492037E-05,5.218479E-06,1.764553E-06,5.754731E-07,_
1.818623E-07,5.51112E-08,1.627009E-08,4.555709E-09,1.270943E-09,2.60662E-10,_
 2.2808E-11,9.90655E-11,3.243796E-10,9.667253E-10,3.423168E-09,9.004626E-09,_
2.871256E-08,8.134338E-08,2.016399E-07,5.14572E-07,1.139071E-06,3.20489E-06,_
8.650451E-06,1.529199E-05,4.30394E-05,1.011827E-04,2.182849E-04,5.095286E-04,_
9.268887E-04,0.00202997,0.00372305,0.0065735,0.01243682,0.01905663,0.02724751,_
0.0398376,0.05170269,0.08225708,0.09805506,0.1312291,0.2020053,0.1908598,_
0.2881865,0.3216877,0.4553668,0.4497088,0.5226638,0.5371565,0.4923515,0.6572974,_
0.7846439,0.6645006,0.8645695,0.7321149,0.8774013,0.7680758,0.684271,0.6610414,_
0.5673983,0.4268559,0.2432556,0.1352877,0.04928733,0.02797419,0.02268952,_
0.01279516,0.00828989,0.00726033,0.00595083,0.0054017,0.00483787,0.00512836,_
0.00451427,0.00551941,0.00614885,0.00777628,0.01100203,0.03742484,0.03569105,_
0.1085492,0.1921965,0.3032985,0.3580865,0.5228942,0.6524109,0.7397233,0.8514488,_
0.7312237,0.8313822,0.6306144,0.7832539,0.6780528,0.6129449,0.5891785,0.5111594,_
0.4921045,0.3684786,0.2829658,0.2806939,0.18067,0.1713288,0.1326967,0.1003972,_
0.07890344,0.0613845,0.03613934,0.03024305,0.02456718,0.02098513,0.01014353,_
0.00478487,0.00336216,0.00159536,0.0016078,9.64243E-04,6.055263E-04,_
3.401279E-04,1.68435E-04,9.023432E-05,3.779153E-05,1.783955E-05,6.379545E-06,_
2.306109E-06,8.935291E-07,2.9211E-07,8.840499E-08,3.150293E-08,8.740776E-09,_
2.544135E-09,7.760386E-10,1.946014E-10,4.592923E-11

PU241FJEFF311:
Data 58, 181,_
 2.6621E-10,8.9732E-10,2.739361E-09,8.34826E-09,2.42195E-08,6.90154E-08,_
1.902155E-07,5.095235E-07,1.326716E-06,3.358386E-06,8.263796E-06,1.976537E-05,_
4.595443E-05,1.038577E-04,2.281482E-04,4.871635E-04,0.0010111,0.00204029,_
0.00400271,0.00763595,0.01417041,0.02558789,0.04497065,0.07695591,0.1283935,_
0.199093,0.3492612,0.4101399,0.58671,0.7671427,0.9684558,1.440751,1.54572,_
1.909927,2.364938,2.984158,3.388353,3.889122,4.369895,4.610258,4.925787,_
4.152172,6.189285,6.332991,6.706284,5.921191,7.154385,7.309448,6.129899,_
5.692351,3.935445,2.302969,1.287819,0.8287504,0.4828974,0.2361526,0.1325457,_
0.07924287,0.04803498,0.02947157,0.01907693,0.01425435,0.01407256,0.01729274,_
0.02478897,0.03801722,0.05976613,0.09197226,0.156977,0.3029743,0.5705962,_
1.669679,2.262746,3.164108,4.592339,6.667201,7.707149,7.29762,6.932356,6.555657,_
6.311965,6.208563,5.362237,4.632149,4.65176,4.610057,4.183003,3.280454,2.740723,_
2.228075,1.942854,1.453301,1.200085,0.9102063,0.7114568,0.4528337,0.3718279,_
0.2307703,0.1526941,0.09754695,0.06021792,0.03604944,0.0209189,0.01177005,_
0.00642869,0.00340942,0.0017561,8.786968E-04,4.271794E-04,2.017975E-04,_
9.263383E-05,4.132584E-05,1.790969E-05,7.548273E-06,3.085552E-06,1.229525E-06,_
4.720622E-07,1.786054E-07,6.3971E-08,2.304088E-08,7.395695E-09,2.646709E-09,_
6.87572E-10,2.586E-10,_
 6.932819E-11,2.137633E-10,6.640162E-10,2.020991E-09,5.189014E-09,1.68636E-08,_
4.609791E-08,1.220699E-07,3.225164E-07,7.974078E-07,1.704808E-06,3.873615E-06,_
1.08122E-05,2.536589E-05,5.359172E-05,1.11637E-04,2.466858E-04,4.82224E-04,_
9.748427E-04,0.00177517,0.00330752,0.00583289,0.01061682,0.016315,0.0251819,_
0.02280547,0.03949006,0.04814311,0.0749677,0.09159751,0.1225519,0.2292962,_
0.1569524,0.2497886,0.290756,0.3560806,0.4174195,0.4373598,0.4780122,0.4621169,_
0.5640755,0.9483145,0.5809975,0.7955354,0.7389162,1.274833,0.793986,1.28501,_
0.7159191,0.9754944,0.7382613,0.5197213,0.3362285,0.2082613,0.1195134,_
0.05437985,0.02725818,0.01908651,0.01147237,0.0058181,0.00435849,0.00307152,_
0.00275548,0.00363528,0.00530482,0.00731175,0.01056181,0.01406603,0.02634488,_
0.04384966,0.07823033,0.2106288,0.2958835,0.3395921,0.5063275,0.7187724,_
0.7244613,0.916374,0.7390105,0.8372388,0.6820927,0.732975,0.6894733,0.6465069,_
0.5873488,0.5383909,0.4493518,0.4135893,0.2861023,0.2859728,0.2091613,0.1730328,_
0.1558776,0.1013899,0.0931144,0.1024616,0.03807169,0.05503805,0.03526355,_
0.02390984,0.01477758,0.00867628,0.00514588,0.00281455,0.0015461,8.278996E-04,_
4.245678E-04,2.144074E-04,1.011374E-04,4.831883E-05,2.26492E-05,9.791262E-06,_
4.134476E-06,1.827351E-06,7.220164E-07,3.003815E-07,1.152609E-07,4.280045E-08,_
1.583044E-08,5.4362E-09,1.911384E-09,6.445071E-10,1.931511E-10,6.725077E-11

PU241TJEFF311:
Data 58,182, _
 1.2507E-10,5.0047E-10,1.610608E-09,4.87964E-09,1.35338E-08,3.657483E-08, _
9.494334E-08,2.380994E-07,5.772343E-07,1.350289E-06,3.045526E-06,6.615012E-06, _
1.381144E-05,2.765527E-05,5.293796E-05,9.641715E-05,1.658727E-04,2.663118E-04, _
3.901884E-04,4.96348E-04,0.0033013,0.01020098,0.02540525,0.05669266,0.1181827, _
0.2045381,0.3673791,0.4377964,0.6318534,0.7650859,0.9899421,1.245358,1.54168, _
1.865928,2.267705,2.865092,3.241317,3.944619,4.236228,4.636166,4.85482,5.650375, _
5.752315,5.980621,6.229264,6.537284,6.672162,6.64483,5.956302,5.541071,4.359031, _
2.96647,2.030732,0.5110713,0.1902393,0.1288478,0.1337023,0.1223857,0.100792, _
0.07708539,0.05732941,0.04693229,0.05787249,0.09091912,0.1039296,0.1339718, _
0.1783423,0.2488535,0.3622275,0.5538545,0.808106,1.275758,1.96517,3.075804, _
4.528578,6.610333,7.486196,7.055423,6.668733,6.468416,6.468286,6.011676, _
5.765379,4.903961,4.71601,4.398757,4.12013,3.154078,2.658647,2.252059,1.878606, _
1.455799,1.155382,0.8564861,0.7178304,0.395311,0.3676938,0.1865079,0.1846181, _
0.1693982,0.1448025,0.1123928,0.09056869,0.06713165,0.04773525,0.02401849, _
0.01254154,0.00619486,0.00293056,0.0013365,5.894324E-04,2.51974E-04, _
1.042949E-04,4.199352E-05,1.632234E-05,6.20448E-06,2.239575E-06,8.125669E-07, _
2.720544E-07,9.41209E-08,2.674724E-08,9.559407E-09,2.525966E-09,8.3784E-10, _
1.245E-10, _
 4.1025E-11,1.353123E-10,4.07683E-10,1.1645E-09,2.939993E-09,8.945873E-09, _
2.330986E-08,5.80637E-08,1.376107E-07,3.169401E-07,6.671821E-07,1.237097E-06, _
3.306003E-06,6.709744E-06,1.218313E-05,2.134587E-05,4.064203E-05,6.413547E-05, _
9.539977E-05,7.275626E-05,7.801052E-04,0.00226096,0.00608002,0.01192669, _
0.02173279,0.02624068,0.04068434,0.06296027,0.08535531,0.09963986,0.1342863, _
0.1585217,0.1506653,0.2462751,0.2867901,0.3716313,0.3854288,0.4308344,0.4736221, _
0.4806359,0.5939253,0.6871252,0.5285291,0.7649285,0.6988798,0.8082995,0.7155398, _
0.7241744,0.7418371,0.6908708,0.5352959,0.4033454,0.1687284,0.04844083, _
0.02010463,0.05193951,0.04170237,0.03956351,0.02962915,0.01739832,0.01471927, _
0.01107544,0.01138025,0.01568226,0.01738865,0.0213562,0.02691755,0.03966529, _
0.06472308,0.08083488,0.1128303,0.1763989,0.2592885,0.3507871,0.4877753, _
0.707472,0.6923372,0.8679874,0.7907475,0.7915345,0.7345351,0.6593416,0.689594, _
0.5909463,0.5894414,0.5303518,0.3733849,0.3945657,0.2964815,0.2772628,0.2164365, _
0.1578046,0.1444398,0.1346927,0.09740566,0.08582181,0.04744598,0.08448745, _
0.06397586,0.05044369,0.03860804,0.02525444,0.02028508,0.0142902,0.00951385, _
0.00649168,0.00323797,0.00153995,7.157582E-04,3.143328E-04,1.429703E-04, _
6.114558E-05,2.502828E-05,1.026022E-05,3.792513E-06,1.488733E-06,5.608314E-07, _
1.957929E-07,6.909698E-08,2.242074E-08,6.970836E-09,2.400518E-09,6.928579E-10, _
2.188355E-10,4.2334E-11

PU242FJEFF311:
Data 57, 182,_
 1.1141E-10,5.0279E-10,1.60773E-09,4.69721E-09,1.356724E-08,3.767419E-08,_
1.023174E-07,2.701867E-07,6.946758E-07,1.739605E-06,4.242733E-06,1.007801E-05,_
2.331255E-05,5.251848E-05,1.152191E-04,2.461685E-04,5.121652E-04,0.00103754,_
0.00204644,0.00392961,0.00734498,0.01335968,0.02363529,0.04063002,0.06781644,_
0.1099006,0.1788342,0.3436719,0.3213853,0.542146,0.6231754,0.8260539,1.119628,_
1.623787,1.793073,2.165316,2.821453,3.105156,3.588485,4.254591,4.484224,4.8263,_
3.822687,6.080863,5.931653,6.400728,5.90624,6.839694,7.46053,5.907301,6.458767,_
4.902768,3.175749,1.619353,1.123909,0.6811797,0.3557268,0.1914359,0.1109921,_
0.06565464,0.03870678,0.02315766,0.01508152,0.01248141,0.01355169,0.01818133,_
0.02653077,0.03942304,0.05656728,0.1793177,0.3398848,0.5377946,1.123653,1.90913,_
3.097673,4.485125,6.824752,7.290654,6.941419,6.898016,6.329046,6.211994,_
6.006727,5.671585,5.237957,4.639979,4.600726,4.281936,3.412415,2.92228,2.382241,_
2.020387,1.582214,1.318452,0.9969849,0.7724664,0.5574377,0.4296874,0.2966189,_
0.2007159,0.1309749,0.08248821,0.05066147,0.03033836,0.01770821,0.01007454,_
0.00558232,0.00301232,0.00158286,8.097038E-04,4.033445E-04,1.955123E-04,_
9.234988E-05,4.235501E-05,1.899547E-05,8.216633E-06,3.50836E-06,1.409314E-06,_
5.808692E-07,2.146908E-07,8.574274E-08,2.669775E-08,1.118804E-08,3.089302E-09,_
1.25154E-09,2.1365E-10,_
 3.6552E-11,1.308368E-10,3.853958E-10,1.134766E-09,3.30571E-09,8.012613E-09,_
2.489627E-08,6.576008E-08,1.650905E-07,4.253371E-07,1.011562E-06,1.998461E-06,_
4.743958E-06,1.230835E-05,2.802668E-05,5.863126E-05,1.181876E-04,2.535579E-04,_
4.86147E-04,9.530574E-04,0.00171596,0.00311788,0.00552112,0.00986409,0.01455122,_
0.02376193,0.0205304,0.0405478,0.05700602,0.0657166,0.08258093,0.1025972,_
0.2307216,0.1775326,0.2269405,0.2835196,0.3255465,0.4114787,0.4150027,0.4487221,_
0.4800557,0.5365658,0.9374532,0.6039637,0.7603566,0.7632399,1.250901,0.7954593,_
1.288077,0.68718,1.026583,0.7927825,0.6115547,0.3914057,0.2747097,0.1665738,_
0.07307962,0.04172438,0.02764078,0.0153971,0.00765208,0.00544938,0.00339151,_
0.00232045,0.00301324,0.00398453,0.00503862,0.00769871,0.00642641,0.0293874,_
0.04996436,0.07226803,0.1953414,0.2456577,0.3611917,0.4541348,0.7505873,_
0.6768117,0.8716852,0.7675887,0.7474905,0.773371,0.6805623,0.703879,0.7394879,_
0.5699381,0.5801778,0.412545,0.4289368,0.3237172,0.2780501,0.2537729,0.1814407,_
0.2060632,0.1228176,0.09797946,0.1228202,0.04448023,0.06636548,0.04415343,_
0.0293649,0.01956313,0.01183464,0.00733758,0.00428894,0.00234587,0.00136051,_
7.316097E-04,3.773262E-04,1.976322E-04,9.59466E-05,4.689576E-05,2.238433E-05,_
1.005534E-05,4.633478E-06,1.960365E-06,8.402808E-07,3.543518E-07,1.382236E-07,_
5.526402E-08,2.103921E-08,7.076554E-09,2.838078E-09,8.721704E-10,3.285028E-10,_
7.303E-11

TH232FJEFF311:
Data 64, 167,_
 5.0063E-10,3.35121E-09,1.967121E-08,1.068471E-07,5.406675E-07,2.544064E-06,_
1.113688E-05,4.536419E-05,1.719195E-04,5.069482E-04,0.00134977,0.00319951,_
0.00656639,0.01090208,0.03284098,0.08939418,0.2244576,0.523977,1.136349,_
2.028927,4.355682,4.33759,7.00437,6.557125,6.785062,7.397813,7.598605,7.246544,_
7.057699,6.221395,5.513056,5.617894,5.1665,4.459243,3.777892,2.951718,1.733549,_
0.8630329,0.3716702,0.1543491,0.08810727,0.07111125,0.05443751,0.05367132,_
0.05374189,0.05364748,0.05917521,0.06475214,0.06922629,0.06860284,0.06758902,_
0.06621718,0.06738403,0.06748649,0.06714082,0.06637271,0.06519362,0.0636336,_
0.06172473,0.05954209,0.05730953,0.05595865,0.05922924,0.08007722,0.1698971,_
0.430824,0.8521578,1.513803,2.593239,4.51552,5.728245,5.562431,5.581997,_
6.498931,6.382286,7.249934,7.726444,7.165633,6.475632,6.511721,7.592594,_
5.165558,3.663119,3.038956,1.937787,1.115215,0.7740774,0.3990864,0.2998566,_
0.2019348,0.06250973,0.01579709,0.00252239,8.63723E-04,2.751054E-04,_
8.151036E-05,2.246488E-05,5.759175E-06,1.373082E-06,3.046578E-07,6.281873E-08,_
1.206203E-08,2.14105E-09,3.304E-10,_
 8.921663E-11,5.223831E-10,3.318946E-09,1.742239E-08,7.320048E-08,3.816415E-07,_
1.599637E-06,7.512884E-06,3.285107E-05,7.588745E-05,2.324649E-04,5.20748E-04,_
0.00100202,0.00164924,0.00518351,0.01390047,0.03467803,0.06534971,0.1435852,_
0.2377734,0.4486557,0.5298062,0.7046028,0.8276816,0.8199945,0.8712224,0.9061476,_
0.8505353,0.8564419,0.7595035,0.6859641,0.7176301,0.6309862,0.4848973,0.5491013,_
0.3251433,0.2371581,0.1316385,0.05125519,0.01473977,0.01253093,0.01018552,_
0.00672852,0.00917652,0.00841296,0.00792603,0.00930546,0.00972256,0.00988249,_
0.0094249,0.00952029,0.00904439,0.01007726,0.00878454,0.01040629,0.01041128,_
0.00827134,0.00988383,0.00890719,0.00774796,0.00845973,0.00716171,0.00858179,_
0.0090523,0.01871358,0.06156367,0.09180099,0.1784663,0.2710445,0.4788107,_
0.6144717,0.6331612,0.6325694,0.7667196,0.7911341,0.9210462,0.7980314,0.8983378,_
0.8227184,0.7587472,0.8263911,0.6664136,0.5316443,0.3968126,0.2448636,0.1695451,_
0.1503924,0.06224068,0.05671795,0.02783574,0.01101822,0.00255378,3.706218E-04,_
1.48753E-04,4.358608E-05,1.372412E-05,3.667989E-06,9.000082E-07,2.354631E-07,_
4.84632E-08,1.036421E-08,2.075976E-09,3.262791E-10,5.997074E-11

TH232HJEFF311:
Data 56, 174,_
 5.5019E-10,2.3632E-09,9.17356E-09,3.401784E-08,1.209574E-07,4.12272E-07,_
1.348289E-06,4.227733E-06,1.271397E-05,3.666413E-05,1.013979E-04,1.794925E-04,_
3.994842E-04,8.406696E-04,0.00166573,0.00308734,0.00529735,0.01080831,_
0.02114763,0.03966285,0.07128325,0.1231693,0.2850586,0.8149973,1.124318,1.46675,_
1.867058,2.501576,3.278447,4.043239,4.774272,5.268191,4.880947,6.081101,_
6.416555,5.934391,5.353342,5.539044,5.770501,4.896181,4.112999,3.080804,_
2.549891,1.970649,1.796888,1.600511,1.199981,0.8872695,0.9356024,1.008567,_
1.115047,1.079016,1.064531,1.035186,1.139233,1.186098,1.219559,1.199146,_
1.245344,1.203766,1.16519,1.139295,1.098551,1.055112,1.007722,0.9285755,_
0.9813122,0.9991412,1.019271,1.043293,1.079083,1.13807,1.35742,1.675468,_
1.818073,2.306367,2.985076,4.112753,5.853466,5.228192,6.443487,6.459269,_
6.158442,5.695233,5.703633,5.726675,5.118484,4.966833,3.893419,3.134827,_
2.416727,1.788211,1.383971,0.932354,0.4060638,0.1647212,0.1234163,0.0857629,_
0.07540592,0.05522876,0.03625844,0.01868963,0.00926435,0.00440106,0.00222371,_
0.00106001,4.188659E-04,1.586728E-04,5.763652E-05,2.007409E-05,6.7039E-06,_
2.147136E-06,6.592611E-07,1.942292E-07,5.480046E-08,1.486176E-08,3.84068E-09,_
8.8089E-10,1.3945E-10,_
 1.01365E-10,3.687763E-10,1.55909E-09,5.711922E-09,1.820913E-08,7.124124E-08,_
2.093668E-07,6.791851E-07,2.166864E-06,5.702811E-06,1.971305E-05,3.966703E-05,_
5.455158E-05,1.271619E-04,2.418472E-04,4.997149E-04,9.151164E-04,0.00164778,_
0.00361261,0.00663584,0.01070311,0.01939139,0.04983643,0.1348522,0.1968617,_
0.2425379,0.3400795,0.4291299,0.4754054,0.627922,0.6448352,0.7536418,0.5946543,_
0.7681878,0.8053703,0.6825274,0.6934416,0.6223289,0.803264,0.6470199,0.5284012,_
0.3610025,0.3498282,0.249949,0.2377714,0.1845463,0.1562102,0.08767355,0.1397434,_
0.1248573,0.1645402,0.1678246,0.1814041,0.1385981,0.1885474,0.1417811,0.1526303,_
0.1278496,0.1612636,0.1713246,0.1609537,0.1593953,0.156094,0.1418653,0.1464914,_
0.1127879,0.130009,0.1415253,0.1349206,0.1372845,0.1575467,0.1217451,0.1580052,_
0.1943692,0.2320479,0.2831431,0.3130004,0.4813916,0.5681424,0.6869902,0.7152499,_
0.8928049,0.8643742,0.6937937,0.7263634,0.6881567,0.6737949,0.6296243,0.5013828,_
0.484607,0.2944496,0.2286054,0.1901983,0.1394062,0.06606374,0.02778631,_
0.02062857,0.01229307,0.0108416,0.00950559,0.0064757,0.0030645,0.00154762,_
5.922733E-04,3.751166E-04,1.39221E-04,6.765682E-05,2.748677E-05,8.82643E-06,_
3.326295E-06,1.147735E-06,3.317445E-07,1.136511E-07,3.163493E-08,8.204846E-09,_
2.572633E-09,6.165035E-10,1.573564E-10,2.9971E-11

U233HJEFF311:
Data 50, 183,_
 4.67431E-10,1.49835E-09,4.26068E-09,1.2114E-08,3.338976E-08,8.89547E-08,_
2.305623E-07,5.815177E-07,1.427773E-06,3.412554E-06,7.93965E-06,1.798175E-05,_
3.965167E-05,8.512017E-05,1.779205E-04,3.621426E-04,7.178618E-04,0.00165736,_
0.00276267,0.00442573,0.00678947,0.00991677,0.0136452,0.02341929,0.03914121,_
0.06383391,0.1016654,0.1582707,0.2410834,0.3593285,0.5246999,0.7513074,1.054017,_
1.3555,1.904198,2.413611,2.961734,3.680335,4.303946,4.944003,5.118059,5.022214,_
4.960846,5.630594,4.82247,5.065806,4.045844,4.732566,3.62975,3.875259,3.266263,_
3.183043,2.981824,2.719266,2.254805,1.833379,1.465218,1.358419,1.312999,_
1.308542,1.263856,1.304992,1.613287,1.190061,1.120016,1.268428,1.358333,_
1.325454,1.296339,1.25551,1.218697,1.185318,1.223059,1.283128,1.389869,1.515679,_
1.787971,2.142933,2.50177,3.013161,3.692055,4.46966,4.01047,4.564736,4.806254,_
5.241959,5.808539,5.06987,5.852287,5.813451,4.711384,4.487783,3.74536,3.176975,_
2.458464,1.93343,1.505615,1.250699,0.9827468,0.8052726,0.6425695,0.4926097,_
0.2813071,0.1444467,0.09941628,0.06715163,0.04441362,0.0283671,0.0177306,_
0.01080926,0.00732857,0.00475,0.00277383,0.00157464,8.685947E-04,4.656215E-04,_
2.425878E-04,2.088336E-04,1.416672E-04,8.491886E-05,5.833317E-05,3.427107E-05,_
1.828967E-05,9.108424E-06,4.285842E-06,1.920992E-06,6.84593E-07,2.363406E-07,_
7.89673E-08,2.539023E-08,7.92164E-09,2.38328E-09,6.3163E-10,1.01E-10,_
 7.888985E-11,2.329642E-10,7.501478E-10,1.973814E-09,5.23848E-09,1.533877E-08,_
3.65397E-08,9.800297E-08,2.319668E-07,5.351818E-07,1.33236E-06,2.833867E-06,_
6.300452E-06,1.451489E-05,2.691943E-05,6.215936E-05,1.132441E-04,2.563553E-04,_
4.27295E-04,5.616656E-04,0.00107758,0.00164914,0.00181835,0.00379395,0.0059617,_
0.01035109,0.01731329,0.02352579,0.04060367,0.05385572,0.07958641,0.1152882,_
0.1418708,0.1880065,0.237621,0.3504534,0.4279904,0.5443309,0.5567733,0.6276235,_
0.7391571,0.619161,0.7163427,0.7697346,0.7611721,0.664385,0.6598497,0.4998226,_
0.6352401,0.4428682,0.5502498,0.4995484,0.3890964,0.3602004,0.2961701,0.1837675,_
0.229268,0.2368292,0.2398176,0.2333512,0.2377304,0.1675186,0.2082945,0.1733555,_
0.1961011,0.1592547,0.1643967,0.1669401,0.1704613,0.1544062,0.1541873,0.1469894,_
0.1354721,0.1779964,0.1903576,0.1246627,0.2381526,0.2278534,0.3192444,0.350942,_
0.4473099,0.5752139,0.4004567,0.4653468,0.4723397,0.6277096,0.6533431,0.6699092,_
0.71078,0.695069,0.6110361,0.5115537,0.5959912,0.373332,0.4120369,0.3326521,_
0.2422769,0.1827691,0.1543681,0.1451895,0.1060055,0.08866946,0.04226141,_
0.01950013,0.0150528,0.01081945,0.00581367,0.00486258,0.00280744,0.00176787,_
0.0011698,6.418114E-04,4.795032E-04,2.451329E-04,1.470288E-04,7.498954E-05,_
3.692534E-05,3.610372E-05,2.021457E-05,1.176283E-05,9.25914E-06,5.313832E-06,_
2.695802E-06,1.492902E-06,6.903339E-07,3.339732E-07,8.914753E-08,3.219878E-08,_
1.177926E-08,3.512033E-09,1.030057E-09,3.862632E-10,8.14222E-11,2.4501E-11

U233FJEFF311:
Data 62, 170,_
 0,9.4579E-10,5.04489E-09,2.360073E-08,1.033583E-07,4.273855E-07,1.664135E-06,_
6.108452E-06,2.113481E-05,6.892523E-05,2.118795E-04,6.139977E-04,0.00167695,_
0.00431802,0.01048093,0.0239902,0.05179587,0.1055597,0.2033324,0.3707386,_
0.6369959,0.9986075,1.644056,2.126556,2.781479,4.232288,5.131898,6.282197,_
6.473399,6.27389,6.464457,6.96255,6.786526,6.313634,5.741755,5.455955,5.186199,_
4.8688,4.424272,3.680554,2.60541,1.584523,1.011354,0.5534322,0.2908113,_
0.1608578,0.1009051,0.07649523,0.06758108,0.06452394,0.06326044,0.06225074,_
0.06099725,0.05855923,0.05841727,0.05959054,0.05961134,0.07330907,0.08230106,_
0.07953972,0.08239198,0.08989134,0.1192231,0.1491352,0.3248851,0.5046597,_
1.167666,1.734862,2.404957,3.85966,4.708497,5.7049,6.369227,6.284793,6.832733,_
6.579609,6.628489,6.480775,6.197686,6.48557,6.463239,5.38001,4.494411,3.239799,_
2.413354,1.737547,1.204002,0.717356,0.4657585,0.3115515,0.1935545,0.117914,_
0.06718502,0.03507173,0.01690652,0.01162429,0.0048512,0.00188921,0.00110047,_
4.93713E-04,1.403027E-04,3.752485E-05,9.445896E-06,2.237709E-06,4.988792E-07,_
1.046235E-07,2.063746E-08,3.83983E-09,5.7246E-10,_
 0,1.706843E-10,7.726206E-10,4.083739E-09,1.679623E-08,6.934369E-08,_
2.515101E-07,7.695315E-07,3.364303E-06,1.121938E-05,3.417647E-05,9.651339E-05,_
2.511984E-04,7.191949E-04,0.00178536,0.00359083,0.00893319,0.01558949,0.0321141,_
0.05727328,0.08436158,0.1238724,0.1565138,0.2712396,0.3549587,0.5365981,_
0.6584781,0.7313746,0.7406001,0.7807175,0.7982247,0.8740351,0.7301943,0.7696968,_
0.6556745,0.5162035,0.6255125,0.5603639,0.4688541,0.5081123,0.2887668,0.2175724,_
0.1317946,0.07510895,0.03094335,0.02480146,0.01659211,0.01204491,0.01089846,_
0.01043336,0.0084458,0.00915577,0.00896028,0.00612705,0.00915031,0.00749814,_
0.0081495,0.00940928,0.0098258,0.01140328,0.00901037,0.01212512,0.01613964,_
0.01249398,0.05885005,0.08943927,0.1749956,0.1954687,0.3100712,0.4305929,_
0.4572704,0.5143225,0.6706486,0.660408,0.7525678,0.7481782,0.6977828,0.7879698,_
0.7442357,0.8111994,0.6845204,0.6550428,0.5735216,0.3682464,0.2787386,0.1988472,_
0.1374226,0.09313729,0.06117784,0.04507603,0.02074089,0.02175674,0.00959802,_
0.00549959,0.00299181,0.00191013,7.883859E-04,3.310672E-04,1.743543E-04,_
8.988122E-05,2.20048E-05,6.057857E-06,1.630966E-06,3.41333E-07,8.531454E-08,_
1.73325E-08,3.011334E-09,6.654737E-10,8.768886E-11

U233TJEFF311:
Data 62, 169,_
 1.099E-10,9.3076E-10,4.84057E-09,2.350012E-08,1.07597E-07,4.635967E-07,_
1.882301E-06,7.19816E-06,2.592859E-05,8.799847E-05,2.815033E-04,8.501215E-04,_
0.0024321,0.00663563,0.01734889,0.03946484,0.06340129,0.126685,0.2492251,_
0.371062,0.5897504,1.068927,1.679939,2.177407,3.040307,3.963544,5.429362,_
6.07305,6.692459,6.577325,6.540326,6.901633,6.855971,6.403184,5.742572,5.538304,_
5.193081,5.041387,4.413127,3.218444,2.42945,1.458337,0.9748738,0.5003389,_
0.2509376,0.1156143,0.07971489,0.04205123,0.03953261,0.02471614,0.01433746,_
0.01577954,0.01732871,0.01924937,0.01772046,0.015067,0.01555563,0.01586121,_
0.01754454,0.01850904,0.01951978,0.02227233,0.03222127,0.1161486,0.2325086,_
0.4666618,0.9250669,1.63308,2.645763,3.565341,4.797522,5.982202,6.286812,_
5.499873,8.631292,6.286482,6.031606,5.63635,6.449814,6.218102,6.818098,5.914317,_
4.655778,3.401131,2.529112,1.826728,1.293586,0.7689478,0.4884973,0.3333217,_
0.1962262,0.1062122,0.04580951,0.02137106,0.01090498,0.00687199,0.00264161,_
9.555746E-04,3.499021E-04,1.194178E-04,3.376192E-05,8.979492E-06,2.247023E-06,_
5.290951E-07,1.172476E-07,2.444142E-08,4.7344E-09,8.0013E-10,_
 2.2464E-11,1.413459E-10,7.731814E-10,3.93412E-09,1.766541E-08,7.83547E-08,_
2.651345E-07,9.245437E-07,4.098117E-06,1.365447E-05,4.723982E-05,1.138379E-04,_
3.420021E-04,0.00108028,0.00262091,0.00512421,0.00743036,0.01241174,0.0305568,_
0.04298075,0.07279497,0.1117544,0.1377345,0.2708437,0.3773455,0.5060342,_
0.5650462,0.6211514,0.7350239,0.812605,0.8134539,0.7696439,0.6272727,0.7635825,_
0.6545597,0.5963162,0.5488911,0.4916945,0.4479352,0.4160191,0.261989,0.1914656,_
0.09466778,0.04870203,0.02457135,0.01428174,0.0108064,0.0060855,0.00579068,_
0.00352516,0.00166886,0.00239971,0.00263722,0.00209167,0.0026241,0.0017291,_
0.00199624,0.00185431,0.00193833,0.00216393,0.00203648,0.00290713,0.00410499,_
0.01245418,0.03214948,0.06903049,0.09608401,0.1824628,0.2745507,0.4001463,_
0.4548221,0.4761595,0.6271877,0.6482365,0.793816,0.6808757,0.5342084,0.7111526,_
0.8117231,0.7756791,0.6842929,0.593611,0.5523526,0.4219885,0.2789353,0.2091302,_
0.1128606,0.09873247,0.06314331,0.04304754,0.02139853,0.01852528,0.00527043,_
0.00382206,0.00178759,0.00107258,3.966195E-04,1.503904E-04,5.816722E-05,_
1.911162E-05,5.510219E-06,1.35382E-06,3.547456E-07,8.856048E-08,1.91778E-08,_
4.146515E-09,7.128142E-10,1.357948E-10

U234FJEFF311:
Data 61, 171, _
 1.2876E-10,7.6264E-10,4.0125E-09,1.69056E-08,6.71051E-08,2.521609E-07,_
9.015063E-07,3.067366E-06,9.93232E-06,3.061294E-05,8.98232E-05,2.510597E-04,_
6.693981E-04,0.00170716,0.00418841,0.00996588,0.02308426,0.0501696,0.1011037,_
0.1723374,0.2877872,0.4699689,0.7745351,1.215032,1.794998,2.499902,3.355127,_
4.292364,5.109837,5.7648,6.291797,6.471909,6.427001,6.288914,6.082353,6.153777,_
6.827761,7.283211,6.772487,5.664302,4.296844,2.695262,1.376703,0.5842069,_
0.2396958,0.1141655,0.07088583,0.05500365,0.04910956,0.04708074,0.04664103,_
0.04672821,0.04685104,0.04680313,0.04651217,0.04609431,0.05729416,0.055842,_
0.05426857,0.05251229,0.05068969,0.04926394,0.04897427,0.05132892,0.05974105,_
0.08281081,0.1458886,0.3077621,0.6854599,1.404259,2.903992,5.321083,7.317348,_
8.062501,7.773513,6.980459,6.264906,6.135812,6.323802,6.337579,6.196333,_
5.861846,5.123694,4.286698,3.527246,2.734327,2.003647,1.410733,0.9524603,_
0.6168174,0.3679194,0.2003699,0.09502733,0.04835017,0.02458331,0.01270002,_
0.0060529,0.00266825,0.00110031,4.283297E-04,1.580877E-04,5.544369E-05,_
1.849499E-05,5.869423E-06,1.772486E-06,5.094474E-07,1.393081E-07,3.623103E-08,_
8.90141E-09,2.07718E-09,3.0859E-10,_
 4.2629E-11,1.989616E-10,9.982987E-10,4.106006E-09,1.630304E-08,6.021863E-08,_
2.148516E-07,6.675052E-07,1.854354E-06,7.207513E-06,2.177692E-05,5.838877E-05,_
1.500952E-04,4.057985E-04,9.643832E-04,0.00224758,0.00460502,0.00972263,_
0.01757948,0.03582595,0.06034135,0.09037869,0.1635933,0.2561131,0.3855681,_
0.5450698,0.7043325,0.9077863,1.082487,1.203225,1.359918,1.348049,1.401443,_
1.361132,1.331064,1.272994,1.152307,1.526997,1.641824,1.345586,1.007321,_
0.4718664,0.2930366,0.1159579,0.05747823,0.0285085,0.01781165,0.0133979,_
0.01160345,0.01162187,0.0113221,0.01022282,0.01117026,0.01049955,0.00982678,_
0.01151529,0.01035565,0.01060267,0.01034683,0.01098509,0.00935172,0.00912556,_
0.00948992,0.01030509,0.01160233,0.02099712,0.03022241,0.06460447,0.1390509,_
0.2869759,0.699075,1.080226,1.210967,1.516043,1.564958,1.279089,1.376896,_
1.291254,1.398039,1.361145,1.372392,1.302677,1.148868,1.02126,0.7975323,_
0.5358658,0.4705906,0.3262925,0.22129,0.1367906,0.08562573,0.04894441,0.0266769,_
0.01301149,0.00698776,0.00337144,0.00155301,6.600244E-04,2.707739E-04,_
1.020993E-04,3.784661E-05,1.357521E-05,4.384892E-06,1.431924E-06,4.286943E-07,_
1.189809E-07,3.403371E-08,8.727076E-09,2.152396E-09,4.603841E-10,1.0068E-10

U235FJEFF311:
Data 63, 171,_
 1.5296E-10,1.05227E-09,5.1847E-09,2.31513E-08,9.72895E-08,3.863726E-07,_
1.454498E-06,5.187372E-06,1.752956E-05,5.613211E-05,1.703387E-04,4.899013E-04,_
0.00133617,0.00346004,0.00852654,0.0200852,0.04546063,0.09886494,0.2005986,_
0.3801853,0.5853938,1.055257,1.333089,1.996559,2.589723,3.67611,4.460477,_
5.338924,5.398618,5.811265,5.873678,6.302243,6.416913,6.327457,5.932311,_
6.263742,5.847691,6.485916,5.235993,4.483886,3.247783,2.285362,1.287576,_
0.4696413,0.1849076,0.07930085,0.04579397,0.03635842,0.0328306,0.02651515,_
0.03460566,0.03146221,0.02698415,0.03630631,0.03812623,0.04070384,0.04272112,_
0.04417889,0.04507608,0.04561146,0.04652563,0.05047181,0.06677659,0.09781753,_
0.3006616,0.4819961,1.027172,2.18589,3.364815,4.699281,6.611166,7.762158,_
6.337979,6.20983,6.026486,6.547542,6.401308,5.964114,5.796032,5.694366,5.550023,_
5.09464,3.805548,2.927449,2.147574,1.694993,1.065033,0.7028508,0.4312639,_
0.3053865,0.1512187,0.1111101,0.04352593,0.01783167,0.01164198,0.00647261,_
0.00316545,0.00101699,3.021464E-04,9.664886E-05,2.92716E-05,8.393214E-06,_
2.278666E-06,5.85734E-07,1.425415E-07,3.277527E-08,7.17706E-09,1.479214E-09,_
1.7604E-10,_
 2.9612E-11,1.811174E-10,9.019159E-10,3.612049E-09,1.676713E-08,5.728811E-08,_
1.821348E-07,8.537214E-07,2.752369E-06,9.225608E-06,2.677644E-05,7.209447E-05,_
2.249252E-04,5.903384E-04,0.00124941,0.00341041,0.00638224,0.01365234,_
0.02732388,0.0423593,0.07148104,0.1010379,0.1492341,0.2532626,0.2733084,_
0.4573715,0.5218833,0.5111585,0.6812057,0.6700027,0.6830357,0.7535542,0.6699358,_
0.6735958,0.5902848,0.6671538,0.7496849,0.6044224,0.6066124,0.5100503,0.3388477,_
0.2575106,0.1616919,0.03857068,0.02584966,0.01272343,0.00728762,0.0059396,_
0.00401569,0.0036035,0.00435154,0.00410215,0.00365343,0.00434217,0.00531049,_
0.00661219,0.00611811,0.00703485,0.00589149,0.00685108,0.00660952,0.00652399,_
0.00959478,0.01685464,0.02372629,0.06826936,0.1443919,0.2410335,0.3132235,_
0.520129,0.6127051,0.7270826,0.7622263,0.6300319,0.7594428,0.6604286,0.7397431,_
0.748096,0.6089663,0.7110917,0.6369346,0.5059936,0.4858691,0.2928699,0.2561866,_
0.1968565,0.1129881,0.09164321,0.04874623,0.03585319,0.02094309,0.01134279,_
0.00807893,0.00238549,0.00186124,0.00114441,5.192562E-04,1.637293E-04,_
4.59149E-05,1.505115E-05,5.004255E-06,1.375253E-06,3.514138E-07,1.017605E-07,_
2.278067E-08,5.348593E-09,1.257886E-09,2.212733E-10,3.7947E-11

U235HJEFF311:
Data 53, 180,_
 4.3122E-10,1.7274E-09,5.75622E-09,1.813295E-08,5.565395E-08,1.649607E-07,_
4.742643E-07,1.321015E-06,3.566263E-06,9.330107E-06,2.365583E-05,5.812995E-05,_
1.384321E-04,3.195183E-04,6.50041E-04,0.00117357,0.00199784,0.00316694,_
0.00456241,0.00565588,0.01150611,0.01893653,0.03009378,0.04618512,0.06817759,_
0.1212927,0.2064856,0.337329,0.5302696,0.7836466,1.145447,1.401063,1.778075,_
2.163769,2.652588,3.754207,4.081154,4.449418,4.604106,4.964008,5.329237,_
5.094634,5.114045,4.836704,5.166819,4.635023,5.059357,4.107065,3.775692,_
3.420877,3.140648,2.447431,1.72122,2.156251,1.828958,1.582211,1.301838,1.180782,_
1.194905,0.7077687,1.094445,0.9663196,0.9721549,1.108724,1.132619,1.152208,_
1.148962,1.150301,1.14242,1.145999,1.180853,1.260402,1.421151,1.622636,1.959494,_
1.798979,1.590739,2.885776,4.112979,4.465876,5.575856,5.728054,6.567307,_
5.181327,5.676625,5.601328,4.9854,4.509259,4.43995,4.570437,4.032146,3.151619,_
2.813903,2.303506,1.657561,0.5941633,0.5573699,0.4805786,0.388235,0.3037231,_
0.230395,0.14352,0.08758875,0.05197942,0.03360458,0.02101874,0.0126939,_
0.00822805,0.00504731,0.0031654,0.00186316,0.00103712,5.51171E-04,2.774873E-04,_
2.323828E-04,1.42505E-04,7.928952E-05,5.495963E-05,3.483221E-05,1.483816E-05,_
5.579999E-06,1.06352E-06,5.427237E-07,9.41156E-08,3.49177E-08,2.76464E-09,_
2.10447E-09,1.2892E-10,_
 7.95344E-11,2.730567E-10,9.617019E-10,2.971303E-09,8.767318E-09,2.659496E-08,_
7.681972E-08,1.950836E-07,5.962003E-07,1.410407E-06,3.706738E-06,9.624842E-06,_
2.251461E-05,5.30099E-05,1.064717E-04,1.780495E-04,2.9605E-04,5.066127E-04,_
7.037038E-04,6.806245E-04,0.00163582,0.00270825,0.00458516,0.00764434,_
0.00971729,0.01820393,0.03275867,0.05395084,0.07672943,0.1173051,0.1501493,_
0.1981217,0.2856519,0.3460581,0.3717201,0.4859988,0.5096278,0.535467,0.5475135,_
0.7597937,0.7435524,0.7494336,0.6559717,0.7341225,0.5041849,0.7531331,0.6456737,_
0.6083115,0.6244885,0.4987057,0.3679543,0.3079323,0.244306,0.2782697,0.2480807,_
0.2115958,0.1762809,0.1887027,0.1612606,0.08890231,0.1557838,0.1504887,_
0.1160801,0.1516304,0.1428946,0.1534605,0.1489792,0.1497031,0.1440341,0.1490513,_
0.1685555,0.1943817,0.217551,0.2414529,0.2684363,0.2349162,0.1729756,0.3609829,_
0.4766835,0.420834,0.5587784,0.625601,0.7327998,0.5886909,0.7336415,0.6710916,_
0.6465347,0.5824425,0.5559044,0.6014106,0.5319005,0.385023,0.3860416,0.2919891,_
0.2148499,0.06728767,0.08820537,0.0776562,0.05944458,0.05063334,0.03290223,_
0.02098776,0.01467116,0.00722939,0.00520265,0.00350293,0.00190494,0.00124348,_
7.347402E-04,5.259247E-04,2.876334E-04,1.726575E-04,9.160458E-05,3.313438E-05,_
3.865222E-05,2.426398E-05,1.027597E-05,9.911807E-06,5.965333E-06,2.071768E-06,_
9.99979E-07,2.12177E-07,9.141701E-08,2.071901E-08,6.852942E-09,7.881244E-10,_
4.817245E-10,4.0222E-11

U235TJEFF311:
Data 64,170, _
7.5819E-10,3.73609E-09, _
1.636806E-08,6.705731E-08,2.599561E-07,9.544935E-07,3.317291E-06,1.091619E-05, _
3.401376E-05,1.00443E-04,3.397418E-04,8.296515E-04,0.00478188,0.00848659, _
0.02044846,0.04871396,0.1275719,0.1981061,0.328456,0.5558197,0.9982174,1.326747, _
1.962824,2.534431,3.497227,4.766751,5.818245,5.872665,5.996369,6.333896, _
6.498096,6.545148,6.306036,5.938497,5.772796,6.160928,6.249393,5.166864, _
4.286845,3.103109,1.874353,0.9469324,0.4107656,0.1396211,0.0572718,0.02885993, _
0.02542475,0.01969147,0.01183283,0.0159675,0.01288434,0.01135638,0.01604389, _
0.01231307,0.01359302,0.01504265,0.01455955,0.01260072,0.01803339,0.01505805, _
0.03162514,0.0260381,0.0594078,0.1202435,0.3306169,0.7060813,1.778768,2.878669, _
4.296289,6.593874,7.75947,6.646549,6.328351,6.384593,6.749204,6.392747,6.320873, _
5.858161,5.834399,5.971498,5.471939,3.9555,2.987748,2.232104,1.679598,1.053727, _
0.6511077,0.4203963,0.2525986,0.1477269,0.07256573,0.03084819,0.01333915, _
0.00657028,0.00193909,0.00106046,3.103305E-04,8.103206E-05,2.717071E-05, _
8.626975E-06,2.593234E-06,7.379414E-07,1.987181E-07,5.06582E-08,1.224047E-08, _
2.78024E-09,4.7731E-10, _
1.189223E-10,5.99972E-10,2.77702E-09,1.074092E-08,3.921482E-08, _
1.183648E-07,4.785657E-07,1.875818E-06,5.560767E-06,1.683091E-05,5.224727E-05, _
1.026764E-04,7.455198E-04,0.00110005,0.0028334,0.00555437,0.0109517,0.02368848, _
0.03739613,0.06743228,0.08426626,0.1275699,0.2291733,0.3033003,0.4450884, _
0.5015521,0.4705631,0.7078464,0.7563481,0.7739494,0.6314302,0.6314263,0.6374432, _
0.6233626,0.6722667,0.6904522,0.4605666,0.6122144,0.4793903,0.3546802,0.1998384, _
0.09015071,0.02364219,0.0092075,0.00750713,0.00396355,0.00359077,0.00249523, _
0.00144088,0.0018666,0.0014191,0.00143445,0.00175084,0.00143063,0.00209401, _
0.00178364,0.00200795,0.00125602,0.00213527,0.00163033,0.00347674,0.00305701, _
0.0069437,0.00651207,0.0138317,0.03710109,0.1584249,0.3007694,0.4827814, _
0.6300473,0.5583634,0.781939,0.7154092,0.7681,0.6403404,0.6238294,0.7300106, _
0.7084668,0.7158615,0.6431167,0.4395186,0.4805143,0.3388295,0.2733807,0.162384, _
0.1001036,0.07908574,0.05126996,0.03171497,0.01727142,0.00567628,0.00415637, _
0.00181544,9.653917E-04,2.789893E-04,1.15658E-04,5.106832E-05,1.157308E-05, _
4.564714E-06,1.435118E-06,3.76131E-07,1.220856E-07,3.346726E-08,8.28074E-09, _
2.016961E-09,4.201699E-10,8.171494E-11

U236FJEFF311:
Data 62, 173,_
 6.0258E-10,2.49311E-09,1.014573E-08,3.935071E-08,1.446481E-07,5.077885E-07,_
1.703164E-06,5.459417E-06,1.67229E-05,4.894928E-05,1.369186E-04,3.659942E-04,_
9.348899E-04,0.00228264,0.00532852,0.01190236,0.0254718,0.0523291,0.1033613,_
0.195141,0.3510368,0.590648,0.9446738,1.406111,1.925614,2.475831,3.030638,_
3.454881,4.580033,5.249706,6.048589,5.157468,6.061427,6.487547,6.184495,_
5.364302,6.292587,5.630452,6.655393,5.348049,5.469615,3.840521,2.903925,_
1.789224,1.038911,0.4376771,0.2057664,0.1100689,0.07252611,0.05794979,_
0.05987348,0.06423897,0.06971663,0.07549716,0.08118083,0.08652431,0.08557254,_
0.08935024,0.09264355,0.09566224,0.09911838,0.1052184,0.1203378,0.1619122,_
0.2612068,0.4094766,0.5316114,0.8345072,1.517502,2.985937,4.05219,6.648743,_
7.669534,6.193777,6.567742,5.937594,6.740877,6.429731,5.861973,5.38827,5.241796,_
5.118159,4.708057,4.273774,3.495037,2.02975,1.949067,1.529801,1.009073,0.750475,_
0.4810861,0.2745954,0.1389883,0.06628551,0.0293831,0.0136718,0.0060656,_
0.00255989,0.00102829,3.931418E-04,1.541405E-04,5.771751E-05,2.063949E-05,_
7.048872E-06,2.298803E-06,7.160435E-07,2.12877E-07,6.047388E-08,1.63099E-08,_
4.1564E-09,1.04234E-09,1.5559E-10,_
 8.844751E-11,4.369022E-10,1.624365E-09,6.285965E-09,2.500411E-08,7.901702E-08,_
2.464802E-07,7.768406E-07,2.419642E-06,8.443396E-06,2.242218E-05,5.545178E-05,_
1.591359E-04,3.547884E-04,8.737533E-04,0.00188947,0.00401467,0.00840959,_
0.01523461,0.02747425,0.04779371,0.08094715,0.1298685,0.175927,0.2845948,_
0.3732776,0.4364748,0.5093033,0.6053606,0.6499653,0.8453192,0.602511,0.8513622,_
0.83796,0.7365072,0.5954578,0.7205139,0.7370294,0.7294397,0.6334509,0.6421502,_
0.4572728,0.3355243,0.2518155,0.1557545,0.06051881,0.03077001,0.0183557,_
0.01094527,0.00921202,0.00852698,0.00938776,0.00843244,0.01120058,0.01154583,_
0.01053575,0.01397189,0.01253348,0.01367314,0.01397603,0.01397418,0.01519234,_
0.01614811,0.02306391,0.04898911,0.04930186,0.07858808,0.1303157,0.2439373,_
0.3687455,0.4313777,0.7774601,0.7338999,0.7949994,0.8663347,0.7184122,0.9799444,_
0.7445019,0.7764255,0.6677966,0.6637846,0.7518678,0.4807873,0.6369346,0.4042269,_
0.2441671,0.3191621,0.247079,0.1837903,0.1202881,0.09413855,0.04838063,_
0.02120425,0.01150571,0.00468585,0.00215489,0.00104858,4.044412E-04,_
1.653667E-04,6.661829E-05,2.436085E-05,9.866411E-06,3.295291E-06,1.118249E-06,_
3.970451E-07,1.118674E-07,3.582383E-08,1.025186E-08,2.408472E-09,7.304722E-10,_
1.731454E-10,3.1936E-11

U238FJEFF311:
Data 61, 175, _
 2.7576E-10,1.08892E-09,3.87879E-09,1.343726E-08,4.429177E-08,1.401297E-07, _
4.26012E-07,1.243283E-06,3.484034E-06,9.374312E-06,2.421818E-05,6.006883E-05, _
1.430371E-04,3.26992E-04,7.176304E-04,0.00151198,0.00305857,0.00766154, _
0.01782568,0.03895738,0.08060677,0.1588117,0.2986677,0.5322515,0.8751171, _
1.169016,1.615375,2.138953,3.059319,3.25384,4.246821,4.340834,5.124089,5.088686, _
5.283097,5.953465,5.708299,5.733682,6.247513,6.533674,6.409304,5.903955, _
6.034804,4.905084,3.753323,2.536996,1.782707,0.6021507,0.1617105,0.09886675, _
0.06414333,0.04549016,0.03174268,0.03469514,0.03810028,0.0316647,0.02781358, _
0.02501572,0.02300562,0.02117187,0.02004579,0.01913402,0.01936609,0.02046323, _
0.02095393,0.09252489,0.1455638,0.2943341,0.6215652,1.64284,3.323188,4.747818, _
6.690365,6.671147,6.569535,6.918372,6.208407,6.035711,6.003906,5.988132, _
5.987319,4.848678,4.694908,4.598799,3.973142,3.592721,2.684161,2.285947, _
1.688296,1.318349,0.8092147,0.5569705,0.3669793,0.2390217,0.1269556,0.06554668, _
0.03422075,0.01725619,0.00835593,0.0032999,0.00119194,5.47536E-04,2.417575E-04, _
1.024862E-04,4.179456E-05,1.631337E-05,6.155817E-06,2.203004E-06,7.718812E-07, _
2.480897E-07,8.2112E-08,2.3529E-08,7.38536E-09,1.6854E-09,5.4326E-10, _
 5.078422E-11,1.645628E-10,6.35282E-10,2.275812E-09,6.872085E-09,2.332791E-08, _
7.051963E-08,1.657522E-07,5.261413E-07,1.354088E-06,3.94201E-06,1.035891E-05, _
2.157306E-05,5.590186E-05,1.191729E-04,2.2643E-04,5.151278E-04,0.00123711, _
0.00279417,0.00647101,0.01108947,0.02427964,0.04467598,0.06793949,0.1204076, _
0.1264549,0.2132871,0.2608044,0.3600318,0.4028091,0.4734431,0.5386276,0.6009912, _
0.6381252,0.6650292,0.5753579,0.6114908,0.6897537,0.6977596,0.73577,0.755839, _
0.7769037,0.7503109,0.5905972,0.4780919,0.3009344,0.1682433,0.08724862, _
0.02070982,0.01682875,0.0080143,0.00691664,0.00443605,0.00518067,0.00440965, _
0.00475533,0.00394626,0.00379106,0.00372779,0.00275118,0.00302233,0.00285993, _
0.00247896,0.00306922,0.00300651,0.0134932,0.01687792,0.03854869,0.04340369, _
0.1628722,0.3480142,0.4848714,0.6745572,0.7128999,0.7231842,0.7217059,0.725206, _
0.7228633,0.7401956,0.6088548,0.7065821,0.6042293,0.5256351,0.4916366,0.445052, _
0.3680538,0.330674,0.2668426,0.2191782,0.1401348,0.09881683,0.07656232, _
0.04331569,0.03564711,0.02038756,0.00787974,0.00588023,0.00273345,0.00129917, _
5.335493E-04,1.553541E-04,9.424588E-05,3.818532E-05,1.702332E-05,7.164969E-06, _
2.476243E-06,1.047472E-06,3.731212E-07,1.209867E-07,4.43044E-08,1.311224E-08, _
3.977479E-09,1.288644E-09,2.914356E-10,9.838765E-11

U238HJEFF311:
Data 54, 181,_
 4.647E-10,1.62609E-09,5.07237E-09,1.51673E-08,4.453217E-08,1.265855E-07,_
3.496424E-07,9.381033E-07,2.446561E-06,6.20045E-06,1.527106E-05,3.654781E-05,_
8.500107E-05,1.400202E-04,2.778919E-04,5.327265E-04,9.851031E-04,0.00175429,_
0.00300204,0.00541206,0.00895494,0.01429096,0.02193562,0.0321377,0.04143911,_
0.09495462,0.1929979,0.3652776,0.5556925,0.7275259,1.286026,1.076526,1.843566,_
1.852801,2.062693,2.796974,3.251633,3.696665,3.784939,4.323936,4.850742,_
4.695573,4.560548,5.145216,4.906207,5.794799,5.458084,5.799583,4.387419,_
4.494764,3.6102,3.117491,2.556497,1.838496,1.67605,1.35652,1.17702,0.9702646,_
1.022273,0.9117849,0.9163898,0.9000095,0.9079814,0.9032217,0.9246464,0.99159,_
1.046302,1.099398,1.133922,1.216731,1.226146,1.276853,1.378077,1.436659,_
1.563408,1.657882,2.973541,3.617505,4.689929,5.739917,6.345851,5.4865,6.044232,_
5.81617,4.68494,5.043768,4.625519,4.419899,4.175039,3.872917,3.578825,2.994435,_
2.633239,2.133742,1.371437,1.359682,0.9776954,0.8003771,0.5421591,0.3947686,_
0.2615973,0.1741836,0.1137755,0.07105371,0.04353736,0.02594342,0.01471821,_
0.00812595,0.00543312,0.00341273,0.00203299,0.00115598,6.299709E-04,_
4.075516E-04,2.379046E-04,1.289979E-04,5.412011E-05,2.206567E-05,8.718138E-06,_
3.355208E-06,1.242495E-06,4.532831E-07,1.561897E-07,5.424627E-08,1.677785E-08,_
5.73844E-09,1.5819E-09,5.152E-10,_
 7.876479E-11,2.645117E-10,8.765017E-10,2.363892E-09,7.580983E-09,2.121712E-08,_
5.266116E-08,1.621317E-07,3.796984E-07,9.96199E-07,2.603217E-06,5.686308E-06,_
1.265783E-05,3.310925E-05,3.78906E-05,8.059369E-05,1.431654E-04,2.827308E-04,_
5.07183E-04,9.318395E-04,0.00151865,0.00238653,0.00324061,0.00476401,0.00617903,_
0.01473601,0.03092014,0.04904172,0.0806,0.08575622,0.1533619,0.1428051,_
0.2028507,0.2400372,0.2491197,0.3550315,0.3604254,0.4367857,0.4814797,0.4822007,_
0.7063168,0.5408117,0.649771,0.5368776,0.7344584,0.7117241,0.7188564,0.6544586,_
0.526879,0.50025,0.3867516,0.3859156,0.2103766,0.1790859,0.2428308,0.1648571,_
0.1882517,0.1179475,0.1239177,0.100044,0.1337232,0.09858212,0.1313418,0.1304195,_
0.1411273,0.1348293,0.1524555,0.1498328,0.1491909,0.1781945,0.1687825,0.1309833,_
0.1868463,0.1548867,0.1540893,0.1405928,0.275166,0.417707,0.4669288,0.6326474,_
0.5749537,0.6910229,0.6345327,0.6707869,0.52761,0.5740733,0.5832911,0.4848844,_
0.5165254,0.4576308,0.377461,0.3781216,0.3153211,0.2668327,0.1723845,0.1846477,_
0.1774094,0.0995684,0.09824179,0.04915803,0.03981614,0.02986313,0.0150921,_
0.01237321,0.00684207,0.00388789,0.00254712,0.00108718,9.256108E-04,_
5.712121E-04,3.095714E-04,1.998538E-04,9.172978E-05,6.558728E-05,4.045969E-05,_
1.660488E-05,8.449791E-06,3.681045E-06,1.388615E-06,5.796303E-07,1.957115E-07,_
7.326014E-08,2.747405E-08,8.340218E-09,3.027155E-09,9.712924E-10,2.445054E-10,_
9.468305E-11

' Data from evaluation JEFF 3.3

AM241FJEFF33:
Data 50, 197, _
 1.267468E-09,2.26105E-09,4.09472E-09,7.37605E-09,1.31187E-08,2.369908E-08, _
4.251113E-08,7.623989E-08,1.366624E-07,2.450874E-07,4.394238E-07,7.87865E-07, _
1.412694E-06,2.532958E-06,4.541791E-06,8.144467E-06,1.460625E-05,2.620085E-05, _
2.349007E-04,2.348453E-04,1.517005E-04,2.34571E-04,2.345241E-04,2.336206E-04, _
0.00196991,0.00265433,0.00589781,0.00927595,0.01942324,0.03380837,0.06453411, _
0.09381089,0.1430061,0.2310764,0.3694655,0.4634493,0.6619766,0.9421522, _
0.7661228,1.782101,2.229888,2.359943,2.771986,3.221017,3.982282,4.179336, _
4.439643,4.800809,5.47892,5.373258,5.738764,5.975191,6.305255,6.52298,6.238562, _
5.380545,4.842322,4.324449,3.435003,2.315223,1.676267,0.984372,0.7400109, _
0.4986542,0.2799052,0.1585522,0.06428733,0.03064797,0.03113829,0.02898604, _
0.08010104,0.04552857,0.05437502,0.07460854,0.1038555,0.2121636,0.3506555, _
0.5116407,0.6095619,1.326662,2.241463,4.128269,4.369207,5.767064,5.972325, _
6.878875,6.712559,6.329948,6.678273,6.666383,4.933554,4.694489,4.110717, _
3.878998,3.433306,4.125854,3.669385,2.171311,2.406842,1.578614,1.582519, _
0.9541351,1.046485,0.6298395,0.5572756,0.4087352,0.260712,0.1618546,0.08242489, _
0.07884343,0.04452885,0.03718897,0.01269019,0.01256507,0.00520493,0.00443623, _
8.003236E-04,7.991863E-04,9.373978E-04,5.774637E-04,3.979669E-04,2.163975E-04, _
1.320518E-04,8.049572E-05,4.902315E-05,2.984647E-05,1.816179E-05,1.105306E-05, _
6.720112E-06,4.091303E-06,2.483932E-06,1.513889E-06,9.14456E-07,5.598731E-07, _
3.407368E-07,2.069636E-07,1.26092E-07,7.662841E-08,4.663536E-08,2.838198E-08, _
1.7184E-08,1.046676E-08,6.33887E-09,3.83997E-09,2.32803E-09,1.431975E-09, _
8.1675E-10,3.9122E-10, _
8.97451E-10,1.537555E-09,2.743295E-09,5.006419E-09,9.579427E-09,1.783551E-08, _
2.845442E-08,4.833072E-08,9.231496E-08,1.874635E-07,3.09436E-07,5.21203E-07, _
8.496469E-07,1.744457E-06,3.308036E-06,6.051755E-06,9.740132E-06,1.663094E-05, _
1.654181E-04,1.340304E-04,1.038918E-04,1.323287E-04,1.598916E-04,1.046789E-04, _
0.00144596,0.0012266,0.00211593,0.0032115,0.00725804,0.00997051,0.0196631, _
0.01868063,0.02687289,0.04592759,0.08323871,0.09060887,0.128228,0.1818217, _
0.3043993,0.2682386,0.3022025,0.3492964,0.3861178,0.4298865,0.4217946,0.5470843, _
0.5452157,0.5689004,0.6127513,0.6160372,0.6576278,0.7499061,0.7192959,0.8377671, _
0.7031509,0.6905418,0.6333322,0.5268756,0.4565897,0.301616,0.2250014,0.1298895, _
0.08049456,0.07380811,0.04540166,0.01879431,0.02256651,0.01759981,0.01656362, _
0.01372201,0.01711707,0.00941261,0.01159777,0.01572488,0.01668134,0.02892042, _
0.05297379,0.0615467,0.06700874,0.1686691,0.3101668,0.4499842,0.832734, _
0.5813146,1.031005,1.122131,1.065728,1.058444,0.9450691,0.8567789,0.5934762, _
0.5494117,0.5336738,0.5081273,0.4445216,0.4730309,0.3813674,0.2883539,0.2917362, _
0.2027794,0.2057901,0.1028876,0.1508412,0.0855092,0.07854097,0.04367521, _
0.0309918,0.04406177,0.03141802,0.01089336,0.01801568,0.00401897,0.00559029, _
0.00558855,0.00280596,0.00380257,3.446355E-04,3.550809E-04,6.745668E-04, _
3.947454E-04,2.411788E-04,1.479809E-04,9.605946E-05,6.088625E-05,3.291451E-05, _
1.860141E-05,1.076704E-05,7.23353E-06,4.659897E-06,2.603417E-06,1.098265E-06, _
1.029218E-06,5.187209E-07,4.215922E-07,2.050095E-07,1.020647E-07,7.523126E-08, _
5.851601E-08,3.24751E-08,1.887174E-08,8.555919E-09,6.329653E-09,3.456464E-09, _
2.866611E-09,1.252405E-09,7.392361E-10,5.169068E-10,3.063312E-10

AM241TJEFF33:
Data 50, 196, _
2.77786E-09,4.78615E-09,8.3174E-09,1.441627E-08,2.483607E-08,4.286195E-08, _
7.394733E-08,1.2758E-07,2.199969E-07,3.795164E-07,6.545341E-07,1.128908E-06, _
1.947165E-06,3.358291E-06,5.792876E-06,9.992301E-06,1.7238E-05,2.974143E-05, _
5.133147E-05,8.863691E-05,2.295593E-04,4.590564E-04,2.295136E-04,2.294878E-04, _
0.00140775,0.00213196,0.00478543,0.00665404,0.0135317,0.02591928,0.05934846, _
0.07867008,0.1245076,0.1828357,0.283874,0.3667468,0.4379395,0.5614761,0.7200621, _
1.044944,1.357699,1.766879,2.122684,2.691295,3.454577,3.980101,4.270274, _
5.010685,5.983425,6.589055,6.603155,6.61335,6.841585,7.141811,7.070757,6.524596, _
5.105385,4.219943,3.091157,1.972299,1.545174,1.05583,0.5533849,0.2633485, _
0.1158634,0.04514985,0.02790971,0.02204234,0.02049107,0.02369963,0.02052935, _
0.01798667,0.02448736,0.02859008,0.05297067,0.1025093,0.2093466,0.6474154, _
0.9406342,1.310132,2.015857,3.400326,4.359334,5.802399,6.217423,8.119555, _
7.352139,7.329356,7.073563,7.285212,5.858441,4.809115,4.89713,3.851192,3.389861, _
3.240105,2.363145,2.033828,1.648614,1.286458,1.015077,0.8052282,0.6678544, _
0.5698807,0.3605707,0.2906597,0.2368199,0.1586701,0.06499684,0.07042242, _
0.02758278,0.02160919,0.00811022,0.00525009,0.00409205,0.00150881,0.00177957, _
6.1246E-04,9.126105E-04,3.061476E-04,1.861539E-04,1.119477E-04,6.72583E-05, _
4.038867E-05,2.424238E-05,1.455055E-05,8.72944E-06,5.238962E-06,3.140186E-06, _
1.88591E-06,1.12843E-06,6.787433E-07,4.033713E-07,2.441089E-07,1.465859E-07, _
8.774664E-08,5.276255E-08,3.163736E-08,1.897828E-08,1.139458E-08,6.8042E-09, _
4.04442E-09,2.373304E-09,1.463096E-09,8.2534E-10,5.29254E-10,1.4012E-10, _
 1.950526E-09,3.229645E-09,5.601406E-09,9.954041E-09,1.815769E-08,3.224587E-08, _
4.963281E-08,8.110241E-08,1.499192E-07,2.938509E-07,4.584103E-07,7.445631E-07, _
1.164668E-06,2.348446E-06,4.245607E-06,7.431959E-06,1.154084E-05,1.894618E-05, _
3.175019E-05,4.994121E-05,1.717627E-04,2.168848E-04,1.579555E-04,1.527479E-04, _
8.838066E-04,0.00128202,0.00182193,0.00293621,0.00599531,0.00696687,0.0187238, _
0.01728281,0.02195442,0.02282069,0.0287857,0.06295927,0.06677429,0.09646348, _
0.1005293,0.1171123,0.1667378,0.2228373,0.2808721,0.3295913,0.3994592,0.490129, _
0.5511261,0.5453185,0.722891,0.7260093,0.8070161,0.9261436,0.8657084,0.9278519, _
0.8166413,0.8103815,0.7602735,0.5697045,0.4533808,0.2801019,0.2337636,0.1661432, _
0.06173203,0.0413987,0.02272951,0.00590276,0.00652171,0.00715677,0.00577745, _
0.00617899,0.01068887,0.00522535,0.00568319,0.00879797,0.01197652,0.02587497, _
0.07134262,0.06367913,0.1183932,0.1305543,0.2428861,0.3731902,0.473456, _
0.5718769,0.6940405,0.83478,0.8425985,0.9412181,0.7998683,0.8302214,0.6873955, _
0.5473393,0.6665767,0.5162082,0.4351887,0.3188708,0.2633099,0.2659142,0.2181766, _
0.1678088,0.1430527,0.08429789,0.1110875,0.07674497,0.06544092,0.03702007, _
0.02747847,0.02141919,0.02630649,0.00973349,0.01470168,0.00253942,0.00451955, _
0.00208676,0.00185752,7.137306E-04,0.00126302,2.713705E-04,4.610171E-04, _
2.219255E-04,1.022353E-04,7.551181E-05,4.858284E-05,3.103258E-05,1.641108E-05, _
9.091709E-06,5.233977E-06,3.376402E-06,2.220537E-06,1.232554E-06,5.00567E-07, _
4.561273E-07,2.275296E-07,1.875531E-07,8.669041E-08,4.463933E-08,3.243836E-08, _
2.405354E-08,1.348329E-08,7.768269E-09,3.345666E-09,2.446365E-09,1.335026E-09, _
1.118325E-09,4.923125E-10,2.735238E-10,1.437E-10

AM243FJEFF33:
Data 59, 185, _
 4.8593E-10,1.07481E-09,1.95965E-09,3.39472E-09,5.85879E-09,1.02909E-08, _
1.794082E-08,3.116206E-08,5.414099E-08,9.41466E-08,1.636305E-07,2.84322E-07, _
4.941442E-07,8.587297E-07,1.4923E-06,2.593591E-06,4.507803E-06,7.835262E-06, _
1.362127E-05,2.368663E-05,4.120501E-05,1.006701E-04,1.006479E-04,2.009748E-04, _
3.026653E-04,0.00104533,0.00174932,0.00318971,0.00313738,0.01091656,0.01630924, _
0.0270159,0.03854752,0.06597992,0.1105958,0.1424349,0.2071409,0.2932031, _
0.4366705,0.6545723,0.9153851,1.158847,1.554813,1.980105,2.709091,3.086032, _
3.563462,4.069949,4.728831,5.058275,5.662704,5.638851,5.97858,6.458693,6.929458, _
6.641444,6.538418,6.194997,5.505939,4.615345,3.596985,2.448428,1.509645, _
0.808418,0.3807127,0.1550204,0.05777502,0.02261353,0.00843791,0.00562763, _
0.00376244,0.00552542,0.00636286,0.00803032,0.02184901,0.054296,0.1308774, _
0.3057096,0.6555197,1.184541,1.997393,3.29678,4.559713,6.112611,7.397491, _
7.860722,7.590803,7.413208,6.112172,5.476566,5.001131,5.30167,4.725008,4.422313, _
3.87528,3.299203,2.753564,2.644076,1.995898,1.558023,1.209475,0.9385683, _
0.6559537,0.4829794,0.3221447,0.2217157,0.1510473,0.1003341,0.05698649, _
0.03884199,0.02041819,0.01386088,0.00872753,0.00544147,0.00233146,0.00289005, _
0.00106154,3.970929E-04,2.982988E-04,9.937679E-05,4.800756E-05,2.151936E-05, _
9.635611E-06,4.314653E-06,1.929207E-06,8.642655E-07,3.856019E-07,1.730374E-07, _
7.65386E-08,3.454455E-08,1.516191E-08,6.91457E-09,2.8383E-09,1.3046E-09, _
4.6265E-10,2.18022E-10, _
 4.8755E-10,7.790127E-10,1.313956E-09,2.396388E-09,4.318174E-09,7.45522E-09, _
1.267283E-08,2.212147E-08,3.63038E-08,6.556687E-08,1.257659E-07,1.957847E-07, _
2.996844E-07,6.008249E-07,1.088467E-06,1.870935E-06,3.171291E-06,5.562148E-06, _
7.592541E-06,1.320517E-05,3.133611E-05,7.423042E-05,6.95257E-05,8.125445E-05, _
1.624594E-04,7.790475E-04,7.492378E-04,9.758847E-04,0.00176036,0.00351181, _
0.00753293,0.00879794,0.01033822,0.01829166,0.03574821,0.04498382,0.0516619, _
0.06547084,0.08435649,0.1185944,0.1291923,0.1784739,0.229254,0.2832496, _
0.3218607,0.3716068,0.4161456,0.4450209,0.5922275,0.6385483,0.5839493,0.7467678, _
0.70574,0.8527781,0.7723381,0.8372869,0.8417246,0.7935375,0.7327582,0.6504479, _
0.4919302,0.3549083,0.2116941,0.1209017,0.06070133,0.03012349,0.01200156, _
0.00424108,0.00235764,0.00209828,0.0012013,0.00136862,0.00219543,0.00196494, _
0.00414432,0.00858197,0.02008214,0.04447728,0.07469928,0.1335442,0.2091894, _
0.3766661,0.5274139,0.6967274,0.7051295,0.9490286,0.8062119,0.9558765,0.7483604, _
0.7639133,0.6911098,0.5633765,0.6319538,0.6242452,0.4901308,0.4418464,0.3009317, _
0.3128514,0.2838686,0.2374136,0.1830823,0.1388001,0.109298,0.09289701, _
0.05927753,0.04978954,0.03849803,0.03141355,0.01950495,0.01153349,0.00894786, _
0.00761453,0.00497938,0.00227532,9.318054E-04,0.00112298,6.9393E-04, _
1.579809E-04,9.861377E-05,6.879103E-05,3.147857E-05,1.534145E-05,6.477519E-06, _
3.018213E-06,1.486204E-06,5.944229E-07,2.555012E-07,1.167366E-07,5.672084E-08, _
2.478132E-08,9.769231E-09,4.936258E-09,1.893701E-09,9.673443E-10,3.482802E-10, _
1.634974E-10

AM243TJEFF33:
Data 50, 192, _
1.0422E-10,2.4532E-10,4.0957E-10,8.1201E-10,1.52887E-09,2.96648E-09, _
5.48564E-09,1.00666E-08,1.86097E-08,3.431667E-08,6.317349E-08,1.165317E-07, _
2.146284E-07,3.955902E-07,7.291162E-07,1.343574E-06,2.47598E-06,4.563108E-06, _
8.41016E-06,1.5504E-05,2.859255E-05,5.275805E-05,1.163374E-04,1.802568E-04, _
4.048765E-04,4.044945E-04,0.00134085,0.00173579,0.00375393,0.00843303, _
0.01239126,0.02089655,0.03475293,0.05952539,0.09198645,0.1298097,0.1909363, _
0.2563997,0.4210277,0.6093047,0.88647,1.115642,1.5076,1.980509,2.728073, _
3.139303,3.575591,4.108114,4.902272,5.16012,5.669476,5.725513,6.018078,6.515861, _
7.001907,6.679079,6.601488,6.206443,5.434968,4.534545,3.495931,2.366526, _
1.460021,0.7816039,0.3568132,0.1239555,0.04597853,0.01942199,0.00834818, _
0.00382499,0.00285658,0.00361814,0.00720425,0.00715927,0.01732204,0.0495763, _
0.1278254,0.2769941,0.6116137,1.124004,1.965512,3.257281,4.542554,6.125747, _
7.42726,7.981906,7.679358,7.525263,6.122954,5.495296,4.980896,5.308138,4.754983, _
4.491532,3.889462,3.31579,2.765662,2.643813,1.944859,1.536901,1.178715,0.912564, _
0.63362,0.4476154,0.2823901,0.2043949,0.1335903,0.08890507,0.05256038,0.033973, _
0.02032705,0.01288599,0.00744464,0.00551692,0.00195321,0.00144491,4.961113E-04, _
4.228712E-04,2.789834E-04,1.332988E-04,7.456864E-05,4.166546E-05,2.325512E-05, _
1.298088E-05,7.231992E-06,4.039521E-06,2.244703E-06,1.256137E-06,6.90077E-07, _
3.903261E-07,2.119088E-07,1.20942E-07,6.12142E-08,3.72682E-08,2.10074E-08, _
1.133761E-08,6.52644E-09,3.63458E-09,1.93852E-09,1.13356E-09,6.03224E-10, _
2.2357E-10,1.0843E-10, _
 1.0458E-10,1.774117E-10,3.100799E-10,6.09326E-10,1.180445E-09,2.146023E-09, _
3.850832E-09,7.184143E-09,1.249141E-08,2.396336E-08,4.850584E-08,8.014924E-08, _
1.284497E-07,2.760859E-07,5.347368E-07,9.678973E-07,1.734403E-06,3.243641E-06, _
4.709697E-06,8.612497E-06,2.172625E-05,3.614727E-05,8.6553E-05,1.184533E-04, _
2.406815E-04,2.293518E-04,7.292998E-04,6.617869E-04,0.00150144,0.00234359, _
0.00524154,0.00555417,0.00807085,0.01464849,0.02574433,0.03003905,0.03671364, _
0.04704359,0.08003572,0.1061668,0.1194253,0.1670353,0.2240076,0.2919136, _
0.3358127,0.3890754,0.4174533,0.4569435,0.6144004,0.6498567,0.5778575,0.7569639, _
0.7099171,0.8629634,0.7773672,0.8576132,0.8616838,0.8090925,0.7499534,0.6617045, _
0.5106976,0.3723941,0.2266973,0.1362229,0.06766628,0.03731852,0.01305609, _
0.00516689,0.00244759,0.00212888,0.00164098,0.00101921,0.00218406,0.00161733, _
0.00406144,0.00866042,0.02377056,0.04812294,0.08241725,0.1372765,0.2113384, _
0.4057145,0.5394572,0.7013515,0.7255638,0.9746441,0.8175164,0.9705092,0.7539484, _
0.7738311,0.7024709,0.5656955,0.6472123,0.6524582,0.5009642,0.4613762,0.3091912, _
0.3353913,0.2981816,0.2387065,0.1789577,0.1238332,0.102822,0.08633293, _
0.04863688,0.03724746,0.02737246,0.02528159,0.01503416,0.00921381,0.00686314, _
0.00489361,0.00313428,0.00239979,7.32591E-04,8.687889E-04,1.924201E-04, _
3.02281E-04,1.941187E-04,9.694655E-05,4.983203E-05,2.961185E-05,1.559276E-05, _
9.031062E-06,5.594076E-06,2.785244E-06,1.491411E-06,8.553696E-07,5.065731E-07, _
2.802363E-07,1.416458E-07,8.594441E-08,4.146255E-08,2.620034E-08,1.227079E-08, _
7.403897E-09,4.352931E-09,2.573888E-09,1.463622E-09,8.216695E-10,3.240196E-10, _
2.2554E-10,1.0992E-10

CM243FJEFF33:
Data 49,196, _
 0,1.266024E-08,2.111595E-08,3.521021E-08,5.87617E-08,9.802679E-08,1.634867E-07, _
2.726874E-07,4.549783E-07,8.604009E-07,1.265944E-06,2.111858E-06,3.522995E-06, _
5.877464E-06,9.806547E-06,1.6365E-05,2.731537E-05,5.173444E-05,7.621633E-05, _
1.274658E-04,2.135118E-04,1.105877E-04,3.328564E-04,0.00101307,0.00144881, _
0.00453121,0.00498189,0.00716702,0.01438675,0.02799956,0.04168018,0.06766275, _
0.07869328,0.1131296,0.1792736,0.2705081,0.3281318,0.4324766,0.6104876, _
0.8537996,1.049895,1.312219,1.614846,2.098215,2.515606,3.113936,3.357556, _
3.88287,4.31565,4.98916,5.018698,5.358878,5.62993,6.079335,6.064424,6.096598, _
5.878735,5.56108,5.117449,4.589483,3.800381,3.126173,2.392093,1.666896,1.079882, _
0.6348552,0.3020949,0.1560464,0.0804157,0.0420449,0.02426432,0.01225375, _
0.03488991,0.04083633,0.07002697,0.1237905,0.2241273,0.3825093,0.6668836, _
1.125789,1.741508,2.264564,3.218005,4.392846,4.989973,5.516613,6.815674, _
7.418715,7.036737,5.652999,5.18617,5.013286,5.041309,4.902516,4.139338,3.855918, _
3.462427,3.117922,2.663309,2.339382,1.877644,1.557973,1.276918,1.036799, _
0.7543238,0.5777778,0.4249468,0.3338814,0.2383878,0.1641548,0.1086019, _
0.07468496,0.05229969,0.03545329,0.01841811,0.01051046,0.00754311,0.00563948, _
0.00294441,9.370309E-04,0.001046,7.415836E-04,1.068397E-04,1.068586E-04, _
1.067604E-04,5.125806E-05,2.885654E-05,1.623738E-05,9.13395E-06,5.136639E-06, _
2.88868E-06,1.624139E-06,9.133391E-07,6.006657E-07,2.887311E-07,1.622837E-07, _
9.126886E-08,5.131045E-08,2.883908E-08,1.62236E-08,9.0918E-09,5.08117E-09, _
2.826202E-09,1.51663E-09,8.6601E-10,2.23907E-10,2.2766E-10,1.1347E-10, _
 0,9.437027E-09,1.535194E-08,2.439389E-08,4.207283E-08,7.903719E-08, _
1.185648E-07,1.897993E-07,3.363436E-07,6.825657E-07,9.517294E-07,1.573166E-06, _
2.577123E-06,3.715046E-06,7.038607E-06,1.321101E-05,1.964783E-05,3.991819E-05, _
5.575543E-05,8.966924E-05,1.181206E-04,7.464541E-05,1.570962E-04,5.406063E-04, _
4.433033E-04,0.00240976,0.00179103,0.00278239,0.00527819,0.00938383,0.00844398, _
0.01422462,0.0159741,0.02176373,0.03169708,0.05169325,0.06037167,0.07609804, _
0.1030699,0.1255943,0.1461158,0.1838879,0.2344324,0.3136317,0.3327626,0.3510847, _
0.4250748,0.476379,0.4927354,0.5415149,0.5782663,0.6337866,0.6900901,0.6696583, _
0.7397396,0.6522806,0.7314046,0.6903777,0.6275092,0.5587641,0.4673578,0.3904423, _
0.2938224,0.1881328,0.1407306,0.08526717,0.04013919,0.02840751,0.01324537, _
0.00900726,0.00652557,0.00768395,0.00598518,0.00687086,0.01035198,0.01921499, _
0.02426995,0.07489404,0.09652508,0.1274147,0.1842317,0.3222156,0.4312301, _
0.4688128,0.547733,0.7070644,0.8384899,0.8445389,0.8259763,0.7753808,0.7469137, _
0.7425973,0.640786,0.5845761,0.5977858,0.4997886,0.4767446,0.373342,0.3415112, _
0.2926124,0.2690868,0.2288088,0.1852767,0.1292489,0.1106113,0.08547158, _
0.0703986,0.05494874,0.04269734,0.0301724,0.0223062,0.01655511,0.01226405, _
0.01088049,0.00631138,0.00476168,0.0029765,0.00233235,0.00157161,7.696955E-04, _
5.9885E-04,3.330869E-04,8.536439E-05,7.443716E-05,8.25746E-05,3.559173E-05, _
2.0313E-05,9.89605E-06,5.760179E-06,3.382734E-06,1.919957E-06,7.691171E-07, _
6.685632E-07,3.743525E-07,2.064697E-07,1.085238E-07,4.926687E-08,3.18623E-08, _
2.155089E-08,1.082376E-08,6.747863E-09,2.641444E-09,1.812909E-09,9.157766E-10, _
5.784374E-10,1.704404E-10,1.556661E-10,1.1885E-10

CM243TJEFF33:
Data 49,200, _
0,2.651382E-08,4.238958E-08,6.773135E-08,1.083513E-07,1.73241E-07,2.769122E-07, _
4.426935E-07,7.078743E-07,1.131609E-06,1.809352E-06,2.892854E-06,4.625528E-06, _
7.396246E-06,1.182751E-05,1.891808E-05,7.807493E-05,7.808E-05,7.806437E-05, _
7.805878E-05,1.99867E-04,1.560742E-04,1.568067E-04,3.127907E-04,0.00102855, _
0.00274459,0.00281051,0.00605453,0.00990173,0.02003693,0.02524634,0.04363008, _
0.06434666,0.09437224,0.1423056,0.2382444,0.2493405,0.346171,0.4838707, _
0.6769516,0.8222609,0.9977856,1.18695,1.711383,1.896189,2.603905,2.941855, _
3.35136,3.860863,4.900176,5.495676,6.026632,6.75572,6.761152,6.204945,7.106018, _
6.345308,5.355651,5.62977,3.209047,3.743859,3.599065,2.776414,1.722327,1.207391, _
0.6525179,0.3587123,0.1775416,0.08594846,0.04880977,0.03088411,0.02569784, _
0.0289207,0.0371854,0.05615525,0.1123767,0.2266169,0.4816379,0.6894942, _
0.8350342,1.308882,1.951753,3.360042,4.698461,5.624364,5.967238,6.601227, _
7.517486,7.164188,7.106297,6.775332,5.164177,5.210863,5.003682,4.08742,3.245409, _
3.336287,2.417539,1.956448,1.847478,1.537725,1.320381,1.180042,0.8843945, _
0.6304879,0.4666568,0.3379526,0.2710537,0.1807352,0.1273701,0.08209115, _
0.05713619,0.04338486,0.0260936,0.0169124,0.00844444,0.00591811,0.0042975, _
0.00277133,0.00190228,6.204522E-04,2.112165E-04,3.124733E-04,3.331199E-04, _
1.055504E-04,2.095333E-04,1.055089E-04,5.618084E-05,3.588607E-05,2.291116E-05, _
1.46244E-05,9.330909E-06,5.953973E-06,3.795722E-06,2.422967E-06,1.545782E-06, _
9.85873E-07,6.289717E-07,4.012161E-07,2.559018E-07,1.632013E-07,1.041153E-07, _
6.639895E-08,4.233838E-08,2.702067E-08,1.71861E-08,1.089696E-08,6.87831E-09, _
4.45145E-09,2.81114E-09,1.814228E-09,1.08611E-09, _
 0,1.976135E-08,3.024226E-08,4.623509E-08,7.648454E-08,1.3748E-07,1.992169E-07, _
3.046717E-07,5.168044E-07,8.175229E-07,1.341857E-06,2.145188E-06,3.321825E-06, _
4.54461E-06,8.36276E-06,1.506075E-05,4.967154E-05,5.921736E-05,5.575269E-05, _
5.944488E-05,1.090263E-04,7.371036E-05,1.223978E-04,1.26183E-04,3.631264E-04, _
0.00197282,0.00124559,0.00215031,0.00335738,0.00581998,0.00596401,0.00913815, _
0.0120775,0.01501635,0.0222191,0.04139154,0.04193413,0.05254588,0.07498755, _
0.09091322,0.1054178,0.1300055,0.1590916,0.2538391,0.2527788,0.3564562, _
0.3994252,0.4063351,0.4420801,0.5171102,0.6835566,0.7186468,0.9202165,0.9683109, _
0.8388703,0.8483587,0.8138027,0.8447409,0.8142765,0.5145857,0.6585132,0.5020273, _
0.3886584,0.2713781,0.1891286,0.1199979,0.05337558,0.03360365,0.01626002, _
0.01097498,0.00675766,0.00648738,0.00517402,0.00813279,0.010178,0.01847232, _
0.03358336,0.07373603,0.07584512,0.08707377,0.1352346,0.2195529,0.3891647, _
0.4550401,0.5391771,0.6458759,0.7511661,0.7820671,0.8713762,0.80426,0.8643174, _
0.6838202,0.7292395,0.5357836,0.5619519,0.4829974,0.4825081,0.3204766,0.2730783, _
0.2291085,0.2308842,0.2042203,0.1688453,0.1333732,0.1064763,0.07956441, _
0.06975928,0.05334004,0.0391155,0.03257112,0.02182198,0.01596798,0.0114938, _
0.0092176,0.00685837,0.00490134,0.00302524,0.00199248,0.00131851,0.00104539, _
4.287279E-04,8.716002E-05,2.330941E-04,2.698046E-04,8.044363E-05,1.501122E-04, _
8.144985E-05,3.337313E-05,2.207888E-05,1.482438E-05,9.458607E-06,4.291708E-06, _
4.312895E-06,2.193116E-06,1.709839E-06,1.018113E-06,5.298446E-07,3.967779E-07, _
2.955393E-07,1.663631E-07,1.187928E-07,5.220219E-08,4.055938E-08,2.3491E-08, _
1.670477E-08,8.117114E-09,5.982685E-09,5.277952E-09,2.515962E-09,1.824832E-09, _
1.299502E-09,7.084738E-10

CM244FJEFF33:
Data 50,200, _
 1.2795E-10,3.1055E-10,6.0894E-10,1.0836E-09,2.11872E-09,3.96392E-09,7.358E-09, _
1.38687E-08,2.597415E-08,4.858212E-08,9.079153E-08,1.697165E-07,3.172162E-07, _
5.92759E-07,1.107819E-06,2.070343E-06,3.869149E-06,7.231193E-06,1.351526E-05, _
2.526286E-05,4.723324E-05,9.135225E-05,1.830144E-04,1.826014E-04,0.00119986, _
0.00110632,0.00184458,0.00508037,0.00724033,0.01441547,0.02282233,0.0402834, _
0.05514738,0.1035482,0.1683171,0.2058685,0.2875884,0.4066629,0.5808638, _
0.7488649,0.9169859,1.120691,1.464812,1.797624,2.315725,2.524221,2.99631, _
3.408063,4.209983,4.385687,4.841199,5.0014,5.431548,5.768565,6.358844,6.156365, _
6.167912,6.16795,5.906075,5.214577,4.611381,3.697012,2.777092,1.869888,1.165303, _
0.5925086,0.2831628,0.1276319,0.04638518,0.01722461,0.00629017,0.00696401, _
0.0096023,0.02099684,0.06080972,0.1514261,0.3425414,0.6565109,1.279692,1.92766, _
2.823786,4.126869,5.267912,6.047824,6.802718,7.062265,6.875585,5.621498,5.54319, _
4.878658,4.870423,5.015906,4.771497,3.919612,3.381997,2.906274,2.672366, _
2.555875,2.330446,1.777877,1.478915,1.232924,1.020038,0.7008169,0.5610212, _
0.448117,0.2724802,0.1884787,0.1182586,0.09277467,0.06788517,0.04127982, _
0.02773247,0.01507435,0.01073322,0.00616971,0.00400334,0.00177223,0.0010185, _
6.386206E-04,2.557479E-04,3.53364E-04,2.444049E-04,1.350568E-04,8.340518E-05, _
5.149004E-05,3.177605E-05,1.961012E-05,1.209091E-05,7.465598E-06,4.596406E-06, _
2.841202E-06,1.737479E-06,1.080904E-06,6.67195E-07,4.105336E-07,2.539177E-07, _
1.566235E-07,9.65744E-08,5.961997E-08,3.66742E-08,2.264025E-08,1.399483E-08, _
8.60362E-09,5.23498E-09,3.274577E-09,2.00981E-09,1.1494E-09,6.57072E-10, _
4.52952E-10,9.8037E-11, _
 1.0826E-10,1.947674E-10,3.419897E-10,6.82832E-10,1.3741E-09,2.297376E-09, _
4.302576E-09,8.87528E-09,1.511891E-08,2.804113E-08,5.773554E-08,1.023716E-07, _
1.607979E-07,3.518694E-07,7.19849E-07,1.19264E-06,2.216275E-06,4.602931E-06, _
7.219409E-06,1.134266E-05,2.94282E-05,5.499184E-05,1.151377E-04,6.227262E-05, _
5.434023E-04,5.271417E-04,6.498104E-04,0.0018726,0.00279199,0.00476736, _
0.00771713,0.01019167,0.01257921,0.02177506,0.04044872,0.04275475,0.0518306, _
0.07015684,0.09512767,0.1104671,0.1218715,0.15837,0.2081781,0.2409101,0.2418483, _
0.3105397,0.3641803,0.3861693,0.4756017,0.4956276,0.5482619,0.6555965,0.6460062, _
0.7505213,0.6676678,0.7988417,0.8230284,0.7781785,0.7516726,0.6667264,0.567371, _
0.4796796,0.3189025,0.2360304,0.1499097,0.07544979,0.04594282,0.01920216, _
0.00972653,0.00379337,0.0024511,0.00144881,0.00261562,0.00366109,0.01239151, _
0.01454587,0.07294271,0.1018488,0.1351543,0.2298475,0.3137618,0.485451, _
0.6022783,0.5645465,0.7318314,0.7329621,0.7829891,0.6691753,0.5665517,0.6427315, _
0.6554474,0.6179752,0.5564321,0.4584081,0.4091102,0.3788218,0.3272056,0.3461774, _
0.2562229,0.251907,0.2342748,0.1910708,0.1632275,0.1348639,0.1023196,0.05832367, _
0.06920031,0.05425596,0.04095608,0.02870794,0.02001292,0.01405969,0.01065097, _
0.00655351,0.0039706,0.00242231,0.00150187,7.490151E-04,3.727165E-04, _
2.82739E-04,1.300441E-04,2.165034E-04,1.634233E-04,7.825863E-05,4.919855E-05, _
3.271409E-05,1.621888E-05,1.014536E-05,7.785652E-06,4.097743E-06,1.789245E-06, _
1.72943E-06,8.695906E-07,6.249014E-07,3.32371E-07,1.959336E-07,1.305533E-07, _
9.024494E-08,6.236228E-08,3.516619E-08,1.529281E-08,1.335096E-08,6.678768E-09, _
4.824501E-09,2.75555E-09,1.664445E-09,9.931798E-10,5.598957E-10,4.917985E-10, _
2.562899E-10,8.3797E-11

CM244TJEFF33:
Data 50,200, _
3.48422E-09,5.86612E-09,9.7598E-09,1.635099E-08,2.728339E-08,4.55649E-08,_
7.610085E-08,1.270801E-07,2.121273E-07,3.542235E-07,5.914141E-07,9.874177E-07,_
1.648558E-06,2.752631E-06,4.595859E-06,7.673762E-06,1.281326E-05,2.139737E-05,_
4.054129E-05,5.970259E-05,9.977038E-05,1.002492E-04,1.002445E-04,2.003588E-04,_
6.057347E-04,5.036287E-04,0.00131354,0.00423732,0.0069352,0.01310195,0.02344825,_
0.03369842,0.05568517,0.09141738,0.1387788,0.1713749,0.2332698,0.3415459,_
0.49393,0.6747851,0.8862982,1.111233,1.50347,1.892242,2.488056,2.809206,_
3.238104,3.770905,4.607484,4.82509,5.316396,5.523333,5.992701,6.172388,6.667102,_
6.368979,6.167352,6.043329,5.574195,4.652621,3.980486,3.070498,2.159927,_
1.414159,0.805259,0.3858012,0.1765245,0.07114691,0.02766641,0.00913295,_
0.00348288,0.00230636,0.00392587,0.00825244,0.0263704,0.07676823,0.1890504,_
0.4125626,0.8147782,1.352602,2.050438,3.06495,4.294545,5.159975,6.330516,_
7.142848,7.501647,7.002446,6.397563,5.365154,5.091555,5.037252,5.148365,_
4.430446,4.148709,3.415198,3.002312,2.72162,2.364019,1.755872,1.447168,1.134392,_
0.9065654,0.6611769,0.4828878,0.3348529,0.2421923,0.1731292,0.118895,0.07072878,_
0.04459972,0.02566488,0.02101791,0.01070403,0.00667684,0.00348613,0.00205947,_
3.965992E-04,4.963097E-04,1.991284E-04,3.835534E-04,2.659072E-04,1.476904E-04,_
9.152177E-05,6.33269E-05,3.510063E-05,2.172548E-05,1.345079E-05,8.315997E-06,_
5.152549E-06,3.180169E-06,1.973147E-06,1.20721E-06,7.552027E-07,4.677792E-07,_
2.88534E-07,1.791482E-07,1.10849E-07,6.854876E-08,4.24664E-08,2.618E-08,_
1.623126E-08,1.006255E-08,6.1974E-09,3.77606E-09,2.374448E-09,1.4615E-09,_
7.4884E-10,4.179E-10,2.37217E-10,0,_
 2.61659E-09,4.038164E-09,6.348702E-09,1.123181E-08,2.076667E-08,3.151326E-08, _
5.124503E-08,9.107024E-08,1.450565E-07,2.462024E-07,4.399168E-07,6.830529E-07, _
9.616435E-07,1.883412E-06,3.519418E-06,5.283043E-06,8.546265E-06,1.529975E-05, _
2.308017E-05,3.168396E-05,7.262076E-05,7.117081E-05,6.591705E-05,7.676663E-05, _
3.963846E-04,2.670884E-04,5.268949E-04,0.00177081,0.00342862,0.0046505, _
0.01013036,0.00983438,0.01268351,0.02156834,0.05086666,0.05060448,0.05933834, _
0.08130713,0.1169146,0.1404503,0.1487093,0.1821669,0.2352463,0.2728039, _
0.2812525,0.3720491,0.393465,0.4273121,0.5200326,0.5475901,0.5950452,0.7165949, _
0.7001676,0.8005837,0.6973314,0.8284147,0.8291004,0.7616154,0.7199535,0.6148724, _
0.5087535,0.4157865,0.2713482,0.2005265,0.1295218,0.05661312,0.03688317, _
0.01375032,0.00702827,0.00217193,0.00115171,5.761757E-04,0.00152491,0.00187156, _
0.00812344,0.02030374,0.04477883,0.06541934,0.08920287,0.155877,0.22334, _
0.3628954,0.481608,0.4813374,0.6925985,0.7449861,0.8612214,0.8643008,0.6612791, _
0.7212221,0.7061426,0.6725866,0.6161711,0.5323899,0.5396562,0.4514514,0.3657934, _
0.3760439,0.2750795,0.2620381,0.2278329,0.1831177,0.1567628,0.1290113,0.0949844, _
0.07563674,0.05489146,0.04825758,0.03658468,0.02304945,0.01454331,0.0107651, _
0.00883226,0.00422005,0.00316643,0.00163709,9.680509E-04,3.018804E-04, _
3.102264E-04,1.459486E-04,2.090678E-04,1.907699E-04,1.103938E-04,6.393381E-05, _
4.558203E-05,2.502316E-05,1.278648E-05,8.130405E-06,6.304779E-06,3.286516E-06, _
1.440826E-06,1.370776E-06,7.001302E-07,5.269793E-07,2.689704E-07,1.602556E-07, _
1.083036E-07,7.626059E-08,5.209516E-08,2.900741E-08,1.242062E-08,1.076066E-08, _
5.603139E-09,4.226407E-09,2.367774E-09,1.345312E-09,8.480879E-10,4.687186E-10, _
4.1943E-10,1.887867E-10,0

CM245FJEFF33:
Data 50,198, _
 9.55318E-10,1.74847E-09,3.34466E-09,6.04981E-09,1.081644E-08,1.964515E-08, _
3.542141E-08,6.385226E-08,1.150617E-07,2.074212E-07,3.73859E-07,6.737981E-07, _
1.214482E-06,2.188869E-06,4.65045E-06,7.112445E-06,1.282274E-05,2.312024E-05, _
4.170212E-05,4.033531E-04,3.035325E-04,2.007476E-04,7.068875E-04,7.037335E-04, _
0.00113029,0.00335645,0.00479872,0.00970799,0.01570802,0.02615518,0.04549439, _
0.06239009,0.09670256,0.1337154,0.2070724,0.2635519,0.3552937,0.4478783, _
0.6305298,0.8276933,1.031328,1.209295,1.502345,1.84769,2.410951,2.614824, _
2.95647,3.3965,4.062806,4.327432,4.813038,4.90355,5.289209,5.640597,6.112238, _
5.934602,5.936596,5.858038,5.613949,4.966633,4.490547,3.685456,2.875474, _
2.194352,1.433179,0.854077,0.4603317,0.2365379,0.1042103,0.05375554,0.02786772, _
0.02262153,0.02889547,0.04138508,0.08350365,0.1669187,0.3099516,0.5563617, _
0.9929101,1.496904,2.152895,3.130675,4.20074,5.2393,6.260648,6.784344,6.90084, _
6.377766,5.942491,5.076884,4.766459,4.701729,4.809805,4.228727,4.01421,3.362456, _
2.94533,2.764478,2.566727,2.020861,1.711708,1.418265,1.193703,0.9241533, _
0.767728,0.5433909,0.4268325,0.3343111,0.2498994,0.1687763,0.1186558,0.08230601, _
0.0539482,0.03186447,0.01953863,0.01115241,0.00744416,0.00523158,0.00357968, _
0.001185,4.970364E-04,4.960166E-04,3.970483E-04,1.984276E-04,1.991293E-04, _
1.991554E-04,3.376622E-05,2.256787E-05,1.130853E-05,6.568475E-06,3.780128E-06, _
2.201952E-06,1.244294E-06,7.372532E-07,4.279425E-07,2.458139E-07,1.434635E-07, _
8.31233E-08,4.804668E-08,2.787672E-08,1.613928E-08,9.28857E-09,5.360926E-09, _
3.12217E-09,1.71148E-09,9.6353E-10,5.2415E-10,2.88964E-10,1.5157E-10, _
 7.600314E-10,1.284036E-09,2.185074E-09,4.171747E-09,8.230054E-09,1.348786E-08, _
2.393609E-08,4.617825E-08,7.801203E-08,1.42474E-07,2.792958E-07,4.654822E-07, _
7.17176E-07,1.50948E-06,3.67541E-06,4.879731E-06,8.663437E-06,1.670373E-05, _
2.51395E-05,1.661885E-04,2.352591E-04,9.857393E-05,2.876464E-04,2.013123E-04, _
8.512613E-04,0.00169393,0.00243125,0.00409555,0.00576553,0.00679403,0.01446254, _
0.01375851,0.01895629,0.02965926,0.05908631,0.05904035,0.07519281,0.08844423, _
0.1237758,0.1557603,0.1663207,0.1965716,0.2331855,0.2761686,0.299094,0.339216, _
0.35739,0.3783695,0.4993151,0.521423,0.5094997,0.6452284,0.6315498,0.743744, _
0.653776,0.7642202,0.792062,0.7424863,0.7417056,0.6671847,0.55819,0.501301, _
0.354733,0.2648067,0.1913684,0.1089652,0.07190756,0.03281111,0.01933937, _
0.00990639,0.0070269,0.00563186,0.00529964,0.00677267,0.01267236,0.02293773, _
0.04645965,0.07162041,0.09522664,0.1637461,0.2254046,0.3527692,0.491751, _
0.5169793,0.6703472,0.7568535,0.8235625,0.8295417,0.6333186,0.6889457,0.6677707, _
0.6112605,0.6126668,0.5249736,0.4992405,0.4568831,0.3652583,0.3841561,0.3101486, _
0.2788079,0.2573386,0.2139309,0.1947254,0.1520362,0.1287842,0.1016475, _
0.08043036,0.06838039,0.05474881,0.03781763,0.02747324,0.01804671,0.01479102, _
0.01116349,0.00971491,0.00456938,0.00293176,0.00245684,0.00200581,4.429077E-04, _
1.791298E-04,2.268157E-04,1.97819E-04,1.527604E-04,9.878024E-05,9.651653E-05, _
2.074212E-05,1.460501E-05,8.671138E-06,4.287031E-06,1.916465E-06,1.575381E-06, _
7.378454E-07,5.11845E-07,2.481604E-07,1.373076E-07,8.850901E-08,5.656661E-08, _
3.683396E-08,1.896679E-08,7.830107E-09,6.554296E-09,3.040052E-09,2.145422E-09, _
1.230562E-09,6.099068E-10,3.106606E-10,1.822272E-10,1.5209E-10

CM245TJEFF33:
Data 50,198, _
1.127445E-09,1.85048E-09,3.38655E-09,5.8348E-09,1.021196E-08,1.76212E-08, _
3.066472E-08,5.308469E-08,9.197748E-08,1.595062E-07,2.764671E-07,4.7899E-07, _
8.300825E-07,1.438243E-06,2.492248E-06,4.318539E-06,7.483951E-06,1.29698E-05, _
2.247726E-05,3.892684E-05,8.381612E-05,6.925913E-05,1.001932E-04,3.326436E-04, _
0.00108187,0.00197162,0.00435797,0.00674964,0.01201504,0.01976862,0.03777755, _
0.0570441,0.08874752,0.151535,0.2230542,0.2828493,0.3673103,0.5046713,0.6505859, _
0.7971463,0.9095606,1.09344,1.434868,2.061354,2.450472,2.401814,2.716,3.09601, _
3.598253,3.700275,4.911394,5.914807,6.547731,6.375953,6.777071,6.479628, _
5.623316,5.546233,5.357003,4.512846,4.227515,3.298877,3.233176,2.155588, _
1.170092,0.6026907,0.3083566,0.1475383,0.07575022,0.03233906,0.01860494, _
0.01397363,0.01381033,0.01994677,0.03943788,0.07655921,0.2022839,0.4390976, _
0.6722656,1.070875,1.778607,2.959753,4.71233,5.471493,5.86894,6.743183,6.28438, _
5.463938,6.46792,7.212308,5.68705,5.324368,4.892166,4.378399,3.759589,3.057149, _
2.588532,2.548347,2.486461,1.984613,1.545975,1.135898,1.120469,1.043703, _
0.8064018,0.5886372,0.4586787,0.3364726,0.262509,0.1651933,0.1194072,0.07393544, _
0.05177343,0.0319034,0.0233772,0.01283643,0.00809952,0.00384861,0.00256146, _
0.00235526,9.278339E-04,4.18131E-04,3.122929E-04,2.092918E-04,1.064989E-04, _
6.188581E-05,3.591281E-05,2.08644E-05,1.207035E-05,7.027991E-06,4.048967E-06, _
2.365459E-06,1.334371E-06,7.950246E-07,4.626426E-07,2.659297E-07,1.557264E-07, _
9.04318E-08,5.240566E-08,3.045252E-08,1.767046E-08,1.020128E-08,5.903146E-09, _
3.43924E-09,1.88607E-09,1.07661E-09,6.7219E-10,3.13844E-10,1.6836E-10, _
 8.737623E-10,1.350617E-09,2.248907E-09,4.205177E-09,7.555466E-09,1.239488E-08, _
2.168517E-08,3.872547E-08,6.171444E-08,1.100495E-07,2.135776E-07,3.307677E-07, _
4.936698E-07,1.021011E-06,1.858016E-06,3.01988E-06,5.246863E-06,9.471797E-06, _
1.296167E-05,6.248149E-06,1.011544E-05,1.095171E-05,1.553094E-05,3.536815E-05, _
7.078813E-05,2.400744E-04,4.824543E-04,7.083548E-04,0.00436534,0.00490482, _
0.01053314,0.01116588,0.01594745,0.02847316,0.03797236,0.04989837,0.06349456, _
0.06883611,0.09798254,0.09913152,0.124453,0.1524752,0.2188668,0.2894888, _
0.2815627,0.281992,0.3389397,0.3371747,0.4415079,0.4289601,0.5218175,0.7785356, _
0.8094777,0.8187014,0.7211215,0.7905173,0.7438651,0.7376572,0.9594027,0.7366755, _
0.5195708,0.5477358,0.4286569,0.2627677,0.1644211,0.06910109,0.04976743, _
0.02165317,0.01302464,0.00633786,0.00523164,0.00291664,0.00374411,0.00391739, _
0.00710403,0.01008968,0.03399885,0.04630413,0.05322759,0.1161594,0.1790531, _
0.3121416,0.5890983,0.5316904,0.6177241,0.8514802,0.7532845,0.8030554,0.8344005, _
0.9405038,0.7488757,0.6955569,0.6927582,0.5655019,0.6026129,0.4231199,0.3165001, _
0.332635,0.2785887,0.2481028,0.2181355,0.1471621,0.1595442,0.1846244,0.1013765, _
0.09248812,0.07316382,0.05590127,0.0414517,0.03109145,0.0246477,0.01600352, _
0.01343478,0.01073688,0.00673097,0.00520779,0.00312835,0.00174215,0.00112137, _
0.00119676,7.010172E-04,1.679143E-04,2.418717E-04,9.591068E-05,7.861157E-05, _
4.427117E-05,2.242484E-05,1.323419E-05,9.375408E-06,4.647502E-06,2.114849E-06, _
1.722237E-06,7.946621E-07,5.586648E-07,2.678766E-07,1.539679E-07,9.852219E-08, _
6.235763E-08,4.062762E-08,2.099349E-08,8.566566E-09,7.33569E-09,3.378022E-09, _
2.395262E-09,1.405615E-09,6.753818E-10,3.566287E-10,1.983472E-10,1.7081E-10

NP237FJEFF33:
Data 56,181, _
 1.5346E-10,5.3059E-10,1.20074E-09,2.77747E-09,6.17107E-09,1.36313E-08, _
3.024808E-08,6.725937E-08,1.491304E-07,3.30628E-07,7.330904E-07,1.625408E-06, _
3.603533E-06,7.989931E-06,1.771257E-05,3.926881E-05,2.422781E-04,2.422995E-04, _
4.838507E-04,4.846088E-04,0.00192716,0.0026491,0.01038824,0.02486353,0.04918898, _
0.1099037,0.1945369,0.48916,0.7726469,0.9545333,1.314635,1.724294,2.209821, _
2.026301,3.351498,3.878649,4.456016,5.163344,5.162074,5.7082,5.579744,6.288262, _
6.177011,7.758987,6.621904,6.244608,5.947788,5.377698,4.240886,2.970768, _
2.239004,1.420357,0.6684306,0.3162321,0.1657839,0.0926703,0.06395966,0.04533237, _
0.04031662,0.04379065,0.04710278,0.04303343,0.05179666,0.05186004,0.050037, _
0.04981798,0.05640927,0.04961467,0.05283194,0.09251875,0.1516728,0.4469343, _
0.7885032,1.654344,2.08824,3.760525,4.704773,6.701185,7.343193,7.627249, _
6.923213,6.385892,6.283518,5.724009,5.777593,4.844906,4.960225,4.759566, _
4.164822,3.250411,2.8423,2.244453,1.767697,1.291273,0.9987026,0.7197123, _
0.4622763,0.3770467,0.1871303,0.1460697,0.09184215,0.04610568,0.01635375, _
0.00768127,0.00253997,0.00127038,8.448889E-04,4.213951E-04,4.21403E-04, _
8.92372E-05,4.193098E-05,1.970518E-05,9.260869E-06,4.352521E-06,2.045636E-06, _
9.61562E-07,4.518523E-07,2.124015E-07,9.97465E-08,4.692527E-08,2.19818E-08, _
1.031972E-08,4.730325E-09,2.285372E-09,1.032252E-09,4.6956E-10, _
 1.564E-10,4.129804E-10,9.239209E-10,2.013904E-09,4.346898E-09,1.017095E-08, _
1.903779E-08,4.701314E-08,1.174709E-07,2.310546E-07,5.046443E-07,1.207021E-06, _
2.427936E-06,4.319855E-06,1.271441E-05,2.875605E-05,1.713372E-04,1.53573E-04, _
3.947609E-04,2.424824E-04,0.00116895,0.00132201,0.00493756,0.00925369, _
0.02007232,0.02539998,0.04414522,0.05826425,0.05765624,0.1039889,0.1633335, _
0.2291842,0.2625985,0.2890964,0.3303452,0.4802992,0.5796145,0.6442487,0.5257368, _
0.646371,0.6260431,0.6638952,0.72371,0.8915239,0.6398922,0.7759887,0.6623142, _
0.693211,0.4510162,0.3691332,0.3012156,0.2396904,0.1499422,0.05028083, _
0.05096097,0.01371797,0.00977546,0.00651912,0.01277994,0.00593546,0.01906712, _
0.01055917,0.01290183,0.01447686,0.01590227,0.00696904,0.01437902,0.01443273, _
0.01285406,0.01007987,0.02382966,0.06899617,0.1071812,0.2790875,0.3011984, _
0.3344077,0.5336043,0.7235048,0.6995638,0.748135,0.6931627,0.7966048,0.7050517, _
0.7383217,0.7126864,0.5202588,0.608936,0.6113231,0.4892481,0.3696071,0.268606, _
0.2185306,0.2269513,0.1711687,0.1295198,0.0636757,0.04926703,0.06517987, _
0.02382555,0.03599073,0.01337846,0.02197091,0.0095898,0.0029154,0.00127184, _
0.00100864,6.338729E-04,3.051365E-04,2.840416E-04,6.238109E-05,2.894562E-05, _
1.43678E-05,6.857398E-06,3.146512E-06,1.378563E-06,7.174689E-07,3.109223E-07, _
1.486717E-07,7.860024E-08,3.277245E-08,1.511812E-08,7.511683E-09,3.544512E-09, _
1.648222E-09,7.240062E-10,3.717347E-10

NP237TJEFF33:
Data 56,181, _
1.9907E-10,6.6209E-10,1.43224E-09,3.2292E-09,6.96021E-09,1.49215E-08, _
3.217718E-08,6.919256E-08,1.487898E-07,3.199144E-07,6.879087E-07,1.479078E-06, _
3.180396E-06,6.838416E-06,1.47026E-05,3.161147E-05,1.575821E-04,1.57584E-04, _
4.719876E-04,1.575933E-04,0.00188591,0.00172961,0.00651334,0.01466196, _
0.03478256,0.06735231,0.147052,0.308495,0.6130183,1.023774,1.405054,1.867243, _
2.243784,2.931132,3.462965,3.741198,4.243583,5.092451,5.467188,5.977494, _
6.053443,5.943146,6.75876,6.713223,7.273121,6.889768,6.488415,5.864048,3.882562, _
2.602228,1.546267,0.750213,0.3106787,0.110958,0.0406098,0.0223147,0.01592479, _
0.01433371,0.01583045,0.01302838,0.0181692,0.02056819,0.01822069,0.01587028, _
0.01542716,0.012988,0.01559141,0.01560315,0.01817093,0.0251254,0.05504302, _
0.1693202,0.4725199,0.9796236,1.906474,3.585763,4.29733,6.511904,6.565245, _
7.691832,7.344918,7.260656,6.057492,5.742111,5.87548,5.790192,4.766693,4.872023, _
4.257804,3.649193,2.73736,2.52443,2.040967,1.71655,1.191628,0.8335738,0.4635258, _
0.2735035,0.1169763,0.06315131,0.02715049,0.01458865,0.00412165,0.00166306, _
0.00114996,7.665419E-04,1.275939E-04,2.551842E-04,6.437653E-05,3.04556E-05, _
1.440919E-05,6.817562E-06,3.225822E-06,1.526393E-06,7.2221E-07,3.417339E-07, _
1.616742E-07,7.650776E-08,3.61157E-08,1.713011E-08,8.07944E-09,3.81712E-09, _
1.73952E-09,8.56914E-10,3.31942E-10,1.2944E-10, _
 1.9995E-10,4.971624E-10,1.110781E-09,2.310486E-09,4.739105E-09,1.101676E-08, _
1.985385E-08,4.791573E-08,1.155924E-07,2.20513E-07,4.668431E-07,1.071815E-06, _
2.162313E-06,3.652101E-06,1.024268E-05,2.290516E-05,1.020658E-04,1.106589E-04, _
3.80046E-04,1.18498E-04,7.472171E-04,6.336552E-04,0.00348615,0.00543724, _
0.01451279,0.01593907,0.02960003,0.06280184,0.1357639,0.1288276,0.2250604, _
0.2556875,0.2956381,0.3576951,0.3673988,0.4906465,0.5603931,0.6652866,0.6191106, _
0.6985924,0.6930577,0.6426551,0.8062252,0.8036,0.747551,0.9020261,0.7549863, _
0.7634113,0.4495646,0.3432338,0.2603317,0.1421426,0.06650993,0.02892864, _
0.01441442,0.00864328,0.00486219,0.00474922,0.00597115,0.00158595,0.00593837, _
0.00444833,0.00460387,0.00534833,0.00598271,0.00348181,0.00501539,0.00437093, _
0.00440731,0.00707641,0.01502607,0.02751819,0.07154689,0.1149245,0.2118965, _
0.4655681,0.5171865,0.7227717,0.7051649,0.7819378,0.7839102,0.977522,0.7231001, _
0.8557044,0.7881743,0.601295,0.6655334,0.6840566,0.5598148,0.4781179,0.3217672, _
0.2915841,0.3195154,0.2615326,0.1901646,0.113168,0.08554024,0.06483138, _
0.02375481,0.0158808,0.01089751,0.0065475,0.00207559,7.068965E-04,4.281279E-04, _
3.628863E-04,9.194446E-05,1.093456E-04,4.980083E-05,2.101108E-05,9.794054E-06, _
4.885505E-06,2.362307E-06,1.091396E-06,4.77419E-07,2.50854E-07,1.095912E-07, _
5.292117E-08,2.813981E-08,1.180768E-08,5.468221E-09,2.718675E-09,1.306925E-09, _
6.108694E-10,2.611497E-10,1.2969E-10
 
NP238FJEFF33:
Data 54,184, _
 1.9108E-10,4.9806E-10,1.03507E-09,2.26979E-09,4.61234E-09,9.59203E-09, _
1.980998E-08,4.075909E-08,8.366818E-08,1.724673E-07,3.547991E-07,7.297934E-07, _
1.501296E-06,3.088442E-06,6.353941E-06,1.307443E-05,2.691003E-05,5.542723E-05, _
1.143045E-04,3.557422E-04,2.828764E-04,0.00152023,0.0022974,0.004162,0.010529, _
0.01766353,0.03224383,0.04912017,0.0942262,0.1702183,0.3569189,0.5181398, _
0.7952918,1.081685,1.784297,2.373942,2.698855,3.411453,4.561659,4.962592, _
5.878211,5.845399,6.527404,6.456414,7.430659,6.741786,6.351005,6.802978, _
6.470051,5.431472,4.527524,3.472917,2.451301,1.370966,0.7090937,0.3381561, _
0.1381202,0.05517896,0.02122335,0.01194568,0.00813481,0.00833942,0.00825951, _
0.00806132,0.00786752,0.00735476,0.0080619,0.00655064,0.00847996,0.00838281, _
0.01533405,0.02701634,0.07694893,0.2157383,0.4845899,0.9179456,1.449037,2.14682, _
4.506299,7.621791,11.51686,2.932868,3.580052,9.123314,7.417545,6.112991, _
5.480983,6.669846,5.976403,4.383773,4.094928,3.56886,3.134572,2.711045,1.786678, _
1.26103,0.9248888,0.7131279,0.4481943,0.2340382,0.1830821,0.09975933,0.05962625, _
0.03761723,0.02427416,0.01056399,0.00582248,0.00358937,0.00179207,5.210569E-04, _
5.198427E-04,1.991679E-04,9.968268E-05,4.981587E-05,2.487629E-05,1.241732E-05, _
6.19654E-06,3.09242E-06,1.542567E-06,7.698749E-07,3.836274E-07,1.916618E-07, _
9.5233E-08,4.761927E-08,2.344727E-08,1.184705E-08,5.75879E-09,2.94296E-09, _
1.32865E-09,6.9701E-10,1.855E-10, _
 3.0404E-10,5.898463E-10,1.174446E-09,2.621183E-09,5.058625E-09,1.076275E-08, _
2.324029E-08,4.464822E-08,8.015862E-08,1.878104E-07,4.237634E-07,8.106112E-07, _
1.60995E-06,3.559341E-06,5.918971E-06,1.11835E-05,3.181778E-05,6.008281E-05, _
1.209279E-04,3.591521E-04,1.632498E-04,0.00108129,0.0020567,0.00223641, _
0.00511091,0.00610783,0.01479916,0.01346021,0.01876221,0.0329873,0.06816772, _
0.08468407,0.1161961,0.1467013,0.2254845,0.2756242,0.271401,0.3824732,0.4685806, _
0.5201634,0.5670862,0.5571749,0.5809628,0.5531542,0.6874754,0.7119578,0.5662402, _
0.703034,0.5790907,0.5809423,0.4598897,0.4049368,0.3209921,0.2120798,0.1379012, _
0.08503407,0.03965362,0.01722558,0.00732372,0.00559081,0.00332168,0.00318744, _
0.00389169,0.00232511,0.0034459,0.00412482,0.00278297,0.00258778,0.00374658, _
0.00296034,0.00517466,0.00758735,0.01719166,0.0437203,0.06987965,0.1209254, _
0.1679831,0.2668934,0.4953994,1.016544,1.215957,2.302581,1.913363,1.344965, _
1.156425,1.186897,1.084347,0.9326055,0.954433,0.996623,0.775997,0.7143577, _
0.4500715,0.4631224,0.4543982,0.3286417,0.2351705,0.1758475,0.1291841,0.1021922, _
0.05666096,0.04098221,0.02701343,0.02020779,0.01403567,0.00647027,0.00354542, _
0.00336346,0.00141199,4.037146E-04,4.665717E-04,2.168214E-04,1.060088E-04, _
5.620365E-05,2.819396E-05,1.403797E-05,6.589491E-06,3.507807E-06,1.634771E-06, _
8.352633E-07,4.689156E-07,2.074003E-07,1.007794E-07,5.263326E-08,2.691931E-08, _
1.334134E-08,6.095729E-09,3.352106E-09,1.450955E-09,7.968587E-10,2.9508E-10  
 
NP238TJEFF33:
Data 50,187, _
4.1733E-10,7.874E-10,1.55022E-09,2.7686E-09,5.40598E-09,1.0098E-08, _
1.898803E-08,3.53891E-08,6.627443E-08,1.240345E-07,2.318777E-07,4.336285E-07, _
8.108202E-07,1.515848E-06,2.834193E-06,5.299598E-06,9.910451E-06,1.853781E-05, _
3.468752E-05,6.496176E-05,2.33278E-04,2.331162E-04,4.322144E-04,8.220203E-04, _
4.611498E-04,0.00109156,0.00279556,0.00669647,0.01143125,0.02696372,0.05869605, _
0.09704014,0.1495083,0.3849129,0.341461,0.6764129,0.8657337,1.089543,1.550508, _
1.913261,2.687452,3.152126,3.870323,4.530476,5.091399,5.353468,5.538822, _
5.993207,5.923707,6.7202,6.941514,6.935893,6.930638,6.715985,5.703475,4.192157, _
2.863801,1.605772,1.10392,0.5154965,0.2369354,0.113952,0.03374197,0.01391503, _
0.01177699,0.01021882,0.00920188,0.01195279,0.00960136,0.01092842,0.01483194, _
0.00953339,0.01170846,0.01254484,0.02225834,0.05295111,0.1402944,0.3499753, _
0.7291115,1.351232,2.259153,3.44407,4.818256,6.573097,7.902948,6.43848,8.05692, _
7.314192,6.476295,4.876337,4.622087,6.053362,5.719409,3.922394,3.878813, _
3.372035,3.07355,2.417204,1.732972,1.281177,1.016256,0.7829072,0.5085247, _
0.3243336,0.1837212,0.114429,0.05920178,0.03719303,0.01953602,0.00871314, _
0.00293943,0.00165809,0.00152463,1.278655E-04,1.278469E-04,1.918957E-04, _
1.233919E-04,5.481988E-05,2.928768E-05,1.564484E-05,8.35565E-06,4.463387E-06, _
2.382864E-06,1.273059E-06,6.784293E-07,3.630972E-07,1.92719E-07,1.035124E-07, _
5.40343E-08,2.945619E-08,1.513483E-08,8.35587E-09,3.8894E-09,2.2872E-09, _
1.27897E-09,5.5044E-10,3.3748E-10,1.3933E-10, _
 2.297915E-10,4.269098E-10,7.559979E-10,1.466597E-09,2.948013E-09,5.016972E-09, _
9.356735E-09,1.912645E-08,3.291407E-08,6.136594E-08,1.237237E-07,2.210046E-07, _
3.509834E-07,7.728469E-07,1.524701E-06,2.620321E-06,4.91389E-06,9.974626E-06, _
1.468619E-05,2.557551E-05,1.296677E-04,1.248097E-04,2.056528E-04,3.887214E-04, _
7.708375E-05,1.47889E-04,3.736286E-04,8.308375E-04,0.00161633,0.00328042, _
0.00560699,0.01121376,0.01897288,0.04263322,0.02870912,0.06369278,0.09900199, _
0.1279056,0.1799112,0.1905574,0.2012426,0.3194275,0.3911215,0.4419301,0.4209702, _
0.4234824,0.4284291,0.460679,0.5141035,0.5850982,0.4449106,0.6031055,0.5416865, _
0.5725141,0.4543965,0.3927313,0.2793996,0.1813545,0.1085644,0.06001201, _
0.03055041,0.01809338,0.00687906,0.00379861,0.00312796,0.00272505,0.00241075, _
0.00208066,0.00246708,0.00209516,0.00267302,0.00194756,0.00272142,0.00212745, _
0.00450777,0.00877592,0.01913549,0.04958563,0.08318046,0.1529972,0.2367001, _
0.4175183,0.5403639,0.7853261,0.8008993,1.076168,0.89144,1.070703,0.9855611, _
1.000093,0.8863631,0.7712404,0.7946147,0.8041857,0.6561609,0.5796499,0.3817229, _
0.3455345,0.3334766,0.2540207,0.1688444,0.1193424,0.07932647,0.05419513, _
0.03051814,0.01948833,0.01138849,0.00788694,0.00591798,0.00258559,8.379035E-04, _
5.127904E-04,8.445538E-04,6.77816E-05,6.312146E-05,9.516176E-05,6.620411E-05, _
2.918156E-05,1.49722E-05,7.770206E-06,4.155062E-06,2.345395E-06,1.159808E-06, _
6.334742E-07,3.733215E-07,1.794118E-07,9.424741E-08,5.458763E-08,2.804368E-08, _
1.456908E-08,7.74788E-09,4.401054E-09,2.037522E-09,1.198335E-09,5.328227E-10, _
3.020401E-10,1.777723E-10,9.976E-11

PU238FJEFF33:
Data 53,183, _
 3.1634E-10,6.0052E-10,1.21719E-09,2.56175E-09,5.08241E-09,1.007211E-08, _
1.98671E-08,3.943592E-08,7.795653E-08,1.5416E-07,3.04738E-07,6.025118E-07, _
1.191117E-06,2.354815E-06,4.655602E-06,9.204963E-06,1.82008E-05,3.599559E-05, _
1.00234E-04,3.01094E-04,1.002223E-04,1.002094E-04,0.00131263,0.00224161, _
0.00420103,0.01113793,0.01592209,0.03656024,0.05144023,0.1084807,0.1894749, _
0.3477632,0.4687417,0.7217399,1.079861,1.733971,2.205077,2.730707,3.224319, _
4.206841,4.791799,5.587992,5.628942,6.024712,6.300686,7.107272,6.824804, _
6.869282,6.576534,6.371716,5.630116,4.942155,3.630533,2.681775,1.828357, _
1.097854,0.5240294,0.2426776,0.09901478,0.03820276,0.01652492,0.01014045, _
0.00918185,0.00914044,0.0081197,0.007886,0.00830693,0.0088,0.00735289, _
0.00903495,0.01220782,0.02535727,0.06903052,0.185909,0.403448,0.8686083, _
1.464112,2.263803,3.305329,4.729667,5.588487,6.825359,7.484039,8.353524, _
7.392483,6.903277,5.552066,5.304426,5.24164,5.541244,4.506773,4.080499,3.293913, _
2.733586,2.2816,1.902434,1.216763,0.8598524,0.6216398,0.4120599,0.2334196, _
0.1405045,0.07083526,0.04755221,0.02688649,0.01101671,0.00722616,0.0033087, _
0.00128473,9.86642E-04,2.99035E-04,9.979395E-05,9.978624E-05,3.938937E-05, _
1.909403E-05,9.25311E-06,4.483675E-06,2.172479E-06,1.05254E-06,5.100366E-07, _
2.470209E-07,1.197092E-07,5.793483E-08,2.810455E-08,1.352352E-08,6.53289E-09, _
3.084552E-09,1.54391E-09,7.0929E-10,2.72328E-10,1.104E-10, _
 2.285873E-10,5.127113E-10,9.131204E-10,1.712858E-09,3.569905E-09,7.127948E-09, _
1.442775E-08,2.900884E-08,5.378522E-08,9.170434E-08,2.094307E-07,4.725015E-07, _
8.302028E-07,1.550023E-06,3.244655E-06,6.228171E-06,9.800452E-06,2.584472E-05, _
7.047064E-05,1.396766E-04,6.273571E-05,8.054575E-05,5.229487E-04,0.0010432, _
0.00161105,0.00441237,0.00430465,0.00985688,0.01044692,0.02166955,0.03402903, _
0.06400522,0.08532217,0.121461,0.1852351,0.2581568,0.2761231,0.3464007, _
0.4456595,0.5877889,0.5996524,0.553695,0.7457815,0.7459193,0.7249818,0.7783031, _
0.7758858,0.836849,0.8793046,0.7624192,0.7753473,0.5708231,0.5278915,0.4184189, _
0.2849737,0.1955407,0.1097669,0.06012668,0.02552376,0.01008427,0.00640245, _
0.00420594,0.00246874,0.0034049,0.00244119,0.0024605,0.00259021,0.00294667, _
0.00224795,0.00306991,0.00322534,0.00530159,0.0142898,0.04479259,0.06315261, _
0.09860247,0.1716833,0.2659025,0.4148929,0.5489926,0.5174478,0.7792747, _
0.8143796,0.9682507,0.8692673,0.7398792,0.7796762,0.7762296,0.7391028,0.5986103, _
0.5709436,0.6037365,0.4490583,0.3473369,0.3331828,0.260107,0.2040999,0.1530161, _
0.1060842,0.07491416,0.05077334,0.03756816,0.01641317,0.01219036,0.00841923, _
0.0057672,0.00321052,0.00158748,6.325602E-04,5.925511E-04,1.432596E-04, _
6.323808E-05,6.303193E-05,2.72213E-05,1.371661E-05,6.880334E-06,3.073906E-06, _
1.186E-06,7.199895E-07,3.957818E-07,1.749141E-07,8.041948E-08,4.030793E-08, _
1.636819E-08,8.465649E-09,4.889487E-09,2.03175E-09,6.770385E-10,5.123847E-10, _
2.049966E-10,1.1144E-10

PU238TJEFF33:
DATA 51,186, _
1.3788E-10,3.7507E-10,7.9469E-10,1.54257E-09,2.83164E-09,5.24318E-09,9.717E-09, _
1.798121E-08,3.323612E-08,6.142192E-08,1.134057E-07,2.094588E-07,3.867082E-07, _
7.141431E-07,1.318584E-06,2.434776E-06,4.496119E-06,8.30361E-06,1.533634E-05, _
5.517927E-05,5.517389E-05,9.691247E-05,1.796001E-04,1.103179E-04,4.431095E-04, _
7.252717E-04,0.00203634,0.00328004,0.00792882,0.01503129,0.02493045,0.05101096, _
0.1019746,0.191078,0.2753039,0.4444523,0.6737398,1.115149,1.472854,2.026771, _
2.507979,3.185167,3.799897,4.730768,5.382185,5.952192,5.639076,6.301749, _
5.926044,6.493121,6.54007,7.302893,7.417792,6.39065,5.364609,3.993535,2.871984, _
1.827028,1.267065,0.3731765,0.16165,0.06092297,0.03012853,0.01903431,0.01767003, _
0.01271473,0.01158802,0.01190845,0.01046468,0.01537562,0.01373459,0.01307565, _
0.02147405,0.03568515,0.1105637,0.3409287,0.647351,1.432595,2.08529,3.803799, _
5.023148,7.731181,7.444948,7.657131,7.393264,7.693831,5.925036,5.771894, _
5.538548,5.082559,5.153706,4.86446,3.64439,3.015224,2.532247,1.889226,1.42924, _
1.293559,0.730951,0.5986246,0.4188612,0.2817218,0.1614545,0.08484131,0.04883212, _
0.02857775,0.01601646,0.00748119,0.00445186,0.00256795,9.303446E-04, _
3.416882E-04,2.569907E-04,8.588446E-05,1.159785E-04,7.494166E-05,3.37593E-05, _
1.819123E-05,9.800223E-06,5.278274E-06,2.842579E-06,1.53088E-06,8.243165E-07, _
4.438188E-07,2.39026E-07,1.286944E-07,6.92011E-08,3.728378E-08,2.009224E-08, _
1.078733E-08,5.82598E-09,3.11668E-09,1.67627E-09,8.4464E-10,3.1578E-10, _
2.1288E-10, _
 1.3315E-10,2.69456E-10,5.473373E-10,1.153412E-09,1.917705E-09,3.34343E-09, _
6.487304E-09,1.211961E-08,2.295457E-08,4.304168E-08,7.441903E-08,1.174855E-07, _
2.533515E-07,5.332935E-07,8.770676E-07,1.527489E-06,2.978566E-06,5.343436E-06, _
7.872729E-06,4.025579E-05,3.970489E-05,5.99063E-05,1.017196E-04,4.910122E-05, _
1.529278E-04,3.203467E-04,7.054493E-04,0.00174929,0.00242623,0.00371742, _
0.00489537,0.00903757,0.0148212,0.02392671,0.03932741,0.06133634,0.09489707, _
0.1305264,0.1568306,0.2339557,0.3145372,0.3998638,0.4286031,0.4394642,0.6485319, _
0.6493626,0.6095845,0.6448089,0.641027,0.7306364,0.8249432,0.8428269,0.9322998, _
0.6658537,0.6953841,0.6654822,0.5052432,0.3845159,0.1774322,0.1230404, _
0.05164189,0.01773408,0.00894665,0.00666538,0.00428129,0.00515771,0.00306008, _
0.00412178,0.00282463,0.00477363,0.00341228,0.00395744,0.00449679,0.00852724, _
0.01962636,0.06166572,0.06719637,0.1292957,0.2052127,0.3689305,0.5629258, _
0.6818669,0.6254272,0.7927244,0.7539764,0.8092042,0.6545215,0.5865784,0.7130958, _
0.7345595,0.6769198,0.5152931,0.4176878,0.4456857,0.3248963,0.2384205,0.2101862, _
0.164969,0.1652044,0.1139083,0.07621173,0.0528909,0.03225729,0.02122641, _
0.01168972,0.00843687,0.00595103,0.00375705,0.00209333,0.00100443,4.469356E-04, _
1.939916E-04,1.309207E-04,6.047632E-05,7.703125E-05,4.889919E-05,2.312061E-05, _
1.296838E-05,6.394404E-06,2.704113E-06,1.852414E-06,1.127772E-06,5.585672E-07, _
2.856864E-07,1.5787E-07,7.081071E-08,4.050815E-08,2.655661E-08,1.210679E-08, _
4.458809E-09,3.796407E-09,1.740032E-09,1.144562E-09,5.01414E-10,2.266677E-10, _
1.466112E-10

PU239FJEFF33:
Data 50,192, _
 5.52344E-09,9.42255E-09,1.62032E-08,2.79761E-08,4.805113E-08,8.25071E-08, _
1.416611E-07,2.433683E-07,4.178871E-07,7.177515E-07,1.2326E-06,2.116833E-06, _
3.635532E-06,6.243733E-06,1.072282E-05,1.841688E-05,3.163359E-05,5.43404E-05, _
9.335848E-05,2.803646E-04,1.401707E-04,7.029676E-04,5.608647E-04,0.00140392, _
0.00226736,0.00239521,0.00814983,0.01452843,0.02502498,0.04006511,0.07593881, _
0.1019897,0.1676324,0.315876,0.4972806,0.6100028,0.7874509,1.006781,1.395465, _
1.730191,2.100369,2.574051,3.053921,3.869369,4.367066,4.713664,4.962288, _
4.941989,5.75049,5.858192,6.681972,6.883358,6.850339,6.570444,6.428263,5.269053, _
4.048843,3.085358,2.118516,1.460802,0.6333975,0.4058883,0.1425009,0.12929, _
0.09635806,0.07678282,0.06244506,0.04047318,0.04020023,0.05066125,0.04335041, _
0.03764857,0.04203415,0.04495732,0.07450686,0.1406291,0.2207873,0.5660489, _
0.9663409,1.314268,3.117062,4.092696,5.255495,7.061505,7.515361,7.524546, _
7.052082,6.420315,5.75462,5.438999,5.308924,4.965551,4.955433,4.264074,3.499064, _
3.021995,2.510977,1.934533,1.696894,1.286171,1.010745,0.8058752,0.6332736, _
0.5313812,0.2905797,0.2001323,0.1286483,0.1052689,0.05991816,0.02945989, _
0.01257853,0.006967,0.0031994,0.00198937,9.547694E-04,5.215484E-04,2.609955E-04, _
5.213088E-04,8.702778E-05,7.386418E-05,4.253343E-05,2.448811E-05,1.409797E-05, _
8.115703E-06,4.671233E-06,2.689298E-06,1.547542E-06,8.911398E-07,5.120889E-07, _
2.952407E-07,1.691771E-07,9.779471E-08,5.53657E-08,3.23005E-08,1.865796E-08, _
1.067863E-08,6.14409E-09,3.51134E-09,2.039937E-09,1.11222E-09,5.88339E-10, _
3.37788E-10,6.3157E-11, _
 3.813728E-09,6.836911E-09,1.068485E-08,1.904273E-08,3.737804E-08,5.615385E-08, _
9.301063E-08,1.755818E-07,2.999513E-07,4.961025E-07,8.782724E-07,1.520776E-06, _
2.185968E-06,4.251492E-06,8.337393E-06,1.252632E-05,2.079322E-05,3.92868E-05, _
6.276641E-05,1.127496E-04,1.070747E-04,4.459679E-04,2.217459E-04,4.677845E-04, _
0.00171979,0.00106128,0.00373739,0.00454935,0.0102854,0.01145184,0.02847414, _
0.02211359,0.03399382,0.03919555,0.04034371,0.07522177,0.1037373,0.1306774, _
0.1633989,0.1765894,0.226662,0.3218848,0.398684,0.4669783,0.4245535,0.5562862, _
0.5668658,0.5281308,0.6461003,0.6515988,0.7016897,0.9184179,0.8306349,0.8273216, _
0.7615575,0.6330574,0.5466883,0.4580911,0.3696328,0.2231916,0.1521833, _
0.05412668,0.01830251,0.01633142,0.01263098,0.0090768,0.00837936,0.01155053, _
0.01312794,0.01065892,0.01105464,0.00796794,0.00856011,0.00785563,0.01389836, _
0.01726928,0.03292679,0.0692747,0.107519,0.1383407,0.3130434,0.4485818, _
0.5681702,0.6257746,0.7370074,0.8105945,0.8227822,0.7577801,0.5570186,0.7012793, _
0.6889519,0.6166015,0.5677971,0.4518062,0.3947914,0.382059,0.2857015,0.2484751, _
0.1647489,0.1500099,0.1308949,0.1020735,0.08062854,0.0733344,0.03383274, _
0.04075058,0.01824705,0.01456178,0.02128967,0.01048135,0.00514591,0.00101529, _
0.00127515,9.431256E-04,4.687819E-04,2.640944E-04,1.226383E-04,2.567022E-04, _
5.067091E-05,5.039533E-05,2.376218E-05,1.75262E-05,1.028409E-05,5.608164E-06, _
3.323625E-06,1.945305E-06,9.350535E-07,5.515746E-07,3.955009E-07,1.908102E-07, _
8.190158E-08,7.004385E-08,3.271283E-08,2.240151E-08,1.083326E-08,5.95055E-09, _
3.758842E-09,2.4211E-09,1.582675E-09,8.019004E-10,3.215498E-10,2.701968E-10, _
6.3546E-11

PU239TJEFF33:
Data 50,185, _
 1.1166E-10,2.1903E-10,5.4381E-10,1.08433E-09,2.1532E-09,3.98784E-09, _
7.55316E-09,1.41336E-08,2.657925E-08,4.97921E-08,9.36235E-08,1.753813E-07, _
3.288122E-07,6.16091E-07,1.154541E-06,2.163201E-06,4.052986E-06,7.592231E-06, _
1.421712E-05,2.660939E-05,4.974649E-05,1.131817E-04,1.138041E-04,3.814893E-04, _
0.00126092,0.00120527,0.00273059,0.00763109,0.02863823,0.01345109,0.1056759, _
0.1498265,0.204173,0.2939928,0.4837121,0.5802397,0.7614957,0.9846084,1.327605, _
1.72302,2.097209,2.436387,3.076949,3.884427,4.501917,4.904048,4.999029,5.333609, _
5.448235,6.164093,6.502648,6.341385,6.694514,6.870355,6.684311,5.6419,4.352473, _
3.009134,1.949459,1.106255,0.6141254,0.2825043,0.1254029,0.08132425,0.05411904, _
0.03651046,0.04588027,0.04589101,0.04606714,0.04816486,0.04177229,0.04434525, _
0.06914853,0.04289015,0.1267029,0.110603,0.2992532,0.5384582,0.9346642,1.666024, _
2.723429,3.777238,5.133238,6.843677,6.736148,7.435879,6.816312,6.703455, _
6.071635,5.822451,5.301612,5.194958,4.953799,4.458144,3.761161,3.052867, _
2.529362,2.071352,1.683539,1.259722,0.9763621,0.7849337,0.615334,0.5896115, _
0.2851647,0.1903832,0.1119214,0.07969778,0.06890935,0.02165357,0.01306789, _
0.00490719,0.00269883,0.00149775,0.00116504,2.808437E-04,1.861808E-04, _
9.311409E-05,4.176814E-05,2.00204E-05,9.607781E-06,4.612886E-06,2.215286E-06, _
1.064133E-06,5.11071E-07,2.45548E-07,1.178993E-07,5.663611E-08,2.71053E-08, _
1.299763E-08,6.24722E-09,2.99841E-09,1.37644E-09,6.9396E-10,1.4003E-10, _
7.1277E-11, _
 1.1259E-10,2.2034E-10,3.975678E-10,7.843499E-10,1.690727E-09,2.761403E-09, _
4.978487E-09,1.027106E-08,1.925183E-08,3.462085E-08,6.674836E-08,1.263925E-07, _
1.961849E-07,4.202215E-07,9.027273E-07,1.474567E-06,2.664681E-06,5.50287E-06, _
9.650253E-06,1.40218E-05,3.563373E-05,5.516552E-05,1.929346E-05,1.566053E-04, _
8.811032E-04,6.405438E-04,0.0012904,0.00109992,0.00394524,0.01460062,0.01252368, _
0.01922235,0.02603965,0.03324816,0.04019085,0.07109086,0.09721585,0.1271292, _
0.1486042,0.1712691,0.221326,0.3050287,0.398535,0.4603002,0.4219057,0.5700824, _
0.5656432,0.5727201,0.6017942,0.6720695,0.6514173,0.7864628,0.7430138,0.8365257, _
0.6496408,0.6544871,0.5439119,0.3465008,0.2468071,0.1451651,0.07163411, _
0.03737959,0.01488695,0.0089335,0.00643997,0.00392349,0.00535401,0.00503866, _
0.00577263,0.00592927,0.00572263,0.01201367,0.00755444,0.0201439,0.01517935, _
0.0135047,0.03491078,0.0514797,0.06778726,0.1636412,0.2581001,0.4090884, _
0.5334138,0.5919246,0.6623636,0.8046853,0.7658479,0.7742429,0.5420538,0.7141382, _
0.6876625,0.6279244,0.5634001,0.4642823,0.4081359,0.3833753,0.2835604,0.2602567, _
0.1617834,0.1414462,0.125321,0.09700452,0.07616711,0.06213474,0.02776039, _
0.02577556,0.01525468,0.0111639,0.01330733,0.00297017,0.00398245,7.254008E-04, _
0.00100869,9.186915E-04,5.709905E-04,1.459384E-04,7.933797E-05,6.721618E-05, _
3.231778E-05,1.361813E-05,5.377444E-06,3.328329E-06,1.599824E-06,7.372065E-07, _
3.702384E-07,1.76739E-07,7.151902E-08,3.520051E-08,2.115387E-08,8.467732E-09, _
3.113491E-09,2.181516E-09,8.303154E-10,4.825017E-10,1.4108E-10,7.1742E-11 

PU240FJEFF33:
Data 56,185, _
3.4757E-10,7.8385E-10,1.79239E-09,4.10795E-09,9.04894E-09,1.987931E-08, _
4.358249E-08,9.5981E-08,2.108997E-07,4.633195E-07,1.018111E-06,2.236874E-06, _
4.91497E-06,1.079951E-05,2.373116E-05,5.215556E-05,1.145216E-04,3.4382E-04, _
3.39454E-04,0.00100797,0.00369699,0.00499811,0.01222348,0.02342011,0.06191091, _
0.08444699,0.149584,0.2242831,0.3850704,0.4313165,0.6220841,0.8549929,0.9736577, _
1.597197,1.810966,2.22842,2.699409,3.690407,3.98354,4.505835,4.797954,5.240489, _
5.590477,6.468683,6.860228,6.601487,6.700564,6.782031,6.689744,5.317264, _
4.984303,3.467328,2.425764,1.7033,0.8758696,0.4917215,0.2304377,0.1561495, _
0.1104629,0.0641767,0.03361473,0.03298041,0.02567693,0.02721066,0.02318115, _
0.01197362,0.01682537,0.0146362,0.03556057,0.08511611,0.2158874,0.4396842, _
0.8680571,1.682757,3.152125,3.564424,4.654015,7.006386,7.185187,7.542304, _
6.573611,6.608047,6.350585,5.781259,5.421966,4.637559,4.716984,4.473208, _
3.931503,3.109131,2.557178,2.150337,1.794125,1.326773,1.071056,0.8357132, _
0.6385245,0.5159298,0.3022795,0.2383936,0.1692258,0.1295775,0.05706782, _
0.03193961,0.01972494,0.01203679,0.01156096,0.00357119,0.00153939,0.00240488, _
8.634226E-04,3.852087E-04,2.047499E-04,1.085968E-04,5.472892E-05,2.761267E-05, _
1.392551E-05,7.025561E-06,3.538465E-06,1.787022E-06,8.981498E-07,4.543812E-07, _
2.253919E-07,1.154305E-07,5.683519E-08,2.92438E-08,1.30618E-08,7.38381E-09, _
3.76065E-09,1.79388E-09, _
 2.491364E-10,6.31962E-10,1.345678E-09,2.771451E-09,6.669514E-09,1.450699E-08, _
2.568943E-08,6.555263E-08,1.67089E-07,3.108669E-07,6.695373E-07,1.680293E-06, _
3.237817E-06,5.61851E-06,1.777225E-05,3.746016E-05,1.589361E-05,2.488641E-04, _
2.714245E-04,5.263604E-04,0.00186567,0.0024158,0.00550216,0.00856366,0.02952232, _
0.02019811,0.03242751,0.02855617,0.03002392,0.04636291,0.07737061,0.1093184, _
0.1198634,0.1800744,0.1699797,0.2761801,0.349477,0.444502,0.3943158,0.4881268, _
0.5186273,0.5577381,0.6431952,0.7346855,0.6382906,0.8343064,0.7840185,0.9035097, _
0.7317792,0.6971656,0.6309432,0.547643,0.4165687,0.2548822,0.1922597,0.06505471, _
0.02819784,0.02132018,0.03074092,0.00796258,0.01592811,0.00879003,0.00842018, _
0.00825419,0.00877177,0.0034049,0.00559969,0.00399788,0.01170632,0.01002204, _
0.03340827,0.04987678,0.104704,0.1884492,0.2958905,0.3687486,0.5220276, _
0.6777118,0.5407114,0.8961655,0.7564353,0.8262256,0.5777588,0.7202372,0.6693552, _
0.6084607,0.6025949,0.5340214,0.3565152,0.3975103,0.3094366,0.2781775,0.2056486, _
0.1450409,0.1167477,0.1069338,0.08429439,0.06848371,0.03041509,0.03130597, _
0.02415748,0.02031929,0.02553782,0.00360708,0.0087812,0.00176565,0.00574991, _
0.00183155,7.154556E-04,0.00178333,6.34266E-04,2.82873E-04,1.523697E-04, _
1.703811E-05,3.786223E-05,2.057454E-05,9.055625E-06,4.731019E-06,2.816317E-06, _
1.210598E-06,5.762141E-07,3.302552E-07,1.679587E-07,7.710322E-08,4.020159E-08, _
2.175329E-08,8.64509E-09,5.057104E-09,2.283246E-09,1.126763E-09

PU241FJEFF33:
Data 55,185, _
 1.242E-10,4.5368E-10,9.819699E-10,2.4336E-09,5.50522E-09,1.254784E-08, _
2.856864E-08,6.476141E-08,1.469118E-07,3.332129E-07,7.558617E-07,1.714272E-06, _
3.887607E-06,8.816131E-06,1.998909E-05,4.530678E-05,1.542439E-04,1.542378E-04, _
4.615301E-04,0.0012179,0.00291683,0.00512207,0.00629197,0.01120626,0.02299139, _
0.04167455,0.06533355,0.09540983,0.194892,0.3411069,0.3952299,0.5720795, _
0.7493572,0.9468897,1.145063,1.516667,1.876091,2.326961,2.94312,3.34806, _
3.846542,4.324638,4.563633,4.875077,5.539471,6.117204,6.253827,6.603826, _
6.735698,7.005534,6.261847,5.975683,4.695497,3.838608,2.808497,1.932007, _
1.061875,0.5208524,0.2422159,0.09747106,0.03777265,0.02005626,0.01015937, _
0.01341603,0.01009454,0.01269926,0.01097887,0.0113521,0.01745154,0.04166053, _
0.0925595,0.1602595,0.3153555,0.5994778,1.85629,2.750642,3.134249,4.563942, _
6.649597,7.691439,7.264333,6.882228,6.499306,6.238023,6.131344,5.280434, _
4.623214,4.574746,4.538776,4.111577,3.232158,2.696221,2.196428,1.913205,1.43514, _
1.185615,0.9000165,0.704043,0.5765644,0.367541,0.2705554,0.1718544,0.1215089, _
0.07798681,0.04533362,0.0266054,0.01114205,0.00642972,0.00423219,0.00353481, _
6.442454E-04,8.611103E-04,2.145183E-04,1.069556E-04,5.122253E-05,2.328523E-05, _
1.059979E-05,4.817683E-06,2.19509E-06,9.926445E-07,4.545871E-07,2.043481E-07, _
9.397106E-08,4.039838E-08,1.94011E-08,8.24651E-09,3.8525E-09,1.34965E-09, _
7.939E-10,1.8785E-10,1.0111E-10, _
 1.2352E-10,3.342458E-10,8.068617E-10,1.601046E-09,3.697306E-09,9.856265E-09, _
1.947259E-08,3.798579E-08,1.073806E-07,2.468112E-07,5.0031E-07,1.213644E-06, _
2.918167E-06,4.896565E-06,1.137851E-05,3.537921E-05,1.136602E-04,1.123841E-04, _
2.365112E-04,6.388922E-04,0.00223883,0.00309458,0.00226913,0.00450868, _
0.00893074,0.01790298,0.01588413,0.02352734,0.02464427,0.03286227,0.04055686, _
0.06565952,0.0950117,0.1232144,0.1663651,0.1372938,0.2296004,0.2987528, _
0.3713204,0.3687522,0.4129008,0.4437508,0.491078,0.5856175,0.6892378,0.5536416, _
0.7676179,0.7462624,0.880575,0.7504517,0.818805,0.673991,0.6939628,0.5722783, _
0.4529554,0.3233347,0.1944301,0.1081946,0.04569557,0.02089345,0.0093468, _
0.00501779,0.00229938,0.00368792,0.00321991,0.00373103,0.00318532,0.00466394, _
0.00357517,0.01085926,0.01272627,0.02326486,0.04525862,0.07531633,0.2008633, _
0.2724682,0.3454277,0.5003498,0.7058346,0.5762842,0.893528,0.7849709,0.8052948, _
0.6592649,0.7046409,0.5946193,0.6498004,0.5833343,0.5547686,0.3631837,0.3812459, _
0.3127209,0.2740368,0.2359697,0.1639782,0.121206,0.1157999,0.09188344, _
0.07875016,0.0385966,0.04033509,0.02856394,0.02186177,0.01586204,0.01119237, _
0.00704573,0.00422987,0.00225128,0.00176886,0.00159511,2.587133E-04, _
3.568266E-04,1.686219E-04,7.587628E-05,3.384043E-05,1.764003E-05,7.4717E-06, _
3.071367E-06,1.550251E-06,7.658608E-07,3.008342E-07,1.406781E-07,7.120813E-08, _
2.851718E-08,1.289901E-08,6.757241E-09,2.804121E-09,1.033173E-09,5.995801E-10, _
1.8572E-10,1.0055E-10

PU241TJEFF33:
Data 53,190, _
 1.9842E-10,5.2197E-10,9.9673E-10,1.72161E-09,3.27614E-09,5.91326E-09, _
1.073374E-08,1.950366E-08,3.551501E-08,6.434834E-08,1.167185E-07,2.116031E-07, _
3.837254E-07,6.95626E-07,1.261145E-06,2.286538E-06,4.14579E-06,7.516793E-06, _
1.363E-05,2.471714E-05,4.822903E-05,7.242214E-05,1.447505E-04,2.664301E-04, _
4.940708E-04,0.00311073,0.0108238,0.0273699,0.05536247,0.1062725,0.198669, _
0.3581188,0.3904229,0.6121143,0.7283344,0.9696087,1.179264,1.487637,1.67765, _
2.202219,2.829372,3.264933,3.906056,4.24741,4.655401,5.123612,5.767231,6.95794, _
5.829607,6.350744,6.962361,6.915975,5.924057,6.082548,4.987988,4.001709, _
2.716009,1.616362,0.6614641,0.1961589,0.193898,0.2857614,0.1763062,0.106218, _
0.08109245,0.06502152,0.08654787,0.04559711,0.08622891,0.09871969,0.1266852, _
0.1649712,0.2257521,0.317138,0.4549747,0.7108182,1.16333,1.9387,3.106544, _
4.620165,6.949808,8.154119,6.784691,7.338927,6.589346,6.169878,5.4186,5.778981, _
4.725349,4.453794,4.290837,3.976709,3.192725,2.559226,2.247951,1.835857,1.53451, _
1.146978,0.9006642,0.7274515,0.4785381,0.3872696,0.2941654,0.2476875,0.2083485, _
0.1669375,0.1230208,0.0968168,0.0702884,0.04919051,0.01753049,0.00886794, _
0.00827005,0.00307235,0.00191169,0.00104233,5.622182E-04,3.012712E-04, _
1.611432E-04,8.584524E-05,4.585531E-05,2.420638E-05,1.301718E-05,6.817835E-06, _
3.685151E-06,1.809516E-06,1.040342E-06,5.102862E-07,2.878409E-07,1.058177E-07, _
7.98531E-08,4.43568E-08,1.96223E-08,1.240594E-08,6.76757E-09,3.60835E-09, _
1.81982E-09,9.55117E-10, _
 1.9892E-10,4.225559E-10,6.690691E-10,1.262101E-09,2.519279E-09,3.986038E-09, _
7.243595E-09,1.541773E-08,2.475847E-08,3.746474E-08,8.524394E-08,1.609237E-07, _
2.567352E-07,4.905145E-07,9.633995E-07,1.312112E-06,2.333794E-06,5.916103E-06, _
9.421975E-06,1.595661E-05,2.483943E-05,5.684575E-05,5.187178E-05,1.960493E-04, _
7.281098E-05,0.00105399,0.00269853,0.00814204,0.01101497,0.01771289,0.02573442, _
0.03653871,0.03993239,0.0715794,0.09342149,0.1251658,0.1341535,0.1307916, _
0.2100962,0.2858212,0.3655731,0.360276,0.4150814,0.4412751,0.5037985,0.6301462, _
0.690976,0.6552277,0.7410561,0.7247283,0.8569258,0.7395809,0.7263237,0.6890378, _
0.6479053,0.5114396,0.3389929,0.2304503,0.1052195,0.02599816,0.02640288, _
0.0426509,0.0304384,0.02289876,0.01446543,0.01558828,0.01918487,0.02487024, _
0.01501379,0.01572325,0.01852489,0.03023995,0.03625891,0.05770024,0.08342589, _
0.1086306,0.1685282,0.1734033,0.3352662,0.5052494,0.7142265,0.6120524,0.8448151, _
0.818897,0.8058524,0.6490104,0.6181581,0.6245522,0.5891892,0.5641983,0.5276517, _
0.3420119,0.3667215,0.2933193,0.2768213,0.226831,0.1757177,0.1151025,0.1171336, _
0.09781783,0.08535773,0.05161168,0.07520662,0.06203324,0.04790455,0.03801185, _
0.0249702,0.01854339,0.01385231,0.00939037,0.00876626,0.00648715,0.00298068, _
0.00193749,0.00154211,7.203204E-04,3.818928E-04,2.371414E-04,1.131334E-04, _
5.555185E-05,3.348931E-05,1.859782E-05,8.718098E-06,4.903243E-06,2.814427E-06, _
1.291558E-06,7.051834E-07,4.368461E-07,2.044194E-07,8.578827E-08,6.258841E-08, _
2.601165E-08,1.496751E-08,9.25781E-09,5.132794E-09,2.366817E-09,1.30707E-09, _
5.823388E-10

PU242FJEFF33:
Data 52,191, _
5.9748E-10,1.06325E-09,1.97474E-09,3.86192E-09,7.21607E-09,1.34011E-08, _
2.50361E-08,4.667213E-08,8.690282E-08,1.620389E-07,3.019249E-07,5.625158E-07, _
1.048136E-06,1.952796E-06,3.637878E-06,6.777378E-06,1.262424E-05,2.35095E-05, _
4.376081E-05,8.140354E-05,1.51202E-04,3.784678E-04,3.782436E-04,7.449553E-04, _
0.00209049,0.00326882,0.00752744,0.014923,0.02749817,0.041048,0.02926653, _
0.1720275,0.3282475,0.2363174,0.5160396,0.5956885,0.7945796,0.9604318,1.572878, _
1.745071,2.117438,2.785248,3.090669,3.528017,4.263288,4.408637,4.75417,5.675151, _
5.990327,6.103587,6.466331,6.496189,6.622612,5.994921,5.429551,5.020928, _
4.389912,3.664656,2.66781,1.692441,0.9656172,0.494232,0.2157768,0.07240211, _
0.02485528,0.01060789,0.00239519,0.00357122,0.00212678,0.00419752,0.00350153, _
0.00828193,0.01653739,0.0548611,0.1727456,0.3425249,0.5705107,1.488185,2.474467, _
3.048304,4.435411,6.771694,7.229228,6.841674,6.819135,6.234725,6.124607, _
5.900991,5.548419,5.606243,4.51903,4.476521,4.164672,3.317798,2.841379,2.320615, _
1.971602,1.551394,1.434946,0.9846756,0.7643406,0.6476396,0.4260587,0.3665879, _
0.2203008,0.1119212,0.07694918,0.05523067,0.02469594,0.01169621,0.00871035, _
0.00302968,9.297715E-04,1.825339E-04,1.825269E-04,3.651521E-04,1.129647E-04, _
6.362466E-05,3.573532E-05,2.020924E-05,1.131354E-05,6.423542E-06,3.494955E-06, _
2.040045E-06,1.098364E-06,6.422782E-07,2.911172E-07,2.018239E-07,9.50028E-08, _
5.920514E-08,1.677645E-08,1.83498E-08,1.123893E-08,4.19468E-09,3.51942E-09, _
2.03734E-09,1.19814E-09,6.4568E-10,2.7964E-10,1.2481E-10, _
 3.809892E-10,8.01746E-10,1.557804E-09,2.528619E-09,4.969626E-09,1.023181E-08, _
1.638314E-08,3.071064E-08,6.755933E-08,1.105183E-07,1.757882E-07,4.122112E-07, _
7.718251E-07,1.275087E-06,2.561476E-06,5.114867E-06,6.892963E-06,1.352198E-05, _
3.408361E-05,5.4879E-05,9.759263E-05,2.328719E-04,2.670967E-04,5.656814E-04, _
0.00175338,0.00136665,0.00299337,0.0077381,0.01676707,0.01693598,0.02981896, _
0.02231852,0.03575817,0.05235064,0.05371189,0.07887486,0.1081597,0.1709533, _
0.1467406,0.201572,0.2719552,0.3530464,0.3649233,0.3749846,0.4006905,0.4767659, _
0.5785345,0.695848,0.5381998,0.7277801,0.7283629,0.8448035,0.768381,0.7937281, _
0.6525334,0.7448826,0.7350877,0.5950043,0.5010812,0.3453505,0.2086991, _
0.07934979,0.04707859,0.02148287,0.00642471,0.00226987,7.913442E-04,0.00133742, _
6.17989E-04,0.00128449,0.0021077,0.00181896,0.00567902,0.00637081,0.02697835, _
0.04873924,0.06958582,0.1759305,0.2283519,0.3573421,0.4797214,0.7116499, _
0.5932626,0.7887837,0.7624145,0.742835,0.7319676,0.7147526,0.5117683,0.7273689, _
0.5938107,0.5617151,0.3967571,0.3600861,0.2867123,0.2958407,0.256809,0.2043862, _
0.1728887,0.1185703,0.1008448,0.08732047,0.05032988,0.05303648,0.03400946, _
0.02026146,0.01531794,0.01200371,0.00739078,0.00356776,0.00312145,0.00114561, _
5.807426E-04,1.329344E-04,1.401619E-04,1.754947E-04,7.161936E-05,4.362478E-05, _
2.771665E-05,1.324651E-05,7.507718E-06,4.905663E-06,2.463278E-06,1.336109E-06, _
8.736262E-07,4.627974E-07,2.200305E-07,1.456399E-07,8.646619E-08,4.254249E-08, _
1.504239E-08,1.581969E-08,6.788604E-09,3.567098E-09,2.898319E-09,1.47749E-09, _
7.639517E-10,4.866416E-10,1.953365E-10,1.228E-10

TH232FJEFF33:
Data 67,166, _
6.28019E-08,3.048453E-07,1.479267E-06,7.179145E-06,3.485845E-05,1.690303E-04, _
6.682585E-04,0.00252878,0.00867006,0.02342308,0.0107279,0.03832666,0.1928148, _
0.4539396,0.9223403,1.492479,1.79391,4.222576,4.233688,6.614008,6.378335, _
6.653377,7.300153,7.478401,7.166173,6.934811,6.115372,5.416214,5.516163, _
5.511577,4.372499,3.622973,2.897637,2.066286,1.142139,0.5168018,0.1523652, _
0.09697901,0.06997259,0.05357909,0.05185276,0.07889966,0.05261534,0.08059483, _
0.06401694,0.04891258,0.05650231,0.03296779,0.06163613,0.08849256,0.07409281, _
0.03252736,0.1178009,0.08381763,0.05819903,0.04487252,0.0468442,0.0457677, _
0.03126614,0.04416005,0.07860567,0.1529496,0.4135519,1.479195,1.494315,2.557639, _
4.472186,5.706387,5.513543,5.510931,6.413575,6.284714,7.13561,7.597317,7.042211, _
6.35799,6.415118,7.538609,5.187327,3.849776,3.022345,1.962777,1.162429,1.035271, _
0.4136207,0.2787645,0.2016444,0.04298374,0.00734896,0.00247988,5.525181E-04, _
1.253265E-04,2.82618E-05,6.363372E-06,1.432353E-06,3.223715E-07,7.24914E-08, _
1.63164E-08,3.6011E-09,7.0712E-10, _
 4.916982E-08,1.887712E-07,8.236174E-07,5.955717E-06,2.439158E-05,3.052034E-05, _
4.685258E-04,0.00189287,0.00614362,0.01033225,0.00146397,0.01309312,0.04989926, _
0.1576367,0.1780531,0.2282346,0.247405,0.4278897,0.3794706,0.6122872,0.7533823, _
0.8651196,0.8770217,0.6840195,0.7453246,0.7716317,0.8091936,0.6731032,0.5961513, _
0.4639525,0.4341413,0.5652605,0.3797524,0.5452726,0.5163139,0.3362451, _
0.01912666,0.03994909,0.00929888,0.00536608,0.02141332,0.02993109,0.00719535, _
0.02736286,0.00812816,0.00544584,0.01743842,0.02169242,0.0088788,0.03537786, _
0.02377136,0.03965516,0.03092303,0.02492586,0.01612593,0.01661331,0.0153312, _
0.03024765,0.01015688,0.01993439,0.00828229,0.05802341,0.05917083,0.3936728, _
0.1253594,0.2655208,0.5003969,0.5148686,0.4998149,0.4459747,0.7997394,0.7993277, _
0.889456,0.5444507,0.7299147,0.7174192,0.8219265,0.7707193,0.6342615,0.4362369, _
0.3715851,0.2713839,0.1653326,0.155401,0.04796709,0.1544374,0.03019118, _
0.01925173,0.00411829,3.812332E-04,3.898367E-04,8.627836E-05,2.097346E-05, _
4.923401E-06,1.098742E-06,2.408956E-07,5.512003E-08,1.115658E-08,2.580868E-09, _
6.9541E-10

TH232HJEFF33:
Data 50,184, _
 6.12398E-09,1.115979E-08,2.063553E-08,3.790248E-08,6.959925E-08,1.277521E-07, _
2.345421E-07,4.307513E-07,7.907537E-07,1.45197E-06,2.665739E-06,4.894149E-06, _
8.985327E-06,1.649553E-05,6.164374E-05,6.16434E-05,1.021054E-04,1.807302E-04, _
1.803925E-04,0.00107926,0.00116141,0.00302459,0.00532981,0.01094305,0.02079067, _
0.04271151,0.07088318,0.1223788,0.2699651,0.6947335,0.8640168,1.374197,2.037671, _
2.824235,3.77674,4.240724,4.842801,4.692041,4.888798,6.056032,6.423183,5.989763, _
5.408194,5.599883,5.661039,5.145661,4.194389,3.16859,2.535092,1.992232,1.903991, _
1.609744,1.202302,0.8935664,0.9265247,1.0072,1.093346,0.9424515,0.9170969, _
0.9913036,1.028321,1.17444,1.203833,1.185425,0.9615327,1.368672,1.293506, _
1.131631,1.113233,1.083543,1.015886,0.9477279,0.9424269,0.8405035,0.8426623, _
0.8683743,0.9652113,1.138176,1.469073,1.653704,2.036237,2.312193,2.977745, _
4.07256,5.64364,5.061493,6.290641,6.207597,6.148614,5.545597,5.719534,5.717975, _
5.165672,5.027386,4.213552,3.58295,2.246524,1.812401,1.452631,1.015067, _
0.4742521,0.1709999,0.1220391,0.08669351,0.08091789,0.06102002,0.03685653, _
0.022505,0.01087674,0.00443345,0.00276304,0.00106754,5.374526E-04,1.783138E-04, _
1.526214E-04,9.59211E-05,3.930454E-05,1.995563E-05,1.013214E-05,5.145826E-06, _
2.611122E-06,1.327065E-06,6.723934E-07,3.421766E-07,1.718117E-07,8.819008E-08, _
4.389276E-08,2.264573E-08,1.0472E-08,5.805122E-09,2.672232E-09,1.42547E-09, _
4.2765E-10,2.6123E-10,1.0099E-10, _
 4.298546E-09,8.28851E-09,1.354942E-08,2.595745E-08,5.460476E-08,8.683699E-08, _
1.557899E-07,3.214563E-07,5.570235E-07,9.862176E-07,2.001915E-06,3.502072E-06, _
5.485072E-06,1.157375E-05,4.952229E-05,4.36902E-05,2.033776E-05,4.02169E-05, _
1.286466E-04,4.156772E-04,9.313587E-04,0.00162433,9.002351E-04,0.00367526, _
0.00885907,0.01185135,0.01904972,0.01880413,0.05023882,0.1368953,0.2037767, _
0.2307934,0.3190878,0.4148839,0.4733373,0.5024807,0.5559338,0.6344919,0.6474944, _
0.7868376,0.735558,0.6966236,0.6922687,0.683713,0.7068124,0.6281925,0.4192325, _
0.3510581,0.3155307,0.2567785,0.2074737,0.2159442,0.1487349,0.1153479,0.117009, _
0.1371626,0.1373812,0.1556573,0.1540693,0.1402612,0.1687075,0.152723,0.1346128, _
0.1358574,0.152195,0.1689065,0.1584609,0.1345322,0.1499265,0.1324258,0.1271019, _
0.1201756,0.1092999,0.1014803,0.1063241,0.1008793,0.1234168,0.1344175,0.1354193, _
0.2108514,0.2104122,0.2714193,0.3515196,0.447361,0.5640212,0.6661536,0.7847315, _
0.8121216,0.6591678,0.7251743,0.6902648,0.7380052,0.6837467,0.6209545,0.4131059, _
0.4459556,0.2778696,0.2304234,0.1886688,0.1404463,0.07019195,0.02875651, _
0.02023025,0.01263133,0.01742639,0.01473201,0.00654029,0.00782091,0.00370816, _
6.735533E-04,0.00121294,1.418562E-04,3.570919E-04,1.291147E-04,1.178702E-04, _
6.809874E-05,2.675255E-05,1.498718E-05,6.910835E-06,3.48811E-06,2.00012E-06, _
9.292153E-07,4.384461E-07,2.449952E-07,1.313383E-07,5.994699E-08,3.145451E-08, _
1.697437E-08,7.623371E-09,3.982631E-09,2.289728E-09,1.038042E-09,4.116268E-10, _
2.6483E-10,1.0252E-10

U233FJEFF33:
Data 49,179, _
 0,8.63005E-08,1.248141E-07,1.804774E-07,2.610233E-07,3.774725E-07,5.45829E-07, _
7.894712E-07,1.141731E-06,1.651305E-06,2.388347E-06,3.454571E-06,4.997498E-06, _
7.230509E-06,1.04635E-05,1.514708E-05,2.19356E-05,3.178597E-05,4.610027E-05, _
6.692939E-05,9.051808E-05,2.813684E-04,9.047706E-05,2.802913E-04,4.522972E-04, _
0.00298928,0.00796106,0.01423645,0.04128477,0.06490952,0.1297624,0.2031379, _
0.288263,0.5098794,0.9920058,1.632683,2.116569,2.774877,4.082264,5.141429, _
6.285975,6.506244,6.314959,6.512955,7.013649,6.830903,6.358565,5.789689, _
5.499026,5.23793,4.908075,4.459201,3.421293,2.522876,1.56935,1.200716,0.6414263, _
0.2920904,0.1407189,0.07192673,0.05354668,0.06172661,0.05474805,0.0680917, _
0.06182484,0.05991983,0.05872084,0.06196348,0.06020738,0.06007837,0.07360511, _
0.08238405,0.06138688,0.08264188,0.08341186,0.1195043,0.1499032,0.330602, _
0.5433558,1.366841,1.780145,2.406392,3.874145,4.725577,5.710172,6.276864, _
6.261009,6.800376,6.551795,6.556525,6.408871,6.207191,6.491722,6.405687, _
5.370404,4.511094,3.255901,2.436947,1.7532,1.221632,0.7278399,0.4727283, _
0.3154183,0.1954902,0.1109015,0.04632351,0.0166241,0.0158922,0.01103372, _
0.00267306,0.00188399,1.738147E-04,4.957541E-04,7.219831E-04,1.932182E-04, _
4.327421E-05,1.933596E-05,8.615292E-06,3.83393E-06,1.705067E-06,7.58098E-07, _
3.370776E-07,1.498096E-07,6.659124E-08,2.958841E-08,1.316257E-08,5.827113E-09, _
2.5787E-09,1.06482E-09,3.8957E-10,1.058E-10, _
 0,5.471748E-08,9.316457E-08,1.233634E-07,1.796948E-07,2.94505E-07,3.821443E-07, _
5.144125E-07,8.097157E-07,1.267804E-06,1.649646E-06,2.342126E-06,3.72003E-06, _
4.599892E-06,7.169868E-06,1.186889E-05,1.516885E-05,2.059936E-05,3.26912E-05, _
4.870083E-05,5.741808E-05,2.003776E-04,7.024351E-05,1.943738E-04,1.238746E-04, _
0.00171245,0.00253759,0.00352775,0.00751571,0.01460447,0.02152921,0.03877239, _
0.05164863,0.08799478,0.1044519,0.1272153,0.2630991,0.3678419,0.59189,0.5713648, _
0.6602935,0.7251964,0.8160923,0.8520842,0.8408735,0.6504065,0.7462565,0.6813066, _
0.5938689,0.5822985,0.5282928,0.4705661,0.4584435,0.3000662,0.2208142,0.1781463, _
0.1127007,0.04165191,0.03404534,0.01839079,0.01565893,0.01669001,0.01577194, _
0.01363814,0.01615336,0.01696814,0.00599579,0.01810462,0.00745552,0.00810466, _
0.00933235,0.01006902,0.01521224,0.01043017,0.02044452,0.01628696,0.01734983, _
0.05725693,0.08939624,0.181164,0.1980906,0.3278736,0.4453221,0.4469216, _
0.4388759,0.6460472,0.696579,0.7365384,0.684415,0.6114387,0.823624,0.8171761, _
0.814215,0.6964318,0.537914,0.5300926,0.4215658,0.2802967,0.2144125,0.1144131, _
0.08694249,0.06403505,0.04167258,0.02538205,0.02017046,0.01527304,0.00880322, _
0.00288784,0.00209676,0.00266127,2.95435E-04,1.243686E-04,8.854878E-05, _
4.866819E-04,1.332568E-04,3.069346E-05,1.44132E-05,5.809789E-06,2.634611E-06, _
1.328203E-06,5.266816E-07,1.861222E-07,1.07231E-07,5.066929E-08,2.05024E-08, _
9.271138E-09,4.341541E-09,1.550129E-09,7.086787E-10,3.9347E-10,1.0834E-10 

U233HJEFF33:
Data 49,200, _
 0,2.27485E-06,3.262551E-06,4.679337E-06,6.711215E-06,9.625922E-06,1.380639E-05, _
1.980431E-05,2.840863E-05,4.075509E-05,5.847357E-05,1.014157E-04,2.032649E-04, _
3.568473E-04,1.015562E-04,2.54044E-04,2.035314E-04,7.094151E-04,0.00163827, _
0.00240299,0.00345322,0.00483111,0.008412,0.01349268,0.02376238,0.03724457, _
0.05871718,0.09184868,0.1430513,0.2389738,0.3215126,0.491209,0.6624401,1.007355, _
1.345865,1.869208,2.157483,2.729508,3.84311,4.28413,4.94335,4.914954,4.929429, _
4.737093,5.411336,5.554666,4.982927,4.756879,4.649161,4.478983,3.799677, _
3.503474,3.333196,2.96124,2.627463,2.115268,1.740749,1.307333,1.358267,1.293788, _
1.185641,1.236653,1.250079,1.563654,1.031353,0.9916835,1.293048,1.31403, _
1.319204,1.284139,1.181352,1.214019,1.193944,1.154352,1.284672,1.364307, _
1.522484,1.880128,2.153348,2.619883,3.239852,3.746721,4.833272,3.996634, _
4.514891,4.735046,5.157258,5.594665,4.985138,5.528615,5.700118,4.570476, _
4.407271,3.992191,3.121885,2.617487,2.085462,1.64994,1.230597,1.014988, _
0.7775045,0.6184337,0.4291608,0.2638001,0.1401175,0.09104553,0.05912716, _
0.04374739,0.0277361,0.01543828,0.01065596,0.00783345,0.00469113,0.00299578, _
0.00179173,0.0020438,0.00107209,2.396767E-04,4.414346E-04,2.91908E-04, _
8.390516E-05,4.093257E-05,2.135904E-05,1.807184E-05,8.059937E-06,4.169056E-06, _
1.898044E-06,1.321623E-06,9.203464E-07,6.40772E-07,4.462138E-07,3.106294E-07, _
2.163481E-07,1.504267E-07,1.049074E-07,7.302519E-08,5.085017E-08,3.54192E-08, _
2.45839E-08,1.717402E-08,1.188321E-08,8.28851E-09,5.626787E-09,4.02281E-09, _
2.77401E-09,1.94629E-09,1.356327E-09,9.0259E-10,5.37243E-10,3.65814E-10, _
2.0192E-10,0, _
 0,1.314344E-06,2.283271E-06,3.386926E-06,4.673007E-06,6.731563E-06, _
9.831217E-06,1.302149E-05,1.92717E-05,3.112472E-05,3.956939E-05,3.771707E-05, _
1.180642E-04,2.106195E-04,7.726779E-05,1.28595E-04,1.546604E-04,1.11047E-04, _
2.713496E-04,0.0013842,0.00122961,0.00159157,0.00311839,0.00192847,0.00489709, _
0.00860145,0.011051,0.0167933,0.02271436,0.03531508,0.0407783,0.06952921, _
0.08527348,0.1294944,0.1466427,0.1768745,0.2855318,0.3680013,0.5398026, _
0.4623509,0.6295817,0.631629,0.6391391,0.7003331,0.715512,0.620145,0.641252, _
0.5931468,0.5159883,0.5098413,0.4581186,0.4660676,0.4333645,0.3583163,0.347977, _
0.2650795,0.2437164,0.2254735,0.1984667,0.2076531,0.2194619,0.1982636,0.1743431, _
0.1769571,0.1817032,0.164009,0.14478,0.1563553,0.1459627,0.1642065,0.140842, _
0.1381638,0.1468232,0.12787,0.1441326,0.1640601,0.1747695,0.199642,0.2583921, _
0.2747579,0.3048101,0.4178883,0.5301604,0.4009546,0.4538038,0.5077379,0.6099965, _
0.5056448,0.6365792,0.6568102,0.7150986,0.5982038,0.5501997,0.4404003,0.4047329, _
0.3670901,0.2835287,0.1894891,0.1471486,0.1367439,0.1162962,0.09346643, _
0.0822296,0.04203757,0.02108637,0.01566596,0.01247895,0.00618711,0.00563968, _
0.00500398,0.00171478,0.00317551,6.797172E-04,0.001246,0.00103355,6.687509E-04, _
5.46728E-04,4.233358E-05,3.392755E-04,1.393538E-04,1.186419E-05,2.460477E-05, _
1.516122E-05,2.807114E-06,5.466137E-06,2.728688E-06,3.173031E-07,8.055114E-07, _
5.663146E-07,4.238133E-07,2.956889E-07,1.489956E-07,1.468842E-07,9.327723E-08, _
7.109944E-08,4.559224E-08,2.641108E-08,1.967039E-08,1.71984E-08,1.182739E-08, _
8.441422E-09,4.337585E-09,3.645896E-09,2.367479E-09,1.802529E-09,9.713428E-10, _
8.186428E-10,6.209108E-10,3.766427E-10,3.089412E-10,2.0139E-10,0

U233TJEFF33:
Data 59,173, _
 3.3936E-10,1.03318E-09,3.05359E-09,8.53229E-09,2.415013E-08,6.772558E-08, _
1.902477E-07,5.339894E-07,1.498695E-06,4.20556E-06,1.179923E-05,3.308854E-05, _
9.264846E-05,1.444593E-04,8.641421E-04,0.00216745,0.00524013,0.01210722, _
0.03817196,0.06223651,0.1250667,0.2502436,0.3740578,0.5867757,1.058935,1.687676, _
2.200103,3.072268,3.994767,5.446585,6.302013,6.681747,6.584144,6.583334, _
6.981049,6.895349,6.467504,5.765121,5.544787,5.076746,4.605688,4.282255, _
3.143385,2.455915,1.590065,0.9872382,0.5069652,0.2552756,0.1169438,0.08069699, _
0.04258964,0.0402325,0.02509271,0.01455809,0.01621451,0.01757684,0.0196546, _
0.01704585,0.01518911,0.01569595,0.01599876,0.01772294,0.01867598,0.01975015, _
0.02062353,0.03260981,0.1171933,0.2400676,0.4561717,1.006434,1.717803,2.48961, _
3.59463,4.820889,6.028983,6.296755,5.464275,7.929724,6.329963,6.036718,5.70215, _
6.496949,6.293094,6.86947,5.982553,4.714227,3.446023,2.5641,1.857481,1.312256, _
0.7842641,0.4956173,0.3434508,0.2009521,0.1387942,0.04686179,0.02430643, _
0.01153756,0.00720235,0.00462615,9.725812E-04,4.26022E-04,1.210659E-04, _
4.251397E-05,1.490371E-05,5.226853E-06,1.833472E-06,6.431087E-07,2.255471E-07, _
7.906227E-08,2.775946E-08,9.7068E-09,3.37633E-09,1.13126E-09,3.6382E-10, _
 2.654325E-10,7.50642E-10,2.300398E-09,5.438898E-09,1.665282E-08,5.395893E-08, _
1.326785E-07,3.495806E-07,1.085459E-06,3.11014E-06,6.295382E-06,2.294249E-05, _
6.926451E-05,1.061757E-04,2.802558E-04,0.00166593,0.0027946,0.00561474, _
0.00533859,0.00681186,0.0111833,0.03057892,0.04790799,0.07513823,0.1077415, _
0.1147951,0.2630141,0.3898842,0.5130991,0.5632947,0.6238195,0.7175761,0.8360463, _
0.8344205,0.8085191,0.605367,0.7466199,0.6666331,0.5993835,0.5504434,0.4971354, _
0.4398636,0.4065895,0.2730986,0.2121685,0.09987027,0.06296236,0.03419695, _
0.01545852,0.01131015,0.00608852,0.00543055,0.00360019,0.0018308,0.00466814, _
0.00778453,0.00185715,0.0062269,0.00173951,0.00199327,0.00195051,0.00190279, _
0.00182252,0.0022389,0.00518902,0.00425347,0.01443706,0.05673367,0.0705399, _
0.1128721,0.1891727,0.2669577,0.408354,0.4513965,0.4401027,0.6087363,0.619937, _
0.7803371,0.6406233,0.5266615,0.7234339,0.8394417,0.78875,0.7096914,0.551706, _
0.5329731,0.4391901,0.286194,0.2253846,0.1152762,0.08926625,0.06668863, _
0.04729385,0.02654759,0.01962392,0.00482092,0.00753581,0.00177779,0.00116631, _
0.00227921,1.619992E-04,2.939693E-04,1.942893E-05,3.25793E-05,1.035227E-05, _
3.710273E-06,1.370696E-06,4.343489E-07,1.555283E-07,6.228609E-08,1.938714E-08, _
5.33382E-09,2.464807E-09,9.169481E-10,2.862653E-10

U234FJEFF33:
Data 59,174, _
 5.8092E-10,1.59777E-09,6.38546E-09,1.441644E-08,4.39508E-08,7.5928E-08, _
2.272173E-07,7.007408E-07,1.603679E-06,3.579411E-06,1.077813E-05,1.986547E-05, _
5.520242E-05,1.671553E-04,4.920186E-04,0.0014998,0.00188564,0.00492454, _
0.01697259,0.05313374,0.1653185,0.268902,0.6179622,0.7001719,3.256158,4.393645, _
7.396099,6.079999,9.519481,15.89821,22.17982,28.51779,29.64442,25.25576, _
25.44462,23.41463,33.61622,15.70469,31.9226,23.02393,28.85206,13.44058,14.80334, _
9.151345,7.624715,2.225218,1.357193,0.4175642,0.1049688,0.0467616,0.05621218, _
0.02743109,0.05115765,0.03386335,0.04231847,0.03106995,0.07246875,0.03007567, _
0.04634921,0.03669042,0.03623844,0.0312043,0.03114195,0.02431388,0.02358363, _
0.01379769,0.04146919,0.04264152,0.4151103,1.342696,3.194275,3.810175,10.42175, _
14.98756,22.93152,22.85397,24.0309,12.90872,31.65662,23.53046,21.24491,25.49373, _
27.42843,20.41156,27.30136,26.11919,15.16066,10.902,12.72543,5.949667,5.086668, _
1.782985,1.794263,0.7221578,0.4235862,0.1552888,0.07589511,0.02602651, _
0.00872079,0.00240894,3.464115E-04,8.071973E-04,1.902044E-04,6.388478E-05, _
2.296187E-05,7.754632E-06,3.471162E-06,1.607908E-06,5.796203E-07,1.85022E-07, _
8.52654E-08,2.225473E-08,1.3218E-08,3.99671E-09,1.53299E-09,4.4208E-10, _
 3.1312E-10,8.810599E-10,3.076055E-09,7.156005E-09,2.037767E-08,4.278916E-08, _
1.171823E-07,3.281232E-07,7.966954E-07,1.857425E-06,5.027541E-06,1.032171E-05, _
2.95208E-05,8.211235E-05,2.085887E-04,7.374224E-04,9.386301E-04,0.00195792, _
0.00486592,0.01352109,0.02592326,0.04822544,0.07484433,0.09680821,0.2577249, _
0.477894,0.4554369,0.5518248,0.7348701,1.09241,0.8804116,0.8956695,1.29866, _
1.43207,1.236256,0.9225637,1.048891,1.023871,1.323992,1.016166,1.044248, _
0.9998625,1.119608,0.7773815,0.7891133,0.4650758,0.2585391,0.1134749,0.02860608, _
0.01320229,0.012191,0.00830952,0.01220222,0.00992747,0.012115,0.01015104, _
0.00970916,0.01241607,0.00800416,0.00826629,0.00688023,0.00955043,0.00585908, _
0.00741398,0.00576922,0.00406547,0.00912135,0.01495543,0.08297379,0.2534856, _
0.3255126,0.3304597,0.7326755,1.383389,1.014697,0.8374111,1.36246,1.164197, _
1.389319,0.8257977,0.9937682,1.638331,1.161195,1.21526,1.08935,1.258063, _
1.053865,0.8659801,0.7643502,0.5174281,0.4743709,0.2824855,0.1710329,0.1004108, _
0.06279677,0.03125445,0.0172198,0.0074894,0.00246783,0.00103471,1.792949E-04, _
4.74309E-04,9.220401E-05,3.26636E-05,1.211291E-05,4.40371E-06,1.816138E-06, _
7.630628E-07,2.826438E-07,9.985258E-08,4.178949E-08,1.232831E-08,6.390091E-09, _
2.089698E-09,8.051522E-10,2.598076E-10

U235FJEFF33:
Data 57,178, _
 2.3053E-10,6.8325E-10,1.64581E-09,3.775559E-09,8.79378E-09,2.04745E-08, _
4.756842E-08,1.101593E-07,2.554696E-07,5.921222E-07,1.372837E-06,3.18312E-06, _
7.388026E-06,1.717864E-05,4.01007E-05,9.448519E-05,2.271571E-04,3.881444E-04, _
0.0030661,0.00355891,0.00801817,0.02348689,0.05562834,0.09804538,0.1595431, _
0.2793656,0.5811762,1.045981,1.339239,1.978133,2.591111,3.653332,4.557015, _
5.290629,5.454866,5.861457,5.943666,6.332997,6.511812,6.323454,5.995506, _
6.144776,5.925336,6.437855,5.241483,4.449666,3.280969,2.135133,1.28479, _
0.4674516,0.192816,0.08916704,0.04280122,0.0343585,0.03358588,0.02666294, _
0.0344014,0.02428175,0.02676557,0.03580342,0.03834143,0.03969967,0.03395734, _
0.03523781,0.03013041,0.02759851,0.02784202,0.03941929,0.06890398,0.1007389, _
0.305912,0.515536,1.16432,2.158368,3.396518,4.743748,6.651991,7.659518,6.334915, _
6.041893,5.995238,6.457697,6.336044,6.066853,5.917732,5.718416,5.565895, _
5.146583,3.775342,2.890468,2.184797,1.693692,1.078488,0.686085,0.438169, _
0.3122654,0.1536057,0.1138794,0.0278622,0.01817859,0.00191906,0.00195889, _
0.00315677,5.527183E-04,3.077374E-04,1.374156E-04,6.132828E-05,2.693306E-05, _
1.174941E-05,5.110312E-06,2.219761E-06,9.635939E-07,4.182044E-07,1.814553E-07, _
7.874012E-08,3.4096E-08,1.482715E-08,6.41121E-09,2.7758E-09,1.1239E-09, _
4.0492E-10,1.3591E-10, _
 2.3362E-10,5.279E-10,1.108999E-09,2.905598E-09,6.827856E-09,1.236422E-08, _
3.369108E-08,9.028165E-08,1.741084E-07,4.00789E-07,1.095166E-06,2.135332E-06, _
3.924518E-06,1.333568E-05,2.973472E-05,5.998001E-05,1.480574E-04,2.881211E-04, _
0.00161638,0.00149283,0.00202132,0.00562883,0.00958451,0.02092048,0.0287094, _
0.04596491,0.06978147,0.08288455,0.1301096,0.2400602,0.3310178,0.445896, _
0.4634287,0.4536723,0.6506814,0.7567446,0.744189,0.6489069,0.6545062,0.6589681, _
0.6561014,0.7360665,0.6924599,0.5766162,0.637623,0.5203426,0.4054888,0.2710694, _
0.1521999,0.05511844,0.0507486,0.02726807,0.01323906,0.01416736,0.00427989, _
0.00352896,0.00444796,0.00919418,0.00354208,0.00407999,0.00827882,0.01020878, _
0.00838965,0.01056851,0.0089141,0.01510141,0.00738378,0.01179601,0.00899945, _
0.01590068,0.03674172,0.06802371,0.1439569,0.2432339,0.3766416,0.5314466, _
0.6474066,0.5258593,0.7804008,0.7235981,0.7497975,0.6027759,0.6510075,0.6805508, _
0.7505731,0.7217503,0.6287212,0.4075509,0.4240104,0.3397714,0.2761877,0.2071113, _
0.1092079,0.06787489,0.05768198,0.0403497,0.02072742,0.01230569,0.01318814, _
0.00243569,0.00329327,0.00216872,5.093051E-04,5.703912E-04,4.80559E-05, _
9.496429E-05,4.427731E-05,2.229737E-05,8.061916E-06,3.448359E-06,1.767779E-06, _
7.007291E-07,2.813345E-07,1.38908E-07,5.997958E-08,2.23981E-08,1.060818E-08, _
5.250851E-09,1.896571E-09,8.200998E-10,4.1E-10,1.3889E-10

U235HJEFF33:
Data 49,195, _
 0,2.123905E-07,3.403903E-07,5.45328E-07,8.738982E-07,1.40027E-06,2.243512E-06, _
3.594841E-06,5.760036E-06,9.228869E-06,1.47869E-05,1.066161E-04,3.197024E-04, _
4.26048E-04,9.742119E-05,2.132198E-04,1.066162E-04,3.199955E-04,6.510028E-04, _
4.092704E-04,0.00163572,0.00185629,0.0024001,0.00566321,0.01151129,0.01872564, _
0.02585753,0.03993281,0.06783675,0.1207886,0.1925626,0.2891777,0.4021213, _
0.6584129,1.003387,1.423378,1.706091,2.101327,2.486024,3.526266,4.079329, _
4.422334,4.594799,4.970393,5.093129,5.567945,5.093476,4.901135,5.123981, _
5.297053,5.052109,4.602586,4.070809,3.54665,3.120996,2.34461,1.639911,1.804616, _
1.543779,1.382686,1.301629,1.294896,1.19965,0.7302387,1.128147,1.034351, _
0.971317,1.099007,1.088266,1.091355,1.132219,1.156898,1.131818,1.154904,1.23773, _
1.327824,1.547211,1.874563,2.197698,2.147885,1.914627,2.777203,4.138869, _
4.488448,5.630517,5.779127,5.509001,5.209841,5.808566,5.214233,5.029662, _
4.530959,4.454403,4.603084,4.133147,3.158355,2.568394,2.090722,1.66818, _
0.6006133,0.5901241,0.5284861,0.426854,0.3480397,0.2305878,0.1525088,0.08227709, _
0.05213425,0.03573719,0.02127985,0.01273075,0.01061439,0.0050571,0.00326365, _
0.00262278,5.713369E-04,7.271269E-04,2.804487E-04,1.425199E-04,7.428289E-05, _
8.013056E-05,1.347439E-04,2.263108E-05,1.802873E-05,8.133212E-05,8.131624E-05, _
8.133347E-05,2.634874E-06,1.630707E-06,1.004376E-06,6.234914E-07,3.819912E-07, _
2.382018E-07,1.419951E-07,9.0771E-08,5.638604E-08,3.436432E-08,2.1494E-08, _
1.333987E-08,8.194E-09,5.06425E-09,3.114149E-09,1.90144E-09,1.12718E-09, _
6.6392E-10,3.3163E-10,2.69177E-10, _
 0,1.293723E-07,2.519412E-07,3.785375E-07,5.929856E-07,1.045456E-06,1.58995E-06, _
2.347329E-06,4.005965E-06,7.024158E-06,1.000894E-05,7.803211E-05,1.623815E-04, _
2.525632E-04,6.596919E-05,9.136597E-05,7.706381E-05,5.553394E-05,8.746934E-05, _
1.438896E-04,6.736274E-04,8.538518E-04,8.308936E-04,8.006459E-04,0.00162676, _
0.00570303,0.00796807,0.01016702,0.00965176,0.025875,0.03167553,0.05475662, _
0.07002945,0.1045915,0.1480039,0.182237,0.2486425,0.3176561,0.3726836,0.4874661, _
0.4302096,0.492338,0.5860808,0.6820515,0.7298113,0.5912597,0.6161819,0.6183511, _
0.5462403,0.6444655,0.5924203,0.536386,0.5458905,0.4178238,0.3937496,0.2770098, _
0.231167,0.2857866,0.207295,0.1942292,0.1743682,0.1736044,0.1527125,0.09257449, _
0.1388075,0.1361859,0.1136696,0.1341526,0.131942,0.1430967,0.145146,0.1498691, _
0.1406292,0.1399096,0.1514552,0.1641667,0.1828255,0.2253318,0.2605764,0.2076616, _
0.2073657,0.301917,0.4760125,0.4459367,0.5192488,0.6121202,0.6076115,0.587943, _
0.6789252,0.5372705,0.6531149,0.5940859,0.5641751,0.5152819,0.4836211,0.3758329, _
0.3273979,0.2475075,0.2111484,0.06278699,0.08182463,0.07612853,0.06139341, _
0.05338392,0.02884247,0.02751457,0.01745165,0.00715426,0.00876984,0.0081064, _
0.00180493,0.00430643,7.304203E-04,0.00209406,0.00114035,4.377733E-04, _
3.217988E-04,4.058869E-05,7.029482E-05,5.715792E-05,1.089821E-05,4.900675E-05, _
1.662242E-05,2.764856E-06,6.161124E-05,6.328715E-05,4.991929E-05,1.657371E-06, _
1.071147E-06,7.73982E-07,4.113663E-07,2.148924E-07,1.766322E-07,8.94451E-08, _
6.189325E-08,3.511582E-08,1.937978E-08,1.351847E-08,9.263021E-09,6.284937E-09, _
3.452351E-09,1.668026E-09,1.441484E-09,7.101904E-10,4.986828E-10,3.3384E-10, _
1.772028E-10

U235TJEFF33:
Data 56,177, _
 2.3225E-10,5.1945E-10,1.13728E-09,2.51703E-09,5.30853E-09,1.137947E-08, _
2.43531E-08,5.203713E-08,1.108206E-07,2.363779E-07,5.038332E-07,1.074201E-06, _
2.290683E-06,4.888218E-06,1.044473E-05,2.236826E-05,4.816228E-05,1.007655E-04, _
3.425195E-04,8.320034E-04,0.00476552,0.00847428,0.020462,0.04717796,0.1253915, _
0.1933107,0.3229458,0.5515621,0.9956288,1.328949,1.964321,2.534549,3.478271, _
4.761414,5.755258,5.878978,5.999905,6.334958,6.500962,6.556502,6.311886, _
5.948113,5.780801,6.171887,6.259189,5.176692,4.29595,3.11189,1.879444,0.9515135, _
0.4107848,0.1390211,0.0567979,0.028509,0.0247331,0.01966214,0.0117365, _
0.01582418,0.0128013,0.01125835,0.01588625,0.01278945,0.01489288,0.01576193, _
0.01531443,0.01270452,0.01840303,0.0137863,0.02494443,0.03029562,0.05833647, _
0.1242741,0.3337854,0.8136968,1.86645,2.921171,4.318702,6.651164,7.754798, _
6.332393,6.331442,6.234249,6.687513,6.379017,6.352493,5.871677,5.817312, _
5.964535,5.467751,3.980062,2.999718,2.247971,1.690292,1.02904,0.6552069, _
0.4289322,0.2541935,0.1467887,0.0732363,0.03113407,0.01344018,0.00661865, _
0.00195952,0.0010639,4.380766E-04,8.129206E-05,5.944579E-05,2.541265E-05, _
1.076674E-05,4.545071E-06,1.915843E-06,8.069086E-07,3.397432E-07,1.429627E-07, _
6.020747E-08,2.534487E-08,1.06471E-08,4.4181E-09,1.88465E-09,7.3616E-10, _
3.1031E-10,1.089E-10, _
 1.69566E-10,4.334825E-10,8.761056E-10,1.684744E-09,4.046985E-09,8.814408E-09, _
1.450142E-08,3.658037E-08,9.044852E-08,1.602843E-07,3.384591E-07,8.530213E-07, _
1.533226E-06,2.57623E-06,8.052173E-06,1.660204E-05,3.07085E-05,1.751437E-05, _
5.158384E-05,1.113111E-04,7.172434E-04,0.00113451,0.00253072,0.00438468, _
0.01114919,0.02159526,0.0383881,0.06410576,0.06997824,0.1264699,0.2327554, _
0.3227666,0.4298165,0.4812221,0.4888442,0.6933219,0.7765858,0.7860869,0.6599727, _
0.6592156,0.6367806,0.6534613,0.6706402,0.7048351,0.5216777,0.6091672,0.4837001, _
0.3768664,0.2046945,0.1095343,0.04202956,0.0190699,0.00763975,0.00403564, _
0.00344363,0.0024137,0.00137788,0.0018419,0.00161134,0.00146898,0.00139134, _
0.00150851,0.00203349,0.00179434,0.00191651,0.00129227,0.00184048,0.00158, _
0.00302999,0.00321831,0.00701225,0.01387572,0.0235162,0.05754178,0.171478, _
0.3232415,0.4888647,0.6256343,0.4887123,0.7727203,0.7263486,0.7699271,0.5993581, _
0.643276,0.7059568,0.741345,0.729748,0.6683484,0.4265718,0.4347101,0.3457517, _
0.2833084,0.2068929,0.1028487,0.06262807,0.05498349,0.03297429,0.0193537, _
0.00684721,0.00288134,0.00166585,9.561831E-04,3.019499E-04,1.440053E-04, _
3.558138E-04,1.257471E-05,3.993717E-05,1.804852E-05,8.833588E-06,3.095885E-06, _
1.282657E-06,6.393734E-07,2.46227E-07,9.558244E-08,4.566327E-08,1.92681E-08, _
6.958198E-09,3.187808E-09,1.53751E-09,5.348653E-10,2.248501E-10,1.0951E-10

U236FJEFF33:
Data 55,174, _
 1.3637E-10,4.502E-10,8.7807E-10,1.90212E-09,3.99014E-09,8.09098E-09, _
1.65049E-08,3.35061E-08,6.814994E-08,1.384701E-07,2.813873E-07,5.718488E-07, _
1.162132E-06,2.361399E-06,4.798821E-06,9.751904E-06,1.982037E-05,4.028455E-05, _
8.190606E-05,1.502901E-04,7.570274E-04,4.514052E-04,0.00120585,0.00350226, _
0.0135583,0.03612502,0.0777815,0.2049915,0.4299899,0.9191615,1.444244,1.97939, _
2.359389,3.113862,3.437325,4.793411,5.44656,5.873335,5.365511,6.256312,6.525797, _
5.979935,5.561321,5.91357,5.800279,6.399648,5.505822,5.028506,3.847704,3.183614, _
1.939146,0.9332638,0.6169667,0.2611591,0.09193152,0.05933895,0.05988315, _
0.098604,0.0541269,0.09255902,0.09316307,0.1041554,0.09220709,0.0730606, _
0.08574088,0.07804649,0.08257184,0.08072005,0.1002,0.09364484,0.1031933, _
0.2881583,0.3630935,0.5827523,0.9746841,1.980731,3.181977,4.247706,6.869927, _
7.927888,6.43261,5.42911,6.148433,5.752157,6.554742,5.806743,5.442348,5.372136, _
4.727785,4.867939,4.097189,3.602669,2.131303,2.090083,1.64915,1.09823,0.6915373, _
0.5175163,0.227653,0.1381272,0.05549885,0.03092715,0.01230801,0.00503246, _
0.00120595,0.00137525,4.114494E-04,0.00155165,5.430625E-05,1.974362E-05, _
7.175996E-06,2.607824E-06,9.477462E-07,3.443941E-07,1.251571E-07,4.54249E-08, _
1.652868E-08,5.99251E-09,2.17818E-09,7.7116E-10, _
 1.4445E-10,3.398147E-10,7.88248E-10,1.466173E-09,2.980411E-09,6.774608E-09, _
1.257953E-08,2.11902E-08,5.116441E-08,1.17826E-07,2.083989E-07,4.188689E-07, _
9.567335E-07,1.527396E-06,2.776859E-06,8.317093E-06,1.474587E-05,2.82178E-05, _
6.094037E-05,1.275377E-04,6.133971E-04,2.180677E-04,4.521257E-04,0.00142221, _
0.00545738,0.01522569,0.01905503,0.03711162,0.0709377,0.1606337,0.1620877, _
0.283803,0.3600361,0.4617526,0.5005331,0.4395572,0.6231776,0.865512,0.7141657, _
0.7528443,0.8315509,0.6276131,0.6407368,0.7491336,0.7511109,0.5891531,0.6487659, _
0.6323363,0.522334,0.4214343,0.3459375,0.1678635,0.1362524,0.07436613, _
0.03273149,0.02884552,0.00785685,0.04355755,0.01451929,0.02932049,0.02651961, _
0.04749152,0.02166687,0.04421295,0.03298806,0.03843992,0.03215869,0.09472535, _
0.04231576,0.04279469,0.03401357,0.05082957,0.1319323,0.08543818,0.1428235, _
0.2640958,0.4030704,0.5095432,0.8121227,0.6167188,0.770521,0.9595106,0.7841508, _
0.9900932,0.7755013,0.6265026,0.7518911,0.7398535,0.7921403,0.4472857,0.6338874, _
0.404483,0.2763578,0.33283,0.2830126,0.1889638,0.1439047,0.1061191,0.0673527, _
0.04622437,0.0259681,0.00421614,0.00572662,0.00215898,6.362632E-04,0.00122791, _
7.407019E-05,0.00117778,4.328444E-05,1.570216E-05,5.407573E-06,2.056421E-06, _
7.589169E-07,2.421808E-07,9.126158E-08,3.959178E-08,1.204291E-08,4.235492E-09, _
1.762587E-09,6.162028E-10

U236TJEFF33:
Data 59,173, _
3.5746E-10,1.805811E-07,6.158818E-07,1.68181E-06,4.648096E-06,1.261992E-05, _
3.038124E-05,6.295004E-05,1.137407E-04,1.833601E-04,2.693806E-04,3.671154E-04, _
4.70718E-04,5.74293E-04,8.716362E-04,0.00232444,0.00581083,0.01481697, _
0.03849587,0.06281052,0.1262312,0.254079,0.3767618,0.6041067,1.102207,1.713131, _
2.21354,3.088848,4.028058,5.494901,6.51192,6.856503,6.636582,6.634605,7.037884, _
6.949631,6.514054,5.800941,5.576872,5.197011,4.726986,4.363259,3.18609,2.464779, _
1.606705,0.9900873,0.5084617,0.2560002,0.1171096,0.08078231,0.04282335, _
0.04042189,0.02513419,0.01456805,0.0167229,0.01874093,0.0196743,0.0174928, _
0.01519588,0.01570272,0.01600697,0.01772943,0.01868124,0.01975555,0.02084949, _
0.03262122,0.1175124,0.246002,0.4614564,1.013196,1.733719,2.514618,3.599534, _
4.827265,6.031878,6.289126,5.409838,7.131061,6.284158,5.926525,5.686388, _
6.419778,6.278982,6.741114,5.948785,4.69051,3.42929,2.552923,1.824478,1.307897, _
0.7759035,0.4948908,0.3396775,0.2000801,0.1317004,0.04679397,0.02213823, _
0.01149798,0.00718469,0.00441542,9.72242E-04,5.466486E-04,1.210608E-04, _
1.000404E-04,8.08824E-05,6.405247E-05,4.975177E-05,3.794332E-05,2.843848E-05, _
2.093349E-05,1.507583E-05,1.045782E-05,6.697764E-06,3.340194E-06,3.15E-10, _
 2.782751E-10,1.475024E-07,4.509342E-07,1.018043E-06,3.413028E-06,1.032563E-05, _
2.189864E-05,4.512793E-05,9.073309E-05,1.124589E-04,1.523388E-04,3.051299E-04, _
3.377745E-04,3.90487E-04,3.342844E-04,0.00168133,0.00269886,0.00694446, _
0.00531999,0.00880318,0.01388611,0.02220635,0.03681757,0.07808205,0.1443195, _
0.1536053,0.1953968,0.350019,0.5569488,0.7605425,0.8059604,0.5722013,0.7827106, _
0.9151684,0.9629753,0.8405606,0.6794903,0.5502946,0.6693814,0.675533,0.639834, _
0.3796919,0.3801696,0.2953249,0.2144622,0.1197148,0.06670666,0.02562785, _
0.01487452,0.01103527,0.00627812,0.00602893,0.0029757,0.0014151,0.00409441, _
0.00618072,0.00227634,0.00595037,0.00153531,0.00197693,0.00192535,0.0021197, _
0.00238273,0.00204307,0.00575058,0.00388099,0.01406886,0.05079155,0.07322364, _
0.1227338,0.1782182,0.2069321,0.4497388,0.6023873,0.7730207,0.4261524,0.6937382, _
0.9657987,0.8364008,0.6696009,0.6606192,0.5276595,0.8749236,0.9494756,0.8404914, _
0.392332,0.3654792,0.2611448,0.2446913,0.1803884,0.105156,0.038695,0.04382707, _
0.02761598,0.02185657,0.00603491,0.00787707,0.00152318,0.00118685,0.00229087, _
1.560663E-04,4.183325E-04,2.095845E-05,6.824621E-05,6.29033E-05,4.884144E-05, _
3.634765E-05,2.933357E-05,2.192235E-05,1.425756E-05,1.067983E-05,8.823325E-06, _
4.734533E-06,2.298782E-06,3.2017E-10

U238FJEFF33:
Data 60,179, _
 1.051887E-09,2.48698E-09,6.17251E-09,1.473275E-08,3.50591E-08,8.378514E-08, _
1.998153E-07,4.76514E-07,1.136377E-06,2.710026E-06,6.462709E-06,1.541176E-05, _
3.675296E-05,8.764967E-05,2.090095E-04,4.98388E-04,0.00118799,0.00306474, _
0.00505564,0.01530906,0.02635911,0.06025195,0.16257,0.2397073,0.4060601, _
0.8157584,1.150047,1.601237,2.128802,3.063841,3.261671,4.256681,4.357331, _
5.171591,5.151717,5.305458,6.065768,5.728611,5.806638,6.267279,6.552655, _
6.400866,6.298851,6.040959,4.607679,3.730797,2.518251,1.746602,0.4544411, _
0.1617993,0.09161643,0.06432971,0.04563719,0.03185994,0.0326626,0.03821868, _
0.04724227,0.04758631,0.0348994,0.02743552,0.02401781,0.02008577,0.01999917, _
0.01417514,0.02527874,0.02099428,0.09273391,0.1462496,0.3021654,0.6273894, _
1.75681,3.339714,4.773944,6.727655,6.699432,6.560751,6.859819,6.212019,6.019189, _
5.952954,6.004293,5.889742,4.795841,4.690754,4.594838,3.957822,3.584027, _
2.694768,2.292612,1.698154,1.329013,0.8126696,0.565693,0.3628364,0.2420561, _
0.1457298,0.0659136,0.02451943,0.01156474,0.00838817,0.00343982,0.00119554, _
5.38029E-04,2.415681E-04,1.084969E-04,4.875135E-05,2.187884E-05,9.843027E-06, _
4.405818E-06,1.987042E-06,8.712678E-07,4.00645E-07,1.736198E-07,8.04322E-08, _
2.91403E-08,1.595383E-08,6.01133E-09,3.04973E-09,5.7686E-10,4.8874E-10, _
 8.502696E-10,1.876775E-09,3.77441E-09,1.04223E-08,2.882843E-08,6.147559E-08, _
1.405836E-07,3.654129E-07,6.949174E-07,1.521815E-06,5.333525E-06,1.085538E-05, _
2.489803E-05,6.245954E-05,1.615428E-04,3.752272E-04,8.95998E-04,4.897903E-04, _
0.00216677,0.00626898,0.01800641,0.02711687,0.04849995,0.05943968,0.1202291, _
0.1049164,0.1063908,0.1993658,0.2836874,0.3746963,0.3265098,0.4074835,0.4926168, _
0.6575682,0.6526964,0.6040115,0.506045,0.585103,0.7242566,0.7899947,0.6687229, _
0.6944876,0.7064578,0.753875,0.6203347,0.4883441,0.2899429,0.2091977,0.1344863, _
0.02304281,0.0322898,0.00865555,0.00533081,0.00426381,0.01221083,0.00494221, _
0.02046296,0.01628916,0.0210673,0.01016521,0.00622349,0.00284079,0.00731127, _
0.00415414,0.01164461,0.00289501,0.01513333,0.01819092,0.03873723,0.06660976, _
0.164575,0.2986494,0.4742285,0.6765701,0.6469679,0.6442363,0.5937821,0.7722584, _
0.7777807,0.7444481,0.496912,0.608164,0.5416391,0.5765705,0.495574,0.4688378, _
0.2611269,0.3208537,0.2958641,0.2141042,0.151454,0.08625656,0.05762141, _
0.04961267,0.03491535,0.04378334,0.00626502,0.01400686,0.00694344,0.00118164, _
0.00174198,1.395642E-04,4.166392E-04,1.773443E-04,7.348849E-05,3.432527E-05, _
1.820766E-05,7.106228E-06,3.049065E-06,1.521183E-06,6.360934E-07,2.971703E-07, _
1.458154E-07,5.784789E-08,2.344321E-08,1.16814E-08,5.77253E-09,2.433411E-09, _
5.8764E-10,4.9153E-10

U238HJEFF33:
Data 50,195, _
 3.77044E-09,6.86429E-09,1.22887E-08,2.217968E-08,3.983541E-08,7.162871E-08, _
1.288045E-07,2.315764E-07,4.161431E-07,7.481929E-07,1.344958E-06,2.417594E-06, _ 
4.346402E-06,8.612106E-05,8.609008E-05,2.618559E-04,8.549239E-05,1.409297E-04, _
2.580083E-04,3.013549E-04,6.997406E-04,0.00120875,0.00302998,0.00550381, _
0.01047316,0.02286815,0.03034764,0.03250568,0.04185184,0.09299306,0.1821476, _
0.3228179,0.4880722,0.7168717,1.243715,1.051341,1.729027,1.827596,2.005329, _
2.780773,3.226384,3.708118,3.803765,4.343165,4.826836,4.722155,5.149441, _
5.173667,5.264461,5.82567,6.04252,5.805097,3.997745,4.492142,3.569793,3.124454, _
2.506907,1.724129,1.541954,1.334169,1.162929,0.9760933,1.029166,0.9171933, _
0.8551675,0.9008799,0.6900313,0.6956491,1.108622,1.011849,1.012766,1.06274, _
1.078699,1.09443,1.190032,1.282641,1.357127,1.445646,1.671845,1.707287,2.558658, _
3.649088,4.716316,5.760409,6.330163,5.501104,5.915123,5.60691,4.663318,5.018991, _
4.649586,4.433963,4.182329,3.890141,3.58473,3.015826,2.62796,2.152867,1.472929, _
1.405856,1.202177,0.8328269,0.6394266,0.4021879,0.3051567,0.1758389,0.114752, _
0.06374436,0.04364778,0.02577281,0.01214074,0.0081356,0.0049485,0.00330049, _
0.00246387,0.00154408,6.33214E-04,8.974108E-04,1.592842E-04,1.29725E-04, _
7.676486E-05,4.608835E-05,2.737952E-05,1.646871E-05,9.550138E-06,5.865912E-06, _
3.350345E-06,2.072783E-06,1.035462E-06,7.269298E-07,3.659321E-07,2.43119E-07, _
8.1007E-08,8.195936E-08,5.383013E-08,2.28855E-08,1.874591E-08,1.183207E-08, _
7.2169E-09,4.0385E-09,2.55196E-09,1.31883E-09,8.6479E-10,3.7901E-10,2.9541E-10, _
1.0001E-10, _
 2.803891E-09,4.853886E-09,7.978728E-09,1.54057E-08,3.034743E-08,4.829245E-08, _
8.739063E-08,1.711346E-07,2.808943E-07,5.040361E-07,1.023212E-06,1.672302E-06, _
2.640671E-06,6.093244E-05,5.538954E-05,1.77197E-04,1.339966E-05,3.282153E-05, _
1.101965E-04,9.346199E-05,2.697521E-04,5.862757E-04,4.988025E-04,9.301707E-04, _
0.00405879,0.00559676,0.00725297,0.00455569,0.00633796,0.01617771,0.02999406, _
0.0457505,0.07038927,0.08719769,0.1295184,0.1193613,0.1918667,0.2336633, _
0.2719134,0.354023,0.3394037,0.4266139,0.4775201,0.536169,0.6785613,0.5605063, _
0.5252994,0.5505071,0.6906433,0.7184428,0.6448261,0.6875278,0.5072731,0.5354146, _
0.3941574,0.3951476,0.2929322,0.2382033,0.2115993,0.1687247,0.1606727,0.1282757, _
0.1126053,0.1044841,0.1143842,0.1043213,0.1317349,0.1126189,0.13193,0.1247478, _
0.1288244,0.149332,0.1395908,0.1638636,0.1426078,0.1376809,0.1627692,0.16355, _
0.1693508,0.1787123,0.2521335,0.4025745,0.5242067,0.6184238,0.5858987,0.6743617, _
0.6970397,0.683744,0.4963206,0.6093155,0.5390877,0.5482325,0.5331573,0.4842487, _
0.3486164,0.3638602,0.3128747,0.2637832,0.1942266,0.1756973,0.1379523,0.1075525, _
0.08753737,0.0529933,0.04502019,0.02768027,0.01486938,0.01464023,0.00926019, _
0.00400329,0.0059939,0.0011989,0.00194906,0.00135527,0.00116689,5.958712E-04, _
8.613337E-05,4.619617E-04,1.184828E-04,1.955703E-05,5.966047E-05,3.135112E-05, _
1.811576E-05,1.206331E-05,6.972441E-06,3.97633E-06,2.58327E-06,1.499101E-06, _
7.786966E-07,5.155326E-07,3.308548E-07,1.782423E-07,7.207561E-08,6.900126E-08, _
3.434169E-08,1.966162E-08,1.535328E-08,8.432576E-09,4.685111E-09,3.04889E-09, _
1.527625E-09,1.015624E-09,6.408856E-10,3.8275E-10,2.149658E-10,1.016E-10


' ******* LOHENGRIN DATA ****************
'
' Djebara et al. Nucl. Phys. A 496 (1989) 346, Hentzschel et al., Nucl. Phys. A 571 (1994) 427
CF249TLOHENGRIN:
Data 69,120, _
5.6E-6,2.96E-5,5.24E-5,1.07E-4,2.08E-4,5.21E-4,9.34E-4,1.82E-3,4.51E-3,7.98E-3,1.80E-2, _
2.95E-2,4.69E-2,7.21E-2,1.19E-1,1.85E-1,2.42E-1,3.36E-1,4.12E-1, _
0.52,0.61,0.78,0.96,1.14,1.36,1.62,1.72,1.93,2.26,2.65,3.10,3.34,3.79,4.42, _
4.91,5.24,5.37,5.58,5.58,5.74,5.61,5.18,5.05,4.68,4.15,3.54,2.92,2.27,1.67,1.14,0.74,0.44, _
2.2E-6,7.4E-6,1.3E-5,2.3E-5,5.6E-5,8.7E-5,1.7E-4,1.5E-4,5.5E-4,2.3E-4,1.4E-3, _
1.5E-3,1.3E-3,1.6E-3,2.9E-3,3.9E-3,5.9E-3,1.9E-2,7.8E-3,1.2E-2, _
0.02,0.01,0.02,0.02,0.03,0.04,0.04,0.04,0.05,0.05,0.09,0.08,0.10,0.15,0.25, _
0.20,0.23,0.17,0.15,0.19,0.17,0.19,0.23,0.14,0.11,0.12,0.11,0.07,0.06,0.05,0.04,0.01,0.02

' Data from E. Birgersson et al, Nucl. Phys. A 791 (2007) 1-23
CF251TLOHENGRIN:
Data 80,124, _
 0.028,0.051,0.076,0.147,0.17,0.29,0.34,0.51,0.51,0.61,0.75,0.87,1,1.36,1.6,1.9, _
2,2.3,2.1,2.2,3,3.5,3.4,4.3,4.6,4.6,4.7,4,4.4,4.7,4.9,6,4.6,4.4,4,3.7,3.9,2.5,2, _
1.5,1,0.61,0.43,0.27,0.29, _
 0.002,0.004,0.005,0.01,0.02,0.02,0.03,0.04,0.03,0.04,0.05,0.06,0.07,0.09,0.1, _
0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.2,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3,0.3, _
0.2,0.2,0.2,0.2,0.1,0.1,0.1,0.03,0.04,0.02,0.04

' Data from Martinez et al., Nucl. Phys. A 515 (1990) 433
' and Tsekhanovich et al., Nucl. Phys. A 688 (2001) 633
NP238TLOHENGRIN:
Data 74,110, _
 5.6E-04,0.00154,0.00394,0.00944,0.0161,0.0379,0.0822,0.1351,0.206,0.492,0.459, _
0.91,1.12,1.38,1.89,2.27,3.03,3.46,4.09,4.64,5.09,5.3,5.45,5.8,5.76,6.35,6.52, _
6.53,6.54,6.4,5.66,4.45,3.26,1.98,1.16,0.62,0.31, _
 1.6E-04,1.4E-04,4.2E-04,6.1E-04,0.0011,0.0024,0.005,0.0086,0.014,0.043,0.027, _
0.05,0.06,0.07,0.09,0.1,0.14,0.16,0.19,0.21,0.23,0.24,0.25,0.26,0.26,0.28, _
0.28,0.29,0.3,0.29,0.27,0.21,0.16,0.1,0.06,0.04,0.02

' Data from C. Schmitt et al. Nucl. Phys. A 430 (1984) 21-60
PU239TLOHENGRIN:
Data 80,113, _
 0.113,0.153,0.211,0.377,0.563,0.687,0.765,1.02,1.49,1.76,2.23,2.58,3.13,3.91, _
4.56,4.9,5.02,5.42,5.44,6.08,6.47,6.34,6.69,6.71,6.71,5.53,4.44,2.82,1.88,1.04, _
0.573,0.224,0.111,0.075, _
0.01,0.01,0.011,0.018,0.024,0.023,0.02,0.01,0.04,0.03,0.04,0.04,0.04,0.05,0.06, _
0.06,0.06,0.06,0.06,0.08,0.08,0.08,0.08,0.09,0.09,0.08,0.07,0.07,0.04,0.03,0.031, _
0.01,0.008,0.024

' Data from J. P. Bocquet et al. Z. Phys. A 335 (1990) 41-48
TH229TLOHENGRIN:
Data 78,100, _
 0.11,0.35,1.66,2.33,3.29,5.46,9.41,9.75,7.7,7.71,8.73,9.1,8.28,6.16,5.47,5.23, _
3.91,2.44,1.43,0.78,0.38,0.18,0.14, _
 0.05,0.05,0.07,0.08,0.1,0.17,0.23,0.28,0.21,0.23,0.32,0.28,0.38,0.2,0.2,0.31, _
0.25,0.14,0.05,0.05,0.05,0.05,0.05

' Data from U. Quade et al., Nucl. Phys. A 487 (1988) 1-36
U233TLOHENGRIN:
Data 79,106, _
 0.12,0.29,0.39,0.61,1.13,1.76,2.24,3.21,4.02,5.38,6.67,6.99,6.45,6.56,7.06, _
6.86,6.5,5.67,5.38,5.11,4.5,4.27,3.07,2.47,1.51,1,0.53,0.27, _
 0.02,0.03,0.03,0.04,0.05,0.06,0.07,0.1,0.1,0.11,0.13,0.12,0.11,0.11,0.11,0.11,0.1, _
0.1,0.1,0.1,0.09,0.09,0.08,0.07,0.05,0.04,0.04,0.02

' Data from * W. Lang et al., Nucl. Phys. A345 (1980) 34-71 and
' J. L. Sida et al. Nucl. Phys. A 502 (1989) 233c-242c 
' When no uncertainties were given, e.g. by Sida at al., they were set to 50%.
U235TLOHENGRIN:
Data 69,110, _
 2.334435E-06,1.232847E-05,1.194738E-05,2.538315E-05,1.258925E-04,7.079458E-04, _
0.00145759,0.00528113,0.0074598,0.01854308,0.04466836,0.115,0.202,0.335,0.627, _
0.974,1.43,1.93,2.45,3.45,4.78,5.9,5.92,5.91,6.21,6.66,6.57,6.32,5.79,5.72,6.35, _
6.12,4.99,4.56,3.08,1.9,0.972,0.439,0.11,0.057,0.016,0.024, _
 1.17E-06,0.62E-05,0.6E-05,1.25E-05,0.63E-04,3.5E-04, _
 0.00073,0.0027,0.0038,0.0093,0.023,_
 0.016,0.021,0.019,0.028,0.033,0.04,0.05,0.06,0.07,0.09,0.11, _
0.11,0.11,0.12,0.12,0.12,0.12,0.11,0.14,0.12,0.12,0.1,0.09,0.07,0.05,0.036,0.022,0.016, _
0.007,0.008,0.005
