' Developed for the GEF code (KHS, 29. 5. 2012, 9. 7. 2013)

'Dim BEexp(0 To 203, 0 To 136) As Single  (Declared in GEF.BAS.)

Scope
  Dim As Integer Z,A
  Dim As Integer I,J
  
  For I = 0 To 203
    For J = 0 To 136
      BEexp(I,J) = -1.E11
    Next
  Next    
 
  Z = 0
  Restore BEexpdata
  Do Until Z < 0
    Read Z,A
    If Z >=0 Then
      Read BEexp(A-Z,Z)
   '  Print Z,A, BEexptab(A-Z,Z)
    End If
  Loop

' Write table for SATAN analyzer BEexp2012.dmp
/' Dim As Integer F2012 = Freefile
Open "BEexp2012.dmp" For Output As #F2012 
For I = 0 To 203
  For J = 0 To 136
    Print #F2012,BEexp(I,J)
  Next
Next     
Close #F2012 '/

End Scope
  
  

BEexpdata:

' This table was produced from the 2012 Mass evaluation.
' It contains experimental masses and systematic estimations.
' See kh/Dokumente/Literature/Full-Text-Special/Masses-2012/MakeTable.jbas.

Data 0, 1, 0, _
0, 1, 0.4e-7, _
1, 1, 0.9e-7, _
1, 2, -2.22456586, _
1, 3, -8.48179859, _
2, 3, -7.71804259, _
3, 3, 6.8000885, _
1, 4, -6.8817988, _
2, 4, -28.2956596, _
3, 4, -4.6150426, _
1, 5, -6.6817989, _
2, 5, -27.5606593, _
3, 5, -26.3306597, _
4, 5, -0.0881991, _
1, 6, -5.769839, _
2, 6, -29.2711144, _
3, 6, -31.9939839, _
4, 6, -26.9234822, _
5, 6, 2.8038304, _
1, 7, -6.5818731, _
2, 7, -28.8614005, _
3, 7, -39.2450747, _
4, 7, -37.6008343, _
5, 7, -24.9109367, _
2, 8, -31.3961626, _
3, 8, -41.277693, _
4, 8, -56.4994794, _
5, 8, -37.7372268, _
6, 8, -24.8121882, _
2, 9, -30.1412647, _
3, 9, -45.3399121, _
4, 9, -58.1640145, _
5, 9, -56.3136329, _
6, 9, -39.0368043, _
2, 10, -29.9761618, _
3, 10, -45.3135072, _
4, 10, -64.9762966, _
5, 10, -64.750748, _
6, 10, -60.3203364, _
7, 10, -36.4366378, _
3, 11, -45.7091943, _
4, 11, -65.4779347, _
5, 11, -76.2048721, _
6, 11, -73.4401135, _
7, 11, -59.0044199, _
3, 12, -45.5891944, _
4, 12, -68.6486598, _
5, 12, -79.5746562, _
6, 12, -92.1617256, _
7, 12, -74.041307, _
8, 12, -58.6823364, _
3, 13, -44.2391945, _
4, 13, -68.1386599, _
5, 13, -84.4532703, _
6, 13, -97.108034, _
7, 13, -94.1052151, _
8, 13, -75.5529105, _
4, 14, -69.914555, _
5, 14, -85.4230214, _
6, 14, -105.284467, _
7, 14, -104.658597, _
8, 14, -98.7322096, _
9, 14, -73.99291, _
4, 15, -68.1803701, _
5, 15, -88.2000355, _
6, 15, -106.502533, _
7, 15, -115.491892, _
8, 15, -111.955379, _
9, 15, -97.2218271, _
4, 16, -68.5645552, _
5, 16, -88.1170696, _
6, 16, -110.752866, _
7, 16, -117.98074, _
8, 16, -127.619302, _
9, 16, -111.4197, _
10, 16, -97.3314536, _
5, 17, -89.5298417, _
6, 17, -111.487533, _
7, 17, -123.86589, _
8, 17, -131.762382, _
9, 17, -128.21957, _
10, 17, -112.888474, _
5, 18, -89.5248418, _
6, 18, -115.671504, _
7, 18, -126.694114, _
8, 18, -139.807751, _
9, 18, -137.369475, _
10, 18, -132.142619, _
11, 18, -111.640964, _
5, 19, -90.6662919, _
6, 19, -116.248333, _
7, 19, -132.023078, _
8, 19, -143.763394, _
9, 19, -147.80135, _
10, 19, -143.779505, _
11, 19, -131.819821, _
12, 19, -112.138474, _
5, 20, -90.381609, _
6, 20, -119.174652, _
7, 20, -134.184806, _
8, 20, -151.371401, _
9, 20, -154.402686, _
10, 20, -160.644807, _
11, 20, -145.969925, _
12, 20, -134.479516, _
5, 21, -89.8649261, _
6, 21, -119.16058, _
7, 21, -138.770069, _
8, 21, -155.176979, _
9, 21, -162.504149, _
10, 21, -167.405969, _
11, 21, -163.076483, _
12, 21, -149.195985, _
13, 21, -132.337153, _
6, 22, -119.284653, _
7, 22, -140.053875, _
8, 22, -162.026881, _
9, 22, -167.73448, _
10, 22, -177.770224, _
11, 22, -174.144682, _
12, 22, -168.580756, _
13, 22, -149.19747, _
14, 22, -133.278124, _
6, 23, -116.775214, _
7, 23, -141.841867, _
8, 23, -164.760863, _
9, 23, -175.286132, _
10, 23, -182.970871, _
11, 23, -186.564333, _
12, 23, -181.725398, _
13, 23, -168.721718, _
14, 23, -150.990441, _
7, 24, -141.297184, _
8, 24, -168.952436, _
9, 24, -179.110964, _
10, 24, -191.839785, _
11, 24, -193.523756, _
12, 24, -198.25702, _
13, 24, -183.588719, _
14, 24, -172.014405, _
15, 24, -148.656411, _
7, 25, -140.323501, _
8, 25, -168.176436, _
9, 25, -183.378299, _
10, 25, -196.019268, _
11, 25, -202.534932, _
12, 25, -205.587539, _
13, 25, -200.528587, _
14, 25, -187.002744, _
15, 25, -170.309729, _
8, 26, -168.862435, _
9, 26, -184.148064, _
10, 26, -201.551334, _
11, 26, -208.109212, _
12, 26, -216.680631, _
13, 26, -211.893851, _
14, 26, -206.042369, _
15, 26, -187.146046, _
16, 26, -170.257699, _
8, 27, -167.215789, _
9, 27, -186.254809, _
10, 27, -203.066272, _
11, 27, -214.837425, _
12, 27, -223.124016, _
13, 27, -224.951803, _
14, 27, -219.357098, _
15, 27, -206.912824, _
16, 27, -188.380016, _
8, 28, -167.658106, _
9, 28, -186.034809, _
10, 28, -206.881844, _
11, 28, -218.379381, _
12, 28, -231.62745, _
13, 28, -232.676903, _
14, 28, -236.536821, _
15, 28, -221.40942, _
16, 28, -209.406128, _
17, 28, -185.180987, _
9, 29, -187.401077, _
10, 29, -207.844929, _
11, 29, -222.782407, _
12, 29, -235.282866, _
13, 29, -242.102352, _
14, 29, -245.010422, _
15, 29, -239.285448, _
16, 29, -224.707058, _
17, 29, -207.001304, _
9, 30, -186.986394, _
10, 30, -211.276474, _
11, 30, -225.05903, _
12, 30, -241.635081, _
13, 30, -247.841459, _
14, 30, -255.619622, _
15, 30, -250.604922, _
16, 30, -243.680974, _
17, 30, -224.396621, _
18, 30, -206.567274, _
9, 31, -187.551711, _
10, 31, -211.567022, _
11, 31, -229.344083, _
12, 31, -243.945008, _
13, 31, -254.9953, _
14, 31, -262.207014, _
15, 31, -262.916172, _
16, 31, -256.73581, _
17, 31, -243.977062, _
18, 31, -224.834591, _
10, 32, -213.459681, _
11, 32, -230.866677, _
12, 32, -249.722795, _
13, 32, -259.210169, _
14, 32, -271.406981, _
15, 32, -270.851822, _
16, 32, -271.780135, _
17, 32, -258.316929, _
18, 32, -246.400259, _
19, 32, -222.319562, _
10, 33, -212.532998, _
11, 33, -233.780652, _
12, 33, -252.003101, _
13, 33, -264.651192, _
14, 33, -275.914938, _
15, 33, -280.955611, _
16, 33, -280.421773, _
17, 33, -274.056909, _
18, 33, -261.655519, _
19, 33, -244.446879, _
10, 34, -213.759315, _
11, 34, -234.529969, _
12, 34, -256.713275, _
13, 34, -267.323177, _
14, 34, -283.428658, _
15, 34, -287.23828, _
16, 34, -291.838929, _
17, 34, -285.564976, _
18, 34, -278.720836, _
19, 34, -260.780196, _
20, 34, -244.926849, _
11, 35, -236.050286, _
12, 35, -257.468155, _
13, 35, -272.545426, _
14, 35, -285.903645, _
15, 35, -295.618691, _
16, 35, -298.82477, _
17, 35, -298.209746, _
18, 35, -291.46127, _
19, 35, -278.804404, _
20, 35, -262.061167, _
11, 36, -236.049603, _
12, 36, -260.799099, _
13, 36, -274.446526, _
14, 36, -292.007886, _
15, 36, -299.083245, _
16, 36, -308.713994, _
17, 36, -306.78954, _
18, 36, -306.716717, _
19, 36, -293.119895, _
20, 36, -281.371634, _
21, 36, -258.787137, _
11, 37, -236.88992, _
12, 37, -260.961573, _
13, 37, -278.658664, _
14, 37, -294.280167, _
15, 37, -305.899639, _
16, 37, -313.017597, _
17, 37, -317.100362, _
18, 37, -315.504142, _
19, 37, -308.574346, _
20, 37, -296.127867, _
21, 37, -278.725454, _
12, 38, -263.247891, _
13, 38, -280.329685, _
14, 38, -299.927496, _
15, 38, -309.644407, _
16, 38, -321.053691, _
17, 38, -323.208245, _
18, 38, -327.342631, _
19, 38, -320.646218, _
20, 38, -313.121618, _
21, 38, -294.826771, _
22, 38, -278.832425, _
12, 39, -263.118208, _
13, 39, -283.614861, _
14, 39, -301.508162, _
15, 39, -315.875441, _
16, 39, -325.426167, _
17, 39, -331.281667, _
18, 39, -333.941318, _
19, 39, -333.723972, _
20, 39, -326.417137, _
21, 39, -312.524798, _
22, 39, -295.371742, _
12, 40, -264.859525, _
13, 40, -284.709178, _
14, 40, -306.470153, _
15, 40, -319.19191, _
16, 40, -333.172984, _
17, 40, -337.110605, _
18, 40, -343.81034, _
19, 40, -341.523591, _
20, 40, -342.052138, _
21, 40, -326.946741, _
22, 40, -314.491445, _
23, 40, -292.972712, _
13, 41, -286.865495, _
14, 41, -307.851481, _
15, 41, -324.168569, _
16, 41, -337.415032, _
17, 41, -344.931298, _
18, 41, -349.909267, _
19, 41, -351.618959, _
20, 41, -350.414956, _
21, 41, -343.137134, _
22, 41, -329.409913, _
23, 41, -312.734029, _
13, 42, -287.987812, _
14, 42, -311.480466, _
15, 42, -326.25038, _
16, 42, -344.115519, _
17, 42, -350.608416, _
18, 42, -359.335754, _
19, 42, -359.152759, _
20, 42, -361.895629, _
21, 42, -354.687183, _
22, 42, -346.888356, _
23, 42, -328.621346, _
24, 42, -313.978, _
13, 43, -288.95213, _
14, 43, -313.012783, _
15, 43, -330.65161, _
16, 43, -346.744549, _
17, 43, -358.08937, _
18, 43, -364.994205, _
19, 43, -368.777439, _
20, 43, -369.828518, _
21, 43, -366.825457, _
22, 43, -359.176094, _
23, 43, -346.98902, _
24, 43, -330.591317, _
14, 44, -315.6721, _
15, 44, -332.960753, _
16, 44, -351.824641, _
17, 44, -362.44779, _
18, 44, -373.728969, _
19, 44, -376.054859, _
20, 44, -380.959678, _
21, 44, -376.524652, _
22, 44, -375.474897, _
23, 44, -361.260361, _
24, 44, -349.998634, _
25, 44, -328.919287, _
14, 45, -315.043417, _
15, 45, -336.151071, _
16, 45, -354.681313, _
17, 45, -368.269124, _
18, 45, -378.897827, _
19, 45, -384.960322, _
20, 45, -388.37449, _
21, 45, -387.851168, _
22, 45, -385.006765, _
23, 45, -377.095847, _
24, 45, -363.94775, _
25, 45, -348.783605, _
26, 45, -329.437258, _
15, 46, -336.761388, _
16, 46, -358.726041, _
17, 46, -371.791024, _
18, 46, -386.92911, _
19, 46, -391.829925, _
20, 46, -398.772051, _
21, 46, -396.611807, _
22, 46, -398.195957, _
23, 46, -390.361217, _
24, 46, -381.977799, _
25, 46, -364.678922, _
26, 46, -350.352575, _
15, 47, -338.376705, _
16, 47, -359.429358, _
17, 47, -376.149012, _
18, 47, -390.480676, _
19, 47, -400.199294, _
20, 47, -406.048425, _
21, 47, -407.258255, _
22, 47, -407.076679, _
23, 47, -403.363733, _
24, 47, -395.136472, _
25, 47, -382.358681, _
26, 47, -366.602892, _
27, 47, -348.382545, _
16, 48, -362.144675, _
17, 48, -378.184329, _
18, 48, -395.780982, _
19, 48, -404.843112, _
20, 48, -416.001048, _
21, 48, -415.497362, _
22, 48, -418.70333, _
23, 48, -413.906017, _
24, 48, -411.468556, _
25, 48, -397.187987, _
26, 48, -385.498209, _
27, 48, -365.433863, _
28, 48, -349.040516, _
16, 49, -361.773992, _
17, 49, -381.048646, _
18, 49, -398.272299, _
19, 49, -410.241444, _
20, 49, -421.147501, _
21, 49, -425.626332, _
22, 49, -426.845722, _
23, 49, -425.461519, _
24, 49, -422.050913, _
25, 49, -413.572611, _
26, 49, -399.904253, _
27, 49, -384.70118, _
28, 49, -366.415833, _
17, 50, -381.835963, _
18, 50, -402.403616, _
19, 50, -414.429118, _
20, 50, -427.508147, _
21, 50, -431.68409, _
22, 50, -437.784911, _
23, 50, -434.795739, _
24, 50, -435.051246, _
25, 50, -426.634422, _
26, 50, -417.713474, _
27, 50, -400.224497, _
28, 50, -386.56015, _
17, 51, -383.86228, _
18, 51, -403.422933, _
19, 51, -419.288626, _
20, 51, -432.328769, _
21, 51, -438.436708, _
22, 51, -444.157405, _
23, 51, -445.846885, _
24, 51, -444.311908, _
25, 51, -440.322002, _
26, 51, -431.498491, _
27, 51, -417.855957, _
28, 51, -402.669467, _
18, 52, -406.59525, _
19, 52, -421.386904, _
20, 52, -438.324566, _
21, 52, -443.445717, _
22, 52, -451.965709, _
23, 52, -453.158129, _
24, 52, -456.35026, _
25, 52, -450.856678, _
26, 52, -447.699771, _
27, 52, -432.575131, _
28, 52, -421.276784, _
29, 52, -400.085438, _
18, 53, -406.906567, _
19, 53, -424.596221, _
20, 53, -440.589874, _
21, 53, -449.457948, _
22, 53, -457.398172, _
23, 53, -461.635826, _
24, 53, -464.289382, _
25, 53, -462.910186, _
26, 53, -458.385529, _
27, 53, -449.315075, _
28, 53, -435.504926, _
29, 53, -419.445755, _
19, 54, -425.988538, _
20, 54, -444.982191, _
21, 54, -453.020834, _
22, 54, -464.236551, _
23, 54, -467.749259, _
24, 54, -474.008502, _
25, 54, -471.848982, _
26, 54, -471.763979, _
27, 54, -462.737085, _
28, 54, -453.168336, _
29, 54, -434.904072, _
30, 54, -419.796725, _
19, 55, -428.349855, _
20, 55, -446.625509, _
21, 55, -457.469671, _
22, 55, -468.378345, _
23, 55, -475.072089, _
24, 55, -480.254765, _
25, 55, -482.075501, _
26, 55, -481.062066, _
27, 55, -476.82834, _
28, 55, -467.35196, _
29, 55, -452.869788, _
30, 55, -435.375043, _
19, 56, -429.202172, _
20, 56, -450.244826, _
21, 56, -460.295479, _
22, 56, -473.987454, _
23, 56, -480.122888, _
24, 56, -488.498684, _
25, 56, -489.345938, _
26, 56, -492.259168, _
27, 56, -486.910197, _
28, 56, -483.994962, _
29, 56, -467.543706, _
30, 56, -454.10236, _
31, 56, -432.063013, _
20, 57, -451.292143, _
21, 57, -464.342796, _
22, 57, -476.721057, _
23, 57, -486.299492, _
24, 57, -493.812895, _
25, 57, -497.992541, _
26, 57, -499.905243, _
27, 57, -498.286665, _
28, 57, -494.242589, _
29, 57, -484.685276, _
30, 57, -469.140677, _
31, 57, -451.46133, _
20, 58, -454.40846, _
21, 58, -466.583113, _
22, 58, -482.036767, _
23, 58, -490.461919, _
24, 58, -501.194799, _
25, 58, -504.405287, _
26, 58, -509.949847, _
27, 58, -506.859592, _
28, 58, -506.45884, _
29, 58, -497.115474, _
30, 58, -486.964147, _
31, 58, -467.375647, _
32, 58, -450.814301, _
21, 59, -470.08043, _
22, 59, -484.640084, _
23, 59, -496.045752, _
24, 59, -505.322881, _
25, 59, -512.174364, _
26, 59, -516.530861, _
27, 59, -517.31347, _
28, 59, -515.458122, _
29, 59, -509.87739, _
30, 59, -499.952266, _
31, 59, -485.926964, _
32, 59, -467.482618, _
21, 60, -471.901747, _
22, 60, -489.395401, _
23, 60, -499.52701, _
24, 60, -512.006584, _
25, 60, -517.688299, _
26, 60, -525.350389, _
27, 60, -524.805388, _
28, 60, -526.845854, _
29, 60, -519.935526, _
30, 60, -514.98236, _
31, 60, -499.810281, _
32, 60, -486.852935, _
33, 60, -464.162588, _
21, 61, -474.990065, _
22, 61, -491.486718, _
23, 61, -504.8628, _
24, 61, -516.029114, _
25, 61, -524.5338, _
26, 61, -530.929826, _
27, 61, -534.124608, _
28, 61, -534.66596, _
29, 61, -531.646126, _
30, 61, -525.228636, _
31, 61, -515.232141, _
32, 61, -501.044252, _
33, 61, -484.119905, _
22, 62, -495.776035, _
23, 62, -507.903688, _
24, 62, -522.540303, _
25, 62, -529.343995, _
26, 62, -538.958697, _
27, 62, -540.722126, _
28, 62, -545.261818, _
29, 62, -540.520575, _
30, 62, -538.118774, _
31, 62, -528.155362, _
32, 62, -517.285569, _
33, 62, -499.186222, _
22, 63, -497.103352, _
23, 63, -512.492006, _
24, 63, -525.438773, _
25, 63, -535.821365, _
26, 63, -543.787587, _
27, 63, -549.220618, _
28, 63, -552.099594, _
29, 63, -551.384224, _
30, 63, -547.23569, _
31, 63, -540.787325, _
32, 63, -530.379102, _
33, 63, -516.30254, _
23, 64, -514.741323, _
24, 64, -531.246976, _
25, 64, -539.994663, _
26, 64, -551.192827, _
27, 64, -555.232824, _
28, 64, -561.757068, _
29, 64, -559.300337, _
30, 64, -559.097685, _
31, 64, -551.144301, _
32, 64, -545.844699, _
33, 64, -530.398857, _
34, 64, -516.89351, _
23, 65, -518.28564, _
24, 65, -533.841293, _
25, 65, -546.044285, _
26, 65, -555.516092, _
27, 65, -562.697451, _
28, 65, -567.855149, _
29, 65, -569.211017, _
30, 65, -567.077012, _
31, 65, -563.040195, _
32, 65, -556.078736, _
33, 65, -545.755225, _
34, 65, -531.196827, _
23, 66, -520.320957, _
24, 66, -538.46661, _
25, 66, -549.898651, _
26, 66, -562.433757, _
27, 66, -567.992103, _
28, 66, -576.807509, _
29, 66, -576.276947, _
30, 66, -578.135593, _
31, 66, -572.178246, _
32, 66, -569.27887, _
33, 66, -558.914568, _
34, 66, -547.475144, _
24, 67, -540.482927, _
25, 67, -554.529581, _
26, 67, -566.505764, _
27, 67, -574.976663, _
28, 67, -582.615221, _
29, 67, -585.408973, _
30, 67, -585.187915, _
31, 67, -583.404397, _
32, 67, -578.401159, _
33, 67, -571.548033, _
34, 67, -560.75875, _
35, 67, -546.324115, _
24, 68, -544.949244, _
25, 68, -557.589898, _
26, 68, -572.3339, _
27, 68, -579.649926, _
28, 68, -590.407672, _
29, 68, -591.728545, _
30, 68, -595.386011, _
31, 68, -591.682564, _
32, 68, -590.793261, _
33, 68, -581.926644, _
34, 68, -576.439219, _
35, 68, -559.908432, _
25, 69, -561.898215, _
26, 69, -575.637868, _
27, 69, -585.966607, _
28, 69, -594.993823, _
29, 69, -599.969041, _
30, 69, -601.868081, _
31, 69, -601.995934, _
32, 69, -598.986443, _
33, 69, -594.215605, _
34, 69, -586.755802, _
35, 69, -575.65022, _
36, 69, -561.191402, _
25, 70, -564.650532, _
26, 70, -580.961185, _
27, 70, -590.788192, _
28, 70, -602.300352, _
29, 70, -605.280518, _
30, 70, -611.086508, _
31, 70, -609.649583, _
32, 70, -610.518941, _
33, 70, -603.516594, _
34, 70, -600.322304, _
35, 70, -589.035686, _
36, 70, -577.775719, _
25, 71, -568.706849, _
26, 71, -583.722502, _
27, 71, -596.310081, _
28, 71, -606.564037, _
29, 71, -613.086589, _
30, 71, -616.921891, _
31, 71, -618.949867, _
32, 71, -617.93488, _
33, 71, -615.139133, _
34, 71, -609.610237, _
35, 71, -602.183801, _
36, 71, -591.226242, _
37, 71, -576.42069, _
26, 72, -588.89682, _
27, 72, -599.795473, _
28, 72, -613.455187, _
29, 72, -618.229778, _
30, 72, -625.809919, _
31, 72, -625.470343, _
32, 72, -628.685641, _
33, 72, -623.547191, _
34, 72, -622.403227, _
35, 72, -612.820021, _
36, 72, -606.910929, _
37, 72, -590.305007, _
26, 73, -591.482137, _
27, 73, -604.97879, _
28, 73, -617.408596, _
29, 73, -625.505534, _
30, 73, -631.329152, _
31, 73, -634.652739, _
32, 73, -635.46858, _
33, 73, -634.34146, _
34, 73, -630.833752, _
35, 73, -625.471602, _
36, 73, -617.593421, _
37, 73, -606.341324, _
38, 73, -591.426978, _
26, 74, -596.171454, _
27, 74, -608.617107, _
28, 74, -623.827761, _
29, 74, -630.595619, _
30, 74, -639.563779, _
31, 74, -641.074338, _
32, 74, -645.664816, _
33, 74, -642.320083, _
34, 74, -642.890883, _
35, 74, -635.183583, _
36, 74, -631.444822, _
37, 74, -620.246626, _
38, 74, -608.375295, _
27, 75, -613.325424, _
28, 75, -627.689078, _
29, 75, -637.132072, _
30, 75, -644.437293, _
31, 75, -649.560618, _
32, 75, -652.170656, _
33, 75, -652.565535, _
34, 75, -650.918479, _
35, 75, -647.07377, _
36, 75, -641.507928, _
37, 75, -633.620652, _
38, 75, -622.238306, _
27, 76, -616.394741, _
28, 76, -633.124395, _
29, 76, -641.708033, _
30, 76, -652.252718, _
31, 76, -655.463994, _
32, 76, -661.597897, _
33, 76, -659.894034, _
34, 76, -662.072265, _
35, 76, -656.327038, _
36, 76, -654.269759, _
37, 76, -644.952356, _
38, 76, -637.938567, _
39, 76, -621.509582, _
28, 77, -636.332712, _
29, 77, -647.315365, _
30, 77, -656.810214, _
31, 77, -663.231016, _
32, 77, -667.669188, _
33, 77, -669.590298, _
34, 77, -669.491117, _
35, 77, -667.344091, _
36, 77, -663.496381, _
37, 77, -657.375084, _
38, 77, -649.565682, _
39, 77, -637.758899, _
28, 78, -641.787029, _
29, 78, -651.37215, _
30, 78, -663.57557, _
31, 78, -669.015939, _
32, 78, -676.389696, _
33, 78, -676.562257, _
34, 78, -679.988858, _
35, 78, -675.632728, _
36, 78, -675.577833, _
37, 78, -667.551328, _
38, 78, -663.007504, _
39, 78, -651.578216, _
40, 78, -639.57087, _
28, 79, -643.438346, _
29, 79, -656.845, _
30, 79, -667.595947, _
31, 79, -675.928984, _
32, 79, -682.125554, _
33, 79, -685.452682, _
34, 79, -686.951691, _
35, 79, -686.319975, _
36, 79, -683.91185, _
37, 79, -679.490212, _
38, 79, -673.381769, _
39, 79, -665.479423, _
40, 79, -653.399187, _
29, 80, -659.448317, _
30, 80, -673.883582, _
31, 80, -680.67629, _
32, 80, -690.205582, _
33, 80, -692.10239, _
34, 80, -696.865061, _
35, 80, -694.212251, _
36, 80, -695.434203, _
37, 80, -688.934011, _
38, 80, -686.287677, _
39, 80, -676.340754, _
40, 80, -669.928547, _
29, 81, -662.878634, _
30, 81, -676.50595, _
31, 81, -687.151895, _
32, 81, -695.03328, _
33, 81, -700.492561, _
34, 81, -703.565908, _
35, 81, -704.370205, _
36, 81, -703.307022, _
37, 81, -700.286524, _
38, 81, -695.575639, _
39, 81, -688.976894, _
40, 81, -680.879212, _
41, 81, -668.647475, _
29, 82, -664.829951, _
30, 82, -680.984604, _
31, 82, -690.525976, _
32, 82, -702.227977, _
33, 82, -706.133653, _
34, 82, -712.842137, _
35, 82, -711.963148, _
36, 82, -714.273843, _
37, 82, -709.088981, _
38, 82, -708.128877, _
39, 82, -699.399447, _
40, 82, -694.497138, _
41, 82, -681.972792, _
30, 83, -683.186921, _
31, 83, -694.923697, _
32, 83, -705.860662, _
33, 83, -713.771204, _
34, 83, -718.660102, _
35, 83, -721.550589, _
36, 83, -721.744873, _
37, 83, -720.043124, _
38, 83, -716.987754, _
39, 83, -711.612326, _
40, 83, -704.535968, _
41, 83, -696.253622, _
42, 83, -683.746762, _
30, 84, -686.930238, _
31, 84, -698.020892, _
32, 84, -711.103972, _
33, 84, -718.026758, _
34, 84, -727.338573, _
35, 84, -728.391589, _
36, 84, -732.265494, _
37, 84, -728.802772, _
38, 84, -728.911021, _
39, 84, -721.372595, _
40, 84, -718.117305, _
41, 84, -706.935426, _
42, 84, -699.634079, _
30, 85, -688.431556, _
31, 85, -701.873209, _
32, 85, -714.150281, _
33, 85, -723.433659, _
34, 85, -731.875804, _
35, 85, -737.255291, _
36, 85, -739.377806, _
37, 85, -739.282459, _
38, 85, -737.436059, _
39, 85, -733.392559, _
40, 85, -727.942114, _
41, 85, -720.265418, _
42, 85, -710.713148, _
43, 85, -698.45505, _
31, 86, -704.336526, _
32, 86, -718.858179, _
33, 86, -727.277975, _
34, 86, -738.036652, _
35, 86, -742.383391, _
36, 86, -749.234458, _
37, 86, -747.933456, _
38, 86, -748.927299, _
39, 86, -742.904952, _
40, 86, -740.808059, _
41, 86, -731.189939, _
42, 86, -725.384957, _
43, 86, -711.789367, _
31, 87, -707.531843, _
32, 87, -721.247497, _
33, 87, -732.005056, _
34, 87, -742.030927, _
35, 87, -748.714133, _
36, 87, -754.749631, _
37, 87, -757.855553, _
38, 87, -757.35545, _
39, 87, -754.711413, _
40, 87, -750.257257, _
41, 87, -744.001676, _
42, 87, -736.230839, _
43, 87, -726.253728, _
44, 87, -713.713337, _
32, 88, -725.378814, _
33, 88, -735.178467, _
34, 88, -747.560315, _
35, 88, -753.609732, _
36, 88, -761.802712, _
37, 88, -763.938075, _
38, 88, -768.468085, _
39, 88, -764.063138, _
40, 88, -762.61037, _
41, 88, -754.375681, _
42, 88, -750.103891, _
43, 88, -738.316315, _
44, 88, -730.251654, _
32, 89, -727.041131, _
33, 89, -739.327784, _
34, 89, -750.739828, _
35, 89, -759.239353, _
36, 89, -766.718528, _
37, 89, -771.112637, _
38, 89, -774.826801, _
39, 89, -775.544856, _
40, 89, -771.929748, _
41, 89, -766.896406, _
42, 89, -760.503599, _
43, 89, -752.101166, _
44, 89, -742.030972, _
45, 89, -729.171625, _
32, 90, -730.604448, _
33, 90, -741.931101, _
34, 90, -755.618972, _
35, 90, -763.036705, _
36, 90, -773.213311, _
37, 90, -776.836445, _
38, 90, -782.638285, _
39, 90, -782.401882, _
40, 90, -783.898233, _
41, 90, -777.00455, _
42, 90, -773.732868, _
43, 90, -763.502321, _
44, 90, -756.879081, _
45, 90, -743.171942, _
33, 91, -745.568418, _
34, 91, -758.228072, _
35, 91, -768.215018, _
36, 91, -777.299343, _
37, 91, -783.288158, _
38, 91, -788.413091, _
39, 91, -790.330216, _
40, 91, -791.09215, _
41, 91, -789.052221, _
42, 91, -783.840011, _
43, 91, -776.835205, _
44, 91, -768.306124, _
45, 91, -758.080259, _
46, 91, -744.778913, _
33, 92, -747.724735, _
34, 92, -762.685389, _
35, 92, -771.411847, _
36, 92, -783.166015, _
37, 92, -788.386873, _
38, 92, -795.699394, _
39, 92, -796.86671, _
40, 92, -799.726939, _
41, 92, -796.938708, _
42, 92, -796.510443, _
43, 92, -787.845961, _
44, 92, -782.439124, _
45, 92, -770.354663, _
46, 92, -761.64323, _
34, 93, -764.748706, _
35, 93, -776.220697, _
36, 93, -786.604007, _
37, 93, -794.305619, _
38, 93, -800.989235, _
39, 93, -804.348629, _
40, 93, -806.461309, _
41, 93, -805.769264, _
42, 93, -804.580253, _
43, 93, -800.596944, _
44, 93, -793.425952, _
45, 93, -784.438693, _
46, 93, -773.784547, _
47, 93, -760.1292, _
34, 94, -768.907023, _
35, 94, -778.920676, _
36, 94, -791.887101, _
37, 94, -798.319772, _
38, 94, -807.820385, _
39, 94, -810.545132, _
40, 94, -814.680844, _
41, 94, -812.996804, _
42, 94, -814.258093, _
43, 94, -809.219999, _
44, 94, -806.864148, _
45, 94, -796.405823, _
46, 94, -788.816911, _
47, 94, -774.344517, _
34, 95, -770.63534, _
35, 95, -783.163994, _
36, 95, -794.769559, _
37, 95, -803.722181, _
38, 95, -812.168205, _
39, 95, -817.474926, _
40, 95, -821.142818, _
41, 95, -821.483971, _
42, 95, -821.627191, _
43, 95, -819.154327, _
44, 95, -815.808371, _
45, 95, -809.910133, _
46, 95, -800.751846, _
47, 95, -789.601834, _
48, 95, -775.853488, _
35, 96, -785.627311, _
36, 96, -799.761642, _
37, 96, -807.253978, _
38, 96, -818.047126, _
39, 96, -822.676517, _
40, 96, -828.997188, _
41, 96, -828.377058, _
42, 96, -830.781511, _
43, 96, -827.025923, _
44, 96, -826.502314, _
45, 96, -819.327314, _
46, 96, -815.040657, _
47, 96, -802.587786, _
48, 96, -792.866805, _
35, 97, -789.590628, _
36, 97, -802.176772, _
37, 97, -812.490056, _
38, 97, -821.770802, _
39, 97, -828.53342, _
40, 97, -834.572312, _
41, 97, -836.449636, _
42, 97, -837.602761, _
43, 97, -836.495706, _
44, 97, -834.613811, _
45, 97, -830.308465, _
46, 97, -824.735657, _
47, 97, -816.973311, _
48, 97, -805.819122, _
49, 97, -791.771775, _
35, 98, -792.054945, _
36, 98, -807.135598, _
37, 98, -816.360585, _
38, 98, -827.685881, _
39, 98, -832.778148, _
40, 98, -840.987726, _
41, 98, -842.44323, _
42, 98, -846.245361, _
43, 98, -843.779297, _
44, 98, -844.79059, _
45, 98, -838.958591, _
46, 98, -836.322107, _
47, 98, -827.285201, _
48, 98, -821.072854, _
49, 98, -806.550092, _
36, 99, -809.654915, _
37, 99, -821.318972, _
38, 99, -831.843164, _
39, 99, -839.204578, _
40, 99, -845.390955, _
41, 99, -849.315977, _
42, 99, -852.170806, _
43, 99, -852.746265, _
44, 99, -852.258981, _
45, 99, -849.43279, _
46, 99, -845.253688, _
47, 99, -839.002576, _
48, 99, -831.438878, _
49, 99, -822.10141, _
50, 99, -807.887063, _
36, 100, -814.019232, _
37, 100, -824.731886, _
38, 100, -837.232685, _
39, 100, -843.953523, _
40, 100, -852.219817, _
41, 100, -854.858833, _
42, 100, -860.462633, _
43, 100, -859.510665, _
44, 100, -861.932306, _
45, 100, -857.51433, _
46, 100, -856.370991, _
47, 100, -848.499379, _
48, 100, -843.773669, _
49, 100, -833.109699, _
50, 100, -825.297352, _
36, 101, -816.16655, _
37, 101, -829.068203, _
38, 101, -841.035849, _
39, 101, -849.758503, _
40, 101, -857.079913, _
41, 101, -862.014807, _
42, 101, -865.860873, _
43, 101, -867.90318, _
44, 101, -868.734354, _
45, 101, -867.408256, _
46, 101, -864.645741, _
47, 101, -859.76711, _
48, 101, -853.486845, _
49, 101, -845.482044, _
50, 101, -836.391322, _
37, 102, -832.03452, _
38, 102, -845.903539, _
39, 102, -853.936193, _
40, 102, -863.574242, _
41, 102, -867.508733, _
42, 102, -873.986249, _
43, 102, -874.204029, _
44, 102, -877.953994, _
45, 102, -874.849175, _
46, 102, -875.217397, _
47, 102, -868.750588, _
48, 102, -865.381241, _
49, 102, -855.633106, _
50, 102, -849.090759, _
37, 103, -836.006837, _
38, 103, -849.038491, _
39, 103, -859.291909, _
40, 103, -867.873243, _
41, 103, -874.29455, _
42, 103, -879.453887, _
43, 103, -882.306646, _
44, 103, -884.186048, _
45, 103, -884.168116, _
46, 103, -882.84275, _
47, 103, -879.375661, _
48, 103, -874.44502, _
49, 103, -867.640193, _
50, 103, -859.197846, _
51, 103, -847.623985, _
38, 104, -853.793808, _
39, 104, -862.969461, _
40, 104, -873.853344, _
41, 104, -879.16595, _
42, 104, -886.914334, _
43, 104, -888.28326, _
44, 104, -893.087462, _
45, 104, -891.167073, _
46, 104, -892.824011, _
47, 104, -887.76301, _
48, 104, -885.832578, _
49, 104, -877.264659, _
50, 104, -871.926689, _
51, 104, -858.687846, _
38, 105, -856.369125, _
39, 105, -867.798778, _
40, 105, -877.665394, _
41, 105, -885.323997, _
42, 105, -891.972973, _
43, 105, -896.140339, _
44, 105, -898.99756, _
45, 105, -900.133249, _
46, 105, -899.918111, _
47, 105, -897.788833, _
48, 105, -894.269496, _
49, 105, -888.793883, _
50, 105, -881.708952, _
51, 105, -871.604709, _
52, 105, -859.617782, _
38, 106, -860.620442, _
39, 106, -871.101095, _
40, 106, -883.173749, _
41, 106, -889.683085, _
42, 106, -898.841874, _
43, 106, -901.694093, _
44, 106, -907.458746, _
45, 106, -906.715804, _
46, 106, -909.479073, _
47, 106, -905.731584, _
48, 106, -905.138991, _
49, 106, -897.832641, _
50, 106, -893.795963, _
51, 106, -882.133227, _
52, 106, -873.096277, _
38, 107, -862.801759, _
39, 107, -875.483412, _
40, 107, -886.606066, _
41, 107, -895.274819, _
42, 107, -903.33028, _
43, 107, -908.737928, _
44, 107, -913.068179, _
45, 107, -915.289188, _
46, 107, -916.015503, _
47, 107, -915.267235, _
48, 107, -913.068541, _
49, 107, -908.860194, _
50, 107, -903.025827, _
51, 107, -894.384475, _
52, 107, -883.485236, _
53, 107, -871.74056, _
39, 108, -878.487729, _
40, 108, -891.761383, _
41, 108, -899.172001, _
42, 108, -909.606038, _
43, 108, -913.982088, _
44, 108, -920.938314, _
45, 108, -921.52857, _
46, 108, -925.238664, _
47, 108, -922.538645, _
48, 108, -923.402161, _
49, 108, -917.487204, _
50, 108, -914.65486, _
51, 108, -904.2479, _
52, 108, -896.801895, _
53, 108, -882.884406, _
39, 109, -882.462047, _
40, 109, -894.6727, _
41, 109, -904.317284, _
42, 109, -913.587472, _
43, 109, -920.413385, _
44, 109, -926.086665, _
45, 109, -929.567892, _
46, 109, -931.392252, _
47, 109, -931.723157, _
48, 109, -930.72529, _
49, 109, -927.926512, _
50, 109, -923.287148, _
51, 109, -916.124941, _
52, 109, -906.806931, _
53, 109, -895.982377, _
54, 109, -883.696475, _
40, 110, -899.437017, _
41, 110, -907.90467, _
42, 110, -919.535436, _
43, 110, -925.236418, _
44, 110, -933.492206, _
45, 110, -935.468262, _
46, 110, -940.188464, _
47, 110, -938.532352, _
48, 110, -940.641009, _
49, 110, -935.980663, _
50, 110, -934.569534, _
51, 110, -925.394937, _
52, 110, -919.392681, _
53, 110, -906.844686, _
54, 110, -897.516751, _
40, 111, -902.182334, _
41, 111, -912.714988, _
42, 111, -922.995315, _
43, 111, -931.297829, _
44, 111, -938.276132, _
45, 111, -943.015259, _
46, 111, -945.914764, _
47, 111, -947.362187, _
48, 111, -947.61664, _
49, 111, -945.972116, _
50, 111, -942.738386, _
51, 111, -936.853257, _
52, 111, -928.821652, _
53, 111, -919.405636, _
54, 111, -908.062019, _
40, 112, -906.503651, _
41, 112, -916.185305, _
42, 112, -928.592958, _
43, 112, -935.601666, _
44, 112, -945.192976, _
45, 112, -948.514803, _
46, 112, -954.321402, _
47, 112, -953.800942, _
48, 112, -957.010683, _
49, 112, -953.643603, _
50, 112, -953.526175, _
51, 112, -945.686803, _
52, 112, -940.873, _
53, 112, -929.586474, _
54, 112, -921.76722, _
55, 112, -907.245732, _
41, 113, -920.493622, _
42, 113, -931.969275, _
43, 113, -941.229467, _
44, 113, -949.505934, _
45, 113, -955.62098, _
46, 113, -959.66219, _
47, 113, -962.315331, _
48, 113, -963.549447, _
49, 113, -963.08967, _
50, 113, -961.269742, _
51, 113, -956.576232, _
52, 113, -949.723838, _
53, 113, -941.71397, _
54, 113, -932.015748, _
55, 113, -920.793688, _
41, 114, -923.440939, _
42, 114, -937.078592, _
43, 114, -945.257246, _
44, 114, -955.928921, _
45, 114, -960.637973, _
46, 114, -967.63336, _
47, 114, -968.290658, _
48, 114, -972.592355, _
49, 114, -970.363563, _
50, 114, -971.570155, _
51, 114, -964.726118, _
52, 114, -961.336695, _
53, 114, -951.46178, _
54, 114, -944.969322, _
55, 114, -931.783346, _
56, 114, -922.278245, _
41, 115, -927.479256, _
42, 115, -940.091909, _
43, 115, -950.468563, _
44, 115, -960.082053, _
45, 115, -967.225146, _
46, 115, -972.640106, _
47, 115, -976.413837, _
48, 115, -978.733219, _
49, 115, -979.402826, _
50, 115, -979.11797, _
51, 115, -975.305193, _
52, 115, -969.582202, _
53, 115, -963.074893, _
54, 115, -954.611497, _
55, 115, -944.871404, _
56, 115, -933.415057, _
42, 116, -944.914226, _
43, 116, -954.08788, _
44, 116, -965.91844, _
45, 116, -971.806212, _
46, 116, -980.116689, _
47, 116, -982.045146, _
48, 116, -987.432703, _
49, 116, -986.187546, _
50, 116, -988.681449, _
51, 116, -983.194761, _
52, 116, -980.859721, _
53, 116, -972.30065, _
54, 116, -967.07279, _
55, 116, -955.306721, _
56, 116, -947.158374, _
57, 116, -932.381027, _
42, 117, -947.655544, _
43, 117, -959.085197, _
44, 117, -969.440522, _
45, 117, -978.036093, _
46, 117, -984.780842, _
47, 117, -989.755861, _
48, 117, -993.209929, _
49, 117, -994.95219, _
50, 117, -995.624553, _
51, 117, -993.083988, _
52, 117, -988.757503, _
53, 117, -983.31581, _
54, 117, -976.28272, _
55, 117, -967.808129, _
56, 117, -958.154378, _
57, 117, -946.338345, _
43, 118, -962.564514, _
44, 118, -975.251167, _
45, 118, -982.097499, _
46, 118, -991.816357, _
47, 118, -995.198919, _
48, 118, -1001.5645, _
49, 118, -1001.30868, _
50, 118, -1004.95097, _
51, 118, -1000.51199, _
52, 118, -999.430175, _
53, 118, -991.922096, _
54, 118, -988.247757, _
55, 118, -977.795722, _
56, 118, -970.958008, _
57, 118, -957.442662, _
43, 119, -967.216831, _
44, 119, -978.627484, _
45, 119, -988.10393, _
46, 119, -995.906913, _
47, 119, -1002.36222, _
48, 119, -1006.91122, _
49, 119, -1009.85125, _
50, 119, -1011.43447, _
51, 119, -1010.06128, _
52, 119, -1006.98593, _
53, 119, -1002.7879, _
54, 119, -997.034431, _
55, 119, -989.762723, _
56, 119, -981.265411, _
57, 119, -970.859979, _
58, 119, -959.160632, _
43, 120, -970.435148, _
44, 120, -984.146802, _
45, 120, -992.167455, _
46, 120, -1002.85032, _
47, 120, -1007.43926, _
48, 120, -1014.96277, _
49, 120, -1015.95166, _
50, 120, -1020.53931, _
51, 120, -1017.07636, _
52, 120, -1017.24421, _
53, 120, -1010.84687, _
54, 120, -1008.48376, _
55, 120, -999.417627, _
56, 120, -993.63528, _
57, 120, -981.651296, _
58, 120, -972.979949, _
44, 121, -987.253119, _
45, 121, -997.853772, _
46, 121, -1006.82375, _
47, 121, -1014.2619, _
48, 121, -1020.15056, _
49, 121, -1024.13057, _
50, 121, -1026.70953, _
51, 121, -1026.32827, _
52, 121, -1024.49161, _
53, 121, -1021.41664, _
54, 121, -1016.86364, _
55, 121, -1010.70264, _
56, 121, -1003.5628, _
57, 121, -994.305613, _
58, 121, -984.022266, _
59, 121, -972.08992, _
44, 122, -992.688436, _
45, 122, -1001.66809, _
46, 122, -1013.3289, _
47, 122, -1019.0365, _
48, 122, -1027.76042, _
49, 122, -1029.93866, _
50, 122, -1035.5249, _
51, 122, -1033.13463, _
52, 122, -1034.3331, _
53, 122, -1029.31676, _
54, 122, -1027.80895, _
55, 122, -1019.81638, _
56, 122, -1015.49822, _
57, 122, -1004.64993, _
58, 122, -997.198583, _
59, 122, -983.487237, _
44, 123, -995.710753, _
45, 123, -1007.07541, _
46, 123, -1017.20106, _
47, 123, -1025.54979, _
48, 123, -1032.63355, _
49, 123, -1037.86747, _
50, 123, -1041.47106, _
51, 123, -1042.09715, _
52, 123, -1041.26212, _
53, 123, -1039.25134, _
54, 123, -1035.77398, _
55, 123, -1030.78659, _
56, 123, -1024.61555, _
57, 123, -1016.82925, _
58, 123, -1007.6819, _
59, 123, -996.951554, _
44, 124, -1000.83907, _
45, 124, -1010.80572, _
46, 124, -1023.40938, _
47, 124, -1030.27316, _
48, 124, -1039.99235, _
49, 124, -1043.37855, _
50, 124, -1049.96023, _
51, 124, -1048.56465, _
52, 124, -1050.6866, _
53, 124, -1046.74467, _
54, 124, -1046.25766, _
55, 124, -1039.54559, _
56, 124, -1036.12169, _
57, 124, -1026.50817, _
58, 124, -1020.38322, _
59, 124, -1007.83587, _
60, 124, -998.427524, _
45, 125, -1015.91504, _
46, 125, -1027.14869, _
47, 125, -1036.37458, _
48, 125, -1044.71009, _
49, 125, -1051.05649, _
50, 125, -1055.69373, _
51, 125, -1057.27122, _
52, 125, -1057.25557, _
53, 125, -1056.28745, _
54, 125, -1053.86093, _
55, 125, -1049.97341, _
56, 125, -1044.77219, _
57, 125, -1038.08037, _
58, 125, -1030.19653, _
59, 125, -1020.78819, _
60, 125, -1009.57284, _
45, 126, -1019.54336, _
46, 126, -1033.01301, _
47, 126, -1040.99566, _
48, 126, -1051.69012, _
49, 126, -1056.4239, _
50, 126, -1063.88391, _
51, 126, -1063.47956, _
52, 126, -1066.36926, _
53, 126, -1063.43289, _
54, 126, -1063.8848, _
55, 126, -1058.30735, _
56, 126, -1055.84445, _
57, 126, -1047.36567, _
58, 126, -1042.43041, _
59, 126, -1031.15151, _
60, 126, -1023.03816, _
61, 126, -1008.45981, _
46, 127, -1036.51033, _
47, 127, -1046.86898, _
48, 127, -1055.99515, _
49, 127, -1063.62059, _
50, 127, -1069.41117, _
51, 127, -1071.85707, _
52, 127, -1072.65691, _
53, 127, -1072.5768, _
54, 127, -1071.1321, _
55, 127, -1068.26836, _
56, 127, -1064.06381, _
57, 127, -1058.35962, _
58, 127, -1051.6605, _
59, 127, -1043.44182, _
60, 127, -1033.65248, _
61, 127, -1022.12013, _
46, 128, -1042.01065, _
47, 128, -1051.2603, _
48, 128, -1062.81784, _
49, 128, -1068.93956, _
50, 128, -1077.37328, _
51, 128, -1077.85921, _
52, 128, -1081.44031, _
53, 128, -1079.40293, _
54, 128, -1080.74215, _
55, 128, -1076.03109, _
56, 128, -1074.69609, _
57, 128, -1067.16026, _
58, 128, -1063.2864, _
59, 128, -1053.3009, _
60, 128, -1046.50179, _
61, 128, -1033.19145, _
62, 128, -1023.3551, _
47, 129, -1056.63962, _
48, 129, -1067.15627, _
49, 129, -1075.70281, _
50, 129, -1082.68968, _
51, 129, -1085.92957, _
52, 129, -1087.52272, _
53, 129, -1088.24268, _
54, 129, -1087.64925, _
55, 129, -1085.67009, _
56, 129, -1082.45178, _
57, 129, -1077.93076, _
58, 129, -1072.1113, _
59, 129, -1064.81501, _
60, 129, -1056.57411, _
61, 129, -1046.35776, _
62, 129, -1034.83542, _
47, 130, -1058.42093, _
48, 130, -1073.25245, _
49, 130, -1080.8201, _
50, 130, -1090.28675, _
51, 130, -1091.65781, _
52, 130, -1095.94215, _
53, 130, -1094.74301, _
54, 130, -1096.90497, _
55, 130, -1093.1419, _
56, 130, -1092.72155, _
57, 130, -1086.30483, _
58, 130, -1083.31803, _
59, 130, -1074.28823, _
60, 130, -1068.92666, _
61, 130, -1056.94408, _
62, 130, -1048.27173, _
63, 130, -1033.80739, _
48, 131, -1075.1209, _
49, 131, -1087.03314, _
50, 131, -1095.49734, _
51, 131, -1099.42477, _
52, 131, -1101.87153, _
53, 131, -1103.32095, _
54, 131, -1103.50945, _
55, 131, -1102.37236, _
56, 131, -1100.21505, _
57, 131, -1096.51804, _
58, 131, -1091.67488, _
59, 131, -1085.48475, _
60, 131, -1078.16978, _
61, 131, -1069.5424, _
62, 131, -1058.97005, _
63, 131, -1047.3247, _
48, 132, -1078.12422, _
49, 132, -1089.48779, _
50, 132, -1102.84044, _
51, 132, -1105.14975, _
52, 132, -1109.92002, _
53, 132, -1109.65298, _
54, 132, -1112.4461, _
55, 132, -1109.54104, _
56, 132, -1110.03744, _
57, 132, -1104.54373, _
58, 132, -1102.50872, _
59, 132, -1094.46889, _
60, 132, -1089.89887, _
61, 132, -1079.31871, _
62, 132, -1071.98737, _
63, 132, -1058.35102, _
48, 133, -1079.85254, _
49, 133, -1092.61419, _
50, 133, -1105.24205, _
51, 133, -1112.508, _
52, 133, -1115.73521, _
53, 133, -1117.90738, _
54, 133, -1118.88203, _
55, 133, -1118.52704, _
56, 133, -1117.22735, _
57, 133, -1114.3858, _
58, 133, -1110.52729, _
59, 133, -1105.2643, _
60, 133, -1098.87675, _
61, 133, -1091.16968, _
62, 133, -1082.21069, _
63, 133, -1071.43334, _
64, 133, -1059.43599, _
49, 134, -1094.88251, _
50, 134, -1108.87139, _
51, 134, -1115.67736, _
52, 134, -1123.41046, _
53, 134, -1124.15122, _
54, 134, -1127.43408, _
55, 134, -1125.41858, _
56, 134, -1126.69514, _
57, 134, -1122.18139, _
58, 134, -1121.01328, _
59, 134, -1113.92603, _
60, 134, -1110.26213, _
61, 134, -1100.5721, _
62, 134, -1094.427, _
63, 134, -1082.19666, _
64, 134, -1072.78831, _
49, 135, -1097.82083, _
50, 135, -1111.14272, _
51, 135, -1119.41776, _
52, 135, -1126.67364, _
53, 135, -1131.9524, _
54, 135, -1133.79786, _
55, 135, -1134.18056, _
56, 135, -1133.66711, _
57, 135, -1131.67756, _
58, 135, -1128.86806, _
59, 135, -1124.40522, _
60, 135, -1118.90062, _
61, 135, -1111.93159, _
62, 135, -1103.97953, _
63, 135, -1094.48797, _
64, 135, -1083.85063, _
65, 135, -1071.60028, _
50, 136, -1114.4808, _
51, 136, -1122.30925, _
52, 136, -1131.44291, _
53, 136, -1135.78023, _
54, 136, -1141.88156, _
55, 136, -1141.00898, _
56, 136, -1142.77485, _
57, 136, -1139.14285, _
58, 136, -1138.83161, _
59, 136, -1132.8811, _
60, 136, -1129.95762, _
61, 136, -1121.15648, _
62, 136, -1116.00453, _
63, 136, -1104.65529, _
64, 136, -1096.71894, _
65, 136, -1082.9046, _
50, 137, -1116.44111, _
51, 137, -1125.9009, _
52, 137, -1134.39264, _
53, 137, -1140.66232, _
54, 137, -1145.90712, _
55, 137, -1149.2872, _
56, 137, -1149.68049, _
57, 137, -1148.31759, _
58, 137, -1146.31314, _
59, 137, -1142.81383, _
60, 137, -1138.41421, _
61, 137, -1132.12015, _
62, 137, -1125.29148, _
63, 137, -1116.60161, _
64, 137, -1106.91426, _
65, 137, -1095.88491, _
50, 138, -1119.58543, _
51, 138, -1128.48108, _
52, 138, -1138.85593, _
53, 138, -1144.35728, _
54, 138, -1151.56727, _
55, 138, -1153.69974, _
56, 138, -1158.29221, _
57, 138, -1155.7699, _
58, 138, -1156.03439, _
59, 138, -1150.81505, _
60, 138, -1148.91927, _
61, 138, -1141.0591, _
62, 138, -1136.83403, _
63, 138, -1126.30359, _
64, 138, -1119.42858, _
65, 138, -1106.65723, _
66, 138, -1097.13788, _
51, 139, -1131.8014, _
52, 139, -1141.43612, _
53, 139, -1148.90773, _
54, 139, -1155.31094, _
55, 139, -1159.58515, _
56, 139, -1163.01564, _
57, 139, -1164.54791, _
58, 139, -1163.48718, _
59, 139, -1160.57576, _
60, 139, -1156.98693, _
61, 139, -1151.69054, _
62, 139, -1145.78781, _
63, 139, -1138.02328, _
64, 139, -1129.47489, _
65, 139, -1119.19055, _
66, 139, -1107.9202, _
51, 140, -1134.02372, _
52, 140, -1145.65909, _
53, 140, -1152.11591, _
54, 140, -1160.72413, _
55, 140, -1164.00566, _
56, 140, -1169.44321, _
57, 140, -1169.70888, _
58, 140, -1172.68747, _
59, 140, -1168.51712, _
60, 140, -1167.29737, _
61, 140, -1160.46982, _
62, 140, -1156.93484, _
63, 140, -1147.68249, _
64, 140, -1141.69648, _
65, 140, -1129.61414, _
66, 140, -1121.17952, _
67, 140, -1106.82617, _
52, 141, -1147.86069, _
53, 141, -1156.49534, _
54, 141, -1164.00629, _
55, 141, -1169.50379, _
56, 141, -1173.97708, _
57, 141, -1176.39656, _
58, 141, -1178.11561, _
59, 141, -1177.91368, _
60, 141, -1175.30832, _
61, 141, -1170.85549, _
62, 141, -1165.48409, _
63, 141, -1158.6935, _
64, 141, -1151.20975, _
65, 141, -1141.74402, _
66, 141, -1131.80284, _
67, 141, -1120.00249, _
52, 142, -1151.815, _
53, 142, -1159.43264, _
54, 142, -1169.10995, _
55, 142, -1173.6158, _
56, 142, -1180.15835, _
57, 142, -1181.55709, _
58, 142, -1185.28366, _
59, 142, -1183.75683, _
60, 142, -1185.13612, _
61, 142, -1179.54594, _
62, 142, -1176.60815, _
63, 142, -1168.1528, _
64, 142, -1163.01636, _
65, 142, -1151.83401, _
66, 142, -1144.61215, _
67, 142, -1130.95981, _
68, 142, -1120.77946, _
52, 143, -1153.79432, _
53, 143, -1163.36098, _
54, 143, -1172.1545, _
55, 143, -1178.84295, _
56, 143, -1184.324, _
57, 143, -1187.77602, _
58, 143, -1190.42846, _
59, 143, -1191.10793, _
60, 143, -1191.25969, _
61, 143, -1189.43568, _
62, 143, -1185.20956, _
63, 143, -1179.15181, _
64, 143, -1172.35946, _
65, 143, -1163.765, _
66, 143, -1154.73241, _
67, 143, -1143.82912, _
68, 143, -1132.09178, _
53, 144, -1166.08529, _
54, 144, -1176.89524, _
55, 144, -1182.51111, _
56, 144, -1190.22533, _
57, 144, -1192.52556, _
58, 144, -1197.32533, _
59, 144, -1196.86163, _
60, 144, -1199.07672, _
61, 144, -1195.96245, _
62, 144, -1195.72962, _
63, 144, -1188.60093, _
64, 144, -1183.95898, _
65, 144, -1173.78531, _
66, 144, -1167.20487, _
67, 144, -1154.46195, _
68, 144, -1145.67809, _
69, 144, -1130.37975, _
53, 145, -1169.81561, _
54, 145, -1179.58759, _
55, 145, -1187.36772, _
56, 145, -1194.04575, _
57, 145, -1198.58254, _
58, 145, -1202.03182, _
59, 145, -1203.80835, _
60, 145, -1204.83202, _
61, 145, -1203.88516, _
62, 145, -1202.48672, _
63, 145, -1199.04469, _
64, 145, -1193.19483, _
65, 145, -1185.79038, _
66, 145, -1176.9487, _
67, 145, -1167.04386, _
68, 145, -1156.21741, _
69, 145, -1143.94206, _
54, 146, -1184.12052, _
55, 146, -1190.95219, _
56, 146, -1199.54119, _
57, 146, -1202.86537, _
58, 146, -1208.67126, _
59, 146, -1208.93457, _
60, 146, -1212.39725, _
61, 146, -1210.14336, _
62, 146, -1210.90301, _
63, 146, -1206.24188, _
64, 146, -1204.42765, _
65, 146, -1195.32318, _
66, 146, -1189.33234, _
67, 146, -1177.23329, _
68, 146, -1169.53474, _
69, 146, -1155.32238, _
54, 147, -1186.8439, _
55, 147, -1195.47276, _
56, 147, -1202.93623, _
57, 147, -1208.56825, _
58, 147, -1213.12139, _
59, 147, -1215.76918, _
60, 147, -1217.68945, _
61, 147, -1217.80241, _
62, 147, -1217.24413, _
63, 147, -1214.74018, _
64, 147, -1211.77001, _
65, 147, -1206.37359, _
66, 147, -1199.04478, _
67, 147, -1189.82348, _
68, 147, -1179.89185, _
69, 147, -1168.4761, _
54, 148, -1191.31021, _
55, 148, -1198.82235, _
56, 148, -1208.33726, _
57, 148, -1212.66991, _
58, 148, -1219.57721, _
59, 148, -1220.93184, _
60, 148, -1225.02194, _
61, 148, -1223.69686, _
62, 148, -1225.38551, _
63, 148, -1221.56647, _
64, 148, -1220.75407, _
65, 148, -1214.23368, _
66, 148, -1210.77327, _
67, 148, -1200.12887, _
68, 148, -1192.83435, _
69, 148, -1179.33804, _
70, 148, -1169.98967, _
55, 149, -1203.35918, _
56, 149, -1211.83584, _
57, 149, -1218.2524, _
58, 149, -1223.92006, _
59, 149, -1227.50716, _
60, 149, -1230.06073, _
61, 149, -1230.96678, _
62, 149, -1231.25586, _
63, 149, -1229.77889, _
64, 149, -1227.68281, _
65, 149, -1223.26258, _
66, 149, -1218.69078, _
67, 149, -1211.87146, _
68, 149, -1203.16829, _
69, 149, -1192.52733, _
70, 149, -1181.05999, _
55, 150, -1206.4835, _
56, 150, -1217.14016, _
57, 150, -1222.48681, _
58, 150, -1230.16831, _
59, 150, -1232.83951, _
60, 150, -1237.43585, _
61, 150, -1236.57089, _
62, 150, -1239.24254, _
63, 150, -1236.20155, _
64, 150, -1236.39098, _
65, 150, -1230.95068, _
66, 150, -1228.37212, _
67, 150, -1220.22618, _
68, 150, -1215.32927, _
69, 150, -1203.20665, _
70, 150, -1194.5713, _
71, 150, -1179.79096, _
55, 151, -1210.59682, _
56, 151, -1220.34947, _
57, 151, -1227.90413, _
58, 151, -1234.61783, _
59, 151, -1239.3899, _
60, 151, -1242.7704, _
61, 151, -1244.43113, _
62, 151, -1244.83899, _
63, 151, -1244.13302, _
64, 151, -1242.88665, _
65, 151, -1239.5393, _
66, 151, -1235.88612, _
67, 151, -1229.97424, _
68, 151, -1223.8356, _
69, 151, -1215.56468, _
70, 151, -1205.54693, _
71, 151, -1193.33027, _
56, 152, -1225.12279, _
57, 152, -1231.78344, _
58, 152, -1240.5211, _
59, 152, -1244.43981, _
60, 152, -1250.04815, _
61, 152, -1250.37059, _
62, 152, -1253.09668, _
63, 152, -1250.43973, _
64, 152, -1251.47631, _
65, 152, -1246.70396, _
66, 152, -1245.32327, _
67, 152, -1238.02201, _
68, 152, -1234.13457, _
69, 152, -1224.62886, _
70, 152, -1218.39662, _
71, 152, -1204.71559, _
56, 153, -1228.02411, _
57, 153, -1236.55676, _
58, 153, -1244.55841, _
59, 153, -1250.32152, _
60, 153, -1255.30099, _
61, 153, -1257.83597, _
62, 153, -1258.96508, _
63, 153, -1258.99001, _
64, 153, -1257.72326, _
65, 153, -1255.37193, _
66, 153, -1252.41922, _
67, 153, -1247.50659, _
68, 153, -1242.18413, _
69, 153, -1234.9189, _
70, 153, -1227.35525, _
71, 153, -1217.78805, _
72, 153, -1205.88456, _
57, 154, -1240.14808, _
58, 154, -1249.95673, _
59, 154, -1255.01878, _
60, 154, -1261.72644, _
61, 154, -1263.75102, _
62, 154, -1266.93187, _
63, 154, -1265.43218, _
64, 154, -1266.61799, _
65, 154, -1262.28599, _
66, 154, -1261.74163, _
67, 154, -1255.20493, _
68, 154, -1252.38819, _
69, 154, -1243.42808, _
70, 154, -1238.1507, _
71, 154, -1227.15122, _
72, 154, -1219.38688, _
57, 155, -1244.64239, _
58, 155, -1253.60305, _
59, 155, -1260.31095, _
60, 155, -1266.39706, _
61, 155, -1270.27092, _
62, 155, -1272.73883, _
63, 155, -1273.58347, _
64, 155, -1273.05322, _
65, 155, -1271.45109, _
66, 155, -1268.57424, _
67, 155, -1264.67608, _
68, 155, -1260.06356, _
69, 155, -1253.69807, _
70, 155, -1246.79258, _
71, 155, -1238.05763, _
72, 155, -1229.0882, _
73, 155, -1217.93385, _
58, 156, -1258.61936, _
59, 156, -1264.53502, _
60, 156, -1272.65829, _
61, 156, -1275.56595, _
62, 156, -1279.98268, _
63, 156, -1279.92278, _
64, 156, -1281.58957, _
65, 156, -1278.36304, _
66, 156, -1278.01893, _
67, 156, -1272.18658, _
68, 156, -1270.13628, _
69, 156, -1261.97254, _
70, 156, -1257.61966, _
71, 156, -1247.32878, _
72, 156, -1240.66379, _
73, 156, -1228.06817, _
58, 157, -1261.82868, _
59, 157, -1269.57834, _
60, 157, -1276.71751, _
61, 157, -1281.77066, _
62, 157, -1285.36885, _
63, 157, -1287.36725, _
64, 157, -1287.94942, _
65, 157, -1287.10703, _
66, 157, -1284.98554, _
67, 157, -1281.61013, _
68, 157, -1277.38663, _
69, 157, -1271.95104, _
70, 157, -1265.85804, _
71, 157, -1258.10689, _
72, 157, -1249.77083, _
73, 157, -1239.72919, _
74, 157, -1229.01314, _
59, 158, -1273.43965, _
60, 158, -1282.38231, _
61, 158, -1286.63415, _
62, 158, -1292.01283, _
63, 158, -1293.23543, _
64, 158, -1295.88681, _
65, 158, -1293.88551, _
66, 158, -1294.03939, _
67, 158, -1289.03728, _
68, 158, -1287.37234, _
69, 158, -1279.98938, _
70, 158, -1276.51406, _
71, 158, -1266.93379, _
72, 158, -1261.04166, _
73, 158, -1249.3238, _
74, 158, -1241.06945, _
59, 159, -1278.26897, _
60, 159, -1286.20562, _
61, 159, -1292.17054, _
62, 159, -1297.04168, _
63, 159, -1300.09444, _
64, 159, -1301.83002, _
65, 159, -1302.01853, _
66, 159, -1300.87081, _
67, 159, -1298.25086, _
68, 159, -1294.70001, _
69, 159, -1289.9279, _
70, 159, -1284.41391, _
71, 159, -1277.50141, _
72, 159, -1269.86322, _
73, 159, -1260.67238, _
74, 159, -1250.93277, _
75, 159, -1239.40042, _
60, 160, -1291.60394, _
61, 160, -1296.68959, _
62, 160, -1303.14002, _
63, 160, -1305.60334, _
64, 160, -1309.28148, _
65, 160, -1308.39374, _
66, 160, -1309.44728, _
67, 160, -1305.37494, _
68, 160, -1304.2754, _
69, 160, -1297.73085, _
70, 160, -1294.81137, _
71, 160, -1286.13406, _
72, 160, -1281.01305, _
73, 160, -1270.17359, _
74, 160, -1262.894, _
75, 160, -1249.66574, _
60, 161, -1295.12926, _
61, 161, -1301.99391, _
62, 161, -1307.6485, _
63, 161, -1311.98572, _
64, 161, -1314.91688, _
65, 161, -1316.09035, _
66, 161, -1315.90167, _
67, 161, -1314.26137, _
68, 161, -1311.48278, _
69, 161, -1307.39885, _
70, 161, -1302.55692, _
71, 161, -1296.49779, _
72, 161, -1289.4685, _
73, 161, -1281.07222, _
74, 161, -1272.1444, _
75, 161, -1261.69672, _
76, 161, -1250.24371, _
61, 162, -1306.20023, _
62, 162, -1313.57788, _
63, 162, -1316.96012, _
64, 162, -1321.76278, _
65, 162, -1322.37549, _
66, 162, -1324.09866, _
67, 162, -1321.17695, _
68, 162, -1320.68701, _
69, 162, -1315.04794, _
70, 162, -1312.61561, _
71, 162, -1304.83851, _
72, 162, -1300.39348, _
73, 162, -1290.22237, _
74, 162, -1283.66005, _
75, 162, -1271.37838, _
76, 162, -1262.59803, _
61, 163, -1311.15054, _
62, 163, -1317.8392, _
63, 163, -1322.97572, _
64, 163, -1326.86837, _
65, 163, -1329.36693, _
66, 163, -1330.36967, _
67, 163, -1329.58477, _
68, 163, -1327.5917, _
69, 163, -1324.37035, _
70, 163, -1320.15968, _
71, 163, -1314.86949, _
72, 163, -1308.55971, _
73, 163, -1301.04809, _
74, 163, -1292.63939, _
75, 163, -1282.95613, _
76, 163, -1272.55135, _
62, 164, -1323.29252, _
63, 164, -1327.74217, _
64, 164, -1333.39982, _
65, 164, -1334.92014, _
66, 164, -1338.02779, _
67, 164, -1336.25955, _
68, 164, -1336.43802, _
69, 164, -1331.61781, _
70, 164, -1329.94932, _
71, 164, -1322.79177, _
72, 164, -1319.18527, _
73, 164, -1309.8675, _
74, 164, -1304.03023, _
75, 164, -1292.54298, _
76, 164, -1284.71031, _
77, 164, -1270.99232, _
62, 165, -1327.06983, _
63, 165, -1333.16549, _
64, 165, -1338.18314, _
65, 165, -1341.48079, _
66, 165, -1343.74375, _
67, 165, -1344.24837, _
68, 165, -1343.08815, _
69, 165, -1340.71422, _
70, 165, -1337.29844, _
71, 165, -1332.66295, _
72, 165, -1327.07387, _
73, 165, -1320.50362, _
74, 165, -1312.73487, _
75, 165, -1303.735, _
76, 165, -1294.10398, _
77, 165, -1283.16963, _
63, 166, -1337.4798, _
64, 166, -1344.29846, _
65, 166, -1346.86959, _
66, 166, -1350.78725, _
67, 166, -1350.49201, _
68, 166, -1351.56464, _
69, 166, -1347.74463, _
70, 166, -1346.66965, _
71, 166, -1340.31301, _
72, 166, -1337.36867, _
73, 166, -1328.82511, _
74, 166, -1323.83315, _
75, 166, -1313.05623, _
76, 166, -1305.81709, _
77, 166, -1292.95195, _
78, 166, -1283.6076, _
63, 167, -1342.50512, _
64, 167, -1348.65277, _
65, 167, -1352.98443, _
66, 167, -1356.20612, _
67, 167, -1357.77377, _
68, 167, -1358.0011, _
69, 167, -1356.47209, _
70, 167, -1353.73659, _
71, 167, -1349.86447, _
72, 167, -1345.04876, _
73, 167, -1339.14971, _
74, 167, -1332.11559, _
75, 167, -1324.07696, _
76, 167, -1314.95377, _
77, 167, -1304.74698, _
78, 167, -1293.69192, _
64, 168, -1354.27409, _
65, 168, -1357.85174, _
66, 168, -1362.90638, _
67, 168, -1363.62476, _
68, 168, -1365.77241, _
69, 168, -1363.31271, _
70, 168, -1362.79845, _
71, 168, -1357.50205, _
72, 168, -1355.01287, _
73, 168, -1347.26388, _
74, 168, -1342.98048, _
75, 168, -1333.10016, _
76, 168, -1326.50982, _
77, 168, -1314.45743, _
78, 168, -1306.01631, _
64, 169, -1358.13541, _
65, 169, -1363.52906, _
66, 169, -1368.0153, _
67, 169, -1370.43295, _
68, 169, -1371.77566, _
69, 169, -1371.34632, _
70, 169, -1369.66543, _
71, 169, -1366.59008, _
72, 169, -1362.44052, _
73, 169, -1357.23172, _
74, 169, -1351.07666, _
75, 169, -1343.78576, _
76, 169, -1335.31718, _
77, 169, -1325.88972, _
78, 169, -1315.54256, _
79, 169, -1304.03521, _
65, 170, -1367.99538, _
66, 170, -1374.15203, _
67, 170, -1375.94578, _
68, 170, -1379.03343, _
69, 170, -1377.93829, _
70, 170, -1378.12437, _
71, 170, -1373.88433, _
72, 170, -1372.04881, _
73, 170, -1365.15027, _
74, 170, -1361.52073, _
75, 170, -1352.36567, _
76, 170, -1346.59202, _
77, 170, -1335.24322, _
78, 170, -1327.40542, _
79, 170, -1314.07053, _
65, 171, -1373.3747, _
66, 171, -1378.74935, _
67, 171, -1382.29739, _
68, 171, -1384.71505, _
69, 171, -1385.42478, _
70, 171, -1384.73899, _
71, 171, -1382.47859, _
72, 171, -1379.29761, _
73, 171, -1374.8042, _
74, 171, -1369.38767, _
75, 171, -1362.76951, _
76, 171, -1355.04011, _
77, 171, -1346.37147, _
78, 171, -1336.64213, _
79, 171, -1325.95749, _
80, 171, -1314.3195, _
66, 172, -1384.64067, _
67, 172, -1387.33332, _
68, 172, -1391.55104, _
69, 172, -1391.65951, _
70, 172, -1392.75846, _
71, 172, -1389.45807, _
72, 172, -1388.33981, _
73, 172, -1382.48522, _
74, 172, -1379.47008, _
75, 172, -1371.11686, _
76, 172, -1366.05183, _
77, 172, -1355.40522, _
78, 172, -1348.34099, _
79, 172, -1335.82986, _
80, 172, -1326.78825, _
66, 173, -1388.64198, _
67, 173, -1393.27164, _
68, 173, -1396.79229, _
69, 173, -1398.61038, _
70, 173, -1399.12583, _
71, 173, -1397.67383, _
72, 173, -1395.42069, _
73, 173, -1391.62309, _
74, 173, -1387.17159, _
75, 173, -1381.21573, _
76, 173, -1374.31769, _
77, 173, -1366.36548, _
78, 173, -1357.25797, _
79, 173, -1347.34897, _
80, 173, -1336.46013, _
67, 174, -1397.68195, _
68, 174, -1403.15861, _
69, 174, -1404.29281, _
70, 174, -1406.59046, _
71, 174, -1404.4347, _
72, 174, -1403.92688, _
73, 174, -1399.03864, _
74, 174, -1396.74262, _
75, 174, -1389.40628, _
76, 174, -1384.94592, _
77, 174, -1375.03723, _
78, 174, -1368.70459, _
79, 174, -1356.83979, _
80, 174, -1348.46789, _
67, 175, -1403.26627, _
68, 175, -1407.93292, _
69, 175, -1410.81016, _
70, 175, -1412.41282, _
71, 175, -1412.10144, _
72, 175, -1410.63538, _
73, 175, -1407.77784, _
74, 175, -1404.21964, _
75, 175, -1399.0928, _
76, 175, -1393.12733, _
77, 175, -1385.63425, _
78, 175, -1377.15764, _
79, 175, -1368.09059, _
80, 175, -1357.86566, _
68, 176, -1413.98324, _
69, 176, -1415.93959, _
70, 176, -1419.27724, _
71, 176, -1418.38942, _
72, 176, -1418.8013, _
73, 176, -1414.80588, _
74, 176, -1413.29976, _
75, 176, -1406.9387, _
76, 176, -1403.19141, _
77, 176, -1394.17057, _
78, 176, -1388.4625, _
79, 176, -1377.14303, _
80, 176, -1369.73736, _
81, 176, -1356.60046, _
68, 177, -1418.28156, _
69, 177, -1422.11021, _
70, 177, -1424.84364, _
71, 177, -1425.46232, _
72, 177, -1425.17721, _
73, 177, -1423.22887, _
74, 177, -1420.4312, _
75, 177, -1416.2163, _
76, 177, -1411.11403, _
77, 177, -1404.42986, _
78, 177, -1396.97053, _
79, 177, -1388.36279, _
80, 177, -1378.81799, _
81, 177, -1368.57771, _
69, 178, -1426.82853, _
70, 178, -1431.62404, _
71, 178, -1431.48762, _
72, 178, -1432.80317, _
73, 178, -1430.18414, _
74, 178, -1429.21017, _
75, 178, -1423.6719, _
76, 178, -1420.78007, _
77, 178, -1412.70564, _
78, 178, -1407.66867, _
79, 178, -1397.21518, _
80, 178, -1390.42298, _
81, 178, -1378.11837, _
82, 178, -1368.97324, _
69, 179, -1432.38485, _
70, 179, -1436.5385, _
71, 179, -1438.28007, _
72, 179, -1438.90216, _
73, 179, -1438.01423, _
74, 179, -1436.16953, _
75, 179, -1432.67459, _
76, 179, -1428.32672, _
77, 179, -1422.60438, _
78, 179, -1416.01065, _
79, 179, -1407.94896, _
80, 179, -1399.10204, _
81, 179, -1389.67602, _
82, 179, -1378.56302, _
70, 180, -1442.67282, _
71, 180, -1443.96926, _
72, 180, -1446.28992, _
73, 180, -1444.66197, _
74, 180, -1444.58199, _
75, 180, -1439.99844, _
76, 180, -1437.74069, _
77, 180, -1430.57392, _
78, 180, -1426.24955, _
79, 180, -1416.62599, _
80, 180, -1410.49972, _
81, 180, -1398.72929, _
82, 180, -1390.61445, _
70, 181, -1447.23213, _
71, 181, -1450.1592, _
72, 181, -1451.98472, _
73, 181, -1452.23872, _
74, 181, -1451.2682, _
75, 181, -1448.75338, _
76, 181, -1445.00002, _
77, 181, -1440.13934, _
78, 181, -1434.25974, _
79, 181, -1426.9742, _
80, 181, -1418.98179, _
81, 181, -1410.33707, _
82, 181, -1399.87339, _
71, 182, -1455.3131, _
72, 182, -1458.70272, _
73, 182, -1458.30166, _
74, 182, -1459.33378, _
75, 182, -1455.75143, _
76, 182, -1454.13044, _
77, 182, -1447.7907, _
78, 182, -1444.12489, _
79, 182, -1435.4751, _
80, 182, -1429.9687, _
81, 182, -1418.91774, _
82, 182, -1411.65285, _
71, 183, -1461.22053, _
72, 183, -1464.00819, _
73, 183, -1465.23584, _
74, 183, -1465.52459, _
75, 183, -1464.18625, _
76, 183, -1461.25673, _
77, 183, -1457.01365, _
78, 183, -1451.80034, _
79, 183, -1445.43478, _
80, 183, -1438.26783, _
81, 183, -1430.26822, _
82, 183, -1420.4697, _
71, 184, -1465.98774, _
72, 184, -1470.29495, _
73, 184, -1470.8526, _
74, 184, -1472.93626, _
75, 184, -1470.67107, _
76, 184, -1469.92065, _
77, 184, -1464.49251, _
78, 184, -1461.43814, _
79, 184, -1453.63567, _
80, 184, -1448.8833, _
81, 184, -1438.62549, _
82, 184, -1432.02145, _
83, 184, -1419.00015, _
71, 185, -1471.53505, _
72, 185, -1475.18451, _
73, 185, -1477.47881, _
74, 185, -1478.68996, _
75, 185, -1478.34028, _
76, 185, -1476.54516, _
77, 185, -1473.28853, _
78, 185, -1468.85877, _
79, 185, -1463.25509, _
80, 185, -1456.78149, _
81, 185, -1449.58146, _
82, 185, -1440.58245, _
83, 185, -1430.4949, _
72, 186, -1481.36024, _
73, 186, -1482.76348, _
74, 186, -1485.88214, _
75, 186, -1484.51963, _
76, 186, -1484.80902, _
77, 186, -1480.19906, _
78, 186, -1478.10642, _
79, 186, -1471.17445, _
80, 186, -1467.21611, _
81, 186, -1457.78152, _
82, 186, -1451.79446, _
83, 186, -1439.4566, _
84, 186, -1431.45559, _
72, 187, -1485.82434, _
73, 187, -1489.1252, _
74, 187, -1491.34893, _
75, 187, -1491.87885, _
76, 187, -1491.09897, _
77, 187, -1488.64498, _
78, 187, -1484.99831, _
79, 187, -1480.55875, _
80, 187, -1474.86625, _
81, 187, -1468.40932, _
82, 187, -1460.17078, _
83, 187, -1450.78489, _
84, 187, -1440.78646, _
72, 188, -1491.95766, _
73, 188, -1493.90834, _
74, 188, -1498.18384, _
75, 188, -1497.7505, _
76, 188, -1499.08854, _
77, 188, -1495.51831, _
78, 188, -1494.21359, _
79, 188, -1487.87907, _
80, 188, -1485.03114, _
81, 188, -1476.37394, _
82, 188, -1471.07019, _
83, 188, -1459.65751, _
84, 188, -1452.23489, _
72, 189, -1496.31198, _
73, 189, -1500.19663, _
74, 189, -1503.20282, _
75, 189, -1504.78365, _
76, 189, -1505.00905, _
77, 189, -1503.69495, _
78, 189, -1500.94132, _
79, 189, -1497.2555, _
80, 189, -1492.51744, _
81, 189, -1486.71104, _
82, 189, -1479.20467, _
83, 189, -1470.60897, _
84, 189, -1461.18381, _
73, 190, -1504.95195, _
74, 190, -1510.03749, _
75, 190, -1510.50925, _
76, 190, -1512.80135, _
77, 190, -1510.06518, _
78, 190, -1509.85245, _
79, 190, -1504.6281, _
80, 190, -1502.33269, _
81, 190, -1494.55917, _
82, 190, -1489.81431, _
83, 190, -1479.21443, _
84, 190, -1472.39692, _
73, 191, -1511.00226, _
74, 191, -1514.90409, _
75, 191, -1517.29763, _
76, 191, -1518.56008, _
77, 191, -1518.09171, _
78, 191, -1516.29998, _
79, 191, -1513.62732, _
80, 191, -1509.62675, _
81, 191, -1504.53434, _
82, 191, -1497.70492, _
83, 191, -1489.92654, _
84, 191, -1480.97321, _
85, 191, -1471.25835, _
73, 192, -1515.73858, _
74, 192, -1521.44823, _
75, 192, -1522.60571, _
76, 192, -1526.11849, _
77, 192, -1524.28984, _
78, 192, -1524.96202, _
79, 192, -1520.66333, _
80, 192, -1519.11622, _
81, 192, -1512.19505, _
82, 192, -1508.1059, _
83, 192, -1498.2936, _
84, 192, -1492.0463, _
85, 192, -1480.25763, _
74, 193, -1526.15755, _
75, 193, -1529.32357, _
76, 193, -1531.7019, _
77, 193, -1532.06183, _
78, 193, -1531.22286, _
79, 193, -1529.36475, _
80, 193, -1526.23932, _
81, 193, -1521.87134, _
82, 193, -1515.80627, _
83, 193, -1508.70226, _
84, 193, -1500.40661, _
85, 193, -1491.33235, _
86, 193, -1481.43947, _
74, 194, -1532.46787, _
75, 194, -1534.39652, _
76, 194, -1538.81437, _
77, 194, -1538.12862, _
78, 194, -1539.57505, _
79, 194, -1536.24329, _
80, 194, -1535.43173, _
81, 194, -1529.40293, _
82, 194, -1525.89053, _
83, 194, -1516.93675, _
84, 194, -1511.12298, _
85, 194, -1500.04759, _
86, 194, -1492.83025, _
75, 195, -1540.80984, _
76, 195, -1543.96009, _
77, 195, -1545.36048, _
78, 195, -1545.6801, _
79, 195, -1544.67093, _
80, 195, -1542.31872, _
81, 195, -1538.69185, _
82, 195, -1533.46753, _
83, 195, -1526.99761, _
84, 195, -1519.25072, _
85, 195, -1510.8832, _
86, 195, -1501.57477, _
75, 196, -1545.84416, _
76, 196, -1550.7986, _
77, 196, -1551.17536, _
78, 196, -1553.60203, _
79, 196, -1551.3127, _
80, 196, -1551.21719, _
81, 196, -1546.10467, _
82, 196, -1543.18637, _
83, 196, -1535.05241, _
84, 196, -1529.74357, _
85, 196, -1519.39132, _
86, 196, -1512.7253, _
75, 197, -1551.87547, _
76, 197, -1555.90013, _
77, 197, -1558.07458, _
78, 197, -1559.44839, _
79, 197, -1559.38506, _
80, 197, -1558.00278, _
81, 197, -1555.01927, _
82, 197, -1550.64576, _
83, 197, -1544.80173, _
84, 197, -1537.69042, _
85, 197, -1529.89424, _
86, 197, -1521.2916, _
75, 198, -1556.58379, _
76, 198, -1562.49944, _
77, 198, -1563.7011, _
78, 198, -1567.00344, _
79, 198, -1565.8974, _
80, 198, -1566.4879, _
81, 198, -1562.24556, _
82, 198, -1560.01845, _
83, 198, -1552.5555, _
84, 198, -1547.8766, _
85, 198, -1538.34232, _
86, 198, -1532.06934, _
76, 199, -1567.21776, _
77, 199, -1570.35162, _
78, 199, -1572.55944, _
79, 199, -1573.48167, _
80, 199, -1573.15076, _
81, 199, -1570.88142, _
82, 199, -1567.27136, _
83, 199, -1562.05479, _
84, 199, -1555.68897, _
85, 199, -1548.51607, _
86, 199, -1540.41013, _
87, 199, -1531.36661, _
76, 200, -1573.58408, _
77, 200, -1575.63373, _
78, 200, -1579.84124, _
79, 200, -1579.69822, _
80, 200, -1581.17928, _
81, 200, -1577.9409, _
82, 200, -1576.36153, _
83, 200, -1569.69933, _
84, 200, -1565.50062, _
85, 200, -1556.75193, _
86, 200, -1550.99595, _
87, 200, -1540.06444, _
76, 201, -1578.1154, _
77, 201, -1581.99105, _
78, 201, -1585.05259, _
79, 201, -1586.93024, _
80, 201, -1587.40974, _
81, 201, -1586.1436, _
82, 201, -1583.44171, _
83, 201, -1578.81463, _
84, 201, -1573.14251, _
85, 201, -1566.62463, _
86, 201, -1559.12541, _
87, 201, -1550.66887, _
88, 201, -1541.64724, _
76, 202, -1584.03471, _
77, 202, -1586.94137, _
78, 202, -1592.07514, _
79, 202, -1592.95365, _
80, 202, -1595.16382, _
81, 202, -1593.02239, _
82, 202, -1592.19385, _
83, 202, -1586.21206, _
84, 202, -1582.61307, _
85, 202, -1574.4974, _
86, 202, -1569.39853, _
87, 202, -1559.2499, _
88, 202, -1552.46841, _
77, 203, -1592.92668, _
78, 203, -1597.08134, _
79, 203, -1599.81547, _
80, 203, -1601.15843, _
81, 203, -1600.86814, _
82, 203, -1599.11096, _
83, 203, -1595.06684, _
84, 203, -1590.07102, _
85, 203, -1584.14044, _
86, 203, -1577.35484, _
87, 203, -1569.53693, _
88, 203, -1560.96399, _
77, 204, -1595.996, _
78, 204, -1603.44765, _
79, 204, -1605.39331, _
80, 204, -1608.65116, _
81, 204, -1607.52423, _
82, 204, -1607.50564, _
83, 204, -1602.2595, _
84, 204, -1599.17238, _
85, 204, -1591.92466, _
86, 204, -1587.24986, _
87, 204, -1577.87714, _
88, 204, -1571.65505, _
78, 205, -1606.56297, _
79, 205, -1611.58462, _
80, 205, -1614.31975, _
81, 205, -1615.07028, _
82, 205, -1614.2373, _
83, 205, -1610.7494, _
84, 205, -1606.4121, _
85, 205, -1601.0908, _
86, 205, -1595.05205, _
87, 205, -1587.86566, _
88, 205, -1579.93467, _
78, 206, -1611.30029, _
79, 206, -1615.10094, _
80, 206, -1621.04879, _
81, 206, -1621.57409, _
82, 206, -1622.32396, _
83, 206, -1617.78431, _
84, 206, -1615.16257, _
85, 206, -1608.62085, _
86, 206, -1604.52491, _
87, 206, -1595.86966, _
88, 206, -1590.27901, _
89, 206, -1579.60048, _
79, 207, -1619.76226, _
80, 207, -1624.66236, _
81, 207, -1628.42597, _
82, 207, -1629.06174, _
83, 207, -1625.88198, _
84, 207, -1622.19083, _
85, 207, -1617.49008, _
86, 207, -1612.11555, _
87, 207, -1605.54282, _
88, 207, -1598.37724, _
89, 207, -1589.98769, _
79, 208, -1623.12958, _
80, 208, -1629.51163, _
81, 208, -1632.21307, _
82, 208, -1636.42961, _
83, 208, -1632.7689, _
84, 208, -1630.58599, _
85, 208, -1624.80412, _
86, 208, -1621.20738, _
87, 208, -1613.43562, _
88, 208, -1608.27246, _
89, 208, -1598.44598, _
90, 208, -1591.74876, _
79, 209, -1627.56789, _
80, 209, -1632.96155, _
81, 209, -1637.17287, _
82, 209, -1640.36697, _
83, 209, -1640.22866, _
84, 209, -1637.55373, _
85, 209, -1633.28817, _
86, 209, -1628.55229, _
87, 209, -1622.60908, _
88, 209, -1616.20468, _
89, 209, -1608.43211, _
90, 209, -1599.95729, _
79, 210, -1630.84221, _
80, 210, -1637.75386, _
81, 210, -1640.85256, _
82, 210, -1645.55215, _
83, 210, -1644.83329, _
84, 210, -1645.21217, _
85, 210, -1640.44879, _
86, 210, -1637.29932, _
87, 210, -1630.24494, _
88, 210, -1625.66978, _
89, 210, -1616.55812, _
90, 210, -1610.50576, _
80, 211, -1641.08418, _
81, 211, -1645.75583, _
82, 211, -1649.38679, _
83, 211, -1649.9713, _
84, 211, -1649.76292, _
85, 211, -1648.19528, _
86, 211, -1644.52111, _
87, 211, -1639.12357, _
88, 211, -1633.36938, _
89, 211, -1626.21684, _
90, 211, -1618.73, _
80, 212, -1645.7745, _
81, 212, -1649.30015, _
82, 212, -1654.51404, _
83, 212, -1654.30147, _
84, 212, -1655.77115, _
85, 212, -1653.24755, _
86, 212, -1652.49666, _
87, 212, -1646.57085, _
88, 212, -1642.4714, _
89, 212, -1634.21246, _
90, 212, -1628.61016, _
91, 212, -1618.31223, _
80, 213, -1648.93681, _
81, 213, -1654.03666, _
82, 213, -1658.23976, _
83, 213, -1659.48605, _
84, 213, -1660.12651, _
85, 213, -1659.27024, _
86, 213, -1657.60662, _
87, 213, -1654.67907, _
88, 213, -1649.98611, _
89, 213, -1643.40543, _
90, 213, -1636.66134, _
91, 213, -1628.33387, _
80, 214, -1653.49613, _
81, 214, -1657.42678, _
82, 214, -1663.29022, _
83, 214, -1663.52692, _
84, 214, -1666.01435, _
85, 214, -1664.1418, _
86, 214, -1664.29943, _
87, 214, -1660.1559, _
88, 214, -1658.32246, _
89, 214, -1651.18848, _
90, 214, -1646.13834, _
91, 214, -1636.58288, _
80, 215, -1656.53745, _
81, 215, -1662.0521, _
82, 215, -1666.76476, _
83, 215, -1668.74983, _
84, 215, -1670.15619, _
85, 215, -1670.08858, _
86, 215, -1669.21956, _
87, 215, -1666.9506, _
88, 215, -1663.95262, _
89, 215, -1659.67336, _
90, 215, -1654.00043, _
91, 215, -1646.27085, _
80, 216, -1660.95777, _
81, 216, -1665.31642, _
82, 216, -1671.77207, _
83, 216, -1672.59573, _
84, 216, -1675.9034, _
85, 216, -1674.64751, _
86, 216, -1675.86945, _
87, 216, -1672.369, _
88, 216, -1671.26663, _
89, 216, -1665.63114, _
90, 216, -1662.6947, _
91, 216, -1654.41112, _
81, 217, -1669.79274, _
82, 217, -1675.08339, _
83, 217, -1677.81108, _
84, 217, -1679.87337, _
85, 217, -1680.58042, _
86, 217, -1680.53508, _
87, 217, -1679.09671, _
88, 217, -1676.74159, _
89, 217, -1673.1432, _
90, 217, -1668.84649, _
91, 217, -1663.2123, _
92, 217, -1656.52892, _
81, 218, -1673.08505, _
82, 218, -1679.94171, _
83, 218, -1681.39632, _
84, 218, -1685.47121, _
85, 218, -1684.94858, _
86, 218, -1687.04748, _
87, 218, -1684.4235, _
88, 218, -1684.04917, _
89, 218, -1679.07416, _
90, 218, -1676.76911, _
91, 218, -1669.66914, _
92, 218, -1665.65927, _
82, 219, -1683.18702, _
83, 219, -1686.40068, _
84, 219, -1689.21997, _
85, 219, -1690.72179, _
86, 219, -1691.50574, _
87, 219, -1690.93571, _
88, 219, -1689.37738, _
89, 219, -1686.41976, _
90, 219, -1682.73418, _
91, 219, -1677.88442, _
92, 219, -1672.35602, _
93, 219, -1665.58321, _
82, 220, -1687.86834, _
83, 220, -1689.93599, _
84, 220, -1694.70919, _
85, 220, -1694.81455, _
86, 220, -1697.79439, _
87, 220, -1696.14243, _
88, 220, -1696.57273, _
89, 220, -1692.31686, _
90, 220, -1690.60926, _
91, 220, -1684.27822, _
92, 220, -1680.77987, _
93, 220, -1672.62053, _
83, 221, -1694.72831, _
84, 221, -1698.27021, _
85, 221, -1700.47889, _
86, 221, -1702.00658, _
87, 221, -1702.41832, _
88, 221, -1701.95034, _
89, 221, -1699.60877, _
90, 221, -1696.41153, _
91, 221, -1692.19116, _
92, 221, -1687.30219, _
93, 221, -1681.15785, _
83, 222, -1698.22663, _
84, 222, -1703.62902, _
85, 222, -1704.37991, _
86, 222, -1708.17656, _
87, 222, -1707.41848, _
88, 222, -1708.66432, _
89, 222, -1705.5818, _
90, 222, -1704.21789, _
91, 222, -1698.48386, _
92, 222, -1695.63451, _
93, 222, -1688.05516, _
83, 223, -1702.83195, _
84, 223, -1707.1076, _
85, 223, -1709.97625, _
86, 223, -1712.23217, _
87, 223, -1713.45558, _
88, 223, -1713.8224, _
89, 223, -1712.44817, _
90, 223, -1710.1064, _
91, 223, -1706.38914, _
92, 223, -1702.08894, _
93, 223, -1696.54548, _
83, 224, -1706.27426, _
84, 224, -1712.34792, _
85, 224, -1713.76455, _
86, 224, -1718.24812, _
87, 224, -1718.11578, _
88, 224, -1720.3012, _
89, 224, -1718.11119, _
90, 224, -1717.56989, _
91, 224, -1712.91884, _
92, 224, -1710.2851, _
93, 224, -1703.3408, _
84, 225, -1715.79923, _
85, 225, -1719.15189, _
86, 225, -1722.2304, _
87, 225, -1724.16139, _
88, 225, -1725.20554, _
89, 225, -1724.77891, _
90, 225, -1723.3246, _
91, 225, -1720.51193, _
92, 225, -1716.69259, _
93, 225, -1711.70032, _
84, 226, -1720.85155, _
85, 226, -1723.0042, _
86, 226, -1728.08866, _
87, 226, -1728.51296, _
88, 226, -1731.60159, _
89, 226, -1730.17833, _
90, 226, -1730.50912, _
91, 226, -1726.89065, _
92, 226, -1724.81258, _
93, 226, -1718.58243, _
84, 227, -1724.19087, _
85, 227, -1728.20652, _
86, 227, -1732.02134, _
87, 227, -1734.43905, _
88, 227, -1736.16302, _
89, 227, -1736.70905, _
90, 227, -1735.97147, _
91, 227, -1734.16343, _
92, 227, -1731.19075, _
93, 227, -1726.86839, _
85, 228, -1732.07684, _
86, 228, -1737.73503, _
87, 228, -1738.82707, _
88, 228, -1742.4716, _
89, 228, -1741.73507, _
90, 228, -1743.07678, _
91, 228, -1740.14231, _
92, 228, -1739.06205, _
93, 228, -1733.906, _
94, 228, -1730.64064, _
85, 229, -1737.00915, _
86, 229, -1741.68741, _
87, 229, -1744.5931, _
88, 229, -1746.93661, _
89, 229, -1748.00456, _
90, 229, -1748.33364, _
91, 229, -1747.23969, _
92, 229, -1745.14483, _
93, 229, -1741.79355, _
94, 229, -1737.3975, _
86, 230, -1747.07313, _
87, 230, -1748.8282, _
88, 230, -1753.04013, _
89, 230, -1752.9357, _
90, 230, -1755.1275, _
91, 230, -1753.03461, _
92, 230, -1752.81205, _
93, 230, -1748.40821, _
94, 230, -1745.92835, _
95, 230, -1739.14801, _
86, 231, -1750.73844, _
87, 231, -1754.34569, _
88, 231, -1757.41126, _
89, 231, -1759.08255, _
90, 231, -1760.24551, _
91, 231, -1759.85475, _
92, 231, -1758.69085, _
93, 231, -1756.09069, _
94, 231, -1752.64786, _
95, 231, -1747.71232, _
87, 232, -1758.49541, _
88, 232, -1763.20211, _
89, 232, -1763.7623, _
90, 232, -1766.68566, _
91, 232, -1765.40405, _
92, 232, -1765.95881, _
93, 232, -1762.42633, _
94, 232, -1760.6418, _
95, 232, -1754.95464, _
96, 232, -1751.03629, _
87, 233, -1763.51873, _
88, 233, -1767.44804, _
89, 233, -1769.68, _
90, 233, -1771.47205, _
91, 233, -1771.9333, _
92, 233, -1771.72074, _
93, 233, -1769.90866, _
94, 233, -1767.02419, _
95, 233, -1763.03096, _
96, 233, -1758.21966, _
88, 234, -1772.94843, _
89, 234, -1774.21816, _
90, 234, -1777.66256, _
91, 234, -1777.1543, _
92, 234, -1778.56549, _
93, 234, -1775.97329, _
94, 234, -1774.79773, _
95, 234, -1769.90427, _
96, 234, -1766.85897, _
97, 234, -1759.45658, _
88, 235, -1776.70902, _
89, 235, -1779.77352, _
90, 235, -1782.33058, _
91, 235, -1783.27708, _
92, 235, -1783.86298, _
93, 235, -1782.95641, _
94, 235, -1781.03511, _
95, 235, -1777.81035, _
96, 235, -1773.64324, _
97, 235, -1768.1679, _
89, 236, -1783.981, _
90, 236, -1788.16444, _
91, 236, -1788.30335, _
92, 236, -1790.40843, _
93, 236, -1788.69316, _
94, 236, -1788.3874, _
95, 236, -1784.46591, _
96, 236, -1781.87054, _
97, 236, -1775.40122, _
89, 237, -1788.99531, _
90, 237, -1792.53587, _
91, 237, -1794.18099, _
92, 237, -1795.53421, _
93, 237, -1795.27045, _
94, 237, -1794.26811, _
95, 237, -1792.00823, _
96, 237, -1788.54945, _
97, 237, -1783.82653, _
98, 237, -1778.29532, _
90, 238, -1797.93628, _
91, 238, -1798.88589, _
92, 238, -1801.68847, _
93, 238, -1800.75877, _
94, 238, -1801.26794, _
95, 238, -1798.22725, _
96, 238, -1796.42317, _
97, 238, -1790.86985, _
98, 238, -1787.0255, _
90, 239, -1802.02659, _
91, 239, -1804.51425, _
92, 239, -1806.49485, _
93, 239, -1806.97397, _
94, 239, -1806.91413, _
95, 239, -1805.32967, _
96, 239, -1802.79107, _
97, 239, -1798.90617, _
98, 239, -1794.12882, _
99, 239, -1788.03647, _
91, 240, -1809.11956, _
92, 240, -1812.42384, _
93, 240, -1812.04011, _
94, 240, -1813.44834, _
95, 240, -1811.2812, _
96, 240, -1810.28527, _
97, 240, -1805.56248, _
98, 240, -1802.4553, _
99, 240, -1795.46479, _
91, 241, -1814.30388, _
92, 241, -1817.01453, _
93, 241, -1818.16721, _
94, 241, -1818.68986, _
95, 241, -1817.9283, _
96, 241, -1816.37856, _
97, 241, -1813.2658, _
98, 241, -1809.19045, _
99, 241, -1803.87211, _
100, 241, -1797.82676, _
92, 242, -1822.66185, _
93, 242, -1823.08193, _
94, 242, -1824.99958, _
95, 242, -1823.46594, _
96, 242, -1823.34805, _
97, 242, -1819.63612, _
98, 242, -1817.20205, _
99, 242, -1811.00542, _
100, 242, -1806.62408, _
92, 243, -1826.95317, _
93, 243, -1828.69482, _
94, 243, -1830.0335, _
95, 243, -1829.83081, _
96, 243, -1829.04099, _
97, 243, -1826.75106, _
98, 243, -1823.66909, _
99, 243, -1819.12974, _
100, 243, -1813.7314, _
93, 244, -1833.44114, _
94, 244, -1836.05398, _
95, 244, -1835.1973, _
96, 244, -1835.84226, _
97, 244, -1832.79806, _
98, 244, -1831.25205, _
99, 244, -1825.92206, _
100, 244, -1822.20071, _
93, 245, -1838.76446, _
94, 245, -1840.75254, _
95, 245, -1841.24748, _
96, 245, -1841.36252, _
97, 245, -1839.76943, _
98, 245, -1837.41579, _
99, 245, -1833.65238, _
100, 245, -1829.05103, _
101, 245, -1823.18368, _
94, 246, -1846.60746, _
95, 246, -1846.22608, _
96, 246, -1847.82013, _
97, 246, -1845.68778, _
98, 246, -1844.7821, _
99, 246, -1840.18969, _
100, 246, -1837.12083, _
101, 246, -1830.412, _
94, 247, -1850.96674, _
95, 247, -1852.1384, _
96, 247, -1852.9756, _
97, 247, -1852.23687, _
98, 247, -1850.84145, _
99, 247, -1847.58454, _
100, 247, -1843.70666, _
101, 247, -1838.66132, _
95, 248, -1856.80071, _
96, 248, -1859.1879, _
97, 248, -1857.71802, _
98, 248, -1857.77672, _
99, 248, -1853.93333, _
100, 248, -1851.55325, _
101, 248, -1845.52063, _
102, 248, -1841.26629, _
95, 249, -1862.33103, _
96, 249, -1863.90127, _
97, 249, -1864.01977, _
98, 249, -1863.36203, _
99, 249, -1861.12864, _
100, 249, -1858.00276, _
101, 249, -1853.50695, _
102, 249, -1848.1766, _
96, 250, -1869.7337, _
97, 250, -1868.99012, _
98, 250, -1869.98735, _
99, 250, -1867.14996, _
100, 250, -1865.52125, _
101, 250, -1860.18027, _
102, 250, -1856.46692, _
96, 251, -1874.14599, _
97, 251, -1874.78364, _
98, 251, -1875.0943, _
99, 251, -1873.93473, _
100, 251, -1871.71201, _
101, 251, -1867.91676, _
102, 251, -1863.25124, _
103, 251, -1857.59089, _
96, 252, -1879.81064, _
97, 252, -1879.54929, _
98, 252, -1881.2667, _
99, 252, -1879.22435, _
100, 252, -1878.91968, _
101, 252, -1874.4439, _
102, 252, -1871.30041, _
103, 252, -1864.65221, _
97, 253, -1885.22661, _
98, 253, -1886.07098, _
99, 253, -1885.57627, _
100, 253, -1884.45965, _
101, 253, -1881.85122, _
102, 253, -1877.88395, _
103, 253, -1872.88453, _
104, 253, -1867.12218, _
97, 254, -1889.83392, _
98, 254, -1892.10255, _
99, 254, -1890.67008, _
100, 254, -1890.97553, _
101, 254, -1887.64354, _
102, 254, -1885.59054, _
103, 254, -1879.65984, _
104, 254, -1875.5525, _
98, 255, -1896.70489, _
99, 255, -1896.64296, _
100, 255, -1896.15024, _
101, 255, -1894.32451, _
102, 255, -1891.57927, _
103, 255, -1887.65686, _
104, 255, -1882.49081, _
105, 255, -1876.30647, _
98, 256, -1902.54621, _
99, 256, -1901.61786, _
100, 256, -1902.53515, _
101, 256, -1899.78317, _
102, 256, -1898.6339, _
103, 256, -1893.92888, _
104, 256, -1890.67045, _
105, 256, -1883.61178, _
99, 257, -1907.47318, _
100, 257, -1907.50309, _
101, 257, -1906.31433, _
102, 257, -1904.27871, _
103, 257, -1901.13979, _
104, 257, -1897.09684, _
105, 257, -1891.9741, _
99, 258, -1912.2455, _
100, 258, -1913.73815, _
101, 258, -1911.69446, _
102, 258, -1911.12146, _
103, 258, -1907.03411, _
104, 258, -1904.6935, _
105, 258, -1898.45442, _
106, 258, -1894.22807, _
100, 259, -1918.53147, _
101, 259, -1917.82912, _
102, 259, -1916.56078, _
103, 259, -1914.03643, _
104, 259, -1910.74508, _
105, 259, -1906.33372, _
106, 259, -1900.98339, _
100, 260, -1924.54179, _
101, 260, -1922.97344, _
102, 260, -1923.13109, _
103, 260, -1919.68375, _
104, 260, -1918.0294, _
105, 260, -1912.72305, _
106, 260, -1909.0656, _
107, 260, -1901.50736, _
101, 261, -1929.01876, _
102, 261, -1928.35841, _
103, 261, -1926.47006, _
104, 261, -1923.92795, _
105, 261, -1920.21737, _
106, 261, -1915.6788, _
107, 261, -1909.76768, _
101, 262, -1934.04107, _
102, 262, -1934.78373, _
103, 262, -1932.00038, _
104, 262, -1930.92703, _
105, 262, -1926.28169, _
106, 262, -1923.38942, _
107, 262, -1916.43099, _
102, 263, -1939.82704, _
103, 263, -1938.4447, _
104, 263, -1936.60435, _
105, 263, -1933.498, _
106, 263, -1929.63766, _
107, 263, -1924.54931, _
108, 263, -1918.54496, _
102, 264, -1946.01736, _
103, 264, -1943.86901, _
104, 264, -1943.38667, _
105, 264, -1939.31932, _
106, 264, -1937.11497, _
107, 264, -1931.05863, _
108, 264, -1926.77058, _
103, 265, -1950.08433, _
104, 265, -1948.84399, _
105, 265, -1946.26564, _
106, 265, -1943.17329, _
107, 265, -1938.83095, _
108, 265, -1933.50421, _
109, 265, -1926.94325, _
103, 266, -1954.76665, _
104, 266, -1955.5293, _
105, 266, -1952.08596, _
106, 266, -1950.42261, _
107, 266, -1945.15126, _
108, 266, -1941.33947, _
109, 266, -1933.73157, _
104, 267, -1960.23262, _
105, 267, -1958.82027, _
106, 267, -1956.27493, _
107, 267, -1952.56358, _
108, 267, -1947.89523, _
109, 267, -1941.97489, _
110, 267, -1935.06454, _
104, 268, -1966.27294, _
105, 268, -1963.90459, _
106, 268, -1963.38224, _
107, 268, -1958.5949, _
108, 268, -1955.78855, _
109, 268, -1948.6862, _
110, 268, -1943.40586, _
105, 269, -1969.88991, _
106, 269, -1968.44056, _
107, 269, -1965.99121, _
108, 269, -1962.10087, _
109, 269, -1956.59652, _
110, 269, -1950.29044, _
105, 270, -1974.75222, _
106, 270, -1974.83488, _
107, 270, -1971.31753, _
108, 270, -1969.67218, _
109, 270, -1963.26584, _
110, 270, -1958.51822, _
106, 271, -1979.64019, _
107, 271, -1977.62585, _
108, 271, -1975.0605, _
109, 271, -1970.94915, _
110, 271, -1965.32181, _
106, 272, -1985.88951, _
107, 272, -1982.89517, _
108, 272, -1981.89782, _
109, 272, -1976.54047, _
110, 272, -1973.32413, _
111, 272, -1965.78478, _
106, 273, -1990.52283, _
107, 273, -1989.12548, _
108, 273, -1987.00314, _
109, 273, -1983.68679, _
110, 273, -1979.02844, _
111, 273, -1973.9931, _
107, 274, -1994.1158, _
108, 274, -1993.56045, _
109, 274, -1989.10711, _
110, 274, -1986.30776, _
111, 274, -1980.08341, _
107, 275, -2000.21012, _
108, 275, -1998.49777, _
109, 275, -1995.71142, _
110, 275, -1991.93608, _
111, 275, -1987.51473, _
108, 276, -2004.90509, _
109, 276, -2001.19874, _
110, 276, -1999.08339, _
111, 276, -1993.35605, _
112, 276, -1989.7087, _
108, 277, -2009.7684, _
109, 277, -2007.71106, _
110, 277, -2004.46371, _
111, 277, -2000.74236, _
112, 277, -1995.70202, _
109, 278, -2012.95137, _
110, 278, -2011.48603, _
111, 278, -2006.55568, _
112, 278, -2003.29333, _
113, 278, -1996.52799, _
109, 279, -2019.37569, _
110, 279, -2016.70934, _
111, 279, -2013.483, _
112, 279, -2009.14165, _
113, 279, -2004.25331, _
110, 280, -2023.65066, _
111, 280, -2019.30332, _
112, 280, -2016.64897, _
113, 280, -2010.48062, _
110, 281, -2028.74098, _
111, 281, -2026.23663, _
112, 281, -2022.30029, _
113, 281, -2018.03894, _
111, 282, -2031.73695, _
112, 282, -2029.6726, _
113, 282, -2024.06826, _
111, 283, -2038.48127, _
112, 283, -2035.15992, _
113, 283, -2031.30257, _
112, 284, -2042.40624, _
113, 284, -2037.36589, _
112, 285, -2047.71955, _
113, 285, -2044.50521, _
114, 285, -2040.07586, _
113, 286, -2050.26652, _
114, 286, -2047.59618, _
113, 287, -2057.23784, _
114, 287, -2053.2935, _
115, 287, -2048.85915, _
114, 288, -2060.62981, _
115, 288, -2055.03347, _
114, 289, -2066.04913, _
115, 289, -2062.27778, _
116, 289, -2057.27144, _
115, 290, -2068.1621, _
116, 290, -2064.89975, _
115, 291, -2075.21342, _
116, 291, -2070.69907, _
117, 291, -2065.76472, _
116, 292, -2078.15139, _
117, 292, -2072.03904, _
116, 293, -2083.6647, _
117, 293, -2079.39136, _
118, 293, -2073.64701, _
117, 294, -2085.38868, _
118, 294, -2081.38433, _
 -1,  -1,          -1
