#define B_plotting

Declare Sub Logcircle(X As Single, Y As Single, R As Single)
Declare Sub Lincircle(X As Single, Y As Single, R As Single)
Declare Sub Logline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Logline2(X As Single, Y As Single)
Declare Sub Logline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
Declare Sub Logcross(X As Single, Y As Single, DY As Single)
Declare Sub Plotexp(CCN As String)

Declare Sub Chisqr_Apost(CCN As String, Byref Chilin As Single, Byref Chilog As Single)
Declare Sub PrintChisqr(Chi As Single)

Sub PrintChisqr(Chi As Single)
  Draw String (150,1.12), "Chi-sqr="+Str(Round(Chi,2))
  Draw String (150,0.95), "(GEF-ENDF," 
  Draw String (150,0.8), " Yields>0.01%)"
End Sub

Sub Chisqr_Apost(CCN As String, Byref Chilin As Single, Byref Chilog As Single)
    Dim As Integer Afirst, Alast, I, N
    Dim As Single Diff,Logdiff 
    Read Afirst
    Read Alast
    Redim As Single VYA(Afirst to Alast)
    Redim As Single VDYA(Afirst to Alast)
    For I = Afirst to Alast
       Read VYA(I)
    Next
    For I = Afirst to Alast
       Read VDYA(I)
    Next    
    Chilin = 0
    Chilog = 0
    N = 0
    For I = Afirst to Alast
      If Apost(I) > 0.01 And VYA(I) > 0.01 Then
        Diff = (VYA(I) - Apost(I)) / VDYA(I)
        Chilin = Chilin + Diff^2
        Logdiff = 0.5 * Log(VYA(I)/Apost(I)) / Log( (VYA(I) + VDYA(I)) / (VYA(I) - VDYA(I)) )
        Chilog = Chilog + Logdiff^2
        N = N + 1
      End If
    Next
    Chilin = Chilin / N
    Chilog = Chilog / N
End Sub

Sub Plotexp(CCN As String)
    Dim As Integer Afirst, Alast,I
    Draw String (71,1.2), "black: ENDF B VII for "+CCN
    Read Afirst
    Read Alast
    Redim As Single VYA(Afirst to Alast)
    Redim As Single VDYA(Afirst to Alast)
    For I = Afirst to Alast
       Read VYA(I)
    Next
    For I = Afirst to Alast
       Read VDYA(I)
    Next
    For I = Afirst to Alast
      Logcross(I,VYA(I),VDYA(I))
    Next I
End Sub



Sub Logcircle(X As Single, Y As Single, R As Single)
   Dim As Single U,V
   U = X
   V = Log10(Y)
   Circle (U,V),R,RGB(255,0,0),,,,F
End Sub

Sub Lincircle(X As Single, Y As Single, R As Single)
    Circle (X,Y),R,RGB(255,0,0),,,,F
End Sub

Sub Logline1(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,V1,U2,V2
  U1 = X1
  V1 = log10(Y1)
  U2 = X2
  V2 = log10(Y2)
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(0,200,0)
End Sub

Sub Logline2(X As Single, Y As Single)
  Dim As Single U,V
  U = X
  V = log10(Y)
  Line - (U,V), RGB(0,200,0)
End Sub

Sub Logline3(X1 As Single, Y1 As Single, X2 As Single, Y2 As Single)
  Dim As Single U1,V1,U2,V2
  U1 = X1
  V1 = log10(Y1)
  U2 = X2
  V2 = log10(Y2)
 ' Pset (U1,V1), RGB(200,0,0)
  Line (U1,V1) - (U2,V2), RGB(255,0,0)
End Sub

Public Sub Logcross(X As Single, Y As Single, DY As Single)
  Dim As Single U,V,V1,V2
  U = X
  V = Log10(Y)
  V1 = Log10(Y-DY)
  V2 = Log10(Y+DY)
  Line (U-0.2,V) - (U+0.2,V)
  Line (U,V1) - (U,V2)
End Sub



' Mass-Chain Yields from ENDF-B-VII
AM241F:
Data 66,172, _
 9.336039E-07,1.869247E-06,5.717186E-06,9.346409E-06,2.077514E-05,3.320435E-05, _
1.350146E-04,3.488251E-04,6.852833E-04,0.00134924,0.00364434,0.00872924, _
0.01847976,0.03438661,0.06155361,0.09556881,0.1576288,0.2360813,0.3395863, _
0.5240064,0.6388462,0.8364165,1.266185,1.370898,1.732568,2.128378,2.926356, _
2.779929,3.730787,3.759122,4.742401,4.636908,5.431832,5.412632,5.911688, _
6.104204,6.063275,6.451236,6.017781,5.342086,4.813984,5.1259,4.116734,2.334843, _
2.055456,1.001644,0.7435825,0.2855293,0.1349561,0.1596012,0.1026962,0.09242541, _
0.09242743,0.08729128,0.08729199,0.09361152,0.09916416,0.1144131,0.1255245, _
0.1931942,0.2616076,0.3805572,0.6136156,1.017952,1.867249,4.16841,4.321882, _
5.817628,7.824069,6.50579,7.684681,5.924618,6.673476,6.762042,4.94121,4.718943, _
5.444504,3.891847,3.415312,3.449104,2.917494,2.149325,1.902163,1.570895, _
1.239355,0.9463601,0.8113003,0.6292022,0.4265999,0.3984769,0.262465,0.1456183, _
0.09673206,0.07937501,0.06302162,0.03766816,0.00874109,0.00257132,0.00104072, _
6.173987E-04,2.389473E-04,1.039807E-04,4.157443E-05,1.456574E-05,8.332911E-06, _
4.88461E-06,1.976138E-06, _
 4.026554E-07,7.837776E-07,2.444077E-06,3.975529E-06,7.705555E-06,1.419372E-05, _
5.674955E-05,1.491548E-04,2.824285E-04,5.659563E-04,0.00157483,0.00358291, _
0.00783037,0.0112973,0.02582594,0.0409325,0.05269349,0.09023897,0.1410213, _
0.1834563,0.2128865,0.1911313,0.5357544,0.5922109,0.68152,0.5666519,0.7070948, _
0.8011603,0.9838099,0.7962934,0.850647,1.287584,1.306226,1.237282,1.100263, _
1.37919,1.749941,1.378233,1.34841,1.138452,1.064422,1.147427,0.8695047, _
0.7428108,0.5096846,0.5018353,0.1539204,0.1485328,0.06263833,0.07261511, _
0.04378865,0.03421244,0.03031843,0.0320472,0.03611499,0.03056443,0.02821423, _
0.04247777,0.05426928,0.07588992,0.07145083,0.1628615,0.2210994,0.3999394, _
0.4566998,0.8754598,0.9213845,1.130089,1.033091,0.7845588,1.349736,1.249289, _
1.33504,1.458944,1.146806,0.9996518,1.234266,0.8489662,0.7333804,0.9003844, _
0.7707478,0.5783421,0.458117,0.5442587,0.5362517,0.3977004,0.3444617,0.2695432, _
0.1502058,0.1722583,0.1106105,0.06218928,0.04150917,0.03332577,0.02690021, _
0.01590674,0.00370248,0.00110767,4.363834E-04,2.64959E-04,1.016273E-04, _
4.386126E-05,1.798127E-05,6.121005E-06,2.776838E-06,2.096369E-06,8.293607E-07

AM241HE:
Data 66,172, _
  3.39000E-0004, 7.26000E-0004, 1.16200E-0003, 1.93700E-0003, 3.20000E-0003, _ 
  4.84200E-0003, 8.71600E-0003, 1.35590E-0002, 2.13080E-0002, 2.71180E-0002, _ 
  3.89400E-0002, 5.86630E-0002, 7.74820E-0002, 1.06546E-0001, 1.81000E-0001, _ 
  2.49329E-0001, 3.54041E-0001, 4.64420E-0001, 5.93532E-0001, 7.82329E-0001, _ 
  9.48662E-0001, 1.07670E+0000, 1.21449E+0000, 1.53791E+0000, 1.74114E+0000, _ 
  2.04490E+0000, 2.21702E+0000, 2.42434E+0000, 2.59816E+0000, 3.12482E+0000, _ 
  3.28433E+0000, 3.54513E+0000, 3.93954E+0000, 4.33690E+0000, 4.56686E+0000, _ 
  4.78342E+0000, 4.89180E+0000, 5.04052E+0000, 4.72749E+0000, 4.72953E+0000, _ 
  4.12356E+0000, 3.78403E+0000, 3.51397E+0000, 3.22237E+0000, 2.87692E+0000, _
  2.33210E+0000, 2.42316E+0000, 2.46782E+0000, 1.83811E+0000, 1.72021E+0000, _
  1.54481E+0000, 1.49605E+0000, 1.44702E+0000, 1.44702E+0000, 1.54044E+0000, _
  1.60125E+0000, 1.78852E+0000, 1.90529E+0000, 2.29601E+0000, 2.35216E+0000, _
  3.57801E+0000, 2.32121E+0000, 2.90870E+0000, 3.60408E+0000, 4.59521E+0000, _
  4.47230E+0000, 3.77210E+0000, 4.63100E+0000, 5.28121E+0000, 4.74197E+0000, _ 
  6.21689E+0000, 4.39037E+0000, 4.40492E+0000, 4.07992E+0000, 3.53239E+0000, _ 
  3.24333E+0000, 3.03853E+0000, 2.70422E+0000, 2.52534E+0000, 2.24986E+0000, _ 
  2.02690E+0000, 1.81579E+0000, 1.59082E+0000, 1.30587E+0000, 1.23572E+0000, _ 
  8.97233E-0001, 8.15177E-0001, 6.71613E-0001, 5.30077E-0001, 3.41757E-0001, _ 
  2.73777E-0001, 1.79285E-0001, 1.53996E-0001, 1.33100E-0001, 8.76450E-0002, _ 
  6.07270E-0002, 3.46470E-0002, 2.44620E-0002, 1.74500E-0002, 1.01900E-0002, _ 
  7.13300E-0003, 4.07600E-0003, 2.95600E-0003, 1.93600E-0003, 1.16500E-0003, _ 
  7.74000E-0004, 5.10000E-0004, _ 
 1.367931E-04,2.902673E-04,4.637516E-04,7.791813E-04,0.00118964,0.00193593, _
0.0034884,0.00542559,0.00828353,0.0108181,0.01565451,0.02322333,0.03092193, _
0.03363232,0.07207751,0.09987929,0.1128966,0.1752763,0.2121712,0.2735721, _
0.2992334,0.4283388,0.3950501,0.6246671,0.6698937,0.5399732,0.460044,0.6501846, _
0.6178886,0.6462281,0.8439357,0.8455552,0.9082037,0.915682,0.8027656,1.102409, _
1.24296,1.091734,0.9720274,0.9774228,1.077915,0.7858192,0.7192262,0.950732, _
0.652755,0.6536131,0.6369607,0.5833497,0.7354698,0.6850888,0.6139688,0.5660389, _
0.4642394,0.5127708,0.5764297,0.5405207,0.5269148,0.6700888,0.646605,0.5263084, _
0.7137626,0.4922392,0.6140994,0.8748254,0.9861162,0.8749473,0.7467356,1.124663, _
0.9335964,0.742335,1.3699,0.945604,0.7389416,1.067634,0.6611069,0.8869032, _
0.715032,0.5585732,0.6601674,0.6855149,0.4785568,0.7282296,0.5241969,0.5262061, _
0.4930146,0.3616838,0.2894775,0.2693262,0.1689043,0.1364163,0.07174943, _
0.07126597,0.0617465,0.05366272,0.0359719,0.02446535,0.01284735,0.00978626, _
0.00703554,0.00395455,0.00284549,0.00163869,0.00118002,7.807368E-04, _
3.856696E-04,3.104618E-04,2.05354E-04

AM241T:
Data 66,172, _
 1.360243E-07,2.520755E-07,5.801802E-07,1.261308E-06,4.54781E-06,6.782167E-06, _
9.932398E-06,3.974789E-05,8.934005E-05,2.482862E-04,5.174494E-04,0.00338238, _
0.00714449,0.01193096,0.02179647,0.04372296,0.06408221,0.17715,0.2658498, _
0.3295127,0.4299125,0.6876811,0.7589043,0.9970028,1.387261,1.851301,1.993558, _
2.638958,3.239136,3.991452,4.263665,5.268149,5.855564,6.645345,6.257203, _
5.998321,6.177491,6.229339,6.211661,6.651797,5.95904,5.270939,4.254325,2.494516, _
1.492982,0.9511381,0.5598577,0.1965796,0.14892,0.0511249,0.03979603,0.03188552, _
0.03602295,0.0278567,0.02586836,0.02617948,0.02935217,0.03979312,0.0503765, _
0.08163791,0.1699472,0.5857888,0.9288238,1.362747,2.234195,3.563391,4.775146, _
5.507373,7.233009,7.01174,7.782257,6.523061,6.961637,6.686576,5.937371,4.792054, _
4.714255,3.675428,3.489514,3.315627,2.645705,2.032388,1.828546,1.433124, _
1.148842,0.8394767,0.7225793,0.6023885,0.3770252,0.3077208,0.1911428,0.1642623, _
0.08587178,0.07300621,0.03459359,0.02210235,0.01047251,0.00282762,3.245606E-04, _
1.002326E-04,6.807017E-05,3.035591E-05,1.361656E-05,5.865321E-06,1.677646E-06, _
3.248216E-07,1.04708E-07, _
 5.912357E-08,1.061646E-07,2.484924E-07,5.420406E-07,1.688847E-06,2.921878E-06, _
4.208766E-06,1.696103E-05,3.75818E-05,1.043965E-04,2.238899E-04,0.00140961, _
0.00302238,0.00392374,0.0092015,0.01870903,0.0212798,0.06795313,0.1100175, _
0.1124919,0.1463234,0.2986943,0.3190001,0.327418,0.5647534,0.530812,0.4801231, _
0.5579203,0.8437994,0.7808102,0.8912998,1.552047,1.129068,1.437594,1.188065, _
1.349577,1.791537,1.333856,1.395227,1.419566,1.324475,1.176007,0.9025983, _
0.7951544,0.5667819,0.4646328,0.1177441,0.107129,0.07541166,0.0235273, _
0.01676862,0.0131028,0.01210074,0.01097318,0.01057668,0.00832434,0.00873459, _
0.01394693,0.01971325,0.02939182,0.06241987,0.24578,0.3455482,0.4308642, _
0.6979994,0.8543103,0.7625615,1.144336,1.344189,0.9151649,1.34816,1.428563, _
1.630331,1.227168,1.384165,0.9303932,1.028612,0.8854303,0.6438032,0.8731866, _
0.8999116,0.5939815,0.4437322,0.5245489,0.4960675,0.3601105,0.3044537,0.2617221, _
0.1443421,0.1317379,0.08205546,0.06921222,0.03734234,0.03086416,0.01485244, _
0.0095112,0.00441249,0.00122998,1.370168E-04,4.288129E-05,2.935774E-05, _
1.277633E-05,5.909459E-06,2.496065E-06,5.739475E-07,1.410452E-07,4.406768E-08

AM242T:
Data 66,172, _
 9.569102E-06,1.91832E-05,2.872112E-05,5.736977E-05,9.570941E-05,1.915485E-04, _
4.789683E-04,9.56764E-04,0.0017227,0.00287005,0.00574698,0.00969464,0.01912862, _
0.029328,0.047729,0.06706911,0.1154512,0.2477873,0.3683912,0.4719844,0.5575843, _
0.6570295,0.9033691,1.207024,1.407738,1.753361,2.085452,2.51721,2.772146, _
3.311836,3.630187,4.283653,4.581688,5.37737,5.484429,5.870559,6.65306,7.072553, _
6.936657,6.968434,6.165398,5.38135,4.10886,3.748904,2.425026,1.534716,0.6429886, _
0.251871,0.105254,0.0737428,0.03877904,0.02935305,0.02714522,0.02326777, _
0.02326784,0.01952945,0.03285103,0.04377076,0.0547866,0.1036566,0.1690289, _
0.2667477,0.413414,1.471808,2.005085,3.483857,4.813762,5.981537,6.990434, _
6.657536,6.371241,6.267843,6.007761,5.792052,5.411484,5.245252,4.478864, _
4.643647,4.429078,3.355493,2.880448,2.466796,2.132502,1.720507,1.602408, _
1.218077,1.023991,0.8290941,0.5471941,0.3611097,0.3275484,0.1550524,0.08754189, _
0.05471331,0.03832984,0.02015066,0.01313227,0.00656571,0.00218842,0.00106687, _
5.473353E-04,2.190844E-04,1.094165E-04,8.746442E-05,4.385761E-05,2.188478E-05, _
1.094234E-05, _
 4.138129E-06,8.122294E-06,1.214541E-05,2.476898E-05,3.661989E-05,8.192041E-05, _
2.046738E-04,4.024543E-04,7.325307E-04,0.0012102,0.00244615,0.0041152, _
0.00802055,0.00966721,0.02029442,0.02829945,0.03788783,0.09672474,0.1121742, _
0.1580687,0.1927068,0.2844603,0.3799355,0.3270029,0.2810855,0.6624303,0.5206482, _
0.5396091,0.7506798,0.9091696,0.7379231,1.404609,0.813694,1.183089,1.317769, _
1.247776,1.958295,1.508022,1.667082,1.538323,1.318241,1.27035,0.8693802, _
1.216913,0.5893232,0.4530107,0.1794218,0.1362447,0.05214076,0.03335473, _
0.01642142,0.01165484,0.00902316,0.00920485,0.00930241,0.0061867,0.01012133, _
0.01554596,0.02070053,0.03605596,0.06032139,0.111004,0.1513699,0.5801585, _
0.4973591,0.6580591,0.9054977,1.07447,1.370137,0.9694761,1.129816,1.334429, _
1.346851,0.8850885,1.036626,1.142517,0.9525918,1.207513,0.9453836,0.9209052, _
0.9606428,0.7568182,0.5225229,0.7231929,0.687293,0.520479,0.4300764,0.3587147, _
0.2063763,0.1546025,0.1403561,0.06514281,0.03786263,0.02311251,0.01628293, _
0.00869351,0.00550268,0.00282532,9.331697E-04,4.489346E-04,2.366187E-04, _
9.229536E-05,4.665843E-05,3.76321E-05,1.580712E-05,9.444964E-06,4.64756E-06

AM243F:
Data 66,172, _
 4.994798E-07,8.980136E-07,2.195758E-06,4.988585E-06,1.596369E-05,2.497895E-05, _
4.986638E-05,1.198703E-04,2.793001E-04,6.991128E-04,0.00129896,0.00289639, _
0.0049835,0.0189369,0.03869149,0.06502194,0.1003342,0.1695981,0.2240353, _
0.3869358,0.4888933,0.6582032,0.8561518,1.133709,1.401968,1.75348,2.09025, _
2.507704,3.202585,3.756762,4.462137,4.681954,5.058695,5.425409,5.450852, _
5.924725,5.994454,5.90462,5.972828,5.883152,5.627293,5.245328,4.93496,3.777303, _
2.818814,1.747796,0.9288284,0.4214111,0.2196077,0.10199,0.09982221,0.0999111, _
0.09487946,0.08988563,0.08489266,0.0848425,0.09472895,0.09967197,0.1196798, _
0.129834,0.2308296,0.349317,0.5679274,0.9473178,1.737105,3.194985,4.72238, _
5.619345,6.218049,6.779684,7.265587,7.29714,6.637085,5.97495,5.483855,4.953151, _
5.234495,5.210595,4.155845,3.418163,2.895627,2.336131,1.865061,1.556962, _
1.233111,0.9667911,0.7973523,0.5880487,0.4188332,0.308975,0.2192721,0.1495037, _
0.09568205,0.05780713,0.03497162,0.01993307,0.00847979,0.0032421,0.00139501, _
5.979501E-04,2.991276E-04,9.964292E-05,5.574359E-05,2.389803E-05,1.296659E-05, _
3.486302E-06,1.793856E-06, _
 2.098453E-07,3.738008E-07,9.058904E-07,2.101369E-06,6.151343E-06,1.038354E-05, _
2.089499E-05,4.940057E-05,1.157318E-04,2.905333E-04,5.381755E-04,0.00120546, _
0.00205576,0.00621669,0.0161902,0.02678508,0.03246688,0.06719609,0.08546603, _
0.1257134,0.1726773,0.2771583,0.3542311,0.4722137,0.5693444,0.7240856,0.5446538, _
0.5243893,0.8592495,0.811558,0.903455,1.402761,0.903335,1.185985,1.300356, _
1.245512,1.704159,1.246361,1.428322,1.313977,1.177824,1.196005,1.050812, _
1.041521,0.6720318,0.7213257,0.3562901,0.2243475,0.1047688,0.04597764, _
0.04749425,0.04142374,0.03542007,0.03723427,0.02968399,0.02689441,0.03184305, _
0.0358233,0.04398761,0.04430649,0.07960399,0.1464155,0.2182293,0.3828497, _
0.5106712,0.7402899,0.8326489,1.116471,1.186498,1.442333,1.279802,1.548162, _
1.481176,1.250415,1.231581,1.065092,1.112792,1.190156,0.8696042,0.8984315, _
0.7861137,0.6556057,0.4452415,0.6418847,0.5190196,0.3998842,0.3294546,0.2463597, _
0.1474365,0.129987,0.09096218,0.0620015,0.0402588,0.0238347,0.01463872, _
0.00833031,0.00349104,0.00136463,5.778638E-04,2.479229E-04,1.257698E-04, _
4.106055E-05,2.337371E-05,9.971873E-06,4.473783E-06,1.467681E-06,7.419537E-07

CF249T:
Data 66,172, _
 3.003711E-07,5.006862E-07,3.001629E-06,5.705404E-06,3.061365E-05,5.356459E-05, _
1.091285E-04,2.139405E-04,5.331218E-04,9.556817E-04,0.00191282,0.00461926, _
0.00816801,0.01844498,0.03022183,0.04804157,0.07574046,0.1298104,0.1837724, _
0.2562576,0.329949,0.4171037,0.5212514,0.4613465,0.5922664,0.8292551,0.8858405, _
1.064568,1.208309,1.507812,1.682469,2.088115,2.305209,2.811734,3.238175, _
3.685313,4.21311,4.926131,5.082934,5.44169,5.618004,5.697193,5.723218,5.576734, _
5.416336,5.499272,4.924504,4.164576,3.623452,2.985791,2.199522,1.830526, _
1.021181,0.6093925,0.385231,0.2063622,0.1802393,0.1681902,0.1374027,0.20708, _
0.4459797,0.5888668,0.7834367,1.629839,1.973786,3.167518,4.158757,5.248341, _
5.386357,5.42013,5.585406,5.764215,5.400658,6.118531,5.322448,5.431498,4.386586, _
4.707764,4.316968,3.538978,3.350847,2.855884,2.254474,2.054087,1.754701, _
1.604402,1.255628,1.21002,0.8926584,0.6159741,0.6767283,0.4212156,0.3809579, _
0.3640027,0.2329119,0.1930784,0.1106548,0.06684857,0.04346443,0.02802512, _
0.0166884,0.00739125,0.004182,0.00168689,8.625747E-04,4.807653E-04,3.628193E-04, _
 1.256456E-07,2.010193E-07,1.17644E-06,2.313277E-06,1.028346E-05,2.006631E-05, _
4.649075E-05,8.581698E-05,1.916307E-04,3.897506E-04,7.494459E-04,0.00172038, _
0.00353846,0.00622684,0.01181042,0.01939708,0.02748741,0.04590305,0.07486394, _
0.0931105,0.1038169,0.1689338,0.2139677,0.05657693,0.2618589,0.2947531, _
0.2689668,0.2413461,0.1335184,0.6068602,0.5040016,0.5390328,0.5346191,0.7278829, _
0.7649684,0.8087729,1.123401,1.014,0.8834642,1.114234,0.8204774,1.610814, _
0.7601222,1.580012,1.223582,1.478487,0.8299668,0.8475805,0.8956689,0.7076311, _
0.7391495,0.6008421,0.324735,0.2564378,0.133942,0.06371876,0.06658583, _
0.05899325,0.04828017,0.0646299,0.1320803,0.1845054,0.2328036,0.2698674, _
0.4471242,0.292944,0.9559557,0.8723215,0.570244,0.5356607,1.200148,0.923519, _
0.5633889,0.4434766,0.9047555,1.114284,0.4931272,0.9764078,0.6956371,0.9407566, _
0.6944659,0.7526776,0.5330865,0.5681198,0.6801263,0.564366,0.5342041,0.4843033, _
0.267748,0.2531948,0.2730379,0.1694036,0.1625698,0.146873,0.08961044,0.07814758, _
0.04659131,0.02683364,0.01775803,0.01141397,0.00646946,0.00296314,0.00180738, _
6.756124E-04,2.978387E-04,1.978422E-04,1.438293E-04

CF250S:
Data 66,172, _
 0.00196615,0.00245632,0.00294824,0.00373506,0.00491775,0.00589556,0.00786074, _
0.0098761,0.01277393,0.01670449,0.01971823,0.02554881,0.03242241,0.04224609, _
0.05007086,0.06884274,0.08966316,0.09651542,0.152685,0.2302323,0.2819488, _
0.2827927,0.3402722,0.4822281,0.5222281,0.567634,0.7662197,0.9293291,1.155429, _
1.488561,1.535321,1.584069,2.467251,3.293937,3.571799,4.009032,4.95656,5.303432, _
6.46393,6.603721,6.8265,7.270499,6.938935,6.330976,5.951902,4.931723,4.095244, _
3.510694,2.46961,2.04965,1.191454,0.4938775,0.196536,0.11792,0.05896202, _
0.02703685,0.01965422,0.01867195,0.01879598,0.02128694,0.04394548,0.1131014, _
0.2149163,0.3967714,0.8801178,1.704766,2.459653,3.903873,4.152461,4.643878, _
4.844939,5.548065,5.772315,6.202791,5.248627,5.849675,6.531487,5.573484, _
4.743872,4.949665,4.449477,3.814537,3.458615,3.258961,2.367303,2.071819, _
1.574102,1.215125,0.8366962,0.6839758,0.508096,0.4103847,0.3419904,0.2540469, _
0.215611,0.1661092,0.1270232,0.107482,0.07817739,0.06296358,0.05080833, _
0.04006073,0.03224379,0.02442742,0.02053994,0.01563433,0.01270283, _
 8.218645E-04,0.00102585,0.00127546,0.00159975,0.00178932,0.00242906,0.00326353, _
0.00427147,0.00532016,0.0069388,0.00826116,0.01019124,0.01384412,0.01394843, _
0.02095474,0.02861803,0.02984319,0.03629924,0.06466914,0.078968,0.09396257, _
0.118175,0.1420874,0.2099369,0.2148844,0.2027034,0.3338879,0.3863832,0.501913, _
0.6401013,0.6021128,0.5118428,0.6382179,0.8737267,0.8588406,0.8496737,1.472587, _
1.118043,1.561835,1.431517,1.476582,1.582917,1.486177,1.978335,1.021164, _
1.203859,0.7465827,0.8999149,0.7206341,0.6781093,0.3912045,0.1590939,0.09842748, _
0.0460711,0.0323702,0.01014733,0.00920844,0.00654556,0.00854689,0.00828794, _
0.02362636,0.04813457,0.08184222,0.1557944,0.2655152,0.3994171,0.5538676, _
0.9128084,0.9326591,0.5948446,0.8542868,1.201,1.377656,1.011636,1.183393, _
1.262478,1.405177,1.32498,1.010857,1.082472,1.262888,0.8136957,0.851807, _
0.6916294,0.6304237,0.5101469,0.6752505,0.5232625,0.2920727,0.2866995,0.2109972, _
0.1770635,0.1484522,0.1057025,0.09029258,0.06900376,0.05399079,0.04697686, _
0.03274814,0.02617034,0.02117092,0.01686413,0.01411502,0.01035311,0.00690276, _
0.00654072,0.00530054

CF251T:
Data 66,172, _
 9.36462E-05,1.402798E-04,1.870748E-04,2.805956E-04,3.743884E-04,4.670657E-04, _
6.546534E-04,9.54031E-04,0.00121544,0.00177752,0.0023419,0.00334023,0.0046756, _
0.00580125,0.00838442,0.0112484,0.01556399,0.0219316,0.02478673,0.04647774, _
0.05482078,0.07295516,0.09952007,0.1456241,0.3052025,0.5225232,0.576362, _
0.6766315,0.7665803,0.9832444,1.439073,1.654316,2.178323,3.312057,3.392419, _
3.871336,4.258333,4.355141,4.538045,4.859633,4.938149,5.226309,5.322145, _
5.223392,5.231263,5.01925,5.335353,4.457916,4.51012,4.56034,3.628636,2.903504, _
1.908816,1.24073,0.7635244,0.4973397,0.2806291,0.1964442,0.1874684,0.3810635, _
0.5065498,0.6090494,0.7092431,0.929301,1.217092,1.841922,3.218643,3.909097, _
4.821788,4.444305,5.438124,5.858964,5.817217,5.711905,4.515359,4.922872, _
5.444064,5.090281,5.052107,4.964054,4.243541,3.5144,3.342784,3.023977,2.425657, _
2.019556,1.520583,1.216441,0.9123958,0.713521,0.5665537,0.4077218,0.3057907, _
0.2038623,0.1529471,0.10193,0.08154389,0.06115697,0.04077223,0.03041057, _
0.02038476,0.01528941,0.01019362,0.00815484,0.0061168,0.00407702,0.00305756, _
 3.959567E-05,5.861065E-05,7.763712E-05,1.188713E-04,1.430645E-04,1.953824E-04, _
2.755154E-04,3.949648E-04,5.068757E-04,7.412573E-04,9.761658E-04,0.00139577, _
0.0019359,0.00190653,0.00352571,0.00465695,0.00504822,0.0086922,0.00955941, _
0.01510853,0.01992946,0.03076244,0.04175678,0.06044665,0.1272539,0.2164346, _
0.2426885,0.2845116,0.3181229,0.4162741,0.5751468,0.5444789,0.7183512,0.6988866, _
0.820514,0.8124442,1.267121,0.930619,1.09405,1.107152,1.036326,1.182757, _
1.140797,1.432118,1.218382,1.048395,1.221359,0.9509181,0.9724358,1.090061, _
0.9505748,0.9181741,0.6580197,0.4553134,0.2876903,0.1905978,0.1402162, _
0.08869949,0.07295021,0.09924924,0.2432098,0.2481093,0.2741814,0.3796765, _
0.3613583,0.4326335,0.7772729,0.7771003,1.108218,0.8154654,1.008865,1.243586, _
1.23712,1.257253,0.8059392,1.281538,1.147922,1.120755,1.105457,1.052192, _
1.376538,0.7382318,0.8686931,0.8441914,0.7264267,0.5261574,0.6297199,0.511578, _
0.3655268,0.2956596,0.2400338,0.1696048,0.127846,0.08614065,0.06328953, _
0.04307435,0.03410484,0.02542822,0.01727443,0.0126011,0.00857303,0.00642927, _
0.00422548,0.00345576,0.00229262,0.00171225,0.00128734

CF252S:
Data 66,172, _
 5.262687E-08,1.441292E-07,3.841434E-07,9.897542E-07,2.390601E-06,6.024517E-06, _
1.407967E-05,3.215305E-05,7.06125E-05,1.517718E-04,3.16804E-04,6.251268E-04, _
0.00205871,0.0034301,0.00471483,0.00834997,0.01526263,0.04128581,0.05236121, _
0.121811,0.1217306,0.2075462,0.3057492,0.3593313,0.5428675,0.5994906,0.6773663, _
0.8814922,1.110424,1.249544,1.603506,1.673742,2.274331,2.651276,3.454928, _
3.933855,4.037408,5.44624,5.634628,6.230864,6.315719,6.618042,6.107254,5.93681, _
5.908461,5.187494,4.135383,4.782717,3.328342,2.897137,2.127236,1.500616, _
0.9938431,0.3841373,0.2389561,0.1175209,0.08845277,0.04088571,0.02543123, _
0.01768514,0.02769515,0.1056024,0.1933433,0.5888286,0.8471598,1.599793,2.152569, _
3.149263,3.8761,4.196888,4.078383,5.094625,5.580282,5.884069,5.962063,5.969938, _
6.016572,6.249428,5.896524,5.068393,4.437222,4.280533,3.943121,2.721639, _
2.445108,1.948856,1.721655,1.292896,1.067242,0.7928709,0.6766843,0.5378041, _
0.4696063,0.3402292,0.2857973,0.1936918,0.1195685,0.07583834,0.04720734, _
0.0286444,0.01839537,0.00956695,0.00525068,0.00166788,0.0013978,7.085066E-04, _
3.458179E-04, _
 2.15982E-08,5.932498E-08,1.573339E-07,4.17262E-07,9.999403E-07,2.481559E-06, _
5.786052E-06,1.318011E-05,2.9407E-05,6.519347E-05,1.315835E-04,2.553682E-04, _
8.451924E-04,0.00118452,0.0020244,0.00349711,0.00510116,0.01650477,0.0191778, _
0.03974627,0.04733116,0.08504505,0.1251927,0.1477539,0.2305159,0.2494548, _
0.2734893,0.3649364,0.3839409,0.4056953,0.6556036,0.5611195,0.7325136,0.5539885, _
0.864943,0.8477387,1.035948,1.119886,1.18608,1.12812,1.343438,1.441797, _
0.7548285,1.500069,1.799041,1.076651,0.8236179,0.8519913,0.8988629,0.7100517, _
0.7550102,0.5056659,0.3293556,0.1478005,0.1061291,0.04591818,0.05344425, _
0.02160715,0.00853127,0.00489548,0.01188073,0.048261,0.07951291,0.2278827, _
0.2652918,0.349046,0.6639906,0.6381173,0.5876034,0.7330344,1.01045,0.7047647, _
0.3957649,0.3938511,0.4258256,0.4126396,0.8070248,1.16565,0.9023937,1.06613, _
1.137919,0.7845723,1.013428,0.6540556,0.7338439,0.7949703,0.695415,0.419918, _
0.3695605,0.3279001,0.1263049,0.1827682,0.1882695,0.1412858,0.1173102, _
0.07948983,0.04948366,0.03256958,0.01975145,0.01170228,0.00755573,0.00394044, _
0.00224714,7.044487E-04,4.781264E-04,2.913884E-04,1.418602E-04

CM242F:
Data 66,172, _
 9.976785E-07,2.990249E-06,3.993976E-06,5.984426E-06,1.501563E-05,2.59693E-05, _
6.383787E-05,1.996604E-04,3.991659E-04,8.978749E-04,0.00136348,0.00494226, _
0.01297685,0.02794921,0.04744336,0.08590198,0.1248077,0.1912241,0.2841046, _
0.4149972,0.5570809,0.7859119,0.9601199,1.227028,1.523775,1.887657,2.262657, _
2.647071,3.374505,4.019274,4.633781,4.845148,5.199471,5.433949,5.649985, _
5.953333,5.973204,5.943358,5.942727,5.787839,5.484037,5.134258,4.484844, _
3.406236,2.41305,1.427739,0.7388291,0.3514138,0.1795966,0.1105759,0.09977631, _
0.0998414,0.08985805,0.08985883,0.0848646,0.08283816,0.0926731,0.107202, _
0.118396,0.1559322,0.2688783,0.3731925,0.603923,1.011745,1.906739,3.45551, _
4.887071,5.647213,6.295203,6.764649,8.25744,7.020999,6.446314,5.777529,5.370582, _
4.76878,5.380749,4.967348,3.949403,3.297652,2.79402,2.180083,1.806818,1.492698, _
1.241072,0.9329176,0.7503847,0.5457596,0.407958,0.2923717,0.2046594,0.136443, _
0.08873541,0.05360235,0.03420081,0.01851784,0.00736577,0.00245528,0.00107906, _
5.259595E-04,2.141189E-04,7.796709E-05,2.43582E-05,1.462314E-05,1.009712E-05, _
4.47603E-06,2.725445E-06, _
 4.069072E-07,1.234751E-06,1.656368E-06,2.453151E-06,5.305697E-06,1.03305E-05, _
2.623826E-05,8.392584E-05,1.515674E-04,3.673248E-04,5.580778E-04,0.00190733, _
0.00548965,0.00927604,0.01934402,0.03502535,0.04385849,0.07050649,0.1121642, _
0.1540443,0.1785129,0.3213205,0.4060527,0.5061637,0.5573533,0.5135162,0.6792933, _
0.6450474,0.7081501,0.8826301,1.064439,1.165755,1.219978,1.110113,1.010597, _
1.29387,1.446391,1.249651,1.241093,1.241458,1.21154,1.071038,1.120364,1.000826, _
0.7260956,0.5478602,0.359726,0.1903259,0.09802064,0.05455703,0.04326124, _
0.03787153,0.02869823,0.03037807,0.03218221,0.02821941,0.03198396,0.03949802, _
0.0575758,0.06545653,0.07444137,0.1550515,0.2043367,0.3889953,0.601824, _
0.6816163,1.118859,1.335635,1.023489,1.367782,1.707039,1.500709,1.138256, _
1.285687,1.121763,1.090085,1.146031,1.062856,0.8664066,0.6914752,0.6832818, _
0.6660717,0.5859602,0.6127434,0.5147139,0.3917744,0.2606362,0.2250927,0.1350577, _
0.1205075,0.08677261,0.05604771,0.0362517,0.02206579,0.01406003,0.00777894, _
0.00282928,0.00100626,4.418601E-04,2.035772E-04,8.95525E-05,3.239117E-05, _
9.931316E-06,6.043637E-06,3.49926E-06,1.864854E-06,1.147319E-06

CM243F:
Data 66,172, _
 9.499473E-06,1.799584E-05,3.401086E-05,6.695705E-05,1.402385E-04,2.702961E-04, _
5.293222E-04,9.995074E-04,0.00200108,0.0037006,0.00664751,0.01199918,0.01999606, _
0.03399188,0.05497964,0.0870486,0.1332332,0.1999193,0.2918162,0.4287122, _
0.5738249,0.7744225,0.9990895,1.311856,1.612713,1.901591,2.293191,2.584506, _
3.028352,3.23451,3.622925,4.001118,4.392987,4.909813,5.505295,6.100083,6.599955, _
6.900142,6.89748,6.603884,6.000316,5.20007,4.199964,3.200083,2.203655,1.50003, _
0.9600189,0.5900159,0.3500095,0.2100046,0.1300029,0.0880006,0.06800091, _
0.06000088,0.05700165,0.05900154,0.06543863,0.079378,0.1100144,0.211209, _
0.2976177,0.4972962,0.8249171,1.29333,2.000726,2.888751,3.884841,4.880883, _
5.793487,6.474696,7.394814,6.873122,6.694537,6.18133,5.677792,4.850427,4.580219, _
4.086427,3.699814,3.38741,3.087998,2.689503,2.390509,1.989179,1.729213,1.3923, _
1.093946,0.8433895,0.6379405,0.4564211,0.3274328,0.2282115,0.1488508,0.09922135, _
0.06387931,0.03869633,0.02381367,0.01389161,0.00784854,0.00436634,0.00238184, _
0.00129081,6.451195E-04,3.270725E-04,1.704292E-04,8.237514E-05,4.167035E-05, _
 3.896207E-06,7.485362E-06,1.452902E-05,2.794059E-05,5.030512E-05,1.09183E-04, _
2.187452E-04,4.276961E-04,8.002545E-04,0.00151942,0.00273295,0.0046963, _
0.00856345,0.01119189,0.02259771,0.03577435,0.0455362,0.07485174,0.120708, _
0.1521289,0.184477,0.3186954,0.4232143,0.5595322,0.6166559,0.4995537,0.7075002, _
0.6943169,0.8105839,0.6783278,0.9204863,1.038589,1.03329,1.069837,0.9896082, _
1.265005,1.705316,1.5267,1.494884,1.389697,1.23337,1.090758,1.04027,0.9439019, _
0.6593037,0.5789269,0.4042148,0.3151637,0.1942739,0.1092176,0.05997321, _
0.03491532,0.02497978,0.02281282,0.02358947,0.01911562,0.01946945,0.02911592, _
0.05141059,0.08679413,0.1645317,0.2115359,0.2865672,0.4859711,0.6182848, _
0.774289,0.90227,1.12037,0.9359331,1.368208,1.457673,1.472272,1.220364,1.381067, _
1.210035,1.036505,1.187628,0.8589204,0.8176643,0.7243402,0.7434421,0.7026959, _
0.5975579,0.527499,0.7085611,0.5869465,0.4502227,0.3473783,0.2044611,0.1877112, _
0.1394358,0.09736696,0.06132897,0.04110547,0.02617372,0.01624248,0.01004502, _
0.00575537,0.00322029,0.00175509,9.926163E-04,5.537996E-04,2.707332E-04, _
1.34735E-04,5.509863E-05,3.401729E-05,1.797791E-05

CM243T:
Data 66,172, _
 3.4107E-06,8.556084E-06,2.118829E-05,4.703536E-05,8.556856E-05,1.69504E-04, _
3.758676E-04,6.700067E-04,0.00171202,0.00423775,0.00858187,0.01778586, _
0.02990281,0.05124086,0.08537949,0.1588698,0.2463172,0.3554962,0.4047591, _
0.423304,0.5364745,0.7086337,0.7600724,1.070649,1.158954,1.158475,1.365409, _
1.751343,2.241419,2.907118,3.352087,3.962876,4.721086,5.040157,5.432485, _
5.946536,8.701928,6.421615,6.710047,6.388371,5.911021,5.66691,4.305952,4.105299, _
2.626387,1.849245,2.355465,0.4669841,0.177819,0.1627402,0.06946664,0.04578302, _
0.03231229,0.02729427,0.03521711,0.03739199,0.0541217,0.06113092,0.072503, _
0.102305,0.1660984,0.6554623,0.7448469,1.207569,2.133637,3.193551,4.773698, _
5.742235,7.524263,5.910232,4.76136,6.402132,5.827525,6.809613,5.540015,5.150066, _
3.768088,4.289833,3.721924,3.275231,2.457521,2.092215,2.352539,1.985309, _
1.852624,1.244853,1.237907,1.309523,0.9041409,0.708375,0.4450572,0.4553847, _
0.3449039,0.2333723,0.1842983,0.1218485,0.08106178,0.0557607,0.02541389, _
0.0110495,0.0045442,0.00227209,0.00134335,6.094763E-04,3.007298E-04, _
1.754952E-04,9.572338E-05, _
 1.39508E-06,3.523264E-06,9.083222E-06,2.006069E-05,3.174385E-05,6.93781E-05, _
1.538173E-04,2.83162E-04,7.250035E-04,0.00175313,0.00350928,0.00709957, _
0.01259148,0.01672987,0.03584773,0.06528181,0.08008233,0.1334863,0.1692728, _
0.142224,0.1821714,0.2936056,0.3132427,0.4562949,0.4836849,0.4590731,0.5596583, _
0.6310433,0.5125492,0.6987984,0.6751126,1.194396,1.164416,1.29145,1.320805, _
1.306695,2.301377,1.39454,1.484404,1.163735,0.7789689,1.189935,0.9420994, _
1.248614,0.6226829,0.4482308,0.5326728,0.2333051,0.09822395,0.08942685, _
0.0342312,0.01915557,0.01034814,0.00945393,0.01438691,0.0123373,0.01718166, _
0.02255154,0.03045042,0.03810366,0.08821416,0.2782041,0.2629971,0.4319976, _
0.2529518,0.4155336,0.2997982,1.17451,1.199558,1.062878,1.23227,1.462414, _
1.104317,1.129039,0.8013579,1.077846,0.8824958,0.9360979,0.6731898,0.8620841, _
0.6211604,0.556278,0.5631385,0.8168898,0.4889762,0.4506628,0.5297757,0.5563076, _
0.3117793,0.2934369,0.183907,0.1954907,0.1467028,0.0960579,0.07539773, _
0.05030313,0.03486856,0.02363677,0.01041149,0.00452188,0.00186472,9.662043E-04, _
5.807855E-04,2.512124E-04,9.64583E-05,7.222546E-05,4.0711E-05

CM244F:
Data 66,172, _
 7.305735E-06,1.30135E-05,2.501219E-05,4.802156E-05,9.610377E-05,1.902248E-04, _
3.804422E-04,7.304546E-04,0.00140064,0.0026013,0.00481756,0.00850332,0.01500309, _
0.0249989,0.04095045,0.06609359,0.1013413,0.1599527,0.2187592,0.3420767, _
0.4527092,0.6224099,0.8338863,1.113123,1.420531,1.703514,1.993579,2.377807, _
2.843222,3.026353,3.612588,4.103275,4.589443,5.11767,5.704846,6.201488,6.501383, _
6.701623,6.695316,6.409222,5.902079,5.201254,4.300753,3.401158,2.603033, _
1.900458,1.300442,0.8502893,0.5402598,0.3401149,0.2100704,0.1400465,0.09503312, _
0.07402703,0.06502168,0.06403014,0.07033843,0.086214,0.119452,0.1794251, _
0.2872963,0.4670783,0.7443369,1.093749,1.692853,2.389211,3.185569,3.981736, _
4.87677,5.675124,6.480082,6.777723,6.790207,6.583404,6.272279,5.926188,5.271783, _
4.783497,4.02495,3.784805,3.285285,2.881483,2.483615,2.090977,1.803654,1.490419, _
1.192333,0.9041871,0.6864256,0.5268418,0.3666571,0.257652,0.1783775,0.1189149, _
0.07486915,0.04657522,0.02873822,0.01684629,0.00991315,0.00566415,0.00307168, _
0.00168462,8.81837E-04,4.565312E-04,2.285545E-04,1.190125E-04,5.843858E-05, _
 3.009016E-06,5.376694E-06,1.071513E-05,2.039015E-05,3.510433E-05,7.799475E-05, _
1.563808E-04,3.09781E-04,5.856359E-04,0.0010741,0.00198511,0.00338806, _
0.00633134,0.00816574,0.01708697,0.02725244,0.03316402,0.05996925,0.0910437, _
0.1159209,0.1512896,0.2583847,0.3461024,0.4779429,0.5706638,0.7043332,0.5471041, _
0.7194135,0.7359489,0.6417867,0.7460577,1.148051,1.10943,1.304572,1.09901, _
1.35746,1.808879,1.419413,1.505261,1.357412,1.291275,1.116642,0.9207706, _
1.046492,0.6754112,0.4648664,0.5366655,0.4357664,0.2994718,0.180924,0.09798518, _
0.05475815,0.03176285,0.02676708,0.02689575,0.02084442,0.02092463,0.03119757, _
0.05207741,0.0683528,0.1544319,0.1981578,0.2763596,0.3902457,0.5142122, _
0.5811021,0.7627405,0.9026905,0.9249942,1.264644,1.51051,1.534323,1.384264, _
1.392227,1.293515,1.242509,1.191779,1.047608,0.8470802,0.995541,0.8323269, _
0.7593781,0.5957599,0.6174218,0.4804678,0.6167532,0.5086758,0.380407,0.2308673, _
0.218795,0.1520395,0.1107007,0.07557186,0.04904741,0.03086899,0.01921976, _
0.0122745,0.0071722,0.00407985,0.00233263,0.00126197,7.128723E-04,3.812732E-04, _
1.889272E-04,7.396256E-05,4.916104E-05,2.455808E-05

CM244S:
Data 66,172, _
 3.986089E-05,6.57787E-05,9.961211E-05,1.493708E-04,2.490594E-04,3.984243E-04, _
6.564175E-04,9.970907E-04,0.00149332,0.00256892,0.00398854,0.00474966, _
0.00995567,0.01692507,0.02687448,0.04482616,0.07074329,0.1157891,0.1126782, _
0.2235962,0.1971384,0.3673923,0.4445721,0.72181,0.8116257,0.8254665,1.090339, _
1.287221,1.508826,1.630835,2.49629,3.065035,3.484617,3.90745,4.991358,5.787746, _
6.885237,6.929599,7.677633,9.300889,7.398161,6.985209,5.986909,5.01237,3.992637, _
2.876296,2.045346,0.881394,0.3983092,0.2577765,0.0697045,0.02990973,0.00996932, _
0.00498634,0.00199188,0.00131806,0.00244002,0.00486703,0.00877686,0.0154993, _
0.06808069,0.1987087,0.4860467,0.6608591,1.991528,3.004091,4.194263,5.660553, _
6.803529,7.481576,7.440197,8.073092,7.688324,7.02018,6.102636,5.620769,4.869087, _
4.00115,3.677363,3.088287,2.58792,1.981329,1.691584,1.452263,0.9974239, _
0.6967001,0.5971672,0.500562,0.3893709,0.2919847,0.2039501,0.1557253,0.09732869, _
0.06813081,0.04384693,0.02919766,0.01946501,0.01167941,0.00778638,0.00490482, _
0.00340597,0.00243331,0.00146012,9.739484E-04,5.837396E-04,3.893523E-04, _
2.921523E-04, _
 1.587385E-05,2.785564E-05,4.751425E-05,6.758949E-05,9.615379E-05,1.622272E-04, _
2.740541E-04,4.504485E-04,7.046053E-04,0.00108713,0.00158858,0.00188555, _
0.00460184,0.00578281,0.01156768,0.01838814,0.02581965,0.04487064,0.05293613, _
0.07966951,0.06297169,0.1526722,0.205716,0.3327427,0.3377715,0.3414494, _
0.4437263,0.5670781,0.3963165,0.703273,0.7052018,0.8448718,0.8550432,1.005782, _
1.227268,1.248861,1.842952,1.520867,1.882581,2.021946,1.478628,1.489778, _
1.380451,1.66398,0.9333833,0.7739372,0.7407943,0.3232419,0.2144168,0.1020641, _
0.03975915,0.01540104,0.00462734,0.00200234,9.006326E-04,4.265195E-04, _
7.024212E-04,0.00177169,0.00383986,0.00577821,0.03732598,0.08580729,0.1956014, _
0.2394508,0.5929105,0.7069757,0.8809378,1.186215,1.487932,1.105443,1.356854, _
1.788533,1.501951,1.526482,1.317366,1.213335,1.105543,1.040136,0.8303131, _
0.8656787,0.6725134,0.6839749,0.4255986,0.6130072,0.3964688,0.2904889,0.2063048, _
0.2290957,0.1515445,0.120816,0.08400092,0.06941447,0.0469589,0.02925285, _
0.0175409,0.0120835,0.00874354,0.00541712,0.00351107,0.00202459,0.00136136, _
0.00104052,7.039393E-04,4.34991E-04,2.104001E-04,1.611539E-04,1.241387E-04

CM245T:
Data 66,172, _
 1.044244E-06,2.08846E-06,4.175883E-06,1.045035E-05,2.611042E-05,5.747035E-05, _
1.044854E-04,2.089638E-04,4.599781E-04,7.733933E-04,0.00209087,0.0051583, _
0.01044162,0.02042451,0.03639531,0.06279352,0.1048859,0.1907532,0.2478064, _
0.314806,0.4630001,0.4961371,0.5909294,0.8609163,1.115876,0.8837012,1.275032, _
1.769137,1.672097,2.367941,2.835007,2.901754,3.653054,4.194667,4.943582, _
5.761652,5.956336,6.327807,6.739069,6.41771,5.744369,5.57935,5.742624,4.656776, _
4.726575,4.010345,3.0063,2.039337,1.093788,0.5595422,0.2166456,0.1431331, _
0.0845941,0.05261291,0.03713997,0.031131,0.05331389,0.06330457,0.0710137, _
0.0935051,0.1618115,0.4865031,0.6513394,1.270379,1.850609,2.91578,4.184739, _
5.466723,7.082899,6.80868,4.9584,6.253076,6.19061,5.879134,5.51993,5.161513, _
4.716754,4.424053,4.301075,3.043344,2.755507,2.438097,2.313969,1.952232, _
1.818359,1.142818,1.22276,1.295212,0.8925162,0.6963168,0.4328855,0.4479941, _
0.3283937,0.2290635,0.1795288,0.1196001,0.07966403,0.05473256,0.02493381, _
0.01090396,0.00445934,0.00223009,0.00131749,5.979109E-04,2.938567E-04, _
1.722348E-04,8.004364E-05, _
 4.303884E-07,8.68639E-07,1.787161E-06,4.579433E-06,1.041673E-05,2.386533E-05, _
4.303209E-05,8.758869E-05,2.027443E-04,3.304322E-04,8.620785E-04,0.00213284, _
0.00433875,0.00679247,0.01599803,0.02608041,0.03371535,0.07475018,0.102046, _
0.104059,0.1747395,0.2043549,0.2443752,0.29469,0.2797361,0.3782617,0.4188212, _
0.4226342,0.4932305,0.6062281,0.7988893,0.9514616,0.9939445,0.9074624,1.200704, _
1.215512,1.638837,1.343131,1.624434,1.450312,1.055836,1.170318,1.208625, _
1.281135,1.140434,0.8397085,1.174193,0.6552633,0.5669175,0.2174056,0.1169111, _
0.06694371,0.03450643,0.02177307,0.01344822,0.01003863,0.01739831,0.02167881, _
0.0269071,0.03199526,0.05686688,0.0993013,0.252738,0.5163249,0.4298504, _
0.4443882,0.7803065,0.7268333,0.4792504,0.917483,0.7629141,0.9109256,0.6369728, _
0.859655,1.171096,1.160526,0.8390887,1.159104,0.9524791,0.6463228,0.8869281, _
0.5138496,0.6045003,0.5311408,0.7521198,0.3681904,0.5072842,0.5624261,0.3709677, _
0.2893144,0.1774943,0.1869636,0.1458752,0.09800065,0.07402807,0.05014717, _
0.03308642,0.02372757,0.01097511,0.00452885,0.00183901,9.263848E-04, _
5.704806E-04,2.61322E-04,1.114564E-04,7.20122E-05,3.295933E-05

CM246F:
Data 66,172, _
 4.117991E-06,7.524064E-06,1.403996E-05,2.908037E-05,5.729407E-05,1.103263E-04, _
2.304069E-04,4.506863E-04,8.63257E-04,0.00160604,0.0030117,0.00531291, _
0.00942399,0.01603451,0.02691972,0.04323711,0.0684754,0.1000823,0.1398957, _
0.2527857,0.3129788,0.4422035,0.5954564,0.8077382,1.042238,1.310024,1.597061, _
1.869673,2.274967,2.341773,2.92091,3.316418,3.787498,4.337256,4.91587,5.409127, _
6.009917,6.410556,6.694748,6.83533,6.615036,6.210483,5.508387,4.70519,3.810097, _
2.904904,2.10502,1.503586,1.002389,0.6510984,0.400955,0.250423,0.150359, _
0.0982331,0.07016838,0.05718711,0.05620084,0.06422839,0.08600201,0.117373, _
0.207298,0.347236,0.5530533,0.8722672,1.289721,1.888904,2.67741,3.477747, _
4.355829,5.280237,5.986353,6.664638,6.813975,6.811005,6.568841,5.932851, _
5.558323,4.98283,4.674943,3.988609,3.481061,3.081538,2.67551,2.282687,1.990103, _
1.685683,1.388206,1.090734,0.8498113,0.6931823,0.4841635,0.3557105,0.2470222, _
0.1778548,0.1186418,0.0760825,0.04841604,0.03063094,0.0187735,0.01090673, _
0.00622598,0.00355702,0.00187708,9.873684E-04,5.440209E-04,2.76826E-04, _
1.383153E-04, _
 1.727494E-06,3.148928E-06,5.843067E-06,1.247631E-05,2.307182E-05,4.59066E-05, _
9.693602E-05,1.868764E-04,3.647961E-04,6.805892E-04,0.00124959,0.00222922, _
0.00391373,0.00535565,0.01151008,0.01793622,0.02233009,0.04075769,0.05332753, _
0.08244909,0.118369,0.1850083,0.2500341,0.3357614,0.4437093,0.5470994,0.6685372, _
0.5101958,0.6919576,0.608523,0.607423,1.09326,0.6695557,0.9181741,1.20065, _
1.143345,1.728616,1.401282,1.649902,1.467223,1.403445,1.358528,1.203611, _
1.277062,0.9180144,0.6082724,0.5493033,0.6234013,0.5002123,0.2517536,0.214228, _
0.1184187,0.06104916,0.0455011,0.02270614,0.01935931,0.0212588,0.02452247, _
0.03150407,0.04105252,0.09283748,0.1502935,0.2148092,0.3876318,0.3813652, _
0.442856,0.9129287,0.6868469,0.9671343,1.109998,0.9703135,1.400978,1.4849, _
1.482385,1.393784,1.251424,1.169796,1.109686,1.02847,0.8440431,1.127328, _
0.6478443,0.6922542,0.6419159,0.584677,0.4436977,0.5751053,0.4664316,0.3366039, _
0.2880672,0.2040976,0.1474949,0.1053408,0.07543808,0.04922694,0.03209638, _
0.02009826,0.01294544,0.00802702,0.00452477,0.00261927,0.00148546,7.850505E-04, _
4.238988E-04,2.057787E-04,1.157089E-04,5.811635E-05

CM246S:
Data 66,172, _
 2.153902E-05,4.412082E-04,4.214345E-04,8.158097E-04,8.009757E-04,0.00110722, _
0.00149965,0.00209599,0.00287042,0.00415458,0.00570626,0.007492,0.01185191, _
0.01713953,0.02552383,0.0392529,0.0571528,0.08304682,0.09132172,0.1679616, _
0.1777313,0.2866277,0.3519396,0.5772312,0.6488433,0.702834,0.959595,1.210963, _
1.487398,1.987705,2.283639,2.364987,3.309904,4.248372,4.720648,5.470753, _
6.138634,6.835194,6.937564,6.811804,6.733375,6.606563,6.005955,5.511356, _
4.848207,4.309434,4.029616,1.752168,1.242049,0.8137178,0.07097495,0.02534316, _
0.00860581,0.00402169,0.00203056,0.00154782,0.00195076,0.00291879,0.00436632, _
0.01016421,0.03460115,0.1053796,0.2507184,0.5660281,1.793253,3.32596,4.655059, _
5.704026,5.814184,6.62958,6.791939,6.914161,6.684257,6.326641,6.371862,5.324576, _
5.514224,5.323882,5.055202,3.518029,2.905872,2.570287,1.977142,1.544039, _
1.119196,0.8575588,0.5712954,0.5895733,0.3356501,0.2285172,0.181209,0.1205082, _
0.08301706,0.05802285,0.03928768,0.02677933,0.02053084,0.01428159,0.01071221, _
0.00739254,0.00535563,0.00446326,0.00267822,0.00178643,0.00169566,0.00116106, _
9.820067E-04, _
 8.794834E-06,1.839678E-04,1.885134E-04,3.683706E-04,3.218832E-04,4.596189E-04, _
6.14572E-04,9.010051E-04,0.00132333,0.00179775,0.0023437,0.00307141,0.00504779, _
0.00577854,0.01151042,0.01636304,0.01832591,0.03216505,0.04019532,0.05672672, _
0.06671572,0.1200072,0.1454998,0.2538421,0.296143,0.2962121,0.3919887,0.5048575, _
0.6676574,0.5224357,0.6628188,0.7679072,0.8702065,0.9447198,1.166351,1.163891, _
1.660841,1.455365,1.69366,1.590622,1.435586,1.383273,1.268921,1.657306,1.167321, _
0.9086794,1.073119,0.7324954,0.6421168,0.3194236,0.03948352,0.01233837, _
0.00362138,0.00166403,7.762965E-04,5.107274E-04,6.546073E-04,0.00100178, _
0.00177478,0.00363779,0.01784455,0.0443137,0.100356,0.2317079,0.5518403, _
0.7752943,0.9972056,1.037226,1.409964,1.180119,1.097126,1.476271,1.569241, _
1.405712,1.349341,1.213554,1.178113,1.244348,1.150403,0.7503286,0.9423227, _
0.5514771,0.5003843,0.6656896,0.4586356,0.3580843,0.2465171,0.2669025,0.1422762, _
0.09523536,0.07402433,0.0506967,0.03817318,0.0257767,0.01639612,0.0112176, _
0.00852038,0.00630479,0.00494987,0.00312279,0.00218859,0.00186021,0.0011804, _
8.097341E-04,6.950113E-04,4.840876E-04,4.014275E-04

CM248F:
Data 66,172, _
 2.074868E-06,3.65945E-06,6.832928E-06,1.286209E-05,2.585224E-05,5.246901E-05, _
1.089105E-04,2.087394E-04,3.958375E-04,7.629479E-04,0.00138531,0.00258164, _
0.00464488,0.00799694,0.0136314,0.02284502,0.03669456,0.0574938,0.06619884, _
0.153677,0.1801401,0.2729417,0.3552438,0.5030575,0.7229612,0.8801838,1.094302, _
1.338352,1.773972,2.073279,2.313635,2.717687,3.053597,3.630062,4.098457, _
4.675797,5.37196,5.968262,6.43868,6.931716,6.975887,6.764973,6.365033,5.777879, _
4.987739,4.078888,3.183514,2.387637,1.687618,1.094335,0.7346108,0.4576303, _
0.27796,0.168762,0.1091983,0.07243413,0.05741864,0.05544618,0.06633323, _
0.08734111,0.1478614,0.238149,0.3943334,0.6349502,0.9904072,1.487342,2.082296, _
2.875073,3.727428,4.721084,5.435168,6.534645,6.769624,7.094317,6.886296, _
6.642542,6.048513,5.599377,5.043958,4.319954,3.787965,3.279522,2.778781, _
2.384795,2.082639,1.685082,1.387714,1.18947,0.9416658,0.7378961,0.5629259, _
0.4147877,0.306152,0.2172697,0.1481426,0.09875821,0.0651797,0.04147917, _
0.02567679,0.01585971,0.00948062,0.00543253,0.00306229,0.00167904,9.178955E-04, _
4.832551E-04,2.472875E-04, _
 8.659467E-07,1.557284E-06,2.85536E-06,5.471831E-06,1.092515E-05,2.190443E-05, _
4.613692E-05,8.79845E-05,1.658433E-04,3.30426E-04,5.841683E-04,0.00108246, _
0.00197239,0.00289513,0.00586744,0.00976548,0.01284701,0.02419575,0.0227926, _
0.05176707,0.07526726,0.114052,0.1504768,0.2120599,0.303124,0.3803172,0.458566, _
0.5656409,0.4941637,0.6168114,0.588605,0.6830287,1.002926,0.7879393,0.8703409, _
1.217952,1.345695,1.331504,1.824393,1.482034,1.511147,1.440805,1.394156, _
1.383679,1.052164,1.059685,0.6732658,0.6290936,0.704985,0.4031717,0.2846458, _
0.2398442,0.1253892,0.0760731,0.03997827,0.02998547,0.02243464,0.02253229, _
0.02168275,0.03069806,0.05529964,0.08192199,0.1425018,0.2676241,0.367586, _
0.5299361,0.6849731,0.7393864,0.8747908,1.034251,0.9576188,1.390034,1.423805, _
1.61331,1.509177,1.411488,1.287441,1.175774,1.131977,0.9493812,1.02354, _
0.8581635,0.5849239,0.6332548,0.5865266,0.7054266,0.5900208,0.4961887,0.4019877, _
0.3144546,0.2352837,0.1765525,0.1277679,0.09291054,0.06369659,0.04119555, _
0.02769653,0.01741397,0.01084068,0.00686836,0.00397937,0.00229071,0.00129708, _
7.01703E-04,3.920774E-04,2.052482E-04,1.034438E-04

CM248S:
Data 66, 172, _
 4.397148E-04,5.487097E-04,7.686162E-04,9.877197E-04,0.0013902,0.00186694, _
0.00241557,0.0032084,0.00439292,0.00593065,0.00769033,0.01069349,0.01426564, _
0.01865148,0.02514262,0.03523387,0.04632771,0.04558003,0.06928283,0.1074655, _
0.1608088,0.2093474,0.2650146,0.4382651,0.496586,0.597923,0.8495646,1.138114, _
1.543216,1.636987,2.110027,2.626063,3.183774,4.153313,4.520552,5.245277, _
5.454882,5.512637,6.273931,6.433392,6.175519,6.29433,6.083044,6.051877,5.777919, _
5.417086,4.683302,2.662814,2.098106,1.38775,0.07686738,0.02138608,0.00748571, _
0.00320821,0.00213848,0.00181768,0.00164595,0.00186681,0.00205997,0.00650519, _
0.0132242,0.0311733,0.1016419,0.3221179,2.026417,2.620905,4.33663,5.255962, _
4.908693,5.790323,4.543206,6.238781,6.574431,6.328858,5.838215,5.621989, _
6.264241,5.489667,5.828458,4.480808,3.742869,3.130743,2.622848,2.030586, _
1.521403,1.184068,0.9685025,0.7927192,0.4077955,0.2548701,0.2038946,0.1325318, _
0.1019471,0.07136314,0.05097963,0.03568107,0.03058294,0.02344703,0.01835088, _
0.01318022,0.01019484,0.00815613,0.00611675,0.00458835,0.00356931,0.00254841, _
0.0020395, _
 1.847447E-04,2.342723E-04,3.200197E-04,4.193441E-04,5.679555E-04,7.774314E-04, _
0.00103256,0.00134357,0.00184215,0.00252447,0.00320197,0.00453782,0.00598237, _
0.0062643,0.01070284,0.0146617,0.01511311,0.01815542,0.02722099,0.03522218, _
0.05768769,0.08927456,0.1114647,0.1829665,0.2084839,0.2490671,0.3606154, _
0.4823388,0.6432634,0.4265976,0.5891318,0.8799803,1.042492,0.8741915,0.9852992, _
1.137843,1.49166,1.286318,1.651757,1.432055,1.353509,1.33791,1.299726,1.541118, _
1.269999,1.149335,1.033003,0.7203555,0.6473614,0.3030784,0.04193502,0.0108996, _
0.00326675,0.00145646,7.167077E-04,6.914302E-04,6.706971E-04,7.048661E-04, _
6.783116E-04,0.00220626,0.0051853,0.01124347,0.03776176,0.1353513,0.7344024, _
0.6608159,0.9625158,1.076419,1.141799,1.252636,0.7971355,1.41937,1.378523, _
1.453828,1.252601,1.212005,1.428066,1.152738,1.344125,0.9562351,1.073682, _
0.8657751,0.7672319,0.534482,0.633299,0.3851903,0.4066464,0.3330027,0.1691039, _
0.1061175,0.08669619,0.05603727,0.04253772,0.03051293,0.0213312,0.01502599, _
0.01304127,0.00976082,0.00780816,0.00556759,0.00425612,0.00348767,0.00255935, _
0.00193381,0.00146844,0.00106079,8.682645E-04

ES253S:
Data 66,172, _
 2.671919E-04,3.599388E-04,5.133974E-04,6.775875E-04,9.451056E-04,0.00133302, _
0.00184687,0.00234137,0.00338541,0.00461595,0.00619955,0.00814653,0.01128294, _
0.01538324,0.0225464,0.03081048,0.04197189,0.06161094,0.07802432,0.1163609, _
0.1516477,0.1999544,0.2843312,0.3716436,0.4667499,0.5338181,0.6124138,0.6600046, _
0.9848831,1.149258,1.53424,1.875936,2.218504,3.116789,3.447869,3.849507, _
4.558483,5.856871,6.275385,6.248576,6.532347,6.280789,5.875143,5.520592, _
5.275653,4.728837,3.977547,3.646909,3.24217,2.828172,2.57118,2.228665,1.222083, _
0.6619633,0.3157057,0.1524624,0.06566466,0.03180525,0.02002489,0.01898346, _
0.02993251,0.06338045,0.1545348,0.3103416,0.5807769,1.136353,2.528619,2.669498, _
2.943386,4.707016,4.272602,4.598938,4.833023,5.884627,5.661408,5.741125, _
5.794275,6.448845,5.108228,5.804204,5.407469,4.817023,3.833056,3.133095,2.46532, _
1.907915,1.561618,1.482296,1.075298,0.9272155,0.772854,0.7442863,0.5796614, _
0.5641536,0.4398304,0.2898212,0.2125343,0.144913,0.1063953,0.07728654, _
0.05796444,0.04057504,0.0289817,0.02221898,0.01658601,0.01062611,0.00772883, _
 1.097346E-04,1.460331E-04,2.080754E-04,2.76253E-04,3.339609E-04,5.379465E-04, _
7.484242E-04,9.600391E-04,0.00131129,0.00187103,0.00255231,0.00318978, _
0.00460374,0.00493005,0.00914367,0.01257618,0.01371696,0.02257612,0.03053968, _
0.03947423,0.04954437,0.08206036,0.1152328,0.1523384,0.1803097,0.2177999, _
0.2517108,0.266635,0.4047999,0.4682482,0.5860289,0.6022965,0.5486482,0.8023447, _
0.8345453,0.8326406,1.267764,1.225799,1.339836,1.294842,1.344715,1.315791, _
1.225395,1.634325,0.9310523,1.156052,0.8265995,0.7839357,0.6966572,0.7408915, _
0.8211561,0.6820539,0.4710205,0.2032328,0.09980115,0.06517395,0.02104377, _
0.01403606,0.00661269,0.00759185,0.01604579,0.02663321,0.05814249,0.12059, _
0.1726062,0.4448154,0.6291644,0.6216141,0.7309933,0.689809,0.7498058,1.010269, _
1.090805,1.244641,1.269945,1.189862,1.311983,1.362934,1.078289,1.194868,1.37467, _
1.069831,0.9113454,0.6577681,0.6447615,0.7740012,0.6307583,0.6058774,0.3615531, _
0.3817265,0.3134838,0.3056269,0.2368169,0.229662,0.1809757,0.1175261,0.08597952, _
0.05906259,0.04339068,0.03121755,0.02346873,0.0166788,0.01182892,0.00904159, _
0.00529751,0.00431359,0.00316559

ES254T:
Data 66,172, _
 9.3824E-09,1.874464E-08,3.75627E-08,7.514279E-08,1.409305E-07,2.345356E-07, _
1.454309E-07,9.686134E-07,1.880799E-06,3.282271E-06,6.577616E-06,1.357003E-05, _
2.422607E-05,4.838431E-05,9.31516E-05,2.353471E-04,4.251063E-04,8.711522E-04, _
0.00142971,0.00362021,0.00678289,0.01341464,0.0266412,0.0488806,0.115311, _
0.2765512,0.3543628,0.4455482,0.5793652,0.7155356,0.7550815,0.9809126,1.321125, _
2.317402,2.428525,2.487147,2.713937,3.127816,3.38223,4.26393,4.025843,3.877228, _
3.682632,3.718746,3.881562,4.192536,4.342347,3.890815,4.94348,5.572667,5.480339, _
5.087158,4.458822,3.913194,3.392581,2.695797,2.295831,1.938617,1.339261, _
0.9033266,0.8446203,0.9452509,1.284918,1.961228,2.460507,3.79487,4.799688, _
5.053106,5.304444,5.502077,4.935948,4.832289,4.506392,4.2057,4.001887,4.588583, _
4.570943,4.839259,3.889947,3.572703,3.266098,2.967359,2.656576,2.266836, _
1.980224,1.700241,1.624616,1.591975,1.280085,0.9846156,0.7962622,0.7543094, _
0.6847703,0.4891217,0.3915011,0.2934731,0.1956475,0.09782308,0.0479333,0.019691, _
0.008803,0.00391289,0.00195689,9.778123E-04,4.892714E-04,1.961339E-04, _
9.79039E-05, _
 3.970144E-09,7.826159E-09,1.559114E-08,3.181734E-08,5.381961E-08,9.807749E-08, _
6.12135E-08,4.011024E-07,7.850233E-07,1.368467E-06,2.741524E-06,5.675748E-06, _
1.003472E-05,1.590017E-05,3.91598E-05,9.74188E-05,1.379823E-04,3.452184E-04, _
5.514858E-04,0.00117605,0.00247506,0.005653,0.0111942,0.02026212,0.04830978, _
0.1149693,0.1480227,0.1883653,0.2397173,0.3011292,0.309282,0.3360051,0.4285783, _
0.4862539,0.6219038,0.7227765,0.9015469,0.8523013,0.8295813,1.112913,0.8456635, _
1.031516,0.7968566,1.002007,0.9407564,0.880213,0.9626074,0.8467852,1.049429, _
1.342673,1.003385,0.8878286,0.7811832,0.6749765,0.7514719,0.6738521,0.7242031, _
0.4880006,0.5192525,0.3366572,0.2989919,0.2911478,0.4936003,0.5047942,0.8520904, _
0.9059283,0.8782579,1.00767,1.217543,1.154253,0.8909661,1.039329,0.9487965, _
0.9543035,0.7291806,1.063394,0.9672201,1.062403,0.8511541,0.7562355,1.059124, _
0.6239742,0.6938362,0.6362843,0.5853689,0.4443375,0.6717923,0.6712856,0.5039096, _
0.4091493,0.3374053,0.3126478,0.2879885,0.2058099,0.1621723,0.1242935, _
0.08146506,0.04083873,0.02028064,0.00814706,0.00371216,0.00164301,8.11329E-04, _
4.144928E-04,1.854805E-04,8.206328E-05,4.137477E-05

FM254S:
Data 66,172, _
 2.824101E-05,3.841463E-05,5.261704E-05,7.471279E-05,1.016376E-04,1.516492E-04, _
2.025359E-04,2.822571E-04,3.840941E-04,5.051044E-04,7.219987E-04,0.00101048, _
0.00151632,0.00232367,0.00354557,0.00505462,0.0085668,0.01208757,0.016832, _
0.02665655,0.04026434,0.05556962,0.09519973,0.1319767,0.2027751,0.3952556, _
0.4430089,0.4785986,0.5001159,0.5225063,1.015821,1.26156,1.5079,1.758764, _
2.219737,2.7145,3.01603,3.168802,4.019588,4.934113,5.565042,5.429001,5.629903, _
5.701335,6.457108,5.529492,6.229129,5.730622,5.032598,5.078135,4.244426, _
3.518799,2.619719,1.813658,1.111863,0.7967667,0.4092798,0.2526796,0.1602105, _
0.1267905,0.1638165,0.2389151,0.4545795,0.8718573,1.507643,2.440137,3.520972, _
4.341242,5.187315,4.478276,5.742619,5.592595,5.744035,4.991275,5.543559, _
5.478932,5.029107,5.457284,4.84689,4.108037,3.725071,3.447174,2.864973,2.857482, _
2.201214,1.685728,1.498415,1.385211,1.034269,0.8009848,0.664453,0.6189294, _
0.4734149,0.4332689,0.2180832,0.1183269,0.07281896,0.05461893,0.03839596, _
0.02457467,0.01820381,0.01183296,0.00546217,0.003641,0.00280822,0.00182165, _
9.099694E-04, _
 1.15195E-05,1.580772E-05,2.083909E-05,3.039607E-05,3.520809E-05,5.917511E-05, _
8.254476E-05,1.168458E-04,1.377582E-04,2.072701E-04,2.968882E-04,3.832819E-04, _
6.27966E-04,7.889873E-04,0.00145707,0.00204785,0.00304034,0.004348,0.00639181, _
0.00994678,0.01291031,0.02264461,0.03928275,0.0542568,0.07449827,0.1637195, _
0.1806438,0.1947306,0.2058641,0.2122757,0.3891878,0.3729159,0.5820668,0.7132657, _
0.7600446,0.7079284,0.7877253,0.8579321,0.8394346,1.042254,1.250683,1.128755, _
1.190579,1.3987,1.154621,1.168699,0.8713938,1.241805,1.053229,1.013898,1.065462, _
0.7642233,0.6533339,0.5971549,0.3184074,0.2610332,0.1928786,0.1022679, _
0.08658685,0.05327981,0.08786444,0.09723355,0.1564685,0.260148,0.4695503, _
0.616562,0.5969994,1.000236,0.9548974,0.8950839,1.440118,1.261785,0.9993985, _
1.059106,1.176518,1.166863,1.196641,1.1338,1.0871,0.8761038,0.8973166,0.9022673, _
0.7103944,0.7652047,0.6131392,0.6889639,0.5971805,0.4980437,0.3340976,0.3287618, _
0.2720717,0.2558696,0.1929349,0.1795005,0.08892871,0.04880313,0.02815942, _
0.0223046,0.0159068,0.00957818,0.00743646,0.00488153,0.00222585,0.00150739, _
9.380479E-04,7.461981E-04,3.767475E-04

FM255T:
Data 66, 172, _
 1.585978E-04,2.0525E-04,2.518404E-04,3.267539E-04,4.382183E-04,5.775442E-04, _
7.456841E-04,9.518139E-04,0.00130549,0.00158452,0.00214946,0.00279652, _
0.00372794,0.00465933,0.00633648,0.00802127,0.01036459,0.0133244,0.01625947, _
0.02435475,0.02932981,0.03939403,0.05110266,0.06591938,0.08666478,0.111978, _
0.1387925,0.186959,0.2363993,0.3086306,0.4106219,0.687297,0.696076,0.8601909, _
0.9525971,1.142434,1.237566,1.332801,1.519811,2.392556,2.415537,2.608418, _
2.704612,2.897614,3.286434,3.188062,3.625351,4.253723,4.830398,5.591329,5.66202, _
5.856079,5.893073,5.953695,5.796475,5.699842,5.329954,4.927008,3.879268, _
3.016303,2.40434,2.322269,2.168519,2.263562,2.483183,3.215207,4.809127,5.420526, _
5.817971,6.177968,6.098579,6.465608,6.107572,5.714777,4.834266,4.623211,4.3335, _
3.144065,3.209111,2.833512,2.482835,2.022641,1.745965,1.469318,1.28779,1.285995, _
1.103258,0.9980806,0.7088053,0.5315931,0.4429942,0.364707,0.2657962,0.1949182, _
0.150645,0.1151777,0.08859837,0.07087819,0.05316001,0.04596977,0.03544001, _
0.02657961,0.01771933,0.0150623,0.01240511,0.00886016,0.00708757, _
 6.926284E-05,8.71162E-05,1.099047E-04,1.403495E-04,1.608532E-04,2.506317E-04, _
3.163621E-04,4.157818E-04,5.41645E-04,6.735377E-04,9.477349E-04,0.00115244, _
0.00160879,0.00155096,0.00268634,0.0035022,0.00351332,0.00507935,0.00694483, _
0.00863181,0.00985997,0.0171696,0.0217206,0.02907755,0.03502183,0.04856489, _
0.06068954,0.07929977,0.1041279,0.1320894,0.1647903,0.229122,0.2576827, _
0.3773954,0.3805491,0.4911978,0.4116512,0.5650857,0.6481252,0.6837621,0.7092384, _
0.6824988,0.5770901,0.9546226,0.7627964,0.6843899,0.9437564,0.9120128,1.086695, _
1.351843,1.020112,1.043486,1.04236,1.032209,1.31563,1.403596,1.524193,0.9546678, _
1.021315,0.6798978,0.6606404,0.5970943,0.8083073,0.6064172,0.7562855,0.7633366, _
0.8517304,1.099944,1.348838,1.159749,1.109243,1.407926,1.326196,1.302329, _
1.036218,1.202313,0.9267516,0.8329552,0.7014624,0.8155379,0.8264489,0.8577436, _
0.4441437,0.6310808,0.5536931,0.5652984,0.4674177,0.4380178,0.2877574,0.2272781, _
0.1953246,0.1549328,0.1158291,0.08495341,0.06399186,0.05076527,0.03791905, _
0.03051182,0.02338398,0.01949282,0.01551031,0.01152953,0.00754765,0.00664484, _
0.00482906,0.00383308,0.00310826

FM256S:
Data 66, 172, _
 1.010745E-04,1.615773E-04,2.21779E-04,3.030103E-04,4.043488E-04,5.255021E-04, _
7.068219E-04,0.00100722,0.0013137,0.00181696,0.00254011,0.00342416,0.00464441, _
0.0070665,0.00907917,0.01213077,0.01654598,0.02214293,0.02918253,0.04147848, _
0.05386862,0.07328021,0.1102465,0.1526235,0.2038373,0.2424369,0.301129, _
0.3955863,0.5321778,0.6689646,0.7484407,0.7681777,1.005212,1.213263,1.511981, _
1.812561,2.009815,2.210792,2.714007,3.114184,3.618669,4.522294,5.225097, _
5.418058,5.624226,5.433909,5.627754,6.029729,6.029969,6.131702,5.657343, _
4.716551,4.019818,3.222344,2.61816,2.720061,1.569283,0.9088657,0.4676412, _
0.4430701,0.4185954,0.4294329,0.5707647,0.8583694,1.546931,2.537372,4.024408, _
3.827047,4.086682,6.220217,4.7795,5.183128,5.293835,6.122885,5.963209,5.759212, _
5.26334,4.88593,4.490768,3.908338,3.416088,3.122585,2.703111,2.655003,2.239134, _
2.050125,1.64177,1.35234,1.064814,0.8373626,0.7219397,0.5203366,0.3996733, _
0.3044948,0.2310795,0.1617626,0.1141851,0.07993124,0.05713371,0.04345804, _
0.03330409,0.02474046,0.0190319,0.01332092,0.00956242,0.007042,0.0047578, _
 4.16714E-05,6.574246E-05,9.02732E-05,1.239728E-04,1.436166E-04,2.134167E-04, _
2.875381E-04,4.141875E-04,5.130098E-04,7.389729E-04,0.00105036,0.00134859, _
0.00190161,0.00226933,0.00369413,0.00497413,0.00544988,0.00808949,0.01147123, _
0.01445,0.01737487,0.03004498,0.04505679,0.06309708,0.07692546,0.09995002, _
0.1236454,0.1605811,0.2199936,0.2726182,0.2864496,0.248919,0.3618243,0.4987855, _
0.565353,0.7426175,0.6471487,0.7083491,0.6494353,0.6573817,0.771229,1.006141, _
1.076311,1.538597,1.071486,1.139749,1.230843,1.25286,1.247283,1.104146, _
0.9060992,0.7880294,0.9272401,0.9922419,0.8153412,0.5830501,0.4972364,0.3420495, _
0.242565,0.1840421,0.2276478,0.180238,0.2150496,0.3391697,0.4551696,0.582512, _
0.8407375,0.9138662,0.9929377,1.068643,0.8364449,1.097151,1.262062,1.271605, _
1.232992,1.213552,1.124303,1.086941,0.932637,1.026212,0.9180338,0.6671737, _
0.6425815,0.5524164,0.5839181,0.8345506,0.6652944,0.5530577,0.3503992,0.3451855, _
0.2938622,0.2151392,0.1632966,0.1246886,0.09546307,0.06581713,0.04647418, _
0.03280604,0.02330074,0.0177747,0.01357069,0.01015744,0.00784877,0.00542036, _
0.00307206,0.00288413,0.00194362

NP237F:
Data 66, 172, _
 1.870675E-07,3.732831E-07,1.878534E-06,6.88089E-08,2.439464E-05,6.188707E-05, _
1.504998E-04,3.684686E-04,6.627251E-04,0.00131849,0.00601294,0.01044062, _
0.02434307,0.05633868,0.1104736,0.2363335,0.3577776,0.4821873,0.7067264, _
0.9985518,1.27353,1.710462,2.135516,2.544159,3.420172,3.938418,4.347595, _
5.000727,5.245265,5.702981,5.49946,6.142352,6.072685,6.150194,6.442837,6.124364, _
5.768816,5.558099,4.123412,3.111566,2.334839,1.712623,1.29639,0.6371514, _
0.301735,0.09527849,0.07346124,0.0515581,0.05283343,0.04894715,0.04778631, _
0.04302248,0.05294127,0.0532655,0.05302229,0.05260609,0.06072722,0.07569814, _
0.07274681,0.131045,0.1649559,0.3560004,1.499034,1.758945,2.727417,3.600316, _
4.853945,6.467511,7.048923,7.269404,6.551699,6.349054,6.17394,5.668061,5.496813, _
5.34293,4.780852,4.658407,4.142292,3.456164,2.800172,2.22783,1.718609,1.303397, _
0.9940159,0.7272126,0.4599397,0.3651559,0.187241,0.1419319,0.1004968,0.03221492, _
0.01277158,0.00649181,0.0025085,7.795688E-04,3.025463E-04,1.295944E-04, _
5.622702E-05,1.923989E-05,1.124646E-05,1.553627E-06,3.987289E-07,1.295573E-07, _
4.075798E-07,1.210042E-07,4.672801E-07, _
 7.982672E-08,1.600455E-07,7.860854E-07,2.966662E-08,9.824337E-06,2.610118E-05, _
6.488319E-05,1.543636E-04,2.81653E-04,5.629144E-04,0.00252209,0.00447442, _
0.010263,0.01902241,0.04754018,0.09889464,0.1173987,0.1938947,0.2094664, _
0.3309849,0.4485351,0.370553,0.8109568,0.6863497,0.8669541,0.7108815,1.132242, _
1.06798,1.16004,1.264613,1.120308,1.802488,0.9325845,1.348477,1.546736,1.298343, _
1.769942,1.194365,0.9960545,0.7454689,0.4934295,0.4833059,0.3626264,0.3305806, _
0.1374243,0.04063506,0.03092277,0.02216676,0.02231257,0.02065763,0.01979678, _
0.01528641,0.01733484,0.02002962,0.02160771,0.01673976,0.01858957,0.02756047, _
0.02665685,0.0440241,0.05462082,0.1443875,0.5793831,0.7048376,0.7671804, _
0.7923254,0.7573077,0.8819409,0.6407088,1.087475,1.191678,0.8079731,0.7322096, _
1.21818,0.9730046,1.214441,0.8627712,1.080551,0.8892856,0.7566066,0.8613978, _
0.7048253,0.4241078,0.5514475,0.3291911,0.3152005,0.1925952,0.1531853, _
0.07158935,0.06041628,0.04313437,0.01348846,0.00549727,0.00275123,0.00105812, _
3.361137E-04,1.268175E-04,5.538142E-05,2.405948E-05,8.059012E-06,4.848745E-06, _
6.55996E-07,1.687743E-07,5.58231E-08,1.501353E-07,5.187682E-08,1.992424E-07

NP237HE:
Data 66, 172, _
 0.00500078,0.00700121,0.00900122,0.01200152,0.01500499,0.02000283,0.02500395, _
0.03300516,0.04300803,0.05301105,0.07007196,0.09501936,0.119954,0.1599095, _
0.1992263,0.2606777,0.3522658,0.4497222,0.5372703,0.7764863,0.8934161,1.182932, _
1.487258,2.032246,2.571905,2.675688,3.992715,4.792158,5.151352,5.58041,5.523332, _
5.3876,5.287126,4.887401,5.206399,5.001207,4.600973,4.331047,3.996505,3.451083, _
3.001445,2.500566,1.900021,1.456032,1.302153,1.214339,1.212032,1.230256, _
1.230238,1.229594,1.230313,1.230297,1.229669,1.229704,1.229634,1.259456, _
1.299848,1.349865,1.408776,1.499603,1.898768,2.503111,2.89831,3.30121,3.616927, _
4.091825,4.39876,4.499304,5.441403,5.001944,4.881315,5.204677,5.026281,4.784565, _
4.829754,4.801114,4.494755,3.549047,3.001683,2.503559,2.000053,1.702403, _
1.199206,0.900031,0.7022309,0.5297467,0.3998053,0.3149134,0.2499969,0.1799145, _
0.1399302,0.09259658,0.07996043,0.06790283,0.05015784,0.03498312,0.02698511, _
0.01999046,0.01599556,0.01199538,0.0094952,0.00699604,0.00549611,0.00419738, _
0.00320222,0.00238839,0.00189859, _
 0.00209396,0.00292727,0.00371072,0.00505613,0.00595931,0.00830293,0.01051666, _
0.01360779,0.01785084,0.02211705,0.02898438,0.03980704,0.04956283,0.05266112, _
0.08341049,0.1075296,0.1138472,0.1789914,0.2095387,0.2545242,0.3098672, _
0.4991243,0.6156122,0.5672346,0.66106,0.5610678,1.042096,1.011363,1.121634, _
1.22474,1.128034,1.533343,0.9414267,1.070055,1.244198,1.05907,1.369243, _
0.9065803,0.9606797,0.7327442,0.637702,0.6631956,0.5153911,0.5070711,0.5392649, _
0.5041538,0.5021578,0.5184436,0.5087792,0.5095608,0.4998867,0.4467969,0.4035677, _
0.4920555,0.4429184,0.4051113,0.4928279,0.5210946,0.4552375,0.474387,0.4414889, _
0.5879306,0.8562832,0.6597582,0.8934488,0.823028,1.049794,1.006667,0.9789196, _
1.111211,0.8545313,1.114072,1.176941,1.001769,1.082799,1.036706,0.9503173, _
0.9250123,0.6306326,0.6781823,0.6591119,0.7043048,0.4905733,0.3710721,0.295291, _
0.2199783,0.1651365,0.1323453,0.08885875,0.07571294,0.05806849,0.03851231, _
0.03361905,0.02799275,0.02109212,0.01455601,0.01114435,0.00842036,0.00660163, _
0.00500875,0.00397469,0.00288713,0.00231502,0.00174089,0.0010728,0.00100512, _
7.828604E-04

NP237T:
Data  66, 172, _
 4.88015E-08,8.7917E-08,4.87436E-07,1.94954E-06,5.856687E-06,1.463877E-05, _
2.931632E-05,8.839597E-05,2.633843E-04,4.397225E-04,0.00185441,0.00432474, _
0.01267357,0.02632537,0.03464454,0.1174701,0.1759685,0.3414395,0.4385167, _
1.068729,1.098717,1.811305,2.186141,2.863659,3.532445,3.676803,4.135007, _
4.692737,5.125458,5.731821,5.68972,5.859629,5.860496,6.660647,5.351025,6.640117, _
5.087504,5.778161,3.871065,2.657717,3.301011,2.410496,1.77774,1.099969, _
0.5390783,0.136614,0.05854912,0.03903301,0.03415364,0.01625724,0.019658, _
0.01778255,0.01670859,0.01619936,0.0142949,0.01586618,0.01773686,0.01960208, _
0.02614262,0.0295414,0.07080501,0.183504,0.5221743,0.9710044,1.839655,3.157179, _
4.567892,6.474188,7.311868,7.691932,6.914595,6.360175,6.255343,6.193016, _
6.021587,6.021975,4.947321,5.04912,4.848925,3.618247,2.811174,2.500003,1.656529, _
1.549034,0.7375935,0.7418379,0.3640288,0.1960164,0.1048227,0.07861539, _
0.06145641,0.02429906,0.01286392,0.00102558,3.735266E-04,2.329763E-04, _
1.400094E-04,5.5963E-05,2.333169E-05,1.04789E-05,2.523714E-06,9.339129E-07, _
1.867115E-07,6.99319E-08,9.32884E-09,4.67309E-09,9.3298E-10, _
 2.073298E-08,3.963304E-08,2.071478E-07,8.359715E-07,2.504788E-06,6.331963E-06, _
1.262213E-05,3.813062E-05,1.165037E-04,1.881726E-04,7.864005E-04,0.00194847, _
0.00537033,0.00912557,0.01568717,0.04977857,0.05813381,0.1455097,0.1786386, _
0.3591832,0.4125206,0.4763534,0.5304852,0.6165894,0.889601,0.7859307,0.938554, _
1.049675,1.132536,1.321115,1.182191,1.848757,1.034382,1.426025,1.320735, _
1.417212,1.48486,1.316964,0.9628245,0.6941522,0.7166371,0.7053646,0.4928105, _
0.4270431,0.2603896,0.06176491,0.0265669,0.01667051,0.01469777,0.00693927, _
0.00880984,0.00687729,0.00564587,0.00696754,0.0057465,0.00504698,0.00629387, _
0.00748691,0.00955276,0.00982359,0.03103581,0.06957265,0.2040018,0.3957478, _
0.5667672,0.7584867,0.8124241,1.306053,0.9208207,1.305664,1.185002,1.396055, _
1.088992,1.390003,1.285495,1.439163,1.06195,1.098545,1.128573,0.7790791, _
0.9212052,0.7358063,0.4494408,0.6660087,0.3121281,0.3364639,0.1539117, _
0.08331702,0.04588791,0.03349368,0.02640954,0.01069007,0.00559882,4.413654E-04, _
1.604393E-04,1.038745E-04,5.982041E-05,2.369374E-05,1.057227E-05,4.435858E-06, _
1.069804E-06,4.224827E-07,7.913221E-08,2.99139E-08,3.98532E-09,2.013234E-09, _
4.016746E-10

NP238F:
Data 66, 172, _
 1.294034E-07,5.470966E-07,2.288708E-06,6.961822E-06,1.592556E-05,4.382611E-05, _
1.591693E-04,2.992732E-04,6.47095E-04,0.00289042,0.00523172,0.01445154, _
0.03036929,0.0577145,0.09803019,0.1699255,0.2395369,0.3880968,0.6266895, _
0.7615635,1.119407,1.39899,1.750036,2.327389,2.747729,3.235638,3.639422, _
4.216536,4.980963,5.086402,5.441891,5.659004,5.643804,6.213391,6.106448, _
6.055525,6.145103,5.815892,5.684963,4.26172,3.843513,2.444156,1.655633, _
0.8960831,0.4799167,0.229224,0.12938,0.06990561,0.07364716,0.07117409, _
0.06079326,0.06085396,0.05979809,0.05834208,0.05931543,0.06149522,0.06438803, _
0.07207333,0.08323155,0.126409,0.184557,0.2724071,0.5857215,1.011625,2.090145, _
3.476654,5.148221,5.765419,7.994832,6.446291,6.959301,6.763392,6.248219, _
5.801846,5.799464,4.9363,5.747904,4.389727,4.14492,3.279148,2.855114,2.392059, _
1.767293,1.753111,0.9034751,0.8945931,0.6438333,0.4324232,0.2882826,0.2017969, _
0.1249214,0.0778366,0.04324292,0.02594499,0.01345375,0.00700225,0.00291626, _
9.416956E-04,2.789446E-04,8.174784E-05,2.691362E-05,1.153104E-05,4.134798E-06, _
1.24946E-06,3.07588E-07,6.728252E-08,5.76797E-09, _
 5.669983E-08,2.440785E-07,9.789179E-07,3.104057E-06,6.727808E-06,1.889523E-05, _
7.143652E-05,1.286977E-04,2.834994E-04,0.001286,0.00223911,0.00644037,0.013248, _
0.02017448,0.04399094,0.07289494,0.08097453,0.1664002,0.2458962,0.2552743, _
0.4256033,0.6204495,0.4894684,0.6988835,0.6944607,0.6971738,0.9801685,0.9488883, _
1.080001,1.323531,1.151794,1.686388,1.006957,1.336414,1.390289,1.333704, _
1.765443,1.372977,1.518253,0.9821594,0.8570787,0.7361589,0.4620662,0.3435633, _
0.2370395,0.10335,0.05757353,0.02999264,0.03300524,0.03061143,0.02684236, _
0.02504132,0.02062804,0.02528215,0.02242885,0.02037136,0.02426321,0.02778756, _
0.02827915,0.04241236,0.08139461,0.109351,0.225969,0.4261431,0.7097121, _
0.8534111,0.9347087,1.176629,1.895891,1.399892,1.227848,1.534948,1.347264, _
1.401069,1.25313,1.123279,1.292541,0.9547307,1.080224,0.7065989,0.9632148, _
0.6706328,0.7615467,0.4565301,0.3879067,0.3955278,0.2850311,0.1853992,0.1278816, _
0.08740396,0.05449748,0.03480887,0.01850727,0.01154533,0.00592232,0.00301155, _
0.00130938,4.063201E-04,1.222924E-04,3.648409E-05,1.151539E-05,5.144163E-06, _
1.811285E-06,5.391461E-07,1.36026E-07,2.896597E-08,2.536182E-09

PA231F:
Data 66, 172, _
 9.859495E-05,1.771181E-04,3.448204E-04,6.895311E-04,0.00128046,0.00246211, _
0.00443255,0.00890268,0.01674222,0.03151514,0.05912383,0.0989258,0.1968682, _
0.3966535,0.6881593,0.9903762,1.691732,2.299778,4.09495,4.617091,5.043211, _
5.891594,6.628855,7.078433,6.93192,6.456943,6.732646,6.621672,6.461996,6.38346, _
4.972485,4.355209,3.168896,2.544867,1.979816,1.38497,0.6429865,0.3706733, _
0.1956621,0.14764,0.1037071,0.09552687,0.07874161,0.07957546,0.0690636, _
0.09528118,0.05851088,0.08096395,0.06105772,0.0833059,0.06466703,0.06569061, _
0.06671859,0.06877308,0.07287858,0.07902725,0.08721146,0.09855357,0.116361, _
0.1457553,0.1931844,0.2915846,0.5289598,1.034249,2.085015,2.667323,3.584338, _
5.092382,6.364538,6.674606,7.285893,7.156854,7.488075,7.368133,6.716192, _
6.839452,6.198158,5.332872,4.697146,3.211158,2.607386,2.027285,1.559834, _
0.922141,0.5506546,0.3164078,0.1794691,0.07696655,0.04150145,0.02074801, _
0.01037308,0.00518722,0.00321523,0.00155554,7.363505E-04,3.736448E-04, _
1.970304E-04,1.037257E-04,4.148691E-05,2.055244E-05,9.325365E-06,3.627089E-06, _
1.556768E-06,6.220173E-07,3.114617E-07,1.55625E-07,1.036842E-07, _
 4.289763E-05,7.61191E-05,1.462202E-04,3.018071E-04,5.0626E-04,0.0010591, _
0.00192366,0.00375978,0.00722843,0.01345662,0.02530593,0.04262975,0.08309545, _
0.1312545,0.2941233,0.4229069,0.560238,0.6857005,0.7682554,0.8176288,0.8882493, _
1.320731,1.416309,1.547367,1.436495,1.430473,1.522601,1.404853,1.514607, _
1.381022,1.032266,1.327993,0.8216768,0.6646891,0.4829512,0.6581925,0.2461947, _
0.2000898,0.07183298,0.06659862,0.04517319,0.04053024,0.03424285,0.03129211, _
0.02969074,0.04095858,0.02496246,0.0353126,0.02577201,0.03596943,0.02584704, _
0.02249543,0.0220668,0.02535539,0.0304413,0.0254128,0.02612227,0.03579735, _
0.04422279,0.05226694,0.07014435,0.1249443,0.1977569,0.4074911,0.6388212, _
0.6375552,0.8539048,1.050706,1.216691,1.463878,1.282612,1.275935,1.674502, _
1.567959,1.550936,1.488782,1.349439,1.235252,0.9995986,0.8502364,0.8865969, _
0.5979888,0.664607,0.3894368,0.239469,0.1358673,0.0761774,0.03362653,0.01543839, _
0.00902294,0.00445942,0.00220437,0.0014069,6.584414E-04,3.180262E-04, _
1.620655E-04,8.314618E-05,4.532771E-05,1.772178E-05,8.769125E-06,4.075862E-06, _
1.531523E-06,6.757327E-07,2.683221E-07,1.096205E-07,6.810127E-08,4.405259E-08

PU238F:
Data 66, 172, _
 1.224462E-06,2.035375E-06,6.117401E-06,2.039301E-05,7.131648E-05,1.834099E-04, _
4.281173E-04,4.609456E-04,0.00126734,0.0024327,0.00786289,0.02128769,0.03647488, _
0.06736991,0.1111937,0.1827259,0.2751976,0.3783337,0.5897804,0.7325104,1.02211, _
1.168523,1.582721,2.097805,2.46175,2.953232,3.453248,4.052854,4.802197,4.439692, _
5.341872,5.658639,5.598281,6.135979,6.112407,6.048102,6.138802,5.89666,5.69863, _
4.770565,4.241429,3.010745,2.140371,1.216494,0.6084834,0.3058194,0.1631041, _
0.08240476,0.0815516,0.08343393,0.0750519,0.07501546,0.07441731,0.0728878, _
0.07488359,0.07782998,0.08244926,0.09279641,0.1098946,0.149767,0.2302302, _
0.3695402,0.6578375,1.119185,2.22784,3.915864,5.304242,5.872996,6.596228, _
6.745116,7.320863,6.586524,6.314111,5.73702,5.614694,4.785239,5.869922,4.540011, _
3.926993,3.237748,2.767061,2.236533,1.757,1.597834,0.9824042,0.908011,0.6785139, _
0.4689712,0.3193968,0.2394752,0.159649,0.09978167,0.07972195,0.03592268, _
0.01999391,0.01023525,0.00374409,0.00179566,6.978841E-04,2.993539E-04, _
1.297398E-04,4.499233E-05,6.984564E-06,3.997885E-06,1.697823E-06,6.987111E-07, _
3.79663E-07, _
 4.850942E-07,8.352399E-07,2.750537E-06,9.303265E-06,2.980902E-05,7.443241E-05, _
1.713194E-04,1.979626E-04,5.947205E-04,0.00106085,0.00317451,0.00850473, _
0.01557027,0.02278096,0.05084305,0.07513943,0.08813114,0.1449224,0.2714199, _
0.2494119,0.3532026,0.3160536,0.6826661,0.5458174,0.6344658,0.6270323,0.7594346, _
0.8633175,1.254619,0.9912015,1.086473,1.617039,1.107236,1.433497,1.497577, _
1.275579,1.581805,1.247971,1.409132,1.083743,0.8932071,0.8077865,0.6899779, _
0.4552339,0.2459272,0.1637248,0.07005347,0.03363346,0.03691045,0.0362456, _
0.02698148,0.02301789,0.0295999,0.02443437,0.03155576,0.02558007,0.02485717, _
0.03549737,0.04508251,0.05466716,0.08636858,0.1606835,0.2666332,0.4078935, _
0.6555058,0.9152209,1.169719,1.1124,1.418115,1.429381,1.345131,1.52112,1.536887, _
1.213064,1.110055,1.008781,1.377009,1.04651,0.8297697,0.8616945,0.6843607, _
0.5886428,0.4304725,0.6588028,0.3886005,0.3793693,0.3145004,0.2103298,0.1197643, _
0.09768484,0.06563038,0.04425594,0.03745532,0.01514313,0.00793206,0.00419329, _
0.00166911,8.196763E-04,3.061391E-04,1.218529E-04,5.173331E-05,1.923567E-05, _
3.297729E-06,1.751211E-06,5.931924E-07,2.848712E-07,1.611371E-07

PU239F:
Data 66, 172, _
 8.680869E-07,2.862627E-06,8.423419E-06,3.124203E-05,8.681548E-05,2.024115E-04, _
5.196785E-04,7.066586E-04,0.00173666,0.00254663,0.00581028,0.01269305, _
0.02291215,0.06073928,0.09228528,0.1420408,0.2189055,0.3153309,0.4777756, _
0.6245013,0.7685531,1.030506,1.31706,1.743756,2.071348,2.520027,3.015737, _
3.781406,4.276312,4.688247,4.859753,5.299067,5.609514,6.005319,6.547979, _
6.669768,6.73131,6.828742,6.576367,5.369249,4.366061,3.221035,2.002562,1.036177, _
0.6475781,0.3570115,0.1889251,0.1276598,0.09426344,0.08140602,0.06035537, _
0.06987054,0.05986282,0.05501733,0.05568852,0.06308457,0.06990402,0.07680782, _
0.120773,0.1778428,0.2666447,0.5009764,0.8788109,1.450814,2.454295,3.878483, _
5.329477,6.970454,7.373923,7.554983,6.929867,6.674805,6.16537,5.627697,5.333657, _
5.147736,4.746747,4.347591,3.674127,3.006336,2.460187,1.990602,1.661006, _
1.241493,0.9968772,0.7849252,0.6266911,0.4258395,0.267246,0.2088174,0.1547517, _
0.1061351,0.06565636,0.03854638,0.01605129,0.00864894,0.00613974,0.00314657, _
0.00179267,8.968647E-04,6.347059E-04,2.668618E-04,7.658663E-05,2.582422E-05, _
7.658345E-06,2.578538E-06,7.663477E-07, _
 3.458204E-07,1.182436E-06,3.814229E-06,1.42055E-05,3.570537E-05,8.25673E-05, _
2.093865E-04,3.046633E-04,8.136244E-04,0.00110281,0.00234772,0.00509559, _
0.00986885,0.02052906,0.04183653,0.05851818,0.07030586,0.1211096,0.1567054, _
0.2126355,0.26833,0.1968474,0.3919345,0.2879908,0.5349211,0.7476287,0.7267264, _
0.6699995,0.6604758,1.049312,0.988911,1.519327,0.7095124,1.40188,1.604566, _
1.409894,1.751976,1.234442,1.271617,1.209076,0.9197497,0.8619414,0.6000009, _
0.3950808,0.1870461,0.1932718,0.09422421,0.05748588,0.03750587,0.03464573, _
0.02816713,0.02604443,0.01906454,0.01955032,0.02561911,0.0204249,0.02149812, _
0.02633876,0.04935167,0.06614785,0.04005666,0.2204903,0.3497962,0.5879004, _
0.62163,0.6741741,0.8368073,0.8772553,0.7472553,0.9678736,1.564204,0.4564373, _
0.4885807,1.201378,1.17938,1.002333,0.6680684,1.133515,0.7943597,0.8088215, _
0.5834385,0.4747615,0.413033,0.4705399,0.3971359,0.3242415,0.168351,0.1908797, _
0.1042461,0.08578604,0.06291512,0.04636193,0.03098983,0.01651703,0.00644659, _
0.00355379,0.00267391,0.00143429,8.040856E-04,3.687291E-04,2.530656E-04, _
1.121814E-04,3.580815E-05,1.150881E-05,2.813283E-06,1.058765E-06,3.171191E-07

PU239HE:
Data 66, 172, _
 6.225972E-05,9.831454E-05,2.176064E-04,3.707943E-04,6.704286E-04,0.00119604, _
0.00218454,0.00375947,0.0058806,0.01022988,0.01641844,0.02370264,0.04146976, _
0.08615795,0.1561051,0.2726443,0.3501312,0.4730066,0.730958,1.029856,1.111199, _
1.285044,1.893307,2.093148,2.136099,2.240457,2.899892,3.182194,3.532176, _
3.940775,4.37921,4.5673,4.849157,4.7645,5.124148,4.997589,5.476413,5.207741, _
5.438741,4.27958,3.577797,2.862293,2.39758,2.475843,1.745581,1.547298,1.392304, _
1.295265,1.256601,1.271724,1.157195,1.151457,1.265308,1.25186,1.248023,1.444536, _
1.460721,1.729728,1.882186,1.954903,2.546901,2.205153,2.718458,3.388101,4.47234, _
4.365778,5.231208,4.865559,6.005656,6.377105,6.197665,4.589047,4.13096,4.133972, _
3.843757,3.560563,3.106279,2.80939,2.70498,2.158801,1.744048,1.709635,1.295557, _
1.055323,0.9937657,0.7376105,0.5399975,0.4577183,0.3269021,0.2331494,0.2139721, _
0.1132989,0.07308692,0.05251003,0.03538582,0.01850494,0.00904885,0.00319492, _
0.00184092,7.370659E-04,5.048872E-04,2.740563E-04,1.376209E-04,6.420609E-05, _
4.804772E-05,3.670801E-05,1.841619E-05, _
 2.494637E-05,3.91926E-05,8.631217E-05,1.486885E-04,2.515695E-04,4.758009E-04, _
8.728283E-04,0.00149398,0.0022982,0.00407081,0.00654688,0.00939287,0.01647092, _
0.02735507,0.06231922,0.1082575,0.1102698,0.1803099,0.2701659,0.3303272, _
0.3627849,0.5170844,0.5686475,0.4842945,0.8114336,0.5956658,0.816141,0.6467261, _
0.9335233,0.8074903,0.8041893,1.205946,1.1353,1.051759,0.9213544,1.114555, _
1.444287,1.095793,1.123902,0.8796615,0.9354994,0.5897084,0.6696419,0.7547658, _
0.6410382,0.6132658,0.5584252,0.5154334,0.5005119,0.4940274,0.4153474,0.3719384, _
0.399611,0.4367349,0.4620193,0.4456702,0.4680686,0.6292778,0.6155633,0.6275371, _
0.4642719,0.7699458,0.7715936,0.8189418,0.9310408,0.8484098,1.007721,1.128263, _
0.9636547,1.343862,1.163839,0.6161253,0.5898976,0.9337742,0.8018152,0.7490985, _
0.7345743,0.5756883,0.7107306,0.6236212,0.6495251,0.6836271,0.4340951,0.4232222, _
0.3948198,0.2953343,0.1937483,0.1816509,0.1032975,0.09260269,0.08564661, _
0.04519067,0.02913633,0.02105113,0.01405461,0.00741182,0.00335813,0.00127094, _
7.382861E-04,2.854978E-04,2.003323E-04,1.096288E-04,5.4665E-05,2.574255E-05, _
1.566118E-05,1.461865E-05,7.391293E-06

PU239T:
Data 66, 172, _
 2.208503E-07,4.489698E-07,1.620852E-06,5.888474E-06,1.991037E-05,3.665489E-05, _
1.214428E-04,2.619899E-04,6.3595E-04,0.0013723,0.00293614,0.00723454,0.0187695, _
0.04362649,0.0937373,0.1837777,0.2297108,0.2966512,0.4732846,0.5807691, _
0.7483376,0.9900881,1.312794,1.719099,2.153562,2.48871,2.988235,3.745615, _
4.358535,4.849266,4.896388,5.41442,5.804398,6.238735,6.777501,6.019096,6.12585, _
6.994607,6.08412,5.654659,4.350492,3.330019,2.163559,1.478,0.6453729,0.2959899, _
0.1285072,0.08166269,0.06025306,0.0425993,0.05067778,0.04445965,0.03248685, _
0.03224954,0.03058468,0.03780659,0.04469353,0.04411842,0.0787171,0.1116571, _
0.2021637,0.5064075,0.7340041,1.37124,2.361852,3.856462,5.406877,7.015683, _
7.665568,7.626193,6.977841,6.716598,6.162849,5.663007,5.366999,5.247752, _
4.919877,4.419634,3.740922,2.989794,2.458402,2.002953,1.641711,1.216911, _
0.9674715,0.7384156,0.5763097,0.3612539,0.2597833,0.1657226,0.1240166, _
0.07415033,0.04143775,0.02065298,0.00968167,0.00484091,0.00223123,9.166919E-04, _
3.295999E-04,1.3432E-04,6.662734E-05,1.521096E-05,4.2853E-06,1.473389E-06, _
3.175225E-07,1.570915E-07,4.940206E-08, _
 8.854489E-08,1.894331E-07,7.539655E-07,2.595472E-06,7.474656E-06,1.496326E-05, _
5.038341E-05,1.158739E-04,2.912174E-04,5.768947E-04,0.00117611,0.00288388, _
0.00837372,0.01483524,0.04076329,0.07577856,0.07799824,0.08720565,0.1544385, _
0.1847408,0.2546199,0.09566308,0.05127024,0.1655047,0.4010099,0.4473761, _
0.1182803,0.1715038,0.236057,1.402812,1.314301,1.435129,1.102259,1.339724, _
0.7749092,0.8015198,1.552163,1.511095,0.8685256,0.8737043,0.9863276,0.7074199, _
0.3303441,0.5202847,0.1352954,0.1593627,0.06322441,0.03684733,0.02409699, _
0.01793614,0.0236012,0.01661196,0.01054606,0.01157451,0.01397192,0.01216359, _
0.01395863,0.01500233,0.03204317,0.040737,0.0301714,0.1297959,0.2520239, _
0.5375128,0.4501397,0.3226009,0.300649,0.5733863,0.5172224,0.7445731,1.234372, _
0.2382042,0.412366,0.5697137,0.5019239,0.624254,0.6183698,0.8588387,0.8122986, _
0.6681643,0.6401421,0.4892944,0.4943874,0.4430864,0.3876983,0.3054338,0.1574376, _
0.1630669,0.1050401,0.06866241,0.05000158,0.03170632,0.01949931,0.00894846, _
0.00394285,0.00200764,9.459495E-04,4.107516E-04,1.513759E-04,5.587345E-05, _
2.66361E-05,6.318093E-06,1.950307E-06,6.624134E-07,1.254374E-07,6.509951E-08, _
2.000929E-08

PU240F:
Data 66, 172, _
 8.870859E-07,1.332534E-06,3.113038E-06,4.889081E-06,1.193644E-05,3.400735E-05, _
1.087675E-04,3.086637E-04,7.83767E-04,0.00170435,0.004092,0.01078649,0.02219437, _
0.04165462,0.07076576,0.1179898,0.1732201,0.2254427,0.3609105,0.4588282, _
0.6077096,0.8421464,0.947188,1.427432,1.831604,2.196237,2.653793,3.443548, _
3.993021,4.460794,4.739962,5.169101,5.470549,5.959893,6.81725,6.479862,6.666604, _
6.612749,6.823414,5.600085,5.095044,3.927546,2.794729,1.746015,0.9416327, _
0.4872109,0.2279719,0.14958,0.09112041,0.06124971,0.06482513,0.0637521, _
0.05899468,0.05855488,0.06707098,0.06803153,0.07599847,0.08694175,0.1098788, _
0.089288,0.2715031,0.4176429,0.6931763,1.149031,2.03139,3.520317,5.042097, _
6.918223,7.465742,7.448484,6.501619,6.693836,6.474196,6.012129,5.507714, _
5.016522,4.877429,4.444355,3.963439,3.080765,2.553768,2.202896,1.772976, _
1.336187,1.085456,0.8504798,0.6511018,0.5145973,0.3095765,0.2355131,0.1739397, _
0.1302769,0.07778389,0.03590435,0.0194006,0.01186752,0.00686406,0.00216679, _
0.00116337,5.701024E-04,3.033264E-04,1.818788E-04,9.094201E-05,9.262151E-05, _
2.01969E-05,1.111758E-05,6.059988E-06, _
 3.567165E-07,5.505192E-07,1.377482E-06,2.244548E-06,5.161971E-06,1.400686E-05, _
4.362184E-05,1.306443E-04,3.677245E-04,7.609533E-04,0.00169617,0.0044034, _
0.00925713,0.0141705,0.03322261,0.04969093,0.05572603,0.08828591,0.1142634, _
0.1556798,0.2384559,0.2251273,0.389144,0.4841171,0.4674676,0.5549454,0.716727, _
0.7285428,0.8772686,1.030877,0.9804219,1.534474,0.8448591,1.348481,1.698975, _
1.382761,1.744268,1.408753,1.359342,1.45679,1.123864,0.8578038,0.5968645, _
0.6436353,0.3741185,0.2713026,0.1181599,0.06800985,0.03702541,0.02530981, _
0.02954128,0.02799708,0.02123002,0.02300756,0.02805061,0.02266667,0.02794651, _
0.03078065,0.04224299,0.03138235,0.07283071,0.17868,0.2806703,0.4821188, _
0.6275632,0.765632,0.9226561,1.28642,1.379887,1.33561,1.208533,0.7487128, _
1.164646,1.338667,1.164059,1.124403,0.8662626,1.15984,1.085509,0.6537195, _
0.7546741,0.6963804,0.3657337,0.5967543,0.4470756,0.3516117,0.2273193,0.2325018, _
0.1397948,0.09848367,0.06956057,0.05434964,0.03609979,0.01625493,0.0081791, _
0.00490339,0.00281992,9.606936E-04,5.508107E-04,2.432483E-04,1.219756E-04, _
7.51308E-05,4.023982E-05,4.253401E-05,8.602778E-06,4.593921E-06,2.431874E-06

PU240HE:
Data 66, 172, _
 6.18112E-05,1.325238E-04,2.453557E-04,5.007295E-04,0.00100157,0.00214526, _
0.00457476,0.00840323,0.01634385,0.03268779,0.05219585,0.07613587,0.1102428, _
0.1592043,0.2204589,0.3001134,0.4027767,0.5072517,0.6064464,0.8839592,1.02171, _
1.225622,1.469872,1.763998,1.991064,2.45524,2.856946,2.831017,3.550421,3.7119, _
4.141405,4.280293,4.736724,4.88851,5.211073,5.396852,5.437108,5.289664,5.207905, _
4.762669,4.021794,3.146933,2.637318,2.295104,1.952286,1.671297,1.568383, _
1.717413,1.248626,1.19282,1.066062,0.8615466,0.9846866,1.004041,1.064989, _
1.166135,1.247784,1.369452,1.536282,1.613512,2.064748,2.002732,2.917076, _
2.860409,4.30879,4.459473,4.58974,5.552468,5.467067,5.340811,5.697428,4.596389, _
5.457705,4.593761,3.852975,3.587233,3.894281,3.10509,2.671574,2.688496,2.129996, _
1.785567,1.510875,1.367679,1.069144,0.8113719,0.6529083,0.5802942,0.4004067, _
0.279434,0.2260454,0.1603263,0.1101984,0.07028597,0.05218976,0.03477363, _
0.02346554,0.01632484,0.01021814,0.00693786,0.00448884,0.00285724,0.00183627, _
0.00115414,7.414392E-04,5.302402E-04,3.672784E-04, _
 2.507928E-05,5.363621E-05,9.855056E-05,2.037755E-04,3.842578E-04,8.648028E-04, _
0.00185827,0.00337691,0.00653008,0.01321526,0.02102503,0.03075423,0.04436146, _
0.05148662,0.08932035,0.1205928,0.1277982,0.1956083,0.2295129,0.2878177, _
0.3391341,0.4998335,0.515372,0.4663405,0.5351402,0.6893776,0.6756659,0.5778307, _
0.92916,0.7734709,0.8566239,1.206018,0.8598081,1.086736,1.244086,1.138755, _
1.552405,1.091177,1.248384,0.9903472,0.859076,0.841507,0.5385993,0.7317971, _
0.4769447,0.6726511,0.5117825,0.6986608,0.5018755,0.4788246,0.4093403,0.2994269, _
0.3155356,0.3845867,0.3746496,0.3674794,0.4556812,0.5158375,0.4874239,0.4954346, _
0.4779025,0.3311376,0.592602,0.7390354,0.8650575,0.7520263,0.7795846,1.25407, _
0.8571225,0.8357825,1.276871,1.040819,1.213539,0.9715437,0.9141026,0.7396647, _
1.026729,0.6527915,0.7507765,0.7181218,0.7602643,0.4663645,0.5432665,0.4355244, _
0.4322897,0.3273138,0.2517708,0.2331724,0.1276131,0.112806,0.09116647, _
0.06524833,0.04431647,0.02848753,0.02153001,0.01398315,0.00933746,0.00658299, _
0.00412625,0.00279338,0.00180234,0.00115992,7.435014E-04,4.64401E-04, _
2.353568E-04,2.135609E-04,1.483842E-04

PU240T:
Data 66, 172, _
 1.597265E-07,3.097852E-07,9.387989E-07,2.974387E-06,9.995162E-06,1.797067E-05, _
5.989953E-05,1.497765E-04,2.994904E-04,8.983754E-04,0.00179788,0.00589355, _
0.01697,0.01595628,0.03863456,0.1100973,0.120093,0.2493714,0.3936183,0.49678, _
0.6664724,0.8154327,1.186349,1.336846,1.873424,2.214412,2.658463,3.391805, _
3.955096,4.71439,4.737209,5.172245,5.916987,5.998755,6.700979,5.925857,6.155492, _
5.965729,6.093924,5.672867,5.268205,4.197064,3.267404,2.148332,1.459942, _
0.3994415,0.1997217,0.109891,0.09986059,0.06993061,0.04993081,0.04297018, _
0.04195859,0.04195937,0.03086458,0.03080889,0.03379636,0.04174232,0.060663, _
0.0607347,0.1390045,0.3585563,0.6966661,1.353808,2.161168,3.339956,4.815279, _
6.71366,7.610041,7.238787,6.829706,6.708979,6.435058,5.992557,5.705688,5.495297, _
4.777723,4.496249,3.930003,3.076677,2.569488,2.123453,1.771369,1.394958, _
1.063843,0.8547112,0.6559417,0.4571708,0.3279743,0.2584008,0.1391382,0.09938595, _
0.0725513,0.04472436,0.02186772,0.00894498,0.00119214,9.1449E-04,3.181589E-04, _
1.095135E-04,6.459225E-05,2.387779E-05,9.244609E-06,3.675022E-06,9.941708E-07, _
2.386007E-07,7.6498E-08, _
 6.416582E-08,1.278074E-07,4.166398E-07,1.374225E-06,4.345173E-06,7.397553E-06, _
2.397725E-05,6.353168E-05,1.414169E-04,4.037927E-04,7.470758E-04,0.00239994, _
0.00708514,0.00544622,0.01826735,0.04650117,0.03867647,0.09691121,0.1726555, _
0.16928,0.2631885,0.3364066,0.4873043,0.5967915,0.4779687,0.7040448,0.7217042, _
0.7176698,1.060181,1.102882,0.9840322,1.524878,1.101399,1.358898,1.676911, _
1.270154,1.603774,1.272742,1.495277,1.47485,1.171444,0.9147113,0.6950452, _
0.7920725,0.4189066,0.2241048,0.105065,0.05026687,0.04080183,0.02887014, _
0.02280791,0.01909189,0.01528666,0.01649673,0.01290505,0.01032454,0.01273853, _
0.01457433,0.0233311,0.02100534,0.07107244,0.1512046,0.282777,0.5619738, _
0.6726923,0.7760014,1.026838,1.228717,1.846925,1.518884,1.254816,1.43759, _
1.547965,1.345446,1.204746,1.240797,1.032191,1.182607,1.064095,0.6518114, _
0.823029,0.6749626,0.4623762,0.6268216,0.440951,0.3525623,0.2766702,0.2081119, _
0.1503475,0.1081585,0.05555392,0.041394,0.03370379,0.02045105,0.00930525, _
0.00368896,4.887786E-04,4.056122E-04,1.51861E-04,4.701487E-05,2.599307E-05, _
9.85446E-06,4.08164E-06,1.697091E-06,4.310045E-07,9.865739E-08,3.061752E-08

PU241F:
Data 66, 172, _
 1.876056E-07,1.314032E-06,2.816988E-06,1.031923E-05,3.285957E-05,8.446396E-05, _
1.501241E-04,4.777285E-04,0.00112659,0.00281548,0.00563157,0.00969329, _
0.01839616,0.03581313,0.06452428,0.09259929,0.1429735,0.2029575,0.3129497, _
0.4887637,0.5801659,0.7815604,0.9564395,1.298776,1.591914,1.936708,2.369013, _
2.887638,3.376962,3.82071,4.306215,4.468308,4.753847,5.570532,5.969599,6.490914, _
6.864937,6.506914,7.27901,6.60963,6.247308,4.906668,3.54115,2.352853,1.400499, _
0.6445846,0.3177857,0.21324,0.1173923,0.1090194,0.09692666,0.0880455,0.0833592, _
0.08238874,0.08650462,0.09158464,0.09465463,0.1017744,0.1131018,0.151115, _
0.223768,0.3322852,0.6583809,1.167463,1.862436,3.362871,4.710133,6.455916, _
7.506952,7.080053,6.431367,6.568322,6.169255,6.373962,5.312863,5.080355, _
4.610234,4.684844,4.171229,3.340222,2.807811,2.224198,1.954226,1.460339,1.23056, _
0.911266,0.7319071,0.5505978,0.3813318,0.3358458,0.2442518,0.1628341,0.1119487, _
0.06513233,0.03969168,0.02340775,0.01178781,0.00522747,0.00331303,0.00153717, _
6.213945E-04,3.106441E-04,1.24275E-04,5.905952E-05,1.65426E-05,5.790651E-06, _
1.656129E-06, _
 7.658071E-08,5.455765E-07,1.210136E-06,4.727268E-06,1.49192E-05,3.526465E-05, _
6.035612E-05,1.997389E-04,5.205976E-04,0.00128967,0.00241798,0.00400168, _
0.00750987,0.0123493,0.03084016,0.04019468,0.04839284,0.08171427,0.09454601, _
0.1664681,0.2486297,0.2618091,0.3890755,0.5598571,0.4104029,0.4747235,0.7031425, _
0.8059016,0.5974137,0.9939655,0.7470695,1.229466,0.8832026,1.193393,1.430959, _
1.468435,1.77106,1.469363,1.408466,1.582315,1.428173,1.053711,0.7640311, _
0.8106518,0.2962604,0.2548844,0.1655927,0.09735768,0.04845992,0.04526793, _
0.04350962,0.03970637,0.03222248,0.03340206,0.03304397,0.03101085,0.04006454, _
0.03737314,0.0388785,0.05102137,0.05855951,0.1383024,0.2664398,0.4987854, _
0.6656869,0.8140703,0.7878706,1.311401,1.407772,1.518638,1.040646,1.044952, _
1.405771,1.53859,1.172744,1.114379,0.9827819,0.8273309,1.092481,0.7198666, _
0.9143011,0.6671507,0.4557818,0.4953158,0.5345644,0.3783589,0.2987568,0.24241, _
0.09625363,0.1445307,0.09876132,0.06757034,0.04940134,0.03005694,0.01793342, _
0.00972386,0.00474632,0.00221193,0.00156541,6.926491E-04,2.604218E-04, _
1.29142E-04,5.162842E-05,2.646373E-05,7.741899E-06,2.466969E-06,6.680306E-07

PU241T:
Data 66, 172, _
 1.671409E-07,5.04729E-07,1.410445E-06,3.641847E-06,1.397829E-05,5.235576E-05, _
2.431344E-05,5.784134E-05,9.468834E-05,2.844872E-04,9.487893E-04,0.00189471, _
0.01151735,0.01494321,0.02910687,0.06218109,0.1367985,0.2012836,0.3295315, _
0.4273018,0.5783352,0.7346503,0.9661501,1.228448,1.590033,1.868657,2.285764, _
2.884391,3.4652,3.949291,4.414053,4.808243,4.991881,6.001462,6.263775,6.231934, _
6.654564,6.775715,7.151231,6.100328,6.108146,4.886318,3.768285,2.587273, _
1.326748,0.5855118,0.2184863,0.1519239,0.07108641,0.03808764,0.02778751, _
0.02362515,0.02315743,0.02315682,0.02562355,0.02587905,0.02588388,0.02670523, _
0.03235074,0.0469015,0.0820796,0.2325286,0.378922,0.8201703,1.81839,3.10116, _
4.564552,6.725917,7.88164,7.181904,6.838293,6.818564,6.64179,6.288313,5.776362, _
4.909019,4.722926,4.587073,4.229491,3.279229,2.769508,2.28495,1.929421,1.476484, _
1.209708,0.9130222,0.7176315,0.5405836,0.3791148,0.2414145,0.1721244,0.1353686, _
0.09224503,0.04802976,0.02049884,0.00846899,1.273367E-05,5.906626E-06, _
1.966927E-06,6.157383E-07,4.145778E-07,1.035821E-07,9.50666E-06,4.024463E-06, _
1.642353E-06,2.192652E-07,7.312835E-08, _
 7.046253E-08,2.12949E-07,6.342884E-07,1.65783E-06,5.428828E-06,2.186537E-05, _
1.019048E-05,2.52817E-05,4.311901E-05,1.240135E-04,3.977605E-04,7.827027E-04, _
0.0048941,0.00508924,0.01309615,0.02615817,0.04439878,0.07893088,0.1025535, _
0.1454952,0.2164755,0.1385368,0.08253044,0.09138194,0.1840172,0.5292929, _
0.476943,0.5492688,0.6135678,1.028368,0.7587938,1.371019,0.8877598,1.30371, _
1.467287,1.384509,1.815755,1.426704,1.631996,1.442711,1.388152,1.041534, _
0.9918757,0.6775531,0.3743199,0.3288596,0.08298954,0.07070176,0.0327067, _
0.01608683,0.01180475,0.01074517,0.00879228,0.00957618,0.00938693,0.00875843, _
0.01070842,0.00992808,0.01081412,0.01556089,0.03473344,0.09157219,0.1498652, _
0.3455395,0.622386,0.7543042,0.7515159,1.277053,0.9483648,1.115277,1.114242, _
0.4863442,0.3384239,0.483924,0.7636299,0.9775592,0.9784357,0.8130687,1.099424, _
0.7146219,0.9276825,0.5480863,0.528002,0.384538,0.5273794,0.3068015,0.3017641, _
0.2311893,0.126817,0.1075394,0.07224085,0.05708849,0.03881399,0.02158204, _
0.00935782,0.00360276,5.358399E-06,2.477056E-06,8.543903E-07,2.83481E-07, _
1.819291E-07,4.341582E-08,4.004561E-06,1.703636E-06,7.429292E-07,9.919094E-08, _
3.087448E-08

PU242F:
Data 66, 172, _
 2.889856E-06,5.791355E-06,8.693542E-06,1.158401E-05,2.891611E-05,5.793362E-05, _
1.25433E-04,2.415287E-04,7.725079E-04,0.00115831,0.00241313,0.006829,0.01348791, _
0.03372851,0.05432862,0.09209882,0.1257247,0.1778687,0.2922093,0.3719808, _
0.5230251,0.6155801,0.7890354,1.101475,1.414309,1.813205,2.128047,2.676351, _
3.217655,3.654649,4.303299,4.475908,4.783007,5.483025,6.096469,5.990137, _
6.419559,6.542945,6.438879,7.008796,5.76495,5.02725,4.395261,3.192894,2.080813, _
1.222247,0.6535766,0.318057,0.13305,0.1091528,0.09754846,0.09826714,0.08779444, _
0.08779282,0.08291627,0.08202187,0.08387063,0.08844041,0.1005201,0.1288967, _
0.1680766,0.277498,0.516961,1.230873,2.0047,3.107153,4.484683,6.639594,7.362753, _
7.028082,6.649417,6.455123,6.228567,6.091946,5.460069,5.025118,4.572553, _
4.555168,4.258991,3.393569,2.912566,2.370548,1.998196,1.576114,1.320261, _
0.9879605,0.7903996,0.6233218,0.4356885,0.3281637,0.2370087,0.164082,0.1093884, _
0.06563193,0.04102097,0.02370128,0.01276153,0.00546891,0.00136678,9.374737E-04, _
4.558732E-04,1.820761E-04,7.294433E-05,4.377063E-05,2.093565E-05,1.184966E-05, _
6.384152E-06, _
 1.201431E-06,2.425976E-06,3.60025E-06,5.076488E-06,1.306595E-05,2.442814E-05, _
5.127339E-05,1.006748E-04,3.362431E-04,5.204661E-04,0.00105426,0.0028382, _
0.00551189,0.01199162,0.0248703,0.04042236,0.04498686,0.07345621,0.1026524, _
0.125405,0.2292711,0.2580669,0.3189633,0.4601469,0.4763968,0.4965347,0.7505822, _
0.7037907,0.5884319,0.9623714,0.9357478,1.171549,0.9343839,1.160093,1.397889, _
1.362632,1.631264,1.370416,1.645367,1.566514,1.367953,1.068309,0.989629, _
0.7847964,0.5953156,0.3454621,0.256914,0.1547353,0.05993726,0.04582457, _
0.04003325,0.0428482,0.03874607,0.03645785,0.02690889,0.02851479,0.03764307, _
0.03519097,0.03231283,0.04418323,0.06730811,0.1036434,0.1986444,0.407087, _
0.7516432,0.7864347,0.7720966,1.340674,1.379326,1.537067,1.191243,1.225886, _
0.9115322,1.579499,1.205548,1.08529,1.004313,0.9604422,1.10699,0.7429699, _
0.7841032,0.6451436,0.5368817,0.5256861,0.5781055,0.3305049,0.3231108,0.263978, _
0.1453819,0.1420343,0.09748066,0.06866709,0.04610299,0.02922671,0.01851924, _
0.00989589,0.00521274,0.00227866,6.108067E-04,4.194852E-04,1.941871E-04, _
7.602778E-05,2.988467E-05,1.870489E-05,9.559196E-06,5.100912E-06,2.62233E-06

PU242HE:
Data 66, 172, _
 2.078047E-07,4.176738E-07,7.329608E-07,1.55879E-06,3.119995E-06,5.221397E-06, _
1.138691E-05,1.861135E-05,5.226319E-05,5.218268E-05,2.096057E-04,0.00518265, _
0.01453494,0.029151,0.05419683,0.09225433,0.1346615,0.2190052,0.2225359, _
0.7975692,0.7993203,0.9818854,1.129261,1.342445,1.605345,2.139168,2.388227, _
2.53736,2.901626,3.418199,3.875924,4.271199,4.519655,5.168239,5.075411,5.08594, _
5.368128,5.675316,5.475249,5.581331,5.069857,3.83465,3.037836,2.543533,2.33435, _
2.234185,1.932371,1.780167,1.425522,1.237393,0.9164058,0.8103119,0.7127608, _
0.6109374,0.6109397,0.6474499,0.7758396,0.8807051,1.076352,1.329445,1.564449, _
1.987632,2.461395,2.658609,2.938601,3.781458,5.269388,5.556796,5.898229, _
6.192919,5.371401,5.282886,5.25585,4.936516,4.886029,4.828543,4.295112,3.639548, _
3.167291,2.569991,2.158325,1.956934,1.759793,1.594553,1.274397,0.9051966, _
0.8725941,0.6592931,0.455775,0.3684291,0.2714731,0.1783957,0.1192556,0.073589, _
0.04581278,0.02685651,0.01396056,0.00611747,0.00305441,0.00203448,0.00102716, _
3.975716E-04,1.724583E-04,9.670737E-05,4.584731E-05,1.970825E-05,1.531853E-05, _
 8.465135E-08,1.729085E-07,2.996019E-07,6.38726E-07,1.257975E-06,2.124234E-06, _
4.695466E-06,7.652593E-06,2.123794E-05,2.158923E-05,8.569824E-05,0.00211758, _
0.00600988,0.01041079,0.02235007,0.03793282,0.04605676,0.08935639,0.07533582, _
0.2605811,0.3113015,0.3977789,0.4683628,0.5465954,0.6559602,0.5093921,0.6798666, _
0.6712206,0.6031318,0.8943616,0.7945521,1.175386,0.8210819,1.071823,1.083507, _
1.081344,1.450048,1.289789,1.395854,1.238255,1.088234,0.8037307,0.7920746, _
0.6147116,0.6949754,0.6233474,0.4032905,0.5153239,0.6425152,0.6128507,0.379347, _
0.3293703,0.2831123,0.2485439,0.1991536,0.2118811,0.2870815,0.314392,0.4140742, _
0.4585042,0.6249226,0.4055461,0.9501359,0.6969593,0.8641375,0.7312637,0.8133894, _
1.098781,1.183634,1.089822,1.016689,1.098709,1.043287,1.065132,1.022832, _
1.126648,0.8952647,0.7989092,0.6815414,0.7575712,0.6919027,0.797277,0.4524531, _
0.6536412,0.5215589,0.3741658,0.3543572,0.2725841,0.1724039,0.1507833,0.1122755, _
0.07264199,0.04917868,0.03026071,0.01867915,0.01111653,0.00569994,0.00250769, _
0.00126254,8.279724E-04,4.237608E-04,1.633278E-04,7.03215E-05,4.004067E-05, _
1.705721E-05,8.085086E-06,6.333014E-06

PU242T:
Data 66, 172, _
 4.971499E-08,9.9395E-08,2.282874E-07,4.976315E-07,1.789031E-06,2.685271E-06, _
9.950019E-06,2.987626E-05,7.956223E-05,1.992847E-04,4.171507E-04,0.00268942, _
0.00646157,0.00743709,0.01957375,0.04094576,0.06070523,0.1389209,0.2349071, _
0.3778232,0.4820568,0.6646816,0.8396089,0.920763,1.286674,1.696459,2.02465, _
2.550987,3.241914,3.81955,4.276957,4.531751,5.563276,6.04909,6.16162,6.094092, _
6.13377,6.233124,6.212528,6.044531,5.940906,5.485682,4.447323,3.503704,2.607383, _
1.105912,0.3979169,0.2590416,0.149219,0.119559,0.07970504,0.04987071,0.04981701, _
0.04981558,0.03586747,0.02473799,0.02474312,0.03167963,0.04063903,0.05559311, _
0.1185863,0.208643,0.4150355,0.8443568,1.630638,2.617253,3.970382,5.848285, _
7.385812,7.531796,7.074927,6.9382,6.651304,6.444174,6.036258,5.305358,4.644698, _
4.559638,4.18922,3.464757,2.810811,2.387707,1.986967,1.601747,1.261253,1.022541, _
0.8017054,0.6235491,0.4354946,0.3167224,0.237542,0.1682581,0.118772,0.07917951, _
0.05146779,0.02474397,0.00890723,0.00395928,0.00148546,2.976695E-04,1.38527E-04, _
3.96352E-05,1.286965E-05,3.46899E-06,1.979013E-06,9.893542E-07,4.944756E-07, _
 2.080439E-08,4.157852E-08,9.474828E-08,2.21502E-07,8.318688E-07,1.143152E-06, _
4.048249E-06,1.246243E-05,3.515623E-05,9.144685E-05,1.857035E-04,0.00111812, _
0.00262765,0.0026464,0.0091681,0.01830389,0.02224458,0.05727012,0.08590576, _
0.1285965,0.2193461,0.2791193,0.3411281,0.3859689,0.5943229,0.4559967,0.8473306, _
0.6711061,0.6883991,1.024528,1.111724,1.180884,0.8906966,1.283454,1.427818, _
1.420666,1.537525,1.302955,1.622158,1.351146,1.448026,1.1791,0.9782066, _
0.8571371,0.749533,0.6076112,0.2250132,0.1308064,0.06844458,0.05561797, _
0.03246866,0.02178692,0.02297903,0.0208854,0.01150571,0.00877454,0.01144855, _
0.01297598,0.01319705,0.01882704,0.04787643,0.07672767,0.1611293,0.3641367, _
0.623251,0.6994708,0.9196327,1.195683,1.803294,1.698937,1.280152,1.546804, _
1.448128,1.546231,1.37584,1.133097,1.047492,0.9685628,1.104393,0.952886, _
0.7304237,0.6341277,0.6116891,0.4215744,0.5750533,0.4267373,0.3257253,0.262966, _
0.2028362,0.1418565,0.09903727,0.07038763,0.04957979,0.03537323,0.02411754, _
0.01050101,0.00362283,0.00165016,6.607044E-04,1.365217E-04,6.133654E-05, _
1.651866E-05,5.236419E-06,1.476292E-06,9.251471E-07,4.405036E-07,2.054155E-07

TH227T:
Data 66, 172, _
 8.52473E-08,2.157486E-07,8.235662E-07,2.348944E-06,5.197259E-06,1.273913E-05, _
5.691525E-05,9.361161E-05,2.648542E-04,7.847611E-04,0.00225602,0.01089143, _
0.03720397,0.6434287,1.882635,3.485717,4.883939,5.652719,6.089515,6.781999, _
6.986066,7.061135,7.064992,7.65627,7.706656,6.170123,4.723169,4.368998,3.679965, _
3.388658,2.613838,2.38309,1.363788,1.435981,0.9368855,0.749314,0.5816461, _
0.56993,0.3115199,0.2796191,0.173294,0.0940906,0.05388883,0.03374447,0.03531358, _
0.04098927,0.02871351,0.03669637,0.03030321,0.03021461,0.03232394,0.03827207, _
0.04747581,0.06345081,0.08383914,0.1135956,0.1091422,0.2212154,0.31372,0.500067, _
0.5690891,0.6731641,0.9262833,1.428623,1.864073,2.626347,3.388653,4.839018, _
5.726812,6.770896,7.565365,7.058391,7.254691,7.558729,7.748536,7.641498, _
7.442986,6.994688,5.967237,3.106312,1.037378,0.1833941,0.03131262,0.01010278, _
0.00202082,5.046262E-04,2.018037E-04,1.010362E-04,4.03827E-05,1.009376E-05, _
5.048839E-06,1.519412E-06,5.757E-07,2.017371E-07,1.009449E-08,6.057821E-09, _
3.030101E-09,1.010881E-09,6.056001E-10,3.0251E-10,1.008E-10,5.979E-11,3.009E-11, _
9.54001E-12,4.03E-12,1.55E-12,0, _
 3.160201E-08,9.355202E-08,4.53105E-07,1.198836E-06,2.384296E-06,4.928726E-06, _
2.592571E-05,4.727435E-05,1.465114E-04,3.450628E-04,8.394084E-04,0.00429683, _
0.02027676,0.2389224,0.51541,0.7087514,1.504425,1.270151,1.246322,1.201847, _
1.214673,1.49977,1.865656,1.566007,1.9616,1.321032,1.028115,1.042543,1.050222, _
0.9456066,0.7141485,0.8111259,0.3599291,0.3072631,0.4006892,0.3054477,0.234155, _
0.2724319,0.1067268,0.1196312,0.09609705,0.04618447,0.02176372,0.01205833, _
0.01913696,0.02092436,0.01274194,0.01459509,0.01537932,0.01571634,0.01637774, _
0.01265551,0.01821914,0.02279439,0.04697246,0.0381253,0.03536021,0.07458138, _
0.1691023,0.1291738,0.1726008,0.3020222,0.3822109,0.5305858,0.5399001,0.7183899, _
0.3788667,1.011345,1.468369,1.415786,1.594672,1.754794,2.046288,1.716305, _
1.462612,1.63451,2.086975,1.900936,1.435687,0.8582152,0.4473168,0.0923572, _
0.0173838,0.00450614,7.575799E-04,2.116859E-04,1.083554E-04,5.247907E-05, _
1.988065E-05,4.041168E-06,2.077479E-06,7.279908E-07,3.240871E-07,9.624418E-08, _
4.134612E-09,2.428438E-09,1.522357E-09,5.253205E-10,3.2466E-10,1.264138E-10, _
3.782351E-11,2.698579E-11,1.682039E-11,5.105018E-12,2.5792E-12,9.92001E-13,0

TH229T:
Data 66, 172, _
 3.021744E-08,7.18874E-08,2.703013E-07,1.145194E-06,3.645054E-06,1.560674E-05, _
7.187618E-05,2.600093E-04,0.0010411,0.00338304,0.01197313,0.04205552,0.2557194, _
0.422642,1.633482,2.300182,3.457586,5.194316,9.213787,9.34447,8.187587,7.19124, _
8.173024,9.198595,8.393294,6.615963,5.942635,4.830236,4.144693,2.679188, _
1.381865,0.7314557,0.2711253,0.1523838,0.03603429,0.01308176,0.00655119, _
0.00598422,0.01003016,0.00817424,0.01201761,0.0108121,0.01173153,0.01289036, _
0.01691478,0.02164984,0.02083577,0.01700316,0.02148558,0.01983129,0.01961891, _
0.02274667,0.01693086,0.01571257,0.01467822,0.01331039,0.01367158,0.01289344, _
0.01110501,0.00564322,0.01904016,0.03891911,0.0519346,0.1188127,0.4172659, _
0.6043554,1.20402,2.965704,5.960552,5.797479,5.83996,7.289948,7.893322,8.512355, _
7.939632,7.462582,7.285674,8.317463,9.760325,5.022272,3.379773,2.11435,1.021262, _
0.5884569,0.178462,0.03799855,0.00975603,0.00205822,4.832186E-04,9.847096E-05, _
2.598127E-05,7.156616E-06,1.792886E-06,5.277774E-07,1.342427E-07,3.573675E-08, _
8.863346E-09,2.689573E-09,8.946646E-10,2.683014E-10,7.13004E-11,1.780009E-11, _
5.16003E-12,1.50001E-12,1.33001E-12,0,0, _
 1.276929E-08,2.747918E-08,1.380888E-07,6.165263E-07,2.00701E-06,6.622505E-06, _
2.696993E-05,1.206709E-04,5.910043E-04,0.00176467,0.00547938,0.01502725, _
0.08813035,0.1559103,0.4906292,0.6409112,0.7509549,0.4709608,0.467,1.314035, _
1.689201,0.914705,0.4628946,0.5050144,0.5235888,0.9742175,0.8059707,0.47232, _
0.8627397,0.3864391,0.5089365,0.1746442,0.09506948,0.08739492,0.02216217, _
0.00780533,0.00383654,0.00299127,0.00397318,0.00333143,0.00665276,0.00575636, _
0.00540981,0.00429637,0.00885664,0.01172034,0.01069851,0.00636728,0.01013533, _
0.01056076,0.01084928,0.00875496,0.00624681,0.00567916,0.00838316,0.00465296, _
0.00495082,0.00424456,0.00579625,0.00236217,0.0114972,0.01798618,0.02250572, _
0.05191078,0.1402678,0.1627237,0.2236507,0.3287834,0.3131618,1.241212,1.063538, _
0.8208159,0.6394867,0.6388672,1.509344,1.254605,0.6657038,1.284661,2.036542, _
1.113311,0.7010218,0.4748755,0.2123549,0.2179306,0.0804207,0.01423351, _
0.00487716,0.00110411,2.678666E-04,4.273349E-05,9.66774E-06,3.24493E-06, _
1.00996E-06,2.806752E-07,6.547866E-08,1.329963E-08,4.027207E-09,1.39151E-09, _
5.100343E-10,1.285917E-10,2.798573E-11,7.209693E-12,3.30242E-12,9.60005E-13, _
8.51204E-13,0,0

TH232F:
Data 66, 172, _
 1.133007E-06,3.901269E-06,1.428673E-05,3.30318E-05,6.538691E-05,1.660977E-04, _
4.141246E-04,6.204804E-04,0.00115374,0.00283551,0.00673924,0.01176571, _
0.03515567,0.07648633,0.1867836,0.4709285,1.076082,2.15668,3.168877,4.97689, _
6.373123,6.951019,6.912892,7.526154,8.43059,7.462611,6.884263,6.415471,5.778937, _
5.752594,4.815221,4.466406,3.644961,2.983161,1.374787,0.713527,0.3677751, _
0.1553261,0.08904449,0.0525419,0.04891834,0.05107361,0.06123567,0.06595311, _
0.071366,0.0716184,0.07826046,0.07806502,0.073421,0.07700252,0.07379941, _
0.07381944,0.06327894,0.0572095,0.05432512,0.04880609,0.03652791,0.02936546, _
0.02647524,0.03295339,0.04797856,0.1014778,0.1822266,0.2521417,0.9440851, _
1.620837,2.970646,4.020586,5.204022,5.604632,5.544904,5.729562,6.47384,7.257795, _
7.908733,7.509957,6.463204,6.634217,7.889151,5.448672,4.581377,2.97859,1.999624, _
1.088533,0.5626237,0.3636493,0.07554483,0.0310079,0.00687556,0.00361702, _
0.00269088,9.322601E-04,4.641866E-04,9.771481E-05,6.91972E-05,1.448792E-05, _
7.976879E-06,4.651239E-06,2.031633E-06,3.536647E-07,1.386452E-07,9.765603E-08, _
5.301497E-08,2.689126E-08,1.068076E-08,4.640439E-09,2.389952E-09, _
 5.193934E-07,1.655818E-06,5.921557E-06,1.411545E-05,3.112462E-05,7.6159E-05, _
1.765915E-04,2.663262E-04,4.836056E-04,0.00127554,0.00325522,0.00508842, _
0.01458016,0.03035639,0.08429156,0.2189349,0.4451476,0.584229,0.8824022, _
0.8775352,1.626516,1.403283,1.51267,1.651877,1.042628,0.7617027,0.6826069, _
1.314983,1.248185,1.026032,1.255753,1.109064,0.9997987,0.8147248,0.6430492, _
0.3706189,0.209355,0.06008923,0.0421534,0.02376068,0.0202993,0.02249879, _
0.02970093,0.02863335,0.02958734,0.03040952,0.03737519,0.03527465,0.03063658, _
0.03296429,0.03212612,0.03416676,0.02862408,0.02422637,0.01753987,0.01801665, _
0.01701917,0.01316697,0.0096728,0.01041067,0.01767,0.03476036,0.06554161, _
0.08247717,0.3829779,0.5377102,0.5432513,0.9996557,1.295882,0.7449292,1.266844, _
0.8815026,1.414951,0.8689637,0.5369562,1.057105,1.2148,1.462836,1.415527, _
1.428399,1.139786,0.6472784,0.4813013,0.4667608,0.2712137,0.1637973,0.03162161, _
0.01329291,0.00296872,0.00168003,0.0012584,3.956016E-04,1.924281E-04, _
4.150665E-05,3.254337E-05,6.715208E-06,3.452687E-06,1.99197E-06,8.460199E-07, _
1.567761E-07,6.728524E-08,4.287126E-08,2.204231E-08,1.149291E-08,4.663866E-09, _
2.162884E-09,1.114856E-09

TH232HE:
Data 66, 172, _
 1.286217E-04,2.240238E-04,7.598372E-04,0.00151501,0.00278268,0.00530429, _
0.00787331,0.01626199,0.03021294,0.05304221,0.09064306,0.1309696,0.2486686, _
0.4120986,0.6739323,1.060875,1.375823,1.734673,1.176508,5.660922,5.249033, _
4.957835,5.064425,5.817682,6.533974,6.064689,5.433561,5.394196,5.546947, _
5.016028,3.817282,3.416977,2.688992,2.072184,1.645356,1.357788,1.02374, _
0.8859082,0.9451335,1.094613,1.199567,1.177843,1.27801,1.408837,1.38878, _
1.303289,1.471981,1.418936,1.331016,1.312196,1.27237,1.429681,1.113324,1.060307, _
0.9754855,0.9480711,0.847409,0.8076228,0.7966103,0.7209816,0.8751265,1.080389, _
1.160634,1.254578,2.44766,2.816572,3.429878,4.651662,6.582761,5.258525,6.395394, _
5.677941,5.781333,5.89215,6.010815,6.132499,5.368108,5.132715,4.218753,2.660497, _
2.461104,1.864806,1.066835,0.8148642,0.4106772,0.2325206,0.1293815,0.08958393, _
0.05517197,0.03165603,0.01831283,0.01061205,0.00624876,0.00455038,0.00172454, _
0.00105786,5.100076E-04,2.556052E-04,1.318793E-04,7.263546E-05,2.970711E-05, _
1.595798E-05,8.013707E-06,3.877542E-06,1.740338E-06,8.18438E-07,3.819301E-07, _
 5.375992E-05,9.226186E-05,3.191074E-04,6.278526E-04,0.00115014,0.00222823, _
0.00324255,0.006801,0.0125822,0.02191937,0.03807953,0.05389027,0.1043222, _
0.1575577,0.2786013,0.4472736,0.4923445,0.4536459,0.3915805,1.41942,1.263695, _
0.8538878,0.8814065,1.010506,1.38189,0.7210722,0.9220845,1.243032,1.207342, _
1.022285,0.9820173,0.8353009,0.8906862,0.551074,0.6765383,0.5631577,0.4179616, _
0.3651132,0.3096015,0.4558899,0.4946341,0.4929222,0.5289066,0.5816849,0.5830148, _
0.5368637,0.4759863,0.5930729,0.5484096,0.5545617,0.5273577,0.5868207,0.4563886, _
0.437607,0.3267779,0.3874412,0.2861675,0.3332959,0.298352,0.2794218,0.3027228, _
0.3422695,0.3420725,0.3371445,0.7109636,0.7165456,0.864158,0.9278039,1.359136, _
0.901371,1.121893,0.6335868,0.9405698,0.8452796,0.6958012,1.257963,1.133841, _
1.066997,0.9425659,0.7398184,0.8287126,0.4927653,0.4384218,0.3396279,0.1695839, _
0.0966533,0.05414933,0.0368843,0.02280551,0.0131245,0.00758505,0.00445901, _
0.00257434,0.00190083,7.205205E-04,4.357401E-04,2.141604E-04,1.059623E-04, _
5.463215E-05,3.052615E-05,1.223531E-05,6.66493E-06,3.345639E-06,1.597026E-06, _
7.174596E-07,3.39121E-07,1.583046E-07

U232T:
Data 66, 172, _
 0.00699599,0.00899462,0.01299275,0.01798943,0.02500403,0.03498069,0.04697309, _
0.06797189,0.0899522,0.129929,0.1709869,0.2499102,0.3497758,0.4797845,0.6401711, _
0.7997437,1.14422,1.499328,1.783741,2.691712,3.309161,4.362436,6.203865,6.96727, _
6.621186,7.161239,6.828914,7.27725,6.257245,6.208402,5.835437,5.433277,4.694567, _
4.214785,3.001459,1.999355,1.499457,1.061154,0.3497061,0.2434205,0.09994796, _
0.02598541,0.00819299,0.0089967,0.00829874,0.00914165,0.01099453,0.01399274, _
0.01599017,0.01878236,0.01547944,0.0144998,0.01143336,0.00870024,0.00811989, _
0.00863698,0.0144379,0.01905816,0.03156144,0.1583156,0.2286409,0.382981, _
1.062887,1.765775,3.01339,3.748975,5.17128,5.804564,5.234876,5.318989,7.125771, _
7.869682,5.646495,7.126929,7.304661,6.914626,6.350093,5.088131,4.330334, _
3.116057,2.505122,1.205581,0.952775,0.6670303,0.5112295,0.343031,0.2668023, _
0.1905701,0.134038,0.1048135,0.07622808,0.05240694,0.03335237,0.02096252, _
0.01454845,0.00857594,0.00571589,0.00352565,0.00238371,0.00171536,0.0011434, _
7.626057E-04,4.760448E-04,3.044366E-04,2.115891E-04,1.429331E-04,9.529766E-05, _
 0.00272239,0.00376563,0.00608709,0.00790514,0.00921698,0.01368251,0.01992844, _
0.0306275,0.03981127,0.05282808,0.06648523,0.09703864,0.1650393,0.1625985, _
0.2552475,0.3134701,0.4674033,0.5776697,0.4359609,0.6461703,0.8846208,0.7705545, _
0.6443098,0.755783,1.329584,1.440872,1.022644,0.8082206,0.7949488,1.305458, _
0.9159689,1.104127,1.151371,0.9369702,0.7491584,0.5391697,0.5814707,0.2336155, _
0.2013356,0.1321755,0.04819944,0.01049111,0.00343229,0.00296758,0.00348125, _
0.00369279,0.00426912,0.00579191,0.00746915,0.00798391,0.00547613,0.00439042, _
0.00477088,0.00287979,0.00328276,0.00277633,0.00449052,0.00686126,0.01501417, _
0.06415561,0.1313875,0.1639675,0.3925741,0.4537759,0.9313079,0.7516722,0.615732, _
1.098876,0.5576672,0.7012957,1.724299,1.779985,0.5311911,0.5418366,1.319966, _
1.54207,1.532696,1.069967,0.5930902,0.5657784,0.3816311,0.5387525,0.3370778, _
0.2683394,0.2170037,0.1544047,0.1178047,0.07804435,0.04260182,0.04324964, _
0.03534988,0.0234365,0.01397065,0.00842865,0.0059025,0.00376253,0.0026575, _
0.00148444,9.313944E-04,6.6712E-04,5.086235E-04,3.456067E-04,2.100035E-04, _
1.230362E-04,6.970409E-05,6.05875E-05,4.504663E-05

U233F:
Data 66, 172, _
 3.990206E-07,1.595608E-06,4.876099E-06,1.33007E-05,5.311572E-05,2.306885E-04, _
6.825146E-04,0.00156421,0.00372521,0.01108587,0.01970295,0.03725962,0.06206219, _
0.09750607,0.2115055,0.3702676,0.5922709,0.9923115,1.607457,2.159054,2.732672, _
3.809744,5.059229,5.809892,6.427629,6.454555,6.511715,6.903808,6.804344, _
6.295399,5.726004,5.429347,5.128244,4.708515,4.35867,3.893539,2.935405,1.664362, _
1.278235,0.8564113,0.3252559,0.145756,0.09749974,0.08524445,0.07992221, _
0.07368706,0.06485697,0.06263088,0.05586994,0.05477973,0.06548506,0.06572292, _
0.07068113,0.074922,0.07091754,0.08033518,0.07264647,0.07580675,0.1033842, _
0.14614,0.2844718,0.7396435,1.182897,1.738086,2.793121,3.742407,5.037387, _
6.037808,6.309772,6.420922,6.942595,6.828384,6.58843,5.898303,6.005381,6.248189, _
6.116155,5.52932,4.380434,3.201052,2.38166,1.685956,1.197376,0.7107698, _
0.4698641,0.3082855,0.1921871,0.1034521,0.04362486,0.02274118,0.01756587, _
0.01012125,0.00331722,0.00173391,4.187558E-04,9.47911E-05,2.271804E-05, _
1.042256E-05,3.501234E-06,1.156219E-06,6.721352E-07,9.381635E-08,2.46295E-08, _
8.24388E-09,2.46255E-09,7.5803E-10,2.8447E-10, _
 1.538013E-07,6.62439E-07,2.347962E-06,6.27143E-06,2.255496E-05,9.221398E-05, _
2.756537E-04,7.018276E-04,0.00184909,0.00486832,0.00779141,0.01462617, _
0.02833217,0.03387581,0.09825916,0.1499941,0.2013492,0.2540734,0.307221, _
0.7475842,0.7140064,0.4656757,0.7047985,1.519135,1.438826,1.408811,1.195785, _
0.9709059,1.392607,1.370816,1.066888,1.341782,0.8068678,1.217615,1.071756, _
0.8473003,0.6924706,0.4704691,0.1389498,0.4899321,0.09329432,0.06964612, _
0.04002266,0.03153998,0.0385619,0.03399609,0.02643412,0.02532612,0.02530511, _
0.0258048,0.028495,0.02104291,0.02565192,0.02581293,0.03437277,0.02595372, _
0.02135509,0.02576227,0.04754187,0.05848376,0.03017967,0.3321453,0.4723935, _
0.6423847,0.8076133,0.9250011,0.8021538,1.248829,0.8110638,1.372073,1.342915, _
1.243933,1.247658,1.259664,1.157705,1.323405,0.8455265,1.313096,0.9501443, _
0.8591336,0.5110483,0.4509994,0.4140924,0.2991765,0.1811348,0.127874,0.05099411, _
0.04823807,0.01721294,0.00916608,0.0073582,0.0046627,0.00163939,7.401162E-04, _
1.619784E-04,3.888274E-05,1.070448E-05,4.943691E-06,1.584508E-06,4.662498E-07, _
2.659748E-07,4.136953E-08,1.230054E-08,3.695357E-09,8.728897E-10,3.061565E-10, _
1.252996E-10

U233HE:
Data 66, 172, _
 6.694245E-04,0.00151467,0.00180277,0.00289945,0.00470379,0.00744545,0.01303136, _
0.01874737,0.0280824,0.04349855,0.06696913,0.1019584,0.1548128,0.2306241, _
0.335923,0.5424325,0.8383964,1.304888,1.984658,2.197735,2.637624,3.342733, _
3.961968,4.664592,4.807177,5.18482,5.455565,5.318841,5.08872,5.068744,4.819321, _
4.836758,3.935919,3.794008,3.088392,2.743745,2.507092,2.531972,1.971554, _
1.811293,1.387908,1.422649,1.431278,1.502362,1.322948,1.412377,1.690539, _
1.702444,1.228654,1.447279,1.381761,1.320992,1.285069,1.220152,1.159647, _
1.709819,1.235142,1.35142,1.514458,1.516258,2.310707,2.228019,2.541648,2.834433, _
3.200194,4.066984,3.983501,4.560313,4.983166,5.133527,5.653897,5.112441, _
6.409112,5.872849,5.029917,4.464476,4.395474,3.219949,2.47872,2.025789,1.629165, _
1.241184,0.8841757,0.6169577,0.4460758,0.3420161,0.2168181,0.1428683,0.09765298, _
0.06537434,0.04362319,0.02775977,0.01708082,0.01064964,0.00716245,0.00467251, _
0.00274854,0.00170597,0.0010471,6.258979E-04,2.635901E-04,2.178503E-04, _
1.327075E-04,8.281634E-05,4.360791E-05,2.367448E-05,2.272324E-05, _
 2.717469E-04,6.138603E-04,7.240465E-04,0.00118102,0.00180729,0.00300254, _
0.0052977,0.00753879,0.01122714,0.01758717,0.02700305,0.04117838,0.06228963, _
0.07399389,0.1358349,0.2186204,0.2681003,0.4954116,0.3854659,0.5545288, _
0.8406943,0.560778,0.6075649,1.040942,0.9542544,1.187744,1.140164,1.10976, _
1.1259,1.046308,0.8920636,1.293728,0.929476,0.9718774,0.7625535,0.735927, _
0.8122036,0.5229231,0.4669354,0.7326129,0.4864172,0.5778785,0.579748,0.5071911, _
0.5252791,0.5689149,0.551748,0.6725137,0.4940676,0.5830668,0.5254472,0.4485957, _
0.4085048,0.4537398,0.422856,0.5522321,0.429191,0.5041983,0.4853059,0.4785194, _
0.5174385,0.4689645,0.7280339,0.7044284,1.016016,0.7922196,0.6355253,1.083851, _
0.7370925,1.045277,1.285444,1.141082,1.115201,1.390593,0.9609333,0.9532461, _
0.9726492,0.6649344,0.6514422,0.4825387,0.6084086,0.5055466,0.3106531,0.2508628, _
0.1804545,0.1350367,0.08449886,0.05748339,0.03142098,0.02648903,0.01757326, _
0.01130453,0.00687358,0.00432201,0.00295989,0.00188582,0.00107092,6.861753E-04, _
4.263025E-04,2.475881E-04,1.059992E-04,8.86353E-05,5.337426E-05,3.364856E-05, _
1.413308E-05,9.534359E-06,9.249835E-06

U233T:
Data 66, 172, _
 2.502551E-07,1.119579E-06,3.423429E-06,9.405139E-06,3.667369E-05,1.618443E-04, _
4.16721E-04,0.0011557,0.00270854,0.00798039,0.01384595,0.02595825,0.05381089, _
0.1434735,0.2336686,0.3679972,0.586514,1.013669,1.637075,2.286758,2.793725, _
3.991101,5.458866,6.371397,6.836402,6.491316,6.523192,6.947972,6.875684,6.36354, _
5.679286,5.514951,5.178917,4.924585,4.460056,3.171171,2.402636,1.573172, _
0.9787734,0.4972616,0.2462747,0.1145293,0.07573259,0.03937386,0.03872445, _
0.02159965,0.01330408,0.01356184,0.01285886,0.0149809,0.0132005,0.01412358, _
0.01541667,0.01855763,0.02182876,0.02308055,0.04096749,0.06041372,0.07462078, _
0.1169592,0.225923,0.5556166,0.8356572,1.592379,2.091663,3.604288,4.953441, _
5.949944,6.300451,6.262645,6.797548,6.839653,5.920187,6.324751,6.424557, _
6.480861,6.665506,5.969125,4.725947,3.447068,2.586059,1.738358,1.301229, _
0.7784272,0.5057133,0.3157159,0.213634,0.1036818,0.04668831,0.02142904, _
0.01279465,0.00630303,0.0020549,8.8602E-04,3.165138E-04,1.215751E-04, _
1.271548E-05,5.927062E-06,1.951632E-06,6.321492E-07,3.674433E-07,5.083982E-08, _
1.289968E-08,4.404528E-09,1.618755E-09,4.460591E-10,1.507662E-10, _
 9.599022E-08,4.585687E-07,1.633633E-06,4.472201E-06,1.638543E-05,6.501286E-05, _
1.633835E-04,5.062972E-04,0.00136162,0.003607,0.00565416,0.01019166,0.02371228, _
0.05335404,0.1189083,0.1569054,0.1533502,0.2947621,0.57147,0.7812694,0.8085877, _
0.2196202,0.2438382,0.3357103,0.6721363,1.095366,0.9382318,1.662547,1.6487, _
1.331216,1.000072,1.161448,1.664425,1.058536,0.4323908,0.4637934,0.7802989, _
0.6376551,0.4838318,0.2369987,0.1329798,0.05760746,0.0347238,0.01490695, _
0.01835641,0.01013006,0.00552411,0.00545648,0.00576815,0.00669357,0.00609544, _
0.00474293,0.0052316,0.00640261,0.0109019,0.00747264,0.0126387,0.02379161, _
0.02927508,0.04081165,0.04609673,0.2370242,0.3091907,0.5816393,0.6180706, _
0.4099542,0.5336873,0.5399274,0.6301032,0.6996506,1.414497,0.266021,0.5194787, _
0.8597596,0.9768713,0.8944862,0.8774147,1.065089,0.2667048,0.7453937,0.6008084, _
0.4266303,0.2559165,0.3430985,0.198057,0.1280152,0.05850253,0.04933698, _
0.02113008,0.00868319,0.0050017,0.0027528,0.0010368,4.005344E-04,1.287283E-04, _
4.885375E-05,5.576525E-06,2.787017E-06,9.590309E-07,2.643544E-07,1.401449E-07, _
2.105956E-08,6.277389E-09,2.081085E-09,6.86134E-10,1.798773E-10,6.028194E-11

U234F:
Data 66, 172, _
 3.920485E-06,9.288475E-06,2.680505E-05,6.194913E-05,2.062796E-04,5.158895E-04, _
6.344081E-04,0.00107465,0.00414272,0.0117649,0.02609599,0.05677454,0.08876111, _
0.1444975,0.216423,0.3617076,0.6538793,1.206397,1.905204,2.22949,3.441612, _
2.956966,3.91744,5.45725,6.095132,6.434357,6.075294,6.094696,6.487726,6.356677, _
6.2288,6.040828,5.749469,5.09399,4.138037,3.394214,2.669827,2.417184,1.319326, _
1.239631,0.4291662,0.268439,0.1857241,0.1226682,0.1035256,0.05819447,0.07227239, _
0.0597416,0.05884942,0.06851701,0.05678621,0.05478764,0.05478659,0.05976792, _
0.06464456,0.06961518,0.08158562,0.0994532,0.1194408,0.1565011,0.2591549, _
0.3888607,0.6473057,1.616283,2.541028,3.736007,4.364336,6.463571,5.740695, _
5.578926,6.347684,5.974308,6.607046,6.025774,5.787398,6.50678,5.979162,6.150958, _
5.445931,3.992219,3.071782,2.017738,1.434132,1.036147,0.6373448,0.3181106, _
0.2486321,0.1487608,0.08056227,0.05072156,0.02088574,0.01093924,0.00636393, _
0.0020889,0.00109551,4.38086E-04,1.590877E-04,4.976593E-05,2.888591E-05, _
9.457287E-06,2.490052E-06,5.968053E-07,2.681295E-07,9.449201E-08,2.48373E-08, _
7.9609E-09,1.1923E-09, _
 1.533082E-06,3.805551E-06,1.238678E-05,2.915451E-05,9.164148E-05,2.097473E-04, _
2.496126E-04,4.642049E-04,0.00203804,0.00529597,0.01061041,0.02257599, _
0.03924876,0.04983786,0.1015554,0.1482143,0.2136898,0.4666048,0.4824258, _
0.7675483,0.8748702,0.7095152,0.8766831,1.425945,1.419817,1.365905,1.189363, _
1.082431,1.717583,1.442191,1.275902,1.70601,1.409082,1.330452,1.034423,0.717636, _
0.8532475,0.5152407,0.3635107,0.3563311,0.2462531,0.1353333,0.08544075, _
0.0489781,0.04400334,0.02730021,0.03299806,0.02430567,0.02397526,0.03113039, _
0.02731467,0.02040227,0.01744302,0.02129717,0.03103743,0.02312606,0.02799465, _
0.03416335,0.04899088,0.05807018,0.1001506,0.1729285,0.2639422,0.666375, _
0.7614155,0.8678845,1.071099,1.236929,1.420536,0.8659708,1.408136,1.31768, _
1.711007,1.334688,1.233378,1.405704,1.371538,1.602977,1.232794,0.8764481, _
0.7749004,0.5578567,0.3676361,0.4456423,0.2492866,0.1305998,0.116404,0.06990521, _
0.03434933,0.02065998,0.00830051,0.00478989,0.0031505,9.306122E-04,4.427251E-04, _
1.781376E-04,6.949399E-05,2.322396E-05,1.380733E-05,3.929011E-06,9.664285E-07, _
2.494675E-07,1.292437E-07,4.393263E-08,9.998119E-09,3.234035E-09,4.859442E-10

U234HE:
Data 66, 172, _
 4.461846E-04,0.00105283,0.0014714,0.00206031,0.00343508,0.00529806,0.01042513, _
0.01479942,0.02256795,0.03434297,0.05505985,0.08386921,0.1353236,0.2060893, _
0.2588344,0.4737055,0.8288235,1.173652,1.414255,2.395549,2.218323,3.152026, _
3.756223,4.342058,4.754412,5.008486,5.162002,4.985277,5.22604,5.046055,5.29685, _
5.04473,4.844559,4.268338,3.510777,3.167301,2.969872,2.298058,2.074154,2.141864, _
1.530669,1.233372,1.420293,1.256797,1.423571,1.318349,1.471315,1.304213, _
1.324604,1.328336,1.180296,1.193029,1.190144,1.170307,1.150472,1.33872,1.220241, _
1.299459,1.43021,1.610591,2.134946,2.198155,2.509244,3.19236,3.478321,3.708356, _
5.261597,5.010633,5.540261,5.459409,6.441389,5.077069,5.270981,5.285622, _
3.930893,3.68089,4.323082,3.287822,2.695677,2.341458,1.914242,1.282374,1.047559, _
0.6228092,0.4832662,0.3360505,0.2372111,0.1819419,0.08919317,0.06424594, _
0.0471188,0.03261674,0.01976898,0.01163766,0.0070201,0.00455113,0.00276813, _
0.00168043,9.897712E-04,5.831727E-04,2.577246E-04,2.073286E-04,1.186405E-04, _
7.907804E-05,3.897259E-05,2.075234E-05,1.680353E-05, _
 1.826637E-04,4.287416E-04,5.951705E-04,8.454691E-04,0.00132002,0.00215315, _
0.00426267,0.00598597,0.00908154,0.01395031,0.02236758,0.03406549,0.05472898, _
0.06614712,0.1052416,0.1922431,0.2662553,0.4477327,0.5511744,0.6103157, _
0.7119759,0.6680042,0.7962442,0.9639719,0.9435129,1.153529,1.079376,1.034456, _
1.156317,1.044448,0.9780777,1.353336,1.148322,1.093129,0.8694279,0.8533852, _
0.9620498,0.7124259,0.4913104,0.5589668,0.620869,0.5018139,0.5821955,0.4480889, _
0.5749608,0.5384163,0.5040655,0.5348363,0.5379236,0.5364102,0.4672765,0.4271842, _
0.3845517,0.4522136,0.4113019,0.4216861,0.4424058,0.490641,0.4565422,0.5047901, _
0.4823328,0.5384859,0.7229917,0.803722,0.9142414,0.7235827,0.9855277,1.180172, _
0.970825,1.127107,1.647152,1.140539,0.9179096,1.18212,0.8344804,0.7745931, _
0.9834495,0.6808311,0.7213313,0.6489183,0.7016873,0.5261537,0.3791859,0.2541497, _
0.1974755,0.1359586,0.09456557,0.07379931,0.02924983,0.02629225,0.01905585, _
0.01337334,0.00802839,0.00473393,0.00287472,0.00184063,0.00111228,6.814246E-04, _
4.033986E-04,2.354566E-04,1.041368E-04,8.499022E-05,4.814063E-05,3.216777E-05, _
1.246554E-05,8.39104E-06,6.876792E-06

U235F:
Data 66, 172, _
 7.230878E-07,2.327381E-06,4.036646E-06,8.708474E-06,1.889313E-05,4.641957E-05, _
1.658637E-04,5.234769E-04,0.00119063,0.00353079,0.01757676,0.03180818, _
0.05705767,0.0907376,0.1749391,0.2286915,0.3404135,0.5752432,0.9262118,1.465087, _
1.88956,2.468987,3.420131,4.399066,5.626073,5.748593,5.781825,6.129097,6.418098, _
6.480661,6.217292,6.013967,5.879849,5.985618,6.305944,5.124243,4.3587,3.243693, _
2.066711,1.20211,0.5328048,0.3023271,0.1306879,0.08141375,0.06517335,0.04257535, _
0.03771098,0.03261428,0.03229373,0.03387675,0.03400434,0.03681958,0.03363263, _
0.0350194,0.03529166,0.0368082,0.04040895,0.04406312,0.06333286,0.06802933, _
0.0973244,0.3064709,0.5040355,0.834744,1.79483,3.220123,4.671125,6.720931, _
7.625521,6.629701,6.059541,6.324691,6.713793,6.379676,5.982377,5.949734, _
5.525296,5.741403,5.261775,3.792449,2.923376,2.138872,1.682051,1.038252, _
0.6859217,0.4119866,0.2708549,0.1670553,0.07231851,0.03947148,0.02025852, _
0.01058248,0.00649522,0.00300716,0.00113201,3.332174E-04,5.782578E-05, _
9.621072E-06,5.772787E-06,2.306685E-06,9.623704E-07,3.84301E-07,9.613305E-08, _
5.769031E-08,1.922656E-08,6.727176E-09,1.923613E-09, _
 3.075478E-07,9.5083E-07,1.710786E-06,4.062165E-06,9.49472E-06,2.004404E-05, _
6.473509E-05,2.159527E-04,5.662334E-04,0.00170021,0.00819354,0.01301852, _
0.02255112,0.03169246,0.08906107,0.1033718,0.1197587,0.2266773,0.2285108, _
0.5136635,0.4464043,0.3258836,0.3139971,0.5394711,0.4807987,0.7919288,1.054056, _
0.2920174,0.3005614,0.7967634,0.8439644,1.606787,0.8510426,1.305635,1.677079, _
1.189642,1.081949,0.7893324,0.4325773,0.3429115,0.05994941,0.1714423,0.07024398, _
0.03457319,0.02553582,0.01943523,0.01893185,0.0136831,0.01251674,0.01452185, _
0.01717454,0.01620262,0.01191663,0.01333825,0.01589985,0.01281149,0.0179682, _
0.01612633,0.0215898,0.02268319,0.04538915,0.1231391,0.2064235,0.2790264, _
0.6220205,0.7315779,0.7599743,0.8976539,0.4589429,0.6681262,0.7070032,0.2380492, _
0.2220749,0.9564129,0.2682055,1.322317,0.4193934,0.3107469,0.6204321,0.84872, _
0.7561827,0.4594964,0.3821703,0.2726452,0.3171296,0.1687965,0.1082007, _
0.05788952,0.03673631,0.01779229,0.00818983,0.00432706,0.00291586,0.00143786, _
5.54512E-04,1.392622E-04,2.236937E-05,4.055436E-06,2.860445E-06,1.096062E-06, _
4.240306E-07,1.569895E-07,3.944504E-08,2.633E-08,9.723312E-09,2.967471E-09, _
7.638503E-10

U235HE:
Data 66, 172, _
 2.877192E-04,6.031931E-04,8.865694E-04,0.00132007,0.00236142,0.00394577, _
0.00601191,0.01134462,0.01700827,0.02698408,0.04001566,0.06658626,0.0996256, _
0.167681,0.2516182,0.3419706,0.5935373,1.099786,1.37678,1.793623,1.783813, _
2.380614,3.366988,4.162302,4.710167,4.836435,5.079415,5.085839,5.194139, _
5.200788,5.217666,5.525681,5.41118,5.160653,3.953702,3.452316,3.253406,3.204485, _
2.469104,1.880557,1.611393,1.285338,1.177188,1.171204,1.086158,1.079264, _
1.075815,1.091283,1.057012,1.091541,1.056207,1.06521,1.081827,1.084015,1.090325, _
1.053678,1.145964,1.192963,1.290026,1.460331,1.862136,2.180774,2.453603,3.37665, _
3.599647,4.102715,4.885822,5.528661,5.707504,5.73079,5.210431,5.016343,4.603212, _
4.827147,4.528828,4.485527,4.196489,3.820217,3.172958,2.712441,2.199175, _
1.623174,1.197542,0.8134843,0.5118293,0.3577337,0.2576451,0.2035873,0.1269613, _
0.07871858,0.05789097,0.03770252,0.0234678,0.01212324,0.00720748,0.00526052, _
0.00278191,0.00158397,9.759085E-04,5.375564E-04,2.796625E-04,1.852784E-04, _
1.064794E-04,7.801956E-05,3.252658E-05,1.7628E-05,1.655315E-05, _
 1.167468E-04,2.469572E-04,3.579196E-04,5.389886E-04,9.34199E-04,0.00159328, _
0.00246275,0.00459605,0.00686165,0.01103702,0.01616342,0.02712209,0.04045785, _
0.05557492,0.1028672,0.1399328,0.1892733,0.431518,0.5121922,0.5772272,0.6101484, _
0.5014319,0.4706581,0.5964516,0.986494,0.8848933,1.024809,1.045812,1.161016, _
1.098258,1.068157,1.518205,0.9709383,1.131917,0.9398205,0.7224261,1.036106, _
0.6661029,0.5909787,0.7502851,0.6561262,0.5201248,0.4821784,0.4340643,0.438055, _
0.4419659,0.4365877,0.4450127,0.4313075,0.3072215,0.4245608,0.4021473,0.3633316, _
0.4319398,0.366661,0.3434434,0.4360265,0.457457,0.4132418,0.3716091,0.4428216, _
0.4996574,0.7157078,0.5610899,0.8815577,0.8250141,0.8610294,1.225086,0.9183498, _
0.6866025,0.9230817,0.5929413,0.7472132,0.8308095,0.9395446,0.9246018,0.9012823, _
0.8415596,0.6572646,0.7091815,0.7429027,0.5240122,0.4585034,0.329792,0.2117366, _
0.1445051,0.1030939,0.0826421,0.04187519,0.03220816,0.02338463,0.01542218, _
0.00953878,0.0049138,0.00297498,0.0021268,0.00112238,6.467075E-04,3.943043E-04, _
2.190348E-04,1.135951E-04,7.515957E-05,4.360221E-05,3.152477E-05,1.048448E-05, _
7.187438E-06,6.734638E-06

U235T:
Data 66, 172, _
 7.221155E-08,3.605806E-07,7.157735E-07,1.572404E-06,3.617294E-06,8.384933E-06, _
2.649483E-05,1.017579E-04,3.385258E-04,0.0010677,0.00309725,0.00795941, _
0.0209287,0.04466554,0.1279504,0.2033144,0.3257495,0.534757,0.8940306,1.285686, _
2.031158,2.521424,3.534232,4.748485,5.88117,5.856083,5.975204,6.234634,6.575449, _
6.540931,6.355827,6.004722,5.752562,6.145833,6.297475,5.172552,4.298203, _
3.030785,1.874197,0.9709237,0.4016966,0.1461922,0.05407689,0.03117186, _
0.02553974,0.01743106,0.01304156,0.01420416,0.01183225,0.01258354,0.01324768, _
0.01276207,0.01134433,0.012874,0.0126085,0.01304529,0.01548211,0.01565748, _
0.02678666,0.03401805,0.05821392,0.1572559,0.3480327,0.5431402,1.811058, _
2.890825,4.31344,6.696198,7.84928,6.54644,6.097407,6.343482,6.775188,6.476025, _
6.222877,5.852969,5.829085,5.967125,5.502811,3.942641,2.997919,2.246727, _
1.672677,1.082445,0.6533272,0.4187668,0.2669133,0.1582784,0.07443416,0.03213494, _
0.01485293,0.00615086,0.00328518,0.00100941,3.190062E-04,8.52942E-05, _
1.590629E-05,6.101987E-06,1.881684E-06,9.514985E-07,3.624149E-07,2.471381E-07, _
5.704561E-08,2.385004E-08,5.006529E-09,2.347027E-09,7.686748E-10, _
 3.026989E-08,1.4718E-07,3.123155E-07,7.499138E-07,1.809397E-06,3.572812E-06, _
1.024456E-05,4.251923E-05,1.666097E-04,5.102658E-04,0.00135697,0.00331992, _
0.00826068,0.01078034,0.00985084,0.00766086,0.08450522,0.03408511,0.09063299, _
0.411958,0.1803774,0.06282173,0.1102757,0.06531929,0.4577789,0.05289498, _
0.1078261,0.0853548,0.08446699,0.3670528,0.6674448,1.423558,1.265029,0.8333609, _
1.658957,0.141908,0.7401456,0.4623724,0.2676036,0.08541009,0.02452209,0.0790517, _
0.02459732,0.01317107,0.01008488,0.00811633,0.00653271,0.0058953,0.00435748, _
0.00519794,0.00536591,0.00564873,0.00310278,0.00316413,0.00566042,0.00376496, _
0.00770107,0.00694663,0.00889678,0.0045201,0.02897836,0.01625092,0.1369769, _
0.04503055,0.561335,0.4048246,0.1336618,0.2617706,0.4718021,0.2103039,1.000651, _
0.149312,0.1512627,0.1224305,0.1634888,0.1948924,0.1960194,0.2993665,0.1328077, _
0.1975699,0.6782757,0.2674503,0.3584795,0.1553164,0.2878789,0.1729659, _
0.09223162,0.05548479,0.03759471,0.01385616,0.00576662,0.00255666,0.00160218, _
4.899529E-04,1.470975E-04,3.496666E-05,6.370334E-06,2.740941E-06,9.690534E-07, _
4.329489E-07,1.471368E-07,1.010872E-07,2.583985E-08,1.152474E-08,2.432947E-09, _
9.828711E-10,2.973508E-10

U236F:
Data 66, 172, _
 8.297559E-07,2.073867E-06,4.158442E-06,9.334155E-06,2.073617E-05,5.1882E-05, _
1.868039E-04,7.188419E-04,0.00311351,0.00830304,0.02283304,0.04517709, _
0.05806179,0.1140577,0.1858398,0.2705717,0.3845709,0.5635422,0.9395179,1.502421, _
1.715,2.244121,2.802164,3.91923,4.843043,5.527523,5.56411,5.397912,5.122932, _
6.415905,6.070514,5.464421,5.9861,5.862486,5.785608,5.229299,5.196377,4.155797, _
3.529251,2.477181,1.013039,0.6160435,0.383791,0.1538313,0.1146616,0.06730792, _
0.05292776,0.04106948,0.03632284,0.03844751,0.0373611,0.03770193,0.0362972, _
0.03534327,0.03820693,0.03745882,0.0505776,0.07118662,0.09401948,0.1642947, _
0.243183,0.3536345,0.5441403,0.9311857,1.742158,2.950469,4.377124,6.88514, _
7.69335,6.091369,6.328255,6.18513,6.677754,6.134056,5.642909,5.385015,5.393676, _
5.780176,5.110675,4.171041,3.46541,2.295286,1.727505,1.340007,0.7400543, _
0.4148881,0.3152069,0.2528786,0.1311239,0.09365924,0.03372977,0.02341401, _
0.01123922,0.00440248,0.00196627,4.926855E-04,2.062753E-04,1.124003E-04, _
4.497237E-05,1.719795E-05,1.029501E-05,4.87443E-06,1.218009E-06,2.992489E-07, _
9.077549E-08,2.993879E-08,8.049301E-09, _
 3.508331E-07,8.477627E-07,1.735014E-06,4.280839E-06,1.007665E-05,2.22193E-05, _
7.373302E-05,2.973948E-04,0.00146125,0.00392515,0.01013061,0.01839828, _
0.02348468,0.03947587,0.09185277,0.1187383,0.1284067,0.2210661,0.4107887, _
0.5241294,0.4230761,0.6507705,0.6026344,0.8613111,1.268743,1.246648,1.176943, _
1.197615,0.9078925,1.563677,1.082099,1.424997,0.9589244,1.253223,1.41517, _
1.231662,1.291361,1.106923,0.8813198,0.561012,0.4128846,0.2424032,0.1918583, _
0.06931646,0.04516196,0.02947335,0.02616294,0.01759999,0.01428493,0.01614763, _
0.01807709,0.01697265,0.01364198,0.01393174,0.01517854,0.01291886,0.02325697, _
0.02703485,0.03032975,0.054774,0.1094349,0.1414098,0.2203168,0.3411378, _
0.6672869,0.7822106,0.6986337,1.391609,0.8284689,1.38477,1.166831,1.344483, _
1.182282,1.602158,1.292384,1.162037,1.149629,1.022104,1.350677,0.9190508, _
0.9234374,0.489419,0.4729276,0.6344385,0.3308437,0.1700493,0.1263994,0.1113491, _
0.06451356,0.04193323,0.01370658,0.00958122,0.00489411,0.00206691,9.421733E-04, _
2.065271E-04,8.110633E-05,4.695671E-05,2.144202E-05,8.092702E-06,4.515735E-06, _
1.994854E-06,4.926098E-07,1.33214E-07,4.464081E-08,1.325261E-08,3.247721E-09

U236HE:
Data 66, 172, _
 1.848187E-04,4.057831E-04,7.865134E-04,0.00109601,0.00199425,0.00308836, _
0.00468542,0.0081779,0.01394408,0.01991955,0.02889595,0.05982999,0.1094242, _
0.1690753,0.2365136,0.3498907,0.5412369,0.6372704,0.9352679,1.477472,1.683799, _
2.544925,2.56054,3.702806,3.936794,4.269622,4.789793,4.925111,5.488012,5.295279, _
5.323805,5.458889,5.191193,5.158493,4.797803,4.201574,3.552764,3.213456, _
2.804425,2.518284,1.817545,1.585503,1.375411,1.195122,1.299876,1.10607,1.160652, _
1.085208,1.047029,1.044624,1.266416,1.143987,1.101795,1.022386,1.052163, _
1.160982,1.101811,1.171801,1.293257,1.469058,1.594674,1.957007,2.230966,2.8124, _
3.35117,3.810133,4.873324,5.389033,5.830106,5.576875,5.965308,5.240859,5.092854, _
5.231889,4.120324,4.056171,4.251554,3.944685,3.488317,2.556472,1.995943, _
1.732623,1.269879,0.8813632,0.6847957,0.4848763,0.3562355,0.2796715,0.1415438, _
0.09202731,0.07047991,0.04947677,0.02770764,0.01630265,0.00992087,0.0064684, _
0.00385813,0.00227604,0.00138521,7.536374E-04,4.198876E-04,2.569427E-04, _
1.485667E-04,1.191547E-04,4.459137E-05,2.474547E-05,1.381808E-05, _
 7.544381E-05,1.678333E-04,3.204035E-04,4.501488E-04,8.040102E-04,0.00125548, _
0.00193523,0.00335091,0.00566872,0.00823874,0.01177057,0.02454194,0.04504595, _
0.0582714,0.09771091,0.1425745,0.1760442,0.2561134,0.3407019,0.4731188, _
0.5995868,0.6727,0.7313483,0.7863289,1.004316,0.8869627,1.093865,1.034384, _
1.177729,1.1694,1.077525,1.598048,0.9085398,1.085862,1.150785,0.8729748, _
1.148748,0.6924271,0.6833816,0.673026,0.4823221,0.6453325,0.5671277,0.4618083, _
0.5279574,0.4574676,0.4742101,0.4444818,0.4326587,0.4249371,0.5158352,0.4477503, _
0.3847383,0.4156943,0.3457578,0.3931794,0.4300169,0.4610789,0.4264725,0.4544939, _
0.5618066,0.6685954,0.651758,0.5433952,0.8098763,0.9248036,0.8518674,1.081384, _
1.193328,1.196763,1.05124,1.098206,1.23211,1.0888,0.9060538,0.876438,0.889838, _
1.029294,0.7271236,0.6958588,0.6500167,0.5922096,0.5126159,0.3593636,0.2814454, _
0.1997015,0.1445297,0.1156536,0.05257119,0.03774414,0.02906591,0.02013943, _
0.01145799,0.00665228,0.0040734,0.00266515,0.00156686,9.410161E-04,5.666274E-04, _
3.078687E-04,1.73572E-04,1.045738E-04,6.116738E-05,4.898966E-05,1.536233E-05, _
1.023124E-05,5.644976E-06

U237F:
Data 66, 172, _
 4.45929E-07,1.386684E-06,1.981356E-06,5.939842E-06,1.189056E-05,2.774843E-05, _
4.957023E-05,2.984095E-04,9.910013E-04,0.00317073,0.00733468,0.01788672, _
0.0465152,0.07521298,0.1273382,0.2090804,0.3076851,0.4749191,0.8046601,1.081308, _
1.506306,1.715018,2.618017,3.441176,4.06078,4.414467,4.762786,5.085342,5.628909, _
5.674896,5.828772,5.910765,5.872965,6.259937,5.955295,5.804114,5.684472, _
4.947286,4.61886,2.709162,2.062948,1.122898,0.4953041,0.178569,0.1295396, _
0.06937654,0.05946646,0.04371289,0.03667079,0.04158078,0.03468726,0.03478046, _
0.03577499,0.0347432,0.03474522,0.03660828,0.04453462,0.05642078,0.07131322, _
0.1191227,0.1776413,0.2483623,0.573181,1.013182,2.02811,3.214311,4.756469, _
5.454151,6.722189,6.662914,6.371755,6.697618,6.328166,6.179007,6.658218, _
5.589428,5.422164,4.831087,4.846426,3.663104,3.130164,2.616421,1.853411,1.44577, _
1.042699,0.7719367,0.5245213,0.3463815,0.1880356,0.1187597,0.05740084, _
0.04255516,0.01484489,0.00682801,0.0027304,0.00104244,2.961411E-04,5.15275E-05, _
2.768054E-05,9.923674E-06,5.935508E-06,2.371396E-06,1.089447E-06,4.156042E-07, _
8.414447E-08,2.281187E-08,6.926085E-09, _
 1.96048E-07,5.716473E-07,8.063137E-07,2.656313E-06,5.902667E-06,1.239677E-05, _
2.011838E-05,1.2306E-04,4.375654E-04,0.00150524,0.00352228,0.00749157, _
0.01840498,0.02696536,0.06222738,0.09744404,0.11714,0.1922524,0.3087816, _
0.3756612,0.3818114,0.7225704,0.7135319,0.7332854,1.08557,1.046929,1.025516, _
1.048033,1.200949,1.329824,1.187615,1.484329,0.9523625,1.334378,1.394311, _
1.52152,1.407227,1.071628,1.224454,0.7892887,0.5945659,0.4502576,0.2629477, _
0.08095682,0.05215987,0.02886605,0.02886527,0.02025022,0.01506642,0.01715536, _
0.01578885,0.01649844,0.01582188,0.01426343,0.01159564,0.01276215,0.0219049, _
0.0239394,0.02356475,0.04051259,0.07343234,0.09337195,0.2254324,0.4529687, _
0.8038995,0.930335,0.8845055,1.124702,1.676948,1.617125,1.289319,1.380033, _
1.349621,1.457306,1.645479,1.194491,1.072493,1.026296,1.297067,0.9827684, _
0.780527,0.6940993,0.7883796,0.3868187,0.5071415,0.3253118,0.2075016,0.1452539, _
0.0899683,0.05635598,0.02543324,0.01754428,0.00602707,0.00304383,0.00136075, _
4.67312E-04,1.204238E-04,2.124066E-05,1.217313E-05,4.697967E-06,2.857621E-06, _
9.957014E-07,4.308722E-07,1.745828E-07,4.037037E-08,1.081375E-08,3.056381E-09

U238F:
Data 66, 172, _
 3.704627E-06,2.143364E-05,2.80312E-05,3.591197E-05,4.419508E-05,4.948809E-05, _
6.05442E-05,2.060041E-04,2.771876E-04,4.622193E-04,8.007113E-04,0.00330193, _
0.01116444,0.03260076,0.04107114,0.08560147,0.2139458,0.3936458,0.6248965, _
0.9281149,1.2542,1.590461,1.827912,2.694771,3.466771,4.081954,4.317273,4.640787, _
4.822732,5.12921,6.158909,5.569324,5.868143,6.237962,6.72458,6.209044,6.446565, _
6.272674,4.992314,4.092845,2.495331,1.445876,0.6009729,0.2517195,0.1416359, _
0.0712156,0.05590134,0.04611245,0.03925743,0.03754765,0.0393137,0.03773198, _
0.04317657,0.0397207,0.03871442,0.03690728,0.04106724,0.04455766,0.04646096, _
0.04852479,0.05386155,0.1364748,0.2841646,1.012532,1.913953,3.28784,5.150981, _
6.729358,7.457114,7.041598,6.684493,6.225989,5.773952,5.810166,5.839304, _
5.379018,4.54303,4.616786,4.534554,3.870584,3.461346,2.592735,2.10468,1.631635, _
1.274931,0.7994029,0.5302316,0.4147904,0.2162819,0.1415151,0.07603332, _
0.04137502,0.01848751,0.00861914,0.00354503,0.00121536,3.405963E-04, _
2.042005E-04,1.247615E-04,7.667431E-05,5.666655E-05,4.351727E-05,2.837824E-05, _
1.701294E-05,1.021359E-05,5.714844E-06,1.06605E-05, _
 1.608783E-06,9.002792E-06,1.167505E-05,1.513163E-05,1.986971E-05,2.172414E-05, _
2.529584E-05,8.736879E-05,1.154828E-04,2.013779E-04,3.630345E-04,0.00139525, _
0.00464732,0.01286696,0.01771375,0.03829782,0.08647414,0.1716955,0.2048813, _
0.3271087,0.315072,0.3455712,0.5828144,0.6335822,0.6149194,0.6047935,0.4265319, _
0.9207512,1.055323,0.9074407,1.125799,1.464182,1.046578,1.43054,1.427341, _
1.433062,1.56609,1.333102,1.529736,0.750842,0.4847029,0.4079754,0.2337109, _
0.1197174,0.06414539,0.0302673,0.02364668,0.02068342,0.0166695,0.01594794, _
0.01634549,0.01639087,0.01914362,0.0166713,0.01250018,0.01365881,0.01770846, _
0.01922993,0.01673816,0.01534853,0.01963424,0.04585306,0.09871859,0.3211372, _
0.7508818,1.11785,0.9132344,1.046333,1.341933,1.575154,1.298667,0.8309212, _
1.243856,0.8741028,0.7408693,0.6917338,0.9828866,0.8858407,0.8055174,1.007075, _
0.8620374,0.7320113,0.7903331,0.5725333,0.4284943,0.3440276,0.2204215,0.175421, _
0.0916983,0.06309691,0.03349552,0.01734722,0.00770942,0.00361745,0.00158584, _
5.378227E-04,1.431767E-04,8.65332E-05,5.187057E-05,3.308465E-05,2.578626E-05, _
1.853393E-05,1.180598E-05,7.186678E-06,4.344562E-06,2.547127E-06,4.704376E-06

U238HE:
Data 66, 172, _
 7.821796E-05,1.386739E-04,2.983565E-04,5.010404E-04,9.012745E-04,0.00159162, _
0.00270596,0.00523004,0.00800628,0.01386986,0.02199003,0.03129333,0.05699387, _
0.1329564,0.2092518,0.334513,0.4537678,0.6663946,0.9607861,1.158072,1.523847, _
1.651169,2.048304,2.884037,3.367145,3.893229,3.873924,4.296611,4.855656, _
4.926308,5.622543,5.322355,5.406467,5.760124,5.013084,5.697824,4.621129, _
4.614399,3.995831,3.241973,2.460785,1.694375,1.221307,1.120021,1.03141, _
0.9922501,1.032698,0.914341,0.718888,0.8570475,0.6756378,0.6047033,0.8310164, _
0.725952,0.7774184,0.8328025,0.8498614,0.9228812,1.034999,1.196329,1.322679, _
1.495971,1.94295,2.079847,3.150233,3.993001,4.838687,6.012312,6.405131,5.860982, _
5.446806,5.197778,4.97367,5.10901,4.624636,4.394473,4.030463,3.915194,3.716103, _
3.033705,2.44469,2.091154,1.726726,1.461404,1.081455,0.8014741,0.5787942, _
0.3919224,0.2521235,0.1552578,0.114369,0.0803493,0.04259307,0.02601792, _
0.01566457,0.00846904,0.00593662,0.00339334,0.00199194,0.00109749,6.297313E-04, _
3.694677E-04,2.004735E-04,1.292682E-04,5.948958E-05,3.302417E-05,2.126358E-05, _
 3.231108E-05,5.80561E-05,1.225259E-04,2.081909E-04,3.678567E-04,6.528907E-04, _
0.00113041,0.00216905,0.00328475,0.00580787,0.00906587,0.01293654,0.02381782, _
0.04758659,0.08719488,0.1384676,0.1532079,0.2740025,0.3268696,0.3766271, _
0.5930712,0.4873587,0.3604941,0.3617073,0.4326308,0.5274587,0.6420903,1.024569, _
1.019802,1.079263,1.223149,1.393463,1.029512,1.214347,1.051429,1.287475, _
1.162494,1.024287,1.131803,0.6809602,0.652953,0.70492,0.5020154,0.4602373, _
0.4257639,0.408696,0.432892,0.3760858,0.2985704,0.3580613,0.2769639,0.2503369, _
0.3277943,0.2975125,0.2514892,0.3202441,0.3140382,0.3832115,0.3882574,0.3944708, _
0.4291773,0.4780431,0.5779856,0.7500455,0.9191356,0.6688598,0.7832638,1.168825, _
0.8751185,1.060138,0.9892447,0.5773638,0.6337098,0.7538033,0.6205395,0.8691308, _
0.8416016,0.8128261,0.978815,0.6459522,0.818975,0.5518317,0.7076018,0.46965, _
0.4466455,0.3317125,0.2417588,0.1606066,0.1039069,0.06435104,0.04711728, _
0.03364893,0.01752601,0.01079246,0.00652949,0.00347627,0.00247902,0.00140743, _
8.194378E-04,4.596103E-04,2.595913E-04,1.527791E-04,8.391785E-05,5.309094E-05, _
2.453287E-05,1.375753E-05,8.729518E-06

U238S:
Data 66, 172, _
 8.133126E-11,2.446135E-10,8.125523E-10,2.457442E-09,8.135643E-09,2.446352E-08, _
8.124411E-08,2.555344E-07,8.137679E-07,2.449174E-06,8.12664E-06,2.55601E-05, _
8.102346E-05,3.35474E-04,7.64068E-04,0.00401743,0.01225796,0.02879181, _
0.09186661,0.08626615,0.9358717,1.542977,2.428585,3.59653,5.847204,5.886475, _
5.837173,5.776653,6.791975,6.690174,6.764961,6.623606,6.415067,6.145249, _
6.157159,6.537965,6.160252,4.555743,3.738511,0.7942804,0.2704863,0.1390346, _
0.08130173,0.01181817,0.00985187,0.00856495,0.00585782,0.00510342,0.00410945, _
0.00382648,0.00355311,0.00328057,0.00319045,0.00379333,0.00379354,0.00388905, _
0.00419062,0.00449006,0.00498816,0.00599022,0.0069638,0.01399333,0.01990331, _
0.02656784,0.1396113,0.4475269,3.327778,5.584719,4.703992,5.256915,5.358765, _
6.089978,6.327491,7.004104,6.840519,6.955839,6.200617,7.178237,6.132599, _
6.139369,5.288952,4.399125,3.030649,2.212395,0.9995816,0.1995014,0.04987444, _
0.01994942,0.00798044,0.00299281,9.976223E-04,3.99589E-04,9.972932E-05, _
1.99635E-05,4.987029E-06,1.499996E-06,5.98249E-07,9.968802E-08,2.997247E-08, _
9.981157E-09,3.987029E-09,9.97646E-10,3.984364E-10,1.993031E-10,9.862157E-11, _
2.973046E-11,9.01014E-12, _
 3.595739E-11,1.070204E-10,3.584135E-10,1.073829E-09,3.84379E-09,1.114716E-08, _
3.5092E-08,1.136932E-07,3.510935E-07,1.136883E-06,3.811997E-06,1.105671E-05, _
3.592896E-05,1.34357E-04,3.438997E-04,0.00191289,0.00485639,0.01264471, _
0.03161006,0.03044782,0.3163574,0.6805393,0.5530074,0.800447,1.291941,1.464814, _
1.31251,1.274942,1.569574,1.453149,1.629523,1.64299,1.155801,1.457046,1.334667, _
1.561901,1.528925,0.9884334,1.247752,0.344558,0.1324471,0.07570595,0.04489711, _
0.00587122,0.00424926,0.00374235,0.0027436,0.00227781,0.00180921,0.00166412, _
0.00159814,0.00154009,0.00126392,0.00166124,0.00129519,0.00138646,0.00195567, _
0.00195899,0.00174828,0.00192634,0.00257205,0.00472677,0.00696149,0.01103655, _
0.05490501,0.1685469,0.7364013,1.383118,0.9766046,1.09547,1.334677,1.338618, _
1.382981,1.554515,1.648248,1.612983,1.348474,1.63065,1.329547,1.465998,1.312669, _
0.8671822,0.7912629,0.4795411,0.468121,0.09256992,0.02151327,0.00887649, _
0.00344342,0.00137592,4.719319E-04,1.736644E-04,4.40629E-05,8.700647E-06, _
2.21699E-06,7.163952E-07,2.670621E-07,4.340878E-08,1.326678E-08,4.334294E-09, _
1.883449E-09,4.595204E-10,1.718951E-10,8.891646E-11,4.301735E-11,1.375863E-11, _
4.669902E-12
