  /' Calculated spectra: '/



  /' II. Nuclide distributions '/

    ReDim ZPROV(150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZPROV"
    Anl_Par(I_Anl).C_Title = "Provisional element distribution"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    ReDim ZMPROV(0 To 6,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZMPROV"
    Anl_Par(I_Anl).C_Title = "Provisional element distribution"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RBT1"  

    ReDim Shared NZPOST(200,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NZPOST"
    Anl_Par(I_Anl).C_Title = "Nuclide distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Neutron number"
    Anl_Par(I_Anl).C_yaxis = "Atomic number"

    ReDim ZPOST(150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZPOST"
    Anl_Par(I_Anl).C_Title = "Element distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RT11"  

    ReDim ZMPOST(0 To 6,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZMPOST"
    Anl_Par(I_Anl).C_Title = "Element distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RBT1"  

    ReDim NPRE(200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NPRE"
    Anl_Par(I_Anl).C_Title = "Neutron-number distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Neutron number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RT11"  

    ReDim NMPRE(0 To 6,200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NMPRE"
    Anl_Par(I_Anl).C_Title = "Neutron-number distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Neutron number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RBT1"  

    ReDim NPOST(200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NPOST"
    Anl_Par(I_Anl).C_Title = "Neutron-number distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Neutron number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RT11"  
    
    ReDim NMPOST(0 To 6,200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NMPOST"
    Anl_Par(I_Anl).C_Title = "Neutron-number distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Neutron number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RBT1"  

    ReDim Shared APOST(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "APOST"
    Anl_Par(I_Anl).C_Title = "Mass distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "BT11"  

    ReDim AMPOST(0 To 6,350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AMPOST"
    Anl_Par(I_Anl).C_Title = "Mass distribution, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "GT1"  

    ReDim APROV(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "APROV"
    Anl_Par(I_Anl).C_Title = "Provisional mass distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "GT11"  

    ReDim AMPROV(0 To 6,350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AMPROV"
    Anl_Par(I_Anl).C_Title = "Provisional mass distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "GT1"  

    ReDim APRE(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "APRE"
    Anl_Par(I_Anl).C_Title = "Mass distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "GT11"  

    ReDim AMPRE(0 To 6,350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AMPRE"
    Anl_Par(I_Anl).C_Title = "Mass distribution, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "GT1"  

    ReDim ZISOPRE(350,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZISOPRE"
    Anl_Par(I_Anl).C_Title = "Isobaric Z distribution for A = &, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  

    ReDim ZISOPOST(350,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ZISOPRE"
    Anl_Par(I_Anl).C_Title = "Isobaric Z distribution for A = &, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  

    ReDim SigmaZpre(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "SigmaZpre"
    Anl_Par(I_Anl).C_Title = "Sigma of isobaric Z distribution"
    Anl_Par(I_Anl).C_xaxis = "Mass number, pre-neutron"
    Anl_Par(I_Anl).C_yaxis = "si^Z$"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  

    ReDim SigmaZpost(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "SigmaZpost"
    Anl_Par(I_Anl).C_Title = "Sigma of isobaric Z distribution"
    Anl_Par(I_Anl).C_xaxis = "Mass number, post-neutron"
    Anl_Par(I_Anl).C_yaxis = "si^Z$"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  

    ReDim Zpolarpre(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Zpolarpre"
    Anl_Par(I_Anl).C_Title = "Charge polarisation"
    Anl_Par(I_Anl).C_xaxis = "Mass number, pre-neutron"
    Anl_Par(I_Anl).C_yaxis = "Zb$a$r$ - ZU$C$D$"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  
                               
    ReDim Zpolarmac(350) As Single                            
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Zpolarmac"
    Anl_Par(I_Anl).C_Title = "Charge polarisation, macroscopic"
    Anl_Par(I_Anl).C_xaxis = "Mass number, pre-neutron"
    Anl_Par(I_Anl).C_yaxis = "Zb$a$r$ - ZU$C$D$"
    Anl_Par(I_Anl).C_Linesymbol = "LGT11"  

    ReDim Zpolarpost(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Zpolarpost"
    Anl_Par(I_Anl).C_Title = "Charge polarisation"
    Anl_Par(I_Anl).C_xaxis = "Mass number, post-neutron"
    Anl_Par(I_Anl).C_yaxis = "Zb$a$r$ - ZU$C$D$"
    Anl_Par(I_Anl).C_Linesymbol = "LRT11"  

    ReDim Edefo2d(350,800) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Edefo2d"
    Anl_Par(I_Anl).C_Title = "Deformation energy versus mass number, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ed$e$f$o$ / MeV"
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
    Anl_Par(I_Anl).I_Dim = 2

    Redim JFRAGpre(200,150,0 To 300) As Single  ' Array of N and Z
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "JFRAGpre (J truncated to integer values)"
    Anl_Par(I_Anl).C_Title = "Fragment spin distribution, unit 1 hb^, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "J / hb^"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    Redim JFRAGpost(200,150,0 To 300) As Single  ' Array of N and Z
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "JFRAGpost (J truncated to integer values)"
    Anl_Par(I_Anl).C_Title = "Fragment spin distribution, unit 1 hb^, post-neutron"
    Anl_Par(I_Anl).C_xaxis = "J / hb^"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    ReDim Eintr2d(350,1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Eintr2d"
    Anl_Par(I_Anl).C_Title = "Mean intrinsic energy versus mass number, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ei$n$t$r$ / MeV"
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
    Anl_Par(I_Anl).I_Dim = 2

    ReDim Ecoll2d(350,500) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Eintr2d"
    Anl_Par(I_Anl).C_Title = "Mean collective energy versus mass number, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ec$o$l$l$ / MeV"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
    Anl_Par(I_Anl).I_Dim = 2

    ReDim Eexc2d(350,1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Eexc2d"
    Anl_Par(I_Anl).C_Title = "Excitation energy versus mass number, pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ee$x$c$ / MeV"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
    Anl_Par(I_Anl).I_Dim = 2

    ReDim N2dpre(350,20) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "N2dpre"
    Anl_Par(I_Anl).C_Title = "Prompt-neutron multiplicity versus pre-neutron mass"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Neutron multiplicity"
    Anl_Par(I_Anl).I_Dim = 2

    ReDim N2dpost(350,20) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "N2dpre"
    Anl_Par(I_Anl).C_Title = "Prompt-neutron multiplicity versus post-neutron mass"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Neutron multiplicity"
    Anl_Par(I_Anl).I_Dim = 2
                               
    ReDim NApre(350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NApre"
    Anl_Par(I_Anl).C_Title = "Mean prompt neutron multiplicity as a function of pre-neutron mass"
    Anl_Par(I_Anl).C_xaxis = "Mass number, pre-neutron"
    Anl_Par(I_Anl).C_yaxis = "Mean neutron multiplicity"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
    
    ReDim NApost(350) As Single                           
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NApost"
    Anl_Par(I_Anl).C_Title = "Mean prompt neutron multiplicity as a function of post-neutron mass"
    Anl_Par(I_Anl).C_xaxis = "Mass number, post-neutron"
    Anl_Par(I_Anl).C_yaxis = "Mean neutron multiplicity"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    ReDim EP(1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "EP"
    Anl_Par(I_Anl).C_Title = "Overall prompt proton-energy spectrum"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    ReDim EN(1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "EN"
    Anl_Par(I_Anl).C_Title = "Overall prompt neutron-energy spectrum"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    ReDim ENCN(1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENCN"
    Anl_Par(I_Anl).C_Title = "Prompt neutron-energy spectrum from CN"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTRB0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
    
    ReDim ENfr(1000) As Single                           
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENfr"
    Anl_Par(I_Anl).C_Title = "Prompt neutron-energy spectrum from fragments"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTRG0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1

    ReDim ENfrC(5,5,1000) As Single 
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENfrC"
    Anl_Par(I_Anl).C_Title = "Prompt neutron-energy spectrum from fragments for Chances (nlost, plost)"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTGB0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    Redim ENlight(1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENlight"
    Anl_Par(I_Anl).C_Title = "Prompt neutron-energy spectrum from light fragments"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTRB0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
    
    Redim ENheavy(1000) As Single   
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENheavy"
    Anl_Par(I_Anl).C_Title = "Prompt neutron-energy spectrum from heavy fragments"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTBG0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
    
    Redim ENM(0 to 6,1000) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENM"
    Anl_Par(I_Anl).C_Title = "Neutron-energy spectrum for mode &"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTR0"  
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
    
    ReDim NP(50) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NP"
    Anl_Par(I_Anl).C_Title = "Proton multiplicity"
    Anl_Par(I_Anl).C_xaxis = "Number of protons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
                               
    ReDim NN(50) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NN"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity"
    Anl_Par(I_Anl).C_xaxis = "Number of neutrons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
                               
    ReDim NNCN(50) As Single 
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NNCN"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity (from CN)"
    Anl_Par(I_Anl).C_xaxis = "Number of neutrons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
    
    ReDim NNfr(50) As Single                            
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NNfr"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity (from fragments)"
    Anl_Par(I_Anl).C_xaxis = "Number of neutrons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
                               
    ReDim NNlight(50) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NNlight"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity (from light fragments)"
    Anl_Par(I_Anl).C_xaxis = "Number of neutrons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
                               
    ReDim NNheavy(50) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NNheavy"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity (from heavy fragments)"
    Anl_Par(I_Anl).C_xaxis = "Number of neutrons"
    Anl_Par(I_Anl).C_yaxis = "Probability"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    ReDim ENM(0 To 6,500) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ENM"
    Anl_Par(I_Anl).C_Title = "Neutron-energy spectrum for mode &"
    Anl_Par(I_Anl).C_xaxis = "Energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTR0"  
    Anl_Par(I_Anl).R_Alim(2,3) = 0.1
                               
    ReDim Ndirlight(-100 To 100) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Ndirlight"
    Anl_Par(I_Anl).C_Title = "Neutron angle vs. light fragment (cos)"
    Anl_Par(I_Anl).C_xaxis = "cos(alpha)"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HLTR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.01
                               
    ReDim nuTKEpre(0 To 250,0 To 20) As Single  
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "nuTKEpre"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity vs. TKE (pre-neutron)"
    Anl_Par(I_Anl).C_xaxis = "TKE / MeV"
    Anl_Par(I_Anl).C_yaxis = "nu^"
    Anl_Par(I_Anl).I_Dim = 2

    ReDim nuTKEpost(0 To 250,0 To 20) As Single  
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "nuTKEpost"
    Anl_Par(I_Anl).C_Title = "Neutron multiplicity vs. TKE (post-neutron)"
    Anl_Par(I_Anl).C_xaxis = "TKE / MeV"
    Anl_Par(I_Anl).C_yaxis = "nu^"
    Anl_Par(I_Anl).I_Dim = 2

    ReDim DPLOCAL(150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "DPLOCAL"
    Anl_Par(I_Anl).C_Title = "Local even-odd effect in Z"
    Anl_Par(I_Anl).C_xaxis = "Z (add 0.5!)"
    Anl_Par(I_Anl).C_yaxis = "de^p$"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  

    ReDim DNLOCAL(200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "DNLOCAL"
    Anl_Par(I_Anl).C_Title = "Local even-odd effect in N"
    Anl_Par(I_Anl).C_xaxis = "N (add 0.5!)"
    Anl_Par(I_Anl).C_yaxis = "de^n$"
    Anl_Par(I_Anl).C_Linesymbol = "LTB11"  

    ReDim AEkinpre(200,300) As Single    ' pre-neutron
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AEkinpre"
    Anl_Par(I_Anl).C_Title = "Ekin over Apre"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ek$i$n$ / MeV"
    Anl_Par(I_Anl).I_Dim = 2

    ReDim AEkinpost(200,300) As Single    ' post-neutron
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AEkinpost"
    Anl_Par(I_Anl).C_Title = "Ekin over Apost"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Ek$i$n$ / MeV"
    Anl_Par(I_Anl).I_Dim = 2
                               
    ReDim ATKEpre(300,300) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ATKEpre"
    Anl_Par(I_Anl).C_Title = "TKE over Apre"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "TKE / MeV"
    Anl_Par(I_Anl).I_Dim = 2
    
    ReDim ATKEpost(300,300) As Single                           
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "ATKEpost"
    Anl_Par(I_Anl).C_Title = "TKE over Apost"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "TKE / MeV"
    Anl_Par(I_Anl).I_Dim = 2
                               
    ReDim TKEpre(300) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "TKEpre"
    Anl_Par(I_Anl).C_Title = "TKE pre-neutron"
    Anl_Par(I_Anl).C_xaxis = "TKE / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTR0"  
                               
    ReDim TKEpost(300) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "TKEpost"
    Anl_Par(I_Anl).C_Title = "TKE post-neutron"
    Anl_Par(I_Anl).C_xaxis = "TKE / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTB0"  

    ReDim Shared TotXE(200) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "TotXE"
    Anl_Par(I_Anl).C_Title = "Total excitation energy"
    Anl_Par(I_Anl).C_xaxis = "TXE / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTR0"  

    ReDim Shared Qvalues(300) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Qvalues"
    Anl_Par(I_Anl).C_Title = "Spectrum of Q values"
    Anl_Par(I_Anl).C_xaxis = "Q value / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTR0"  
                               
    ReDim Shared AQpre(200,300) As Single  
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "AQpre"
    Anl_Par(I_Anl).C_Title = "Q value over Ap$r$e$"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Q value"
    Anl_Par(I_Anl).I_Dim = 2

    ReDim Shared EGamma(1000) As Single    ' individual gammas
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Egamma"
    Anl_Par(I_Anl).C_Title = "Prompt-gamma spectrum"
    Anl_Par(I_Anl).C_xaxis = "Ega^$ / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTB0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    ReDim Shared EGammaE2(1000) As Single    ' individual gammas
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "EgammaE2"
    Anl_Par(I_Anl).C_Title = "Prompt-E2-gamma spectrum"
    Anl_Par(I_Anl).C_xaxis = "Ega^$ / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTBR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    Redim Shared NGammatot(100) As Single    ' number of gammas in one fission event
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NGammatot"
    Anl_Par(I_Anl).C_Title = "Gamma multiplicity per fission"
    Anl_Par(I_Anl).C_xaxis = "Gamma multiplicity"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "LTB11"  
    
    Redim Shared NgammaA(350,100) As Single  ' number of gammas per fission in one A
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "NgammaA"
    Anl_Par(I_Anl).C_Title = "Gamma multiplicity per fission"
    Anl_Par(I_Anl).C_xaxis = "Post-neutron fragment mass number"
    Anl_Par(I_Anl).C_yaxis = "Gamma multiplicity"
    Anl_Par(I_Anl).I_Dim = 2
                                   
    Redim Shared EGammatot(5000) As Single   ' total gammas in 1 fission
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Egammatot"
    Anl_Par(I_Anl).C_Title = "Total gamma energy per fission"
    Anl_Par(I_Anl).C_xaxis = "Total gamma energy / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTBR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1
                               
    ReDim Shared Eentrance(5000) As Single   ' Eentrance - Erot      
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "Eentrance"
    Anl_Par(I_Anl).C_Title = "Entrance energy above yrast line"
    Anl_Par(I_Anl).C_xaxis = "Energy after last neutron / MeV"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "HTR0"  
    Anl_Par(I_Anl).R_Alim(1,3) = 0.1



   /' Spectra for error analysis '/
  
    ReDim Shared d_NZPOST(2,200,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "d_NZPOST"
    Anl_Par(I_Anl).C_Title = "Post-neutron fragment distribution (uncertainties)"
    Anl_Par(I_Anl).C_xaxis = "Post-neutron neutron number"
    Anl_Par(I_Anl).C_yaxis = "Atomic number"
    Anl_Par(I_Anl).I_Dim = 2  
                               
    ReDim d_ZISOPOST(2,350,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "d_ZISOPOST"
    Anl_Par(I_Anl).C_Title = "Isobaric Z distribution, post-neutron (uncertainties)"
    Anl_Par(I_Anl).C_xaxis = "Z distribution for A = &"
    Anl_Par(I_Anl).C_yaxis = "Counts"
    Anl_Par(I_Anl).C_Linesymbol = "LTR11"  
     ' dim. 0,1,2: sigma, N*m1, N*m2, all logarithmic
                           
    ReDim d_APOST(2,350) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "d_APOST"
    Anl_Par(I_Anl).C_Title = "Mass distribution, post neutron (uncertainties)"
    Anl_Par(I_Anl).C_xaxis = "Mass number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "BT11"  
    Anl_Par(I_Anl).I_Dim = 1  ' first dimension!
                               
    ReDim d_ZPOST(2,150) As Single
    I_Anl = I_Anl + 1
    Anl_Par(I_Anl).C_Name = "d_ZPOST"
    Anl_Par(I_Anl).C_Title = "Element distribution, post-neutron (uncertainties)"
    Anl_Par(I_Anl).C_xaxis = "Atomic number"
    Anl_Par(I_Anl).C_yaxis = "Yield"
    Anl_Par(I_Anl).C_Linesymbol = "RT11"  
    Anl_Par(I_Anl).I_Dim = 1  ' first dimension!
