
'
'    Copyright 2009, 2010, 2011, 2012, 2013: 
'       Dr. Karl-Heinz Schmidt, Rheinstrasse 4, 64390 Erzhausen, Germany
'       and 
'       Dr. Beatriz Jurado, Centre d'Etudes Nucleaires de Bordeaux-Gradignan,
'       Chemin du Solarium, Le Haut Vigneau, BP 120, 33175 Gradignan, Cedex,
'       France 
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.


  /' Documentation: '/
  /' (1) K.-H. Schmidt and B. Jurado, Contribution to '/
  /'     ESNT Workshop "The scission process", Saclay (France), April 12-16, 2010 '/
  /' (2) B. Jurado and K.-H. Schmidt, Contribution to '/
  /'     Seminar an fission, Gent (Belgium), May 17-20, 2010 '/
  /' (3) K.-H. Schmidt and B. Jurado, Contribution to '/
  /'     Seminar on fission, Gent (Belgium), May 17-20, 2010 '/
  /' (4) B. Jurado and K.-H. Schmidt, Contribution to '/
  /'     EFNUDAT Workshop, Paris (France), May 25-27, 2010 '/
  /' (5) K.-H. Schmidt and B. Jurado, Contribution to '/
  /'     EFNUDAT Workshop, Paris (France), May 25-27, 2010 '/
  /' (6) K.-H. Schmidt and B. Jurado, '/
  /'     Final Report to EFNUDAT, October, 2010 '/
  /' (7) K.-H. Schmidt and B. Jurado, Phys. Rev. Lett. 104 (2010) 21250 '/
  /' (8) K.-H. Schmidt and B. Jurado, Phys. Rev. C 82 (2011) 014607 '/
  /' (9) K.-H. Schmidt and B. Jurado, Phys. Rev. C 83 (2011) 061601 '/
  /' (10) K.-H. Schmidt and B. Jurado, arXiv:1007.0741v1[nucl-th] (2010) '/
  /' (11) K.-H. Schmidt and B. Jurado, JEF/DOC 1423, NEA of OECD, 2012 '/  
  /' (12) K.-H. Schmidt and B. Jurado, Phys. Rev. C 86 (2012) 044322 '/


  /' Further documentation and the newest version of the GEF code are '/
  /' available from                                                   '/
  /' http://www.cenbg.in2p3.fr/GEF and http://www.khs-erzhausen.de/ . '/

  
'    The development of the GEF code has been supported by the European Union,
'    EURATOM 6 in the Framework Program "European Facilities for Nuclear Data
'    Measurements" (EFNUDAT), contract number FP6-036434, the Framework
'    Program "European Research Infrastructure for Nuclear Data Applications
'    (ERINDA), and by the OECD Nuclear Energy Agency.


' Technical remark: The code contains commented sections with 
' produce the GEF code as a subroutine from this source with a dedicated
' pre-processor. 
   

  /' K.-H. Schmidt / B. Jurado, 07/Feb./2009 '/
  /' SEFI9 is taken as a basis and extended by new features in SEFI14 (May 2010), KHS '/
  /' Several improvements (even-odd effect, charge polarization etc. (June 2010), KHS '/
  /' SEFI15 converted to FreeBASIC on 04/July/2010, KHS '/
  /' Error in LyPair corrected (26/July/2010) KHS '/
  /' Indices corrected in U_Shell inside Eva (1/Aug/2010) KHS '/
  /' Major developments, sigma_E*(scission), sigma_Z(A) etc. (14/Aug/2010) KHS '/
  /' Macroscopic masses from Thomas-Fermi model (Myers & Swiatecki) (17/Aug/2010) KHS '/
  /' 3 reference options for energy input (4/Sept/2010) KHS '/
  /' Graphic output of mass distribution added (if there are problems with the X11 
      installation on LINUX, the graphics may be suppressed by simply commenting 
      the line  -> #Include Once "DCLPlotting.bas" <- )  (5/Sept/2010) KHS '/
  /' Comparison with ENDF compilation in graphic output (12/Sept/2010) KHS '/
  /' Super-long fission channel included (14/Sept/2010) KHS '/
  /' Overlap of S1 and S2 fission channels in both fragments included (18/Oct/2010) KHS '/
  /' Output of neutron multiplicity distribution added (20/Oct/2010) KHS '/
  /' Decreasing curvature of shells with increasing E* (24/Oct/2010) KHS '/
  /' Angular momenta of fission fragments added (18/Dec/2010) KHS '/
  /' CN angular momentum considered (14/Jan/2011) KHS '/
  /' Numerical stability improved (28/Jan/2011) KHS '/
  /' Output in ENDF format (optional) (4/Feb/2011) KHS '/
  /' Input list from file supported (31/Jan/2011) KHS '/
  /' Multiprocessing supported (5/Feb/2011) KHS '/
  /' Polarization for symmetric fission channel improved (12/Feb/2011) KHS '/
  /' GUI for input (23/Feb/2011) KHS '/
  /' Calculation of fission-fragment angular momentum refined (5/May/2011) KHS '/
  /' Neutron inverse cross section modified (5/August/2011) KHS '/
  /' Even-odd staggering in neutron emission improved (5/August/2011) KHS '/
  /' Slight modifications in angular-momentum distributions (19/October/2011) KHS '/
  /' Gamma emission added (23/November/2011) KHS '/
  /' TKE added (24/November/2011) KHS '/
  /' Neutron spectrum added (25/November/2011) KHS '/
  /' Neutron-gamma competition added (4/December/2011) KHS '/
  /' Composite level density (Egidy + Ignatyuk) refined (31/January/2012) KHS '/
  /' Treatment of GDR refined (14/February/2012) KHS '/
  /' Deformation of S3 channel changed (27/February/2012) KHS '/
  /' Z=44 deformed shell added (supports S1 around Pu) (27/February/2012) KHS '/
  /' Uncertainties from perturbed fission yields (3/March/2012) KHS '/
  /' Validity range extended to Z=120 (with a warning message) (8/March/2012) KHS '/
  /' Neutron emission during fragment acceleration (18/March/2012) KHS '/
  /' Several optimizations (15/April/2012) KHS '/
  /' TF masses of Myers & Swiatecki corrected (pairing shift) (29/May/2012) KHS '/
  /' Correction on intrinsic excitation energy (05/June/2012) KHS '/
  /' Correction on gamma emission (25/September/2012) KHS '/
  /' Free choice of listmode values (13/October/2012) KHS '/
  /' Excitation-energy distribution from file (14/October/2012) KHS '/
  /' Transfer of input from GUI corrected (02/November/2012) KHS '/
  /' Parameters of perturbed calculations modified (02/November/2012) KHS '/
  /' Model parameters je-adjusted (08/November/2012) KHS '/
  /' Input options for isomeric target nuclei (09/November/2012) KHS '/
  /' Random initialisation of the random generator (26/November/2012) KHS '/
  /' Covariance matrix for Z, Apre, Apost, ZApre, ZApost (06/December/2012) KHS '/
  /' Output file in XML format (06/December/2012) KHS '/
  /' Multi-chance fission supported (13/December/2012) KHS '/
  /' Pre-compound emission for (n,f) included (13/December/2012) KHS '/
  /' Some technical corrections and modifications (17/December/2012) KHS '/
  /' Transition from asymmetric to symmetric fission around Fm improved (19/December/2012) KHS '/
  /' Influence of S2 channel on S1 channel in the other fragment included (20/December/2012) KHS'/
  /' List-mode output of pre-fission neutron energies (21/December/2012) KHS '/
  /' Parameterisation for EB-EA from fit to data in Dahlinger et al. (21/December/2012) KHS '/
  /' Fission channel at Z=42 added (seen around Pu in light fragment and around Hg) (23/Dec./2012) KHS '/
  /' Gamma-n / Gamma-f according to Moretto (IAEA Rochester) (23/December/2012) KHS '/
  /' Pre-compound neutron energies modified (24/December/2012) KHS '/
  /' Some technical revisions to avoid crashes in covariances (26/December/2012) KHS '/
  /' Influence of shells on yrast line from Deleplanque et al. (26/December/2012) KHS '/
  /' Fission threshold in multi-chance fission modified (30/December/2012) KHS '/
  /' Output of energies at fission for multi-chance fission (30/December/2012) KHS '/
  /' Several revisions (15/January/2013) KHS '/
  /' New optical model fit (3/February/2013) KHS '/
  /' Gamma-f / Gamma-n modified (3/February/2013) KHS '/
  /' Handling for reading input from file corrected (5/February/2013) KHS '/ 
  /' Data transfer from GUI corrected (6/February/2013) KHS '/
  /' Input dialog re-organized (6/February/2013) KHS '/  
  /' Mass-dependent deformation and charge polarization revised (9/February/2013) KHS '/
  /' Calculation of combined fission channels S12, S22 revised (10/February/2013) KHS '/
  /' Extension of validity range to heavier nuclei (10/February/2013) KHS '/
  /' Improved description of prompt-neutron spectra (21/February/2013) KHS '/
  /' Several technical corrections and developments (April-May/2013) KHS '/
  /' Pre-fission emission of protons considered (14/Mai,2013) KHS '/
  /' Structure of energy list in input file modified (26/May/2013) KHS '/
  /' Option "local fit" added (26/May/2013) KHS '/
  /' Neutron evaporation corrected (more realistic even-odd effect in isotonic distr.) (21/June(2013) KHS '/
  /' Even-odd effect in TKE added (23/June/2013) KHS '/
  /' Calculation of Z-A-covariance matrix corrected (16/July/2013) KHS '/ 
  /' Output of multi-variant distributions corrected for input from file (24/July/2013) KHS '/
  /' New global fit (most important: Energy gain from saddle to scission reduced) (15/September/2013) KHS '/
  /' Even-odd effect in neutron number of fragments modified (17/September/2013) KHS '/
  /' Curvatures of fission valleys adjusted to experimental shells around 132Sn (18/September/2013) KHS '/
  /' Width of S0 corrected: Fit of Rusanov (18/September/2013) KHS '/
  /' Random generator Box with asymmetric diffuseness for S2 (18/September/2013) KHS '/
  /' Gaussian random generator revised (20/September/2013) KHS '/
  /' Mass shift of fission channels with E* modified (22/September/2013) KHS '/
  /' Energy dependence of S1 position corrected, slightly modified parameters (25/September/2013) KHS '/
  /' Initial angular momentum introduced as an input parameter (02/October/2013) KHS '/
  /' Calculation of prompt-neutron emission improved, some model parameters modified (12/October/2013) KHS '/
  /' Technical error, causing incomplete covariance matrices on output corrected  (17/October/2013) KHS '/
  /' Washing of shell effects considerd in shape fluctuations (26/October/2013) KHS '/
  /' Post-scission neutrons added to list-mode output (8/November/2013) KHS '/
  /' Fission-gamma competition refined (10/November/2013) KHS '/
  /' New global fit of model parameters (18/November/2013) KHS '/
  /' Multi-chance fission modified (18/November/2013) KHS '/
  /' A numerical instability removed (20/November/2013) KHS '/
  
  /' FreeBASIC is available from http://www.freebasic.net/ '/
  /' It runs on Windows, Linux, and DOS. '/
  /' FreeBASIC compiles a binary code that uses the C run-time library. '/
  
  
  #Include "utilities.bi"

  /' Functions and subroutines '/
  
   Declare Function Getyield(E_rel As Single,E As Single,T_low As Single,T_high As Single) As Single
     	
   Declare Function Masscurv(Z As Single, A As Single, RI As Single, kappa As Single) As Single
   Declare Function Masscurv1(Z As Single, A As Single, RI As Single, kappa As Single) As Single

   Declare Function De_Saddle_Scission(Z_square_over_Athird As Single, _
           ESHIFTSASCI As Single) As Single

   Declare Function TEgidy(A As Single,DU As Single,Fred As Single) As Single
   
   Declare Function TRusanov(E As Single, A As Single) As Single

   Declare Function LyMass(Z As Single,A As Single,beta As Single) As Single

   Declare Function LyPair(Z As Integer,A As Integer) As Single

   Declare Function TFPair(Z As Integer,A As Integer) As Single

   Declare Function Pmass(Z As Single,A As Single,beta As Single) As Single

   Declare Function FEDEFOLys(Z As Single,A As Single,beta As Single) As Single
   
   Declare Function FEDEFOP(Z As Single,A As Single,beta As Single) As Single

   Declare Function LDMass(Z As Single,A As Single,beta As Single) As Single
   
   Declare Function AME2012(Z As Integer,A As Integer) As Single

   Declare Function U_SHELL(Z As Integer,A As Integer) As Single
   
   Declare Function U_SHELL_exp(Z As Integer, A As Integer) As Single   

   Declare Function U_MASS(Z As Single,A As Single) As Single

   Declare Function ECOUL( _
	        Z1 As Single,A1 As Single,beta1 As Single,Z2 As Single,A2 As Single, _
           beta2 As Single,d As Single) As Single

   Declare Function beta_light(Z As Integer,betaL0 As Single,betaL1 As Single) As Single

   Declare Function beta_heavy(Z As Integer,betaH0 As Single,betaH1 As Single) As Single

   Declare Function _
           Z_equi(ZCN As Integer,A1 As Integer,A2 As Integer, _
           beta1 As Single,beta2 As Single,d As Single, Imode As Integer, _
           POLARadd As Single,POLARfac As Single) _
           As Single

   Declare Sub Beta_opt_light(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single, _
             d As Single,beta2_imposed As Single,ByRef beta1_opt As Single)

   Declare Sub Beta_Equi( _
          A1 As Single,A2 As Single,Z1 As Single,Z2 As Single,d As Single, _
          beta1prev As Single,beta2prev As Single, _
          ByRef beta1opt As Single,ByRef beta2opt As Single)

   Declare Function U_Ired(Z As Single,A As Single) As Single
   
   Declare Function U_alev(Z As Single, A As Single) As Single
   
   Declare Function U_Temp(Z As Single, A As Single, E As Single, Ishell As Integer, _
             Ipair As Integer, Tscale As Single,Econd As Single) As Single

   Declare Function U_Even_Odd(I_Channel As Integer,PEO As Single) As Single
   
   Declare Function BFTF(RZ As Single,RA As Single,I_Switch As Integer) As Single
   Declare Function BFTFA(RZ As Single,RA As Single,I_Switch As Integer) As Single
   Declare Function BFTFB(RZ As Single,RA As Single,I_Switch As Integer) As Single

   Declare Function Gaussintegral(R_x As Single,R_sigma As Single) As Single

   /' Utility functions '/


   Declare Function U_Box(x As Single,sigma As Single, _ 
                  width As Single) As Single
   Declare Function U_Gauss(x As Single,sigma As Single) As Single
   Declare Function U_LinGauss(x As Single,R_Sigma As Single) As Single
   Declare Function CC_Count(CIn As String, CDiv As String) As Integer
   Declare Sub CC_Cut(CIn As String,CDiv As String,COut() As String, _
               Byref N as Integer)
   Declare Function Round(R As Single, N As Integer) As Single        
   Declare Function U_Valid(I_Z As Integer,I_A As Integer) As Ubyte
   
   Declare Function U_Delta_S0(I_Z As Integer,I_A As Integer) As Single 


    Dim Shared As Ubyte Bsub = 0  ' For extracting the subroutine version of GEF.

/' Internal variables '/
    Const As Single pi = 3.14159
    Dim Shared As Integer I_N_CN /' Neutron number of fissioning nucleus '/
    Dim Shared As Integer I,J,K
    Dim Shared As Single T_coll_Mode_1,T_coll_Mode_2,T_coll_Mode_3,T_coll_Mode_4
    Dim Shared As Single T_asym_Mode_1,T_asym_Mode_2,T_asym_Mode_3,T_asym_Mode_4,T_asym_Mode_0
    Dim Shared As Single Sigpol_Mode_1,Sigpol_Mode_2,Sigpol_Mode_3,Sigpol_Mode_4
    Dim Shared As Single R_Z_Curv_S0,R_Z_Curv1_S0,R_A_Curv1_S0
    Dim Shared As Single ZC_Mode_0,ZC_Mode_1,ZC_Mode_2,ZC_Mode_3,ZC_Mode_4
    Dim Shared As Single SigZ_Mode_0,SigZ_Mode_1,SigZ_Mode_2,SigZ_Mode_3,SigZ_Mode_4
    Dim Shared As Single SN
    Dim Shared As Single E_exc_S0_prov,E_exc_S1_prov,E_exc_S2_prov,E_exc_S3_prov,E_exc_S4_prov
    Dim Shared As Single E_exc_S11_prov,E_exc_S22_prov
    Dim Shared As Single E_exc_Barr
    Dim Shared As Single E_LD_S1,E_LD_S2,E_LD_S3,E_LD_S4
    Dim Shared As Single R_Shell_S1_eff,R_Shell_S3_eff,R_Shell_S4_eff
    Dim Shared As Single Yield_Norm
    Dim Shared As Single R_E_exc_eff
    Dim Shared As Single R_Z_Heavy,R_Z_Light
    Dim Shared As Integer I_Mode
    Dim Shared As Single T_Pol_Mode_0,T_Pol_Mode_1,T_Pol_Mode_2,T_Pol_Mode_3,T_Pol_Mode_4
    Dim Shared As Single E_Min_Barr
    Dim Shared As Single RI
    Dim Shared As Single rbeta, beta1, beta2
    Dim Shared As Single rbeta_ld, rbeta_shell
    Dim Shared As Single ZUCD
    Dim Shared As Single Z
    Dim Shared As Single E_tunn
    Dim Shared As Single beta1_opt,beta2_opt,beta1_prev,beta2_prev
    Dim Shared As Single Z1,Z2
    Dim Shared As Integer IZ1
    Dim Shared As Single A1,A2
    Dim Shared As Integer IA1,IA2
    Dim Shared As Single E_defo
    Dim Shared As Single R_Pol_Curv_S0, R_Pol_Curv_S1, R_Pol_Curv_S2,R_Pol_Curv_S3,R_Pol_Curv_S4
    Dim Shared As Single RA,RZ
    Dim Shared As Single SigA_Mode_0, SigA_Mode_1, SigA_Mode_2,SigA_Mode_3,SigA_Mode_4
    Dim Shared As Single AC_Mode_0, AC_Mode_1, AC_Mode_2, AC_Mode_3, AC_Mode_4
    Dim Shared As Single R_A_heavy, R_A_light
    Dim Shared As Single RZpol
    Dim Shared As Single T_intr_Mode_0,T_intr_Mode_1_heavy,T_intr_Mode_1_light
    Dim Shared As Single T_intr_Mode_2_heavy,T_intr_Mode_2_light
    Dim Shared As Single T_intr_Mode_3_heavy,T_intr_Mode_3_light
    Dim Shared As Single T_intr_Mode_4_heavy,T_intr_Mode_4_light
    Dim Shared As Single T
    Dim Shared As Single DU0,DU1,DU2,DU3,DU4
    Dim Shared As Single T_low_S1_used
    Dim Shared As Single SigA_Mode_11,SigA_Mode_22
    Dim Shared As Integer Ngtot = 0
    Dim Shared As Integer Nglight = 0
    Dim Shared As Integer Ngheavy = 0
    Dim Shared As Single Egtot10 = 0
    Dim Shared As Single S1_enhance
    Dim Shared As Integer I_A_CN,I_Z_CN

    ' Model parameters of GEF
    Dim Shared As Single  Emax_valid = 100      /' Maximum allowed excitation energy '/
    Dim Shared As Single _P_DZ_Mean_S1 = 0
    Dim Shared As Single _P_DZ_Mean_S2 = -0.9
    Dim Shared As Single _P_DZ_Mean_S3 = 0     /' Shift of mean Z of Mode 3 '/
  '  Dim Shared As Single _P_DZ_Mean_S4 = 0.5
    Dim Shared As Single _P_DZ_Mean_S4 = 0.25
    Dim Shared As Single _P_Z_Curv_S1 = 0.23
    Dim Shared As Single P_Z_Curvmod_S1 = 3.5    /' Scales energy-dependent shift '/ 
    Dim Shared As Single _P_Z_Curv_S2 = 0.0525
    Dim Shared As Single S2leftmod = 0.7       /' Asymmetry in diffuseness of S2 mass peak '/ 
    Dim Shared As Single P_Z_Curvmod_S2 = 20   /' Scales energy-dependent shift '/
    Dim Shared As Single _P_A_Width_S2 = 14.5    /' A width of Mode 2 (box) '/
    Dim Shared As Single _P_Z_Curv_S3 = 0.038
  ' Dim Shared As Single _P_Z_Curv_S4 = 0.24     /' Curvature in Z of Mode 4 '/ 
    Dim Shared As Single _P_Z_Curv_S4 = 0.18
    Dim Shared As Single _Delta_S0 = 0         /' Shell effect for SL, for individual systems '/
    Dim Shared As Single _P_Shell_S1 = -1.8    /' Shell effect for Mode 1 '/
       Dim Shared As Single _P_Shell_S1_global = -1.8
    Dim Shared As Single _P_Shell_S2 = -4.0    /' Shell effect for Mode 2 '/
    Dim Shared As Single _P_Shell_S3 = -6.0    /' Shell effect for Mode 3 '/
    Dim Shared As Single _P_Shell_S4 = -1.3    /' Shell effect for Mode 4 '/
    Dim Shared As Single PZ_S3_olap_pos = 37   /' Pos. of S3 shell in light fragment (in N!) '/
    Dim Shared As Single PZ_S3_olap_curv = 0.005 /' for width of S3 shell in light fragment '/
    Dim Shared As Single Level_S11 = -0.5      /' Level for mode S11 '/
    Dim Shared As Single Shell_fading = 18.5   /' fading of shell effect with E* '/
    Dim Shared As Single _T_low_S1 = 0.33
    Dim Shared As Single _T_low_S2 = 0.31      /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_S3 = 0.31      /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_S4 = 0.31      /' Slope parameter for tunneling '/
    Dim Shared As Single _T_low_SL = 0.31      /' Slope parameter for tunneling '/
    Dim Shared As Single T_low_S11 = 0.36     /' Slope parameter for tunneling '/
    Dim Shared As Single _P_att_pol = 4.5     /' Attenuation of 132Sn shell '/
    Dim Shared As Single dE_Defo_S1 = -2.8    /' Deformation energy expense for Mode 1 '/
    Dim Shared As Single dE_Defo_S2 = 0       /' Deformation energy expense for Mode 2 '/
    Dim Shared As Single dE_Defo_S3 = 0       /' Deformation energy expense for Mode 3 '/
    Dim Shared As Single dE_Defo_S4 = 0       /' Deformation energy expense for Mode 4 '/
    Dim Shared As Single betaL0 = 24.5
    Dim Shared As Single betaL1 = 0.65 
    Dim Shared As Single betaH0 = 48.0    /' Offset for deformation of heavy fragment '/
    Dim Shared As Single betaH1 = 0.55
    Dim Shared As Single kappa = 0     /' N/Z dedendence of A-asym. potential '/
    Dim Shared As Single TCOLLFRAC = 0.02     /' Tcoll per energy gain from saddle to scission '/
    Dim Shared As Single ECOLLFRAC = 0.1      /' Ecoll per energy gain from saddle to scission '/
    Dim Shared As Single TFCOLL = 0.017  
    Dim Shared As Single TCOLLMIN = 0.04
    Dim Shared As Single ESHIFTSASCI_intr = -30   /' Shift of saddle-scission energy '/
    Dim Shared As Single ESHIFTSASCI_coll = -90   /' Shift of saddle-scission energy '/
    Dim Shared As Single ESHIFTSASCI_coll_global = -90 
    Dim Shared As Single EDISSFRAC = 0.35
    Dim Shared As Single SIGDEFO = 0.165  
    Dim Shared As Single SIGDEFO_0 = 0.165
    Dim Shared As Single EexcSIGrel = 0.5     /' Relative sigma of coll. and intr. energy '/
    Dim Shared As Single DNECK = 1            /' Tip distance at scission / fm '/
    Dim Shared As Single FTRUNC50 = 1         /' Truncation near Z = 50 '/
    Dim Shared As Single ZTRUNC50 = 50        /' Z value for truncation '/
    Dim Shared As Single FTRUNC28 = 0.56      /' Truncation near Z = 28 '/
    Dim Shared As Single ZTRUNC28 = 30.5      /' Z value for truncation '/
    Dim Shared As Single ZMAX_S2 = 60         /' Maximum Z of S2 channel in light fragment '/
    Dim Shared As Single NTRANSFEREO = 6      /' Steps for E sorting for even-odd effect '/
    Dim Shared As Single NTRANSFERE = 12      /' Steps for E sorting for energy division '/
    Dim Shared As Single Csort = 0.1          /' Smoothing of energy sorting '/
    Dim Shared As Single PZ_EO_symm = 2.25    /' Even-odd effect in Z at symmetry '/
    Dim Shared As Single PN_EO_Symm = 0.5     /' Even-odd effect in N at symmetry '/
    Dim Shared As Single R_EO_THRESH = 0.04   /' Threshold for asymmetry-driven even-odd effect'/
    Dim Shared As Single R_EO_SIGMA = 0.35
    Dim Shared As Single R_EO_MAX = 0.40      /' Maximum even-odd effect '/
    Dim Shared As Single _POLARadd = 0.32 /' Offset for enhanced polarization '/
    Dim Shared As Single POLARfac = 1  /' Enhancement of polarization of ligu. drop '/
    Dim Shared As Single T_POL_RED = 0.01  /' Reduction of temperature for sigma(Z) '/
    Dim Shared As Single _HOMPOL = 2.0  /' hbar omega of polarization oscillation '/
    Dim Shared As Single ZPOL1 = 0           /' Extra charge polarization of S1 '/
    Dim Shared As Single Ethreshsupps1 = 1  
    Dim Shared As Single ESIGSUPPS1 = 0.3     /' Sigma of suppression threshold '/
    Dim Shared As Single P_n_x = 0     /' Enhanced inverse neutron x section '/
    Dim Shared As Single Tscale = 1
    Dim Shared As Single Econd = 2   
    Dim Shared As Integer Emode = 1     /' 0: E over BF_B; 1: E over gs; 2: E_neutron '/
    Dim Shared As Single Jscaling = 1  /' General scaling of fragment angular momenta '/
    Dim Shared As Single Spin_odd = 0.4       /' RMS Spin enhancement for odd Z '/ 

  /' I. Properties of nuclide distributions '/

    ReDim Shared Beta(0 To 6,2,150) As Single
                           /'  Title('Mean fragment deformation at scission')
                               Cxaxis('Element number')
                               Cyaxis('beta')
                               T ype(Float);   '/

    ReDim Shared Edefo(0 To 4,2,150) As Single
                           /'  Title('Fragment deformation energy at scission')
                               Cxaxis('Element number')
                               Cyaxis('E / MeV')
                               T ype(Float);   '/

    ReDim Shared Zmean(0 To 4,2,350) As Single
                           /'  Title('Mean Z at scission')
                               Cxaxis('Mass number')
                               Cyaxis('Zm$e$a$n$')
                               T ype(Float);   '/

    ReDim Shared Zshift(0 To 4,2,350) As Single
                           /'  Title('Z polarisation at scission')
                               Cxaxis('Mass number')
                               Cyaxis('Zm$e$a$n$- ZU$C$D$')
                               T ype(Float);   '/

    ReDim Shared Temp(0 To 4,2,350) As Single
                           /'  Title('Nuclear temperature (level-density parameter)')
                               Cxaxis('Mass number')
                               Cyaxis('T / MeV')
                               T ype(Float);   '/

    ReDim Shared TempFF(0 To 4,2,350) As Single
                           /'  Title('Nuclear temperature (level-density parameter) of FF')
                               Cxaxis('Mass number')
                               Cyaxis('T / MeV')
                               T ype(Float);   '/

    ReDim Shared Eshell(0 To 4,2,350) As Single
                           /'  Title('Local shell effect over pre-neutron mass')
                               Cxaxis('Mass number')
                               Cyaxis('de^U / MeV')
                               T ype(Float);   '/

    ReDim Shared PEOZ(0 To 6,2,350) As Single
                           /'  Title('Local even-odd effect in Z')
                               Cxaxis('Mass number')
                               Cyaxis('de^P')
                               T ype(Float);   '/

    ReDim Shared PEON(0 To 6,2,350) As Single   ' pre-neutron evaporation
                           /'  Title('Local even-odd effect in N')
                               Cxaxis('Mass number')
                               Cyaxis('de^N')
                               T ype(Float);   '/

    ReDim Shared EPART(0 To 6,2,350) As Single
                           /'  Title('Energy partition')
                               Cxaxis('Mass number')
                               Cyaxis('Mean intrinsic excitation energy in fragment / MeV')
                               T ype(Float);   '/
                               
    Redim Shared SpinRMSNZ(0 To 6,2,1 To 200,1 To 150) As Single
                           /'  Title('RMS spin')
                               Cxaxis('Neutron number')
                               Cyaxis('Atomic number')
                               T ype(Float);    '/                              
                               

  /' Masses etc. '/
                               
    ReDim Shared BEldmTF(0 To 203,0 To 136) As Single
                           /'  Limits('1,203,1,136') Bins(1,1)
                               Title('Liquid-drop mass (-BE)')
                               Cxaxis('Neutron number')
                               Cyaxis('Atomic number')
                               T ype(FLOAT,Protected);   '/

    ReDim Shared BEexp(0 To 203,0 To 136) As Single
                           /'  Limits('0,203,0,136') Bins(1,1)
                               Title('Experimental mass (-BE)')
                               Cxaxis('Neutron number')
                               Cyaxis('Atomic number')
                               T ype(FLOAT,Protected);   '/
                               
    ReDim Shared ShellMO(0 To 203,0 To 136) As Single
                           /'  Limits('1,203,1,136') Bins(1,1)
                               Title('Shell effect')
                               Cxaxis('Neutron number')
                               Cyaxis('Atomic number')
                               T ype(FLOAT,Protected);   '/

    ReDim Shared EVOD(0 To 203,0 To 136) As Single
                           /'  Limits('1,203,1,136') Bins(1,1)
                               Title('Even-odd fluctuating binding energy')
                               Cxaxis('Neutron number')
                               Cyaxis('Atomic number')
                               T ype(FLOAT,Protected) ;   '/


    ReDim Shared NZPRE(0 to 200,0 to 150) As Single 
                           /'  Title('Nuclide distribution, pre-neutron')
                               Cxaxis('Neutron number')
                               Cyaxis('Proton number')
                               T ype(Float);   '/                           
                               
    ReDim Shared NZMPRE(0 To 6,0 to 200,0 to 150) As Single 
                           /'  Title('Nuclide distribution of modes, pre-neutron')
                               Cxaxis('Neutron number')
                               Cyaxis('Proton number')
                               T ype(Float);   '/         

 

    ReDim Shared As Single Array_En_light(50)  ' neutron energy array
    ReDim Shared As Single Array_En_heavy(50)  ' neutron energy array
    ReDim Shared As Single Array_En_post(100)  ' neutron energy array in lab system
    Dim As Integer In_post 
    ReDim Shared As Single Array_Tn(50)  ' neutron decay times


    
 /' Internal parameters for error analysis: '/
    Dim Shared As Single P_DZ_Mean_S1
    Dim Shared As Single P_DZ_Mean_S2
    Dim Shared As Single P_DZ_Mean_S3
    Dim Shared As Single P_DZ_Mean_S4
    Dim Shared As Single P_Z_Curv_S1
    Dim Shared As Single P_Z_Curv_S2
    Dim Shared As Single P_A_Width_S2
    Dim Shared As Single P_Z_Curv_S3
    Dim Shared As Single P_Z_Curv_S4
    Dim Shared As Single Delta_S0
    Dim Shared As Single P_Shell_S1
    Dim Shared As Single P_Shell_S2
    Dim Shared As Single P_Shell_S3
    Dim Shared As Single P_Shell_S4
    Dim Shared As Single T_low_S1
    Dim Shared As Single T_low_S2
    Dim Shared As Single T_low_S3
    Dim Shared As Single T_low_S4
    Dim Shared As Single T_low_SL
    Dim Shared As Single P_att_pol
    Dim Shared As Single HOMPOL
    Dim Shared As Single POLARadd  
     
     
 /' Control parameters: '/
    Dim Shared As Single B_F = 0              /' Fission barrier '/
    Dim Shared As Single B_F_ld = 0           /' Fission barrier, liquid drop '/
    Dim Shared As Single E_B = 0              /' Outer fission barrier '/
    Dim Shared As Single E_B_ld = 0           /' Outer fission barrier, liquid drop '/
    Dim Shared As Single R_E_exc_Eb = 0       /' Energy above outer barrier '/
    Dim Shared As Single R_E_exc_GS = 0       /' Energy above ground state '/
    Dim Shared As Single P_Z_Mean_S0 = 0      /' Mean Z of Mode 1 '/
    Dim Shared As Single P_Z_Mean_S1 = 52.8   /' Mean Z of Mode 1 '/
    Dim Shared As Single P_Z_Mean_S2 = 55     /' Mean Z of Mode 2 '/
    Dim Shared As Single P_Z_Mean_S3 = 65     /' Mean Z of Mode 3 '/
    Dim Shared As Single P_Z_Mean_S4 = 42.05  /' Mean Z of Mode 4 '/
    Dim Shared As Single NC_Mode_0 = 0        /' Mean N of symm. Mode '/
    Dim Shared As Single NC_Mode_1 = 0        /' Mean N of Mode 1 '/
    Dim Shared As Single NC_Mode_2 = 0        /' Mean N of Mode 2 '/
    Dim Shared As Single NC_Mode_3 = 0        /' Mean N of Mode 3 '/
    Dim Shared As Single NC_Mode_4 = 0
    Dim Shared As Single B_S1 = 0             /' Barrier S1, relative to SL '/
    Dim Shared As Single B_S2 = 0             /' Barrier S2, relative to SL '/
    Dim Shared As Single B_S3 = 0             /' Barrier S3, relative to SL '/
    Dim Shared As Single B_S4 = 0
    Dim Shared As Single B_S11 = 0            /' Barrier S11, relative to SL '/
    Dim Shared As Single B_S22 = 0            /' Barrier S22, relative to SL '/
    Dim Shared As Single DES11ZPM = 0         /' Mod. of eff. barrier due to ZPM in overlap '/
    Dim Shared As Single Delta_NZ_Pol = 0      /' Polarization for 132Sn '/
    Dim Shared As Single Yield_Mode_0 = 0     /' Relative yield of SL '/
    Dim Shared As Single Yield_Mode_1 = 0     /' Relative yield of S1 '/
    Dim Shared As Single Yield_Mode_2 = 0     /' Relative yield of S2 '/
    Dim Shared As Single Yield_Mode_3 = 0     /' Relative yield of S3 '/
    Dim Shared As Single Yield_Mode_4 = 0     /' Relative yield of S4 '/
    Dim Shared As Single Yield_Mode_11 = 0    /' Relative yield of S11 '/
    Dim Shared As Single Yield_Mode_22 = 0    /' Relative yield of S22 '/
    Dim Shared As Single P_POL_CURV_S0 = 0    /' Stiffnes in N/Z '/
    Dim Shared As Single T_Coll_Mode_0 = 0    /' Effective collective temperature '/
    Dim Shared As Single E_Exc_S0 = 0         /' Energy over barrier of symmetric channel '/
    Dim Shared As Single E_Exc_S1 = 0         /' Energy over barrier of S1 channel '/
    Dim Shared As Single E_Exc_S2 = 0         /' Energy over barrier of S2 channel '/
    Dim Shared As Single E_Exc_S3 = 0         /' Energy over barrier of S3 channel '/
    Dim Shared As Single E_Exc_S4 = 0         /' Energy over barrier of S4 channel '/
    Dim Shared As Single E_Exc_S11 = 0        /' Energy over barrier of S11 channel '/
    Dim Shared As Single E_Exc_S22 = 0        /' Energy over barrier of S22 channel '/
    Dim Shared As Single E_POT_SCISSION = 0   /' Potential-energy gain saddle-scission '/
    Dim Shared As Single EINTR_SCISSION = 0   /' Intrinsic excitation energy at scission '/
    Dim Shared As Single EeffS2 = 0           /' Governs S1 reduction by pairing '/
    Dim Shared As Single Sigpol_Mode_0 = 0    /' Width of isobaric Z distribution '/

  #Include Once "BEldmTF.bas"
  
  #Include Once "BEexp.bas"

  #Include Once "ShellMO.bas"


Declare Sub GEFSUB(P_Z_CN As Integer, P_A_CN As Integer, P_E_EXC As Single, _
   P_J_CN As Single)
   
GEFSUB(92,236,6.0,0.0)

/'
Dim As Single Zsum

Print
Print "Z, A, Yield"
For J = 20 To 80
  Zsum = 0
  For I = 20 To 150
    Zsum = Zsum + NZpre(I,J)
    If NZPRE(I,J) > 0.00001 Then
      Print J,I+J,NZPRE(I,J)*200
    End If
  Next
Next 

Print
Print "Z yields"
For J = 20 To 80
  Zsum = 0
  For I = 20 To 150
    Zsum = Zsum + NZpre(I,J)
  Next
  Print J, Zsum * 200 
Next

Dim As Single Asum
Print
Print "N yields"
For I = 20 To 150
  Asum = 0
  For J = 20 To 80
    Asum = Asum + NZpre(I,J)
 '   If NZPRE(I,J) > 0.001 Then
 '     Print J,I+J,NZPRE(I,J)*200
 '   End If
  Next
  Print I, Asum * 200
Next   '/

End
  

 Sub GEFSUB(P_Z_CN As Integer, P_A_CN As Integer, P_E_EXC As Single, _
   P_J_CN As Single)
   /' Input parameters: '/
   /' Atomic number, mass number, excitation energy/MeV, spin/h_bar of CN '/
   /' Results are stored in external arrays. '/
   
/'<FO INCLUDE "GEFSUBdcl2.FOR" FO>'/

  Bsub = 1
  
   Static As Integer I_E_iso  ' numbered in sequence of increasing energy
   Static As Single Spin_CN     


  P_DZ_Mean_S1 = _P_DZ_Mean_S1
  P_DZ_Mean_S2 = _P_DZ_Mean_S2
  P_DZ_Mean_S3 = _P_DZ_Mean_S3
  P_DZ_Mean_S4 = _P_DZ_Mean_S4
  P_Z_Curv_S1 = _P_Z_Curv_S1
  P_Z_Curv_S2 = _P_Z_Curv_S2
  P_A_Width_S2 = _P_A_Width_S2
  P_Z_Curv_S3 = _P_Z_Curv_S3
  P_Z_Curv_S4 = _P_Z_Curv_S4
  Delta_S0 = _Delta_S0
  P_Shell_S1 = _P_Shell_S1
  P_Shell_S2 = _P_Shell_S2
  P_Shell_S3 = _P_Shell_S3
  P_Shell_S4 = _P_Shell_S4
  T_low_S1 = _T_low_S1
  T_low_S2 = _T_low_S2
  T_low_S3 = _T_low_S3
  T_low_S4 = _T_low_S4
  T_low_SL = _T_low_SL
  P_att_pol = _P_att_pol
  HOMPOL = _HOMPOL
  POLARadd = _POLARadd
  
    Dim As Single R_E_exc_used
    R_E_exc_used = P_E_exc
    I_A_CN = P_A_CN
    I_Z_CN = P_Z_CN

    /' Central Z values of fission modes '/

    /' Fit to positions of fission channels (Boeckstiegel et al., 2008) '/
    /' P_DZ_Mean_S1 and P_DZ_Mean_S2 allow for slight adjustments '/
    Scope
    Dim As Single R_Z_mod
      R_Z_mod = I_Z_CN
      ZC_Mode_0 = R_Z_mod * 0.5E0      /' Central Z value of SL mode '/
      ZC_Mode_1 = (53.0E0 - 51.5E0) / (1.56E0 - 1.50E0) * _
                   (R_Z_mod^1.3E0 / I_A_CN - 1.50E0) + 51.5E0 + P_DZ_Mean_S1
      ZC_Mode_2 = (55.8E0 - 54.5E0) / (1.56E0 - 1.50E0) * _
                   (R_Z_mod^1.3E0 / I_A_CN - 1.50E0) + 54.5E0 + P_DZ_Mean_S2
      ZC_Mode_3 = ZC_Mode_2 + 4.5E0 + P_DZ_Mean_S3
      ZC_Mode_4 = 42.05 + P_DZ_Mean_S4
    End Scope

    I_N_CN = I_A_CN - I_Z_CN
    /' Mean deformation as a function of mass '/
    /' Mode 0: liquid drop and mode 4: Z = 44 '/
    beta1_prev = 0.3
    beta2_prev = 0.3
    beta1_opt = beta1_prev
    beta2_opt = beta2_prev
    For I = 10 to I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN)
      A2 = I_A_CN - A1

      Beta_Equi(A1,A2,Z1,Z2,dneck,beta1_prev,beta2_prev,beta1_opt,beta2_opt)

'Print "Mode 0, Z1,Z2,beta1,beta2",Z1,Z2,beta1_opt,beta2_opt
      Beta(0,1,I) = beta1_opt /' "light" fragment '/
      Beta(4,1,I) = beta1_opt
      Beta(0,2,I) = beta1_opt /' "heavy" fragment '/
      Beta(4,2,I) = beta1_opt
      beta1_prev = beta1_opt
      beta2_prev = beta2_opt
      E_defo = Lymass(Z1,A1,beta1_opt) - Lymass(Z1,A1,0.0)
'Print "Edefo 1",E_defo      
      Edefo(0,1,I) = E_defo  /' "light" fragment '/
      Edefo(4,1,I) = E_defo
      Edefo(0,2,I) = E_defo  /' "heavy" fragment '/
      Edefo(4,2,I) = E_defo
    Next

    /' Mode 1: deformed shells (light) and spherical (heavy) '/
    For I = 10 to  I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = I_A_CN - A1
      If I_Z_CN * 0.5 < ZC_Mode_1 Then
      ' Beta_opt_light(A1,A2,Z1,Z2,dneck,0,rbeta_ld)
        /' nu_mean of Cf requires shells in the light fragment: '/
        rbeta = beta_light(I,betaL0,betaL1)  ' general deformation of light fragment
        If rbeta < 0 Then rbeta = 0
      Else
        rbeta = beta_heavy(I,betaH0,betaH1)  ' equal to S2 channel
        if rbeta < 0 Then rbeta = 0
      End If
      Beta(1,1,I) = rbeta    /' "light" fragment '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(1,1,I) = E_defo /' "light" fragment '/
    Next
    
    For I = 10 To I_Z_CN - 10
      rbeta = 0
      Beta(1,2,I) = rbeta
      Edefo(1,2,I) = 0   /' "heavy" fragment (at S1 shell) '/
    Next

    /' Mode 2: deformed shells (light and heavy) '/
    For I = 10 to I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = I_A_CN - A1
      If I_Z_CN * 0.5 < ZC_Mode_2 Then
    ' Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2),rbeta_ld)
        rbeta = beta_light(I,betaL0,betaL1)   ' general deformation of light fragment
        If rbeta < 0 Then rbeta = 0  ' negative values replaced by 0
      Else
        rbeta = beta_heavy(I,betaH0,betaH1)  ' equal to S2 channel
      End If  
      Beta(2,1,I) = rbeta
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(2,1,I) = E_defo
    Next
    For I = 10 To I_Z_CN - 10
      rbeta = beta_heavy(I,betaH0,betaH1)   /' "heavy" fragment (at S2 shell)'/
      If rbeta < 0 Then rbeta = 0  ' negative values replaced by 0  
      Beta(2,2,I) = rbeta
      Z1 = I
      A1 = (Z1 + 0.5E0) / I_Z_CN * I_A_CN /' polarization rougly considered '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(2,2,I) = E_defo
    Next

    /' Mode 3 '/
    For I = 10 to I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      A1 = (Z1 - 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      A2 = I_A_CN - A1
      rbeta = beta_light(I,betaL0,betaL1) 
      rbeta = Max(rbeta-0.10,0.0)  /' for low nu-bar of lightest fragments '/
   '  Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2,betaH0,betaH1),rbeta)  
      Beta(3,1,I) = rbeta
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(3,1,I) = E_defo
    Next
    For I = 10 To I_Z_CN - 10
      rbeta = beta_heavy(I,betaH0,betaH1) + 0.2   /' for high nu-bar of heaviest fragments '/
      If rbeta < 0 Then rbeta = 0
      Beta(3,2,I) = rbeta
      Z1 = I
      A1 = (Z1 + 0.5E0) / Csng(I_Z_CN) * Csng(I_A_CN) /' polarization roughly considered '/
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0)
      Edefo(3,2,I) = E_defo
    Next

    /' Mode 5: (Channel ST1 in both fragments) '/
    For I = 10 To I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      rbeta = Beta(1,2,I)
      if rbeta < 0 Then rbeta = 0
      Beta(5,1,Int(Z1)) = rbeta
      Beta(5,2,Int(Z1)) = rbeta
    Next

    /' Mode 6: (Channel ST2 in both fragments) '/
    For I = 10 To I_Z_CN - 10
      Z1 = I
      Z2 = I_Z_CN - Z1
      rbeta = Beta(2,2,I)
      if rbeta < 0 Then rbeta = 0
      Beta(6,1,Int(Z1)) = rbeta
      Beta(6,2,Int(Z1)) = rbeta
    Next


    /' Mean Z as a function of mass '/

    /' Mode 0 '/
    For I = 10 To I_A_CN - 10
      ZUCD = Csng(I) / Csng(I_A_CN) * Csng(I_Z_CN)
      beta1 = Beta(0,1,Int(ZUCD + 0.5))
      beta2 = Beta(0,2,Int(I_Z_CN - ZUCD + 0.5))
      Z1 = Z_equi(I_Z_CN,I, I_A_CN - I, beta1, beta2, dneck,0,_
               0,1)
      Zmean(0,1,I) = Z1
      Zshift(0,1,I) = Z1 - ZUCD
      Zmean(0,2,I_A_CN - I) = I_Z_CN - Z1
      Zshift(0,2,I_A_CN - I) = ZUCD - Z1
    Next

    /' Mode 1 '/
    For I = 10 To I_A_CN - 10
      ZUCD = Csng(I) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD + ZPOL1 /' Charge polarisation is considered in a crude way '/
      beta1 = Beta(1,1,CInt(Z)) /' "light" fragment '/
      Z = ZUCD - ZPOL1
      beta2 = Beta(1,2,CInt(I_Z_CN-Z)) /' "heavy" fragment  at S1 shell '/
      If Csng(I_Z_CN) * 0.5 < ZC_Mode_1 Then
        Z1 = Z_equi(I_Z_CN,I, I_A_CN - I, beta1, beta2, dneck,1,_
            POLARadd,POLARfac)
      Else
        Z1 = Z_equi(I_Z_CN,I, I_A_CN - I, beta1, beta2, dneck,1,0.0,0.0)
      End If      
      Z1 = Z1 + ZPOL1  /' Charge polarization by shell '/

      If I_Z_CN - Z1 < 50 And (I_Z_CN - Z1) > Z1 Then
        Z1 = I_Z_CN - 50    /' Z of mean heavy fragment not below 50 '/
      EndIf

      Zmean(1,1,I) = Z1
      Zshift(1,1,I) = Z1 - ZUCD     ' neutron-deficient
      Zmean(1,2,I_A_CN - I) = I_Z_CN - Z1
      Zshift(1,2,I_A_CN - I) = ZUCD - Z1  ' neutron rich at shell
    Next

    /' Mode 2 '/
    For I = 10 To I_A_CN - 10
      ZUCD = Csng(I) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD /' Charge polarisation is here neglected '/
      beta1 = Beta(2,1,CInt(Z))
      beta2 = Beta(2,2,CInt(I_Z_CN-Z))
      If Csng(I_Z_CN) * 0.5 < ZC_Mode_2 Then
        Z1 = Z_equi(I_Z_CN,I, I_A_CN-I, beta1, beta2, dneck,2, _
               POLARadd,POLARfac)
      Else
        Z1 = Z_equi(I_Z_CN,I, I_A_CN-I, beta1, beta2, dneck,2,0.0,0.0)
      End If         
      Zmean(2,1,I) = Z1
      Zshift(2,1,I) = Z1 - ZUCD        ' neutron deficieint
      Zmean(2,2,I_A_CN - I) = I_Z_CN - Z1  
      Zshift(2,2,I_A_CN - I) = ZUCD - Z1  ' neutron rich at shell
    Next

    /' Mode 3 '/
    For I = 10 To I_A_CN - 10
      ZUCD = Csng(I) / Csng(I_A_CN) * Csng(I_Z_CN)
      Z = ZUCD /' Charge polarisation is here neglected '/
      beta1 = Beta(3,1,CInt(Z))
      beta2 = Beta(3,2,CInt(I_Z_CN-Z))
      Z1 = Z_equi(I_Z_CN,I, I_A_CN - I, beta1, beta2, dneck,3, _
           POLARadd,POLARfac)
      Zmean(3,1,I) = Z1
      Zshift(3,1,I) = Z1 - ZUCD
      Zmean(3,2,I_A_CN - I) = I_Z_CN - Z1
      Zshift(3,2,I_A_CN - I) = ZUCD - Z1
    Next

    /' Mode 4 (assumed to be equal to mode 0) '/
    For I = 10 To I_A_CN - 10
      Zmean(4,1,I) = Zmean(0,1,I)
      Zshift(4,1,I) = Zshift(0,1,I)
      Zmean(4,2,I_A_CN - I) = Zmean(0,2,I_A_CN - I)
      Zshift(4,2,I_A_CN - I) = Zshift(0,2,I_A_CN - I)
    Next


    /' General relations between Z and A of fission channels '/
    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(0,2,CInt(RA))
    Next
    AC_Mode_0 = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN) /' mean position in mass '/
    NC_Mode_0 = AC_Mode_0 - ZC_Mode_0

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(1,2,CInt(RA))
    Next
    AC_Mode_1 = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_1 = AC_Mode_1 - ZC_Mode_1
    
    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(2,2,CInt(RA))
    Next
    AC_Mode_2 = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_2 = AC_Mode_2 - ZC_Mode_2

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(3,2,CInt(RA))
    Next
    AC_Mode_3 = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_3 = AC_Mode_3 - ZC_Mode_3

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(4,2,CInt(RA))
    Next
    AC_Mode_4 = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_4 = AC_Mode_4 - ZC_Mode_4


    /' Potential curvatures of fission modes '/

    RI = Csng(I_N_CN - I_Z_CN)/Csng(I_A_CN) /' measure of neutron excess '/
    R_Z_Curv_S0 = 8.E0 / Csng(I_Z_CN)^2 * Masscurv(Csng(I_Z_CN), Csng(I_A_CN), RI, kappa)
    R_Z_Curv1_S0 = 8.E0 / Csng(I_Z_CN)^2 * Masscurv1(Csng(I_Z_CN), Csng(I_A_CN), RI, kappa)
    R_A_Curv1_S0 = 8.E0 / Csng(I_A_CN)^2 * Masscurv1(Csng(I_Z_CN), Csng(I_A_CN), RI, kappa)



    /' Energy transformation '/
   
    Select Case Emode
      Case 0   ' Energy above outer barrier given
        R_E_exc_Eb = R_E_exc_used
        R_E_exc_GS = R_E_exc_used + BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
      Case 1,3,-1   ' Energy above ground state given
        R_E_exc_Eb = R_E_exc_used - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
        R_E_exc_GS = R_E_exc_used
      Case 2     ' kinetic energy of neutron given 
        SN = (U_Mass(Csng(I_Z_CN),Csng(I_A_CN-1)) + Lypair(I_Z_CN,I_A_CN-1)) _
           -(U_Mass(Csng(I_Z_CN),Csng(I_A_CN)) + Lypair(I_Z_CN,I_A_CN))
        R_E_exc_GS = R_E_exc_used + SN 
        R_E_exc_Eb = R_E_exc_GS - BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)
    End Select
   
   
    /' Fission barriers -> global parameters '/
   
    B_F = BFTF(Csng(I_Z_CN),Csng(I_A_CN),1)   
    B_F_ld = BFTF(Csng(I_Z_CN),Csng(I_A_CN),0)
    E_B = BFTFB(Csng(I_Z_CN),Csng(I_A_CN),1)   
    E_B_ld = BFTFB(Csng(I_Z_CN),Csng(I_A_CN),0)


    /' Barriers and excitation energies of the fission modes '/

    E_exc_S0_prov = R_E_exc_Eb


    /' Additional influence of N=82 assumed '/
    Delta_NZ_Pol = 82.E0/50.E0 - Csng(I_N_CN)/Csng(I_Z_CN)
    R_Shell_S1_eff = P_Shell_S1 * (1.E0 - P_Att_Pol * Abs(Delta_NZ_Pol))
    
    /' In Pu, the Z=50 shell meets Z=44 in the light fragment. '/
    /' A deformed shell at Z=44 is assumed to explain the enhancement _ 
       of the S1 channel around Pu '/
    /' This very same shell automatically produces the double-humped '/
    /' mass distribution in 180Hg '/   
    S1_enhance = P_Shell_S4 + _
              (Csng(I_Z_CN) - ZC_Mode_1 - ZC_Mode_4)^2 * P_Z_Curv_S4
    If S1_enhance > 0 Then S1_enhance = 0
    R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance


   ' Influence of S2 shell in complementary fragment
   ' May be called "S12 fission channel"
    T_Asym_Mode_2 = 0.5
    SigZ_Mode_2 = Sqr(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_S2))
    SigA_Mode_2 = SigZ_Mode_2 * Csng(I_A_CN) / Csng(I_Z_CN)
    S1_enhance = P_Shell_S2 * U_Box(Csng(P_A_CN) - AC_Mode_2 - AC_Mode_1, _
             SigA_Mode_2,P_A_Width_S2) *P_A_Width_S2
    If S1_enhance < 0.01 Then
      R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance
    End If   
    ' Modify deformation of complementary fragment in corresponding analyzer

    
    
    R_Shell_S3_eff = P_Shell_S3 * (1.E0 - PZ_S3_olap_curv _
        * (Csng(I_Z_CN) - 60.5E0 - PZ_S3_olap_pos)^2)
    R_Shell_S3_eff = Min(R_Shell_S3_eff,0.0)    

    R_Shell_S4_eff = P_Shell_S4

    E_ld_S1 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_1 - ZC_MODE_0) )^2
    B_S1 = E_ld_S1 + R_Shell_S1_eff
    E_exc_S1_prov = E_Exc_S0_prov - B_S1

    E_ld_S2 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_2 - ZC_MODE_0) )^2
    B_S2 = E_ld_S2 + P_Shell_S2
    E_exc_S2_prov = E_Exc_S0_prov - B_S2

    E_ld_S3 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_3 - ZC_MODE_0) )^2
    B_S3 = E_ld_S3 + R_Shell_S3_eff
    E_exc_S3_prov = E_Exc_S0_prov - B_S3

    If I_A_CN < 220 Then  ' Only here S4 is close enough to symmetry to have a chance
      E_ld_S4 = R_A_Curv1_S0 * (Csng(I_A_CN)/Csng(I_Z_CN)*(ZC_MODE_4 - ZC_MODE_0) )^2
      B_S4 = E_ld_S4 + R_Shell_S4_eff
      E_exc_S4_prov = E_Exc_S0_prov - B_S4
    Else
      B_S4 = 9999
      E_exc_S4_prov = - 9999  
    End If

    /' Mode 11 (overlap of channel 1 in light and heavy fragment '/
    /' Potential depth with respect to liquid-drop potential: B_S11 '/
    B_S11 = 2.E0 * (R_Shell_S1_eff + De_Defo_S1 _
             + P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)^2 ) - De_Defo_S1 
             
 '  If B_S11 > R_Shell_S1_eff + 0.5E0 Then 
    If B_S11 > R_Shell_S1_eff + Level_S11 Then
      B_S11 = 100   ' S1 and S11 are exclusive
    Else
      B_S11 = Min(B_S11,R_Shell_S1_eff)  
    End If  
  
    /' Lowering of effective barrier by lower ZPM due to larger width in
       partial overlap region (shells in light and heavy fragment) '/
    DES11ZPM = - 0.2E0 * (2.E0 * Abs(ZC_Mode_1 - ZC_Mode_0) )
    DES11ZPM = Min(0.0,DES11ZPM)
    B_S11 = B_S11 + DES11ZPM

    E_exc_S11_prov = E_Exc_S0_prov - B_S11

    /' Mode 22 (overlap of channel 2 in light and heavy fragment '/
    /' Potential depth with respect to liquid-drop potential: B_S22 '/

 '   B_S22 = 2.E0 * (E_ld_S2 + P_Shell_S2) _
 '       + 2.E0 * P_Z_Curv_S2 * (ZC_Mode_2 - ZC_Mode_0)^2   /' Parabola '/
'Print E_ld_S2,P_Shell_S2,P_Z_Curv_S2,ZC_Mode_2,ZC_Mode_0   
    B_S22 = 2.E0 * P_Shell_S2  * _
             U_Box(Csng(P_A_CN)/2.0 - AC_Mode_2, _
             SigA_Mode_2,P_A_Width_S2) * P_A_Width_S2
             ' The integral of U_Box is normalized, not the height! 

    E_exc_S22_prov = E_Exc_S0_prov - B_S22

    
    E_Min_Barr = Min(0.0,B_S1)
    E_Min_Barr = Min(E_Min_Barr,B_S2)
    E_Min_Barr = Min(E_Min_Barr,B_S3)
    E_Min_Barr = Min(E_Min_Barr,B_S4)
    E_Min_Barr = Min(E_Min_Barr,B_S11)
    E_Min_Barr = Min(E_Min_Barr,B_S22)
    
    /' Energy minus the height of the respective fission saddle '/
    E_exc_S0 = E_exc_S0_prov + E_Min_Barr - Delta_S0
    E_exc_S1 = E_exc_S1_prov + E_Min_Barr
    E_exc_S2 = E_exc_S2_prov + E_Min_Barr
    E_exc_S3 = E_exc_S3_prov + E_Min_Barr
    E_exc_S4 = E_exc_S4_prov + E_Min_Barr
    E_exc_S11 = E_exc_S11_prov + E_Min_Barr
    E_exc_S22 = E_exc_S22_prov + E_Min_Barr

    /' Energy above the lowest fission saddle '/
    E_exc_Barr = Max(E_Exc_S0,E_Exc_S1)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S2)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S3)
    E_exc_Barr = Max(E_exc_Barr,E_Exc_S4)
    E_exc_Barr = Max(E_exc_Barr,E_exc_S11)
    E_exc_Barr = Max(E_exc_Barr,E_exc_S22)
    

    /' Collective temperature used for calculating the widths
       in mass asymmetry and charge polarization '/

    If E_Exc_S0 < 0 Then E_tunn = -E_Exc_S0 Else E_tunn = 0
    R_E_exc_eff = Max(0.1,E_Exc_S0)
  '  T_Coll_Mode_0 = TFCOLL * R_E_exc_eff + _  /' empirical, replaced by TRusanov '/
    T_Coll_Mode_0 = TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
           Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_0 = Max(T_Coll_Mode_0,0.0)

' Print "T_Coll ";De_Saddle_Scission(I_Z_CN^2/I_A_CN^0.3333),E_tunn,T_Coll_Mode_0    
    
    /' Temperature description fitting to the empirical systematics of Rusanov et al. '/
    /' Here from Ye. N. Gruzintsev et al., Z. Phys. A 323 (1986) 307 '/    
    /' Empirical description of the nuclear temperature according to the '/
    /' Fermi-gas description. Should be valid at higher excitation energies '/
      Dim As Single T_Rusanov
    T_Rusanov = TRusanov(R_E_exc_eff,Csng(I_A_CN)) 
  '  Print "Temperatures, (GEF, Total, Rusanov): ", T_Coll_Mode_0, TFCOLL * R_E_exc_eff, T_Rusanov
    T_Coll_Mode_0 = Max(T_Coll_Mode_0,T_Rusanov)
    /' Transition vom const. temp. to Fermi gas occurs around 20 MeV by MAX function '/
  
    T_Pol_Mode_0 = T_Pol_Red * T_Coll_Mode_0
    T_Asym_Mode_0 = Sqr(T_Coll_Mode_0^2 + TCOLLMIN^2)
    
    E_pot_scission = (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
               Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_intr) - E_tunn)               

    /' Suppression of S1 fission channel due to reduced pairing in 132Sn '/
    /' At very low excitation energy on the fission path, the binding energy at the
       S1 fission channel does not profit as much from pairing as SL and S2,
       because pairing is reduced in magic nuclei. This leads to a reduction of
       the yield in S1 in the case that the fully paired ground-state configuration
       is populated on the fission path with a considerable probability. '/
 '   EeffS2 = Max(E_exc_S2,0.0) + EDISSFRAC * E_pot_scission - 2.3E0
 '   EeffS2 = Max(0.0,EeffS2)
       /' -2.3 MeV, because fission channels are assumed to be chosen before scission '/

 '   If EeffS2 < ETHRESHSUPPS1 + 2.E0 * ESIGSUPPS1 Then
 '     E_exc_S1 = E_exc_S1 - _
 '        0.5E0 * 4.E0 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS2,ESIGSUPPS1)
 '   EndIf

    T_low_S1_used = T_low_S1
    
    T_Coll_Mode_1 = TFCOLL * Max(E_exc_S1,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(I_Z_CN^2 / I_A_CN^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_1 = Max(T_Coll_mode_1,0.0)
    T_Pol_Mode_1 = T_Pol_Red * T_Coll_Mode_1
    T_Asym_Mode_1 = Sqr(T_Coll_Mode_1^2 + (6.E0*TCOLLMIN)^2)  ' TCOLLMIN for ZPM

    T_Coll_Mode_2 = TFCOLL * Max(E_exc_S2,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
          Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_2 = Max(T_Coll_mode_2,0.0)
    T_Pol_Mode_2 = T_Pol_Red * T_Coll_Mode_2
    T_Asym_Mode_2 = Sqr(T_Coll_Mode_2^2 + TCOLLMIN^2)

    T_Coll_Mode_3 = TFCOLL * Max(E_exc_S3,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _ 
            Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_3 = Max(T_Coll_mode_3,0.0)
    T_Pol_Mode_3 = T_Pol_Red * T_Coll_Mode_3
    T_Asym_Mode_3 = Sqr(T_Coll_Mode_3^2 + TCOLLMIN^2)

    T_Coll_Mode_4 = TFCOLL * Max(E_exc_S4,0.E0) + _
          TCOLLFRAC * (De_Saddle_Scission(Csng(I_Z_CN)^2 / _
             Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
    T_Coll_Mode_4 = Max(T_Coll_mode_4,0.0)
    T_Pol_Mode_4 = T_Pol_Red * T_Coll_Mode_4
    T_Asym_Mode_4 = Sqr(T_Coll_Mode_4^2 + TCOLLMIN^2)

    /' Stiffness in polarization '/

    RZ = Csng(I_Z_CN) * 0.5E0
    RA = Csng(I_A_CN) * 0.5E0
    beta1 = Beta(0,1,CInt(RZ))
    beta2 = Beta(0,2,CInt(RZ))
    R_Pol_Curv_S0 = ( LyMass( RZ - 1.E0, RA, beta1 ) + _
             LyMass( RZ + 1.0E0, RA, beta2 ) + _
             LyMass( RZ + 1.0E0, RA, beta1 ) + _
             LyMass( RZ - 1.0E0, RA, beta2 ) + _
             ecoul( RZ - 1.0E0, RA, beta1, _
                    RZ + 1.0E0, RA, beta2, dneck) + _
             ecoul( RZ + 1.0E0, RA, beta1, _
                    RZ - 1.0E0, RA, beta2, dneck) - _
         2.0E0*ecoul( RZ, RA, beta1, RZ, RA, beta2, dneck) - _
         2.0E0*LyMass( RZ, RA, beta1 ) - _
         2.0E0*LyMass( RZ, RA, beta2) ) * 0.5E0

    P_Pol_Curv_S0 = R_Pol_Curv_S0

    R_Pol_Curv_S1 = R_Pol_Curv_S0
    R_Pol_Curv_S2 = R_Pol_Curv_S0
    R_Pol_Curv_S3 = R_Pol_Curv_S0
    R_Pol_Curv_S4 = R_Pol_Curv_S0



    /' Mean values and standard deviations of fission modes '/
    
    Dim As Single R_E_intr_S1, R_E_intr_S2, R_E_intr_S3   ' intrinsic exc. energies at barrier
    Dim As Single R_E_intr_S4
    ReDim As Single R_Att(6)                              ' attenuation of shell
    ReDim As Single R_Att_Sad(6)     
  '  Dim As Single E_backshift 
  '  E_backshift = -3

    SIGZ_Mode_0 = Sqr(0.5E0 * T_Asym_Mode_0/R_Z_Curv_S0)
    If T_Pol_Mode_0 > 1.E-2 Then
      SigPol_Mode_0 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S0 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_0)))
    Else
      SigPol_Mode_0 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S0)
        /' including influence of zero-point motion '/
    Endif

    R_E_intr_S1 = Max(E_Exc_S1+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(1) = exp(-R_E_intr_S1/Shell_fading)
    R_Att(5) = R_Att(1)
    R_Att_Sad(1) = exp(-R_E_intr_S1/Shell_fading)
    R_Att_Sad(5) = R_Att_Sad(1)
    SIGZ_Mode_1 = Sqr(0.5E0 * T_Asym_Mode_1/(P_Z_Curv_S1*Sqr(R_Att(1))))
    If T_Pol_Mode_1 > 1.E-2 Then
      SigPol_Mode_1 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S1 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_1)))
    Else
      SigPol_Mode_1 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S1)
    Endif

    R_E_intr_S2 = Max(E_Exc_S2+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(2) = exp(-R_E_intr_S2/Shell_fading)
    R_Att(6) = R_Att(2)
    R_Att_Sad(2) = exp(-R_E_intr_S2/Shell_fading)
    R_Att_Sad(6) = R_Att_Sad(2)
    SIGZ_Mode_2 = Sqr(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_S2*Sqr(R_Att(2))))
    If T_Pol_Mode_2 > 1.E-2 Then
      SigPol_Mode_2 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S2 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_2)))
    Else
      SigPol_Mode_2 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S2)
    End If

    R_E_intr_S3 = Max(E_exc_S3+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(3) = exp(-R_E_intr_S3/Shell_fading)
    R_Att_Sad(3) = exp(-R_E_intr_S3/Shell_fading)
    SIGZ_Mode_3 = Sqr(0.5E0 * T_Asym_Mode_3/(P_Z_Curv_S3*Sqr(R_Att(3))))
    If T_Pol_Mode_3 > 1.E-2 Then
      SigPol_Mode_3 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S3 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_3)))
    Else
      SigPol_Mode_3 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S3)
    End if

    R_E_intr_S4 = Max(E_exc_S4+Lypair(I_Z_CN,I_A_CN),0.0)
    R_Att(4) = exp(-R_E_intr_S4/Shell_fading)
    R_Att_Sad(4) = exp(-R_E_intr_S4/Shell_fading)
    SIGZ_Mode_4 = Sqr(0.5E0 * T_Asym_Mode_4/(P_Z_Curv_S4*Sqr(R_Att(4))))
    If T_Pol_Mode_4 > 1.E-2 Then
      SigPol_Mode_4 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S4 / _
                     Tanh(HOMPOL/(2.E0 * T_Pol_Mode_4)))
    Else
      SigPol_Mode_4 = Sqr(0.25E0 * HOMPOL / R_Pol_Curv_S4)
    End if



    /' Energy-dependent shift of fission channels '/
    Scope
      Dim As Single DZ_S1,DZ_S2,DZ_S3,DZ_S4
      Dim As Single P_Z_Curv_S1_eff
      P_Z_Curv_S1_eff = P_Z_Curv_S1 * P_Z_Curvmod_S1
      Dim AS Single P_Z_Curv_S2_eff
      P_Z_Curv_S2_eff = P_Z_Curv_S2 * P_Z_Curvmod_S2      

      DZ_S1 = ZC_Mode_1 * _
              (P_Z_Curv_S1_eff*R_Att(1) / (R_Z_Curv_S0 + P_Z_Curv_S1_eff*R_Att(1)) _
            - (P_Z_Curv_S1_eff / (R_Z_Curv_S0 + P_Z_Curv_S1_eff) ) )
      DZ_S2 =  ZC_Mode_2 * _
               (P_Z_Curv_S2_eff*R_Att(2) / (R_Z_Curv_S0 + P_Z_Curv_S2_eff*R_Att(2)) _
             - (P_Z_Curv_S2_eff / (R_Z_Curv_S0 + P_Z_Curv_S2_eff) ) )  
      DZ_S3 =  ZC_Mode_3 * _
               (P_Z_Curv_S3*R_Att(3) / (R_Z_Curv_S0 + P_Z_Curv_S3*R_Att(3)) _
             - (P_Z_Curv_S3 / (R_Z_Curv_S0 + P_Z_Curv_S3) ) )
      DZ_S4 =  ZC_Mode_4 * _
               (P_Z_Curv_S4*R_Att(4) / (R_Z_Curv_S0 + P_Z_Curv_S4*R_Att(4)) _
             - (P_Z_Curv_S4 / (R_Z_Curv_S0 + P_Z_Curv_S4) ) )

 '   DZ_S1 = 0
 '   DZ_S2 = 0
 '   DZ_S3 = 0
 '   DZ_S4 = 0
   

      P_Z_Mean_S0 = ZC_Mode_0
      ZC_Mode_1 = ZC_Mode_1 + DZ_S1  
      P_Z_Mean_S1 = ZC_Mode_1          /' Copy to global parameter '/
      ZC_Mode_2 = ZC_Mode_2 + DZ_S2  
      P_Z_Mean_S2 = ZC_Mode_2          /'             "            '/
      ZC_Mode_3 = ZC_Mode_3 + DZ_S3
      P_Z_Mean_S3 = ZC_Mode_3
      ZC_Mode_4 = ZC_Mode_4 + DZ_S4
      P_Z_Mean_S4 = ZC_Mode_4 
    End Scope


    /' Energy dependence of charge polarization '/
    /' Due to washing out of shells '/
    
    For I = 10 To I_A_CN - 10   ' mass number
      For J = 1 To 4    ' fission channel
        For K = 1 To 2    ' light - heavy group
          Zshift(J,K,I) = Zshift(0,K,I) + (Zshift(J,K,I) - Zshift(0,K,I))*R_Att(J)
        Next
      Next    
    Next    
    
     
    /' Energy dependence of shell-induced deformation '/
    /' Due to washing out of shells '/
    /' (Under development) '/
 /' For I = 10 To I_Z_CN - 10  ' mass number
      For J = 1 To 4           ' fission channel
        For K = 1 To 2         ' light - heavy group
          beta(J,K,I) = beta(0,K,I) + (beta(J,K,I) - beta(0,K,I))*R_Att_Sad(J)
          if beta(J,K,I) < 0 Then 
            beta(J,K,I) = 0
          End If  
          Z1 = I
          Z2 = I_Z_CN - Z1
          A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN)
          A2 = I_A_CN - A1
          E_defo = Lymass(Z1,A1,beta(J,K,I)) - Lymass(Z1,A1,0.0)
          Edefo(J,K,I) = E_defo
        Next
      Next    
    Next  '/  
    
    


    /' General relations between Z and A of fission channels '/  
    /' 2nd iteration '/

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(0,2,CInt(RA))
    Next
    AC_Mode_0 = (ZC_Mode_0 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN) /' mean position in mass '/
    NC_Mode_0 = AC_Mode_0 - ZC_Mode_0

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(1,2,CInt(RA))
    Next
    AC_Mode_1 = (ZC_Mode_1 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_1 = AC_Mode_1 - ZC_Mode_1

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(2,2,CInt(RA))
    Next
    AC_Mode_2 = (ZC_Mode_2 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_2 = AC_Mode_2 - ZC_Mode_2

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(3,2,CInt(RA))
    Next
    AC_Mode_3 = (ZC_Mode_3 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_3 = AC_Mode_3 - ZC_Mode_3

    RZpol = 0
    For I = 1 To 3
      RA = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
      RZpol = Zshift(4,2,CInt(RA))
    Next
    AC_Mode_4 = (ZC_Mode_4 - RZPol) * Csng(I_A_CN) / Csng(I_Z_CN)
    NC_Mode_4 = AC_Mode_4 - ZC_Mode_4



   /' Yields of the fission modes '/
   
    Yield_Mode_0 = Getyield(E_exc_S0,E_exc_S0,T_low_SL,TEgidy(Csng(I_A_CN),0.E0,Tscale))
    Yield_Mode_0 = Max(Yield_Mode_0,0.0)

    Yield_Mode_1 = _
          Getyield(E_exc_S1,E_exc_S0,T_low_S1_used,TEgidy(Csng(I_A_CN),R_Shell_S1_eff + dE_Defo_S1,Tscale))
                  /'  - Getyield(E_exc_S0 - E_ld_S1,T_low,T_high); '/
    Yield_Mode_1 = Max(Yield_Mode_1,0.0)

    Yield_Mode_2 = Getyield(E_exc_S2,E_exc_S0,T_low_S2,TEgidy(Csng(I_A_CN),P_Shell_S2 + dE_Defo_S2,Tscale))
                  /'  - Getyield(E_exc_S0 - E_ld_S2,T_low,T_high); '/
    Yield_Mode_2 = Max(Yield_Mode_2,0.0)

    Yield_Mode_3 = Getyield(E_exc_S3,E_exc_S0,T_low_S3,TEgidy(Csng(I_A_CN),R_Shell_S3_eff + dE_Defo_S3,Tscale))
                  /'  - Getyield(E_exc_S0 - E_ld_S3,T_low,T_high); '/
    Yield_Mode_3 = Max(Yield_Mode_3,0.0)

    Yield_Mode_4 = Getyield(E_exc_S4,E_exc_S0,T_low_S4,TEgidy(Csng(I_A_CN),R_Shell_S4_eff + dE_Defo_S4,Tscale))
                  /'  - Getyield(E_exc_S0 - E_ld_S4,T_low,T_high); '/
    Yield_Mode_4 = Max(Yield_Mode_4,0.0)

    If B_S11 > 0 Then 
      Yield_Mode_11 = 0.0
    Else
      Yield_Mode_11 = Getyield(E_exc_S11,E_exc_S0, T_low_S11, _
          TEgidy(Csng(I_A_CN),R_Shell_S1_eff + 2.E0 * dE_Defo_S1,Tscale))
    End If      

    If B_S22 > B_S2 Then 
      Yield_Mode_22 = 0.0
    Else
      Yield_Mode_22 = Getyield(E_exc_S22,E_exc_S0, T_low_S2, _
          TEgidy(Csng(I_A_CN),P_Shell_S2,Tscale))
    End If     
    

    Yield_Norm = Yield_Mode_0 + Yield_Mode_1 + Yield_Mode_2 + Yield_Mode_3 _
                 + Yield_Mode_4 + Yield_Mode_11 + Yield_Mode_22
    Yield_Mode_0 = Yield_Mode_0 / Yield_Norm
    Yield_Mode_1 = Yield_Mode_1 / Yield_Norm
    Yield_Mode_2 = Yield_Mode_2 / Yield_Norm
    Yield_Mode_3 = Yield_Mode_3 / Yield_Norm
    Yield_Mode_4 = Yield_Mode_4 / Yield_Norm
    Yield_Mode_11 = Yield_Mode_11 / Yield_Norm
    Yield_Mode_22 = Yield_Mode_22 / Yield_Norm


    /' Mass widhts of the fission channels '/

    SigA_Mode_0 = SigZ_Mode_0 * Csng(I_A_CN) / Csng(I_Z_CN) /' width in mass '/
    SigA_Mode_1 = SigZ_Mode_1 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_1 = Min(SigA_Mode_1,SigA_Mode_0)  ' not broader than liquid-drop
    SigA_Mode_2 = SigZ_Mode_2 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_2 = Min(SigA_Mode_2,SigA_Mode_0)  ' not broader than liquid-drop
    SigA_Mode_3 = SigZ_Mode_3 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_3 = Min(SigA_Mode_3,SigA_Mode_0)
    SigA_Mode_4 = SigZ_mode_4 * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_4 = Min(SigA_Mode_4,SigA_Mode_0)
    SigA_Mode_11 = SigZ_Mode_1 * sqr(2.E0) * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_11 = Min(SigA_Mode_11,SigA_Mode_0)
    SigA_Mode_22 = SigZ_Mode_2 * sqr(2.E0) * Csng(I_A_CN) / Csng(I_Z_CN)
    SigA_Mode_22 = Min(SigA_Mode_22,SigA_Mode_0)



    /' Shell effects of different fission channels '/
    /' This is the "real" microscopic shell effect, not the effective shell-correction energy '/
    /' EShell acts on the level density and determines the T parameter '/

    For I = 1 To I_A_CN - 1
      For J = 0 To 4
        EShell(J,1,I) = 0   /' Shells in "light" fragment assumed to be zero '/
      Next
      DU0 = 0
      EShell(0,2,I) = 0 /' Shell = 0 in symmetric mode '/
      DU1 = R_Shell_S1_eff + dE_Defo_S1 /' + R_A_Curv1_S1 * (AC_Mode_1 - Float(I,6))**2; '/
      DU1 = MIN(DU1,0.E0)  /' Technical limit '/
      EShell(1,2,I) = DU1

      DU2 = P_Shell_S2 + dE_Defo_S2 /' + R_A_Curv1_S2 * (AC_Mode_2 - Float(I,6))**2; '/
      DU2 = Min(DU2,0.E0)  /' Technical limit '/
      EShell(2,2,I) = DU2

      DU3 = R_Shell_S3_eff + dE_Defo_S3 /' + R_A_Curv1_S3 * (AC_Mode_3 - Float(I,6))**2; '/
      DU3 = Min(DU3,0.E0)  /' Technical limit '/
      EShell(3,2,I) = DU3

      DU4 = R_Shell_S4_eff + dE_Defo_S4 /' + R_A_Curv1_S4 * (AC_Mode_4 - Float(I,6))**2; '/
      DU4 = Min(DU4,0.E0)  /' Technical limit '/
      EShell(4,2,I) = DU4

    Next


    /' Intrinsic temperatures of fragments at scission '/

    /' Mean values '/
    T_intr_Mode_0 = TEgidy(AC_Mode_0,0.0,0.8)
    T_intr_Mode_1_heavy = TEgidy(AC_Mode_1,R_Shell_S1_eff + dE_Defo_S1,Tscale)
    T_intr_Mode_1_light = TEgidy(Csng(I_A_CN) - AC_Mode_1,0.0,Tscale)
    T_intr_Mode_2_heavy = TEgidy(AC_Mode_2,P_Shell_S2 + dE_Defo_S2,Tscale)
    T_intr_Mode_2_light = TEgidy(Csng(I_A_CN) - AC_Mode_2,0.0,Tscale)
    T_intr_Mode_3_heavy = TEgidy(AC_Mode_3,R_Shell_S3_eff + dE_Defo_S3,Tscale)
    T_intr_Mode_3_light = TEgidy(Csng(I_A_CN) - AC_Mode_3,0.0,Tscale)
    T_intr_Mode_4_heavy = TEgidy(AC_Mode_4,R_Shell_S4_eff + dE_Defo_S4,Tscale)
    T_intr_Mode_4_light = TEgidy(Csng(I_A_CN) - AC_Mode_4,0.0,Tscale)


    /' Mass-dependent values of individual fragments '/
    /' Mode 0 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(0,1,I),Tscale)
      Temp(0,1,I) = T /' "light" fragment at freeze-out (somewhere before scission) '/
      T = TEgidy(Csng(I),EShell(0,2,I),Tscale)
      Temp(0,2,I) = T /' "heavy" fragment at freeze-out (somewhere before scission) '/

      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(0,1,I) = T       ' FF in their ground state
      TempFF(0,2,I) = T       ' FF in their ground state 
    Next

    /' Mode 1 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(1,1,I),Tscale)
      Temp(1,1,I) = T  /' "light" fragment '/
      T = TEgidy(Csng(I),EShell(1,2,I),Tscale)
      Temp(1,2,I) = T  /' "heavy" fragment '/

      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(1,1,I) = T       ' FF in their ground state
      TempFF(1,2,I) = T       ' FF in their ground state
    Next

    /' Mode 2 '/
    For I = 1 To I_A_CN - 1
      T = TEgidy(Csng(I),EShell(2,1,I),Tscale)
      Temp(2,1,I) = T /' "light" fragment '/
      T = TEgidy(Csng(I),EShell(2,2,I),Tscale)
      Temp(2,2,I) = T /' "heavy" fragment '/

   /' The next section is introduced, because energy sorting is not strong enough,
      when shells are only introduced in the heavy fragment.
      Ad hoc assumption: For Mode 2 there are shells in both fragments of about
      equal size. Technically, we neglect the shells in both fragments.
      This has about the same effect for the energy sorting. '/
      T = TEgidy(Csng(I),0.0,Tscale)   ' FF at scssion
      Temp(2,1,I) = T /' "light" fragment '/
      T = TEgidy(Csng(I),0.0,Tscale)   ' FF at scission
      Temp(2,2,I) = T /' "heavy" fragment '/

      T = TEgidy(Csng(I),0.0,1.0)    ' shell effect neglected
      TempFF(2,1,I) = T    ' FFs in their ground state
      TempFF(2,2,I) = T    ' FFs in their ground state
    Next
    
    /' Mode 3 '/
    For I = 1 To I_A_CN -1
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(3,1,I) = T
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(3,2,I) = T
      
      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(3,1,I) = T       ' FF in their ground state
      TempFF(3,2,I) = T       ' FF in their ground state
    Next

    /' Mode 4 '/
    For I = 1 To I_A_CN -1
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(4,1,I) = T
      T = TEgidy(Csng(I),0.0,Tscale)
      Temp(4,2,I) = T
      
      T = TEgidy(Csng(I),0.0,1.0)
      TempFF(4,1,I) = T       ' FF in their ground state
      TempFF(4,2,I) = T       ' FF in their ground state
    Next


    /'** Intrinsic excitation energy at saddle and at scission as well as   **'/
    /'** Even-odd effect in proton and neutron number for each fission mode **'/
    Dim As Single Etot,E1FG,E1ES
    Dim As Single Rincr1P,Rincr1N,Rincr2,Rincr2P,Rincr2N
    Dim As Single T1,T2,E1,E2
    Redim As Single E_coll_saddle(0 To 6)


    For I_Mode = 0 To 6
      E_coll_saddle(I_Mode) = 0
      If I_Mode = 0 Then Etot = E_exc_S0
      If I_Mode = 1 Then Etot = E_exc_S1
      If I_Mode = 2 Then Etot = E_exc_S2
      If I_Mode = 3 Then Etot = E_exc_S3
      If I_Mode = 4 Then Etot = E_exc_S4
      If I_Mode = 5 Then Etot = E_exc_S11
      If I_Mode = 6 Then Etot = E_exc_S22
      If I_Z_CN Mod 2 + I_N_CN Mod 2 = 0 Then  /' Even-even CN '/
        If Etot > 0 And Etot < 2.E0 * 12.E0/Sqr(Csng(I_A_CN)) Then
          E_coll_saddle(I_Mode) = Etot
          Etot = 0
         /' Excitation below the pairing gap in even-even CN goes into collective excitations '/
        End If
      End If
      Etot = Max(Etot,0.0)
      Etot = Etot + EDISSFRAC * E_pot_scission
      /' All excitation energy at saddle and part of the potential-energy gain to scission
         go into intrinsic excitation energy at scission '/



      Dim As Single DT

      For IA1 = 40 To I_A_CN - 40

        IA2 = I_A_CN - IA1
        If I_Mode <= 4 Then
          T1 = Temp(I_Mode,1,IA1)
          T2 = Temp(I_Mode,2,IA2)
        End If
        If I_Mode = 5 Then
          T1 = Temp(1,2,IA1)
          T2 = Temp(1,2,IA2)
        End If  
        If I_Mode = 6 Then
          T1 = Temp(2,2,IA1)
          T2 = Temp(2,2,IA2)
        End If
        DT = ABS(T2 - T1)
        
          /' Even-odd effect '/
        IF I_Z_CN Mod 2 = 0 Then
           Rincr1P = Exp(-Etot/PZ_EO_symm)
        Else
           Rincr1P = 0
        End If
        If I_N_CN Mod 2 = 0 Then
           Rincr1N = Exp(-Etot/PN_EO_symm)
        Else
           Rincr1N = 0
        End If
        If I_Mode <= 4 Then
          PEOZ(I_Mode,1,IA1) = Rincr1P
          PEOZ(I_Mode,2,IA2) = Rincr1P
          PEON(I_Mode,1,IA1) = Rincr1N
          PEON(I_Mode,2,IA2) = Rincr1N
        End If
        If I_Mode = 5 Then 
          PEOZ(5,1,IA1) = Rincr1P
          PEOZ(5,2,IA2) = Rincr1P
          PEON(5,1,IA1) = Rincr1N
          PEON(5,2,IA2) = Rincr1N
        End If
        If I_Mode = 6 Then 
          PEOZ(6,1,IA1) = Rincr1P
          PEOZ(6,2,IA2) = Rincr1P
          PEON(6,1,IA1) = Rincr1N
          PEON(6,2,IA2) = Rincr1N
        End If

        Rincr2 = Gaussintegral(DT/Etot-R_EO_Thresh, _
                 R_EO_Sigma*(DT+0.0001))
                  /' even-odd effect due to asymmetry '/
        Rincr2P = (R_EO_MAX - Rincr1P) * Rincr2
        Rincr2N = (R_EO_MAX - Rincr1N) * Rincr2        

        If IA1 < IA2 Then  ' A1 is lighter
          PEOZ(I_Mode,1,IA1) = _
               PEOZ(I_Mode,1,IA1) + Rincr2P
          IF I_Z_CN Mod 2 = 0 Then
             PEOZ(I_Mode,2,IA2) = _
                PEOZ(I_Mode,2,IA2) + Rincr2P
          Else
             PEOZ(I_Mode,2,IA2) = _
                PEOZ(I_Mode,2,IA2) - Rincr2P
          End if
          PEON(I_Mode,1,IA1) = _
             PEON(I_Mode,1,IA1) + Rincr2N
          IF I_N_CN Mod 2 = 0 Then
             PEON(I_Mode,2,IA2) = _
                PEON(I_Mode,2,IA2) + Rincr2N
          Else
             PEON(I_Mode,2,IA2) = _
                PEON(I_Mode,2,IA2) - Rincr2N
          End if
        Else   
          PEOZ(I_Mode,1,IA1) = PEOZ(I_Mode,2,IA1)
          PEON(I_Mode,1,IA1) = PEON(I_Mode,2,IA1)
          PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,1,IA2)
          PEON(I_Mode,2,IA2) = PEON(I_Mode,1,IA2)
        End If            
          
          
    /'  Else
          PEOZ(I_Mode,2,IA2) = _
               PEOZ(I_Mode,1,IA2) + Rincr2P
          IF I_Z_CN Mod 2 = 0 Then
             PEOZ(I_Mode,1,IA1) = _
                PEOZ(I_Mode,1,IA1) + Rincr2P
          Else
             PEOZ(I_Mode,1,IA1) = _
                PEOZ(I_Mode,1,IA1) - Rincr2P
          End if
          PEON(I_Mode,2,IA2) = _
             PEON(I_Mode,2,IA2) + Rincr2N
          IF I_N_CN Mod 1 = 0 Then
             PEON(I_Mode,1,IA1) = _
                PEON(I_Mode,1,IA1) + Rincr2N
          Else
             PEON(I_Mode,1,IA1) = _
                PEON(I_Mode,1,IA1) - Rincr2N
          End if
        End If  '/

          /' Energy sorting '/
     /' E1 = Etot * Gaussintegral(T2-T1,0.03); '/
        If Abs(T1-T2) < 1.E-6 Then
          E1 = 0.5E0 * Etot
        Else
          E1ES = Csort * T1 * T2 / ( Abs(T1 - T2) )
          E1ES = Min(E1ES,0.5E0*Etot)
           /' Asymptotic value after "complete" energy sorting '/
          E1FG = Etot * IA1 / I_A_CN  /' in Fermi-gas regime '/
          If Etot < 13 Then E1 = E1ES  ' complete energy sorting
          If Etot >= 13 and Etot <= 20 Then  ' transition region
            E1 = E1ES + (Etot-13)/7*(E1FG-E1ES)
          End If
          If Etot > 20 Then E1 = E1FG   ' Fermi-gas regime
        End If
        E2 = Etot - E1
        EPART(I_Mode,1,IA1) = E1  /' Mean E* in light fragment '/
        EPART(I_Mode,2,IA2) = E2  /' Mean E* in heavy fragment '/
      Next
    Next


    EINTR_SCISSION = Etot /' (For Mode 2) Global parameter '/
  
   /'** RMS angular momentum of fission fragments **'/
   /' Following Naik et al., EPJ A 31 (2007) 195 and  '/
   /' S. G. Kadmensky, Phys. At. Nucl. 71 (2008) 1193 '/ 

   Scope
    Dim As Single AUCD   /' UCD fragment mass '/
    Dim As Single I_rigid_spher  /' I rigid for spherical shape '/
    Dim As Single I_rigid        /' I rigid for deformed scission shape '/
    Dim As Single I_eff          /' I with reduction due to pairing '/
    Dim As Single alph           /' deformation parameter '/
    Dim As Single E_exc          /' Excitation energy '/
    Dim As Single J_rms          /' rms angular momentum '/
    Dim As Integer ZT,AT         /' Z and A of target nucleus '/
    /' CN spin '/
    ZT = P_Z_CN
  '  AT = I_A_CN
    AT = P_A_CN
    If Emode = 2 Then AT = AT -1
    Spin_CN = P_J_CN
 '   Print "ZT, AT, I_MAT",ZT, AT, I_MAT
 '   Print "SPIN_CN",Spin_CN
 '   Sleep
    
    For IZ1 = 10 To I_Z_CN - 10
      AUCD = Int(Csng(IZ1) * Csng(I_A_CN) / Csng(I_Z_CN))
      For IA1 = Int(AUCD - 15) To Int(AUCD + 15)
       If IA1 - IZ1 >= 10 Then
        /' Rigid momentum of inertia for spherical nucleus '/
        I_rigid_spher = 1.16E0^2 * Csng(IA1)^1.6667E0 / 103.8415E0
                /' unit: hbar^2/MeV '/
        For I_Mode = 0 To 6  
          
          /' First (normally light) fission fragment: '/
          
          beta1 = Beta(I_Mode,1,IZ1)
          alph = beta1 / sqr(4.E0 * pi / 5.E0)
          I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph^2)
                  /' From Hasse & Myers, Geometrical Relationships ... '/
          E_exc = EPART(I_Mode,1,IA1)
          If E_exc < 0 Then E_exc = 0
          T = U_Temp(Csng(IZ1),Csng(IA1),E_exc,1,1,Tscale,Econd)          
          T = sqr(T^2 + 0.8^2)       ' For ZPM
          I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0))
          J_rms = sqr(2.E0 * I_eff * T)  
          
          /' Influence of CN spin '/
          J_rms = sqr(J_rms^2 + 1./3. * Spin_CN^2)
          
          /' Incoming neutron (spin + orbital) '/
          If Emode = 2 Then
            ' 2/3 * 1.16 * sqrt(2 * 939.65) / 197.33 = 0.1699 
            J_rms = sqr(J_rms^2 + 1./3 * 0.5^2 + _ 
                 1./3. * (0.1699 * AT^0.333333 * sqr(R_E_exc_used))^2)
          End If  
          
          If IZ1 Mod 2 = 1 Then J_rms = J_rms + Spin_odd * (Csng(IA1)/140.0)^0.66667 /' empirical '/
           /' Additional angular momentum of unpaired proton. '/ 
           /' See also Tomar et al., Pramana 68 (2007) 111 '/
           
          J_rms = J_rms * Jscaling 
' Print Z1,I_Mode,beta1,T,E_exc,Spin_CN         
' Print " ",I_rigid_spher,I_rigid,I_eff,J_rms
            
          SpinRMSNZ(I_Mode,1,IA1-IZ1,IZ1) = J_rms
          
          
     '     Print A1,T,E_exc,I_rigid_spher,I_rigid,I_eff,J_rms

          /' Second (normally heavy) fission fragment: '/

          beta2 = Beta(I_Mode,2,IZ1)
          alph = beta2 / sqr(4.E0 * pi / 5.E0)
          I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph^2)
                  /' From Hasse & Myers, Geometrical Relationships ... '/
          E_exc = EPART(I_Mode,2,IA1)
          If E_exc < 0 Then E_exc = 0
          T = U_Temp(Csng(IZ1),Csng(IA1),E_exc,1,1,Tscale,Econd)          
          T = sqr(T^2 + 0.8^2)       ' For ZPM
          I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0))
          J_rms = sqr(2.E0 * I_eff * T)

          /' Influence of CN spin '/
          J_rms = sqr(J_rms^2 + 1./3. * Spin_CN^2)

          /' Incoming neutron (spin + orbital) '/
          If Emode = 2 Then
            ' 2/3 * 1.16 * sqrt(2 * 939.65) / 197.33 = 0.1699 
            J_rms = sqr(J_rms^2 + 1./3. * 0.5^2 + _ 
                 1./3. * (0.1699 * AT^0.333333 * sqr(R_E_exc_used))^2)
          End If  
          
          If IZ1 Mod 2 = 1 Then J_rms = J_rms + Spin_odd * (IA1/140.0)^0.66667 /' empirical '/
           /' Additional angular momentum of unpaired proton. '/ 
           /' See also Tomar et al., Pramana 68 (2007) 111 '/
           
          J_rms = J_rms * Jscaling 
          
          SpinRMSNZ(I_Mode,2,IA1-IZ1,IZ1) = J_rms

        Next
       ENd If 
      Next
    Next
   End Scope

' *******************************************************
' *** Filling arrays with results in the folding mode *** 
' *******************************************************

 Dim As Integer Ic, Jc
 Dim As Single R_Help,Zs,R_Sum
 
 For I = 10 To I_A_CN - P_Z_CN - 10
   For J = 10 To P_Z_CN - 10
     For K = 0 To 6
       NZMPRE(K,I,J) = 0.0
     Next
   Next
 Next
 
 ' Mode 0
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_0 * (U_Gauss(AC_Mode_0 - Csng(I), SigA_Mode_0) _ 
                 + U_Gauss(AC_Mode_0 - Csng(Ic), SigA_Mode_0)) ' Mass yield
   If I < Ic Then
     Zs = ZShift(0,1,I)
   Else
     Zs = -ZShift(0,1,Ic)
   End If
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(0,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) + Zs - Csng(J),SigPol_Mode_0) * _
          U_Even_Odd(J,PEOZ(0,1,I)) * U_Even_Odd(I-J,PEON(0,1,I))   
     End If     
   Next
 Next

 ' Mode 1
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_1 * (U_Gauss(AC_Mode_1 - Csng(I), SigA_Mode_1) _
               + U_Gauss(AC_Mode_1 - Csng(Ic), SigA_Mode_1)) ' Mass yield
   If I < Ic Then
     Zs = ZShift(1,1,I)
   Else
     Zs = -ZShift(1,1,Ic)
   End If  
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(1,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) + Zs - Csng(J),SigPol_Mode_1)* _
          U_Even_Odd(J,PEOZ(1,1,I)) * U_Even_Odd(I-J,PEON(1,1,I))   
     End If    
   Next
 Next 
 
 ' Mode 2
 Dim As Single R_Cut1, R_Cut2
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_2 * (U_Box(AC_Mode_2 - Csng(I), _
               sqr(2.0)*SigA_Mode_2,P_A_Width_S2) + _
            U_Box(AC_Mode_2 - Csng(Ic), _
               sqr(2.0)*SigA_Mode_2,P_A_Width_S2))
   If I < Ic Then
     Zs = ZShift(2,1,I)
   Else
     Zs = -ZShift(2,1,Ic)
   End If   
   For J = 10 To P_Z_CN - 10
     Jc = P_Z_CN - J 
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       R_Cut1 = R_Help
       R_Cut2 = R_Help
       If J > Jc Then
         R_Cut1 = R_Help * Gaussintegral(Csng(J)-ZTRUNC50,FTRUNC50*SigZ_Mode_2)
       Else 
         R_Cut2 = R_Help * Gaussintegral(Csng(J)-ZTRUNC50,FTRUNC50*SigZ_Mode_2)
       End If     
       NZMPRE(2,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) + Zs - Csng(J),SigPol_Mode_2) * _
         U_Even_Odd(J,PEOZ(2,1,I)) * U_Even_Odd(I-J,PEON(2,1,I))  
     End If     
   Next
 Next

 ' Mode 3
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_3 * (U_Gauss(AC_Mode_3 - Csng(I), SigA_Mode_3) + _
                    U_Gauss(AC_Mode_3 - Csng(I), SigA_Mode_3)) ' Mass yield   
   If I < Ic Then
     Zs = ZShift(3,1,I)
   Else
     Zs = -ZShift(3,1,Ic)
   End If   
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(3,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) + Zs - Csng(J),SigPol_Mode_3) * _
         U_Even_Odd(J,PEOZ(3,1,I)) * U_Even_Odd(I-J,PEON(3,1,I))         
     End If     
   Next
 Next  
 
 ' Mode 4
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_4 * (U_Gauss(AC_Mode_4 - Csng(I), SigA_Mode_4) + _
                    U_Gauss(AC_Mode_4 - Csng(I), SigA_Mode_4)) ' Mass yield   
   If I < Ic Then
     Zs = ZShift(3,1,I)
   Else
     Zs = -ZShift(3,1,Ic)
   End If   
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(4,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) + Zs - Csng(J),SigPol_Mode_4) * _
          U_Even_Odd(J,PEOZ(4,1,I)) * U_Even_Odd(I-J,PEON(4,1,I))         
     End If           
   Next
 Next   

 ' Mode 11
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_11 * (U_Gauss(AC_Mode_0 - Csng(I), SigA_Mode_11) + _
                    U_Gauss(AC_Mode_0 - Csng(I), SigA_Mode_11)) ' Mass yield   
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(5,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) - Csng(J),SigPol_Mode_0) * _
          U_Even_Odd(J,PEOZ(5,1,I)) * U_Even_Odd(I-J,PEON(5,1,I))         
     End If    
   Next
 Next 
 
 ' Mode 22
 For I = 20 To I_A_CN - 20
   Ic = I_A_CN - I
   R_Help = Yield_Mode_22 * (U_Gauss(AC_Mode_0 - Csng(I), SigA_Mode_22) + _
                    U_Gauss(AC_Mode_0 - Csng(I), SigA_Mode_22)) ' Mass yield   
   For J = 10 To P_Z_CN - 10 
     Jc = P_Z_CN - J
     If I-J >= 0 And Ic-Jc >= 0 And I-J <= 200 And Ic-Jc <= 200 Then
       NZMPRE(6,I-J,J) = R_Help * _ 
          U_Gauss(Csng(P_Z_CN)/Csng(I_A_CN)*Csng(I) - Csng(J),SigPol_Mode_0) * _
          U_Even_Odd(J,PEOZ(6,1,I)) * U_Even_Odd(I-J,PEON(6,1,I))        
     End If            
   Next
 Next  
 

 ' Normalization 
 R_Sum = 0
 For I = 10 To (I_A_CN - P_Z_CN) - 10
   For J = 10 To P_Z_CN - 10
     NZPRE(I,J) = 0
     For K = 0 To 6
       If NZMPRE(K,I,J) > 0 Then
         R_Sum = R_Sum + NZMPRE(K,I,J) 
         NZPRE(I,J) = NZPRE(I,J) + NZMPRE(K,I,J)  ' sum of all modes
       End If
     Next
   Next
 Next
 Print R_Sum
 For I = 10 To (I_A_CN - P_Z_CN) - 10
   For J = 10 To P_Z_CN - 10
     NZPRE(I,J) = NZPRE(I,J) / R_Sum
     For K = 0 To 6
       NZMPRE(K,I,J) = NZMPRE(K,I,J) / R_Sum
     Next
   Next
 Next    
 
 ' Calculate and store distributions of fragment excitation energy and spin
 
 Dim As Integer N_index,Z_index,A_index,M_index 
 Dim As Single Ymin = 1.E-7           ' Minimum yield to be stored
 Dim As Single Eexc_mean, Eexc_sigma
 Dim As Single Eexc_intr, Eexc_coll

 /' ***************** Begin Module GEFRESULTS ********************* '/
 Dim As Integer N_cases            ' Number of cases in NZMkey, Etab, Jtab and Ytab
 ' (First dimension of NZMkey, Etab, Jtab and Ytab)
 ReDim NZMkey(10000,3) As Integer  ' Key (Mode,N,Z) for E*, spin and yield distr. of fragments 
 ReDim Etab(10000,1000) As Single  ' Excitation-energy distribution of fragments (0.1 MeV bins)
 Redim Jtab(10000,100) As Single   ' Spin distribution of fragments
 ' (0 to 100 hbar for even-A or 1/2 to 201/2 hbar for odd-A nuclei)
 Redim Ytab(10000) As Single       ' Yield of fragments
 /' ****************** End Module GEFRESULTS ********************* '/
 
  
 N_cases = 0 
 For N_index = 10 To (I_A_CN - P_Z_CN) - 10   ' Neutron number
   For Z_index = 10 To P_Z_CN - 10            ' Atomic number
     For M_index = 0 To 6
       If NZMPRE(M_index,N_index,Z_index) > Ymin Then
         N_cases = N_cases + 1
         If N_cases = Ubound(NZMkey,1) Then
           Print "Upper bound of NZkey reached"
           Print "Result will be incomplete"
           Exit For, For, For 
         End If
         NZMkey(N_cases,1) = M_index  ' Fission mode
         NZMkey(N_cases,2) = N_index  ' Neutron number of fragment
         NZMkey(N_cases,3) = Z_index  ' Atomic number of fragment
       End If
     Next  
   Next
 Next
 Print "N_cases  ",N_cases
 
 For K = 1 To N_cases
   M_index = NZMkey(K,1)   ' fission mode
   N_index = NZMkey(K,2)   ' neutron number
   Z_index = NZMkey(K,3)   ' atomic number 
   A_index = N_index + Z_index

   ' Yield
   Ytab(K) = NZMpre(M_index,N_index,Z_index)
   
   ' Angular momentum:
   For I = 1 To 100
     If M_index <= 4 Then
       If Z_index < 0.5 * P_Z_CN Then
         Jtab(K,I) = _
           U_LinGauss(Csng(I),SpinRMSNZ(M_index,1,N_index,Z_index)/sqr(2.0))
       Else
         Jtab(K,I) = _
           U_LinGauss(Csng(I),SpinRMSNZ(M_index,2,N_index,Z_index)/sqr(2.0))
       End If  
     End If
     If M_index = 5 Then
       Jtab(K,I) = _
         U_LinGauss(Csng(I),SpinRMSNZ(1,2,N_index,Z_index)/sqr(2.0))
     End If
     If M_index = 6 Then
       Jtab(K,I) = _
         U_LinGauss(Csng(I),SpinRMSNZ(2,2,N_index,Z_index)/sqr(2.0))
     End If
   Next 
   
   ' Normalize numerically (due to non-continuous values) 
   Scope
     Dim As Single Rint = 0
     For I = 1 To 100
       Rint = Rint + Jtab(K,I)
     Next   
     If Rint > 0 Then
       For I = 1 To 100
         Jtab(K,I) = Jtab(K,I) / Rint
       Next  
     End If
   End Scope  
   
   
   ' Excitation energy:
   ' 1. Deformation energy at scission
   Dim As Single RS
   If M_index = 0 Then
     If Z_index < 0.5 * P_Z_CN Then
       Eexc_mean = Edefo(M_index,1,Z_index)
       Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) + SIGDEFO_0) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) ))       
            ' factor 2 is a guess for the smaller shape restoring force of the liquid-drop
     Else
       Eexc_mean = Edefo(M_index,2,Z_index)
       Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) + SIGDEFO_0) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) ))
            ' factor 2 is a guess for the smaller shape restoring force of the liquid-drop
     End If 
   End If
   If M_index > 0 And M_index <= 4 Then
     If Z_index < 0.5 * P_Z_CN Then
       Eexc_mean = Edefo(M_index,1,Z_index)
       RS = SIGDEFO/Sqr(R_Att_Sad(M_index))
       Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,1,Z_index) ))       
     Else
       Eexc_mean = Edefo(M_index,2,Z_index)
       RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
       Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(M_index,2,Z_index) ))
     End If
   End If    
   If M_index = 5 Then
     Eexc_mean = Edefo(1,2,Z_index)
     RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
     Eexc_sigma = _
          ( Lymass(Csng(Z_index),Csng(A_index),beta(1,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(1,2,Z_index) ))  
   End If
   If M_index = 6 Then
     Eexc_mean = Edefo(2,2,Z_index)  
     RS = SIGDEFO/Sqr(R_Att_Sad(M_index))       
     Eexc_sigma = _ 
          ( Lymass(Csng(Z_index),Csng(A_index),beta(2,2,Z_index) + RS) - _
            Lymass(Csng(Z_index),Csng(A_index),beta(2,2,Z_index) ))
   End If
   Eexc_mean = Max(Eexc_mean,0.0)
   
   ' 2. Intrinsic excitation energy at scission
   If Z_index < 0.5 * Csng(P_Z_CN) Then   
     Eexc_intr = EPART(M_index,1,A_index)
   Else
     Eexc_intr = EPART(M_index,2,A_index) 
   End If  
   Eexc_intr = Max(Eexc_intr,0.0)
   Eexc_mean = Eexc_mean + Eexc_intr
   Eexc_sigma = sqr(Eexc_sigma^2 + (EexcSIGrel * Eexc_intr)^2)
   
   ' 3. Pairing staggering
   Eexc_mean = Eexc_mean - Lypair(Z_index,A_index)
   
   ' 4. Collective energy
   Eexc_coll = 0.5 * (De_Saddle_Scission(Csng(P_Z_CN)^2 / _
     Csng(I_A_CN)^0.33333E0,ESHIFTSASCI_coll) - E_tunn)
   Eexc_coll = Max(Eexc_coll,0.0)
   Eexc_sigma = sqr(Eexc_sigma^2 + 0.5*(EexcSIGrel*Eexc_coll)^2)
   Eexc_mean = Eexc_mean + Eexc_coll + 0.5 * E_coll_saddle(M_index)

   ' 5. Total excitation energy distribution of fragments (all contributions summed up)
   For I = 0 To 1000  ' 100 keV bins up to 100 MeV
     Etab(K,I) = exp(-(0.1*Csng(I)-Eexc_mean)^2/(2.0 * Eexc_sigma))
   Next
   
 ' Normalize excitation-energy distribution
   Scope
     Dim As Single RintE = 0
     For I = 1 To 1000
       RintE = RintE + Etab(K,I)
     Next   
     If RintE > 0 Then
       For I = 1 To 1000
         Etab(K,I) = Etab(K,I) / RintE
       Next  
     End If
   End Scope  
   
 Next


  End SUB



  /' Subroutines '/

/'<FO Include "BEexp.FOR" FO>'/
/'<FO Include "BEldmTF.FOR" FO>'/
/'<FO Include "ShellMO.FOR" FO>'/


   Function U_Valid(I_Z As Integer,I_A As Integer) As Ubyte
     Dim As Ubyte Ivalid
     Ivalid = 1
     If I_A / I_Z < 210.E0/90.E0 _
       Or I_A / I_Z > 250.E0/90.E0 _
       Then
       Ivalid = 0
     End If
     If I_Z < 76 Or I_Z > 120 Then
       Ivalid = 0  
     End If       
     U_Valid = Ivalid  
' U_Valid = 1
   End Function     


   Function U_Delta_S0(I_Z As Integer,I_A As Integer) As Single
   ' I_Z and I_A refer to the fissioning nucleus90 22
     Dim As Single Delta
     Delta = 0
     If I_Z = 95 And I_A = 242 Then Delta = -0.1  'T
     IF I_Z = 95 And I_A = 243 Then Delta = 0.05  'T 
     If I_Z = 95 And I_A = 244 Then Delta = -0.1
     If I_Z = 96 And I_A = 244 Then Delta = 0.1   'T
     If I_Z = 96 And I_A = 246 Then Delta = 0.0   'T
     If I_Z = 93 And I_A = 238 Then Delta = 0.15  'T
     If I_Z = 94 And I_A = 240 Then Delta = 0.05  'T
     If I_Z = 94 And I_A = 241 Then Delta = -0.3  'T
     If I_Z = 94 And I_A = 242 Then Delta = -0.15 'T
     If I_Z = 94 And I_A = 243 Then Delta = -0.45 'T
     If I_Z = 90 And I_A = 228 Then Delta = 0.70  'T
     If I_Z = 90 And I_A = 230 Then Delta = 0.85  'T
     If I_Z = 90 And I_A = 233 Then Delta = 0.2
     If I_Z = 91 And I_A = 228 Then Delta = 0.65
     If I_Z = 92 And I_A = 233 Then Delta = 0.65  'T
     If I_Z = 92 And I_A = 234 Then Delta = 0.7   'T
     If I_Z = 92 And I_A = 235 Then Delta = 0.3
     If I_Z = 92 And I_A = 236 Then Delta = 0.45  'T
     If I_Z = 92 And I_A = 237 Then Delta = 0.3
     If I_Z = 92 And I_A = 238 Then Delta = 0.3
     If I_Z = 92 And I_A = 239 Then Delta = 0.3
     U_Delta_S0 = Delta    
   End Function       


  Function Getyield(E_rel As Single,E_ref As Single,T_low As Single,T_high As Single) As Single
         /' Erel: Energy relative to the barrier '/
         /' T_low: Effective temperature below barrier '/
         /' T_high: Effective temperature above barrier '/
         Dim As Single Exp1
         Dim As Single Yield

     Exp1 = E_rel/T_low - E_ref/0.4   ' energy far below barrier
     If Exp1 < -50 Then
       Yield = 0
     Else
       Yield = Exp(E_rel / T_high - E_ref/0.4) * 1.E0 / _
          (1.E0 + exp(-E_rel/ (T_high*T_low/(T_high-T_low) ) ) )
     End If
 '   print  E_rel,T_high,E_ref,Yield
     Getyield = Yield

  End Function


    Declare Function F1(Z_S_A As Single) As Single
    Function F1(Z_S_A As Single) As Single
      /' Fit to the lower part of the data '/
      Dim As Single Result
      Result = exp(-9.05E0 + 4.58E0 * Log(Z_S_A/2.3E0))
      F1 = Result
    End Function
    Declare Function F2(Z_S_A As Single) As Single
    Function F2(Z_S_A As Single) As Single
      /' Fit to the upper part of the data '/
      Dim As Single Result
      Result = exp(12.08E0 - 3.27E0 * Log(Z_S_A/2.3E0))
      F2 = Result
    End Function

  Function Masscurv(Z As Single, A As Single, RI As Single, kappa As Single) As Single
     /'  Fit to  Data of Fig. 7 of                                             '/
     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/
     /'  S. I. Mulgin, K.-H. Schmidt, A. Grewe, S. V. Zhdanov                  '/
     /'  Nucl. Phys. A 640 (1998) 375 
     /' (From fit of the width of the mass distributions.) '/                                         '/
    Dim As Single Result1, Result2, Result 
    Dim Z_square_over_A As Single
    Dim ZsqrA As Single
    /'<FO REAL*4 F1 FO>'/
    /'<FO REAL*4 F2 FO>'/

    Z_square_over_A = Z^2/A
    ZsqrA = Z_square_over_A * (1.E0 - kappa * RI^2) / _
       (1.E0 - kappa * ((226.E0 - 2.E0*91.E0)/226.E0)^2)

    Result1 = F1(ZsqrA)
    Result2 = F2(ZsqrA)
    Result = Min(Result1,Result2)
    Masscurv = Result
  
  End Function

  Function Masscurv1(Z As Single, A As Single, RI As Single, kappa As Single) As Single
     /'  Fit to  Data of Fig. 7 of                                             '/
     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/
     /'  S. I. Mulgin, K.-H. Schmidt, A. Grewe, S. V. Zhdanov                  '/
     /'  Nucl. Phys. A 640 (1998) 375 
     /' (The left part assumed to be valid for the yields of the fission channels.) '/                                         '/
    Dim As Single Result1, Result2, Result 
    Dim Z_square_over_A As Single
    Dim ZsqrA As Single
    /'<FO REAL*4 F1 FO>'/
    /'<FO REAL*4 F2 FO>'/

    Z_square_over_A = Z^2/A
    ZsqrA = Z_square_over_A * (1.E0 - kappa * RI^2) / _
       (1.E0 - kappa * ((226.E0 - 2.E0*91.E0)/226.E0)^2)

    Result1 = F1(ZsqrA)
  '  Result2 = F2(ZsqrA)
  '  Result = Min(Result1,Result2)
    Masscurv1 = Result1
  
  End Function


  Function De_Saddle_Scission(Z_square_over_Athird As Single, _
       ESHIFTSASCI As Single) As Single
    /' Energy release between saddle and scission '/
    /' M. Asghar, R. W. Hasse, J. Physique C 6 (1984) 455 '/
    Dim As Single Result
    Result = (31.E0 - 11.E0) / (1550.E0 - 1300.E0) * _
             (Z_square_over_Athird - 1300.E0 + ESHIFTSASCI) + 11.E0
       ' This formula with ESHIFTSASCI = 0 is the parameterisation of the results
       ' of Ashgar and Hasse, JPC 6 (1984) 455, see 
       ' F. Rejmund, A. V. Ignatyuk, A. R. Junghans, K.-H. Schmidt
       ' Nucl. Phys. A 678 (2000) 215     
    Result = max(Result,0.0)
    De_Saddle_Scission = Result
  End Function


  Function TEgidy(A As Single,DU As Single,Fred As Single) As Single
    /' Temperature parameter of the constant-temperature formula for the
       nuclear level density.
       Input parameters: A = Mass number of nucleus
                         DU = Shell effect (corrected for pairing:P=0 for odd-A nuclei)
       From "Correlations between the nuclear level density parameters"
         Dorel Bucurescu, Till von Egidy
         Phys. Rev. C 72 (2005) 067304    and
            "Systematics of nuclear level density parameters"
         Dorel Bucurescu, Till von Egidy
         J. Phys. G: Nucl. Part. Phys. 31 (2005) S1675 and
            "Systematics of nuclear level density parameters"
         Till von Egidy, Dorel Bucurescu
         Phys. Rev. C 72 (2005) 044311 '/
    Dim As Single Temp_smooth,Temp,T_Fac
  ' Temp_smooth = 17.45E0 / (A^0.666667E0)   
  ' Temp = (17.45E0 - 0.51E0 * DU + 0.051 * DU^2) / (A^0.666667E0)
    Temp_smooth = 1.0 / (0.0570 * A^0.6666667)
    Temp = 1.0 / ( (0.0570 + 0.00193*DU) * A^0.6666667)  ' from  PRC 80 (2009) 054310 
    T_Fac = Temp / Temp_smooth
    Temp = Temp * Fred  /' (For influence of deformation) '/
    TEgidy = Temp
  End Function


  Function TRusanov(E As Single, A As Single) As Single
     /' Fermi-gas level density, parameterisation of Rusanov et al. '/
     If E >0 Then 
       TRusanov = sqr(E / (0.094E0 * A) )
     Else
       TRusanov = 0.0
     End If   
  End Function

  Function LyMass(Z As Single,A As Single,beta As Single) As Single

     /' liquid-drop mass, Myers & Swiatecki, Lysekil, 1967  '/
     /' pure liquid drop, without pairing and shell effects '/

     /' On input:    Z     nuclear charge of nucleus        '/
     /'              N     number of neutrons in nucleus    '/
     /'              beta  deformation of nucleus           '/
     /' On output:   binding energy of nucleus              '/
 
     /'<FO Const As Single pi = 3.14159 FO>'/
     Dim As Single N
     Dim As Single alpha
     Dim As Single XCOM,XVS,XE,EL

     N = A - Z
     alpha = sqr(5.E0/(4.E0*pi)) * beta
     XCOM = 1.E0 - 1.7826E0 * ((A - 2.E0*Z)/A)^2
            /' factor for asymmetry dependence of surface and volume term '/
     XVS = - XCOM * (15.4941E0*A _
                   - 17.9439E0*A^(2.E0/3.E0)*(1.E0+0.4E0*Alpha^2))
            /' sum of volume and surface energy '/
     XE = Z^2 * (0.7053E0/A^(1.E0/3.E0)*(1.E0-0.2E0*Alpha^2) _
                  - 1.1529E0/A)
     EL = XVS + XE
  /'   EL = EL + LyPair(Z,A); '/
     LyMass = EL
   END Function


   Function LyPair(Z As Integer,A As Integer) As Single
     /' Calculates pairing energy '/
     /' odd-odd nucleus:   Lypair = 0 '/
     /' even-odd nucleus:  Lypair = -12/sqr(A) '/
     /' even-even nucleus: Lypair = -2*12/sqr(A) '/
    Dim As Single E_PAIR

     E_PAIR = - 12.E0 / sqr(Csng(A)) _
          * ( (Z+1) Mod 2 + (A-Z+1) Mod 2)

     Lypair = E_PAIR
   END Function


   Function TFPair(Z As Integer,A As Integer) As Single
     /' Pairing energy from Thomas-Fermi model of Myers and Swiatecki '/
     /' Shifted that TFPair is zero for odd-odd nuclei '/
     Dim As Integer N
     Dim As Single E_Pair
     N = A - Z
     IF Z Mod 2 = 0 And N Mod 2 = 0 Then /' even-even '/
        E_Pair = - 4.8E0 / Z^0.333333E0 - 4.8E0 / N^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 0 And N Mod 2 = 1 Then /' even Z, odd N '/
        E_Pair = - 4.8E0 / Z^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 1 And N Mod 2 = 0 Then /' odd Z, even N '/
        E_Pair = - 4.8E0 / N^0.333333E0 + 6.6E0 / A^0.666666E0
     EndIf
     If Z Mod 2 = 1 And N Mod 2 = 1 Then /' odd N, odd N '/
        E_Pair = 0.0
     EndIf
     TFPair = E_Pair
   End Function


   Function Pmass(Z As Single,A As Single,beta As Single) As Single
    /' Liquid-drop model of Pearson, 2001 '/
     Dim As Single N,EA,BE
     Dim As Single avol = -15.65
     Dim As Single asf = 17.63
     Dim As Single r0 = 1.233
     Dim As Single asym = 27.72
     Dim As Single ass = -25.60
     Dim As Single alpha
     /'<FO Const As Single pi = 3.14159 FO>'/     

      N = A - Z
      alpha = sqr(5.E0/(4.E0*pi)) * beta
      EA = avol + asf * A^(-0.333333)*(1.E0+0.4E0*Alpha^2) _
           + 0.6E0 * 1.44E0 * Z^2 / (A^1.333333 * r0 )*(1.E0-0.2E0*Alpha^2) _
           + (asym + ass * A^(-0.333333)) * (N-Z)^2 / A^2
      BE = EA * A
      Pmass = BE
   End Function


   Function FEDEFOP(Z As Single,A As Single,beta As Single) As Single
     /' According to liquid-drop model of Pearson 2001 '/
      Dim As Single asf = 17.63
      Dim As Single r0 = 1.233
      Dim As Single N,Alpha
     /'<FO Const As Single pi = 3.14159 FO>'/      

      N = A - Z
      alpha = sqr(5.E0/(4.E0*pi)) * beta
      FEDEFOP = asf * A^(0.666667)*(0.4E0*Alpha^2) _
              - 0.6E0 * 1.44E0 * Z^2 / (A^0.333333 * r0 )*(0.2E0*Alpha^2)
   End Function

   
   Function FEDEFOLys(Z As Single,A As Single,beta As Single) As Single
       /'<FO REAL*4 LYMASS FO>'/
       FEDEFOLys = Lymass(Z,A,beta) - Lymass(Z,A,0.0)
   End Function


   Function LDMass(Z As Single,A As Single,beta As Single) As Single
     Dim As Single N,BEtab
     /'<FO REAL*4 LYMASS FO>'/
     /'<FO REAL*4 FEDEFOLYS FO>'/
     /'<FO REAL*4 BEldmTF FO>'/
     /'<FO REAL*4 BEexp FO>'/
       N = A - Z
       BEtab = BEldmTF(CInt(N),CInt(Z)) + 2.0 * 12.0 / sqr(Csng(A)) _
                        - 0.00001433*Z^2.39
           ' The values in BEtab are the negative binding energies! 
           ' Pairing in Thomas Fermi masses is zero for Z,N even !        
       If BEtab = 0.0 Then
         BEtab = Lymass(Z,A,0.0) 
         Print "Warning: Binding energy of Z=";Z;", A=";A;" not in mass table,"; _
                        " replaced by LYMASS"
         Print "I_Mode = ";I_Mode               
       End If
       LDMASS = BEtab + FEDEFOLys(Z,A,beta)
   End Function

   Function AME2012(IZ As Integer,IA As Integer) As Single
      ' Masses from the 2003 mass evaluation, complemented by TF masses
      ' and Lysekil masses.
      Dim As Single BEexpval
      Dim As Single Z,A,N
      Dim As Integer INeu
      /'<FO REAL*4 LYPAIR FO>'/
      /'<FO REAL*4 U_SHELL FO>'/
      /'<FO REAL*4 LDMASS FO>'/
      /'<FO REAL*4 BEexp FO>'/
      INeu = IA - IZ
      A = Csng(IA)
      Z = Csng(IZ)
      N = A - Z
      BEexpval = BEexp(INeu,IZ) 
      If BEexpval > -1.E10 Then
        AME2012 = BEexpval
      Else
        AME2012 = Ldmass(Z,A,0.0) + U_SHELL(IZ,IA) + Lypair(IZ,IA)
      End If  
   End Function

   Function U_SHELL(Z As Integer,A As Integer) As Single
      Dim As Integer N
      Dim As Single Res
      /'<FO REAL*4 ShellMO FO>'/
      N = A - Z
      Res = ShellMO(N,Z)  
      If Res > 0.0 Then Res = 0.3 * Res     ' KHS (12. Feb. 2012)
     '      ' The positive shell effects for deformed nuclei seem to be too positive
            ' This gives too many high-energetic prompt neutrons.
     U_SHELL = Res
   End Function

   Function U_SHELL_exp(IZ As Integer, IA As Integer) As Single
      Dim Res As Single
      Dim As Single Z,A
      /'<FO REAL*4 LDMASS FO>'/
      /'<FO REAL*4 LYPAIR FO>'/
      /'<FO REAL*4 AME2012 FO>'/
      Z = Csng(IZ)
      A = Csng(IA)
   '   Res = 2.0 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) ) _
   '          - 0.25 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,A+1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - LDMass(Z+1.0,A+1.0,0.0) ) _
   '          - 0.25 * ( AME2012(IZ-1,IA-1) - Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) )
      Res = 0.5 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) ) _
             + 0.125 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,A+1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - LDMass(Z+1.0,A+1.0,0.0) ) _
             + 0.125 * ( AME2012(IZ-1,IA-1) - Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) )
      U_SHELL_exp = Res             
   End Function


   Function U_MASS(Z As Single,A As Single) As Single
     /' LD + congruence energy + shell (no pairing) '/
     Dim As Single BE
     /'<FO REAL*4 U_SHELL FO>'/
     /'<FO REAL*4 LDMASS FO>'/
     If Z < 0 Or A < 0 Then
       Print "U_Mass: Z, A",Z,A
     End If
     BE = Ldmass(Z,A,0.0)  + U_SHELL(CInt(Z),CInt(A))
  '    BE = AME2012(Cint(Z),Cint(A)) - Lypair(Z,A)
  '    BE = Lymass(Z,A,0.0) + U_Shell(CInt(Z),CInt(A))     
  '    BE = Lymass(Z,A,0.0)  
     U_MASS = BE
   End Function


   Function ECOUL(Z1 As Single,A1 As Single,beta1 As Single,Z2 As Single,A2 As Single, _
                     beta2 As Single,d As Single) _
                     As Single

      /' Coulomb potential between two nuclei                    '/
      /' surfaces are in a distance of d                         '/
      /' in a tip to tip configuration                           '/

      /' approximate formulation                                 '/
      /' On input: Z1      nuclear charge of first nucleus       '/
      /'           A1      mass number of irst nucleus   '/
      /'           beta1   deformation of first nucleus          '/
      /'           Z2      nuclear charge of second nucleus      '/
      /'           A2      mass number of second nucleus  '/
      /'           beta2   deformation of second nucleus         '/
      /'           d       distance of surfaces of the nuclei    '/

       Dim As Single N1,N2,recoul
       Dim As Single dtot
       Dim As Single r0 = 1.16

      N1 = A1 - Z1
      N2 = A2 - Z2
      dtot = r0 *( (Z1+N1)^0.3333333E0 * (1.E0+0.6666667E0*beta1) _
             + (Z2+N2)^0.3333333E0 * (1.E0+0.6666667E0*beta2) ) _
             + d
      REcoul = Z1 * Z2 * 1.44E0 / dtot

      ECOUL = REcoul
   END Function


   Function beta_light(Z As Integer,betaL0 As Single,betaL1 As Single) As Single
      /' Deformation of light fission fragment for S1 and S2 '/
      /' Systematic correlation Z vs. beta for deformed shells '/
      /' Z of fission fragment '/
     Dim As Single beta
     beta = (Z - betaL0) * betaL1/20.E0 
     beta_light = beta
   End Function


   Function beta_heavy(Z As Integer,betaH0 As Single,betaH1 As Single) As Single
      /' Deformation of heavy fission fragment for S2 '/
      /' Systematic correlation Z vs. beta for deformed shells '/
      /' Z of fission fragment '/
     Dim As Single beta
     beta = (Z - betaH0) * betaH1/20.E0 
     beta_heavy = beta
   End Function



   Function Z_equi(ZCN As Integer,A1 As Integer,A2 As Integer, _
           beta1 As Single,beta2 As Single,d As Single,Imode As Integer, _
           POLARadd As Single, POLARfac As Single) _
           As Single
    /' Determines the minimum potential of the scission-point configuration
       represented by two deformed nuclei divided by a tip distance d.
       A1, A2, beta1, beta2, d are fixed, Z1 is searched for and returned on output.  '/

       /' ZCN: Z of fissioning nucleus '/
       /' A1: A of first fission fragment '/
       /' A2: A of second fission fragment '/
       /' beta1: deformation of first fission fragment '/
       /' beta2: deformation of second fission fragment '/
       /' d: tip distance '/

             Dim As Single RZ_equi
             Dim As Single RA1,RA2,RZCN,RACN
             Dim As Single Z1UCD,Z2UCD
             Dim As Single re1,re2,re3,eps1,eps2,DZ_Pol /' help variables '/
             /'<FO REAL*4 ECOUL FO>'/
             /'<FO REAL*4 LYMASS FO>'/

          RA1 = Csng(A1)
          RA2 = Csng(A2)
          RZCN = Csng(ZCN)       
          RACN = RA1 + RA2
          Z1UCD = RA1 / (RA1 + RA2) * RZCN
          Z2UCD = RZCN - Z1UCD
          re1 = LyMass( Z1UCD-1.E0, RA1, beta1 ) + _
                LyMass( Z2UCD+1.E0, RA2, beta2 ) + _
                ECoul( Z1UCD-1.E0, RA1, beta1, _
                       Z2UCD+1.E0, RA2, beta2, d )
          re2 = LyMass( Z1UCD, RA1, beta1) + _
                LyMass( Z2UCD, RA2, beta2) + _
                ECoul( Z1UCD, RA1, beta1, _
                       Z2UCD, RA2, beta2, d )
          re3 = LyMass( Z1UCD+1.E0, RA1, beta1 ) + _
                LyMass( Z2UCD-1.E0, RA2, beta2 ) + _
                ECoul( Z1UCD+1.E0, RA1, beta1, _
                       Z2UCD-1.E0, RA2, beta2, d )
          eps2 = ( re1 - 2.E0*re2 + re3 ) / 2.E0
          eps1 = ( re3 - re1 ) / 2.E0
          DZ_Pol = -eps1 / ( 2.E0 * eps2 )
          
          If DZ_Pol > 2 Or DZ_Pol < -2 Then DZ_Pol = 0

          If Imode > 0 Then
            /' Purely empirical enhancement of charge polarization '/
            DZ_POL = DZ_POL * POLARfac + POLARadd   
          End If           

          RZ_equi = Z1UCD + DZ_POL   
          Z_equi = RZ_equi
   End Function


   Sub Beta_opt_light(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single, _
             d As Single,beta2_imposed As Single,ByRef beta1_opt As Single)
    /' Determines the optimum deformation of the light fragment when the deformation of the
       heavy fragment is imposed. '/

       Dim As Single beta1,dbeta1,beta1_prev,beta1_next
       Dim As Single Uguess,Uplus,Uminus,Uprev,Unext
       Dim As Integer I
       /'<FO REAL*4 ECOUL FO>'/
       /'<FO REAL*4 LYMASS FO>'/

    /' List('Beta_opt_light called with ');
       List(A1,A2,Z1,Z2,d,beta2_imposed,beta1_opt);
      DCL Byes Bit(1) aligned;
       Call GPYES('Continue',Byes); '/
       beta1 = 0.5
       dbeta1 = 0.01
       Uguess = LyMass(Z1, A1, beta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1, Z2, A2, beta2_imposed, d)
       Uplus  = LyMass(Z1, A1, beta1 + dbeta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1 + dbeta1, Z2, A2, beta2_imposed, d)
       Uminus = LyMass(Z1, A1, beta1 - dbeta1) + _
                Lymass(Z2, A2, beta2_imposed) + _
                ECoul(Z1, A1, beta1 - dbeta1, Z2, A2, beta2_imposed, d)
       If Uplus > Uguess And Uminus > Uguess then
         beta1_opt = beta1
       Else
         If Uplus < Uguess then dbeta1 = 0.01
         If Uminus < Uguess then dbeta1 = -0.01
         Unext = Uguess
         beta1_next = beta1
         For I = 1 to 10000
           beta1_prev = beta1_next
           Uprev = Unext
           beta1_next = beta1_prev + dbeta1
           Unext = LyMass(Z1, A1, beta1_next) + _
                   Lymass(Z2, A2, beta2_imposed) + _
                   ECoul(Z1, A1, beta1_next, Z2, A2, beta2_imposed, d)
           If Unext >= Uprev Then Exit For
         Next
         beta1_opt = beta1_prev
       EndIf

   End Sub


   Sub Beta_Equi(A1 As Single,A2 As Single,Z1 As Single,Z2 As Single,d As Single, _
                  beta1prev As Single,beta2prev As Single, _
                  ByRef beta1opt As Single,ByRef beta2opt As Single)
    /' Determines the minimum potential of the scission-point configuration
       represented by two deformed nuclei, divided by a tip distance d.
       A1, A2, Z1, Z2, d are fixed, beta1 and beta2 are searched for and returned on output '/

       Dim As Single beta1,beta2
       
 '      Dim As Double U,Uprev,Ulast,Ubest,Uopt
       Dim As Single U,Uprev,Ulast,Ubest,Uopt

 '      Dim As Double sbeta1,sbeta2
       Dim As Single sbeta1,sbeta2

       Dim As Integer N,N1,N2,Nopt

 '      Dim As Double eps = 5.E-4
       Dim As Single eps = 5.E-4

       Dim As Integer I
       /'<FO REAL*4 LYMASS FO>'/       
       /'<FO REAL*4 ECOUL FO>'/       

       beta1 = beta1prev
       beta2 = beta2prev
       Uprev = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
       Uopt = Uprev

       /' Test slope of variation of U '/
       beta1 = beta1prev + eps
       U = 1.E30

       beta2 = beta2prev
 '     For beta2 = beta2prev to 0 Step -eps
       For I = 1 To Int(beta2prev/eps)
         beta2 = beta2 - eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
           Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = eps
         sbeta2 = -eps
       EndIf

       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 1 Step eps
       For I = 1 To Int((1 - beta2prev)/eps)
         beta2 = beta2 + eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = eps
         sbeta2 = eps
       End If

       beta1 = beta1prev - eps
       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 0 Step -eps
       For I = 1 To Int(beta2prev/eps)
         beta2 = beta2 - eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
            Ubest = U
         End If
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = -eps
         sbeta2 = -eps
       EndIf

       U = 1.E30
       beta2 = beta2prev
   '   For beta2 = beta2prev To 1 Step eps
       For I = 1 To Int((1-beta2prev)/eps)
         beta2 = beta2 + eps
         Ulast = U
         U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
         If U > Ulast Then
            Exit For
         Else
           Ubest = U
         EndIf
       Next
       If Ubest < Uopt Then
         Uopt = Ubest
         sbeta1 = -eps
         sbeta2 = eps
       EndIf


      Ubest = Lymass(Z1,A1,beta1prev) + Lymass(Z2,A2,beta2prev) _
             + ECoul(Z1,A1,beta1prev,Z2,A2,beta2prev,d)
      U = Lymass(Z1,A1,beta1prev+Csng(sbeta1)) + _
          Lymass(Z2,A2,beta2prev+Csng(sbeta2)) + _
          ECoul(Z1,A1,beta1prev+sbeta1,Z2,A2,beta2prev+Csng(sbeta2),d)

'   L1:
       For N = 1 To 1000

'   L2:
         For N1 = 1 To N
           N2 = N-N1
           beta1 = beta1prev + sbeta1*N1
           beta2 = beta2prev + sbeta2*N2
           U = LyMass(Z1,A1,beta1) + _
               LyMass(Z2,A2,beta2) + _
               ECoul(Z1,A1,beta1,Z2,A2,beta2,d)
           If U < Ubest Then
             Ubest = U
             beta1opt = beta1
             beta2opt = beta2
             Nopt = N
           EndIf
         Next
         If N-Nopt > 2 Then Exit For
       Next


   End Sub

  Function U_Ired(Z As Single,A As Single) As Single
    ' Effective moment of inertia by pairing and shell effect
      Dim As Single I_rigid_spher,IfragEff
      /'<FO REAL*4 U_SHELL FO>'/
      
      I_rigid_spher = 1.16E0^2 * A^1.6667E0 / 103.8415E0 
      IfragEff = I_rigid_spher + 0.003 * A^(4.0/3.0) * U_shell(Cint(Z),Cint(A))
                      ' reduction due to shell (Deleplanque et al. PRC 69 (2004) 044309)
      IfragEff = 0.45 * IfragEff  ' Effect of superfluidity 
    '  IfragEff = 0.65 * IfragEff   ' Average effect of superfluidity and deformation 
      U_Ired = IfragEff      
   End Function

   Function U_alev(Z As Single, A As Single) As Single
    '  U_alev = 0.073 * A + 0.095 * A^0.666667  'Ignatyuk (1970's)
       U_alev = 0.078 * A + 0.115 * A^0.6666667  ' Ignatyuk (Bologna 2000) 
    '  U_alev = 0.089 * A    ' only volume term
   End Function
    
   Function U_Temp(Z As Single, A As Single, E As Single, Ishell As Integer, _
           Ipair As Integer, Tscale As Single,Econd As Single) As Single
       ' Temperature (modified Gilbert-Cameron composite level density)    
       ' KHS (10. 2. 2012)       
       Dim As Single alev  
       Dim As Single Eeff0,Eeff1,Rho0,Rho1,TCT,TFG 
       Static As Single fgamma = 0.055      
       Dim As Single RShell,RPair,Res
       /'<FO REAL*4 U_ALEV FO>'/
       /'<FO REAL*4 U_SHELL FO>'/
       /'<FO REAL*4 LYPAIR FO>'/
       /'<FO REAL*4 TEGIDY FO>'/ 
       ' Used global parameters: Tscale
    '  alev = U_alev(Z,A) * 1.1   ' Factor adjusted to high-energy prompt neutrons in U235(nth,f)
    '  alev = U_alev(Z,A) * 0.86  ' " with the correction for non-constant T (FG range)
       alev = U_alev(Z,A)
       
       If Ishell = 1 Then
         RShell = U_Shell(Cint(Z),Cint(A))
       Else
         RShell = 0.0
       End If    
       TCT = TEgidy(A,RShell,Tscale)  
       
       If Ipair = 1 Then
         RPair = Lypair(CInt(Z),CInt(A))
       Else
         Rpair = 0.0
       End If    
       Eeff0 = E - Econd + RPair + Rshell*(1.0 - exp(-fgamma * E))
       
       If Eeff0 > 0.5 Then
         Eeff1 = Eeff0 + 0.1
         Rho0 = 1.E0/Eeff0^1.25 * exp(2.E0 * sqr(alev * Eeff0))
         Rho1 = 1.E0/Eeff1^1.25 * exp(2.E0 * sqr(alev * Eeff1))
'         Rho0 = 1.E0/Eeff0 * exp(2.E0 * sqr(alev * Eeff0))
'         Rho1 = 1.E0/Eeff1 * exp(2.E0 * sqr(alev * Eeff1))
         TFG = 0.1E0 / (log(Rho1) - log(Rho0))
       Else 
         TFG = 0.0
       End If
       Res = TCT
       If TFG > Res Then Res = TFG

' If Res > 1.4 Then Res = 1.4

       U_Temp = Res
   End Function

 Function U_Even_Odd(I_Channel As Integer,PEO As Single) As Single
   ' Creates even-odd fluctuations 
   Dim As Single R
   If I_Channel Mod 2 = 0 Then
     R = 1.0 + PEO
   Else
     R = 1.0 - PEO
   End If
   U_Even_Odd = R   
 End Function
 

   Function BFTF(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' Fission barriers from Myers and Swiatecki, Thomas-Fermi model '/
    /'  I_Switch: 0: liquid-drop; 1: with shells '/
      Dim As Single RN,RI,Rkappa,RS,RF,RX
      Dim As Single RX0 = 48.5428
      Dim As Single RX1 = 34.15
      Dim As Single RB 
     /'<FO REAL*4 U_SHELL FO>'/
     /'<FO REAL*4 U_SHELL_EXP FO>'/
     
     RN = RA - RZ
     RI = (RN-RZ) / RA
     Rkappa = 1.9E0 + (RZ - 80.E0) / 75.E0
     RS = RA^0.666667E0 * (1.E0 - Rkappa * RI^2)
     RX = RZ^2 / (RA * (1.E0 - Rkappa * RI^2))
     If RX < 30 Then   /' out of range '/
       RF = 1.E10
     End If
     If RX > RX0 Then  /' out of range '/
       RF = 0.0
     End If
     If RX < RX1 And RX > 30 Then 
       RF = 0.595553E0 - 0.124136E0 * (RX - RX1)
     End If
     If RX >= RX1 And RX <= RX0 Then 
       RF = 0.000199749 * (RX0 - RX)^3
     End If
     RB = RF * RS

     If I_Switch = 0 Then 
       BFTF = RB
     Else 
      ' Tentative modification from comparison with experimental fission barriers
      ' (shell correction at the barrier?)
       If RZ > 86.5 Then RB = RB - 0.15 * (RZ - 86.5)
       If RZ > 90 Then RB = RB + 0.3 * (RZ - 90.0)
       If RZ > 98 Then RB = RB - 0.15 * (RZ - 98.0) 
          
   '    BFTF = RB - U_Shell(Cint(RZ),Cint(RA))
       BFTF = RB - U_Shell_exp(Cint(RZ),Cint(RA))
     End If
   End Function

   Function BFTFA(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' inner barrier height '/
     Dim As Single EA,BF0,Z4A,Z3A,DB 
     Dim As Single coeff = 0.5
     /'<FO REAL*4 BFTF FO>'/
     BF0 = BFTF(RZ,RA,I_Switch)
   ' Z4A = RZ^4 / RA
     '  EB - EA from fit to Smirenkin barriers:
     '  V. M. Kupriyanov, K. K. Istekov, B. I. Fursov, G. N. Smirenkin
     '  Sov. J. Nucl. Phys. 32 (1980) 184
   '  DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB
   
     '  EB - EA from fit to data from Dahlinger et al. (KHS, 21. Dec. 2012)
     Z3A = RZ^3 / RA
     DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A^2)
     If DB > 0.0 Then
       EA = BF0 - DB
     Else
       EA = BF0 
     End If 
     BFTFA = EA
   End Function

   Function BFTFB(RZ As Single,RA As Single,I_Switch As Integer) As Single
    /' outer barrier height '/
     Dim As Single EB,BF0,Z4A,Z3A,DB 
     Dim As Single coeff = 0.5
     /'<FO REAL*4 BFTF FO>'/
     BF0 = BFTF(RZ,RA,I_Switch)
   ' Z4A = RZ^4 / RA
     '  EB - EA from fit to Smirenkin barriers:
     '  V. M. Kupriyanov, K. K. Istekov, B. I. Fursov, G. N. Smirenkin
     '  Sov. J. Nucl. Phys. 32 (1980) 184
  '   DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB
  
     '  EB - EA from fit to data from Dahlinger et al. (KHS, 21. Dec. 2012)
     Z3A = RZ^3 / RA
     DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A^2)  
     If DB < 0.0 Then
       EB = BF0 + DB
     Else
       EB = BF0 
     End If 
     BFTFB = EB
   End Function
   


   /' Utility functions '/


   Function Gaussintegral(R_x As Single,R_sigma As Single) As Single
     /' Smoothed step function. Grows from 0 to 1 around R_x
        with a Gauss-integral function with given sigma'/
     Dim As Single R_ret
     ' Note: The variable R_sigma = standard deviation / sqr(2) !
     /'<FO REAL*4 ERF FO>'/
       R_ret = 0.5E0 + 0.5E0 * Erf(R_x / R_sigma)
       Gaussintegral = R_ret
   End Function

   Function U_Box(x As Single,sigma As Single, _
         length As Single) As Single
     Dim As Single y
     ' Note: The variable sigma = standard deviation / sqr(2) !
     /'<FO REAL*4 GAUSSINTEGRAL FO>'/      
     y = Gaussintegral(x+0.5*length,sigma) - Gaussintegral(x-0.5*length,sigma)
     U_Box = y/length
   End Function
   
   Function U_Gauss(x As Single,sigma As Single) As Single
     Dim As Single y
     /'<FO Const As Single pi = 3.14159 FO>'/      
     
     y = 1.0 / (sqr(2.0 * pi) * sigma) * exp(-x^2/ ( 2.0 * sigma^2 ) )
     U_Gauss = y
   End Function  

Public Function U_LinGauss(x As Single, R_Sigma As Single) As Single
  /' Gaussian times a linear function '/
  /' Not normalized! '/
  Dim As Single R_Res
  If R_Sigma > 0.0 Then
    R_Res = x * exp(-x^2/(2.0 * R_Sigma^2))
  Else
    R_Res = 0.0
  End If    
  U_LinGauss = R_Res
End Function
