' Developed for the GEF code (KHS, 29. 5. 2012)

'Dim BEexp(0 To 203, 0 To 136) As Single  (Declared in GEF.BAS.)

Scope
  Dim As Integer Z,A
  Dim As Integer I,J
  Restore BEexpdata
  For I = 0 To 203
    For J = 0 To 136
      BEexp(I,J) = -1.E11
    Next
  Next    
  For I = 1 To 2247
    Read Z,A
    Read BEexp(A-Z,Z)
   '  Print Z,A, BEexptab(A-Z,Z)
  Next
End Scope
  

BEexpdata:

' This table was produced from the 2003 Mass evaluation.
' It contains only experimental masses, no systematic estimations.
' See kh/Dokumente/Literature/Full-Text-Special/Masses-2003/MakeTable.jbas.

Data 0, 1, 0, _
1, 1, 0, _
1, 2, -2.224566, _
1, 3, -8.4817987, _
2, 3, -7.7180433, _
1, 4, -5.6029218, _
2, 4, -28.2956596, _
3, 4, -4.6182286, _
1, 5, -6.6842389, _
2, 5, -27.4018923, _
3, 5, -26.3295457, _
1, 6, -5.785556, _
2, 6, -29.2681094, _
3, 6, -31.9940698, _
4, 6, -26.9235162, _
2, 7, -28.8335265, _
3, 7, -39.2440399, _
4, 7, -37.5998033, _
5, 7, -24.7174867, _
2, 8, -31.4078436, _
3, 8, -41.276657, _
4, 8, -56.4994804, _
5, 8, -37.7373038, _
6, 8, -24.7824572, _
2, 9, -30.1381607, _
3, 9, -45.3405141, _
4, 9, -58.1648675, _
5, 9, -56.3144209, _
6, 9, -39.0372743, _
2, 10, -30.3384778, _
3, 10, -45.3151312, _
4, 10, -64.9770846, _
5, 10, -64.750738, _
6, 10, -60.3203914, _
7, 10, -36.4367448, _
3, 11, -45.6404483, _
4, 11, -65.4811017, _
5, 11, -76.2048551, _
6, 11, -73.4401085, _
7, 11, -59.0080619, _
4, 12, -68.6494188, _
5, 12, -79.5751722, _
7, 12, -74.041279, _
8, 12, -58.5490324, _
4, 13, -68.5477359, _
5, 13, -84.4531893, _
6, 13, -97.1080314, _
7, 13, -94.1052161, _
8, 13, -75.5563495, _
4, 14, -69.919053, _
5, 14, -85.4227064, _
6, 14, -105.284467, _
7, 14, -104.658596, _
8, 14, -98.7323066, _
5, 15, -88.1860235, _
6, 15, -106.502577, _
7, 15, -115.491892, _
8, 15, -111.955384, _
9, 15, -97.2486371, _
5, 16, -88.1493406, _
6, 16, -110.752994, _
7, 16, -117.980947, _
8, 16, -127.619302, _
9, 16, -111.419954, _
10, 16, -97.3216076, _
5, 17, -89.5306577, _
6, 17, -111.479311, _
7, 17, -123.864964, _
8, 17, -131.762428, _
9, 17, -128.219571, _
10, 17, -112.927925, _
6, 18, -115.659628, _
7, 18, -126.693282, _
8, 18, -139.806435, _
9, 18, -137.368888, _
10, 18, -132.143072, _
11, 18, -112.487895, _
6, 19, -116.240945, _
7, 19, -132.016599, _
8, 19, -143.761352, _
9, 19, -147.801296, _
10, 19, -143.780119, _
11, 19, -131.822212, _
12, 19, -110.926866, _
6, 20, -119.172262, _
7, 20, -134.179916, _
8, 20, -151.370069, _
9, 20, -154.402623, _
10, 20, -160.644807, _
11, 20, -145.972529, _
12, 20, -134.468183, _
7, 21, -138.771233, _
8, 21, -155.175886, _
9, 21, -162.50414, _
10, 21, -167.405973, _
11, 21, -163.076046, _
12, 21, -149.1985, _
7, 22, -140.05255, _
8, 22, -162.030203, _
9, 22, -167.734857, _
10, 22, -177.770225, _
11, 22, -174.145564, _
12, 22, -168.577817, _
8, 23, -164.771521, _
9, 23, -175.269174, _
10, 23, -182.970877, _
11, 23, -186.564334, _
12, 23, -181.725934, _
13, 23, -168.699788, _
8, 24, -168.382838, _
9, 24, -179.110491, _
10, 24, -191.839644, _
11, 24, -193.523908, _
12, 24, -198.257018, _
13, 24, -183.598005, _
14, 24, -172.003758, _
9, 25, -183.471808, _
10, 25, -196.067462, _
11, 25, -202.534915, _
12, 25, -205.587598, _
13, 25, -200.528622, _
14, 25, -187.006075, _
9, 26, -184.543125, _
10, 26, -201.600779, _
11, 26, -208.110432, _
12, 26, -216.680667, _
13, 26, -211.894049, _
14, 26, -206.046392, _
9, 27, -185.954442, _
10, 27, -203.032096, _
11, 27, -214.836749, _
12, 27, -223.124053, _
13, 27, -224.951716, _
14, 27, -219.357009, _
15, 27, -206.907363, _
10, 28, -206.933413, _
11, 28, -218.380066, _
12, 28, -231.62732, _
13, 28, -232.676813, _
14, 28, -236.536823, _
15, 28, -221.42068, _
16, 28, -209.409333, _
10, 29, -208.18473, _
11, 29, -222.797383, _
12, 29, -235.299037, _
13, 29, -242.11299, _
14, 29, -245.010389, _
15, 29, -239.285597, _
16, 29, -224.71065, _
10, 30, -211.216047, _
11, 30, -225.1727, _
12, 30, -241.662354, _
13, 30, -247.841007, _
14, 30, -255.619589, _
15, 30, -250.604914, _
16, 30, -243.684967, _
11, 31, -228.955018, _
12, 31, -244.039671, _
13, 31, -254.994324, _
14, 31, -262.206988, _
15, 31, -262.916511, _
16, 31, -256.737885, _
17, 31, -243.980938, _
11, 32, -230.616335, _
12, 32, -249.848988, _
13, 32, -259.171641, _
14, 32, -271.410205, _
15, 32, -270.852168, _
16, 32, -271.780302, _
17, 32, -258.312255, _
18, 32, -246.400108, _
11, 33, -232.857652, _
12, 33, -252.071305, _
13, 33, -264.712959, _
14, 33, -275.893612, _
15, 33, -280.955765, _
16, 33, -280.421909, _
17, 33, -274.056972, _
18, 33, -261.655326, _
12, 34, -256.226622, _
13, 34, -267.184276, _
14, 34, -283.428929, _
15, 34, -287.247582, _
16, 34, -291.839026, _
17, 34, -285.564669, _
18, 34, -278.719743, _
13, 35, -272.455593, _
14, 35, -285.903246, _
15, 35, -295.6186, _
16, 35, -298.824913, _
17, 35, -298.209746, _
18, 35, -291.46126, _
19, 35, -278.800513, _
13, 36, -274.61691, _
14, 36, -292.094563, _
15, 36, -299.083217, _
16, 36, -308.71394, _
17, 36, -306.789383, _
18, 36, -306.716717, _
19, 36, -293.12883, _
20, 36, -281.360484, _
13, 37, -278.518227, _
14, 37, -294.26588, _
15, 37, -305.893534, _
16, 37, -313.017547, _
17, 37, -317.100371, _
18, 37, -315.504154, _
19, 37, -308.574347, _
20, 37, -296.153801, _
13, 38, -280.489544, _
14, 38, -299.827197, _
15, 38, -309.734851, _
16, 38, -321.053504, _
17, 38, -323.208258, _
18, 38, -327.342411, _
19, 38, -320.646164, _
20, 38, -313.122118, _
13, 39, -283.210861, _
14, 39, -301.898514, _
15, 39, -315.916168, _
16, 39, -325.423821, _
17, 39, -331.281675, _
18, 39, -333.941128, _
19, 39, -333.723792, _
20, 39, -326.408835, _
21, 39, -312.520088, _
14, 40, -306.429832, _
15, 40, -319.227485, _
16, 40, -333.205138, _
17, 40, -337.112792, _
18, 40, -343.810341, _
19, 40, -341.523299, _
20, 40, -342.052022, _
21, 40, -326.946605, _
22, 40, -314.491059, _
14, 41, -306.411149, _
15, 41, -324.468802, _
16, 41, -337.426455, _
17, 41, -344.934109, _
18, 41, -349.909262, _
19, 41, -351.618486, _
20, 41, -350.414829, _
21, 41, -343.137113, _
15, 42, -326.320119, _
16, 42, -344.157773, _
17, 42, -350.605426, _
18, 42, -359.336079, _
19, 42, -359.152293, _
20, 42, -361.895456, _
21, 42, -354.68728, _
22, 42, -346.905693, _
15, 43, -329.561436, _
16, 43, -346.51909, _
17, 43, -357.936743, _
18, 43, -364.994397, _
19, 43, -368.79505, _
20, 43, -369.828303, _
21, 43, -366.825257, _
22, 43, -359.17601, _
16, 44, -351.740407, _
17, 44, -362.06806, _
18, 44, -373.728814, _
19, 44, -376.083367, _
20, 44, -380.95952, _
21, 44, -376.524774, _
22, 44, -375.474827, _
23, 44, -361.263981, _
16, 45, -353.941724, _
17, 45, -368.269377, _
18, 45, -378.897631, _
19, 45, -384.952684, _
20, 45, -388.374338, _
21, 45, -387.847791, _
22, 45, -385.003344, _
23, 45, -377.095298, _
24, 45, -363.402951, _
17, 46, -372.690694, _
18, 46, -386.918348, _
19, 46, -391.834001, _
20, 46, -398.768755, _
21, 46, -396.608408, _
22, 46, -398.192361, _
23, 46, -390.359615, _
24, 46, -381.978268, _
18, 47, -391.179665, _
19, 47, -400.183318, _
20, 47, -406.045072, _
21, 47, -407.254725, _
22, 47, -407.072679, _
23, 47, -403.360032, _
24, 47, -395.133585, _
19, 48, -404.682635, _
20, 48, -415.990289, _
21, 48, -415.489942, _
22, 48, -418.699296, _
23, 48, -413.904649, _
24, 48, -411.465902, _
25, 48, -397.184556, _
19, 49, -410.949953, _
20, 49, -421.136606, _
21, 49, -425.617259, _
22, 49, -426.841713, _
23, 49, -425.457466, _
24, 49, -422.04872, _
25, 49, -413.551873, _
19, 50, -414.05127, _
20, 50, -427.489923, _
21, 50, -431.673576, _
22, 50, -437.78093, _
23, 50, -434.793483, _
24, 50, -435.049037, _
25, 50, -426.63399, _
26, 50, -417.704843, _
20, 51, -431.85024, _
21, 51, -438.425894, _
22, 51, -444.153347, _
23, 51, -445.8446, _
24, 51, -444.309654, _
25, 51, -440.319807, _
26, 51, -431.518161, _
20, 52, -436.571557, _
21, 52, -443.639211, _
22, 52, -451.961864, _
23, 52, -453.155817, _
24, 52, -456.349071, _
25, 52, -450.855224, _
26, 52, -447.699478, _
22, 53, -457.398181, _
23, 53, -461.634835, _
24, 53, -464.288188, _
25, 53, -462.909041, _
26, 53, -458.384095, _
27, 53, -449.301448, _
21, 54, -453.641845, _
22, 54, -464.229498, _
23, 54, -467.748152, _
24, 54, -474.007305, _
25, 54, -471.847858, _
26, 54, -471.762612, _
27, 54, -462.737265, _
28, 54, -453.155419, _
21, 55, -457.073162, _
22, 55, -468.380815, _
23, 55, -475.078469, _
24, 55, -480.253622, _
25, 55, -482.074376, _
26, 55, -481.060829, _
27, 55, -476.826682, _
28, 55, -467.352736, _
22, 56, -473.722132, _
23, 56, -480.079786, _
24, 56, -488.498639, _
25, 56, -489.344793, _
26, 56, -492.258146, _
27, 56, -486.909799, _
28, 56, -483.992053, _
22, 57, -476.39345, _
23, 57, -486.261103, _
24, 57, -493.812856, _
25, 57, -497.99321, _
26, 57, -499.904163, _
27, 57, -498.285917, _
28, 57, -494.24137, _
29, 57, -484.687023, _
23, 58, -490.35242, _
24, 58, -501.190073, _
25, 58, -504.487727, _
26, 58, -509.94878, _
27, 58, -506.858934, _
28, 58, -506.458387, _
29, 58, -497.11044, _
30, 58, -486.965994, _
23, 59, -495.283737, _
24, 59, -505.321391, _
25, 59, -512.129044, _
26, 59, -516.529797, _
27, 59, -517.312751, _
28, 59, -515.457704, _
29, 59, -509.876858, _
30, 59, -499.997311, _
23, 60, -498.865054, _
24, 60, -512.002708, _
25, 60, -517.900361, _
26, 60, -525.350014, _
27, 60, -524.804668, _
28, 60, -526.845421, _
29, 60, -519.935075, _
30, 60, -514.996628, _
24, 61, -515.754025, _
25, 61, -524.351678, _
26, 61, -530.930332, _
27, 61, -534.125385, _
28, 61, -534.665538, _
29, 61, -531.645892, _
30, 61, -525.224945, _
31, 61, -515.187599, _
24, 62, -522.055342, _
25, 62, -528.902995, _
26, 62, -538.981649, _
27, 62, -540.730302, _
28, 62, -545.262055, _
29, 62, -540.531609, _
30, 62, -538.122262, _
31, 62, -528.168916, _
25, 63, -535.284312, _
26, 63, -543.701966, _
27, 63, -549.209619, _
28, 63, -552.099873, _
29, 63, -551.384426, _
30, 63, -547.235579, _
31, 63, -540.787333, _
25, 64, -539.625629, _
26, 64, -550.993283, _
27, 64, -555.233936, _
28, 64, -561.75789, _
29, 64, -559.300443, _
30, 64, -559.097496, _
31, 64, -551.14585, _
32, 64, -545.879203, _
25, 65, -545.746947, _
26, 65, -555.1746, _
27, 65, -562.682253, _
28, 65, -567.856007, _
29, 65, -569.21126, _
30, 65, -567.076814, _
31, 65, -563.040067, _
32, 65, -556.01052, _
26, 66, -561.935917, _
27, 66, -567.69357, _
28, 66, -576.807524, _
29, 66, -576.277177, _
30, 66, -578.135931, _
31, 66, -572.178184, _
32, 66, -569.291837, _
33, 66, -558.389491, _
26, 67, -566.127234, _
27, 67, -574.714887, _
28, 67, -582.615241, _
29, 67, -585.408994, _
30, 67, -585.188248, _
31, 67, -583.405201, _
32, 67, -578.401155, _
33, 67, -571.610808, _
26, 68, -571.638551, _
27, 68, -579.076205, _
28, 68, -590.407658, _
29, 68, -591.728511, _
30, 68, -595.386365, _
31, 68, -591.682918, _
32, 68, -590.794472, _
33, 68, -581.932125, _
34, 68, -576.459778, _
27, 69, -585.797522, _
28, 69, -594.994175, _
29, 69, -599.969029, _
30, 69, -601.868482, _
31, 69, -601.995935, _
32, 69, -598.986389, _
33, 69, -594.193442, _
34, 69, -586.621096, _
27, 70, -589.508839, _
28, 70, -602.236492, _
29, 70, -605.280246, _
30, 70, -611.086399, _
31, 70, -609.649552, _
32, 70, -610.520206, _
33, 70, -603.514759, _
34, 70, -600.442413, _
27, 71, -595.810156, _
28, 71, -606.357809, _
29, 71, -613.086563, _
30, 71, -616.920116, _
31, 71, -618.95097, _
32, 71, -617.936123, _
33, 71, -615.140076, _
34, 71, -609.58373, _
35, 71, -602.741383, _
36, 71, -591.819037, _
28, 72, -613.169126, _
29, 72, -618.22978, _
30, 72, -625.795433, _
31, 72, -625.471487, _
32, 72, -628.68564, _
33, 72, -623.547393, _
34, 72, -622.429047, _
35, 72, -612.7727, _
36, 72, -606.911354, _
29, 73, -625.505097, _
30, 73, -631.14575, _
31, 73, -634.652704, _
32, 73, -635.468557, _
33, 73, -634.345711, _
34, 73, -630.824364, _
35, 73, -625.454017, _
36, 73, -617.593671, _
29, 74, -630.595414, _
30, 74, -639.517067, _
31, 74, -641.074721, _
32, 74, -645.664774, _
33, 74, -642.320028, _
34, 74, -642.890381, _
35, 74, -635.201334, _
35, 74, -635.187334, _
36, 74, -631.444488, _
37, 74, -620.247641, _
29, 75, -636.780731, _
30, 75, -644.348385, _
31, 75, -649.560638, _
32, 75, -652.170091, _
33, 75, -652.563745, _
34, 75, -650.917998, _
35, 75, -647.105652, _
36, 75, -641.508305, _
37, 75, -633.623958, _
38, 75, -622.239612, _
29, 76, -641.708048, _
30, 76, -652.089702, _
31, 76, -655.463955, _
32, 76, -661.598008, _
33, 76, -659.892162, _
34, 76, -662.072415, _
35, 76, -656.326969, _
36, 76, -654.269622, _
37, 76, -644.953075, _
38, 76, -637.930929, _
30, 77, -656.741019, _
31, 77, -663.230972, _
32, 77, -667.670326, _
33, 77, -669.590579, _
34, 77, -669.491232, _
35, 77, -667.344286, _
36, 77, -663.496339, _
37, 77, -657.369593, _
38, 77, -649.566246, _
30, 78, -663.432336, _
30, 78, -660.762336, _
31, 78, -669.016589, _
32, 78, -676.389643, _
33, 78, -676.562296, _
34, 78, -679.989049, _
35, 78, -675.632603, _
36, 78, -675.577956, _
37, 78, -667.55191, _
38, 78, -663.007563, _
31, 79, -675.891306, _
32, 79, -682.08896, _
33, 79, -685.453613, _
34, 79, -686.951867, _
35, 79, -686.32042, _
36, 79, -683.912573, _
37, 79, -679.490227, _
38, 79, -673.38188, _
39, 79, -665.482534, _
30, 80, -674.07497, _
31, 80, -680.592623, _
32, 80, -690.185277, _
33, 80, -692.04693, _
34, 80, -696.865484, _
35, 80, -694.212737, _
36, 80, -695.43339, _
37, 80, -688.931544, _
38, 80, -686.284197, _
39, 80, -676.413851, _
40, 80, -669.931504, _
31, 81, -687.503941, _
32, 81, -695.041594, _
33, 81, -700.492247, _
34, 81, -703.566401, _
35, 81, -704.369354, _
36, 81, -703.306208, _
37, 81, -700.284861, _
38, 81, -695.575514, _
39, 81, -689.285168, _
40, 81, -680.972821, _
32, 82, -702.432911, _
33, 82, -706.350564, _
34, 82, -712.842218, _
35, 82, -711.962371, _
36, 82, -714.273025, _
37, 82, -709.089378, _
38, 82, -708.126831, _
39, 82, -699.526485, _
33, 83, -713.981882, _
34, 83, -718.660535, _
35, 83, -721.546188, _
36, 83, -721.736542, _
37, 83, -720.047495, _
38, 83, -716.985149, _
39, 83, -711.737802, _
39, 83, -711.677802, _
40, 83, -705.085455, _
41, 83, -696.803109, _
34, 84, -727.342852, _
35, 84, -728.407505, _
36, 84, -732.257159, _
37, 84, -728.793812, _
38, 84, -728.905466, _
39, 84, -721.639119, _
34, 85, -731.890169, _
35, 85, -737.289823, _
36, 85, -739.377776, _
37, 85, -739.28246, _
38, 85, -737.435383, _
39, 85, -733.392436, _
40, 85, -727.91809, _
41, 85, -721.135743, _
34, 86, -738.074486, _
35, 86, -742.39114, _
36, 86, -749.234363, _
37, 86, -747.933466, _
38, 86, -748.9277, _
39, 86, -742.905753, _
40, 86, -740.639407, _
41, 86, -731.88706, _
42, 86, -725.834713, _
34, 87, -742.184803, _
35, 87, -748.679457, _
36, 87, -754.74954, _
37, 87, -757.855559, _
38, 87, -757.355817, _
39, 87, -754.71177, _
40, 87, -750.258724, _
41, 87, -744.308377, _
42, 87, -737.036031, _
34, 88, -747.55612, _
35, 88, -753.623774, _
36, 88, -761.803427, _
37, 88, -763.938081, _
38, 88, -768.468434, _
39, 88, -764.063487, _
40, 88, -762.605041, _
41, 88, -754.269694, _
42, 88, -750.117348, _
35, 89, -759.535091, _
36, 89, -766.912744, _
37, 89, -771.113398, _
38, 89, -774.827151, _
39, 89, -775.537405, _
40, 89, -771.922358, _
41, 89, -766.921011, _
42, 89, -760.492665, _
35, 90, -763.656408, _
36, 90, -773.224061, _
37, 90, -776.833715, _
38, 90, -782.630968, _
39, 90, -782.394522, _
40, 90, -783.891975, _
41, 90, -776.998328, _
42, 90, -773.726982, _
43, 90, -763.987635, _
35, 91, -768.617725, _
36, 91, -777.635379, _
37, 91, -783.288032, _
38, 91, -788.405685, _
39, 91, -790.323339, _
40, 91, -791.086392, _
41, 91, -789.045646, _
42, 91, -783.835299, _
43, 91, -776.828952, _
44, 91, -768.646606, _
35, 92, -771.759042, _
36, 92, -783.181696, _
37, 92, -788.386349, _
38, 92, -795.700002, _
39, 92, -796.862656, _
40, 92, -799.721209, _
41, 92, -796.933263, _
42, 92, -796.507616, _
43, 92, -787.855269, _
36, 93, -786.488013, _
37, 93, -794.303666, _
38, 93, -800.98832, _
39, 93, -804.343973, _
40, 93, -806.455626, _
41, 93, -805.76458, _
42, 93, -804.576933, _
43, 93, -800.594587, _
44, 93, -793.47924, _
37, 94, -798.309983, _
38, 94, -807.814637, _
39, 94, -810.54029, _
40, 94, -814.676743, _
41, 94, -812.992097, _
42, 94, -814.25495, _
43, 94, -809.216904, _
44, 94, -806.848557, _
45, 94, -796.13821, _
37, 95, -803.6823, _
38, 95, -812.162954, _
39, 95, -817.470607, _
40, 95, -821.139061, _
41, 95, -821.480814, _
42, 95, -821.624067, _
43, 95, -819.151221, _
44, 95, -815.801874, _
45, 95, -809.909528, _
46, 95, -799.077181, _
37, 96, -807.124617, _
38, 96, -818.056271, _
39, 96, -822.681924, _
40, 96, -828.995378, _
41, 96, -828.374231, _
42, 96, -830.778384, _
43, 96, -827.022538, _
44, 96, -826.495191, _
45, 96, -819.319845, _
46, 96, -815.088498, _
37, 97, -812.330935, _
38, 97, -821.976588, _
39, 97, -828.664241, _
40, 97, -834.570495, _
41, 97, -836.447148, _
42, 97, -837.599602, _
43, 97, -836.496855, _
44, 97, -834.606508, _
45, 97, -830.302162, _
46, 97, -824.729815, _
47, 97, -816.967469, _
37, 98, -816.262252, _
38, 98, -827.905905, _
39, 98, -832.944558, _
40, 98, -840.982212, _
41, 98, -842.441865, _
42, 98, -846.242219, _
43, 98, -843.776172, _
44, 98, -844.789825, _
45, 98, -838.958479, _
46, 98, -836.301132, _
47, 98, -827.278786, _
48, 98, -821.066439, _
37, 99, -820.993569, _
38, 99, -831.521222, _
39, 99, -838.749876, _
40, 99, -845.534529, _
41, 99, -849.311182, _
42, 99, -852.167636, _
43, 99, -852.742589, _
44, 99, -852.254143, _
45, 99, -849.428796, _
46, 99, -845.260449, _
47, 99, -839.050103, _
38, 100, -837.622539, _
39, 100, -843.910193, _
40, 100, -852.437846, _
41, 100, -854.994499, _
42, 100, -860.457153, _
43, 100, -859.507006, _
44, 100, -861.92746, _
45, 100, -857.510113, _
46, 100, -856.369766, _
47, 100, -848.51142, _
48, 100, -843.829073, _
49, 100, -832.966727, _
50, 100, -824.79438, _
37, 101, -829.856203, _
38, 101, -840.883856, _
39, 101, -849.60151, _
40, 101, -857.369163, _
41, 101, -862.068817, _
42, 101, -865.85547, _
43, 101, -867.898123, _
44, 101, -868.729477, _
45, 101, -867.40543, _
46, 101, -864.643084, _
47, 101, -859.652737, _
48, 101, -853.40039, _
38, 102, -846.625173, _
39, 102, -854.652827, _
40, 102, -863.72048, _
41, 102, -867.548134, _
42, 102, -873.972787, _
43, 102, -874.19944, _
44, 102, -877.949094, _
45, 102, -874.843747, _
46, 102, -875.211501, _
47, 102, -868.769054, _
48, 102, -865.399707, _
49, 102, -855.649361, _
50, 102, -849.087014, _
40, 103, -868.421797, _
41, 103, -874.589451, _
42, 103, -879.337104, _
43, 103, -882.301758, _
44, 103, -884.181211, _
45, 103, -884.162264, _
46, 103, -882.836818, _
47, 103, -879.366371, _
48, 103, -874.442025, _
49, 103, -867.609678, _
41, 104, -879.560768, _
42, 104, -886.888421, _
43, 104, -888.266075, _
44, 104, -893.082728, _
45, 104, -891.161181, _
46, 104, -892.819035, _
47, 104, -887.757688, _
48, 104, -885.839342, _
49, 104, -877.191995, _
50, 104, -871.889648, _
41, 105, -886.262085, _
42, 105, -891.969738, _
43, 105, -896.137392, _
44, 105, -898.993045, _
45, 105, -900.128699, _
46, 105, -899.913352, _
47, 105, -897.786005, _
48, 105, -894.265659, _
49, 105, -888.634312, _
50, 105, -881.630966, _
51, 105, -871.408619, _
42, 106, -898.956055, _
43, 106, -901.693709, _
44, 106, -907.458362, _
45, 106, -906.715016, _
46, 106, -909.473669, _
47, 106, -905.726322, _
48, 106, -905.138976, _
49, 106, -897.830629, _
50, 106, -893.872283, _
52, 106, -873.087589, _
42, 107, -903.712373, _
43, 107, -909.090026, _
44, 107, -913.127679, _
45, 107, -915.288333, _
46, 107, -916.010986, _
47, 107, -915.26264, _
48, 107, -913.063293, _
49, 107, -908.855946, _
50, 107, -903.0936, _
43, 108, -914.011343, _
44, 108, -920.948996, _
45, 108, -921.51665, _
46, 108, -925.238303, _
47, 108, -922.533957, _
48, 108, -923.40161, _
49, 108, -917.483263, _
50, 108, -914.625917, _
52, 108, -896.740224, _
43, 109, -920.67266, _
44, 109, -926.200314, _
45, 109, -929.578967, _
46, 109, -931.39262, _
47, 109, -931.725974, _
48, 109, -930.728927, _
49, 109, -927.927581, _
50, 109, -923.295234, _
51, 109, -916.132887, _
52, 109, -906.701541, _
53, 109, -895.919194, _
43, 110, -925.163977, _
44, 110, -933.401631, _
45, 110, -935.419284, _
46, 110, -940.205937, _
47, 110, -938.535191, _
48, 110, -940.645244, _
49, 110, -935.984898, _
50, 110, -934.571551, _
52, 110, -919.442858, _
54, 110, -897.498165, _
43, 111, -931.495294, _
44, 111, -938.162948, _
45, 111, -943.067601, _
46, 111, -945.932255, _
47, 111, -947.366908, _
48, 111, -947.621061, _
49, 111, -945.977215, _
50, 111, -942.743868, _
51, 111, -936.904522, _
52, 111, -928.714175, _
43, 112, -936.346611, _
44, 112, -945.044265, _
45, 112, -948.521918, _
46, 112, -954.335572, _
47, 112, -953.841225, _
48, 112, -957.015378, _
49, 112, -953.648532, _
50, 112, -953.531185, _
51, 112, -945.688839, _
52, 112, -940.605492, _
54, 112, -921.710799, _
44, 113, -949.835582, _
45, 113, -955.533235, _
46, 113, -959.760889, _
47, 113, -962.321542, _
48, 113, -963.555496, _
49, 113, -963.093849, _
50, 113, -961.274502, _
51, 113, -956.579156, _
52, 113, -949.723809, _
53, 113, -941.724463, _
54, 113, -931.902116, _
55, 113, -920.729769, _
45, 114, -960.554552, _
46, 114, -967.639206, _
47, 114, -968.308859, _
48, 114, -972.598413, _
49, 114, -970.367166, _
50, 114, -971.573819, _
51, 114, -964.745473, _
52, 114, -961.337126, _
54, 114, -944.969433, _
56, 114, -922.26874, _
44, 115, -960.208216, _
45, 115, -967.20587, _
46, 115, -972.613523, _
47, 115, -976.421176, _
48, 115, -978.73933, _
49, 115, -979.403483, _
50, 115, -979.120137, _
51, 115, -975.30479, _
52, 115, -969.582443, _
53, 115, -963.075097, _
54, 115, -954.61175, _
45, 116, -971.807187, _
46, 116, -980.24484, _
47, 116, -982.072493, _
48, 116, -987.439147, _
49, 116, -986.1878, _
50, 116, -988.683554, _
51, 116, -983.194107, _
52, 116, -980.85976, _
53, 116, -972.298414, _
54, 116, -967.073067, _
46, 117, -984.886157, _
47, 117, -989.843811, _
48, 117, -993.216464, _
49, 117, -994.954117, _
50, 117, -995.626771, _
51, 117, -993.089424, _
52, 117, -988.759078, _
53, 117, -983.314731, _
54, 117, -976.282384, _
55, 117, -967.755038, _
46, 118, -991.897474, _
47, 118, -995.215128, _
48, 118, -1001.57178, _
49, 118, -1001.31043, _
50, 118, -1004.95419, _
51, 118, -1000.51474, _
52, 118, -999.454395, _
53, 118, -991.922048, _
54, 118, -988.247701, _
55, 118, -977.795355, _
47, 119, -1002.27644, _
48, 119, -1006.8441, _
49, 119, -1009.85575, _
50, 119, -1011.4378, _
51, 119, -1010.06406, _
52, 119, -1006.98871, _
53, 119, -1002.78837, _
54, 119, -997.034019, _
55, 119, -989.762672, _
56, 119, -981.265325, _
46, 120, -1002.72011, _
47, 120, -1007.43776, _
48, 120, -1014.97942, _
49, 120, -1015.96307, _
50, 120, -1020.54582, _
51, 120, -1017.08238, _
52, 120, -1017.28103, _
53, 120, -1010.88368, _
54, 120, -1008.48334, _
55, 120, -999.417989, _
56, 120, -993.636642, _
47, 121, -1014.51908, _
48, 121, -1020.13673, _
49, 121, -1024.13539, _
50, 121, -1026.71614, _
51, 121, -1026.32479, _
52, 121, -1024.49835, _
53, 121, -1021.452, _
54, 121, -1016.85565, _
55, 121, -1010.70031, _
56, 121, -1003.55796, _
48, 122, -1027.87805, _
49, 122, -1029.9457, _
50, 122, -1035.52926, _
51, 122, -1033.13121, _
52, 122, -1034.33266, _
53, 122, -1029.31632, _
54, 122, -1027.80897, _
55, 122, -1019.81162, _
56, 122, -1015.49828, _
48, 123, -1032.52937, _
49, 123, -1037.86302, _
50, 123, -1041.47517, _
51, 123, -1042.09643, _
52, 123, -1041.26188, _
53, 123, -1039.25063, _
54, 123, -1035.77429, _
55, 123, -1030.78694, _
56, 123, -1024.61559, _
48, 124, -1040.00068, _
49, 124, -1043.38834, _
50, 124, -1049.96279, _
51, 124, -1048.56394, _
52, 124, -1050.6858, _
53, 124, -1046.74395, _
54, 124, -1046.2567, _
55, 124, -1039.54526, _
56, 124, -1036.12191, _
57, 124, -1026.50956, _
48, 125, -1044.722, _
49, 125, -1051.05965, _
50, 125, -1055.69581, _
51, 125, -1057.27046, _
52, 125, -1057.25481, _
53, 125, -1056.28667, _
54, 125, -1053.86002, _
55, 125, -1049.97357, _
56, 125, -1044.77123, _
57, 125, -1038.07988, _
48, 126, -1051.76332, _
49, 126, -1056.46097, _
50, 126, -1063.88862, _
51, 126, -1063.48628, _
52, 126, -1066.36853, _
53, 126, -1063.43258, _
54, 126, -1063.90824, _
55, 126, -1058.30189, _
56, 126, -1055.84455, _
57, 126, -1047.3622, _
58, 126, -1042.43085, _
48, 127, -1056.02463, _
49, 127, -1063.71229, _
50, 127, -1069.43894, _
51, 127, -1071.8576, _
52, 127, -1072.65635, _
53, 127, -1072.5759, _
54, 127, -1071.13156, _
55, 127, -1068.26821, _
56, 127, -1064.06186, _
57, 127, -1058.35952, _
58, 127, -1051.66117, _
48, 128, -1062.86595, _
49, 128, -1069.15361, _
50, 128, -1077.34626, _
51, 128, -1077.83791, _
52, 128, -1081.43867, _
53, 128, -1079.40222, _
54, 128, -1080.74187, _
55, 128, -1076.03053, _
56, 128, -1074.71918, _
57, 128, -1067.16483, _
58, 128, -1063.28649, _
59, 128, -1053.30114, _
49, 129, -1075.80492, _
50, 129, -1082.67658, _
51, 129, -1085.92823, _
52, 129, -1087.52108, _
53, 129, -1088.23854, _
54, 129, -1087.65059, _
55, 129, -1085.67084, _
56, 129, -1082.4535, _
57, 129, -1077.93215, _
58, 129, -1072.1108, _
59, 129, -1064.81546, _
48, 130, -1073.28859, _
49, 130, -1080.82624, _
50, 130, -1090.29289, _
51, 130, -1091.66355, _
52, 130, -1095.9406, _
53, 130, -1094.73885, _
54, 130, -1096.90621, _
55, 130, -1093.14216, _
56, 130, -1092.72141, _
57, 130, -1086.30547, _
58, 130, -1083.31812, _
59, 130, -1074.29277, _
60, 130, -1068.92643, _
49, 131, -1087.14456, _
50, 131, -1095.53921, _
51, 131, -1099.43086, _
52, 131, -1101.87002, _
53, 131, -1103.32257, _
54, 131, -1103.51102, _
55, 131, -1102.37348, _
56, 131, -1100.21493, _
57, 131, -1096.51778, _
58, 131, -1091.68644, _
59, 131, -1085.46409, _
60, 131, -1078.17074, _
49, 132, -1089.49887, _
50, 132, -1102.85053, _
51, 132, -1105.18818, _
52, 132, -1109.91383, _
53, 132, -1109.64949, _
54, 132, -1112.44764, _
55, 132, -1109.54069, _
56, 132, -1110.03725, _
57, 132, -1104.5601, _
58, 132, -1102.51175, _
59, 132, -1094.46541, _
60, 132, -1089.89906, _
50, 133, -1105.31784, _
51, 133, -1112.5285, _
52, 133, -1115.74815, _
53, 133, -1117.9078, _
54, 133, -1118.88206, _
55, 133, -1118.52707, _
56, 133, -1117.22726, _
57, 133, -1114.38542, _
58, 133, -1110.53207, _
59, 133, -1105.26472, _
60, 133, -1098.87438, _
61, 133, -1091.17203, _
50, 134, -1109.23916, _
51, 134, -1115.82681, _
52, 134, -1123.43347, _
53, 134, -1124.16412, _
54, 134, -1127.43427, _
55, 134, -1125.41861, _
56, 134, -1126.69498, _
57, 134, -1122.18174, _
58, 134, -1121.01639, _
59, 134, -1113.90804, _
60, 134, -1110.2617, _
61, 134, -1100.57335, _
51, 135, -1119.43813, _
52, 135, -1126.77579, _
53, 135, -1131.95344, _
54, 135, -1133.79809, _
55, 135, -1134.18065, _
56, 135, -1133.6669, _
57, 135, -1131.68505, _
58, 135, -1128.87671, _
59, 135, -1124.40536, _
60, 135, -1118.90101, _
61, 135, -1111.88467, _
62, 135, -1103.98232, _
52, 136, -1131.4471, _
53, 136, -1135.73476, _
54, 136, -1141.87741, _
55, 136, -1141.00876, _
56, 136, -1142.77462, _
57, 136, -1139.14537, _
58, 136, -1138.79102, _
59, 136, -1132.86768, _
60, 136, -1129.95733, _
61, 136, -1121.17598, _
62, 136, -1116.00464, _
52, 137, -1134.64842, _
53, 137, -1140.80907, _
54, 137, -1145.90273, _
55, 137, -1149.28698, _
56, 137, -1149.68023, _
57, 137, -1148.27769, _
58, 137, -1146.27334, _
59, 137, -1142.78899, _
60, 137, -1138.40965, _
61, 137, -1132.1203, _
62, 137, -1125.29495, _
53, 138, -1144.70739, _
54, 138, -1151.74504, _
55, 138, -1153.6997, _
56, 138, -1158.29195, _
57, 138, -1155.773, _
58, 138, -1156.03466, _
59, 138, -1150.81531, _
60, 138, -1148.91896, _
61, 138, -1141.05862, _
62, 138, -1136.83427, _
63, 138, -1126.30392, _
53, 139, -1149.28871, _
54, 139, -1155.31036, _
55, 139, -1159.58501, _
56, 139, -1163.01537, _
57, 139, -1164.55072, _
58, 139, -1163.48897, _
59, 139, -1160.57763, _
60, 139, -1156.96428, _
61, 139, -1151.68593, _
62, 139, -1145.78759, _
63, 139, -1138.02324, _
54, 140, -1160.72768, _
55, 140, -1164.00633, _
56, 140, -1169.44398, _
57, 140, -1169.71164, _
58, 140, -1172.69159, _
59, 140, -1168.52094, _
60, 140, -1167.2956, _
61, 140, -1160.47125, _
62, 140, -1156.9349, _
63, 140, -1147.68656, _
64, 140, -1141.69621, _
65, 140, -1129.61186, _
54, 141, -1164.13899, _
55, 141, -1169.50365, _
56, 141, -1173.9703, _
57, 141, -1176.39995, _
58, 141, -1178.11971, _
59, 141, -1177.91816, _
60, 141, -1175.31292, _
61, 141, -1170.85557, _
62, 141, -1165.48922, _
63, 141, -1158.69488, _
64, 141, -1151.20953, _
65, 141, -1141.74318, _
54, 142, -1169.36031, _
55, 142, -1173.61297, _
56, 142, -1180.13862, _
57, 142, -1181.56827, _
58, 142, -1185.28943, _
59, 142, -1183.76128, _
60, 142, -1185.14143, _
61, 142, -1179.56089, _
62, 142, -1176.61454, _
63, 142, -1168.15919, _
64, 142, -1163.01685, _
55, 143, -1178.84028, _
56, 143, -1184.32294, _
57, 143, -1187.79159, _
58, 143, -1190.43424, _
59, 143, -1191.1134, _
60, 143, -1191.26495, _
61, 143, -1189.4412, _
62, 143, -1185.21586, _
63, 143, -1179.15251, _
64, 143, -1172.35816, _
65, 143, -1163.77582, _
55, 144, -1182.5106, _
56, 144, -1190.22725, _
57, 144, -1192.56591, _
58, 144, -1197.33056, _
59, 144, -1196.86721, _
60, 144, -1199.08207, _
61, 144, -1195.96752, _
62, 144, -1195.73617, _
63, 144, -1188.60383, _
64, 144, -1183.95948, _
65, 144, -1173.78513, _
66, 144, -1167.21479, _
55, 145, -1187.36892, _
56, 145, -1193.93957, _
57, 145, -1198.73722, _
58, 145, -1202.06488, _
59, 145, -1203.81453, _
60, 145, -1204.83728, _
61, 145, -1203.89184, _
62, 145, -1202.49319, _
63, 145, -1199.05114, _
64, 145, -1193.1978, _
65, 145, -1185.36845, _
66, 145, -1176.9961, _
55, 146, -1191.00323, _
56, 146, -1199.60089, _
57, 146, -1202.93854, _
58, 146, -1208.71619, _
59, 146, -1208.96385, _
60, 146, -1212.4026, _
61, 146, -1210.14915, _
62, 146, -1210.90881, _
63, 146, -1206.24646, _
64, 146, -1204.43511, _
65, 146, -1195.32977, _
66, 146, -1189.33142, _
55, 147, -1195.47455, _
57, 147, -1208.73986, _
58, 147, -1213.13751, _
59, 147, -1215.78016, _
60, 147, -1217.69472, _
61, 147, -1217.80837, _
62, 147, -1217.25022, _
63, 147, -1214.74578, _
64, 147, -1211.77643, _
65, 147, -1206.38308, _
66, 147, -1199.03674, _
67, 147, -1189.90339, _
55, 148, -1198.82587, _
56, 148, -1208.75352, _
57, 148, -1213.09117, _
58, 148, -1219.56983, _
59, 148, -1220.92748, _
60, 148, -1225.02753, _
61, 148, -1223.70379, _
62, 148, -1225.39164, _
63, 148, -1221.5691, _
64, 148, -1220.76055, _
65, 148, -1214.2424, _
66, 148, -1210.77906, _
67, 148, -1200.15771, _
58, 149, -1223.95015, _
59, 149, -1227.5278, _
60, 149, -1230.06635, _
61, 149, -1230.97411, _
62, 149, -1231.26266, _
63, 149, -1229.78541, _
64, 149, -1227.68907, _
65, 149, -1223.26972, _
66, 149, -1218.70637, _
67, 149, -1211.89703, _
68, 149, -1203.16868, _
58, 150, -1230.14146, _
59, 150, -1232.84312, _
60, 150, -1237.44677, _
61, 150, -1236.57742, _
62, 150, -1239.24938, _
63, 150, -1236.20673, _
64, 150, -1236.39638, _
65, 150, -1230.95604, _
66, 150, -1228.37969, _
67, 150, -1220.22834, _
68, 150, -1215.331, _
58, 151, -1234.89278, _
59, 151, -1239.38143, _
60, 151, -1242.78109, _
61, 151, -1244.44074, _
62, 151, -1244.84589, _
63, 151, -1244.14015, _
64, 151, -1242.8937, _
65, 151, -1239.54635, _
66, 151, -1235.89301, _
67, 151, -1229.98366, _
68, 151, -1223.83531, _
69, 151, -1215.56897, _
70, 151, -1205.54462, _
59, 152, -1244.49175, _
60, 152, -1250.0574, _
61, 152, -1250.37906, _
62, 152, -1253.10351, _
63, 152, -1250.44686, _
64, 152, -1251.48422, _
65, 152, -1246.70767, _
66, 152, -1245.32932, _
67, 152, -1238.03098, _
68, 152, -1234.14063, _
69, 152, -1224.62828, _
70, 152, -1218.38594, _
59, 153, -1250.38307, _
60, 153, -1255.31972, _
61, 153, -1257.87337, _
62, 153, -1258.97183, _
63, 153, -1258.99718, _
64, 153, -1257.73113, _
65, 153, -1255.37899, _
66, 153, -1252.42664, _
67, 153, -1247.51329, _
68, 153, -1242.19995, _
69, 153, -1234.9446, _
71, 153, -1217.77491, _
59, 154, -1255.02438, _
60, 154, -1261.73204, _
61, 154, -1263.75969, _
62, 154, -1266.93894, _
63, 154, -1265.4394, _
64, 154, -1266.62585, _
65, 154, -1262.2903, _
66, 154, -1261.74596, _
67, 154, -1255.20961, _
68, 154, -1252.39526, _
69, 154, -1243.42992, _
70, 154, -1238.15257, _
61, 155, -1270.30101, _
62, 155, -1272.74586, _
63, 155, -1273.59081, _
64, 155, -1273.06107, _
65, 155, -1271.45562, _
66, 155, -1268.57927, _
67, 155, -1264.67693, _
68, 155, -1260.06958, _
69, 155, -1253.70724, _
70, 155, -1246.79289, _
71, 155, -1238.06154, _
60, 156, -1272.71467, _
61, 156, -1275.62233, _
62, 156, -1279.98998, _
63, 156, -1279.93063, _
64, 156, -1281.59749, _
65, 156, -1278.37094, _
66, 156, -1278.02059, _
67, 156, -1272.05825, _
68, 156, -1270.1389, _
69, 156, -1261.98355, _
70, 156, -1257.62521, _
71, 156, -1247.32886, _
72, 156, -1240.64651, _
61, 157, -1281.84364, _
62, 157, -1285.4213, _
63, 157, -1287.37595, _
64, 157, -1287.9573, _
65, 157, -1287.11486, _
66, 157, -1284.98991, _
67, 157, -1281.60856, _
68, 157, -1277.41722, _
69, 157, -1271.92387, _
70, 157, -1265.87452, _
71, 157, -1258.13318, _
73, 157, -1239.71548, _
61, 158, -1286.63496, _
62, 158, -1291.97261, _
63, 158, -1293.19027, _
64, 158, -1295.89472, _
65, 158, -1293.89277, _
66, 158, -1294.04523, _
67, 158, -1289.04188, _
68, 158, -1287.37253, _
69, 158, -1279.98919, _
70, 158, -1276.51884, _
71, 158, -1266.93549, _
72, 158, -1261.04315, _
62, 159, -1297.04393, _
63, 159, -1300.10458, _
64, 159, -1301.83774, _
65, 159, -1302.02589, _
66, 159, -1300.87804, _
67, 159, -1298.2582, _
68, 159, -1294.70685, _
69, 159, -1289.9275, _
70, 159, -1284.41816, _
71, 159, -1277.50281, _
72, 159, -1269.86446, _
73, 159, -1260.67612, _
64, 160, -1309.28915, _
65, 160, -1308.40111, _
66, 160, -1309.45396, _
67, 160, -1305.38151, _
68, 160, -1304.26917, _
69, 160, -1297.72882, _
70, 160, -1294.81647, _
71, 160, -1286.13413, _
72, 160, -1281.01878, _
73, 160, -1270.17943, _
74, 160, -1262.87709, _
64, 161, -1314.92457, _
65, 161, -1316.09772, _
66, 161, -1315.90828, _
67, 161, -1314.26783, _
68, 161, -1311.49148, _
69, 161, -1307.39914, _
70, 161, -1302.56179, _
71, 161, -1296.49744, _
72, 161, -1289.4721, _
73, 161, -1281.05475, _
75, 161, -1261.68606, _
64, 162, -1321.77019, _
65, 162, -1322.38084, _
66, 162, -1324.10529, _
67, 162, -1321.18315, _
68, 162, -1320.6968, _
69, 162, -1315.05545, _
70, 162, -1312.62111, _
71, 162, -1304.84676, _
72, 162, -1300.39742, _
73, 162, -1290.22207, _
74, 162, -1283.66172, _
65, 163, -1329.37316, _
66, 163, -1330.37631, _
67, 163, -1329.59137, _
68, 163, -1327.59912, _
69, 163, -1324.37777, _
70, 163, -1320.16443, _
71, 163, -1314.86908, _
72, 163, -1308.58173, _
73, 163, -1301.05339, _
74, 163, -1292.64104, _
75, 163, -1282.95569, _
65, 164, -1334.92348, _
66, 164, -1338.03443, _
67, 164, -1336.26588, _
68, 164, -1336.44644, _
69, 164, -1331.60209, _
70, 164, -1329.95474, _
71, 164, -1322.7914, _
72, 164, -1319.18905, _
73, 164, -1309.8677, _
74, 164, -1304.03636, _
75, 164, -1292.54001, _
76, 164, -1284.69766, _
66, 165, -1343.75035, _
67, 165, -1344.2547, _
68, 165, -1343.09575, _
69, 165, -1340.72141, _
70, 165, -1337.29006, _
71, 165, -1332.66271, _
72, 165, -1327.07437, _
73, 165, -1320.51102, _
74, 165, -1312.73567, _
75, 165, -1303.74833, _
77, 165, -1282.96663, _
65, 166, -1346.74611, _
66, 166, -1350.79386, _
67, 166, -1350.49832, _
68, 166, -1351.57067, _
69, 166, -1347.75072, _
70, 166, -1346.66238, _
71, 166, -1340.31303, _
72, 166, -1337.36868, _
73, 166, -1328.82534, _
74, 166, -1323.83699, _
75, 166, -1312.86264, _
76, 166, -1305.8183, _
66, 167, -1356.21508, _
67, 167, -1357.77973, _
68, 167, -1358.00709, _
69, 167, -1356.47634, _
70, 167, -1353.73969, _
71, 167, -1349.86335, _
72, 167, -1345.049, _
73, 167, -1339.14965, _
74, 167, -1332.10531, _
75, 167, -1323.94396, _
76, 167, -1314.95161, _
77, 167, -1304.74827, _
66, 168, -1362.9064, _
67, 168, -1363.63405, _
68, 168, -1365.7784, _
69, 168, -1363.31706, _
70, 168, -1362.79201, _
71, 168, -1357.49466, _
72, 168, -1355.01332, _
73, 168, -1347.26397, _
74, 168, -1342.97762, _
75, 168, -1333.09528, _
76, 168, -1326.51393, _
77, 168, -1314.43058, _
78, 168, -1305.99824, _
66, 169, -1368.01771, _
67, 169, -1370.43837, _
68, 169, -1371.78172, _
69, 169, -1371.35067, _
70, 169, -1369.65833, _
71, 169, -1366.58298, _
72, 169, -1362.44063, _
73, 169, -1357.23129, _
74, 169, -1351.07694, _
75, 169, -1343.76259, _
76, 169, -1335.31525, _
77, 169, -1325.8929, _
67, 170, -1375.94668, _
68, 170, -1379.03894, _
69, 170, -1377.94259, _
70, 170, -1378.12865, _
71, 170, -1373.8873, _
72, 170, -1372.04895, _
73, 170, -1365.15061, _
74, 170, -1361.52326, _
75, 170, -1352.36591, _
76, 170, -1346.59357, _
77, 170, -1334.93322, _
78, 170, -1327.40687, _
67, 171, -1382.298, _
68, 171, -1384.72056, _
69, 171, -1385.42891, _
70, 171, -1384.74306, _
71, 171, -1382.48212, _
72, 171, -1379.29727, _
73, 171, -1374.80392, _
74, 171, -1369.38758, _
75, 171, -1362.76923, _
76, 171, -1355.02988, _
77, 171, -1346.38454, _
78, 171, -1336.64219, _
79, 171, -1325.95484, _
68, 172, -1391.55597, _
69, 172, -1391.66463, _
70, 172, -1392.76258, _
71, 172, -1389.46123, _
72, 172, -1388.34159, _
73, 172, -1382.48524, _
74, 172, -1379.46989, _
75, 172, -1371.11055, _
76, 172, -1366.0462, _
77, 172, -1355.26585, _
78, 172, -1348.34451, _
80, 172, -1326.76881, _
69, 173, -1398.61494, _
70, 173, -1399.1299, _
71, 173, -1397.67705, _
72, 173, -1395.4209, _
73, 173, -1391.62356, _
74, 173, -1387.17121, _
75, 173, -1381.21586, _
76, 173, -1374.31752, _
77, 173, -1366.36917, _
78, 173, -1357.25482, _
79, 173, -1347.35248, _
69, 174, -1404.29726, _
70, 174, -1406.59451, _
71, 174, -1404.43787, _
72, 174, -1403.92682, _
73, 174, -1399.03887, _
74, 174, -1396.74253, _
75, 174, -1389.40618, _
76, 174, -1384.94683, _
77, 174, -1375.03749, _
78, 174, -1368.70514, _
79, 174, -1356.44379, _
80, 174, -1348.46845, _
69, 175, -1410.81858, _
70, 175, -1412.41683, _
71, 175, -1412.10458, _
72, 175, -1410.63534, _
73, 175, -1407.77819, _
74, 175, -1404.21984, _
75, 175, -1399.0925, _
76, 175, -1393.12715, _
77, 175, -1385.6688, _
78, 175, -1377.14746, _
79, 175, -1368.11511, _
80, 175, -1357.88276, _
69, 176, -1415.93989, _
70, 176, -1419.28165, _
71, 176, -1418.3926, _
72, 176, -1418.80035, _
73, 176, -1414.81051, _
74, 176, -1413.30016, _
75, 176, -1406.93881, _
76, 176, -1403.19147, _
77, 176, -1394.17212, _
78, 176, -1388.45677, _
79, 176, -1377.12643, _
80, 176, -1369.74308, _
70, 177, -1424.84806, _
71, 177, -1425.46552, _
72, 177, -1425.18377, _
73, 177, -1423.23582, _
74, 177, -1420.43148, _
75, 177, -1416.21613, _
76, 177, -1411.11479, _
77, 177, -1404.42944, _
78, 177, -1396.97009, _
79, 177, -1388.36775, _
80, 177, -1378.8154, _
81, 177, -1368.58105, _
70, 178, -1431.62818, _
71, 178, -1431.49084, _
72, 178, -1432.80979, _
73, 178, -1430.09014, _
74, 178, -1429.2168, _
75, 178, -1423.67145, _
76, 178, -1420.7821, _
77, 178, -1412.70576, _
78, 178, -1407.66941, _
79, 178, -1397.21906, _
80, 178, -1390.42372, _
82, 178, -1368.97402, _
71, 179, -1438.28315, _
72, 179, -1438.90871, _
73, 179, -1438.02076, _
74, 179, -1436.17611, _
75, 179, -1432.67577, _
76, 179, -1428.32742, _
77, 179, -1422.60207, _
78, 179, -1416.00673, _
79, 179, -1407.91238, _
80, 179, -1399.10003, _
81, 179, -1389.69569, _
71, 180, -1443.98047, _
72, 180, -1446.29652, _
73, 180, -1444.66198, _
74, 180, -1444.58743, _
75, 180, -1440.00108, _
76, 180, -1437.73774, _
77, 180, -1430.57439, _
78, 180, -1426.25004, _
79, 180, -1416.6277, _
80, 180, -1410.49435, _
82, 180, -1390.62366, _
72, 181, -1451.99134, _
73, 181, -1452.23869, _
74, 181, -1451.26875, _
75, 181, -1448.7434, _
76, 181, -1445.00005, _
77, 181, -1440.13971, _
78, 181, -1434.26036, _
79, 181, -1426.97401, _
80, 181, -1418.98167, _
81, 181, -1410.33932, _
82, 181, -1399.89597, _
72, 182, -1458.70976, _
73, 182, -1458.30171, _
74, 182, -1459.33356, _
75, 182, -1455.75372, _
76, 182, -1454.13037, _
77, 182, -1447.79102, _
78, 182, -1444.12568, _
79, 182, -1435.47533, _
80, 182, -1429.96798, _
81, 182, -1418.95964, _
82, 182, -1411.65329, _
72, 183, -1464.01207, _
73, 183, -1465.23583, _
74, 183, -1465.52438, _
75, 183, -1464.18603, _
76, 183, -1461.25269, _
77, 183, -1457.00734, _
78, 183, -1451.79999, _
79, 183, -1445.43265, _
80, 183, -1438.2633, _
81, 183, -1430.26795, _
82, 183, -1420.46761, _
72, 184, -1470.29339, _
73, 184, -1470.85204, _
74, 184, -1472.936, _
75, 184, -1470.67335, _
76, 184, -1469.9201, _
77, 184, -1464.49266, _
78, 184, -1461.43131, _
79, 184, -1453.63597, _
80, 184, -1448.88362, _
81, 184, -1438.64227, _
82, 184, -1432.01493, _
73, 185, -1477.47836, _
74, 185, -1478.68972, _
75, 185, -1478.33987, _
76, 185, -1476.54472, _
77, 185, -1473.28898, _
78, 185, -1468.85063, _
79, 185, -1463.25528, _
80, 185, -1456.78194, _
81, 185, -1449.58359, _
82, 185, -1440.58224, _
83, 185, -1430.4019, _
73, 186, -1482.76368, _
74, 186, -1485.88083, _
75, 186, -1484.51919, _
76, 186, -1484.80614, _
77, 186, -1480.19729, _
78, 186, -1478.10595, _
79, 186, -1471.1746, _
80, 186, -1467.21625, _
81, 186, -1458.08491, _
82, 186, -1451.79356, _
83, 186, -1439.50021, _
74, 187, -1491.34745, _
75, 187, -1491.876, _
76, 187, -1491.09616, _
77, 187, -1488.81161, _
78, 187, -1485.02626, _
79, 187, -1480.53592, _
80, 187, -1474.86657, _
81, 187, -1468.41022, _
82, 187, -1460.16388, _
83, 187, -1450.77453, _
74, 188, -1498.18097, _
75, 188, -1497.74772, _
76, 188, -1499.08567, _
77, 188, -1495.49493, _
78, 188, -1494.20758, _
79, 188, -1487.90323, _
80, 188, -1485.02189, _
81, 188, -1476.38754, _
82, 188, -1471.07019, _
83, 188, -1459.67285, _
84, 188, -1452.2285, _
74, 189, -1503.06528, _
75, 189, -1504.78094, _
76, 189, -1505.00599, _
77, 189, -1503.69124, _
78, 189, -1500.9389, _
79, 189, -1497.25555, _
80, 189, -1492.5212, _
81, 189, -1486.71086, _
82, 189, -1479.20651, _
83, 189, -1470.60416, _
84, 189, -1461.17682, _
74, 190, -1509.9566, _
75, 190, -1510.44425, _
76, 190, -1512.79821, _
77, 190, -1510.06076, _
78, 190, -1509.85021, _
79, 190, -1504.62587, _
80, 190, -1502.33252, _
81, 190, -1494.51017, _
82, 190, -1489.81483, _
83, 190, -1479.51548, _
84, 190, -1472.39613, _
75, 191, -1517.29457, _
76, 191, -1518.55692, _
77, 191, -1518.08728, _
78, 191, -1516.29653, _
79, 191, -1513.62618, _
80, 191, -1509.62684, _
81, 191, -1504.53249, _
82, 191, -1497.71914, _
83, 191, -1489.9268, _
84, 191, -1480.95845, _
76, 192, -1526.11504, _
77, 192, -1524.28539, _
78, 192, -1524.96275, _
79, 192, -1520.6645, _
80, 192, -1519.11616, _
81, 192, -1512.19281, _
82, 192, -1508.09646, _
83, 192, -1498.30812, _
84, 192, -1492.04677, _
76, 193, -1531.69846, _
77, 193, -1532.05731, _
78, 193, -1531.21817, _
79, 193, -1529.35282, _
80, 193, -1526.22747, _
81, 193, -1521.71413, _
82, 193, -1515.80178, _
83, 193, -1508.70243, _
84, 193, -1500.40709, _
85, 193, -1491.41474, _
76, 194, -1538.80988, _
77, 194, -1538.12413, _
78, 194, -1539.57558, _
79, 194, -1536.29214, _
80, 194, -1535.44079, _
81, 194, -1529.29544, _
82, 194, -1525.8911, _
83, 194, -1516.89075, _
84, 194, -1511.1234, _
85, 194, -1500.52606, _
76, 195, -1544.13849, _
77, 195, -1545.35595, _
78, 195, -1545.6806, _
79, 195, -1544.67145, _
80, 195, -1542.31911, _
81, 195, -1538.69176, _
82, 195, -1533.46841, _
83, 195, -1526.99607, _
84, 195, -1519.25972, _
85, 195, -1510.88337, _
86, 195, -1501.55503, _
76, 196, -1550.79981, _
77, 196, -1551.17746, _
78, 196, -1553.60252, _
79, 196, -1551.31277, _
80, 196, -1551.21712, _
81, 196, -1546.10508, _
82, 196, -1543.18673, _
83, 196, -1535.05238, _
84, 196, -1529.73504, _
85, 196, -1519.39869, _
86, 196, -1512.72634, _
77, 197, -1558.07678, _
78, 197, -1559.44883, _
79, 197, -1559.38519, _
80, 197, -1558.00274, _
81, 197, -1555.02039, _
82, 197, -1550.64605, _
83, 197, -1544.8027, _
84, 197, -1537.69235, _
85, 197, -1529.89001, _
86, 197, -1521.28766, _
78, 198, -1567.00575, _
79, 198, -1565.8975, _
80, 198, -1566.48746, _
81, 198, -1562.24071, _
82, 198, -1560.01836, _
83, 198, -1552.55502, _
84, 198, -1547.87667, _
85, 198, -1538.29132, _
86, 198, -1532.06998, _
77, 199, -1570.35141, _
78, 199, -1572.56107, _
79, 199, -1573.48172, _
80, 199, -1573.15147, _
81, 199, -1570.88103, _
82, 199, -1567.26768, _
83, 199, -1562.05534, _
84, 199, -1555.68999, _
85, 199, -1548.51264, _
86, 199, -1540.4303, _
87, 199, -1531.36795, _
78, 200, -1579.84339, _
79, 200, -1579.72804, _
80, 200, -1581.17979, _
81, 200, -1577.94135, _
82, 200, -1576.354, _
83, 200, -1569.69865, _
84, 200, -1565.50031, _
85, 200, -1556.75196, _
86, 200, -1550.98761, _
87, 200, -1540.07927, _
78, 201, -1585.0517, _
79, 201, -1586.93036, _
80, 201, -1587.41031, _
81, 201, -1586.14666, _
82, 201, -1583.44032, _
83, 201, -1578.81597, _
84, 201, -1573.14262, _
85, 201, -1566.62428, _
86, 201, -1559.12293, _
87, 201, -1550.67058, _
79, 202, -1593.00067, _
80, 202, -1595.16423, _
81, 202, -1593.01898, _
82, 202, -1592.18763, _
83, 202, -1586.20429, _
84, 202, -1582.61294, _
85, 202, -1574.49759, _
86, 202, -1569.39925, _
87, 202, -1559.2019, _
88, 202, -1552.34955, _
79, 203, -1599.81499, _
80, 203, -1601.15874, _
81, 203, -1600.8685, _
82, 203, -1599.11195, _
83, 203, -1595.0826, _
84, 203, -1590.06726, _
85, 203, -1584.14091, _
86, 203, -1577.35556, _
87, 203, -1569.55222, _
88, 203, -1560.99087, _
80, 204, -1608.65116, _
81, 204, -1607.52461, _
82, 204, -1607.50597, _
83, 204, -1602.28092, _
84, 204, -1599.16557, _
85, 204, -1591.92423, _
86, 204, -1587.25088, _
87, 204, -1577.87653, _
88, 204, -1571.64819, _
80, 205, -1614.31928, _
81, 205, -1615.07053, _
82, 205, -1614.23768, _
83, 205, -1610.74724, _
84, 205, -1606.41189, _
85, 205, -1601.09254, _
86, 205, -1595.0482, _
87, 205, -1587.86585, _
88, 205, -1579.9335, _
80, 206, -1621.04959, _
81, 206, -1621.57435, _
82, 206, -1622.3243, _
83, 206, -1617.78455, _
84, 206, -1615.15621, _
85, 206, -1608.61186, _
86, 206, -1604.52552, _
87, 206, -1595.87017, _
88, 206, -1590.27982, _
89, 206, -1579.55248, _
80, 207, -1624.39491, _
81, 207, -1628.42657, _
82, 207, -1629.06212, _
83, 207, -1625.88227, _
84, 207, -1622.19153, _
85, 207, -1617.50618, _
86, 207, -1612.11183, _
87, 207, -1605.53849, _
88, 207, -1598.37614, _
89, 207, -1590.00379, _
81, 208, -1632.21338, _
82, 208, -1636.43004, _
83, 208, -1632.76919, _
84, 208, -1630.58634, _
85, 208, -1624.8255, _
86, 208, -1621.20015, _
87, 208, -1613.4398, _
88, 208, -1608.27346, _
89, 208, -1598.44511, _
81, 209, -1637.1732, _
82, 209, -1640.36725, _
83, 209, -1640.22901, _
84, 209, -1637.55406, _
85, 209, -1633.28581, _
86, 209, -1628.55247, _
87, 209, -1622.61012, _
88, 209, -1616.20877, _
89, 209, -1608.43643, _
90, 209, -1599.99408, _
81, 210, -1640.85252, _
82, 210, -1645.55247, _
83, 210, -1644.83362, _
84, 210, -1645.21258, _
85, 210, -1640.44913, _
85, 210, -1637.89913, _
86, 210, -1637.29278, _
87, 210, -1630.25844, _
88, 210, -1625.66909, _
89, 210, -1616.55774, _
90, 210, -1610.5224, _
82, 211, -1649.38689, _
83, 211, -1649.97114, _
84, 211, -1649.76329, _
85, 211, -1648.19555, _
86, 211, -1644.5221, _
87, 211, -1639.14175, _
88, 211, -1633.36541, _
89, 211, -1626.21906, _
90, 211, -1618.72671, _
82, 212, -1654.5142, _
83, 212, -1654.30176, _
84, 212, -1655.77151, _
85, 212, -1653.24076, _
86, 212, -1652.49742, _
87, 212, -1646.59307, _
88, 212, -1642.46372, _
89, 212, -1634.21038, _
90, 212, -1628.61703, _
91, 212, -1618.31568, _
82, 213, -1658.22212, _
83, 213, -1659.48677, _
84, 213, -1660.12643, _
85, 213, -1659.27008, _
86, 213, -1657.60673, _
87, 213, -1654.67639, _
88, 213, -1649.98604, _
89, 213, -1643.41169, _
90, 213, -1636.65935, _
91, 213, -1628.337, _
82, 214, -1663.29074, _
83, 214, -1663.52709, _
84, 214, -1666.01465, _
85, 214, -1664.1424, _
86, 214, -1664.30005, _
87, 214, -1660.15571, _
88, 214, -1658.31436, _
89, 214, -1651.20401, _
90, 214, -1646.13867, _
91, 214, -1636.57832, _
83, 215, -1668.74941, _
84, 215, -1670.15636, _
85, 215, -1670.08872, _
86, 215, -1669.22037, _
87, 215, -1666.95102, _
88, 215, -1663.95268, _
89, 215, -1659.69233, _
90, 215, -1653.99498, _
91, 215, -1646.26964, _
83, 216, -1672.59573, _
84, 216, -1675.90358, _
85, 216, -1674.64803, _
86, 216, -1675.86669, _
87, 216, -1672.36134, _
88, 216, -1671.26699, _
89, 216, -1665.65265, _
90, 216, -1662.6893, _
91, 216, -1654.41095, _
84, 217, -1679.8577, _
85, 217, -1680.58035, _
86, 217, -1680.535, _
87, 217, -1679.09666, _
88, 217, -1676.74231, _
89, 217, -1673.13996, _
90, 217, -1668.84862, _
91, 217, -1663.21227, _
92, 217, -1656.79992, _
84, 218, -1685.47171, _
85, 218, -1684.94867, _
86, 218, -1687.04782, _
87, 218, -1684.42397, _
88, 218, -1684.04963, _
89, 218, -1679.07828, _
90, 218, -1676.76193, _
91, 218, -1669.68459, _
92, 218, -1665.65124, _
85, 219, -1690.72198, _
86, 219, -1691.50584, _
87, 219, -1690.93629, _
88, 219, -1689.37794, _
89, 219, -1686.4196, _
90, 219, -1682.73725, _
91, 219, -1677.9049, _
92, 219, -1672.43256, _
85, 220, -1694.8403, _
86, 220, -1697.79455, _
87, 220, -1696.14261, _
88, 220, -1696.57026, _
89, 220, -1692.30891, _
90, 220, -1690.60957, _
91, 220, -1684.11622, _
86, 221, -1702.00727, _
87, 221, -1702.41892, _
88, 221, -1701.95058, _
89, 221, -1699.61223, _
90, 221, -1696.41189, _
91, 221, -1692.18754, _
86, 222, -1708.17699, _
87, 222, -1707.41924, _
88, 222, -1708.6649, _
89, 222, -1705.58255, _
90, 222, -1704.2182, _
87, 223, -1713.45576, _
88, 223, -1713.82251, _
89, 223, -1712.44887, _
90, 223, -1710.10652, _
91, 223, -1706.39017, _
92, 223, -1702.08783, _
87, 224, -1718.25088, _
88, 224, -1720.30133, _
89, 224, -1718.11118, _
90, 224, -1717.56784, _
91, 224, -1712.91149, _
92, 224, -1710.28514, _
87, 225, -1724.17219, _
88, 225, -1725.20585, _
89, 225, -1724.7795, _
90, 225, -1723.32515, _
91, 225, -1720.51281, _
92, 225, -1716.69346, _
93, 225, -1711.69811, _
87, 226, -1728.68351, _
88, 226, -1731.60206, _
89, 226, -1730.17882, _
90, 226, -1730.50947, _
91, 226, -1726.89112, _
92, 226, -1724.81278, _
87, 227, -1734.47483, _
88, 227, -1736.16348, _
89, 227, -1736.70923, _
90, 227, -1735.97159, _
91, 227, -1734.16344, _
92, 227, -1731.19109, _
93, 227, -1726.87075, _
88, 228, -1742.472, _
89, 228, -1741.73545, _
90, 228, -1743.0769, _
91, 228, -1740.14276, _
92, 228, -1739.05941, _
94, 228, -1730.62972, _
87, 229, -1744.44746, _
88, 229, -1746.92212, _
89, 229, -1747.95277, _
90, 229, -1748.33392, _
91, 229, -1747.24008, _
92, 229, -1745.14473, _
93, 229, -1741.79338, _
94, 229, -1737.39104, _
88, 230, -1753.03843, _
89, 230, -1752.96409, _
90, 230, -1755.12774, _
91, 230, -1753.03439, _
92, 230, -1752.81205, _
93, 230, -1748.4047, _
94, 230, -1745.92835, _
89, 231, -1758.9254, _
90, 231, -1760.24576, _
91, 231, -1759.85501, _
92, 231, -1758.69136, _
93, 231, -1756.08602, _
94, 231, -1752.64867, _
89, 232, -1763.76672, _
90, 232, -1766.68607, _
91, 232, -1765.40403, _
92, 232, -1765.95898, _
94, 232, -1760.63899, _
90, 233, -1771.47249, _
91, 233, -1771.93324, _
92, 233, -1771.721, _
93, 233, -1769.90865, _
94, 233, -1767.0263, _
96, 233, -1758.22161, _
90, 234, -1777.66301, _
91, 234, -1777.15366, _
92, 234, -1778.56571, _
93, 234, -1775.97397, _
94, 234, -1774.79762, _
96, 234, -1766.85893, _
90, 235, -1782.08832, _
91, 235, -1783.23598, _
92, 235, -1783.86313, _
93, 235, -1782.95658, _
94, 235, -1781.03494, _
91, 236, -1788.2873, _
92, 236, -1790.40865, _
93, 236, -1788.6926, _
94, 236, -1788.38756, _
91, 237, -1794.06861, _
92, 237, -1795.53437, _
93, 237, -1795.27062, _
94, 237, -1794.26827, _
91, 238, -1799.00993, _
92, 238, -1801.68868, _
93, 238, -1800.75894, _
94, 238, -1801.26819, _
95, 238, -1798.23054, _
96, 238, -1796.4682, _
92, 239, -1806.495, _
93, 239, -1806.97415, _
94, 239, -1806.91431, _
95, 239, -1805.32986, _
92, 240, -1812.42522, _
93, 240, -1812.04287, _
94, 240, -1813.44852, _
95, 240, -1811.28118, _
96, 240, -1810.28543, _
93, 241, -1818.16919, _
94, 241, -1818.69004, _
95, 241, -1817.92849, _
96, 241, -1816.37875, _
93, 242, -1823.0805, _
94, 242, -1824.99976, _
95, 242, -1823.46611, _
96, 242, -1823.34826, _
98, 242, -1817.24877, _
93, 243, -1828.64682, _
94, 243, -1830.03347, _
95, 243, -1829.83103, _
96, 243, -1829.04118, _
97, 243, -1826.75144, _
94, 244, -1836.05479, _
95, 244, -1835.19745, _
96, 244, -1835.8424, _
97, 244, -1832.79775, _
98, 244, -1831.25221, _
94, 245, -1840.82611, _
95, 245, -1841.24976, _
96, 245, -1841.36272, _
97, 245, -1839.76967, _
98, 245, -1837.41582, _
94, 246, -1846.60843, _
95, 246, -1846.22608, _
96, 246, -1847.82033, _
97, 246, -1845.68639, _
98, 246, -1844.78234, _
100, 246, -1837.16935, _
96, 247, -1852.97605, _
97, 247, -1852.2367, _
98, 247, -1850.80836, _
96, 248, -1859.18937, _
97, 248, -1857.68902, _
98, 248, -1857.77667, _
100, 248, -1851.54598, _
96, 249, -1863.90268, _
97, 249, -1864.02074, _
98, 249, -1863.36239, _
96, 250, -1869.735, _
97, 250, -1868.99065, _
98, 250, -1869.98751, _
100, 250, -1865.52062, _
96, 251, -1874.14732, _
97, 251, -1874.78497, _
98, 251, -1875.09563, _
99, 251, -1873.93628, _
100, 251, -1871.67893, _
98, 252, -1881.26794, _
99, 252, -1879.2296, _
100, 252, -1878.92025, _
102, 252, -1871.29156, _
98, 253, -1886.07226, _
99, 253, -1885.57721, _
100, 253, -1884.45857, _
98, 254, -1892.10358, _
99, 254, -1890.67023, _
100, 254, -1890.97568, _
102, 254, -1885.59119, _
99, 255, -1896.64455, _
100, 255, -1896.1522, _
101, 255, -1894.32585, _
102, 255, -1891.53251, _
100, 256, -1902.53652, _
101, 256, -1899.62017, _
102, 256, -1898.63382, _
104, 256, -1890.65713, _
100, 257, -1907.50483, _
101, 257, -1906.31529, _
102, 257, -1904.28814, _
101, 258, -1911.69481, _
106, 260, -1909.03371, _
104, 261, -1923.93472, _
108, 264, -1926.73428, _
106, 265, -1943.15029
