C     Output of FBtoFO from GEFSUB.BAS
      PROGRAM MAIN
      IMPLICIT NONE
C     ' 
C     ' 
C     '    Copyright 2009,2010,2011,2012,2013: 
C     '       Dr. Karl-Heinz Schmidt,Rheinstrasse 4,64390 Erzhausen,Germany 
C     '       and 
C     '       Dr. Beatriz Jurado,Centre d'Etudes Nucleaires de Bordeaux-Gradignan, 
C     '       Chemin du Solarium,Le Haut Vigneau,BP 120,33175 Gradignan,Cedex, 
C     '       France 
C     ' 
C     '    This program is free software: you can redistribute it and/or modify 
C     '    it under the terms of the GNU General Public License as published by 
C     '    the Free Software Foundation,either version 3 of the License,or 
C     '    (at your option) any later version. 
C     ' 
C     '    This program is distributed in the hope that it will be useful, 
C     '    but WITHOUT ANY WARRANTY; without even the implied warranty of 
C     '    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
C     '    GNU General Public License for more details. 
C     ' 
C     '    You should have received a copy of the GNU General Public License 
C     '    along with this program.  If not,see <http://www.gnu.org/licenses/>. 
C     ' 
C     ' 
C     /' Documentation: '/ 
C     /' (1) K.-H. Schmidt and B. Jurado,Contribution to '/ 
C     /'     ESNT Workshop "The scission process",Saclay (France),April 12-16,2010 '/ 
C     /' (2) B. Jurado and K.-H. Schmidt,Contribution to '/ 
C     /'     Seminar an fission,Gent (Belgium),May 17-20,2010 '/ 
C     /' (3) K.-H. Schmidt and B. Jurado,Contribution to '/ 
C     /'     Seminar on fission,Gent (Belgium),May 17-20,2010 '/ 
C     /' (4) B. Jurado and K.-H. Schmidt,Contribution to '/ 
C     /'     EFNUDAT Workshop,Paris (France),May 25-27,2010 '/ 
C     /' (5) K.-H. Schmidt and B. Jurado,Contribution to '/ 
C     /'     EFNUDAT Workshop,Paris (France),May 25-27,2010 '/ 
C     /' (6) K.-H. Schmidt and B. Jurado,'/ 
C     /'     Final Report to EFNUDAT,October,2010 '/ 
C     /' (7) K.-H. Schmidt and B. Jurado,Phys. Rev. Lett. 104 (2010) 21250 '/ 
C     /' (8) K.-H. Schmidt and B. Jurado,Phys. Rev. C 82 (2011) 014607 '/ 
C     /' (9) K.-H. Schmidt and B. Jurado,Phys. Rev. C 83 (2011) 061601 '/ 
C     /' (10) K.-H. Schmidt and B. Jurado,arXiv:1007.0741v1[nucl-th] (2010) '/ 
C     /' (11) K.-H. Schmidt and B. Jurado,JEF/DOC 1423,NEA of OECD,2012 '/ 
C     /' (12) K.-H. Schmidt and B. Jurado,Phys. Rev. C 86 (2012) 044322 '/ 
C     ' 
C     ' 
C     /' Further documentation and the newest version of the GEF code are '/ 
C     /' available from                                                   '/ 
C     /' http://www.cenbg.in2p3.fr/GEF and http://www.khs-erzhausen.de/ . '/ 
C     ' 
C     ' 
C     '    The development of the GEF code has been supported by the European Union, 
C     '    EURATOM 6 in the Framework Program "European Facilities for Nuclear Data 
C     '    Measurements" (EFNUDAT),contract number FP6-036434,the Framework 
C     '    Program "European Research Infrastructure for Nuclear Data Applications 
C     '    (ERINDA),and by the OECD Nuclear Energy Agency. 
C     ' 
C     ' 
C     ' Technical remark: The code contains commented sections with 
C     ' produce the GEF code as a subroutine from this source with a dedicated 
C     ' pre-processor. 
C     ' 
C     ' 
C     /' K.-H. Schmidt / B. Jurado,07/Feb./2009 '/ 
C     /' SEFI9 is taken as a basis and extended by new features in SEFI14 (May 2010),KHS '/ 
C     /' Several improvements (even-odd effect,charge polarization etc. (June 2010),KHS '/ 
C     /' SEFI15 converted to FreeBASIC on 04/July/2010,KHS '/ 
C     /' Error in LyPair corrected (26/July/2010) KHS '/ 
C     /' Indices corrected in U_Shell inside Eva (1/Aug/2010) KHS '/ 
C     /' Major developments,sigma_E*(scission),sigma_Z(A) etc. (14/Aug/2010) KHS '/ 
C     /' Macroscopic masses from Thomas-Fermi model (Myers & Swiatecki) (17/Aug/2010) KHS '/ 
C     /' 3 reference options for energy input (4/Sept/2010) KHS '/ 
C     /' Graphic output of mass distribution added (if there are problems with the X11 
C     installation on LINUX,the graphics may be suppressed by simply commenting 
C     the line  -> #Include Once "DCLPlotting.bas" <- )  (5/Sept/2010) KHS '/ 
C     /' Comparison with ENDF compilation in graphic output (12/Sept/2010) KHS '/ 
C     /' Super-long fission channel included (14/Sept/2010) KHS '/ 
C     /' Overlap of S1 and S2 fission channels in both fragments included (18/Oct/2010) KHS '/ 
C     /' Output of neutron multiplicity distribution added (20/Oct/2010) KHS '/ 
C     /' Decreasing curvature of shells with increasing E* (24/Oct/2010) KHS '/ 
C     /' Angular momenta of fission fragments added (18/Dec/2010) KHS '/ 
C     /' CN angular momentum considered (14/Jan/2011) KHS '/ 
C     /' Numerical stability improved (28/Jan/2011) KHS '/ 
C     /' Output in ENDF format (optional) (4/Feb/2011) KHS '/ 
C     /' Input list from file supported (31/Jan/2011) KHS '/ 
C     /' Multiprocessing supported (5/Feb/2011) KHS '/ 
C     /' Polarization for symmetric fission channel improved (12/Feb/2011) KHS '/ 
C     /' GUI for input (23/Feb/2011) KHS '/ 
C     /' Calculation of fission-fragment angular momentum refined (5/May/2011) KHS '/ 
C     /' Neutron inverse cross section modified (5/August/2011) KHS '/ 
C     /' Even-odd staggering in neutron emission improved (5/August/2011) KHS '/ 
C     /' Slight modifications in angular-momentum distributions (19/October/2011) KHS '/ 
C     /' Gamma emission added (23/November/2011) KHS '/ 
C     /' TKE added (24/November/2011) KHS '/ 
C     /' Neutron spectrum added (25/November/2011) KHS '/ 
C     /' Neutron-gamma competition added (4/December/2011) KHS '/ 
C     /' Composite level density (Egidy + Ignatyuk) refined (31/January/2012) KHS '/ 
C     /' Treatment of GDR refined (14/February/2012) KHS '/ 
C     /' Deformation of S3 channel changed (27/February/2012) KHS '/ 
C     /' Z=44 deformed shell added (supports S1 around Pu) (27/February/2012) KHS '/ 
C     /' Uncertainties from perturbed fission yields (3/March/2012) KHS '/ 
C     /' Validity range extended to Z=120 (with a warning message) (8/March/2012) KHS '/ 
C     /' Neutron emission during fragment acceleration (18/March/2012) KHS '/ 
C     /' Several optimizations (15/April/2012) KHS '/ 
C     /' TF masses of Myers & Swiatecki corrected (pairing shift) (29/May/2012) KHS '/ 
C     /' Correction on intrinsic excitation energy (05/June/2012) KHS '/ 
C     /' Correction on gamma emission (25/September/2012) KHS '/ 
C     /' Free choice of listmode values (13/October/2012) KHS '/ 
C     /' Excitation-energy distribution from file (14/October/2012) KHS '/ 
C     /' Transfer of input from GUI corrected (02/November/2012) KHS '/ 
C     /' Parameters of perturbed calculations modified (02/November/2012) KHS '/ 
C     /' Model parameters je-adjusted (08/November/2012) KHS '/ 
C     /' Input options for isomeric target nuclei (09/November/2012) KHS '/ 
C     /' Random initialisation of the random generator (26/November/2012) KHS '/ 
C     /' Covariance matrix for Z,Apre,Apost,ZApre,ZApost (06/December/2012) KHS '/ 
C     /' Output file in XML format (06/December/2012) KHS '/ 
C     /' Multi-chance fission supported (13/December/2012) KHS '/ 
C     /' Pre-compound emission for (n,f) included (13/December/2012) KHS '/ 
C     /' Some technical corrections and modifications (17/December/2012) KHS '/ 
C     /' Transition from asymmetric to symmetric fission around Fm improved (19/December/2012) KHS '/ 
C     /' Influence of S2 channel on S1 channel in the other fragment included (20/December/2012) KHS'/ 
C     /' List-mode output of pre-fission neutron energies (21/December/2012) KHS '/ 
C     /' Parameterisation for EB-EA from fit to data in Dahlinger et al. (21/December/2012) KHS '/ 
C     /' Fission channel at Z=42 added (seen around Pu in light fragment and around Hg) (23/Dec./2012) KHS '/ 
C     /' Gamma-n / Gamma-f according to Moretto (IAEA Rochester) (23/December/2012) KHS '/ 
C     /' Pre-compound neutron energies modified (24/December/2012) KHS '/ 
C     /' Some technical revisions to avoid crashes in covariances (26/December/2012) KHS '/ 
C     /' Influence of shells on yrast line from Deleplanque et al. (26/December/2012) KHS '/ 
C     /' Fission threshold in multi-chance fission modified (30/December/2012) KHS '/ 
C     /' Output of energies at fission for multi-chance fission (30/December/2012) KHS '/ 
C     /' Several revisions (15/January/2013) KHS '/ 
C     /' New optical model fit (3/February/2013) KHS '/ 
C     /' Gamma-f / Gamma-n modified (3/February/2013) KHS '/ 
C     /' Handling for reading input from file corrected (5/February/2013) KHS '/ 
C     /' Data transfer from GUI corrected (6/February/2013) KHS '/ 
C     /' Input dialog re-organized (6/February/2013) KHS '/ 
C     /' Mass-dependent deformation and charge polarization revised (9/February/2013) KHS '/ 
C     /' Calculation of combined fission channels S12,S22 revised (10/February/2013) KHS '/ 
C     /' Extension of validity range to heavier nuclei (10/February/2013) KHS '/ 
C     /' Improved description of prompt-neutron spectra (21/February/2013) KHS '/ 
C     /' Several technical corrections and developments (April-May/2013) KHS '/ 
C     /' Pre-fission emission of protons considered (14/Mai,2013) KHS '/ 
C     /' Structure of energy list in input file modified (26/May/2013) KHS '/ 
C     /' Option "local fit" added (26/May/2013) KHS '/ 
C     /' Neutron evaporation corrected (more realistic even-odd effect in isotonic distr.) (21/June(2013) KHS '/ 
C     /' Even-odd effect in TKE added (23/June/2013) KHS '/ 
C     /' Calculation of Z-A-covariance matrix corrected (16/July/2013) KHS '/ 
C     /' Output of multi-variant distributions corrected for input from file (24/July/2013) KHS '/ 
C     /' New global fit (most important: Energy gain from saddle to scission reduced) (15/September/2013) KHS '/ 
C     /' Even-odd effect in neutron number of fragments modified (17/September/2013) KHS '/ 
C     /' Curvatures of fission valleys adjusted to experimental shells around 132Sn (18/September/2013) KHS '/ 
C     /' Width of S0 corrected: Fit of Rusanov (18/September/2013) KHS '/ 
C     /' Random generator Box with asymmetric diffuseness for S2 (18/September/2013) KHS '/ 
C     /' Gaussian random generator revised (20/September/2013) KHS '/ 
C     /' Mass shift of fission channels with E* modified (22/September/2013) KHS '/ 
C     /' Energy dependence of S1 position corrected,slightly modified parameters (25/September/2013) KHS '/ 
C     /' Initial angular momentum introduced as an input parameter (02/October/2013) KHS '/ 
C     /' Calculation of prompt-neutron emission improved,some model parameters modified (12/October/2013) KHS '/ 
C     /' Technical error,causing incomplete covariance matrices on output corrected  (17/October/2013) KHS '/ 
C     /' Washing of shell effects considerd in shape fluctuations (26/October/2013) KHS '/ 
C     /' Post-scission neutrons added to list-mode output (8/November/2013) KHS '/ 
C     /' Fission-gamma competition refined (10/November/2013) KHS '/ 
C     /' New global fit of model parameters (18/November/2013) KHS '/ 
C     /' Multi-chance fission modified (18/November/2013) KHS '/ 
C     /' A numerical instability removed (20/November/2013) KHS '/ 
C     ' 
C     /' FreeBASIC is available from http://www.freebasic.net/ '/ 
C     /' It runs on Windows,Linux,and DOS. '/ 
C     /' FreeBASIC compiles a binary code that uses the C run-time library. '/ 
C     ' 
C     ' 
C     '  #Include "utilities.bi" 
C     ' 
C     /' Functions and subroutines '/ 
C     ' 
      	 
      CALL GEFSUB(92,236,6.0,0.0) 
C     ' 
C     /' 
C     Dim As Single Zsum 
C     ' 
C     'Print 
C     'Print "Z,A,Yield" 
C     For J = 20 To 80 
C     Zsum = 0 
C     For I = 20 To 150 
C     Zsum = Zsum + NZpre(I,J) 
C     If NZPRE(I,J) > 0.00001 Then 
C     '      Print J,I+J,NZPRE(I,J)*200 
C     End If 
C     Next 
C     Next 
C     ' 
C     'Print 
C     'Print "Z yields" 
C     For J = 20 To 80 
C     Zsum = 0 
C     For I = 20 To 150 
C     Zsum = Zsum + NZpre(I,J) 
C     Next 
C     '  Print J,Zsum * 200 
C     Next 
C     ' 
C     Dim As Single Asum 
C     'Print 
C     'Print "N yields" 
C     For I = 20 To 150 
C     Asum = 0 
C     For J = 20 To 80 
C     Asum = Asum + NZpre(I,J) 
C     '   If NZPRE(I,J) > 0.001 Then 
C     '     Print J,I+J,NZPRE(I,J)*200 
C     '   End If 
C     Next 
C     '  Print I,Asum * 200 
C     Next   '/ 
C     ' 
      End 
C     ' 
C     ' 
      SUBROUTINE GEFSUB(P_Z_CN,P_A_CN,P_E_EXC,P_J_CN)
      IMPLICIT NONE
      INTEGER*4 P_Z_CN
      INTEGER*4 P_A_CN
      REAL*4 P_E_EXC
      REAL*4 P_J_CN
C     /' Input parameters: '/ 
C     /' Atomic number,mass number,excitation energy/MeV,spin/h_bar of CN '/ 
C     /' Results are stored in external arrays. '/ 
C     ' 
      INCLUDE "GEFSUBdcl2.FOR" 
C     ' 
      Bsub = 1 
C     ' 
      P_DZ_Mean_S1 = xP_DZ_Mean_S1 
      P_DZ_Mean_S2 = xP_DZ_Mean_S2 
      P_DZ_Mean_S3 = xP_DZ_Mean_S3 
      P_DZ_Mean_S4 = xP_DZ_Mean_S4 
      P_Z_Curv_S1 = xP_Z_Curv_S1 
      P_Z_Curv_S2 = xP_Z_Curv_S2 
      P_A_Width_S2 = xP_A_Width_S2 
      P_Z_Curv_S3 = xP_Z_Curv_S3 
      P_Z_Curv_S4 = xP_Z_Curv_S4 
      Delta_S0 = xDelta_S0 
      P_Shell_S1 = xP_Shell_S1 
      P_Shell_S2 = xP_Shell_S2 
      P_Shell_S3 = xP_Shell_S3 
      P_Shell_S4 = xP_Shell_S4 
      T_low_S1 = xT_low_S1 
      T_low_S2 = xT_low_S2 
      T_low_S3 = xT_low_S3 
      T_low_S4 = xT_low_S4 
      T_low_SL = xT_low_SL 
      P_att_pol = xP_att_pol 
      HOMPOL = xHOMPOL 
      POLARadd = xPOLARadd 
C     ' 
      R_E_exc_used = P_E_exc 
      I_A_CN = P_A_CN 
      I_Z_CN = P_Z_CN 
C     ' 
C     /' Central Z values of fission modes '/ 
C     ' 
C     /' Fit to positions of fission channels (Boeckstiegel et al.,2008) '/ 
C     /' P_DZ_Mean_S1 and P_DZ_Mean_S2 allow for slight adjustments '/ 
C     '    Scope 
      R_Z_mod = I_Z_CN 
      ZC_Mode_0 = R_Z_mod * 0.5E0 
C     /' Central Z value of SL mode '/ 
      ZC_Mode_1 = (53.0E0 - 51.5E0) / (1.56E0 - 1.50E0) * 
     *(R_Z_mod**1.3E0 / I_A_CN - 1.50E0) + 51.5E0 + P_DZ_Mean_S1 
      ZC_Mode_2 = (55.8E0 - 54.5E0) / (1.56E0 - 1.50E0) * 
     *(R_Z_mod**1.3E0 / I_A_CN - 1.50E0) + 54.5E0 + P_DZ_Mean_S2 
      ZC_Mode_3 = ZC_Mode_2 + 4.5E0 + P_DZ_Mean_S3 
      ZC_Mode_4 = 42.05 + P_DZ_Mean_S4 
C     '    End Scope 
C     ' 
      I_N_CN = I_A_CN - I_Z_CN 
C     /' Mean deformation as a function of mass '/ 
C     /' Mode 0: liquid drop and mode 4: Z = 44 '/ 
      beta1_prev = 0.3 
      beta2_prev = 0.3 
      beta1_opt = beta1_prev 
      beta2_opt = beta2_prev 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      A1 = Z1 / REAL(I_Z_CN) * REAL(I_A_CN) 
      A2 = I_A_CN - A1 
C     ' 
      CALL Beta_Equi(A1,A2,Z1,Z2,dneck,beta1_prev,beta2_prev,beta1_opt,
     *beta2_opt) 
C     ' 
C     'Print "Mode 0,Z1,Z2,beta1,beta2",Z1,Z2,beta1_opt,beta2_opt 
      Beta(0,1,I) = beta1_opt 
C     /' "light" fragment '/ 
      Beta(4,1,I) = beta1_opt 
      Beta(0,2,I) = beta1_opt 
C     /' "heavy" fragment '/ 
      Beta(4,2,I) = beta1_opt 
      beta1_prev = beta1_opt 
      beta2_prev = beta2_opt 
      E_defo = Lymass(Z1,A1,beta1_opt) - Lymass(Z1,A1,0.0) 
C     'Print "Edefo 1",E_defo 
      Edefo(0,1,I) = E_defo 
C     /' "light" fragment '/ 
      Edefo(4,1,I) = E_defo 
      Edefo(0,2,I) = E_defo 
C     /' "heavy" fragment '/ 
      Edefo(4,2,I) = E_defo 
      END DO 
C     ' 
C     /' Mode 1: deformed shells (light) and spherical (heavy) '/ 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      A1 = (Z1 - 0.5E0) / REAL(I_Z_CN) * REAL(I_A_CN) 
C     /' polarization roughly considered '/ 
      A2 = I_A_CN - A1 
      IF (  I_Z_CN * 0.5 .LT. ZC_Mode_1  ) THEN 
C     ' Beta_opt_light(A1,A2,Z1,Z2,dneck,0,rbeta_ld) 
C     /' nu_mean of Cf requires shells in the light fragment: '/ 
      rbeta = beta_light(I,betaL0,betaL1) 
C     ' general deformation of light fragment 
      IF (  rbeta .LT. 0  )  rbeta = 0 
      Else 
      rbeta = beta_heavy(I,betaH0,betaH1) 
C     ' equal to S2 channel 
      IF (  rbeta .LT. 0  )  rbeta = 0 
      End If 
      Beta(1,1,I) = rbeta 
C     /' "light" fragment '/ 
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0) 
      Edefo(1,1,I) = E_defo 
C     /' "light" fragment '/ 
      END DO 
C     ' 
      DO I = 10 , I_Z_CN - 10 
      rbeta = 0 
      Beta(1,2,I) = rbeta 
      Edefo(1,2,I) = 0 
C     /' "heavy" fragment (at S1 shell) '/ 
      END DO 
C     ' 
C     /' Mode 2: deformed shells (light and heavy) '/ 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      A1 = (Z1 - 0.5E0) / REAL(I_Z_CN) * REAL(I_A_CN) 
C     /' polarization roughly considered '/ 
      A2 = I_A_CN - A1 
      IF (  I_Z_CN * 0.5 .LT. ZC_Mode_2  ) THEN 
C     ' Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2),rbeta_ld) 
      rbeta = beta_light(I,betaL0,betaL1) 
C     ' general deformation of light fragment 
      IF (  rbeta .LT. 0  )  rbeta = 0 
C     ' negative values replaced by 0 
      Else 
      rbeta = beta_heavy(I,betaH0,betaH1) 
C     ' equal to S2 channel 
      End If 
      Beta(2,1,I) = rbeta 
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0) 
      Edefo(2,1,I) = E_defo 
      END DO 
      DO I = 10 , I_Z_CN - 10 
      rbeta = beta_heavy(I,betaH0,betaH1) 
C     /' "heavy" fragment (at S2 shell)'/ 
      IF (  rbeta .LT. 0  )  rbeta = 0 
C     ' negative values replaced by 0 
      Beta(2,2,I) = rbeta 
      Z1 = I 
      A1 = (Z1 + 0.5E0) / I_Z_CN * I_A_CN 
C     /' polarization rougly considered '/ 
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0) 
      Edefo(2,2,I) = E_defo 
      END DO 
C     ' 
C     /' Mode 3 '/ 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      A1 = (Z1 - 0.5E0) / REAL(I_Z_CN) * REAL(I_A_CN) 
C     /' polarization roughly considered '/ 
      A2 = I_A_CN - A1 
      rbeta = beta_light(I,betaL0,betaL1) 
      rbeta = Max(rbeta-0.10,0.0) 
C     /' for low nu-bar of lightest fragments '/ 
C     '  Beta_opt_light(A1,A2,Z1,Z2,dneck,beta_heavy(Z2,betaH0,betaH1),rbeta) 
      Beta(3,1,I) = rbeta 
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0) 
      Edefo(3,1,I) = E_defo 
      END DO 
      DO I = 10 , I_Z_CN - 10 
      rbeta = beta_heavy(I,betaH0,betaH1) + 0.2 
C     /' for high nu-bar of heaviest fragments '/ 
      IF (  rbeta .LT. 0  )  rbeta = 0 
      Beta(3,2,I) = rbeta 
      Z1 = I 
      A1 = (Z1 + 0.5E0) / REAL(I_Z_CN) * REAL(I_A_CN) 
C     /' polarization roughly considered '/ 
      E_defo = Lymass(Z1,A1,rbeta) - Lymass(Z1,A1,0.0) 
      Edefo(3,2,I) = E_defo 
      END DO 
C     ' 
C     /' Mode 5: (Channel ST1 in both fragments) '/ 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      rbeta = Beta(1,2,I) 
      IF (  rbeta .LT. 0  )  rbeta = 0 
      Beta(5,1,Int(Z1)) = rbeta 
      Beta(5,2,Int(Z1)) = rbeta 
      END DO 
C     ' 
C     /' Mode 6: (Channel ST2 in both fragments) '/ 
      DO I = 10 , I_Z_CN - 10 
      Z1 = I 
      Z2 = I_Z_CN - Z1 
      rbeta = Beta(2,2,I) 
      IF (  rbeta .LT. 0  )  rbeta = 0 
      Beta(6,1,Int(Z1)) = rbeta 
      Beta(6,2,Int(Z1)) = rbeta 
      END DO 
C     ' 
C     ' 
C     /' Mean Z as a function of mass '/ 
C     ' 
C     /' Mode 0 '/ 
      DO I = 10 , I_A_CN - 10 
      ZUCD = REAL(I) / REAL(I_A_CN) * REAL(I_Z_CN) 
      beta1 = Beta(0,1,Int(ZUCD + 0.5)) 
      beta2 = Beta(0,2,Int(I_Z_CN - ZUCD + 0.5)) 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN - I,beta1,beta2,dneck,0,0,1) 
      Zmean(0,1,I) = Z1 
      Zshift(0,1,I) = Z1 - ZUCD 
      Zmean(0,2,I_A_CN - I) = I_Z_CN - Z1 
      Zshift(0,2,I_A_CN - I) = ZUCD - Z1 
      END DO 
C     ' 
C     /' Mode 1 '/ 
      DO I = 10 , I_A_CN - 10 
      ZUCD = REAL(I) / REAL(I_A_CN) * REAL(I_Z_CN) 
      Z = ZUCD + ZPOL1 
C     /' Charge polarisation is considered in a crude way '/ 
      beta1 = Beta(1,1,NINT(Z)) 
C     /' "light" fragment '/ 
      Z = ZUCD - ZPOL1 
      beta2 = Beta(1,2,NINT(I_Z_CN-Z)) 
C     /' "heavy" fragment  at S1 shell '/ 
      IF (  REAL(I_Z_CN) * 0.5 .LT. ZC_Mode_1  ) THEN 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN - I,beta1,beta2,dneck,1,POLARadd,
     *POLARfac) 
      Else 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN - I,beta1,beta2,dneck,1,0.0,0.0) 
      End If 
      Z1 = Z1 + ZPOL1 
C     /' Charge polarization by shell '/ 
C     ' 
      IF (  I_Z_CN - Z1 .LT. 50 .AND. (I_Z_CN - Z1) .GT. Z1  ) THEN 
      Z1 = I_Z_CN - 50 
C     /' Z of mean heavy fragment not below 50 '/ 
      END IF 
C     ' 
      Zmean(1,1,I) = Z1 
      Zshift(1,1,I) = Z1 - ZUCD 
C     ' neutron-deficient 
      Zmean(1,2,I_A_CN - I) = I_Z_CN - Z1 
      Zshift(1,2,I_A_CN - I) = ZUCD - Z1 
C     ' neutron rich at shell 
      END DO 
C     ' 
C     /' Mode 2 '/ 
      DO I = 10 , I_A_CN - 10 
      ZUCD = REAL(I) / REAL(I_A_CN) * REAL(I_Z_CN) 
      Z = ZUCD 
C     /' Charge polarisation is here neglected '/ 
      beta1 = Beta(2,1,NINT(Z)) 
      beta2 = Beta(2,2,NINT(I_Z_CN-Z)) 
      IF (  REAL(I_Z_CN) * 0.5 .LT. ZC_Mode_2  ) THEN 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN-I,beta1,beta2,dneck,2,POLARadd,
     *POLARfac) 
      Else 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN-I,beta1,beta2,dneck,2,0.0,0.0) 
      End If 
      Zmean(2,1,I) = Z1 
      Zshift(2,1,I) = Z1 - ZUCD 
C     ' neutron deficieint 
      Zmean(2,2,I_A_CN - I) = I_Z_CN - Z1 
      Zshift(2,2,I_A_CN - I) = ZUCD - Z1 
C     ' neutron rich at shell 
      END DO 
C     ' 
C     /' Mode 3 '/ 
      DO I = 10 , I_A_CN - 10 
      ZUCD = REAL(I) / REAL(I_A_CN) * REAL(I_Z_CN) 
      Z = ZUCD 
C     /' Charge polarisation is here neglected '/ 
      beta1 = Beta(3,1,NINT(Z)) 
      beta2 = Beta(3,2,NINT(I_Z_CN-Z)) 
      Z1 = Z_equi(I_Z_CN,I,I_A_CN - I,beta1,beta2,dneck,3,POLARadd,
     *POLARfac) 
      Zmean(3,1,I) = Z1 
      Zshift(3,1,I) = Z1 - ZUCD 
      Zmean(3,2,I_A_CN - I) = I_Z_CN - Z1 
      Zshift(3,2,I_A_CN - I) = ZUCD - Z1 
      END DO 
C     ' 
C     /' Mode 4 (assumed to be equal to mode 0) '/ 
      DO I = 10 , I_A_CN - 10 
      Zmean(4,1,I) = Zmean(0,1,I) 
      Zshift(4,1,I) = Zshift(0,1,I) 
      Zmean(4,2,I_A_CN - I) = Zmean(0,2,I_A_CN - I) 
      Zshift(4,2,I_A_CN - I) = Zshift(0,2,I_A_CN - I) 
      END DO 
C     ' 
C     ' 
C     /' General relations between Z and A of fission channels '/ 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_0 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(0,2,NINT(RA)) 
      END DO 
      AC_Mode_0 = (ZC_Mode_0 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
C     /' mean position in mass '/ 
      NC_Mode_0 = AC_Mode_0 - ZC_Mode_0 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_1 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(1,2,NINT(RA)) 
      END DO 
      AC_Mode_1 = (ZC_Mode_1 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_1 = AC_Mode_1 - ZC_Mode_1 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_2 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(2,2,NINT(RA)) 
      END DO 
      AC_Mode_2 = (ZC_Mode_2 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_2 = AC_Mode_2 - ZC_Mode_2 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_3 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(3,2,NINT(RA)) 
      END DO 
      AC_Mode_3 = (ZC_Mode_3 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_3 = AC_Mode_3 - ZC_Mode_3 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_4 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(4,2,NINT(RA)) 
      END DO 
      AC_Mode_4 = (ZC_Mode_4 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_4 = AC_Mode_4 - ZC_Mode_4 
C     ' 
C     ' 
C     /' Potential curvatures of fission modes '/ 
C     ' 
      RI = REAL(I_N_CN - I_Z_CN)/REAL(I_A_CN) 
C     /' measure of neutron excess '/ 
      R_Z_Curv_S0 = 8.E0 / REAL(I_Z_CN)**2 * Masscurv(REAL(I_Z_CN),
     *REAL(I_A_CN),RI,kappa) 
      R_Z_Curv1_S0 = 8.E0 / REAL(I_Z_CN)**2 * Masscurv1(REAL(I_Z_CN),
     *REAL(I_A_CN),RI,kappa) 
      R_A_Curv1_S0 = 8.E0 / REAL(I_A_CN)**2 * Masscurv1(REAL(I_Z_CN),
     *REAL(I_A_CN),RI,kappa) 
C     ' 
C     ' 
C     ' 
C     /' Energy transformation '/ 
C     ' 
      Select CASE( Emode) 
      CASE( 0) 
C     ' Energy above outer barrier given 
      R_E_exc_Eb = R_E_exc_used 
      R_E_exc_GS = R_E_exc_used + BFTFB(REAL(I_Z_CN),REAL(I_A_CN),1) 
      CASE( 1,3,-1) 
C     ' Energy above ground state given 
      R_E_exc_Eb = R_E_exc_used - BFTFB(REAL(I_Z_CN),REAL(I_A_CN),1) 
      R_E_exc_GS = R_E_exc_used 
      CASE( 2) 
C     ' kinetic energy of neutron given 
      SN = (U_Mass(REAL(I_Z_CN),REAL(I_A_CN-1)) + Lypair(I_Z_CN,
     *I_A_CN-1)) -(U_Mass(REAL(I_Z_CN),REAL(I_A_CN)) + Lypair(I_Z_CN,
     *I_A_CN)) 
      R_E_exc_GS = R_E_exc_used + SN 
      R_E_exc_Eb = R_E_exc_GS - BFTFB(REAL(I_Z_CN),REAL(I_A_CN),1) 
      End Select 
C     ' 
C     ' 
C     /' Fission barriers -> global parameters '/ 
C     ' 
      B_F = BFTF(REAL(I_Z_CN),REAL(I_A_CN),1) 
      B_F_ld = BFTF(REAL(I_Z_CN),REAL(I_A_CN),0) 
      E_B = BFTFB(REAL(I_Z_CN),REAL(I_A_CN),1) 
      E_B_ld = BFTFB(REAL(I_Z_CN),REAL(I_A_CN),0) 
C     ' 
C     ' 
C     /' Barriers and excitation energies of the fission modes '/ 
C     ' 
      E_exc_S0_prov = R_E_exc_Eb 
C     ' 
C     ' 
C     /' Additional influence of N=82 assumed '/ 
      Delta_NZ_Pol = 82.E0/50.E0 - REAL(I_N_CN)/REAL(I_Z_CN) 
      R_Shell_S1_eff = P_Shell_S1 * (1.E0 - P_Att_Pol * 
     *Abs(Delta_NZ_Pol)) 
C     ' 
C     /' In Pu,the Z=50 shell meets Z=44 in the light fragment. '/ 
C     /' A deformed shell at Z=44 is assumed to explain the enhancement        of the S1 channel around Pu '/ 
C     /' This very same shell automatically produces the double-humped '/ 
C     /' mass distribution in 180Hg '/ 
      S1_enhance = P_Shell_S4 + (REAL(I_Z_CN) - ZC_Mode_1 - 
     *ZC_Mode_4)**2 * P_Z_Curv_S4 
      IF (  S1_enhance .GT. 0  )  S1_enhance = 0 
      R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance 
C     ' 
C     ' 
C     ' Influence of S2 shell in complementary fragment 
C     ' May be called "S12 fission channel" 
      T_Asym_Mode_2 = 0.5 
      SigZ_Mode_2 = SQRT(0.5E0 * T_Asym_Mode_2/(P_Z_Curv_S2)) 
      SigA_Mode_2 = SigZ_Mode_2 * REAL(I_A_CN) / REAL(I_Z_CN) 
      S1_enhance = P_Shell_S2 * U_Box(REAL(P_A_CN) - AC_Mode_2 - 
     *AC_Mode_1,SigA_Mode_2,P_A_Width_S2) *P_A_Width_S2 
      IF (  S1_enhance .LT. 0.01  ) THEN 
      R_Shell_S1_eff = R_Shell_S1_eff + S1_enhance 
      End If 
C     ' Modify deformation of complementary fragment in corresponding analyzer 
C     ' 
C     ' 
C     ' 
      R_Shell_S3_eff = P_Shell_S3 * (1.E0 - PZ_S3_olap_curv         * 
     *(REAL(I_Z_CN) - 60.5E0 - PZ_S3_olap_pos)**2) 
      R_Shell_S3_eff = Min(R_Shell_S3_eff,0.0) 
C     ' 
      R_Shell_S4_eff = P_Shell_S4 
C     ' 
      E_ld_S1 = R_A_Curv1_S0 * (REAL(I_A_CN)/REAL(I_Z_CN)*(ZC_MODE_1 - 
     *ZC_MODE_0) )**2 
      B_S1 = E_ld_S1 + R_Shell_S1_eff 
      E_exc_S1_prov = E_Exc_S0_prov - B_S1 
C     ' 
      E_ld_S2 = R_A_Curv1_S0 * (REAL(I_A_CN)/REAL(I_Z_CN)*(ZC_MODE_2 - 
     *ZC_MODE_0) )**2 
      B_S2 = E_ld_S2 + P_Shell_S2 
      E_exc_S2_prov = E_Exc_S0_prov - B_S2 
C     ' 
      E_ld_S3 = R_A_Curv1_S0 * (REAL(I_A_CN)/REAL(I_Z_CN)*(ZC_MODE_3 - 
     *ZC_MODE_0) )**2 
      B_S3 = E_ld_S3 + R_Shell_S3_eff 
      E_exc_S3_prov = E_Exc_S0_prov - B_S3 
C     ' 
      IF (  I_A_CN .LT. 220  ) THEN 
C     ' Only here S4 is close enough to symmetry to have a chance 
      E_ld_S4 = R_A_Curv1_S0 * (REAL(I_A_CN)/REAL(I_Z_CN)*(ZC_MODE_4 - 
     *ZC_MODE_0) )**2 
      B_S4 = E_ld_S4 + R_Shell_S4_eff 
      E_exc_S4_prov = E_Exc_S0_prov - B_S4 
      Else 
      B_S4 = 9999 
      E_exc_S4_prov = - 9999 
      End If 
C     ' 
C     /' Mode 11 (overlap of channel 1 in light and heavy fragment '/ 
C     /' Potential depth with respect to liquid-drop potential: B_S11 '/ 
      B_S11 = 2.E0 * (R_Shell_S1_eff + De_Defo_S1              + 
     *P_Z_Curv_S1 * (ZC_Mode_1 - ZC_Mode_0)**2 ) - De_Defo_S1 
C     ' 
C     '  If B_S11 > R_Shell_S1_eff + 0.5E0 Then 
      IF (  B_S11 .GT. R_Shell_S1_eff + Level_S11  ) THEN 
      B_S11 = 100 
C     ' S1 and S11 are exclusive 
      Else 
      B_S11 = Min(B_S11,R_Shell_S1_eff) 
      End If 
C     ' 
C     /' Lowering of effective barrier by lower ZPM due to larger width in 
C     partial overlap region (shells in light and heavy fragment) '/ 
      DES11ZPM = - 0.2E0 * (2.E0 * Abs(ZC_Mode_1 - ZC_Mode_0) ) 
      DES11ZPM = Min(0.0,DES11ZPM) 
      B_S11 = B_S11 + DES11ZPM 
C     ' 
      E_exc_S11_prov = E_Exc_S0_prov - B_S11 
C     ' 
C     /' Mode 22 (overlap of channel 2 in light and heavy fragment '/ 
C     /' Potential depth with respect to liquid-drop potential: B_S22 '/ 
C     ' 
C     '   B_S22 = 2.E0 * (E_ld_S2 + P_Shell_S2)  '       + 2.E0 * P_Z_Curv_S2 * (ZC_Mode_2 - ZC_Mode_0)^2   /' Parabola '/ 
C     'Print E_ld_S2,P_Shell_S2,P_Z_Curv_S2,ZC_Mode_2,ZC_Mode_0 
      B_S22 = 2.E0 * P_Shell_S2 * U_Box(REAL(P_A_CN)/2.0 - AC_Mode_2,
     *SigA_Mode_2,P_A_Width_S2) * P_A_Width_S2 
C     ' The integral of U_Box is normalized,not the height! 
C     ' 
      E_exc_S22_prov = E_Exc_S0_prov - B_S22 
C     ' 
C     ' 
      E_Min_Barr = Min(0.0,B_S1) 
      E_Min_Barr = Min(E_Min_Barr,B_S2) 
      E_Min_Barr = Min(E_Min_Barr,B_S3) 
      E_Min_Barr = Min(E_Min_Barr,B_S4) 
      E_Min_Barr = Min(E_Min_Barr,B_S11) 
      E_Min_Barr = Min(E_Min_Barr,B_S22) 
C     ' 
C     /' Energy minus the height of the respective fission saddle '/ 
      E_exc_S0 = E_exc_S0_prov + E_Min_Barr - Delta_S0 
      E_exc_S1 = E_exc_S1_prov + E_Min_Barr 
      E_exc_S2 = E_exc_S2_prov + E_Min_Barr 
      E_exc_S3 = E_exc_S3_prov + E_Min_Barr 
      E_exc_S4 = E_exc_S4_prov + E_Min_Barr 
      E_exc_S11 = E_exc_S11_prov + E_Min_Barr 
      E_exc_S22 = E_exc_S22_prov + E_Min_Barr 
C     ' 
C     /' Energy above the lowest fission saddle '/ 
      E_exc_Barr = Max(E_Exc_S0,E_Exc_S1) 
      E_exc_Barr = Max(E_exc_Barr,E_Exc_S2) 
      E_exc_Barr = Max(E_exc_Barr,E_Exc_S3) 
      E_exc_Barr = Max(E_exc_Barr,E_Exc_S4) 
      E_exc_Barr = Max(E_exc_Barr,E_exc_S11) 
      E_exc_Barr = Max(E_exc_Barr,E_exc_S22) 
C     ' 
C     ' 
C     /' Collective temperature used for calculating the widths 
C     in mass asymmetry and charge polarization '/ 
C     ' 
      IF (  E_Exc_S0 .LT. 0  ) THEN 
      E_tunn = -E_Exc_S0
      Else
      E_tunn = 0
      END IF
      R_E_exc_eff = Max(0.1,E_Exc_S0) 
C     '  T_Coll_Mode_0 = TFCOLL * R_E_exc_eff + _  /' empirical,replaced by TRusanov '/ 
      T_Coll_Mode_0 = TCOLLFRAC * (De_Saddle_Scission(REAL(I_Z_CN)**2 / 
     *           REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
      T_Coll_Mode_0 = Max(T_Coll_Mode_0,0.0) 
C     ' 
C     ' Print "T_Coll ";De_Saddle_Scission(I_Z_CN^2/I_A_CN^0.3333),E_tunn,T_Coll_Mode_0 
C     ' 
C     /' Temperature description fitting to the empirical systematics of Rusanov et al. '/ 
C     /' Here from Ye. N. Gruzintsev et al.,Z. Phys. A 323 (1986) 307 '/ 
C     /' Empirical description of the nuclear temperature according to the '/ 
C     /' Fermi-gas description. Should be valid at higher excitation energies '/ 
      T_Rusanov = TRusanov(R_E_exc_eff,REAL(I_A_CN)) 
C     '  Print "Temperatures,(GEF,Total,Rusanov): ",T_Coll_Mode_0,TFCOLL * R_E_exc_eff,T_Rusanov 
      T_Coll_Mode_0 = Max(T_Coll_Mode_0,T_Rusanov) 
C     /' Transition vom const. temp. to Fermi gas occurs around 20 MeV by MAX function '/ 
C     ' 
      T_Pol_Mode_0 = T_Pol_Red * T_Coll_Mode_0 
      T_Asym_Mode_0 = SQRT(T_Coll_Mode_0**2 + TCOLLMIN**2) 
C     ' 
      E_pot_scission = (De_Saddle_Scission(REAL(I_Z_CN)**2 /            
     *    REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_intr) - E_tunn) 
C     ' 
C     /' Suppression of S1 fission channel due to reduced pairing in 132Sn '/ 
C     /' At very low excitation energy on the fission path,the binding energy at the 
C     S1 fission channel does not profit as much from pairing as SL and S2, 
C     because pairing is reduced in magic nuclei. This leads to a reduction of 
C     the yield in S1 in the case that the fully paired ground-state configuration 
C     is populated on the fission path with a considerable probability. '/ 
C     '   EeffS2 = Max(E_exc_S2,0.0) + EDISSFRAC * E_pot_scission - 2.3E0 
C     '   EeffS2 = Max(0.0,EeffS2) 
C     /' -2.3 MeV,because fission channels are assumed to be chosen before scission '/ 
C     ' 
C     '   If EeffS2 < ETHRESHSUPPS1 + 2.E0 * ESIGSUPPS1 Then 
C     '     E_exc_S1 = E_exc_S1 -  '        0.5E0 * 4.E0 * 12.E0 / Sqr(132.E0) * Gaussintegral(ETHRESHSUPPS1 - EeffS2,ESIGSUPPS1) 
C     '   EndIf 
C     ' 
      T_low_S1_used = T_low_S1 
C     ' 
      T_Coll_Mode_1 = TFCOLL * Max(E_exc_S1,0.E0) + TCOLLFRAC * 
     *(De_Saddle_Scission(I_Z_CN**2 / I_A_CN**0.33333E0,
     *ESHIFTSASCI_coll) - E_tunn) 
      T_Coll_Mode_1 = Max(T_Coll_mode_1,0.0) 
      T_Pol_Mode_1 = T_Pol_Red * T_Coll_Mode_1 
      T_Asym_Mode_1 = SQRT(T_Coll_Mode_1**2 + (6.E0*TCOLLMIN)**2) 
C     ' TCOLLMIN for ZPM 
C     ' 
      T_Coll_Mode_2 = TFCOLL * Max(E_exc_S2,0.E0) + TCOLLFRAC * 
     *(De_Saddle_Scission(REAL(I_Z_CN)**2 /           
     *REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
      T_Coll_Mode_2 = Max(T_Coll_mode_2,0.0) 
      T_Pol_Mode_2 = T_Pol_Red * T_Coll_Mode_2 
      T_Asym_Mode_2 = SQRT(T_Coll_Mode_2**2 + TCOLLMIN**2) 
C     ' 
      T_Coll_Mode_3 = TFCOLL * Max(E_exc_S3,0.E0) + TCOLLFRAC * 
     *(De_Saddle_Scission(REAL(I_Z_CN)**2 /             
     *REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
      T_Coll_Mode_3 = Max(T_Coll_mode_3,0.0) 
      T_Pol_Mode_3 = T_Pol_Red * T_Coll_Mode_3 
      T_Asym_Mode_3 = SQRT(T_Coll_Mode_3**2 + TCOLLMIN**2) 
C     ' 
      T_Coll_Mode_4 = TFCOLL * Max(E_exc_S4,0.E0) + TCOLLFRAC * 
     *(De_Saddle_Scission(REAL(I_Z_CN)**2 /              
     *REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
      T_Coll_Mode_4 = Max(T_Coll_mode_4,0.0) 
      T_Pol_Mode_4 = T_Pol_Red * T_Coll_Mode_4 
      T_Asym_Mode_4 = SQRT(T_Coll_Mode_4**2 + TCOLLMIN**2) 
C     ' 
C     /' Stiffness in polarization '/ 
C     ' 
      RZ = REAL(I_Z_CN) * 0.5E0 
      RA = REAL(I_A_CN) * 0.5E0 
      beta1 = Beta(0,1,NINT(RZ)) 
      beta2 = Beta(0,2,NINT(RZ)) 
      R_Pol_Curv_S0 = ( LyMass( RZ - 1.E0,RA,beta1 ) +              
     *LyMass( RZ + 1.0E0,RA,beta2 ) +              LyMass( RZ + 1.0E0,
     *RA,beta1 ) +              LyMass( RZ - 1.0E0,RA,beta2 ) +         
     *     ecoul( RZ - 1.0E0,RA,beta1,RZ + 1.0E0,RA,beta2,dneck) +      
     *        ecoul( RZ + 1.0E0,RA,beta1,RZ - 1.0E0,RA,beta2,dneck) -   
     *       2.0E0*ecoul( RZ,RA,beta1,RZ,RA,beta2,dneck) -          
     *2.0E0*LyMass( RZ,RA,beta1 ) -          2.0E0*LyMass( RZ,RA,beta2) 
     *) * 0.5E0 
C     ' 
      P_Pol_Curv_S0 = R_Pol_Curv_S0 
C     ' 
      R_Pol_Curv_S1 = R_Pol_Curv_S0 
      R_Pol_Curv_S2 = R_Pol_Curv_S0 
      R_Pol_Curv_S3 = R_Pol_Curv_S0 
      R_Pol_Curv_S4 = R_Pol_Curv_S0 
C     ' 
C     ' 
C     ' 
C     /' Mean values and standard deviations of fission modes '/ 
C     ' 
      SIGZ_Mode_0 = SQRT(0.5E0 * T_Asym_Mode_0/R_Z_Curv_S0) 
      IF (  T_Pol_Mode_0 .GT. 1.E-2  ) THEN 
      SigPol_Mode_0 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S0 /            
     *          Tanh(HOMPOL/(2.E0 * T_Pol_Mode_0))) 
      Else 
      SigPol_Mode_0 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S0) 
C     /' including influence of zero-point motion '/ 
      END IF 
C     ' 
      R_E_intr_S1 = Max(E_Exc_S1+Lypair(I_Z_CN,I_A_CN),0.0) 
      R_Att(1) = exp(-R_E_intr_S1/Shell_fading) 
      R_Att(5) = R_Att(1) 
      R_Att_Sad(1) = exp(-R_E_intr_S1/Shell_fading) 
      R_Att_Sad(5) = R_Att_Sad(1) 
      SIGZ_Mode_1 = SQRT(0.5E0 * 
     *T_Asym_Mode_1/(P_Z_Curv_S1*SQRT(R_Att(1)))) 
      IF (  T_Pol_Mode_1 .GT. 1.E-2  ) THEN 
      SigPol_Mode_1 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S1 /            
     *          Tanh(HOMPOL/(2.E0 * T_Pol_Mode_1))) 
      Else 
      SigPol_Mode_1 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S1) 
      END IF 
C     ' 
      R_E_intr_S2 = Max(E_Exc_S2+Lypair(I_Z_CN,I_A_CN),0.0) 
      R_Att(2) = exp(-R_E_intr_S2/Shell_fading) 
      R_Att(6) = R_Att(2) 
      R_Att_Sad(2) = exp(-R_E_intr_S2/Shell_fading) 
      R_Att_Sad(6) = R_Att_Sad(2) 
      SIGZ_Mode_2 = SQRT(0.5E0 * 
     *T_Asym_Mode_2/(P_Z_Curv_S2*SQRT(R_Att(2)))) 
      IF (  T_Pol_Mode_2 .GT. 1.E-2  ) THEN 
      SigPol_Mode_2 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S2 /            
     *          Tanh(HOMPOL/(2.E0 * T_Pol_Mode_2))) 
      Else 
      SigPol_Mode_2 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S2) 
      End If 
C     ' 
      R_E_intr_S3 = Max(E_exc_S3+Lypair(I_Z_CN,I_A_CN),0.0) 
      R_Att(3) = exp(-R_E_intr_S3/Shell_fading) 
      R_Att_Sad(3) = exp(-R_E_intr_S3/Shell_fading) 
      SIGZ_Mode_3 = SQRT(0.5E0 * 
     *T_Asym_Mode_3/(P_Z_Curv_S3*SQRT(R_Att(3)))) 
      IF (  T_Pol_Mode_3 .GT. 1.E-2  ) THEN 
      SigPol_Mode_3 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S3 /            
     *          Tanh(HOMPOL/(2.E0 * T_Pol_Mode_3))) 
      Else 
      SigPol_Mode_3 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S3) 
      End if 
C     ' 
      R_E_intr_S4 = Max(E_exc_S4+Lypair(I_Z_CN,I_A_CN),0.0) 
      R_Att(4) = exp(-R_E_intr_S4/Shell_fading) 
      R_Att_Sad(4) = exp(-R_E_intr_S4/Shell_fading) 
      SIGZ_Mode_4 = SQRT(0.5E0 * 
     *T_Asym_Mode_4/(P_Z_Curv_S4*SQRT(R_Att(4)))) 
      IF (  T_Pol_Mode_4 .GT. 1.E-2  ) THEN 
      SigPol_Mode_4 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S4 /            
     *          Tanh(HOMPOL/(2.E0 * T_Pol_Mode_4))) 
      Else 
      SigPol_Mode_4 = SQRT(0.25E0 * HOMPOL / R_Pol_Curv_S4) 
      End if 
C     ' 
C     ' 
C     ' 
C     /' Energy-dependent shift of fission channels '/ 
C     '    Scope 
      P_Z_Curv_S1_eff = P_Z_Curv_S1 * P_Z_Curvmod_S1 
      P_Z_Curv_S2_eff = P_Z_Curv_S2 * P_Z_Curvmod_S2 
C     ' 
      DZ_S1 = ZC_Mode_1 * (P_Z_Curv_S1_eff*R_Att(1) / (R_Z_Curv_S0 + 
     *P_Z_Curv_S1_eff*R_Att(1))             - (P_Z_Curv_S1_eff / 
     *(R_Z_Curv_S0 + P_Z_Curv_S1_eff) ) ) 
      DZ_S2 = ZC_Mode_2 * (P_Z_Curv_S2_eff*R_Att(2) / (R_Z_Curv_S0 + 
     *P_Z_Curv_S2_eff*R_Att(2))              - (P_Z_Curv_S2_eff / 
     *(R_Z_Curv_S0 + P_Z_Curv_S2_eff) ) ) 
      DZ_S3 = ZC_Mode_3 * (P_Z_Curv_S3*R_Att(3) / (R_Z_Curv_S0 + 
     *P_Z_Curv_S3*R_Att(3))              - (P_Z_Curv_S3 / (R_Z_Curv_S0 
     *+ P_Z_Curv_S3) ) ) 
      DZ_S4 = ZC_Mode_4 * (P_Z_Curv_S4*R_Att(4) / (R_Z_Curv_S0 + 
     *P_Z_Curv_S4*R_Att(4))              - (P_Z_Curv_S4 / (R_Z_Curv_S0 
     *+ P_Z_Curv_S4) ) ) 
C     ' 
C     '   DZ_S1 = 0 
C     '   DZ_S2 = 0 
C     '   DZ_S3 = 0 
C     '   DZ_S4 = 0 
C     ' 
C     ' 
      P_Z_Mean_S0 = ZC_Mode_0 
      ZC_Mode_1 = ZC_Mode_1 + DZ_S1 
      P_Z_Mean_S1 = ZC_Mode_1 
C     /' Copy to global parameter '/ 
      ZC_Mode_2 = ZC_Mode_2 + DZ_S2 
      P_Z_Mean_S2 = ZC_Mode_2 
C     /'             "            '/ 
      ZC_Mode_3 = ZC_Mode_3 + DZ_S3 
      P_Z_Mean_S3 = ZC_Mode_3 
      ZC_Mode_4 = ZC_Mode_4 + DZ_S4 
      P_Z_Mean_S4 = ZC_Mode_4 
C     '    End Scope 
C     ' 
C     ' 
C     /' Energy dependence of charge polarization '/ 
C     /' Due to washing out of shells '/ 
C     ' 
      DO I = 10 , I_A_CN - 10 
C     ' mass number 
      DO J = 1 , 4 
C     ' fission channel 
      DO K = 1 , 2 
C     ' light - heavy group 
      Zshift(J,K,I) = Zshift(0,K,I) + (Zshift(J,K,I) - Zshift(0,K,
     *I))*R_Att(J) 
      END DO 
      END DO 
      END DO 
C     ' 
C     ' 
C     /' Energy dependence of shell-induced deformation '/ 
C     /' Due to washing out of shells '/ 
C     /' (Under development) '/ 
C     /' For I = 10 To I_Z_CN - 10  ' mass number 
C     For J = 1 To 4           ' fission channel 
C     For K = 1 To 2         ' light - heavy group 
C     beta(J,K,I) = beta(0,K,I) + (beta(J,K,I) - beta(0,K,I))*R_Att_Sad(J) 
C     if beta(J,K,I) < 0 Then 
C     beta(J,K,I) = 0 
C     End If 
C     Z1 = I 
C     Z2 = I_Z_CN - Z1 
C     A1 = Z1 / Csng(I_Z_CN) * Csng(I_A_CN) 
C     A2 = I_A_CN - A1 
C     E_defo = Lymass(Z1,A1,beta(J,K,I)) - Lymass(Z1,A1,0.0) 
C     Edefo(J,K,I) = E_defo 
C     Next 
C     Next 
C     Next  '/ 
C     ' 
C     ' 
C     ' 
C     ' 
C     /' General relations between Z and A of fission channels '/ 
C     /' 2nd iteration '/ 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_0 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(0,2,NINT(RA)) 
      END DO 
      AC_Mode_0 = (ZC_Mode_0 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
C     /' mean position in mass '/ 
      NC_Mode_0 = AC_Mode_0 - ZC_Mode_0 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_1 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(1,2,NINT(RA)) 
      END DO 
      AC_Mode_1 = (ZC_Mode_1 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_1 = AC_Mode_1 - ZC_Mode_1 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_2 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(2,2,NINT(RA)) 
      END DO 
      AC_Mode_2 = (ZC_Mode_2 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_2 = AC_Mode_2 - ZC_Mode_2 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_3 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(3,2,NINT(RA)) 
      END DO 
      AC_Mode_3 = (ZC_Mode_3 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_3 = AC_Mode_3 - ZC_Mode_3 
C     ' 
      RZpol = 0 
      DO I = 1 , 3 
      RA = (ZC_Mode_4 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      RZpol = Zshift(4,2,NINT(RA)) 
      END DO 
      AC_Mode_4 = (ZC_Mode_4 - RZPol) * REAL(I_A_CN) / REAL(I_Z_CN) 
      NC_Mode_4 = AC_Mode_4 - ZC_Mode_4 
C     ' 
C     ' 
C     ' 
C     /' Yields of the fission modes '/ 
C     ' 
      Yield_Mode_0 = Getyield(E_exc_S0,E_exc_S0,T_low_SL,
     *TEgidy(REAL(I_A_CN),0.E0,Tscale)) 
      Yield_Mode_0 = Max(Yield_Mode_0,0.0) 
C     ' 
      Yield_Mode_1 = Getyield(E_exc_S1,E_exc_S0,T_low_S1_used,
     *TEgidy(REAL(I_A_CN),R_Shell_S1_eff + dE_Defo_S1,Tscale)) 
C     /'  - Getyield(E_exc_S0 - E_ld_S1,T_low,T_high); '/ 
      Yield_Mode_1 = Max(Yield_Mode_1,0.0) 
C     ' 
      Yield_Mode_2 = Getyield(E_exc_S2,E_exc_S0,T_low_S2,
     *TEgidy(REAL(I_A_CN),P_Shell_S2 + dE_Defo_S2,Tscale)) 
C     /'  - Getyield(E_exc_S0 - E_ld_S2,T_low,T_high); '/ 
      Yield_Mode_2 = Max(Yield_Mode_2,0.0) 
C     ' 
      Yield_Mode_3 = Getyield(E_exc_S3,E_exc_S0,T_low_S3,
     *TEgidy(REAL(I_A_CN),R_Shell_S3_eff + dE_Defo_S3,Tscale)) 
C     /'  - Getyield(E_exc_S0 - E_ld_S3,T_low,T_high); '/ 
      Yield_Mode_3 = Max(Yield_Mode_3,0.0) 
C     ' 
      Yield_Mode_4 = Getyield(E_exc_S4,E_exc_S0,T_low_S4,
     *TEgidy(REAL(I_A_CN),R_Shell_S4_eff + dE_Defo_S4,Tscale)) 
C     /'  - Getyield(E_exc_S0 - E_ld_S4,T_low,T_high); '/ 
      Yield_Mode_4 = Max(Yield_Mode_4,0.0) 
C     ' 
      IF (  B_S11 .GT. 0  ) THEN 
      Yield_Mode_11 = 0.0 
      Else 
      Yield_Mode_11 = Getyield(E_exc_S11,E_exc_S0,T_low_S11,
     *TEgidy(REAL(I_A_CN),R_Shell_S1_eff + 2.E0 * dE_Defo_S1,Tscale)) 
      End If 
C     ' 
      IF (  B_S22 .GT. B_S2  ) THEN 
      Yield_Mode_22 = 0.0 
      Else 
      Yield_Mode_22 = Getyield(E_exc_S22,E_exc_S0,T_low_S2,
     *TEgidy(REAL(I_A_CN),P_Shell_S2,Tscale)) 
      End If 
C     ' 
C     ' 
      Yield_Norm = Yield_Mode_0 + Yield_Mode_1 + Yield_Mode_2 + 
     *Yield_Mode_3 + Yield_Mode_4 + Yield_Mode_11 + Yield_Mode_22 
      Yield_Mode_0 = Yield_Mode_0 / Yield_Norm 
      Yield_Mode_1 = Yield_Mode_1 / Yield_Norm 
      Yield_Mode_2 = Yield_Mode_2 / Yield_Norm 
      Yield_Mode_3 = Yield_Mode_3 / Yield_Norm 
      Yield_Mode_4 = Yield_Mode_4 / Yield_Norm 
      Yield_Mode_11 = Yield_Mode_11 / Yield_Norm 
      Yield_Mode_22 = Yield_Mode_22 / Yield_Norm 
C     ' 
C     ' 
C     /' Mass widhts of the fission channels '/ 
C     ' 
      SigA_Mode_0 = SigZ_Mode_0 * REAL(I_A_CN) / REAL(I_Z_CN) 
C     /' width in mass '/ 
      SigA_Mode_1 = SigZ_Mode_1 * REAL(I_A_CN) / REAL(I_Z_CN) 
      SigA_Mode_1 = Min(SigA_Mode_1,SigA_Mode_0) 
C     ' not broader than liquid-drop 
      SigA_Mode_2 = SigZ_Mode_2 * REAL(I_A_CN) / REAL(I_Z_CN) 
      SigA_Mode_2 = Min(SigA_Mode_2,SigA_Mode_0) 
C     ' not broader than liquid-drop 
      SigA_Mode_3 = SigZ_Mode_3 * REAL(I_A_CN) / REAL(I_Z_CN) 
      SigA_Mode_3 = Min(SigA_Mode_3,SigA_Mode_0) 
      SigA_Mode_4 = SigZ_mode_4 * REAL(I_A_CN) / REAL(I_Z_CN) 
      SigA_Mode_4 = Min(SigA_Mode_4,SigA_Mode_0) 
      SigA_Mode_11 = SigZ_Mode_1 * SQRT(2.E0) * REAL(I_A_CN) / 
     *REAL(I_Z_CN) 
      SigA_Mode_11 = Min(SigA_Mode_11,SigA_Mode_0) 
      SigA_Mode_22 = SigZ_Mode_2 * SQRT(2.E0) * REAL(I_A_CN) / 
     *REAL(I_Z_CN) 
      SigA_Mode_22 = Min(SigA_Mode_22,SigA_Mode_0) 
C     ' 
C     ' 
C     ' 
C     /' Shell effects of different fission channels '/ 
C     /' This is the "real" microscopic shell effect,not the effective shell-correction energy '/ 
C     /' EShell acts on the level density and determines the T parameter '/ 
C     ' 
      DO I = 1 , I_A_CN - 1 
      DO J = 0 , 4 
      EShell(J,1,I) = 0 
C     /' Shells in "light" fragment assumed to be zero '/ 
      END DO 
      DU0 = 0 
      EShell(0,2,I) = 0 
C     /' Shell = 0 in symmetric mode '/ 
      DU1 = R_Shell_S1_eff + dE_Defo_S1 
C     /' + R_A_Curv1_S1 * (AC_Mode_1 - Float(I,6))**2; '/ 
      DU1 = MIN(DU1,0.E0) 
C     /' Technical limit '/ 
      EShell(1,2,I) = DU1 
C     ' 
      DU2 = P_Shell_S2 + dE_Defo_S2 
C     /' + R_A_Curv1_S2 * (AC_Mode_2 - Float(I,6))**2; '/ 
      DU2 = Min(DU2,0.E0) 
C     /' Technical limit '/ 
      EShell(2,2,I) = DU2 
C     ' 
      DU3 = R_Shell_S3_eff + dE_Defo_S3 
C     /' + R_A_Curv1_S3 * (AC_Mode_3 - Float(I,6))**2; '/ 
      DU3 = Min(DU3,0.E0) 
C     /' Technical limit '/ 
      EShell(3,2,I) = DU3 
C     ' 
      DU4 = R_Shell_S4_eff + dE_Defo_S4 
C     /' + R_A_Curv1_S4 * (AC_Mode_4 - Float(I,6))**2; '/ 
      DU4 = Min(DU4,0.E0) 
C     /' Technical limit '/ 
      EShell(4,2,I) = DU4 
C     ' 
      END DO 
C     ' 
C     ' 
C     /' Intrinsic temperatures of fragments at scission '/ 
C     ' 
C     /' Mean values '/ 
      T_intr_Mode_0 = TEgidy(AC_Mode_0,0.0,0.8) 
      T_intr_Mode_1_heavy = TEgidy(AC_Mode_1,R_Shell_S1_eff + 
     *dE_Defo_S1,Tscale) 
      T_intr_Mode_1_light = TEgidy(REAL(I_A_CN) - AC_Mode_1,0.0,Tscale) 
      T_intr_Mode_2_heavy = TEgidy(AC_Mode_2,P_Shell_S2 + dE_Defo_S2,
     *Tscale) 
      T_intr_Mode_2_light = TEgidy(REAL(I_A_CN) - AC_Mode_2,0.0,Tscale) 
      T_intr_Mode_3_heavy = TEgidy(AC_Mode_3,R_Shell_S3_eff + 
     *dE_Defo_S3,Tscale) 
      T_intr_Mode_3_light = TEgidy(REAL(I_A_CN) - AC_Mode_3,0.0,Tscale) 
      T_intr_Mode_4_heavy = TEgidy(AC_Mode_4,R_Shell_S4_eff + 
     *dE_Defo_S4,Tscale) 
      T_intr_Mode_4_light = TEgidy(REAL(I_A_CN) - AC_Mode_4,0.0,Tscale) 
C     ' 
C     ' 
C     /' Mass-dependent values of individual fragments '/ 
C     /' Mode 0 '/ 
      DO I = 1 , I_A_CN - 1 
      T = TEgidy(REAL(I),EShell(0,1,I),Tscale) 
      Temp(0,1,I) = T 
C     /' "light" fragment at freeze-out (somewhere before scission) '/ 
      T = TEgidy(REAL(I),EShell(0,2,I),Tscale) 
      Temp(0,2,I) = T 
C     /' "heavy" fragment at freeze-out (somewhere before scission) '/ 
C     ' 
      T = TEgidy(REAL(I),0.0,1.0) 
      TempFF(0,1,I) = T 
C     ' FF in their ground state 
      TempFF(0,2,I) = T 
C     ' FF in their ground state 
      END DO 
C     ' 
C     /' Mode 1 '/ 
      DO I = 1 , I_A_CN - 1 
      T = TEgidy(REAL(I),EShell(1,1,I),Tscale) 
      Temp(1,1,I) = T 
C     /' "light" fragment '/ 
      T = TEgidy(REAL(I),EShell(1,2,I),Tscale) 
      Temp(1,2,I) = T 
C     /' "heavy" fragment '/ 
C     ' 
      T = TEgidy(REAL(I),0.0,1.0) 
      TempFF(1,1,I) = T 
C     ' FF in their ground state 
      TempFF(1,2,I) = T 
C     ' FF in their ground state 
      END DO 
C     ' 
C     /' Mode 2 '/ 
      DO I = 1 , I_A_CN - 1 
      T = TEgidy(REAL(I),EShell(2,1,I),Tscale) 
      Temp(2,1,I) = T 
C     /' "light" fragment '/ 
      T = TEgidy(REAL(I),EShell(2,2,I),Tscale) 
      Temp(2,2,I) = T 
C     /' "heavy" fragment '/ 
C     ' 
C     /' The next section is introduced,because energy sorting is not strong enough, 
C     when shells are only introduced in the heavy fragment. 
C     Ad hoc assumption: For Mode 2 there are shells in both fragments of about 
C     equal size. Technically,we neglect the shells in both fragments. 
C     This has about the same effect for the energy sorting. '/ 
      T = TEgidy(REAL(I),0.0,Tscale) 
C     ' FF at scssion 
      Temp(2,1,I) = T 
C     /' "light" fragment '/ 
      T = TEgidy(REAL(I),0.0,Tscale) 
C     ' FF at scission 
      Temp(2,2,I) = T 
C     /' "heavy" fragment '/ 
C     ' 
      T = TEgidy(REAL(I),0.0,1.0) 
C     ' shell effect neglected 
      TempFF(2,1,I) = T 
C     ' FFs in their ground state 
      TempFF(2,2,I) = T 
C     ' FFs in their ground state 
      END DO 
C     ' 
C     /' Mode 3 '/ 
      DO I = 1 , I_A_CN -1 
      T = TEgidy(REAL(I),0.0,Tscale) 
      Temp(3,1,I) = T 
      T = TEgidy(REAL(I),0.0,Tscale) 
      Temp(3,2,I) = T 
C     ' 
      T = TEgidy(REAL(I),0.0,1.0) 
      TempFF(3,1,I) = T 
C     ' FF in their ground state 
      TempFF(3,2,I) = T 
C     ' FF in their ground state 
      END DO 
C     ' 
C     /' Mode 4 '/ 
      DO I = 1 , I_A_CN -1 
      T = TEgidy(REAL(I),0.0,Tscale) 
      Temp(4,1,I) = T 
      T = TEgidy(REAL(I),0.0,Tscale) 
      Temp(4,2,I) = T 
C     ' 
      T = TEgidy(REAL(I),0.0,1.0) 
      TempFF(4,1,I) = T 
C     ' FF in their ground state 
      TempFF(4,2,I) = T 
C     ' FF in their ground state 
      END DO 
C     ' 
C     ' 
C     /'** Intrinsic excitation energy at saddle and at scission as well as   **'/ 
C     /'** Even-odd effect in proton and neutron number for each fission mode **'/ 
      DO I_Mode = 0 , 6 
      E_coll_saddle(I_Mode) = 0 
      IF (  I_Mode .EQ. 0  )  Etot = E_exc_S0 
      IF (  I_Mode .EQ. 1  )  Etot = E_exc_S1 
      IF (  I_Mode .EQ. 2  )  Etot = E_exc_S2 
      IF (  I_Mode .EQ. 3  )  Etot = E_exc_S3 
      IF (  I_Mode .EQ. 4  )  Etot = E_exc_S4 
      IF (  I_Mode .EQ. 5  )  Etot = E_exc_S11 
      IF (  I_Mode .EQ. 6  )  Etot = E_exc_S22 
      IF (   MOD(I_Z_CN,2)  +  MOD(I_N_CN,2)  .EQ. 0  ) THEN 
C     /' Even-even CN '/ 
      IF (  Etot .GT. 0 .AND. Etot .LT. 2.E0 * 12.E0/SQRT(REAL(I_A_CN)) 
     * ) THEN 
      E_coll_saddle(I_Mode) = Etot 
      Etot = 0 
C     /' Excitation below the pairing gap in even-even CN goes into collective excitations '/ 
      End If 
      End If 
      Etot = Max(Etot,0.0) 
      Etot = Etot + EDISSFRAC * E_pot_scission 
C     /' All excitation energy at saddle and part of the potential-energy gain to scission 
C     go into intrinsic excitation energy at scission '/ 
C     ' 
C     ' 
C     ' 
      DO IA1 = 40 , I_A_CN - 40 
C     ' 
      IA2 = I_A_CN - IA1 
      IF (  I_Mode .LE. 4  ) THEN 
      T1 = Temp(I_Mode,1,IA1) 
      T2 = Temp(I_Mode,2,IA2) 
      End If 
      IF (  I_Mode .EQ. 5  ) THEN 
      T1 = Temp(1,2,IA1) 
      T2 = Temp(1,2,IA2) 
      End If 
      IF (  I_Mode .EQ. 6  ) THEN 
      T1 = Temp(2,2,IA1) 
      T2 = Temp(2,2,IA2) 
      End If 
      DT = ABS(T2 - T1) 
C     ' 
C     /' Even-odd effect '/ 
      IF (   MOD(I_Z_CN,2)  .EQ. 0  ) THEN 
      Rincr1P = Exp(-Etot/PZ_EO_symm) 
      Else 
      Rincr1P = 0 
      End If 
      IF (   MOD(I_N_CN,2)  .EQ. 0  ) THEN 
      Rincr1N = Exp(-Etot/PN_EO_symm) 
      Else 
      Rincr1N = 0 
      End If 
      IF (  I_Mode .LE. 4  ) THEN 
      PEOZ(I_Mode,1,IA1) = Rincr1P 
      PEOZ(I_Mode,2,IA2) = Rincr1P 
      PEON(I_Mode,1,IA1) = Rincr1N 
      PEON(I_Mode,2,IA2) = Rincr1N 
      End If 
      IF (  I_Mode .EQ. 5  ) THEN 
      PEOZ(5,1,IA1) = Rincr1P 
      PEOZ(5,2,IA2) = Rincr1P 
      PEON(5,1,IA1) = Rincr1N 
      PEON(5,2,IA2) = Rincr1N 
      End If 
      IF (  I_Mode .EQ. 6  ) THEN 
      PEOZ(6,1,IA1) = Rincr1P 
      PEOZ(6,2,IA2) = Rincr1P 
      PEON(6,1,IA1) = Rincr1N 
      PEON(6,2,IA2) = Rincr1N 
      End If 
C     ' 
      Rincr2 = Gaussintegral(DT/Etot-R_EO_Thresh,
     *R_EO_Sigma*(DT+0.0001)) 
C     /' even-odd effect due to asymmetry '/ 
      Rincr2P = (R_EO_MAX - Rincr1P) * Rincr2 
      Rincr2N = (R_EO_MAX - Rincr1N) * Rincr2 
C     ' 
      IF (  IA1 .LT. IA2  ) THEN 
C     ' A1 is lighter 
      PEOZ(I_Mode,1,IA1) = PEOZ(I_Mode,1,IA1) + Rincr2P 
      IF (   MOD(I_Z_CN,2)  .EQ. 0  ) THEN 
      PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,2,IA2) + Rincr2P 
      Else 
      PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,2,IA2) - Rincr2P 
      End if 
      PEON(I_Mode,1,IA1) = PEON(I_Mode,1,IA1) + Rincr2N 
      IF (   MOD(I_N_CN,2)  .EQ. 0  ) THEN 
      PEON(I_Mode,2,IA2) = PEON(I_Mode,2,IA2) + Rincr2N 
      Else 
      PEON(I_Mode,2,IA2) = PEON(I_Mode,2,IA2) - Rincr2N 
      End if 
      Else 
      PEOZ(I_Mode,1,IA1) = PEOZ(I_Mode,2,IA1) 
      PEON(I_Mode,1,IA1) = PEON(I_Mode,2,IA1) 
      PEOZ(I_Mode,2,IA2) = PEOZ(I_Mode,1,IA2) 
      PEON(I_Mode,2,IA2) = PEON(I_Mode,1,IA2) 
      End If 
C     ' 
C     ' 
C     /'  Else 
C     PEOZ(I_Mode,2,IA2) =                PEOZ(I_Mode,1,IA2) + Rincr2P 
C     IF I_Z_CN Mod 2 = 0 Then 
C     PEOZ(I_Mode,1,IA1) =                 PEOZ(I_Mode,1,IA1) + Rincr2P 
C     Else 
C     PEOZ(I_Mode,1,IA1) =                 PEOZ(I_Mode,1,IA1) - Rincr2P 
C     End if 
C     PEON(I_Mode,2,IA2) =              PEON(I_Mode,2,IA2) + Rincr2N 
C     IF I_N_CN Mod 1 = 0 Then 
C     PEON(I_Mode,1,IA1) =                 PEON(I_Mode,1,IA1) + Rincr2N 
C     Else 
C     PEON(I_Mode,1,IA1) =                 PEON(I_Mode,1,IA1) - Rincr2N 
C     End if 
C     End If  '/ 
C     ' 
C     /' Energy sorting '/ 
C     /' E1 = Etot * Gaussintegral(T2-T1,0.03); '/ 
      IF (  Abs(T1-T2) .LT. 1.E-6  ) THEN 
      E1 = 0.5E0 * Etot 
      Else 
      E1ES = Csort * T1 * T2 / ( Abs(T1 - T2) ) 
      E1ES = Min(E1ES,0.5E0*Etot) 
C     /' Asymptotic value after "complete" energy sorting '/ 
      E1FG = Etot * IA1 / I_A_CN 
C     /' in Fermi-gas regime '/ 
      IF (  Etot .LT. 13  )  E1 = E1ES 
C     ' complete energy sorting 
      IF (  Etot .GE. 13 .AND. Etot .LE. 20  ) THEN 
C     ' transition region 
      E1 = E1ES + (Etot-13)/7*(E1FG-E1ES) 
      End If 
      IF (  Etot .GT. 20  )  E1 = E1FG 
C     ' Fermi-gas regime 
      End If 
      E2 = Etot - E1 
      EPART(I_Mode,1,IA1) = E1 
C     /' Mean E* in light fragment '/ 
      EPART(I_Mode,2,IA2) = E2 
C     /' Mean E* in heavy fragment '/ 
      END DO 
      END DO 
C     ' 
C     ' 
      EINTR_SCISSION = Etot 
C     /' (For Mode 2) Global parameter '/ 
C     ' 
C     /'** RMS angular momentum of fission fragments **'/ 
C     /' Following Naik et al.,EPJ A 31 (2007) 195 and  '/ 
C     /' S. G. Kadmensky,Phys. At. Nucl. 71 (2008) 1193 '/ 
C     ' 
C     '   Scope 
      ZT = P_Z_CN 
C     '  AT = I_A_CN 
      AT = P_A_CN 
      IF (  Emode .EQ. 2  )  AT = AT -1 
      Spin_CN = P_J_CN 
C     '   Print "ZT,AT,I_MAT",ZT,AT,I_MAT 
C     '   Print "SPIN_CN",Spin_CN 
C     '   Sleep 
C     ' 
      DO IZ1 = 10 , I_Z_CN - 10 
      AUCD = Int(REAL(IZ1) * REAL(I_A_CN) / REAL(I_Z_CN)) 
      DO IA1 = Int(AUCD - 15) , Int(AUCD + 15) 
      IF (  IA1 - IZ1 .GE. 10  ) THEN 
C     /' Rigid momentum of inertia for spherical nucleus '/ 
      I_rigid_spher = 1.16E0**2 * REAL(IA1)**1.6667E0 / 103.8415E0 
C     /' unit: hbar^2/MeV '/ 
      DO I_Mode = 0 , 6 
C     ' 
C     /' First (normally light) fission fragment: '/ 
C     ' 
      beta1 = Beta(I_Mode,1,IZ1) 
      alph = beta1 / SQRT(4.E0 * pi / 5.E0) 
      I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph**2) 
C     /' From Hasse & Myers,Geometrical Relationships ... '/ 
      E_exc = EPART(I_Mode,1,IA1) 
      IF (  E_exc .LT. 0  )  E_exc = 0 
      T = U_Temp(REAL(IZ1),REAL(IA1),E_exc,1,1,Tscale,Econd) 
      T = SQRT(T**2 + 0.8**2) 
C     ' For ZPM 
      I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0)) 
      J_rms = SQRT(2.E0 * I_eff * T) 
C     ' 
C     /' Influence of CN spin '/ 
      J_rms = SQRT(J_rms**2 + 1./3. * Spin_CN**2) 
C     ' 
C     /' Incoming neutron (spin + orbital) '/ 
      IF (  Emode .EQ. 2  ) THEN 
C     ' 2/3 * 1.16 * sqrt(2 * 939.65) / 197.33 = 0.1699 
      J_rms = SQRT(J_rms**2 + 1./3 * 0.5**2 +                  1./3. * 
     *(0.1699 * AT**0.333333 * SQRT(R_E_exc_used))**2) 
      End If 
C     ' 
      IF (   MOD(IZ1,2)  .EQ. 1  )  J_rms = J_rms + Spin_odd * 
     *(REAL(IA1)/140.0)**0.66667 
C     /' empirical '/ 
C     /' Additional angular momentum of unpaired proton. '/ 
C     /' See also Tomar et al.,Pramana 68 (2007) 111 '/ 
C     ' 
      J_rms = J_rms * Jscaling 
C     ' Print Z1,I_Mode,beta1,T,E_exc,Spin_CN 
C     ' Print " ",I_rigid_spher,I_rigid,I_eff,J_rms 
C     ' 
      SpinRMSNZ(I_Mode,1,IA1-IZ1,IZ1) = J_rms 
C     ' 
C     ' 
C     '     Print A1,T,E_exc,I_rigid_spher,I_rigid,I_eff,J_rms 
C     ' 
C     /' Second (normally heavy) fission fragment: '/ 
C     ' 
      beta2 = Beta(I_Mode,2,IZ1) 
      alph = beta2 / SQRT(4.E0 * pi / 5.E0) 
      I_rigid = I_rigid_spher * (1.E0 + 0.5E0*alph + 9.E0/7.E0*alph**2) 
C     /' From Hasse & Myers,Geometrical Relationships ... '/ 
      E_exc = EPART(I_Mode,2,IA1) 
      IF (  E_exc .LT. 0  )  E_exc = 0 
      T = U_Temp(REAL(IZ1),REAL(IA1),E_exc,1,1,Tscale,Econd) 
      T = SQRT(T**2 + 0.8**2) 
C     ' For ZPM 
      I_eff = I_rigid * (1.E0 - 0.8E0 * exp(-0.693E0 * E_exc / 5.E0)) 
      J_rms = SQRT(2.E0 * I_eff * T) 
C     ' 
C     /' Influence of CN spin '/ 
      J_rms = SQRT(J_rms**2 + 1./3. * Spin_CN**2) 
C     ' 
C     /' Incoming neutron (spin + orbital) '/ 
      IF (  Emode .EQ. 2  ) THEN 
C     ' 2/3 * 1.16 * sqrt(2 * 939.65) / 197.33 = 0.1699 
      J_rms = SQRT(J_rms**2 + 1./3. * 0.5**2 +                  1./3. * 
     *(0.1699 * AT**0.333333 * SQRT(R_E_exc_used))**2) 
      End If 
C     ' 
      IF (   MOD(IZ1,2)  .EQ. 1  )  J_rms = J_rms + Spin_odd * 
     *(IA1/140.0)**0.66667 
C     /' empirical '/ 
C     /' Additional angular momentum of unpaired proton. '/ 
C     /' See also Tomar et al.,Pramana 68 (2007) 111 '/ 
C     ' 
      J_rms = J_rms * Jscaling 
C     ' 
      SpinRMSNZ(I_Mode,2,IA1-IZ1,IZ1) = J_rms 
C     ' 
      END DO 
      ENd If 
      END DO 
      END DO 
C     '   End Scope 
C     ' 
C     ' ******************************************************* 
C     ' *** Filling arrays with results in the folding mode *** 
C     ' ******************************************************* 
C     ' 
      DO I = 10 , I_A_CN - P_Z_CN - 10 
      DO J = 10 , P_Z_CN - 10 
      DO K = 0 , 6 
      NZMPRE(K,I,J) = 0.0 
      END DO 
      END DO 
      END DO 
C     ' 
C     ' Mode 0 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_0 * (U_Gauss(AC_Mode_0 - REAL(I),SigA_Mode_0) 
     *                 + U_Gauss(AC_Mode_0 - REAL(Ic),SigA_Mode_0)) 
C     ' Mass yield 
      IF (  I .LT. Ic  ) THEN 
      Zs = ZShift(0,1,I) 
      Else 
      Zs = -ZShift(0,1,Ic) 
      End If 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(0,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) + Zs - REAL(J),
     *SigPol_Mode_0) * U_Even_Odd(J,PEOZ(0,1,I)) * U_Even_Odd(I-J,
     *PEON(0,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 1 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_1 * (U_Gauss(AC_Mode_1 - REAL(I),SigA_Mode_1) 
     *               + U_Gauss(AC_Mode_1 - REAL(Ic),SigA_Mode_1)) 
C     ' Mass yield 
      IF (  I .LT. Ic  ) THEN 
      Zs = ZShift(1,1,I) 
      Else 
      Zs = -ZShift(1,1,Ic) 
      End If 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(1,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) + Zs - REAL(J),
     *SigPol_Mode_1)* U_Even_Odd(J,PEOZ(1,1,I)) * U_Even_Odd(I-J,PEON(1,
     *1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 2 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_2 * (U_Box(AC_Mode_2 - REAL(I),
     *SQRT(2.0)*SigA_Mode_2,P_A_Width_S2) +             U_Box(AC_Mode_2 
     *- REAL(Ic),SQRT(2.0)*SigA_Mode_2,P_A_Width_S2)) 
      IF (  I .LT. Ic  ) THEN 
      Zs = ZShift(2,1,I) 
      Else 
      Zs = -ZShift(2,1,Ic) 
      End If 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      R_Cut1 = R_Help 
      R_Cut2 = R_Help 
      IF (  J .GT. Jc  ) THEN 
      R_Cut1 = R_Help * Gaussintegral(REAL(J)-ZTRUNC50,
     *FTRUNC50*SigZ_Mode_2) 
      Else 
      R_Cut2 = R_Help * Gaussintegral(REAL(J)-ZTRUNC50,
     *FTRUNC50*SigZ_Mode_2) 
      End If 
      NZMPRE(2,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) + Zs - REAL(J),
     *SigPol_Mode_2) * U_Even_Odd(J,PEOZ(2,1,I)) * U_Even_Odd(I-J,
     *PEON(2,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 3 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_3 * (U_Gauss(AC_Mode_3 - REAL(I),SigA_Mode_3) 
     *+                     U_Gauss(AC_Mode_3 - REAL(I),SigA_Mode_3)) 
C     ' Mass yield 
      IF (  I .LT. Ic  ) THEN 
      Zs = ZShift(3,1,I) 
      Else 
      Zs = -ZShift(3,1,Ic) 
      End If 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(3,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) + Zs - REAL(J),
     *SigPol_Mode_3) * U_Even_Odd(J,PEOZ(3,1,I)) * U_Even_Odd(I-J,
     *PEON(3,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 4 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_4 * (U_Gauss(AC_Mode_4 - REAL(I),SigA_Mode_4) 
     *+                     U_Gauss(AC_Mode_4 - REAL(I),SigA_Mode_4)) 
C     ' Mass yield 
      IF (  I .LT. Ic  ) THEN 
      Zs = ZShift(3,1,I) 
      Else 
      Zs = -ZShift(3,1,Ic) 
      End If 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(4,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) + Zs - REAL(J),
     *SigPol_Mode_4) * U_Even_Odd(J,PEOZ(4,1,I)) * U_Even_Odd(I-J,
     *PEON(4,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 11 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_11 * (U_Gauss(AC_Mode_0 - REAL(I),
     *SigA_Mode_11) +                     U_Gauss(AC_Mode_0 - REAL(I),
     *SigA_Mode_11)) 
C     ' Mass yield 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(5,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) - REAL(J),
     *SigPol_Mode_0) * U_Even_Odd(J,PEOZ(5,1,I)) * U_Even_Odd(I-J,
     *PEON(5,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' Mode 22 
      DO I = 20 , I_A_CN - 20 
      Ic = I_A_CN - I 
      R_Help = Yield_Mode_22 * (U_Gauss(AC_Mode_0 - REAL(I),
     *SigA_Mode_22) +                     U_Gauss(AC_Mode_0 - REAL(I),
     *SigA_Mode_22)) 
C     ' Mass yield 
      DO J = 10 , P_Z_CN - 10 
      Jc = P_Z_CN - J 
      IF (  I-J .GE. 0 .AND. Ic-Jc .GE. 0 .AND. I-J .LE. 200 .AND. 
     *Ic-Jc .LE. 200  ) THEN 
      NZMPRE(6,I-J,J) = R_Help * 
     *U_Gauss(REAL(P_Z_CN)/REAL(I_A_CN)*REAL(I) - REAL(J),
     *SigPol_Mode_0) * U_Even_Odd(J,PEOZ(6,1,I)) * U_Even_Odd(I-J,
     *PEON(6,1,I)) 
      End If 
      END DO 
      END DO 
C     ' 
C     ' 
C     ' Normalization 
      R_Sum = 0 
      DO I = 10 , (I_A_CN - P_Z_CN) - 10 
      DO J = 10 , P_Z_CN - 10 
      NZPRE(I,J) = 0 
      DO K = 0 , 6 
      IF (  NZMPRE(K,I,J) .GT. 0  ) THEN 
      R_Sum = R_Sum + NZMPRE(K,I,J) 
      NZPRE(I,J) = NZPRE(I,J) + NZMPRE(K,I,J) 
C     ' sum of all modes 
      End If 
      END DO 
      END DO 
      END DO 
C     ' Print R_Sum 
      DO I = 10 , (I_A_CN - P_Z_CN) - 10 
      DO J = 10 , P_Z_CN - 10 
      NZPRE(I,J) = NZPRE(I,J) / R_Sum 
      DO K = 0 , 6 
      NZMPRE(K,I,J) = NZMPRE(K,I,J) / R_Sum 
      END DO 
      END DO 
      END DO 
C     ' 
C     ' Calculate and store distributions of fragment excitation energy and spin 
C     ' 
      N_cases = 0 
      DO N_index = 10 , (I_A_CN - P_Z_CN) - 10 
C     ' Neutron number 
      DO Z_index = 10 , P_Z_CN - 10 
C     ' Atomic number 
      DO M_index = 0 , 6 
      IF (  NZMPRE(M_index,N_index,Z_index) .GT. Ymin  ) THEN 
      N_cases = N_cases + 1 
      IF (  N_cases .EQ. Ubound(NZMkey,1)  ) THEN 
C     '           Print "Upper bound of NZkey reached" 
C     '           Print "Result will be incomplete" 
      End If 
      NZMkey(N_cases,1) = M_index 
C     ' Fission mode 
      NZMkey(N_cases,2) = N_index 
C     ' Neutron number of fragment 
      NZMkey(N_cases,3) = Z_index 
C     ' Atomic number of fragment 
      End If 
      END DO 
      END DO 
      END DO 
      WRITE (*,*) "N_cases  ",N_cases 
C     ' 
      DO K = 1 , N_cases 
      M_index = NZMkey(K,1) 
C     ' fission mode 
      N_index = NZMkey(K,2) 
C     ' neutron number 
      Z_index = NZMkey(K,3) 
C     ' atomic number 
      A_index = N_index + Z_index 
C     ' 
C     ' Yield 
      Ytab(K) = NZMpre(M_index,N_index,Z_index) 
C     ' 
C     ' Angular momentum: 
      DO I = 1 , 100 
      IF (  M_index .LE. 4  ) THEN 
      IF (  Z_index .LT. 0.5 * P_Z_CN  ) THEN 
      Jtab(K,I) = U_LinGauss(REAL(I),SpinRMSNZ(M_index,1,N_index,
     *Z_index)/SQRT(2.0)) 
      Else 
      Jtab(K,I) = U_LinGauss(REAL(I),SpinRMSNZ(M_index,2,N_index,
     *Z_index)/SQRT(2.0)) 
      End If 
      End If 
      IF (  M_index .EQ. 5  ) THEN 
      Jtab(K,I) = U_LinGauss(REAL(I),SpinRMSNZ(1,2,N_index,
     *Z_index)/SQRT(2.0)) 
      End If 
      IF (  M_index .EQ. 6  ) THEN 
      Jtab(K,I) = U_LinGauss(REAL(I),SpinRMSNZ(2,2,N_index,
     *Z_index)/SQRT(2.0)) 
      End If 
      END DO 
C     ' 
C     ' Normalize numerically (due to non-continuous values) 
C     '   Scope 
      DO I = 1 , 100 
      Rint = Rint + Jtab(K,I) 
      END DO 
      IF (  Rint .GT. 0  ) THEN 
      DO I = 1 , 100 
      Jtab(K,I) = Jtab(K,I) / Rint 
      END DO 
      End If 
C     '   End Scope 
C     ' 
C     ' 
C     ' Excitation energy: 
C     ' 1. Deformation energy at scission 
      IF (  M_index .EQ. 0  ) THEN 
      IF (  Z_index .LT. 0.5 * P_Z_CN  ) THEN 
      Eexc_mean = Edefo(M_index,1,Z_index) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(M_index,1,
     *Z_index) + SIGDEFO_0) -             Lymass(REAL(Z_index),
     *REAL(A_index),beta(M_index,1,Z_index) )) 
C     ' factor 2 is a guess for the smaller shape restoring force of the liquid-drop 
      Else 
      Eexc_mean = Edefo(M_index,2,Z_index) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(M_index,2,
     *Z_index) + SIGDEFO_0) -             Lymass(REAL(Z_index),
     *REAL(A_index),beta(M_index,2,Z_index) )) 
C     ' factor 2 is a guess for the smaller shape restoring force of the liquid-drop 
      End If 
      End If 
      IF (  M_index .GT. 0 .AND. M_index .LE. 4  ) THEN 
      IF (  Z_index .LT. 0.5 * P_Z_CN  ) THEN 
      Eexc_mean = Edefo(M_index,1,Z_index) 
      RS = SIGDEFO/SQRT(R_Att_Sad(M_index)) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(M_index,1,
     *Z_index) + RS) -             Lymass(REAL(Z_index),REAL(A_index),
     *beta(M_index,1,Z_index) )) 
      Else 
      Eexc_mean = Edefo(M_index,2,Z_index) 
      RS = SIGDEFO/SQRT(R_Att_Sad(M_index)) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(M_index,2,
     *Z_index) + RS) -             Lymass(REAL(Z_index),REAL(A_index),
     *beta(M_index,2,Z_index) )) 
      End If 
      End If 
      IF (  M_index .EQ. 5  ) THEN 
      Eexc_mean = Edefo(1,2,Z_index) 
      RS = SIGDEFO/SQRT(R_Att_Sad(M_index)) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(1,2,
     *Z_index) + RS) -             Lymass(REAL(Z_index),REAL(A_index),
     *beta(1,2,Z_index) )) 
      End If 
      IF (  M_index .EQ. 6  ) THEN 
      Eexc_mean = Edefo(2,2,Z_index) 
      RS = SIGDEFO/SQRT(R_Att_Sad(M_index)) 
      Eexc_sigma = ( Lymass(REAL(Z_index),REAL(A_index),beta(2,2,
     *Z_index) + RS) -             Lymass(REAL(Z_index),REAL(A_index),
     *beta(2,2,Z_index) )) 
      End If 
      Eexc_mean = Max(Eexc_mean,0.0) 
C     ' 
C     ' 2. Intrinsic excitation energy at scission 
      IF (  Z_index .LT. 0.5 * REAL(P_Z_CN)  ) THEN 
      Eexc_intr = EPART(M_index,1,A_index) 
      Else 
      Eexc_intr = EPART(M_index,2,A_index) 
      End If 
      Eexc_intr = Max(Eexc_intr,0.0) 
      Eexc_mean = Eexc_mean + Eexc_intr 
      Eexc_sigma = SQRT(Eexc_sigma**2 + (EexcSIGrel * Eexc_intr)**2) 
C     ' 
C     ' 3. Pairing staggering 
      Eexc_mean = Eexc_mean - Lypair(Z_index,A_index) 
C     ' 
C     ' 4. Collective energy 
      Eexc_coll = 0.5 * (De_Saddle_Scission(REAL(P_Z_CN)**2 /      
     *REAL(I_A_CN)**0.33333E0,ESHIFTSASCI_coll) - E_tunn) 
      Eexc_coll = Max(Eexc_coll,0.0) 
      Eexc_sigma = SQRT(Eexc_sigma**2 + 0.5*(EexcSIGrel*Eexc_coll)**2) 
      Eexc_mean = Eexc_mean + Eexc_coll + 0.5 * E_coll_saddle(M_index) 
C     ' 
C     ' 5. Total excitation energy distribution of fragments (all contributions summed up) 
      DO I = 0 , 1000 
C     ' 100 keV bins up to 100 MeV 
      Etab(K,I) = exp(-(0.1*REAL(I)-Eexc_mean)**2/(2.0 * Eexc_sigma)) 
      END DO 
C     ' 
C     ' Normalize excitation-energy distribution 
C     '   Scope 
      DO I = 1 , 1000 
      RintE = RintE + Etab(K,I) 
      END DO 
      IF (  RintE .GT. 0  ) THEN 
      DO I = 1 , 1000 
      Etab(K,I) = Etab(K,I) / RintE 
      END DO 
      End If 
C     '   End Scope 
C     ' 
      END DO 
C     ' 
C     ' 
      End  
C     ' 
C     ' 
C     ' 
C     /' Subroutines '/ 
C     ' 
      Include "BEexp.FOR" 
      Include "BEldmTF.FOR" 
      Include "ShellMO.FOR" 
C     ' 
C     ' 
      INTEGER*4 FUNCTION U_Valid(I_Z,I_A)
      IMPLICIT NONE
      INTEGER*4 I_Z
      INTEGER*4 I_A
      INTEGER*4  Ivalid
      Ivalid = 1 
      IF (  I_A / I_Z .LT. 210.E0/90.E0 .OR. I_A / I_Z .GT. 
     *250.E0/90.E0  ) THEN 
      Ivalid = 0 
      End If 
      IF (  I_Z .LT. 76 .OR. I_Z .GT. 120  ) THEN 
      Ivalid = 0 
      End If 
      U_Valid = Ivalid 
C     ' U_Valid = 1 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION U_Delta_S0(I_Z,I_A)
      IMPLICIT NONE
      INTEGER*4 I_Z
      INTEGER*4 I_A
C     ' I_Z and I_A refer to the fissioning nucleus90 22 
      REAL*4  Delta
      Delta = 0 
      IF (  I_Z .EQ. 95 .AND. I_A .EQ. 242  )  Delta = -0.1 
C     'T 
      IF (  I_Z .EQ. 95 .AND. I_A .EQ. 243  )  Delta = 0.05 
C     'T 
      IF (  I_Z .EQ. 95 .AND. I_A .EQ. 244  )  Delta = -0.1 
      IF (  I_Z .EQ. 96 .AND. I_A .EQ. 244  )  Delta = 0.1 
C     'T 
      IF (  I_Z .EQ. 96 .AND. I_A .EQ. 246  )  Delta = 0.0 
C     'T 
      IF (  I_Z .EQ. 93 .AND. I_A .EQ. 238  )  Delta = 0.15 
C     'T 
      IF (  I_Z .EQ. 94 .AND. I_A .EQ. 240  )  Delta = 0.05 
C     'T 
      IF (  I_Z .EQ. 94 .AND. I_A .EQ. 241  )  Delta = -0.3 
C     'T 
      IF (  I_Z .EQ. 94 .AND. I_A .EQ. 242  )  Delta = -0.15 
C     'T 
      IF (  I_Z .EQ. 94 .AND. I_A .EQ. 243  )  Delta = -0.45 
C     'T 
      IF (  I_Z .EQ. 90 .AND. I_A .EQ. 228  )  Delta = 0.70 
C     'T 
      IF (  I_Z .EQ. 90 .AND. I_A .EQ. 230  )  Delta = 0.85 
C     'T 
      IF (  I_Z .EQ. 90 .AND. I_A .EQ. 233  )  Delta = 0.2 
      IF (  I_Z .EQ. 91 .AND. I_A .EQ. 228  )  Delta = 0.65 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 233  )  Delta = 0.65 
C     'T 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 234  )  Delta = 0.7 
C     'T 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 235  )  Delta = 0.3 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 236  )  Delta = 0.45 
C     'T 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 237  )  Delta = 0.3 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 238  )  Delta = 0.3 
      IF (  I_Z .EQ. 92 .AND. I_A .EQ. 239  )  Delta = 0.3 
      U_Delta_S0 = Delta 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION Getyield(E_rel,E_ref,T_low,T_high)
      IMPLICIT NONE
      REAL*4 E_rel
      REAL*4 E_ref
      REAL*4 T_low
      REAL*4 T_high
C     /' Erel: Energy relative to the barrier '/ 
C     /' T_low: Effective temperature below barrier '/ 
C     /' T_high: Effective temperature above barrier '/ 
      REAL*4  Exp1
      REAL*4  Yield
C     ' 
      Exp1 = E_rel/T_low - E_ref/0.4 
C     ' energy far below barrier 
      IF (  Exp1 .LT. -50  ) THEN 
      Yield = 0 
      Else 
      Yield = Exp(E_rel / T_high - E_ref/0.4) * 1.E0 / (1.E0 + 
     *exp(-E_rel/ (T_high*T_low/(T_high-T_low) ) ) ) 
      End If 
C     '   print  E_rel,T_high,E_ref,Yield 
      Getyield = Yield 
C     ' 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION F1(Z_S_A)
      IMPLICIT NONE
      REAL*4 Z_S_A
C     /' Fit to the lower part of the data '/ 
      REAL*4  Result
      Result = exp(-9.05E0 + 4.58E0 * Log(Z_S_A/2.3E0)) 
      F1 = Result 
      END
      REAL*4 FUNCTION F2(Z_S_A)
      IMPLICIT NONE
      REAL*4 Z_S_A
C     /' Fit to the upper part of the data '/ 
      REAL*4  Result
      Result = exp(12.08E0 - 3.27E0 * Log(Z_S_A/2.3E0)) 
      F2 = Result 
      END
C     ' 
      REAL*4 FUNCTION Masscurv(Z,A,RI,kappa)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 RI
      REAL*4 kappa
C     /'  Fit to  Data of Fig. 7 of                                             '/ 
C     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/ 
C     /'  S. I. Mulgin,K.-H. Schmidt,A. Grewe,S. V. Zhdanov                  '/ 
C     /'  Nucl. Phys. A 640 (1998) 375 
C     /' (From fit of the width of the mass distributions.) '/                                         '/ 
      REAL*4  Result1,Result2,Result
      REAL*4  Z_square_over_A
      REAL*4  ZsqrA
      REAL*4 F1 
      REAL*4 F2 
C     ' 
      Z_square_over_A = Z**2/A 
      ZsqrA = Z_square_over_A * (1.E0 - kappa * RI**2) / (1.E0 - kappa 
     ** ((226.E0 - 2.E0*91.E0)/226.E0)**2) 
C     ' 
      Result1 = F1(ZsqrA) 
      Result2 = F2(ZsqrA) 
      Result = Min(Result1,Result2) 
      Masscurv = Result 
C     ' 
      END
C     ' 
      REAL*4 FUNCTION Masscurv1(Z,A,RI,kappa)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 RI
      REAL*4 kappa
C     /'  Fit to  Data of Fig. 7 of                                             '/ 
C     /'  "Shell effect in the symmetric-modal fission of pre-actinide nuclei"  '/ 
C     /'  S. I. Mulgin,K.-H. Schmidt,A. Grewe,S. V. Zhdanov                  '/ 
C     /'  Nucl. Phys. A 640 (1998) 375 
C     /' (The left part assumed to be valid for the yields of the fission channels.) '/                                         '/ 
      REAL*4  Result1,Result2,Result
      REAL*4  Z_square_over_A
      REAL*4  ZsqrA
      REAL*4 F1 
      REAL*4 F2 
C     ' 
      Z_square_over_A = Z**2/A 
      ZsqrA = Z_square_over_A * (1.E0 - kappa * RI**2) / (1.E0 - kappa 
     ** ((226.E0 - 2.E0*91.E0)/226.E0)**2) 
C     ' 
      Result1 = F1(ZsqrA) 
C     '  Result2 = F2(ZsqrA) 
C     '  Result = Min(Result1,Result2) 
      Masscurv1 = Result1 
C     ' 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION De_Saddle_Scission(Z_square_over_Athird,
     *ESHIFTSASCI)
      IMPLICIT NONE
      REAL*4 Z_square_over_Athird
      REAL*4 ESHIFTSASCI
C     /' Energy release between saddle and scission '/ 
C     /' M. Asghar,R. W. Hasse,J. Physique C 6 (1984) 455 '/ 
      REAL*4  Result
      Result = (31.E0 - 11.E0) / (1550.E0 - 1300.E0) * 
     *(Z_square_over_Athird - 1300.E0 + ESHIFTSASCI) + 11.E0 
C     ' This formula with ESHIFTSASCI = 0 is the parameterisation of the results 
C     ' of Ashgar and Hasse,JPC 6 (1984) 455,see 
C     ' F. Rejmund,A. V. Ignatyuk,A. R. Junghans,K.-H. Schmidt 
C     ' Nucl. Phys. A 678 (2000) 215 
      Result = max(Result,0.0) 
      De_Saddle_Scission = Result 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION TEgidy(A,DU,Fred)
      IMPLICIT NONE
      REAL*4 A
      REAL*4 DU
      REAL*4 Fred
C     /' Temperature parameter of the constant-temperature formula for the 
C     nuclear level density. 
C     Input parameters: A = Mass number of nucleus 
C     DU = Shell effect (corrected for pairing:P=0 for odd-A nuclei) 
C     From "Correlations between the nuclear level density parameters" 
C     Dorel Bucurescu,Till von Egidy 
C     Phys. Rev. C 72 (2005) 067304    and 
C     "Systematics of nuclear level density parameters" 
C     Dorel Bucurescu,Till von Egidy 
C     J. Phys. G: Nucl. Part. Phys. 31 (2005) S1675 and 
C     "Systematics of nuclear level density parameters" 
C     Till von Egidy,Dorel Bucurescu 
C     Phys. Rev. C 72 (2005) 044311 '/ 
      REAL*4  Temp_smooth,Temp,T_Fac
C     ' Temp_smooth = 17.45E0 / (A^0.666667E0) 
C     ' Temp = (17.45E0 - 0.51E0 * DU + 0.051 * DU^2) / (A^0.666667E0) 
      Temp_smooth = 1.0 / (0.0570 * A**0.6666667) 
      Temp = 1.0 / ( (0.0570 + 0.00193*DU) * A**0.6666667) 
C     ' from  PRC 80 (2009) 054310 
      T_Fac = Temp / Temp_smooth 
      Temp = Temp * Fred 
C     /' (For influence of deformation) '/ 
      TEgidy = Temp 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION TRusanov(E,A)
      IMPLICIT NONE
      REAL*4 E
      REAL*4 A
C     /' Fermi-gas level density,parameterisation of Rusanov et al. '/ 
      IF (  E >0  ) THEN 
      TRusanov = SQRT(E / (0.094E0 * A) ) 
      Else 
      TRusanov = 0.0 
      End If 
      END
C     ' 
      REAL*4 FUNCTION LyMass(Z,A,beta)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 beta
C     ' 
C     /' liquid-drop mass,Myers & Swiatecki,Lysekil,1967  '/ 
C     /' pure liquid drop,without pairing and shell effects '/ 
C     ' 
C     /' On input:    Z     nuclear charge of nucleus        '/ 
C     /'              N     number of neutrons in nucleus    '/ 
C     /'              beta  deformation of nucleus           '/ 
C     /' On output:   binding energy of nucleus              '/ 
C     ' 
      REAL*4  pi
      PARAMETER (pi=3.14159)
      REAL*4  N
      REAL*4  alpha
      REAL*4  XCOM,XVS,XE,EL
C     ' 
      N = A - Z 
      alpha = SQRT(5.E0/(4.E0*pi)) * beta 
      XCOM = 1.E0 - 1.7826E0 * ((A - 2.E0*Z)/A)**2 
C     /' factor for asymmetry dependence of surface and volume term '/ 
      XVS = - XCOM * (15.4941E0*A                    - 
     *17.9439E0*A**(2.E0/3.E0)*(1.E0+0.4E0*Alpha**2)) 
C     /' sum of volume and surface energy '/ 
      XE = Z**2 * (0.7053E0/A**(1.E0/3.E0)*(1.E0-0.2E0*Alpha**2)        
     *           - 1.1529E0/A) 
      EL = XVS + XE 
C     /'   EL = EL + LyPair(Z,A); '/ 
      LyMass = EL 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION LyPair(Z,A)
      IMPLICIT NONE
      INTEGER*4 Z
      INTEGER*4 A
C     /' Calculates pairing energy '/ 
C     /' odd-odd nucleus:   Lypair = 0 '/ 
C     /' even-odd nucleus:  Lypair = -12/sqr(A) '/ 
C     /' even-even nucleus: Lypair = -2*12/sqr(A) '/ 
      REAL*4  E_PAIR
C     ' 
      E_PAIR = - 12.E0 / SQRT(REAL(A)) * ( MOD((Z+1) , 2) + MOD((A-Z+1) 
     *, 2)) 
C     ' 
      Lypair = E_PAIR 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION TFPair(Z,A)
      IMPLICIT NONE
      INTEGER*4 Z
      INTEGER*4 A
C     /' Pairing energy from Thomas-Fermi model of Myers and Swiatecki '/ 
C     /' Shifted that TFPair is zero for odd-odd nuclei '/ 
      INTEGER*4  N
      REAL*4  E_Pair
      N = A - Z 
      IF (   MOD(Z,2)  .EQ. 0 .AND.  MOD(N,2)  .EQ. 0  ) THEN 
C     /' even-even '/ 
      E_Pair = - 4.8E0 / Z**0.333333E0 - 4.8E0 / N**0.333333E0 + 6.6E0 
     */ A**0.666666E0 
      END IF 
      IF (   MOD(Z,2)  .EQ. 0 .AND.  MOD(N,2)  .EQ. 1  ) THEN 
C     /' even Z,odd N '/ 
      E_Pair = - 4.8E0 / Z**0.333333E0 + 6.6E0 / A**0.666666E0 
      END IF 
      IF (   MOD(Z,2)  .EQ. 1 .AND.  MOD(N,2)  .EQ. 0  ) THEN 
C     /' odd Z,even N '/ 
      E_Pair = - 4.8E0 / N**0.333333E0 + 6.6E0 / A**0.666666E0 
      END IF 
      IF (   MOD(Z,2)  .EQ. 1 .AND.  MOD(N,2)  .EQ. 1  ) THEN 
C     /' odd N,odd N '/ 
      E_Pair = 0.0 
      END IF 
      TFPair = E_Pair 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION Pmass(Z,A,beta)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 beta
C     /' Liquid-drop model of Pearson,2001 '/ 
      REAL*4  N,EA,BE
      REAL*4  avol
      DATA avol/-15.65/
      REAL*4  asf
      DATA asf/17.63/
      REAL*4  r0
      DATA r0/1.233/
      REAL*4  asym
      DATA asym/27.72/
      REAL*4  ass
      DATA ass/-25.60/
      REAL*4  alpha
      REAL*4  pi
      PARAMETER (pi=3.14159)
C     ' 
      N = A - Z 
      alpha = SQRT(5.E0/(4.E0*pi)) * beta 
      EA = avol + asf * A**(-0.333333)*(1.E0+0.4E0*Alpha**2) + 0.6E0 * 
     *1.44E0 * Z**2 / (A**1.333333 * r0 )*(1.E0-0.2E0*Alpha**2) + (asym 
     *+ ass * A**(-0.333333)) * (N-Z)**2 / A**2 
      BE = EA * A 
      Pmass = BE 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION FEDEFOP(Z,A,beta)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 beta
C     /' According to liquid-drop model of Pearson 2001 '/ 
      REAL*4  asf
      DATA asf/17.63/
      REAL*4  r0
      DATA r0/1.233/
      REAL*4  N,Alpha
      REAL*4  pi
      PARAMETER (pi=3.14159)
C     ' 
      N = A - Z 
      alpha = SQRT(5.E0/(4.E0*pi)) * beta 
      FEDEFOP = asf * A**(0.666667)*(0.4E0*Alpha**2) - 0.6E0 * 1.44E0 * 
     *Z**2 / (A**0.333333 * r0 )*(0.2E0*Alpha**2) 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION FEDEFOLys(Z,A,beta)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 beta
      REAL*4 LYMASS 
      FEDEFOLys = Lymass(Z,A,beta) - Lymass(Z,A,0.0) 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION LDMass(Z,A,beta)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 beta
      REAL*4  N,BEtab
      REAL*4 LYMASS 
      REAL*4 FEDEFOLYS 
      REAL*4 BEldmTF 
      REAL*4 BEexp 
      N = A - Z 
      BEtab = BEldmTF(NINT(N),NINT(Z)) + 2.0 * 12.0 / SQRT(REAL(A)) - 
     *0.00001433*Z**2.39 
C     ' The values in BEtab are the negative binding energies! 
C     ' Pairing in Thomas Fermi masses is zero for Z,N even ! 
      IF (  BEtab .EQ. 0.0  ) THEN 
      BEtab = Lymass(Z,A,0.0) 
C     '         Print "Warning: Binding energy of Z=";Z;",A=";A;" not in mass table,";                         " replaced by LYMASS" 
C     '         Print "I_Mode = ";I_Mode 
      End If 
      LDMASS = BEtab + FEDEFOLys(Z,A,beta) 
      END
C     ' 
      REAL*4 FUNCTION AME2012(IZ,IA)
      IMPLICIT NONE
      INTEGER*4 IZ
      INTEGER*4 IA
C     ' Masses from the 2003 mass evaluation,complemented by TF masses 
C     ' and Lysekil masses. 
      REAL*4  BEexpval
      REAL*4  Z,A,N
      INTEGER*4  INeu
      REAL*4 LYPAIR 
      REAL*4 U_SHELL 
      REAL*4 LDMASS 
      REAL*4 BEexp 
      INeu = IA - IZ 
      A = REAL(IA) 
      Z = REAL(IZ) 
      N = A - Z 
      BEexpval = BEexp(INeu,IZ) 
      IF (  BEexpval .GT. -1.E10  ) THEN 
      AME2012 = BEexpval 
      Else 
      AME2012 = Ldmass(Z,A,0.0) + U_SHELL(IZ,IA) + Lypair(IZ,IA) 
      End If 
      END
C     ' 
      REAL*4 FUNCTION U_SHELL(Z,A)
      IMPLICIT NONE
      INTEGER*4 Z
      INTEGER*4 A
      INTEGER*4  N
      REAL*4  Res
      REAL*4 ShellMO 
      N = A - Z 
      Res = ShellMO(N,Z) 
      IF (  Res .GT. 0.0  )  Res = 0.3 * Res 
C     ' KHS (12. Feb. 2012) 
C     '      ' The positive shell effects for deformed nuclei seem to be too positive 
C     ' This gives too many high-energetic prompt neutrons. 
      U_SHELL = Res 
      END
C     ' 
      REAL*4 FUNCTION U_SHELL_exp(IZ,IA)
      IMPLICIT NONE
      INTEGER*4 IZ
      INTEGER*4 IA
      REAL*4  Res
      REAL*4  Z,A
      REAL*4 LDMASS 
      REAL*4 LYPAIR 
      REAL*4 AME2012 
      Z = REAL(IZ) 
      A = REAL(IA) 
C     '   Res = 2.0 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) )    '          - 0.25 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,0.0) )    '          - 0.25 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,A+1.0,0.0) )    '          - 0.25 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - LDMass(Z+1.0,A+1.0,0.0) )    '          - 0.25 * ( AME2012(IZ-1,IA-1) - Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) ) 
      Res = 0.5 * ( AME2012(IZ,IA) - Lypair(IZ,IA) - LDMass(Z,A,0.0) ) 
     *+ 0.125 * ( AME2012(IZ,IA-1) - Lypair(IZ,IA-1) - LDMass(Z,A-1.0,
     *0.0) ) + 0.125 * ( AME2012(IZ,IA+1) - Lypair(IZ,IA+1) - LDMass(Z,
     *A+1.0,0.0) ) + 0.125 * ( AME2012(IZ+1,IA+1) - Lypair(IZ+1,IA+1) - 
     *LDMass(Z+1.0,A+1.0,0.0) ) + 0.125 * ( AME2012(IZ-1,IA-1) - 
     *Lypair(IZ-1,IA-1) - LDMass(Z-1.0,A-1.0,0.0) ) 
      U_SHELL_exp = Res 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION U_MASS(Z,A)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
C     /' LD + congruence energy + shell (no pairing) '/ 
      REAL*4  BE
      REAL*4 U_SHELL 
      REAL*4 LDMASS 
      IF (  Z .LT. 0 .OR. A .LT. 0  ) THEN 
C     '       Print "U_Mass: Z,A",Z,A 
      End If 
      BE = Ldmass(Z,A,0.0) + U_SHELL(NINT(Z),NINT(A)) 
C     '    BE = AME2012(Cint(Z),Cint(A)) - Lypair(Z,A) 
C     '    BE = Lymass(Z,A,0.0) + U_Shell(CInt(Z),CInt(A)) 
C     '    BE = Lymass(Z,A,0.0) 
      U_MASS = BE 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION ECOUL(Z1,A1,beta1,Z2,A2,beta2,d)
      IMPLICIT NONE
      REAL*4 Z1
      REAL*4 A1
      REAL*4 beta1
      REAL*4 Z2
      REAL*4 A2
      REAL*4 beta2
      REAL*4 d
C     ' 
C     /' Coulomb potential between two nuclei                    '/ 
C     /' surfaces are in a distance of d                         '/ 
C     /' in a tip to tip configuration                           '/ 
C     ' 
C     /' approximate formulation                                 '/ 
C     /' On input: Z1      nuclear charge of first nucleus       '/ 
C     /'           A1      mass number of irst nucleus   '/ 
C     /'           beta1   deformation of first nucleus          '/ 
C     /'           Z2      nuclear charge of second nucleus      '/ 
C     /'           A2      mass number of second nucleus  '/ 
C     /'           beta2   deformation of second nucleus         '/ 
C     /'           d       distance of surfaces of the nuclei    '/ 
C     ' 
      REAL*4  N1,N2,recoul
      REAL*4  dtot
      REAL*4  r0
      DATA r0/1.16/
C     ' 
      N1 = A1 - Z1 
      N2 = A2 - Z2 
      dtot = r0 *( (Z1+N1)**0.3333333E0 * (1.E0+0.6666667E0*beta1)      
     *        + (Z2+N2)**0.3333333E0 * (1.E0+0.6666667E0*beta2) ) + d 
      REcoul = Z1 * Z2 * 1.44E0 / dtot 
C     ' 
      ECOUL = REcoul 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION beta_light(Z,betaL0,betaL1)
      IMPLICIT NONE
      INTEGER*4 Z
      REAL*4 betaL0
      REAL*4 betaL1
C     /' Deformation of light fission fragment for S1 and S2 '/ 
C     /' Systematic correlation Z vs. beta for deformed shells '/ 
C     /' Z of fission fragment '/ 
      REAL*4  beta
      beta = (Z - betaL0) * betaL1/20.E0 
      beta_light = beta 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION beta_heavy(Z,betaH0,betaH1)
      IMPLICIT NONE
      INTEGER*4 Z
      REAL*4 betaH0
      REAL*4 betaH1
C     /' Deformation of heavy fission fragment for S2 '/ 
C     /' Systematic correlation Z vs. beta for deformed shells '/ 
C     /' Z of fission fragment '/ 
      REAL*4  beta
      beta = (Z - betaH0) * betaH1/20.E0 
      beta_heavy = beta 
      END
C     ' 
C     ' 
C     ' 
      REAL*4 FUNCTION Z_equi(ZCN,A1,A2,beta1,beta2,d,Imode,POLARadd,
     *POLARfac)
      IMPLICIT NONE
      INTEGER*4 ZCN
      INTEGER*4 A1
      INTEGER*4 A2
      REAL*4 beta1
      REAL*4 beta2
      REAL*4 d
      INTEGER*4 Imode
      REAL*4 POLARadd
      REAL*4 POLARfac
C     /' Determines the minimum potential of the scission-point configuration 
C     represented by two deformed nuclei divided by a tip distance d. 
C     A1,A2,beta1,beta2,d are fixed,Z1 is searched for and returned on output.  '/ 
C     ' 
C     /' ZCN: Z of fissioning nucleus '/ 
C     /' A1: A of first fission fragment '/ 
C     /' A2: A of second fission fragment '/ 
C     /' beta1: deformation of first fission fragment '/ 
C     /' beta2: deformation of second fission fragment '/ 
C     /' d: tip distance '/ 
C     ' 
      REAL*4  RZ_equi
      REAL*4  RA1,RA2,RZCN,RACN
      REAL*4  Z1UCD,Z2UCD
      REAL*4  re1,re2,re3,eps1,eps2,DZ_Pol
C     /' help variables '/ 
      REAL*4 ECOUL 
      REAL*4 LYMASS 
C     ' 
      RA1 = REAL(A1) 
      RA2 = REAL(A2) 
      RZCN = REAL(ZCN) 
      RACN = RA1 + RA2 
      Z1UCD = RA1 / (RA1 + RA2) * RZCN 
      Z2UCD = RZCN - Z1UCD 
      re1 = LyMass( Z1UCD-1.E0,RA1,beta1 ) + LyMass( Z2UCD+1.E0,RA2,
     *beta2 ) + ECoul( Z1UCD-1.E0,RA1,beta1,Z2UCD+1.E0,RA2,beta2,d ) 
      re2 = LyMass( Z1UCD,RA1,beta1) + LyMass( Z2UCD,RA2,beta2) + 
     *ECoul( Z1UCD,RA1,beta1,Z2UCD,RA2,beta2,d ) 
      re3 = LyMass( Z1UCD+1.E0,RA1,beta1 ) + LyMass( Z2UCD-1.E0,RA2,
     *beta2 ) + ECoul( Z1UCD+1.E0,RA1,beta1,Z2UCD-1.E0,RA2,beta2,d ) 
      eps2 = ( re1 - 2.E0*re2 + re3 ) / 2.E0 
      eps1 = ( re3 - re1 ) / 2.E0 
      DZ_Pol = -eps1 / ( 2.E0 * eps2 ) 
C     ' 
      IF (  DZ_Pol .GT. 2 .OR. DZ_Pol .LT. -2  )  DZ_Pol = 0 
C     ' 
      IF (  Imode .GT. 0  ) THEN 
C     /' Purely empirical enhancement of charge polarization '/ 
      DZ_POL = DZ_POL * POLARfac + POLARadd 
      End If 
C     ' 
      RZ_equi = Z1UCD + DZ_POL 
      Z_equi = RZ_equi 
      END
C     ' 
C     ' 
      SUBROUTINE Beta_opt_light(A1,A2,Z1,Z2,d,beta2_imposed,beta1_opt)
      IMPLICIT NONE
      REAL*4 A1
      REAL*4 A2
      REAL*4 Z1
      REAL*4 Z2
      REAL*4 d
      REAL*4 beta2_imposed
      REAL*4 beta1_opt
C     /' Determines the optimum deformation of the light fragment when the deformation of the 
C     heavy fragment is imposed. '/ 
C     ' 
      REAL*4  beta1,dbeta1,beta1_prev,beta1_next
      REAL*4  Uguess,Uplus,Uminus,Uprev,Unext
      INTEGER*4  I
      REAL*4 ECOUL 
      REAL*4 LYMASS 
C     ' 
C     /' List('Beta_opt_light called with '); 
C     List(A1,A2,Z1,Z2,d,beta2_imposed,beta1_opt); 
C     DCL Byes Bit(1) aligned; 
C     Call GPYES('Continue',Byes); '/ 
      beta1 = 0.5 
      dbeta1 = 0.01 
      Uguess = LyMass(Z1,A1,beta1) + Lymass(Z2,A2,beta2_imposed) + 
     *ECoul(Z1,A1,beta1,Z2,A2,beta2_imposed,d) 
      Uplus = LyMass(Z1,A1,beta1 + dbeta1) + Lymass(Z2,A2,
     *beta2_imposed) + ECoul(Z1,A1,beta1 + dbeta1,Z2,A2,beta2_imposed,
     *d) 
      Uminus = LyMass(Z1,A1,beta1 - dbeta1) + Lymass(Z2,A2,
     *beta2_imposed) + ECoul(Z1,A1,beta1 - dbeta1,Z2,A2,beta2_imposed,
     *d) 
      IF (  Uplus .GT. Uguess .AND. Uminus .GT. Uguess  ) THEN 
      beta1_opt = beta1 
      Else 
      IF (  Uplus .LT. Uguess  )  dbeta1 = 0.01 
      IF (  Uminus .LT. Uguess  )  dbeta1 = -0.01 
      Unext = Uguess 
      beta1_next = beta1 
      DO I = 1 , 10000 
      beta1_prev = beta1_next 
      Uprev = Unext 
      beta1_next = beta1_prev + dbeta1 
      Unext = LyMass(Z1,A1,beta1_next) + Lymass(Z2,A2,beta2_imposed) + 
     *ECoul(Z1,A1,beta1_next,Z2,A2,beta2_imposed,d) 
      IF (  Unext .GE. Uprev  )  Exit 
      END DO 
      beta1_opt = beta1_prev 
      END IF 
C     ' 
      END
C     ' 
C     ' 
      SUBROUTINE Beta_Equi(A1,A2,Z1,Z2,d,beta1prev,beta2prev,beta1opt,
     *beta2opt)
      IMPLICIT NONE
      REAL*4 A1
      REAL*4 A2
      REAL*4 Z1
      REAL*4 Z2
      REAL*4 d
      REAL*4 beta1prev
      REAL*4 beta2prev
      REAL*4 beta1opt
      REAL*4 beta2opt
C     /' Determines the minimum potential of the scission-point configuration 
C     represented by two deformed nuclei,divided by a tip distance d. 
C     A1,A2,Z1,Z2,d are fixed,beta1 and beta2 are searched for and returned on output '/ 
C     ' 
      REAL*4  beta1,beta2
C     ' 
C     '      Dim As Double U,Uprev,Ulast,Ubest,Uopt 
      REAL*4  U,Uprev,Ulast,Ubest,Uopt
C     ' 
C     '      Dim As Double sbeta1,sbeta2 
      REAL*4  sbeta1,sbeta2
C     ' 
      INTEGER*4  N,N1,N2,Nopt
C     ' 
C     '      Dim As Double eps = 5.E-4 
      REAL*4  eps
      DATA eps/5.E-4/
C     ' 
      INTEGER*4  I
      REAL*4 LYMASS 
      REAL*4 ECOUL 
C     ' 
      beta1 = beta1prev 
      beta2 = beta2prev 
      Uprev = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,
     *beta1,Z2,A2,beta2,d) 
      Uopt = Uprev 
C     ' 
C     /' Test slope of variation of U '/ 
      beta1 = beta1prev + eps 
      U = 1.E30 
C     ' 
      beta2 = beta2prev 
C     '     For beta2 = beta2prev to 0 Step -eps 
      DO I = 1 , Int(beta2prev/eps) 
      beta2 = beta2 - eps 
      Ulast = U 
      U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,
     *Z2,A2,beta2,d) 
      IF (  U .GT. Ulast  ) THEN 
      Exit 
      Else 
      Ubest = U 
      END IF 
      END DO 
      IF (  Ubest .LT. Uopt  ) THEN 
      Uopt = Ubest 
      sbeta1 = eps 
      sbeta2 = -eps 
      END IF 
C     ' 
      U = 1.E30 
      beta2 = beta2prev 
C     '   For beta2 = beta2prev To 1 Step eps 
      DO I = 1 , Int((1 - beta2prev)/eps) 
      beta2 = beta2 + eps 
      Ulast = U 
      U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,
     *Z2,A2,beta2,d) 
      IF (  U .GT. Ulast  ) THEN 
      Exit 
      Else 
      Ubest = U 
      END IF 
      END DO 
      IF (  Ubest .LT. Uopt  ) THEN 
      Uopt = Ubest 
      sbeta1 = eps 
      sbeta2 = eps 
      End If 
C     ' 
      beta1 = beta1prev - eps 
      U = 1.E30 
      beta2 = beta2prev 
C     '   For beta2 = beta2prev To 0 Step -eps 
      DO I = 1 , Int(beta2prev/eps) 
      beta2 = beta2 - eps 
      Ulast = U 
      U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,
     *Z2,A2,beta2,d) 
      IF (  U .GT. Ulast  ) THEN 
      Exit 
      Else 
      Ubest = U 
      End If 
      END DO 
      IF (  Ubest .LT. Uopt  ) THEN 
      Uopt = Ubest 
      sbeta1 = -eps 
      sbeta2 = -eps 
      END IF 
C     ' 
      U = 1.E30 
      beta2 = beta2prev 
C     '   For beta2 = beta2prev To 1 Step eps 
      DO I = 1 , Int((1-beta2prev)/eps) 
      beta2 = beta2 + eps 
      Ulast = U 
      U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,
     *Z2,A2,beta2,d) 
      IF (  U .GT. Ulast  ) THEN 
      Exit 
      Else 
      Ubest = U 
      END IF 
      END DO 
      IF (  Ubest .LT. Uopt  ) THEN 
      Uopt = Ubest 
      sbeta1 = -eps 
      sbeta2 = eps 
      END IF 
C     ' 
C     ' 
      Ubest = Lymass(Z1,A1,beta1prev) + Lymass(Z2,A2,beta2prev) + 
     *ECoul(Z1,A1,beta1prev,Z2,A2,beta2prev,d) 
      U = Lymass(Z1,A1,beta1prev+REAL(sbeta1)) + Lymass(Z2,A2,
     *beta2prev+REAL(sbeta2)) + ECoul(Z1,A1,beta1prev+sbeta1,Z2,A2,
     *beta2prev+REAL(sbeta2),d) 
C     ' 
C     '   L1: 
      DO N = 1 , 1000 
C     ' 
C     '   L2: 
      DO N1 = 1 , N 
      N2 = N-N1 
      beta1 = beta1prev + sbeta1*N1 
      beta2 = beta2prev + sbeta2*N2 
      U = LyMass(Z1,A1,beta1) + LyMass(Z2,A2,beta2) + ECoul(Z1,A1,beta1,
     *Z2,A2,beta2,d) 
      IF (  U .LT. Ubest  ) THEN 
      Ubest = U 
      beta1opt = beta1 
      beta2opt = beta2 
      Nopt = N 
      END IF 
      END DO 
      IF (  N-Nopt .GT. 2  )  Exit 
      END DO 
C     ' 
C     ' 
      END
C     ' 
      REAL*4 FUNCTION U_Ired(Z,A)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
C     ' Effective moment of inertia by pairing and shell effect 
      REAL*4  I_rigid_spher,IfragEff
      REAL*4 U_SHELL 
C     ' 
      I_rigid_spher = 1.16E0**2 * A**1.6667E0 / 103.8415E0 
      IfragEff = I_rigid_spher + 0.003 * A**(4.0/3.0) * U_shell(NINT(Z),
     *NINT(A)) 
C     ' reduction due to shell (Deleplanque et al. PRC 69 (2004) 044309) 
      IfragEff = 0.45 * IfragEff 
C     ' Effect of superfluidity 
C     '  IfragEff = 0.65 * IfragEff   ' Average effect of superfluidity and deformation 
      U_Ired = IfragEff 
      END
C     ' 
      REAL*4 FUNCTION U_alev(Z,A)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
C     '  U_alev = 0.073 * A + 0.095 * A^0.666667  'Ignatyuk (1970's) 
      U_alev = 0.078 * A + 0.115 * A**0.6666667 
C     ' Ignatyuk (Bologna 2000) 
C     '  U_alev = 0.089 * A    ' only volume term 
      END
C     ' 
      REAL*4 FUNCTION U_Temp(Z,A,E,Ishell,Ipair,Tscale,Econd)
      IMPLICIT NONE
      REAL*4 Z
      REAL*4 A
      REAL*4 E
      INTEGER*4 Ishell
      INTEGER*4 Ipair
      REAL*4 Tscale
      REAL*4 Econd
C     ' Temperature (modified Gilbert-Cameron composite level density) 
C     ' KHS (10. 2. 2012) 
      REAL*4  alev
      REAL*4  Eeff0,Eeff1,Rho0,Rho1,TCT,TFG
      REAL*4  fgamma
      DATA fgamma/0.055/
      REAL*4  RShell,RPair,Res
      REAL*4 U_ALEV 
      REAL*4 U_SHELL 
      REAL*4 LYPAIR 
      REAL*4 TEGIDY 
C     ' Used global parameters: Tscale 
C     '  alev = U_alev(Z,A) * 1.1   ' Factor adjusted to high-energy prompt neutrons in U235(nth,f) 
C     '  alev = U_alev(Z,A) * 0.86  ' " with the correction for non-constant T (FG range) 
      alev = U_alev(Z,A) 
C     ' 
      IF (  Ishell .EQ. 1  ) THEN 
      RShell = U_Shell(NINT(Z),NINT(A)) 
      Else 
      RShell = 0.0 
      End If 
      TCT = TEgidy(A,RShell,Tscale) 
C     ' 
      IF (  Ipair .EQ. 1  ) THEN 
      RPair = Lypair(NINT(Z),NINT(A)) 
      Else 
      Rpair = 0.0 
      End If 
      Eeff0 = E - Econd + RPair + Rshell*(1.0 - exp(-fgamma * E)) 
C     ' 
      IF (  Eeff0 .GT. 0.5  ) THEN 
      Eeff1 = Eeff0 + 0.1 
      Rho0 = 1.E0/Eeff0**1.25 * exp(2.E0 * SQRT(alev * Eeff0)) 
      Rho1 = 1.E0/Eeff1**1.25 * exp(2.E0 * SQRT(alev * Eeff1)) 
C     '         Rho0 = 1.E0/Eeff0 * exp(2.E0 * sqr(alev * Eeff0)) 
C     '         Rho1 = 1.E0/Eeff1 * exp(2.E0 * sqr(alev * Eeff1)) 
      TFG = 0.1E0 / (log(Rho1) - log(Rho0)) 
      Else 
      TFG = 0.0 
      End If 
      Res = TCT 
      IF (  TFG .GT. Res  )  Res = TFG 
C     ' 
C     ' If Res > 1.4 Then Res = 1.4 
C     ' 
      U_Temp = Res 
      END
C     ' 
      REAL*4 FUNCTION U_Even_Odd(I_Channel,PEO)
      IMPLICIT NONE
      INTEGER*4 I_Channel
      REAL*4 PEO
C     ' Creates even-odd fluctuations 
      REAL*4  R
      IF (   MOD(I_Channel,2)  .EQ. 0  ) THEN 
      R = 1.0 + PEO 
      Else 
      R = 1.0 - PEO 
      End If 
      U_Even_Odd = R 
      END
C     ' 
C     ' 
      REAL*4 FUNCTION BFTF(RZ,RA,I_Switch)
      IMPLICIT NONE
      REAL*4 RZ
      REAL*4 RA
      INTEGER*4 I_Switch
C     /' Fission barriers from Myers and Swiatecki,Thomas-Fermi model '/ 
C     /'  I_Switch: 0: liquid-drop; 1: with shells '/ 
      REAL*4  RN,RI,Rkappa,RS,RF,RX
      REAL*4  RX0
      DATA RX0/48.5428/
      REAL*4  RX1
      DATA RX1/34.15/
      REAL*4  RB
      REAL*4 U_SHELL 
      REAL*4 U_SHELL_EXP 
C     ' 
      RN = RA - RZ 
      RI = (RN-RZ) / RA 
      Rkappa = 1.9E0 + (RZ - 80.E0) / 75.E0 
      RS = RA**0.666667E0 * (1.E0 - Rkappa * RI**2) 
      RX = RZ**2 / (RA * (1.E0 - Rkappa * RI**2)) 
      IF (  RX .LT. 30  ) THEN 
C     /' out of range '/ 
      RF = 1.E10 
      End If 
      IF (  RX .GT. RX0  ) THEN 
C     /' out of range '/ 
      RF = 0.0 
      End If 
      IF (  RX .LT. RX1 .AND. RX .GT. 30  ) THEN 
      RF = 0.595553E0 - 0.124136E0 * (RX - RX1) 
      End If 
      IF (  RX .GE. RX1 .AND. RX .LE. RX0  ) THEN 
      RF = 0.000199749 * (RX0 - RX)**3 
      End If 
      RB = RF * RS 
C     ' 
      IF (  I_Switch .EQ. 0  ) THEN 
      BFTF = RB 
      Else 
C     ' Tentative modification from comparison with experimental fission barriers 
C     ' (shell correction at the barrier?) 
      IF (  RZ .GT. 86.5  )  RB = RB - 0.15 * (RZ - 86.5) 
      IF (  RZ .GT. 90  )  RB = RB + 0.3 * (RZ - 90.0) 
      IF (  RZ .GT. 98  )  RB = RB - 0.15 * (RZ - 98.0) 
C     ' 
C     '    BFTF = RB - U_Shell(Cint(RZ),Cint(RA)) 
      BFTF = RB - U_Shell_exp(NINT(RZ),NINT(RA)) 
      End If 
      END
C     ' 
      REAL*4 FUNCTION BFTFA(RZ,RA,I_Switch)
      IMPLICIT NONE
      REAL*4 RZ
      REAL*4 RA
      INTEGER*4 I_Switch
C     /' inner barrier height '/ 
      REAL*4  EA,BF0,Z4A,Z3A,DB
      REAL*4  coeff
      DATA coeff/0.5/
      REAL*4 BFTF 
      BF0 = BFTF(RZ,RA,I_Switch) 
C     ' Z4A = RZ^4 / RA 
C     '  EB - EA from fit to Smirenkin barriers: 
C     '  V. M. Kupriyanov,K. K. Istekov,B. I. Fursov,G. N. Smirenkin 
C     '  Sov. J. Nucl. Phys. 32 (1980) 184 
C     '  DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB 
C     ' 
C     '  EB - EA from fit to data from Dahlinger et al. (KHS,21. Dec. 2012) 
      Z3A = RZ**3 / RA 
      DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A**2) 
      IF (  DB .GT. 0.0  ) THEN 
      EA = BF0 - DB 
      Else 
      EA = BF0 
      End If 
      BFTFA = EA 
      END
C     ' 
      REAL*4 FUNCTION BFTFB(RZ,RA,I_Switch)
      IMPLICIT NONE
      REAL*4 RZ
      REAL*4 RA
      INTEGER*4 I_Switch
C     /' outer barrier height '/ 
      REAL*4  EB,BF0,Z4A,Z3A,DB
      REAL*4  coeff
      DATA coeff/0.5/
      REAL*4 BFTF 
      BF0 = BFTF(RZ,RA,I_Switch) 
C     ' Z4A = RZ^4 / RA 
C     '  EB - EA from fit to Smirenkin barriers: 
C     '  V. M. Kupriyanov,K. K. Istekov,B. I. Fursov,G. N. Smirenkin 
C     '  Sov. J. Nucl. Phys. 32 (1980) 184 
C     '   DB = -10.3517 + 1.6027E-5 * Z4A + 5.4945E-11 * Z4A^2  ' EA - EB 
C     ' 
C     '  EB - EA from fit to data from Dahlinger et al. (KHS,21. Dec. 2012) 
      Z3A = RZ**3 / RA 
      DB = -(5.40101 - 0.00666175*Z3A + 1.52531E-6*Z3A**2) 
      IF (  DB .LT. 0.0  ) THEN 
      EB = BF0 + DB 
      Else 
      EB = BF0 
      End If 
      BFTFB = EB 
      END
C     ' 
C     ' 
C     ' 
C     /' Utility functions '/ 
C     ' 
C     ' 
      REAL*4 FUNCTION Gaussintegral(R_x,R_sigma)
      IMPLICIT NONE
      REAL*4 R_x
      REAL*4 R_sigma
C     /' Smoothed step function. Grows from 0 to 1 around R_x 
C     with a Gauss-integral function with given sigma'/ 
      REAL*4  R_ret
C     ' Note: The variable R_sigma = standard deviation / sqr(2) ! 
      REAL*4 ERF 
      R_ret = 0.5E0 + 0.5E0 * Erf(R_x / R_sigma) 
      Gaussintegral = R_ret 
      END
C     ' 
      REAL*4 FUNCTION U_Box(x,sigma,length)
      IMPLICIT NONE
      REAL*4 x
      REAL*4 sigma
      REAL*4 length
      REAL*4  y
C     ' Note: The variable sigma = standard deviation / sqr(2) ! 
      REAL*4 GAUSSINTEGRAL 
      y = Gaussintegral(x+0.5*length,sigma) - 
     *Gaussintegral(x-0.5*length,sigma) 
      U_Box = y/length 
      END
C     ' 
      REAL*4 FUNCTION U_Gauss(x,sigma)
      IMPLICIT NONE
      REAL*4 x
      REAL*4 sigma
      REAL*4  y
      REAL*4  pi
      PARAMETER (pi=3.14159)
C     ' 
      y = 1.0 / (SQRT(2.0 * pi) * sigma) * exp(-x**2/ ( 2.0 * sigma**2 
     *) ) 
      U_Gauss = y 
      END
C     ' 
      REAL*4 FUNCTION U_LinGauss(x,R_Sigma)
      IMPLICIT NONE
      REAL*4 x
      REAL*4 R_Sigma
C     /' Gaussian times a linear function '/ 
C     /' Not normalized! '/ 
      REAL*4  R_Res
      IF (  R_Sigma .GT. 0.0  ) THEN 
      R_Res = x * exp(-x**2/(2.0 * R_Sigma**2)) 
      Else 
      R_Res = 0.0 
      End If 
      U_LinGauss = R_Res 
      END
